"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSchemasTask = generateSchemasTask;

var _manage_schema = require("../manage_schema");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function generateSchemasTask({
  roots
}) {
  return roots.map(root => ({
    task: () => {
      if (!root.parsedCollections || !root.parsedCollections.length) {
        return;
      }

      const mapping = (0, _manage_schema.generateMapping)(root.parsedCollections);
      root.mapping = mapping;
    },
    title: `Generating mapping for ${root.config.root}`
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy90b29scy90YXNrcy9nZW5lcmF0ZV9zY2hlbWFzX3Rhc2sudHMiXSwibmFtZXMiOlsiZ2VuZXJhdGVTY2hlbWFzVGFzayIsInJvb3RzIiwibWFwIiwicm9vdCIsInRhc2siLCJwYXJzZWRDb2xsZWN0aW9ucyIsImxlbmd0aCIsIm1hcHBpbmciLCJ0aXRsZSIsImNvbmZpZyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQW9CQTs7QUFwQkE7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQXNCTyxTQUFTQSxtQkFBVCxDQUE2QjtBQUFFQyxFQUFBQTtBQUFGLENBQTdCLEVBQXFEO0FBQzFELFNBQU9BLEtBQUssQ0FBQ0MsR0FBTixDQUFXQyxJQUFELEtBQVc7QUFDMUJDLElBQUFBLElBQUksRUFBRSxNQUFNO0FBQ1YsVUFBSSxDQUFDRCxJQUFJLENBQUNFLGlCQUFOLElBQTJCLENBQUNGLElBQUksQ0FBQ0UsaUJBQUwsQ0FBdUJDLE1BQXZELEVBQStEO0FBQzdEO0FBQ0Q7O0FBQ0QsWUFBTUMsT0FBTyxHQUFHLG9DQUFnQkosSUFBSSxDQUFDRSxpQkFBckIsQ0FBaEI7QUFDQUYsTUFBQUEsSUFBSSxDQUFDSSxPQUFMLEdBQWVBLE9BQWY7QUFDRCxLQVB5QjtBQVExQkMsSUFBQUEsS0FBSyxFQUFHLDBCQUF5QkwsSUFBSSxDQUFDTSxNQUFMLENBQVlOLElBQUs7QUFSeEIsR0FBWCxDQUFWLENBQVA7QUFVRCIsInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBMaWNlbnNlZCB0byBFbGFzdGljc2VhcmNoIEIuVi4gdW5kZXIgb25lIG9yIG1vcmUgY29udHJpYnV0b3JcbiAqIGxpY2Vuc2UgYWdyZWVtZW50cy4gU2VlIHRoZSBOT1RJQ0UgZmlsZSBkaXN0cmlidXRlZCB3aXRoXG4gKiB0aGlzIHdvcmsgZm9yIGFkZGl0aW9uYWwgaW5mb3JtYXRpb24gcmVnYXJkaW5nIGNvcHlyaWdodFxuICogb3duZXJzaGlwLiBFbGFzdGljc2VhcmNoIEIuVi4gbGljZW5zZXMgdGhpcyBmaWxlIHRvIHlvdSB1bmRlclxuICogdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTsgeW91IG1heVxuICogbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZyxcbiAqIHNvZnR3YXJlIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuXG4gKiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWVxuICogS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlXG4gKiBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kIGxpbWl0YXRpb25zXG4gKiB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5pbXBvcnQgeyBUYXNrQ29udGV4dCB9IGZyb20gJy4vdGFza19jb250ZXh0JztcbmltcG9ydCB7IGdlbmVyYXRlTWFwcGluZyB9IGZyb20gJy4uL21hbmFnZV9zY2hlbWEnO1xuXG5leHBvcnQgZnVuY3Rpb24gZ2VuZXJhdGVTY2hlbWFzVGFzayh7IHJvb3RzIH06IFRhc2tDb250ZXh0KSB7XG4gIHJldHVybiByb290cy5tYXAoKHJvb3QpID0+ICh7XG4gICAgdGFzazogKCkgPT4ge1xuICAgICAgaWYgKCFyb290LnBhcnNlZENvbGxlY3Rpb25zIHx8ICFyb290LnBhcnNlZENvbGxlY3Rpb25zLmxlbmd0aCkge1xuICAgICAgICByZXR1cm47XG4gICAgICB9XG4gICAgICBjb25zdCBtYXBwaW5nID0gZ2VuZXJhdGVNYXBwaW5nKHJvb3QucGFyc2VkQ29sbGVjdGlvbnMpO1xuICAgICAgcm9vdC5tYXBwaW5nID0gbWFwcGluZztcbiAgICB9LFxuICAgIHRpdGxlOiBgR2VuZXJhdGluZyBtYXBwaW5nIGZvciAke3Jvb3QuY29uZmlnLnJvb3R9YCxcbiAgfSkpO1xufVxuIl19