"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBadgeGroup = exports.GUTTER_SIZES = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../../common");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var gutterSizeToClassNameMap = {
  none: null,
  xs: 'euiBadgeGroup--gutterExtraSmall',
  s: 'euiBadgeGroup--gutterSmall'
};
var GUTTER_SIZES = (0, _common.keysOf)(gutterSizeToClassNameMap);
exports.GUTTER_SIZES = GUTTER_SIZES;

var EuiBadgeGroup = _react.default.forwardRef(function (_ref, ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'xs' : _ref$gutterSize,
      rest = _objectWithoutProperties(_ref, ["children", "className", "gutterSize"]);

  var classes = (0, _classnames.default)('euiBadgeGroup', gutterSizeToClassNameMap[gutterSize], className);
  return _react.default.createElement("div", _extends({
    className: classes,
    ref: ref
  }, rest), _react.default.Children.map(children, function (child) {
    return _react.default.createElement("span", {
      className: "euiBadgeGroup__item"
    }, child);
  }));
});

exports.EuiBadgeGroup = EuiBadgeGroup;
EuiBadgeGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Space between badges
     */
  gutterSize: _propTypes.default.oneOf(["none", "xs", "s"]),

  /**
     * Should be a list of EuiBadge's but can also be any other element
     * Will apply an extra class to add spacing
     */
  children: _propTypes.default.node
};
EuiBadgeGroup.displayName = 'EuiBadgeGroup';
EuiBadgeGroup.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiBadgeGroup",
  "props": {
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "gutterSize": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"none\"",
          "computed": false
        }, {
          "value": "\"xs\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Space between badges"
    },
    "children": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "Should be a list of EuiBadge's but can also be any other element\nWill apply an extra class to add spacing"
    }
  }
};