function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useState, useEffect, Fragment, useMemo, useRef } from 'react';
import classNames from 'classnames';
import tabbable from 'tabbable';
import { EuiI18n } from '../i18n';
import { EuiDataGridHeaderRow } from './data_grid_header_row';
import { EuiButtonEmpty } from '../button';
import { keys, htmlIdGenerator } from '../../services';
import { EuiDataGridBody } from './data_grid_body';
import { useColumnSelector } from './column_selector';
import { useStyleSelector, startingStyles } from './style_selector';
import { EuiTablePagination } from '../table/table_pagination';
import { EuiFocusTrap } from '../focus_trap';
import { EuiResizeObserver } from '../observer/resize_observer';
import { EuiDataGridInMemoryRenderer } from './data_grid_inmemory_renderer';
import { useMergedSchema, useDetectSchema, schemaDetectors as providedSchemaDetectors } from './data_grid_schema';
import { useColumnSorting } from './column_sorting';
import { EuiMutationObserver } from '../observer/mutation_observer';
import { DataGridContext } from './data_grid_context';
import { useResizeObserver } from '../observer/resize_observer/resize_observer'; // Used to short-circuit some async browser behaviour that is difficult to account for in tests

var IS_JEST_ENVIRONMENT = global.hasOwnProperty('_isJest'); // When below this number the grid only shows the full screen button

var MINIMUM_WIDTH_FOR_GRID_CONTROLS = 479;
// Each gridStyle object above sets a specific CSS select to .euiGrid
var fontSizesToClassMap = {
  s: 'euiDataGrid--fontSizeSmall',
  m: '',
  l: 'euiDataGrid--fontSizeLarge'
};
var headerToClassMap = {
  shade: 'euiDataGrid--headerShade',
  underline: 'euiDataGrid--headerUnderline'
};
var rowHoverToClassMap = {
  highlight: 'euiDataGrid--rowHoverHighlight',
  none: ''
};
var bordersToClassMap = {
  all: 'euiDataGrid--bordersAll',
  horizontal: 'euiDataGrid--bordersHorizontal',
  none: 'euiDataGrid--bordersNone'
};
var cellPaddingsToClassMap = {
  s: 'euiDataGrid--paddingSmall',
  m: '',
  l: 'euiDataGrid--paddingLarge'
};

function computeVisibleRows(props) {
  var pagination = props.pagination,
      rowCount = props.rowCount;
  var startRow = pagination ? pagination.pageIndex * pagination.pageSize : 0;
  var endRow = pagination ? (pagination.pageIndex + 1) * pagination.pageSize : rowCount;
  endRow = Math.min(endRow, rowCount);
  return endRow - startRow;
}

function renderPagination(props, controls) {
  var pagination = props.pagination;

  if (pagination == null) {
    return null;
  }

  var pageIndex = pagination.pageIndex,
      pageSize = pagination.pageSize,
      pageSizeOptions = pagination.pageSizeOptions,
      onChangePage = pagination.onChangePage,
      onChangeItemsPerPage = pagination.onChangeItemsPerPage;
  var pageCount = Math.ceil(props.rowCount / pageSize);

  if (props.rowCount < pageSizeOptions[0]) {
    return null;
  }

  return React.createElement(EuiI18n, {
    token: "euiDataGrid.ariaLabelGridPagination",
    default: "Pagination for preceding grid: {label}",
    values: {
      label: props['aria-label']
    }
  }, function (ariaLabelGridPagination) {
    return React.createElement(EuiI18n, {
      token: "euiDataGrid.ariaLabelledByGridPagination",
      default: "Pagination for preceding grid"
    }, function (ariaLabelledByGridPagination) {
      var accessibleName = _objectSpread({}, props['aria-label'] && {
        'aria-label': ariaLabelGridPagination
      }, {}, props['aria-labelledby'] && {
        'aria-labelledby': ariaLabelledByGridPagination
      });

      return React.createElement("div", {
        className: "euiDataGrid__pagination"
      }, React.createElement(EuiTablePagination, _extends({
        "aria-controls": controls,
        activePage: pageIndex,
        itemsPerPage: pageSize,
        itemsPerPageOptions: pageSizeOptions,
        pageCount: pageCount,
        onChangePage: onChangePage,
        onChangeItemsPerPage: onChangeItemsPerPage
      }, accessibleName)));
    });
  });
}

function useDefaultColumnWidth(container, leadingControlColumns, trailingControlColumns, columns) {
  var containerSize = useResizeObserver(container, 'width');
  var gridWidth = containerSize.width;
  var computeDefaultWidth = useCallback(function () {
    if (IS_JEST_ENVIRONMENT) return 100;
    if (gridWidth === 0) return null; // we can't tell what size to compute yet

    var controlColumnWidths = [].concat(_toConsumableArray(leadingControlColumns), _toConsumableArray(trailingControlColumns)).reduce(function (claimedWidth, controlColumn) {
      return claimedWidth + controlColumn.width;
    }, 0);
    var columnsWithWidths = columns.filter(doesColumnHaveAnInitialWidth);
    var definedColumnsWidth = columnsWithWidths.reduce(function (claimedWidth, column) {
      return claimedWidth + column.initialWidth;
    }, 0);
    var claimedWidth = controlColumnWidths + definedColumnsWidth;
    var widthToFill = gridWidth - claimedWidth;
    var unsizedColumnCount = columns.length - columnsWithWidths.length;
    return Math.max(widthToFill / unsizedColumnCount, 100);
  }, [gridWidth, columns, leadingControlColumns, trailingControlColumns]);

  var _useState = useState(computeDefaultWidth),
      _useState2 = _slicedToArray(_useState, 2),
      defaultColumnWidth = _useState2[0],
      setDefaultColumnWidth = _useState2[1];

  useEffect(function () {
    var columnWidth = computeDefaultWidth();
    setDefaultColumnWidth(columnWidth);
  }, [computeDefaultWidth]);
  return defaultColumnWidth;
}

function doesColumnHaveAnInitialWidth(column) {
  return column.hasOwnProperty('initialWidth');
}

function useColumnWidths(columns, onColumnResize) {
  var hasMounted = useRef(false);
  var computeColumnWidths = useCallback(function () {
    return columns.filter(doesColumnHaveAnInitialWidth).reduce(function (initialWidths, column) {
      initialWidths[column.id] = column.initialWidth;
      return initialWidths;
    }, {});
  }, [columns]);

  var _useState3 = useState(computeColumnWidths),
      _useState4 = _slicedToArray(_useState3, 2),
      columnWidths = _useState4[0],
      setColumnWidths = _useState4[1];

  useEffect(function () {
    if (!hasMounted.current) {
      hasMounted.current = true;
      return;
    }

    setColumnWidths(computeColumnWidths());
  }, [computeColumnWidths]);

  var setColumnWidth = function setColumnWidth(columnId, width) {
    setColumnWidths(_objectSpread({}, columnWidths, _defineProperty({}, columnId, width)));

    if (onColumnResize) {
      onColumnResize({
        columnId: columnId,
        width: width
      });
    }
  };

  return [columnWidths, setColumnWidth];
}

function useOnResize(setHasRoomForGridControls, isFullScreen, minSizeForControls) {
  return useCallback(function (_ref) {
    var width = _ref.width;
    setHasRoomForGridControls(width > minSizeForControls || isFullScreen);
  }, [setHasRoomForGridControls, isFullScreen, minSizeForControls]);
}

function useInMemoryValues(inMemory, rowCount) {
  /**
   * For performance, `onCellRender` below mutates the inMemoryValues object
   * instead of cloning. If this operation were done in a setState call
   * React would ignore the update as the object itself has not changed.
   * So, we keep a dual record: the in-memory values themselves and a "version" counter.
   * When the object is mutated, the version is incremented triggering a re-render, and
   * the returned `inMemoryValues` object is re-created (cloned) from the mutated version.
   * The version updates are batched, so only one clone happens per batch.
   **/
  var _inMemoryValues = useRef({});

  var _useState5 = useState(0),
      _useState6 = _slicedToArray(_useState5, 2),
      inMemoryValuesVersion = _useState6[0],
      setInMemoryValuesVersion = _useState6[1]; // eslint-disable-next-line react-hooks/exhaustive-deps


  var inMemoryValues = useMemo(function () {
    return _objectSpread({}, _inMemoryValues.current);
  }, [inMemoryValuesVersion]);
  var onCellRender = useCallback(function (rowIndex, columnId, value) {
    var nextInMemoryValues = _inMemoryValues.current;
    nextInMemoryValues[rowIndex] = nextInMemoryValues[rowIndex] || {};
    nextInMemoryValues[rowIndex][columnId] = value;
    setInMemoryValuesVersion(function (version) {
      return version + 1;
    });
  }, []); // if `inMemory.level` or `rowCount` changes reset the values

  var inMemoryLevel = inMemory && inMemory.level;
  var resetRunCount = useRef(0);
  useEffect(function () {
    if (resetRunCount.current++ > 0) {
      // this has to delete "overflow" keys from the object instead of resetting to an empty one,
      // as the internal inmemoryrenderer component's useEffect which sets the values
      // exectues before this outer, wrapping useEffect
      var existingRowKeyCount = Object.keys(_inMemoryValues.current).length;

      for (var i = rowCount; i < existingRowKeyCount; i++) {
        delete _inMemoryValues.current[i];
      }

      setInMemoryValuesVersion(function (version) {
        return version + 1;
      });
    }
  }, [inMemoryLevel, rowCount]);
  return [inMemoryValues, onCellRender];
}

function createKeyDownHandler(props, visibleColumns, leadingControlColumns, trailingControlColumns, focusedCell, headerIsInteractive, setFocusedCell, updateFocus) {
  return function (event) {
    if (focusedCell == null) return;
    var colCount = visibleColumns.length + leadingControlColumns.length + trailingControlColumns.length - 1;

    var _focusedCell = _slicedToArray(focusedCell, 2),
        x = _focusedCell[0],
        y = _focusedCell[1];

    var rowCount = computeVisibleRows(props);
    var key = event.key,
        ctrlKey = event.ctrlKey;

    if (key === keys.ARROW_DOWN) {
      event.preventDefault();

      if (y < rowCount - 1) {
        setFocusedCell([x, y + 1]);
      }
    } else if (key === keys.ARROW_LEFT) {
      event.preventDefault();

      if (x > 0) {
        setFocusedCell([x - 1, y]);
      }
    } else if (key === keys.ARROW_UP) {
      event.preventDefault();
      var minimumIndex = headerIsInteractive ? -1 : 0;

      if (y > minimumIndex) {
        setFocusedCell([x, y - 1]);
      }
    } else if (key === keys.ARROW_RIGHT) {
      event.preventDefault();

      if (x < colCount) {
        setFocusedCell([x + 1, y]);
      }
    } else if (key === keys.PAGE_DOWN) {
      if (props.pagination) {
        event.preventDefault();
        var _rowCount = props.rowCount;
        var pageIndex = props.pagination.pageIndex;
        var pageSize = props.pagination.pageSize;
        var pageCount = Math.ceil(_rowCount / pageSize);

        if (pageIndex < pageCount - 1) {
          props.pagination.onChangePage(pageIndex + 1);
        }

        setFocusedCell([focusedCell[0], 0]);
        updateFocus();
      }
    } else if (key === keys.PAGE_UP) {
      if (props.pagination) {
        event.preventDefault();
        var _pageIndex = props.pagination.pageIndex;

        if (_pageIndex > 0) {
          props.pagination.onChangePage(_pageIndex - 1);
        }

        setFocusedCell([focusedCell[0], props.pagination.pageSize - 1]);
        updateFocus();
      }
    } else if (key === (ctrlKey && keys.END)) {
      event.preventDefault();
      setFocusedCell([colCount, rowCount - 1]);
    } else if (key === (ctrlKey && keys.HOME)) {
      event.preventDefault();
      setFocusedCell([0, 0]);
    } else if (key === keys.END) {
      event.preventDefault();
      setFocusedCell([colCount, y]);
    } else if (key === keys.HOME) {
      event.preventDefault();
      setFocusedCell([0, y]);
    }
  };
}

function useAfterRender(fn) {
  var _useState7 = useState(false),
      _useState8 = _slicedToArray(_useState7, 2),
      isSubscribed = _useState8[0],
      setIsSubscribed = _useState8[1];

  var _useState9 = useState(false),
      _useState10 = _slicedToArray(_useState9, 2),
      needsExecution = _useState10[0],
      setNeedsExecution = _useState10[1]; // first useEffect waits for the parent & children to render & flush to dom


  useEffect(function () {
    if (isSubscribed) {
      setIsSubscribed(false);
      setNeedsExecution(true);
    }
  }, [isSubscribed, setIsSubscribed, setNeedsExecution]); // second useEffect allows for a new `fn` to have been created
  // with any state updates before being called

  useEffect(function () {
    if (needsExecution) {
      setNeedsExecution(false);
      fn();
    }
  }, [needsExecution, setNeedsExecution, fn]);
  return function () {
    setIsSubscribed(true);
  };
}

var useFocus = function useFocus(headerIsInteractive) {
  var _useState11 = useState(undefined),
      _useState12 = _slicedToArray(_useState11, 2),
      focusedCell = _useState12[0],
      setFocusedCell = _useState12[1];

  var hasHadFocus = useMemo(function () {
    return focusedCell != null;
  }, [focusedCell]);
  var focusProps = useMemo(function () {
    return hasHadFocus ? {
      // FireFox allows tabbing to a div that is scrollable, while Chrome does not
      tabIndex: -1
    } : {
      tabIndex: 0,
      onFocus: function onFocus(e) {
        // if e.target (the source element of the `focus event`
        // matches e.currentTarget (always the div with this onFocus listener)
        // then the user has focused directly on the data grid wrapper (almost definitely by tabbing)
        // so shift focus to the first interactive cell within the grid
        if (e.target === e.currentTarget) {
          setFocusedCell(headerIsInteractive ? [0, -1] : [0, 0]);
        }
      }
    };
  }, [hasHadFocus, setFocusedCell, headerIsInteractive]);
  return [focusProps, focusedCell, setFocusedCell];
}; // Typeguards to see if toolbarVisibility has a certain boolean property assigned
// If not, just set it to true and assume it's OK to show


function objectHasKey(object, key) {
  return object.hasOwnProperty(key);
}

function checkOrDefaultToolBarDiplayOptions(arg, option) {
  if (arg === undefined) {
    return true;
  } else if (typeof arg === 'boolean') {
    return arg;
  } else if (objectHasKey(arg, option)) {
    return arg[option];
  } else {
    return true;
  }
}

var emptyArrayDefault = [];
export var EuiDataGrid = function EuiDataGrid(props) {
  var _useState13 = useState(false),
      _useState14 = _slicedToArray(_useState13, 2),
      isFullScreen = _useState14[0],
      setIsFullScreen = _useState14[1];

  var _useState15 = useState(true),
      _useState16 = _slicedToArray(_useState15, 2),
      hasRoomForGridControls = _useState16[0],
      setHasRoomForGridControls = _useState16[1];

  var _useState17 = useState(null),
      _useState18 = _slicedToArray(_useState17, 2),
      containerRef = _useState18[0],
      _setContainerRef = _useState18[1];

  var _useState19 = useState(htmlIdGenerator()()),
      _useState20 = _slicedToArray(_useState19, 1),
      interactiveCellId = _useState20[0];

  var _useState21 = useState(false),
      _useState22 = _slicedToArray(_useState21, 2),
      headerIsInteractive = _useState22[0],
      setHeaderIsInteractive = _useState22[1];

  var setContainerRef = useCallback(function (ref) {
    return _setContainerRef(ref);
  }, []);

  var _useFocus = useFocus(headerIsInteractive),
      _useFocus2 = _slicedToArray(_useFocus, 3),
      wrappingDivFocusProps = _useFocus2[0],
      focusedCell = _useFocus2[1],
      setFocusedCell = _useFocus2[2];

  var handleHeaderChange = useCallback(function (records) {
    var _records = _slicedToArray(records, 1),
        target = _records[0].target; // find the wrapping header div


    var headerRow = target.parentElement;

    while (headerRow && (headerRow.getAttribute('data-test-subj') || '').indexOf('dataGridHeader') === -1) {
      headerRow = headerRow.parentElement;
    }

    if (headerRow) {
      var tabbables = tabbable(headerRow);
      var managed = headerRow.querySelectorAll('[data-euigrid-tab-managed]');
      var hasInteractives = tabbables.length > 0 || managed.length > 0;

      if (hasInteractives !== headerIsInteractive) {
        setHeaderIsInteractive(hasInteractives); // if the focus is on the header, and the header is no longer interactive
        // move the focus down to the first row

        if (hasInteractives === false && focusedCell && focusedCell[1] === -1) {
          setFocusedCell([focusedCell[0], 0]);
        }
      }
    }
  }, [headerIsInteractive, setHeaderIsInteractive, focusedCell, setFocusedCell]);

  var handleGridKeyDown = function handleGridKeyDown(event) {
    switch (event.key) {
      case keys.ESCAPE:
        if (isFullScreen) {
          event.preventDefault();
          setIsFullScreen(false);
        }

        break;
    }
  };

  var _props$leadingControl = props.leadingControlColumns,
      leadingControlColumns = _props$leadingControl === void 0 ? emptyArrayDefault : _props$leadingControl,
      _props$trailingContro = props.trailingControlColumns,
      trailingControlColumns = _props$trailingContro === void 0 ? emptyArrayDefault : _props$trailingContro,
      columns = props.columns,
      columnVisibility = props.columnVisibility,
      schemaDetectors = props.schemaDetectors,
      rowCount = props.rowCount,
      renderCellValue = props.renderCellValue,
      className = props.className,
      gridStyle = props.gridStyle,
      _props$toolbarVisibil = props.toolbarVisibility,
      toolbarVisibility = _props$toolbarVisibil === void 0 ? true : _props$toolbarVisibil,
      pagination = props.pagination,
      sorting = props.sorting,
      inMemory = props.inMemory,
      popoverContents = props.popoverContents,
      onColumnResize = props.onColumnResize,
      _props$minSizeForCont = props.minSizeForControls,
      minSizeForControls = _props$minSizeForCont === void 0 ? MINIMUM_WIDTH_FOR_GRID_CONTROLS : _props$minSizeForCont,
      rest = _objectWithoutProperties(props, ["leadingControlColumns", "trailingControlColumns", "columns", "columnVisibility", "schemaDetectors", "rowCount", "renderCellValue", "className", "gridStyle", "toolbarVisibility", "pagination", "sorting", "inMemory", "popoverContents", "onColumnResize", "minSizeForControls"]); // enables/disables grid controls based on available width


  var onResize = useOnResize(function (nextHasRoomForGridControls) {
    if (nextHasRoomForGridControls !== hasRoomForGridControls) {
      setHasRoomForGridControls(nextHasRoomForGridControls);
    }
  }, isFullScreen, minSizeForControls);

  var _useColumnWidths = useColumnWidths(columns, onColumnResize),
      _useColumnWidths2 = _slicedToArray(_useColumnWidths, 2),
      columnWidths = _useColumnWidths2[0],
      setColumnWidth = _useColumnWidths2[1]; // apply style props on top of defaults


  var gridStyleWithDefaults = _objectSpread({}, startingStyles, {}, gridStyle);

  var _useInMemoryValues = useInMemoryValues(inMemory, rowCount),
      _useInMemoryValues2 = _slicedToArray(_useInMemoryValues, 2),
      inMemoryValues = _useInMemoryValues2[0],
      onCellRender = _useInMemoryValues2[1];

  var definedColumnSchemas = useMemo(function () {
    return columns.reduce(function (definedColumnSchemas, _ref2) {
      var id = _ref2.id,
          schema = _ref2.schema;

      if (schema != null) {
        definedColumnSchemas[id] = schema;
      }

      return definedColumnSchemas;
    }, {});
  }, [columns]);
  var allSchemaDetectors = useMemo(function () {
    return [].concat(_toConsumableArray(providedSchemaDetectors), _toConsumableArray(schemaDetectors || []));
  }, [schemaDetectors]);
  var detectedSchema = useDetectSchema(inMemory, inMemoryValues, allSchemaDetectors, definedColumnSchemas, inMemory != null);
  var mergedSchema = useMergedSchema(detectedSchema, columns);
  var displayValues = columns.reduce(function (acc, column) {
    return _objectSpread({}, acc, _defineProperty({}, column.id, column.displayAsText || column.id));
  }, {});

  var _useColumnSelector = useColumnSelector(columns, columnVisibility, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showColumnSelector'), displayValues),
      _useColumnSelector2 = _slicedToArray(_useColumnSelector, 2),
      columnSelector = _useColumnSelector2[0],
      orderedVisibleColumns = _useColumnSelector2[1];

  var columnSorting = useColumnSorting(orderedVisibleColumns, sorting, mergedSchema, allSchemaDetectors, displayValues);

  var _useStyleSelector = useStyleSelector(gridStyleWithDefaults),
      _useStyleSelector2 = _slicedToArray(_useStyleSelector, 2),
      styleSelector = _useStyleSelector2[0],
      gridStyles = _useStyleSelector2[1]; // compute the default column width from the container's clientWidth and count of visible columns


  var defaultColumnWidth = useDefaultColumnWidth(containerRef, leadingControlColumns, trailingControlColumns, orderedVisibleColumns);
  var contentRef = useRef(null); // Because of a weird Chrome bug with position:sticky css items and focus, we force scrolling to the top
  // if the item is in the first row. This prevents the cell from ever being under the sticky header.

  useEffect(function () {
    if (focusedCell !== undefined && focusedCell[1] === 0) {
      if (contentRef.current != null) {
        contentRef.current.scrollTop = 0;
      }
    }
  }, [focusedCell]);
  var classes = classNames('euiDataGrid', fontSizesToClassMap[gridStyles.fontSize], bordersToClassMap[gridStyles.border], headerToClassMap[gridStyles.header], rowHoverToClassMap[gridStyles.rowHover], cellPaddingsToClassMap[gridStyles.cellPadding], {
    'euiDataGrid--stripes': gridStyles.stripes
  }, {
    'euiDataGrid--fullScreen': isFullScreen
  }, {
    'euiDataGrid--noControls': !toolbarVisibility
  }, className);
  var controlBtnClasses = classNames('euiDataGrid__controlBtn', {
    'euiDataGrid__controlBtn--active': isFullScreen
  }, className); // By default the toolbar appears

  var showToolbar = !!toolbarVisibility; // These grid controls will only show when there is room. Check the resize observer callback
  // They can also be optionally turned off individually by using toolbarVisibility

  var gridControls = React.createElement(Fragment, null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'additionalControls') && typeof toolbarVisibility !== 'boolean' ? toolbarVisibility.additionalControls : null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showColumnSelector') ? columnSelector : null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showStyleSelector') ? styleSelector : null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showSortSelector') ? columnSorting : null); // When data grid is full screen, we add a class to the body to remove the extra scrollbar

  if (isFullScreen) {
    document.body.classList.add('euiDataGrid__restrictBody');
  } else {
    document.body.classList.remove('euiDataGrid__restrictBody');
  }

  var fullScreenSelector = React.createElement(EuiI18n, {
    tokens: ['euiDataGrid.fullScreenButton', 'euiDataGrid.fullScreenButtonActive'],
    defaults: ['Full screen', 'Exit full screen']
  }, function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        fullScreenButton = _ref4[0],
        fullScreenButtonActive = _ref4[1];

    return React.createElement(EuiButtonEmpty, {
      size: "xs",
      iconType: "fullScreen",
      color: "text",
      className: controlBtnClasses,
      "data-test-subj": "dataGridFullScrenButton",
      onClick: function onClick() {
        return setIsFullScreen(!isFullScreen);
      }
    }, isFullScreen ? fullScreenButtonActive : fullScreenButton);
  });
  var cellsUpdateFocus = useRef(new Map());
  var focusAfterRender = useAfterRender(function () {
    if (focusedCell) {
      var _key = "".concat(focusedCell[0], "-").concat(focusedCell[1]);

      if (cellsUpdateFocus.current.has(_key)) {
        cellsUpdateFocus.current.get(_key)();
      }
    }
  });
  var datagridContext = useMemo(function () {
    return {
      onFocusUpdate: function onFocusUpdate(cell, updateFocus) {
        if (pagination) {
          var _key2 = "".concat(cell[0], "-").concat(cell[1]);

          cellsUpdateFocus.current.set(_key2, updateFocus);
          return function () {
            cellsUpdateFocus.current.delete(_key2);
          };
        }
      }
    };
  }, [pagination]);
  var gridIds = htmlIdGenerator();
  var gridId = gridIds();
  var ariaLabelledById = gridIds();
  return React.createElement(EuiI18n, {
    token: "euiDataGrid.ariaLabel",
    default: "{label}; Page {page} of {pageCount}.",
    values: {
      label: rest['aria-label'],
      page: pagination ? pagination.pageIndex + 1 : 0,
      pageCount: pagination ? Math.ceil(props.rowCount / pagination.pageSize) : 0
    }
  }, function (ariaLabel) {
    return React.createElement(EuiI18n, {
      token: "euiDataGrid.ariaLabelledBy",
      default: "Page {page} of {pageCount}.",
      values: {
        page: pagination ? pagination.pageIndex + 1 : 0,
        pageCount: pagination ? Math.ceil(props.rowCount / pagination.pageSize) : 0
      }
    }, function (ariaLabelledBy) {
      // extract aria-label and/or aria-labelledby from `rest`
      var gridAriaProps = {};

      if ('aria-label' in rest) {
        gridAriaProps['aria-label'] = pagination ? ariaLabel : rest['aria-label'];
        delete rest['aria-label'];
      }

      if ('aria-labelledby' in rest) {
        gridAriaProps['aria-labelledby'] = "".concat(rest['aria-labelledby'], " ").concat(pagination ? ariaLabelledById : '');
        delete rest['aria-labelledby'];
      }

      return React.createElement(DataGridContext.Provider, {
        value: datagridContext
      }, React.createElement(EuiFocusTrap, {
        disabled: !isFullScreen,
        style: {
          height: '100%'
        }
      }, React.createElement("div", {
        className: classes,
        onKeyDown: handleGridKeyDown,
        ref: setContainerRef
      }, (IS_JEST_ENVIRONMENT || defaultColumnWidth) && React.createElement(React.Fragment, null, showToolbar ? React.createElement("div", {
        className: "euiDataGrid__controls",
        "data-test-sub": "dataGridControls"
      }, hasRoomForGridControls ? gridControls : null, checkOrDefaultToolBarDiplayOptions(toolbarVisibility, 'showFullScreenSelector') ? fullScreenSelector : null) : null, React.createElement(EuiResizeObserver, {
        onResize: onResize
      }, function (resizeRef) {
        return React.createElement("div", _extends({
          onKeyDown: createKeyDownHandler(props, orderedVisibleColumns, leadingControlColumns, trailingControlColumns, focusedCell, headerIsInteractive, setFocusedCell, focusAfterRender),
          className: "euiDataGrid__verticalScroll",
          ref: resizeRef
        }, rest), React.createElement("div", {
          className: "euiDataGrid__overflow"
        }, inMemory ? React.createElement(EuiDataGridInMemoryRenderer, {
          inMemory: inMemory,
          renderCellValue: renderCellValue,
          columns: columns,
          rowCount: inMemory.level === 'enhancements' ? // if `inMemory.level === enhancements` then we can only be sure the pagination's pageSize is available in memory
          pagination && pagination.pageSize || rowCount : // otherwise, all of the data is present and usable
          rowCount,
          onCellRender: onCellRender
        }) : null, React.createElement("div", _extends({
          ref: contentRef,
          "data-test-subj": "dataGridWrapper",
          className: "euiDataGrid__content",
          role: "grid",
          id: gridId
        }, wrappingDivFocusProps, gridAriaProps), React.createElement(EuiMutationObserver, {
          observerOptions: {
            subtree: true,
            childList: true
          },
          onMutation: handleHeaderChange
        }, function (ref) {
          return React.createElement(EuiDataGridHeaderRow, {
            ref: ref,
            leadingControlColumns: leadingControlColumns,
            trailingControlColumns: trailingControlColumns,
            columns: orderedVisibleColumns,
            columnWidths: columnWidths,
            defaultColumnWidth: defaultColumnWidth,
            setColumnWidth: setColumnWidth,
            schema: mergedSchema,
            sorting: sorting,
            headerIsInteractive: headerIsInteractive,
            focusedCell: focusedCell,
            setFocusedCell: setFocusedCell
          });
        }), React.createElement(EuiDataGridBody, {
          columnWidths: columnWidths,
          defaultColumnWidth: defaultColumnWidth,
          inMemoryValues: inMemoryValues,
          inMemory: inMemory,
          leadingControlColumns: leadingControlColumns,
          trailingControlColumns: trailingControlColumns,
          columns: orderedVisibleColumns,
          schema: mergedSchema,
          schemaDetectors: allSchemaDetectors,
          popoverContents: popoverContents,
          focusedCell: focusedCell,
          onCellFocus: setFocusedCell,
          pagination: pagination,
          sorting: sorting,
          renderCellValue: renderCellValue,
          rowCount: rowCount,
          interactiveCellId: interactiveCellId
        }))));
      }), props.pagination && props['aria-labelledby'] && React.createElement("p", {
        id: ariaLabelledBy,
        hidden: true
      }, ariaLabelledBy), renderPagination(props, gridId), React.createElement("p", {
        id: interactiveCellId,
        hidden: true
      }, React.createElement(EuiI18n, {
        token: "euiDataGrid.screenReaderNotice",
        default: "Cell contains interactive content."
      }))))));
    });
  });
};
EuiDataGrid.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiDataGrid"
};