"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importStar(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var uuid_1 = __importDefault(require("uuid"));
var axis_type_utils_1 = require("../chart_types/xy_chart/utils/axis_type_utils");
var specs_parser_1 = require("../specs/specs_parser");
var events_1 = require("../state/actions/events");
var chart_state_1 = require("../state/chart_state");
var get_internal_is_intialized_1 = require("../state/selectors/get_internal_is_intialized");
var get_settings_specs_1 = require("../state/selectors/get_settings_specs");
var chart_size_1 = require("../utils/chart_size");
var commons_1 = require("../utils/commons");
var chart_background_1 = require("./chart_background");
var chart_container_1 = require("./chart_container");
var chart_resizer_1 = require("./chart_resizer");
var chart_status_1 = require("./chart_status");
var legend_1 = require("./legend/legend");
var getMiddlware = function (id) {
    var middlware = [];
    if (process.env.DEBUG_REDUX === 'true') {
        middlware.push(require('redux-immutable-state-invariant').default());
        middlware.push(require('redux-logger').createLogger({}));
    }
    if (typeof window !== 'undefined' && window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__) {
        return window
            .__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
            trace: true,
            name: "@elastic/charts (id: " + id + ")",
        })(redux_1.applyMiddleware.apply(void 0, __spread(middlware)));
    }
    return redux_1.applyMiddleware.apply(void 0, __spread(middlware));
};
var Chart = (function (_super) {
    __extends(Chart, _super);
    function Chart(props) {
        var _a;
        var _this = _super.call(this, props) || this;
        _this.getChartContainerRef = function () { return _this.chartContainerRef; };
        _this.chartContainerRef = react_1.createRef();
        _this.chartStageRef = react_1.createRef();
        var id = (_a = props.id, (_a !== null && _a !== void 0 ? _a : uuid_1.default.v4()));
        var storeReducer = chart_state_1.chartStoreReducer(id);
        var enhancer = getMiddlware(id);
        _this.chartStore = redux_1.createStore(storeReducer, enhancer);
        _this.state = {
            legendPosition: commons_1.Position.Right,
        };
        _this.unsubscribeToStore = _this.chartStore.subscribe(function () {
            var state = _this.chartStore.getState();
            if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
                return;
            }
            var settings = get_settings_specs_1.getSettingsSpecSelector(state);
            if (_this.state.legendPosition !== settings.legendPosition) {
                _this.setState({
                    legendPosition: settings.legendPosition,
                });
            }
            if (state.internalChartState) {
                state.internalChartState.eventCallbacks(state);
            }
        });
        return _this;
    }
    Chart.prototype.componentWillUnmount = function () {
        this.unsubscribeToStore();
    };
    Chart.prototype.getPNGSnapshot = function (options) {
        if (options === void 0) { options = {
            backgroundColor: 'transparent',
            pixelRatio: 2,
        }; }
        if (!this.chartStageRef.current) {
            return null;
        }
        var canvas = this.chartStageRef.current;
        var backgroundCanvas = document.createElement('canvas');
        backgroundCanvas.width = canvas.width;
        backgroundCanvas.height = canvas.height;
        var bgCtx = backgroundCanvas.getContext('2d');
        if (!bgCtx) {
            return null;
        }
        bgCtx.fillStyle = options.backgroundColor;
        bgCtx.fillRect(0, 0, canvas.width, canvas.height);
        bgCtx.drawImage(canvas, 0, 0);
        if (bgCtx.msToBlob) {
            var blobOrDataUrl = bgCtx.msToBlob();
            return {
                blobOrDataUrl: blobOrDataUrl,
                browser: 'IE11',
            };
        }
        return {
            blobOrDataUrl: backgroundCanvas.toDataURL(),
            browser: 'other',
        };
    };
    Chart.prototype.dispatchExternalPointerEvent = function (event) {
        this.chartStore.dispatch(events_1.onExternalPointerEvent(event));
    };
    Chart.prototype.render = function () {
        var _a = this.props, size = _a.size, className = _a.className;
        var containerSizeStyle = chart_size_1.getChartSize(size);
        var horizontal = axis_type_utils_1.isHorizontalAxis(this.state.legendPosition);
        var chartClassNames = classnames_1.default('echChart', className, {
            'echChart--column': horizontal,
        });
        return (react_1.default.createElement(react_redux_1.Provider, { store: this.chartStore },
            react_1.default.createElement("div", { className: chartClassNames, style: containerSizeStyle, ref: this.chartContainerRef },
                react_1.default.createElement(chart_background_1.ChartBackground, null),
                react_1.default.createElement(chart_status_1.ChartStatus, null),
                react_1.default.createElement(chart_resizer_1.ChartResizer, null),
                react_1.default.createElement(legend_1.Legend, null),
                react_1.default.createElement(specs_parser_1.SpecsParser, null, this.props.children),
                react_1.default.createElement("div", { className: "echContainer" },
                    react_1.default.createElement(chart_container_1.ChartContainer, { getChartContainerRef: this.getChartContainerRef, forwardStageRef: this.chartStageRef })))));
    };
    Chart.defaultProps = {
        renderer: 'canvas',
    };
    return Chart;
}(react_1.default.Component));
exports.Chart = Chart;
//# sourceMappingURL=chart.js.map