"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../utils/commons");
var spec_1 = require("../state/utils/spec");
var fit_function_1 = require("./fit_function");
var specs_1 = require("./specs");
exports.formatNonStackedDataSeriesValues = function (dataseries, scaleToExtent, seriesSpecs, xScaleType) {
    var len = dataseries.length;
    var formattedValues = [];
    for (var i = 0; i < len; i++) {
        var formattedDataValue = exports.formatNonStackedDataValues(dataseries[i], scaleToExtent);
        var spec = spec_1.getSpecsById(seriesSpecs, formattedDataValue.specId);
        if (spec !== null
            && spec !== undefined
            && (specs_1.isAreaSeriesSpec(spec) || specs_1.isLineSeriesSpec(spec))
            && spec.fit !== undefined) {
            var fittedData = fit_function_1.fitFunction(formattedDataValue, spec.fit, xScaleType);
            formattedValues.push(fittedData);
        }
        else {
            formattedValues.push(formattedDataValue);
        }
    }
    return formattedValues;
};
exports.formatNonStackedDataValues = function (dataSeries, scaleToExtent) {
    var len = dataSeries.data.length;
    var formattedValues = __assign(__assign({}, dataSeries), { data: [] });
    for (var i = 0; i < len; i++) {
        var data = dataSeries.data[i];
        var x = data.x, y1 = data.y1, mark = data.mark, datum = data.datum;
        var y0 = void 0;
        if (y1 === null) {
            y0 = null;
        }
        else if (scaleToExtent) {
            y0 = data.y0 ? data.y0 : y1;
        }
        else {
            y0 = data.y0 ? data.y0 : 0;
        }
        var formattedValue = {
            x: x,
            y1: y1,
            y0: y0,
            initialY1: y1,
            initialY0: data.y0 == null || y1 === null ? null : data.y0,
            mark: commons_1.isDefined(mark) ? mark : null,
            datum: datum,
        };
        formattedValues.data.push(formattedValue);
    }
    return formattedValues;
};
//# sourceMappingURL=nonstacked_series_utils.js.map