"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var specs_1 = require("../../../../specs");
var constants_1 = require("../../../../specs/constants");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var get_tooltip_header_formatter_1 = require("../../../../state/selectors/get_tooltip_header_formatter");
var events_1 = require("../../../../utils/events");
var rendering_1 = require("../../rendering/rendering");
var tooltip_1 = require("../../tooltip/tooltip");
var spec_1 = require("../utils/spec");
var get_computed_scales_1 = require("./get_computed_scales");
var get_elements_at_cursor_pos_1 = require("./get_elements_at_cursor_pos");
var get_oriented_projected_pointer_position_1 = require("./get_oriented_projected_pointer_position");
var get_projected_pointer_position_1 = require("./get_projected_pointer_position");
var get_specs_1 = require("./get_specs");
var has_single_series_1 = require("./has_single_series");
var EMPTY_VALUES = Object.freeze({
    tooltip: {
        header: null,
        values: [],
    },
    highlightedGeometries: [],
});
var getExternalPointerEventStateSelector = function (state) { return state.externalEvents.pointer; };
exports.getTooltipInfoAndGeometriesSelector = re_reselect_1.default([
    get_specs_1.getSeriesSpecsSelector,
    get_specs_1.getAxisSpecsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    get_projected_pointer_position_1.getProjectedPointerPositionSelector,
    get_oriented_projected_pointer_position_1.getOrientedProjectedPointerPositionSelector,
    get_chart_rotation_1.getChartRotationSelector,
    has_single_series_1.hasSingleSeriesSelector,
    get_computed_scales_1.getComputedScalesSelector,
    get_elements_at_cursor_pos_1.getElementAtCursorPositionSelector,
    getExternalPointerEventStateSelector,
    get_tooltip_header_formatter_1.getTooltipHeaderFormatterSelector,
], getTooltipAndHighlightFromValue)(function (_a) {
    var chartId = _a.chartId;
    return chartId;
});
function getTooltipAndHighlightFromValue(seriesSpecs, axesSpecs, settings, projectedPointerPosition, orientedProjectedPointerPosition, chartRotation, hasSingleSeries, scales, matchingGeoms, externalPointerEvent, tooltipHeaderFormatter) {
    if (!scales.xScale || !scales.yScales) {
        return EMPTY_VALUES;
    }
    var x = orientedProjectedPointerPosition.x, y = orientedProjectedPointerPosition.y;
    var tooltipType = specs_1.getTooltipType(settings);
    if (events_1.isValidPointerOverEvent(scales.xScale, externalPointerEvent)) {
        tooltipType = specs_1.getTooltipType(settings, true);
        var scaledX = scales.xScale.pureScale(externalPointerEvent.value);
        if (scaledX === null) {
            return EMPTY_VALUES;
        }
        x = scaledX;
        y = 0;
    }
    else if (projectedPointerPosition.x === -1 || projectedPointerPosition.y === -1) {
        return EMPTY_VALUES;
    }
    if (tooltipType === constants_1.TooltipType.None) {
        return EMPTY_VALUES;
    }
    if (matchingGeoms.length === 0) {
        return EMPTY_VALUES;
    }
    var header = null;
    var highlightedGeometries = [];
    var xValues = new Set();
    var values = matchingGeoms
        .filter(function (_a) {
        var y = _a.value.y;
        return y !== null;
    })
        .reduce(function (acc, indexedGeometry) {
        var specId = indexedGeometry.seriesIdentifier.specId;
        var spec = spec_1.getSpecsById(seriesSpecs, specId);
        if (!spec) {
            return acc;
        }
        var _a = spec_1.getAxesSpecForSpecId(axesSpecs, spec.groupId), xAxis = _a.xAxis, yAxis = _a.yAxis;
        var yScale = scales.yScales.get(spec.groupId);
        if (!yScale) {
            return acc;
        }
        var isHighlighted = false;
        if ((!externalPointerEvent || specs_1.isPointerOutEvent(externalPointerEvent))
            && rendering_1.isPointOnGeometry(x, y, indexedGeometry, settings.pointBuffer)) {
            isHighlighted = true;
            highlightedGeometries.push(indexedGeometry);
        }
        if (!isHighlighted && specs_1.isFollowTooltipType(tooltipType)) {
            return acc;
        }
        var yAxisFormatSpec = [0, 180].includes(chartRotation) ? yAxis : xAxis;
        var formattedTooltip = tooltip_1.formatTooltip(indexedGeometry, spec, false, isHighlighted, hasSingleSeries, yAxisFormatSpec);
        if (!header) {
            var xAxisFormatSpec = [0, 180].includes(chartRotation) ? xAxis : yAxis;
            var formatterAxis = tooltipHeaderFormatter ? undefined : xAxisFormatSpec;
            header = tooltip_1.formatTooltip(indexedGeometry, spec, true, false, hasSingleSeries, formatterAxis);
        }
        xValues.add(indexedGeometry.value.x);
        return __spread(acc, [formattedTooltip]);
    }, []);
    if (values.length > 1 && xValues.size === values.length) {
        header = null;
    }
    return {
        tooltip: {
            header: header,
            values: values,
        },
        highlightedGeometries: highlightedGeometries,
    };
}
exports.getTooltipInfoSelector = re_reselect_1.default([exports.getTooltipInfoAndGeometriesSelector], function (_a) {
    var tooltip = _a.tooltip;
    return tooltip;
})(get_chart_id_1.getChartIdSelector);
exports.getHighlightedGeomsSelector = re_reselect_1.default([exports.getTooltipInfoAndGeometriesSelector], function (_a) {
    var highlightedGeometries = _a.highlightedGeometries;
    return highlightedGeometries;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_tooltip_values_highlighted_geoms.js.map