"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var axis_utils_1 = require("../../utils/axis_utils");
var compute_axis_ticks_dimensions_1 = require("./compute_axis_ticks_dimensions");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var compute_series_domains_1 = require("./compute_series_domains");
var count_bars_in_cluster_1 = require("./count_bars_in_cluster");
var get_bar_paddings_1 = require("./get_bar_paddings");
var get_specs_1 = require("./get_specs");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
exports.computeAxisVisibleTicksSelector = re_reselect_1.default([
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_chart_theme_1.getChartThemeSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    get_specs_1.getAxisSpecsSelector,
    compute_axis_ticks_dimensions_1.computeAxisTicksDimensionsSelector,
    compute_series_domains_1.computeSeriesDomainsSelector,
    count_bars_in_cluster_1.countBarsInClusterSelector,
    is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
    get_bar_paddings_1.getBarPaddingsSelector,
], function (chartDimensions, chartTheme, settingsSpec, axesSpecs, axesTicksDimensions, seriesDomainsAndData, totalBarsInCluster, isHistogramMode, barsPadding) {
    var xDomain = seriesDomainsAndData.xDomain, yDomain = seriesDomainsAndData.yDomain;
    return axis_utils_1.getAxisTicksPositions(chartDimensions, chartTheme, settingsSpec.rotation, axesSpecs, axesTicksDimensions, xDomain, yDomain, totalBarsInCluster, isHistogramMode, barsPadding);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=compute_axis_visible_ticks.js.map