
#ifndef KDBUSADDONS_EXPORT_H
#define KDBUSADDONS_EXPORT_H

#ifdef KDBUSADDONS_STATIC_DEFINE
#  define KDBUSADDONS_EXPORT
#  define KDBUSADDONS_NO_EXPORT
#else
#  ifndef KDBUSADDONS_EXPORT
#    ifdef KF5DBusAddons_EXPORTS
        /* We are building this library */
#      define KDBUSADDONS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KDBUSADDONS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KDBUSADDONS_NO_EXPORT
#    define KDBUSADDONS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KDBUSADDONS_DECL_DEPRECATED
#  define KDBUSADDONS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KDBUSADDONS_DECL_DEPRECATED_EXPORT
#  define KDBUSADDONS_DECL_DEPRECATED_EXPORT KDBUSADDONS_EXPORT KDBUSADDONS_DECL_DEPRECATED
#endif

#ifndef KDBUSADDONS_DECL_DEPRECATED_NO_EXPORT
#  define KDBUSADDONS_DECL_DEPRECATED_NO_EXPORT KDBUSADDONS_NO_EXPORT KDBUSADDONS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDBUSADDONS_NO_DEPRECATED
#    define KDBUSADDONS_NO_DEPRECATED
#  endif
#endif

#define KDBUSADDONS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KDBUSADDONS_NO_DEPRECATED) && !defined(KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KDBUSADDONS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KDBUSADDONS_NO_DEPRECATED_WARNINGS) && !defined(KDBUSADDONS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KDBUSADDONS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KDBUSADDONS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KDBUSADDONS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KDBUSADDONS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KDBUSADDONS_NO_DEPRECATED)
#  undef KDBUSADDONS_DEPRECATED
#  define KDBUSADDONS_DEPRECATED_EXPORT KDBUSADDONS_EXPORT
#  define KDBUSADDONS_DEPRECATED_NO_EXPORT KDBUSADDONS_NO_EXPORT
#elif defined(KDBUSADDONS_NO_DEPRECATED_WARNINGS)
#  define KDBUSADDONS_DEPRECATED
#  define KDBUSADDONS_DEPRECATED_EXPORT KDBUSADDONS_EXPORT
#  define KDBUSADDONS_DEPRECATED_NO_EXPORT KDBUSADDONS_NO_EXPORT
#else
#  define KDBUSADDONS_DEPRECATED KDBUSADDONS_DECL_DEPRECATED
#  define KDBUSADDONS_DEPRECATED_EXPORT KDBUSADDONS_DECL_DEPRECATED_EXPORT
#  define KDBUSADDONS_DEPRECATED_NO_EXPORT KDBUSADDONS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDBUSADDONS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDBUSADDONS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDBUSADDONS_NO_DEPRECATED
#  define KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x54900
#endif
#ifdef KDBUSADDONS_NO_DEPRECATED_WARNINGS
#  define KDBUSADDONS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDBUSADDONS_DEPRECATED_WARNINGS_SINCE
#  ifdef KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDBUSADDONS_DEPRECATED_WARNINGS_SINCE KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDBUSADDONS_DEPRECATED_WARNINGS_SINCE 0x54900
#  endif
#endif

#ifndef KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDBUSADDONS_DEPRECATED
#  define KDBUSADDONS_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KDBUSADDONS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDBUSADDONS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KDBUSADDONS_DEPRECATED_WARNINGS_SINCE >= 0x54400
#  define KDBUSADDONS_DEPRECATED_VERSION_5_68(text) KDBUSADDONS_DECL_DEPRECATED_TEXT(text)
#else
#  define KDBUSADDONS_DEPRECATED_VERSION_5_68(text)
#endif
#define KDBUSADDONS_DEPRECATED_VERSION_5(minor, text)      KDBUSADDONS_DEPRECATED_VERSION_5_##minor(text)
#define KDBUSADDONS_DEPRECATED_VERSION(major, minor, text) KDBUSADDONS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KDBUSADDONS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KDBUSADDONS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)

#endif /* KDBUSADDONS_EXPORT_H */
