/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.slicedMap.AbstractWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.DelegatingSlice;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.SlicedMap;

public class BasicWritableSlice<K, V>
extends AbstractWritableSlice<K, V> {
    private String debugName;
    private final RewritePolicy rewritePolicy;
    private final boolean isCollective;

    public static Void initSliceDebugNames(Class<?> declarationOwner) {
        for (Field field : declarationOwner.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object value2 = field.get(null);
                if (!(value2 instanceof BasicWritableSlice)) continue;
                BasicWritableSlice slice = (BasicWritableSlice)value2;
                slice.debugName = field.getName();
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public BasicWritableSlice(RewritePolicy rewritePolicy) {
        this(rewritePolicy, false);
    }

    public BasicWritableSlice(RewritePolicy rewritePolicy, boolean isCollective) {
        super("<BasicWritableSlice>");
        this.rewritePolicy = rewritePolicy;
        this.isCollective = isCollective;
    }

    @Override
    public boolean check(K key, V value2) {
        assert (value2 != null) : this + " called with null value";
        return true;
    }

    @Override
    public void afterPut(MutableSlicedMap map2, K key, V value2) {
    }

    @Override
    public V computeValue(SlicedMap map2, K key, V value2, boolean valueNotFound) {
        if (valueNotFound) assert (value2 == null);
        return value2;
    }

    @Override
    public RewritePolicy getRewritePolicy() {
        return this.rewritePolicy;
    }

    @Override
    public boolean isCollective() {
        return this.isCollective;
    }

    public void setDebugName(@NotNull String debugName) {
        if (debugName == null) {
            BasicWritableSlice.$$$reportNull$$$0(0);
        }
        if (this.debugName != null) {
            throw new IllegalStateException("Debug name already set for " + this);
        }
        this.debugName = debugName;
    }

    @Override
    public String toString() {
        return this.debugName;
    }

    @Override
    public ReadOnlySlice<K, V> makeRawValueVersion() {
        return new DelegatingSlice<K, V>(this){

            @Override
            public V computeValue(SlicedMap map2, K key, V value2, boolean valueNotFound) {
                if (valueNotFound) assert (value2 == null);
                return value2;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/util/slicedMap/BasicWritableSlice", "setDebugName"));
    }
}

