/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.security.util.ThrowableCauseExtractor;

public class ThrowableAnalyzer {
    public static final ThrowableCauseExtractor DEFAULT_EXTRACTOR = new ThrowableCauseExtractor(){

        public Throwable extractCause(Throwable throwable) {
            return throwable.getCause();
        }
    };
    public static final ThrowableCauseExtractor INVOCATIONTARGET_EXTRACTOR = new ThrowableCauseExtractor(){

        public Throwable extractCause(Throwable throwable) {
            ThrowableAnalyzer.verifyThrowableHierarchy(throwable, class$java$lang$reflect$InvocationTargetException == null ? (class$java$lang$reflect$InvocationTargetException = ThrowableAnalyzer.class$("java.lang.reflect.InvocationTargetException")) : class$java$lang$reflect$InvocationTargetException);
            return ((InvocationTargetException)throwable).getTargetException();
        }
    };
    private static final Comparator CLASS_HIERARCHY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            Class class1 = (Class)o1;
            Class class2 = (Class)o2;
            if (class1.isAssignableFrom(class2)) {
                return 1;
            }
            if (class2.isAssignableFrom(class1)) {
                return -1;
            }
            return class1.getName().compareTo(class2.getName());
        }
    };
    private final Map extractorMap = new TreeMap(CLASS_HIERARCHY_COMPARATOR);
    static /* synthetic */ Class class$java$lang$reflect$InvocationTargetException;
    static /* synthetic */ Class class$java$lang$Throwable;

    public ThrowableAnalyzer() {
        this.initExtractorMap();
    }

    protected final void registerExtractor(Class throwableType, ThrowableCauseExtractor extractor) {
        ThrowableAnalyzer.verifyThrowableType(throwableType);
        if (extractor == null) {
            throw new IllegalArgumentException("Invalid extractor: null");
        }
        this.extractorMap.put(throwableType, extractor);
    }

    protected void initExtractorMap() {
        this.registerExtractor(class$java$lang$reflect$InvocationTargetException == null ? (class$java$lang$reflect$InvocationTargetException = ThrowableAnalyzer.class$("java.lang.reflect.InvocationTargetException")) : class$java$lang$reflect$InvocationTargetException, INVOCATIONTARGET_EXTRACTOR);
        this.registerExtractor(class$java$lang$Throwable == null ? (class$java$lang$Throwable = ThrowableAnalyzer.class$("java.lang.Throwable")) : class$java$lang$Throwable, DEFAULT_EXTRACTOR);
    }

    final Class[] getRegisteredTypes() {
        ArrayList typeList = new ArrayList(this.extractorMap.keySet());
        return typeList.toArray(new Class[typeList.size()]);
    }

    public final Throwable[] determineCauseChain(Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("Invalid throwable: null");
        }
        ArrayList<Throwable> chain = new ArrayList<Throwable>();
        Throwable currentThrowable = throwable;
        while (currentThrowable != null) {
            chain.add(currentThrowable);
            currentThrowable = this.extractCause(currentThrowable);
        }
        return chain.toArray(new Throwable[chain.size()]);
    }

    private Throwable extractCause(Throwable throwable) {
        Iterator iter = this.extractorMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Class throwableType = (Class)entry.getKey();
            if (!throwableType.isInstance(throwable)) continue;
            ThrowableCauseExtractor extractor = (ThrowableCauseExtractor)entry.getValue();
            return extractor.extractCause(throwable);
        }
        return null;
    }

    public final Throwable getFirstThrowableOfType(Class throwableType, Throwable[] chain) {
        ThrowableAnalyzer.verifyThrowableType(throwableType);
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                Throwable t = chain[i];
                if (t == null || !throwableType.isInstance(t)) continue;
                return t;
            }
        }
        return null;
    }

    private static void verifyThrowableType(Class throwableType) {
        if (throwableType == null) {
            throw new IllegalArgumentException("Invalid type: null");
        }
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = ThrowableAnalyzer.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(throwableType)) {
            throw new IllegalArgumentException("Invalid type: '" + throwableType.getName() + "'. Has to be a subclass of '" + (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ThrowableAnalyzer.class$("java.lang.Throwable")) : class$java$lang$Throwable).getName() + "'");
        }
    }

    public static final void verifyThrowableHierarchy(Throwable throwable, Class expectedBaseType) {
        if (expectedBaseType == null) {
            return;
        }
        if (throwable == null) {
            throw new IllegalArgumentException("Invalid throwable: null");
        }
        Class<?> throwableType = throwable.getClass();
        if (!expectedBaseType.isAssignableFrom(throwableType)) {
            throw new IllegalArgumentException("Invalid type: '" + throwableType.getName() + "'. Has to be a subclass of '" + expectedBaseType.getName() + "'");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

