/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.etl.kettle.KettleJob;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.SPSUtils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinMeta;

public class KettleJobPanel
implements DataEntryPanel {
    private static Logger logger = Logger.getLogger(KettleJobPanel.class);
    private JPanel panel = new JPanel();
    private JTextField nameField;
    private JComboBox databaseComboBox;
    private JButton newDatabaseButton;
    private JTextField schemaName;
    private JTextField filePath;
    private JButton browseFilePath;
    private JComboBox defaultJoinType;
    private JLabel transformationPath;
    private JRadioButton saveFileRadioButton;
    private JRadioButton saveReposRadioButton;
    private JButton reposPropertiesButton;
    private JComboBox reposDB;
    private final ArchitectSwingSession session;

    public KettleJobPanel(ArchitectSwingSession session) {
        this.session = session;
        this.buildUI();
        this.panel.setVisible(true);
    }

    private void buildUI() {
        KettleJob settings = this.session.getKettleJob();
        this.panel.setLayout((LayoutManager)new FormLayout());
        this.panel.setPreferredSize(new Dimension(450, 300));
        this.nameField = new JTextField(settings.getJobName());
        this.databaseComboBox = new JComboBox();
        ASUtils.setupTargetDBComboBox(this.session, this.databaseComboBox);
        this.newDatabaseButton = new JButton();
        this.newDatabaseButton.setText(Messages.getString("KettleJobPanel.propertiesButton"));
        this.newDatabaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window parentWindow = SPSUtils.getWindowInHierarchy((Component)KettleJobPanel.this.panel);
                ASUtils.showTargetDbcsDialog(parentWindow, KettleJobPanel.this.session, KettleJobPanel.this.databaseComboBox);
            }
        });
        this.schemaName = new JTextField(settings.getSchemaName());
        this.saveFileRadioButton = new JRadioButton(Messages.getString("KettleJobPanel.saveJobToFileOption"), settings.isSavingToFile());
        this.filePath = new JTextField(settings.getFilePath());
        this.filePath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.copyFilePath();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.copyFilePath();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.copyFilePath();
            }

            private void copyFilePath() {
                File file = new File(KettleJobPanel.this.filePath.getText());
                if (file != null) {
                    File parentFile = file.getParentFile();
                    KettleJobPanel.this.transformationPath.setText("     " + (parentFile == null || parentFile.getPath() == null ? "" : parentFile.getPath()));
                }
            }
        });
        this.browseFilePath = new JButton();
        this.browseFilePath.setText(Messages.getString("KettleJobPanel.browseButton"));
        this.browseFilePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(KettleJobPanel.this.session.getProjectLoader().getFile());
                chooser.addChoosableFileFilter(SPSUtils.XML_FILE_FILTER);
                int response = chooser.showSaveDialog(KettleJobPanel.this.panel);
                if (response != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                File parentFile = file.getParentFile();
                KettleJobPanel.this.filePath.setText(file.getPath());
                if (parentFile != null) {
                    KettleJobPanel.this.transformationPath.setText("     " + parentFile.getPath());
                }
            }
        });
        File parentFile = new File(settings.getFilePath()).getParentFile();
        this.transformationPath = settings == null || parentFile == null || parentFile.getPath() == null ? new JLabel("") : new JLabel("     " + parentFile.getPath());
        this.saveReposRadioButton = new JRadioButton(Messages.getString("KettleJobPanel.saveJobToRepositoryOption"), !settings.isSavingToFile());
        Object[] connectionArray = this.session.getContext().getConnections().toArray();
        this.reposDB = new JComboBox<Object>(connectionArray);
        if (connectionArray.length > 0) {
            this.reposDB.setSelectedIndex(0);
        }
        this.reposPropertiesButton = new JButton();
        this.reposPropertiesButton.setText(Messages.getString("KettleJobPanel.propertiesButton"));
        this.reposPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window parentWindow = SPSUtils.getWindowInHierarchy((Component)KettleJobPanel.this.panel);
                ASUtils.showDbcsDialog(parentWindow, (JDBCDataSource)KettleJobPanel.this.reposDB.getSelectedItem(), null);
            }
        });
        ButtonGroup saveByButtonGroup = new ButtonGroup();
        saveByButtonGroup.add(this.saveFileRadioButton);
        saveByButtonGroup.add(this.saveReposRadioButton);
        this.defaultJoinType = new JComboBox();
        for (int joinType = 0; joinType < MergeJoinMeta.join_types.length; ++joinType) {
            this.defaultJoinType.addItem(MergeJoinMeta.join_types[joinType]);
        }
        this.defaultJoinType.setSelectedIndex(settings.getKettleJoinType());
        FormLayout formLayout = new FormLayout("10dlu, 2dlu, pref, 4dlu,0:grow, 4dlu, pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout, this.panel);
        builder.nextColumn(2);
        builder.append(Messages.getString("KettleJobPanel.jobNameLabel"));
        builder.append((Component)this.nameField, 3);
        builder.nextLine();
        builder.append("");
        builder.append(Messages.getString("KettleJobPanel.targetDatabaseLabel"));
        builder.append((Component)this.databaseComboBox);
        builder.append((Component)this.newDatabaseButton);
        builder.nextLine();
        builder.append("");
        builder.append(Messages.getString("KettleJobPanel.schemaNameLabel"));
        builder.append((Component)this.schemaName, 3);
        builder.nextLine();
        builder.append("");
        builder.append(Messages.getString("KettleJobPanel.defaultJoinTypeLabel"));
        builder.append((Component)this.defaultJoinType);
        builder.nextLine();
        builder.append("");
        builder.append((Component)this.saveFileRadioButton, 3);
        builder.nextLine();
        builder.append("");
        builder.append(Messages.getString("KettleJobPanel.pathLabel"));
        builder.append((Component)this.filePath);
        builder.append((Component)this.browseFilePath);
        builder.nextLine();
        builder.append("");
        builder.append("");
        JLabel transPathLabel = new JLabel(Messages.getString("KettleJobPanel.transfomationsPathLabel"));
        builder.append((Component)transPathLabel, 3);
        builder.nextLine();
        builder.append("");
        builder.append("");
        builder.append((Component)this.transformationPath, 3);
        builder.nextLine();
        builder.append("");
        builder.append((Component)this.saveReposRadioButton, 3);
        builder.nextLine();
        builder.append("");
        builder.append(Messages.getString("KettleJobPanel.repositoryLabel"));
        builder.append((Component)this.reposDB);
        builder.append((Component)this.reposPropertiesButton);
        builder.nextLine();
        builder.append("");
        JLabel check = new JLabel(Messages.getString("KettleJobPanel.checkTargetSameAsPlaypenWarning"));
        builder.append((Component)check, 5);
    }

    public boolean applyChanges() {
        this.copySettingsToProject();
        if (this.nameField.getText().equals("")) {
            JOptionPane.showMessageDialog(this.panel, Messages.getString("KettleJobPanel.jobNameNotSetError"));
            return false;
        }
        if (this.filePath.getText().equals("") && this.saveFileRadioButton.isSelected()) {
            JOptionPane.showMessageDialog(this.panel, Messages.getString("KettleJobPanel.jobPathNotSetError"));
            return false;
        }
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public String getPath() {
        return this.filePath.getText();
    }

    public String getSchemaName() {
        return this.schemaName.getText();
    }

    public boolean isSaveFile() {
        return this.saveFileRadioButton.isSelected();
    }

    public boolean isSaveRepository() {
        return this.saveReposRadioButton.isSelected();
    }

    public int getDefaultJoinType() {
        return this.defaultJoinType.getSelectedIndex();
    }

    public String getJobName() {
        return this.nameField.getText();
    }

    private void copySettingsToProject() {
        logger.debug((Object)"Saving settings to the project...");
        KettleJob settings = this.session.getKettleJob();
        this.session.getWorkspace().begin("Saving kettle settings");
        settings.setJobName(this.nameField.getText());
        settings.setSchemaName(this.schemaName.getText());
        settings.setKettleJoinType(this.defaultJoinType.getSelectedIndex());
        settings.setFilePath(this.filePath.getText());
        settings.setRepository((JDBCDataSource)this.reposDB.getSelectedItem());
        settings.setSavingToFile(this.isSaveFile());
        this.session.getWorkspace().commit();
    }

    public boolean hasUnsavedChanges() {
        return true;
    }
}

