/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.util.Collections;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;

public abstract class BaseHttpSolrClient
extends SolrClient {

    public static class RemoteExecutionException
    extends HttpSolrClient.RemoteSolrException {
        private NamedList meta;

        public RemoteExecutionException(String remoteHost, int code, String msg, NamedList meta) {
            super(remoteHost, code, msg, null);
            this.meta = meta;
        }

        public static HttpSolrClient.RemoteExecutionException create(String host, NamedList errResponse) {
            Object errObj = errResponse.get("error");
            if (errObj != null) {
                Number code = (Number)Utils.getObjectByPath(errObj, true, Collections.singletonList("code"));
                String msg = (String)Utils.getObjectByPath(errObj, true, Collections.singletonList("msg"));
                return new HttpSolrClient.RemoteExecutionException(host, code == null ? SolrException.ErrorCode.UNKNOWN.code : code.intValue(), msg == null ? "Unknown Error" : msg, errResponse);
            }
            throw new RuntimeException("No error");
        }

        public NamedList getMetaData() {
            return this.meta;
        }
    }

    public static class RemoteSolrException
    extends SolrException {
        public RemoteSolrException(String remoteHost, int code, String msg, Throwable th) {
            super(code, "Error from server at " + remoteHost + ": " + msg, th);
        }
    }
}

