/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.lang.invoke.MethodHandles;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.processor.AllValuesOrNoneFieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseDateFieldUpdateProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FORMATS_PARAM = "format";
    private static final String DEFAULT_TIME_ZONE_PARAM = "defaultTimeZone";
    private static final String LOCALE_PARAM = "locale";
    private Map<String, DateTimeFormatter> formats = new LinkedHashMap<String, DateTimeFormatter>();

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new AllValuesOrNoneFieldMutatingUpdateProcessor(this.getSelector(), next){
            final ParsePosition parsePosition;
            {
                this.parsePosition = new ParsePosition(0);
            }

            @Override
            protected Object mutateValue(Object srcVal) {
                if (srcVal instanceof CharSequence) {
                    String srcStringVal = srcVal.toString();
                    int stringValLen = srcStringVal.length();
                    if (stringValLen > 1 && srcStringVal.startsWith("'") && srcStringVal.endsWith("'")) {
                        srcStringVal = srcStringVal.substring(1, stringValLen - 1);
                    }
                    for (Map.Entry format : ParseDateFieldUpdateProcessorFactory.this.formats.entrySet()) {
                        DateTimeFormatter parser = (DateTimeFormatter)format.getValue();
                        try {
                            return Date.from(ParseDateFieldUpdateProcessorFactory.parseInstant(parser, srcStringVal, this.parsePosition));
                        }
                        catch (DateTimeParseException e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("value '{}' is not parseable with format '{}'", new Object[]{srcStringVal, format.getKey()});
                        }
                    }
                    log.debug("value '{}' was not parsed by any configured format, thus was not mutated", (Object)srcStringVal);
                    return SKIP_FIELD_VALUE_LIST_SINGLETON;
                }
                if (srcVal instanceof Date) {
                    return srcVal;
                }
                return SKIP_FIELD_VALUE_LIST_SINGLETON;
            }
        };
    }

    @Override
    public void init(NamedList args) {
        Collection formatsParam;
        String localeParam = (String)args.remove(LOCALE_PARAM);
        Locale locale = null != localeParam ? LocaleUtils.toLocale((String)localeParam) : Locale.US;
        Object defaultTimeZoneParam = args.remove(DEFAULT_TIME_ZONE_PARAM);
        ZoneId defaultTimeZone = ZoneOffset.UTC;
        if (null != defaultTimeZoneParam) {
            defaultTimeZone = ZoneId.of(defaultTimeZoneParam.toString());
        }
        if (null != (formatsParam = args.removeConfigArgs(FORMATS_PARAM))) {
            for (String value : formatsParam) {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(value).toFormatter(locale).withResolverStyle(ResolverStyle.LENIENT).withZone(defaultTimeZone);
                ParseDateFieldUpdateProcessorFactory.validateFormatter(formatter);
                this.formats.put(value, formatter);
            }
        }
        super.init(args);
    }

    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return fieldName -> {
            IndexSchema schema = core.getLatestSchema();
            FieldType type = schema.getFieldTypeNoEx(fieldName);
            return null == type || type instanceof DateValueFieldType;
        };
    }

    public static void validateFormatter(DateTimeFormatter formatter) {
        try {
            ParseDateFieldUpdateProcessorFactory.parseInstant(formatter, formatter.format(Instant.now()), new ParsePosition(0));
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Bad or unsupported pattern: " + formatter.toFormat().toString(), (Throwable)e);
        }
    }

    private static Instant parseInstant(DateTimeFormatter formatter, String dateStr, ParsePosition parsePosition) {
        parsePosition.setIndex(0);
        parsePosition.setErrorIndex(-1);
        TemporalAccessor temporal = formatter.parse((CharSequence)dateStr, parsePosition);
        if (parsePosition.getIndex() < dateStr.length()) {
            String abbr = dateStr.length() > 64 ? dateStr.subSequence(0, 64).toString() + "..." : dateStr;
            throw new DateTimeParseException("Text '" + abbr + "' could not be parsed, unparsed text found at index " + parsePosition.getIndex(), dateStr, parsePosition.getIndex());
        }
        LocalDate date = temporal.query(TemporalQueries.localDate());
        if (date == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Date (year, month, day) is mandatory: " + formatter.toFormat().toString());
        }
        LocalTime time = temporal.query(TemporalQueries.localTime());
        if (time == null) {
            time = LocalTime.MIN;
        }
        LocalDateTime localDateTime = LocalDateTime.of(date, time);
        ZoneOffset offset = temporal.query(TemporalQueries.offset());
        if (offset == null) {
            ZoneId zoneId = temporal.query(TemporalQueries.zone());
            if (zoneId == null && (zoneId = formatter.getZone()) == null) {
                zoneId = ZoneOffset.UTC;
            }
            return localDateTime.atZone(zoneId).toInstant();
        }
        return localDateTime.toInstant(offset);
    }
}

