"""Generated client library for bigtableadmin version v2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.bigtableadmin.v2 import bigtableadmin_v2_messages as messages


class BigtableadminV2(base_api.BaseApiClient):
  """Generated client library for service bigtableadmin version v2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://bigtableadmin.googleapis.com/'
  MTLS_BASE_URL = u'https://bigtableadmin.mtls.googleapis.com/'

  _PACKAGE = u'bigtableadmin'
  _SCOPES = [u'https://www.googleapis.com/auth/bigtable.admin', u'https://www.googleapis.com/auth/bigtable.admin.cluster', u'https://www.googleapis.com/auth/bigtable.admin.instance', u'https://www.googleapis.com/auth/bigtable.admin.table', u'https://www.googleapis.com/auth/cloud-bigtable.admin', u'https://www.googleapis.com/auth/cloud-bigtable.admin.cluster', u'https://www.googleapis.com/auth/cloud-bigtable.admin.table', u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = u'v2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = u'google-cloud-sdk'
  _CLIENT_CLASS_NAME = u'BigtableadminV2'
  _URL_VERSION = u'v2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new bigtableadmin handle."""
    url = url or self.BASE_URL
    super(BigtableadminV2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.operations_projects_operations = self.OperationsProjectsOperationsService(self)
    self.operations_projects = self.OperationsProjectsService(self)
    self.operations = self.OperationsService(self)
    self.projects_instances_appProfiles = self.ProjectsInstancesAppProfilesService(self)
    self.projects_instances_clusters_backups = self.ProjectsInstancesClustersBackupsService(self)
    self.projects_instances_clusters = self.ProjectsInstancesClustersService(self)
    self.projects_instances_tables = self.ProjectsInstancesTablesService(self)
    self.projects_instances = self.ProjectsInstancesService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class OperationsProjectsOperationsService(base_api.BaseApiService):
    """Service class for the operations_projects_operations resource."""

    _NAME = u'operations_projects_operations'

    def __init__(self, client):
      super(BigtableadminV2.OperationsProjectsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the.
server doesn't support this method, it returns `UNIMPLEMENTED`.

NOTE: the `name` binding allows API services to override the binding
to use different resource name schemes, such as `users/*/operations`. To
override the binding, API services can add a binding such as
`"/v1/{name=users/*}/operations"` to their service configuration.
For backwards compatibility, the default name includes the operations
collection id, however overriding users must ensure the name binding
is the parent resource, without the operations collection id.

      Args:
        request: (BigtableadminOperationsProjectsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/operations/projects/{projectsId}/operations',
        http_method=u'GET',
        method_id=u'bigtableadmin.operations.projects.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+name}/operations',
        request_field='',
        request_type_name=u'BigtableadminOperationsProjectsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class OperationsProjectsService(base_api.BaseApiService):
    """Service class for the operations_projects resource."""

    _NAME = u'operations_projects'

    def __init__(self, client):
      super(BigtableadminV2.OperationsProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(BigtableadminV2.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.  The server.
makes a best effort to cancel the operation, but success is not
guaranteed.  If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.  Clients can use
Operations.GetOperation or
other methods to check whether the cancellation succeeded or whether the
operation completed despite cancellation. On successful cancellation,
the operation is not deleted; instead, it becomes an operation with
an Operation.error value with a google.rpc.Status.code of 1,
corresponding to `Code.CANCELLED`.

      Args:
        request: (BigtableadminOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'bigtableadmin.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:cancel',
        request_field='',
        request_type_name=u'BigtableadminOperationsCancelRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is.
no longer interested in the operation result. It does not cancel the
operation. If the server doesn't support this method, it returns
`google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (BigtableadminOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/operations/{operationsId}',
        http_method=u'DELETE',
        method_id=u'bigtableadmin.operations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminOperationsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (BigtableadminOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'bigtableadmin.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsInstancesAppProfilesService(base_api.BaseApiService):
    """Service class for the projects_instances_appProfiles resource."""

    _NAME = u'projects_instances_appProfiles'

    def __init__(self, client):
      super(BigtableadminV2.ProjectsInstancesAppProfilesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an app profile within an instance.

      Args:
        request: (BigtableadminProjectsInstancesAppProfilesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AppProfile) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/appProfiles',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.appProfiles.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'appProfileId', u'ignoreWarnings'],
        relative_path=u'v2/{+parent}/appProfiles',
        request_field=u'appProfile',
        request_type_name=u'BigtableadminProjectsInstancesAppProfilesCreateRequest',
        response_type_name=u'AppProfile',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an app profile from an instance.

      Args:
        request: (BigtableadminProjectsInstancesAppProfilesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/appProfiles/{appProfilesId}',
        http_method=u'DELETE',
        method_id=u'bigtableadmin.projects.instances.appProfiles.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'ignoreWarnings'],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesAppProfilesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about an app profile.

      Args:
        request: (BigtableadminProjectsInstancesAppProfilesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AppProfile) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/appProfiles/{appProfilesId}',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.appProfiles.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesAppProfilesGetRequest',
        response_type_name=u'AppProfile',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about app profiles in an instance.

      Args:
        request: (BigtableadminProjectsInstancesAppProfilesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAppProfilesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/appProfiles',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.appProfiles.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/appProfiles',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesAppProfilesListRequest',
        response_type_name=u'ListAppProfilesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an app profile within an instance.

      Args:
        request: (BigtableadminProjectsInstancesAppProfilesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/appProfiles/{appProfilesId}',
        http_method=u'PATCH',
        method_id=u'bigtableadmin.projects.instances.appProfiles.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'ignoreWarnings', u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'appProfile',
        request_type_name=u'BigtableadminProjectsInstancesAppProfilesPatchRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsInstancesClustersBackupsService(base_api.BaseApiService):
    """Service class for the projects_instances_clusters_backups resource."""

    _NAME = u'projects_instances_clusters_backups'

    def __init__(self, client):
      super(BigtableadminV2.ProjectsInstancesClustersBackupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Starts creating a new Cloud Bigtable Backup.  The returned backup.
long-running operation can be used to
track creation of the backup. The
metadata field type is
CreateBackupMetadata. The
response field type is
Backup, if successful. Cancelling the returned operation will stop the
creation and delete the backup.

      Args:
        request: (BigtableadminProjectsInstancesClustersBackupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}/backups',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.clusters.backups.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'backupId'],
        relative_path=u'v2/{+parent}/backups',
        request_field=u'backup',
        request_type_name=u'BigtableadminProjectsInstancesClustersBackupsCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a pending or completed Cloud Bigtable backup.

      Args:
        request: (BigtableadminProjectsInstancesClustersBackupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}/backups/{backupsId}',
        http_method=u'DELETE',
        method_id=u'bigtableadmin.projects.instances.clusters.backups.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesClustersBackupsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets metadata on a pending or completed Cloud Bigtable Backup.

      Args:
        request: (BigtableadminProjectsInstancesClustersBackupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Backup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}/backups/{backupsId}',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.clusters.backups.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesClustersBackupsGetRequest',
        response_type_name=u'Backup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a Table resource.
Returns an empty policy if the resource exists but does not have a policy
set.

      Args:
        request: (BigtableadminProjectsInstancesClustersBackupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}/backups/{backupsId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.clusters.backups.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'BigtableadminProjectsInstancesClustersBackupsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Cloud Bigtable backups. Returns both completed and pending.
backups.

      Args:
        request: (BigtableadminProjectsInstancesClustersBackupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBackupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}/backups',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.clusters.backups.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'filter', u'orderBy', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+parent}/backups',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesClustersBackupsListRequest',
        response_type_name=u'ListBackupsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a pending or completed Cloud Bigtable Backup.

      Args:
        request: (BigtableadminProjectsInstancesClustersBackupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Backup) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}/backups/{backupsId}',
        http_method=u'PATCH',
        method_id=u'bigtableadmin.projects.instances.clusters.backups.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'backup',
        request_type_name=u'BigtableadminProjectsInstancesClustersBackupsPatchRequest',
        response_type_name=u'Backup',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a Table resource.
Replaces any existing policy.

      Args:
        request: (BigtableadminProjectsInstancesClustersBackupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}/backups/{backupsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.clusters.backups.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'BigtableadminProjectsInstancesClustersBackupsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified table resource.

      Args:
        request: (BigtableadminProjectsInstancesClustersBackupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}/backups/{backupsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.clusters.backups.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'BigtableadminProjectsInstancesClustersBackupsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsInstancesClustersService(base_api.BaseApiService):
    """Service class for the projects_instances_clusters resource."""

    _NAME = u'projects_instances_clusters'

    def __init__(self, client):
      super(BigtableadminV2.ProjectsInstancesClustersService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a cluster within an instance.

      Args:
        request: (BigtableadminProjectsInstancesClustersCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.clusters.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'clusterId'],
        relative_path=u'v2/{+parent}/clusters',
        request_field=u'cluster',
        request_type_name=u'BigtableadminProjectsInstancesClustersCreateRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a cluster from an instance.

      Args:
        request: (BigtableadminProjectsInstancesClustersDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}',
        http_method=u'DELETE',
        method_id=u'bigtableadmin.projects.instances.clusters.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesClustersDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about a cluster.

      Args:
        request: (BigtableadminProjectsInstancesClustersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Cluster) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.clusters.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesClustersGetRequest',
        response_type_name=u'Cluster',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about clusters in an instance.

      Args:
        request: (BigtableadminProjectsInstancesClustersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListClustersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.clusters.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageToken'],
        relative_path=u'v2/{+parent}/clusters',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesClustersListRequest',
        response_type_name=u'ListClustersResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a cluster within an instance.

      Args:
        request: (Cluster) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/clusters/{clustersId}',
        http_method=u'PUT',
        method_id=u'bigtableadmin.projects.instances.clusters.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='<request>',
        request_type_name=u'Cluster',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsInstancesTablesService(base_api.BaseApiService):
    """Service class for the projects_instances_tables resource."""

    _NAME = u'projects_instances_tables'

    def __init__(self, client):
      super(BigtableadminV2.ProjectsInstancesTablesService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckConsistency(self, request, global_params=None):
      r"""Checks replication consistency based on a consistency token, that is, if.
replication has caught up based on the conditions specified in the token
and the check request.

      Args:
        request: (BigtableadminProjectsInstancesTablesCheckConsistencyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckConsistencyResponse) The response message.
      """
      config = self.GetMethodConfig('CheckConsistency')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckConsistency.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}:checkConsistency',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.checkConsistency',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:checkConsistency',
        request_field=u'checkConsistencyRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesCheckConsistencyRequest',
        response_type_name=u'CheckConsistencyResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new table in the specified instance.
The table can be created with a full set of initial column families,
specified in the request.

      Args:
        request: (BigtableadminProjectsInstancesTablesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Table) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/tables',
        request_field=u'createTableRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesCreateRequest',
        response_type_name=u'Table',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Permanently deletes a specified table and all of its data.

      Args:
        request: (BigtableadminProjectsInstancesTablesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}',
        http_method=u'DELETE',
        method_id=u'bigtableadmin.projects.instances.tables.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesTablesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def DropRowRange(self, request, global_params=None):
      r"""Permanently drop/delete a row range from a specified table. The request can.
specify whether to delete all rows in a table, or only those that match a
particular prefix.

      Args:
        request: (BigtableadminProjectsInstancesTablesDropRowRangeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('DropRowRange')
      return self._RunMethod(
          config, request, global_params=global_params)

    DropRowRange.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}:dropRowRange',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.dropRowRange',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:dropRowRange',
        request_field=u'dropRowRangeRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesDropRowRangeRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def GenerateConsistencyToken(self, request, global_params=None):
      r"""Generates a consistency token for a Table, which can be used in.
CheckConsistency to check whether mutations to the table that finished
before this call started have been replicated. The tokens will be available
for 90 days.

      Args:
        request: (BigtableadminProjectsInstancesTablesGenerateConsistencyTokenRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateConsistencyTokenResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateConsistencyToken')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateConsistencyToken.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}:generateConsistencyToken',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.generateConsistencyToken',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:generateConsistencyToken',
        request_field=u'generateConsistencyTokenRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesGenerateConsistencyTokenRequest',
        response_type_name=u'GenerateConsistencyTokenResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets metadata information about the specified table.

      Args:
        request: (BigtableadminProjectsInstancesTablesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Table) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.tables.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'view'],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesTablesGetRequest',
        response_type_name=u'Table',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a Table resource.
Returns an empty policy if the resource exists but does not have a policy
set.

      Args:
        request: (BigtableadminProjectsInstancesTablesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all tables served from a specified instance.

      Args:
        request: (BigtableadminProjectsInstancesTablesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTablesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.tables.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken', u'view'],
        relative_path=u'v2/{+parent}/tables',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesTablesListRequest',
        response_type_name=u'ListTablesResponse',
        supports_download=False,
    )

    def ModifyColumnFamilies(self, request, global_params=None):
      r"""Performs a series of column family modifications on the specified table.
Either all or none of the modifications will occur before this method
returns, but data requests received prior to that point may see a table
where only some modifications have taken effect.

      Args:
        request: (BigtableadminProjectsInstancesTablesModifyColumnFamiliesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Table) The response message.
      """
      config = self.GetMethodConfig('ModifyColumnFamilies')
      return self._RunMethod(
          config, request, global_params=global_params)

    ModifyColumnFamilies.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}:modifyColumnFamilies',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.modifyColumnFamilies',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}:modifyColumnFamilies',
        request_field=u'modifyColumnFamiliesRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesModifyColumnFamiliesRequest',
        response_type_name=u'Table',
        supports_download=False,
    )

    def Restore(self, request, global_params=None):
      r"""Create a new table by restoring from a completed backup. The new table.
must be in the same instance as the instance containing the backup.  The
returned table long-running operation can
be used to track the progress of the operation, and to cancel it.  The
metadata field type is
RestoreTableMetadata.  The
response type is
Table, if successful.

      Args:
        request: (BigtableadminProjectsInstancesTablesRestoreRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Restore')
      return self._RunMethod(
          config, request, global_params=global_params)

    Restore.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables:restore',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.restore',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/tables:restore',
        request_field=u'restoreTableRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesRestoreRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on a Table resource.
Replaces any existing policy.

      Args:
        request: (BigtableadminProjectsInstancesTablesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified table resource.

      Args:
        request: (BigtableadminProjectsInstancesTablesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}/tables/{tablesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.tables.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'BigtableadminProjectsInstancesTablesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsInstancesService(base_api.BaseApiService):
    """Service class for the projects_instances resource."""

    _NAME = u'projects_instances'

    def __init__(self, client):
      super(BigtableadminV2.ProjectsInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Create an instance within a project.

      Args:
        request: (CreateInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v2/{+parent}/instances',
        request_field='<request>',
        request_type_name=u'CreateInstanceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Delete an instance from a project.

      Args:
        request: (BigtableadminProjectsInstancesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}',
        http_method=u'DELETE',
        method_id=u'bigtableadmin.projects.instances.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about an instance.

      Args:
        request: (BigtableadminProjectsInstancesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Instance) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesGetRequest',
        response_type_name=u'Instance',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for an instance resource. Returns an empty.
policy if an instance exists but does not have a policy set.

      Args:
        request: (BigtableadminProjectsInstancesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'BigtableadminProjectsInstancesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about instances in a project.

      Args:
        request: (BigtableadminProjectsInstancesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInstancesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.instances.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageToken'],
        relative_path=u'v2/{+parent}/instances',
        request_field='',
        request_type_name=u'BigtableadminProjectsInstancesListRequest',
        response_type_name=u'ListInstancesResponse',
        supports_download=False,
    )

    def PartialUpdateInstance(self, request, global_params=None):
      r"""Partially updates an instance within a project. This method can modify all.
fields of an Instance and is the preferred way to update an Instance.

      Args:
        request: (BigtableadminProjectsInstancesPartialUpdateInstanceRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('PartialUpdateInstance')
      return self._RunMethod(
          config, request, global_params=global_params)

    PartialUpdateInstance.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}',
        http_method=u'PATCH',
        method_id=u'bigtableadmin.projects.instances.partialUpdateInstance',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v2/{+name}',
        request_field=u'instance',
        request_type_name=u'BigtableadminProjectsInstancesPartialUpdateInstanceRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on an instance resource. Replaces any.
existing policy.

      Args:
        request: (BigtableadminProjectsInstancesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'BigtableadminProjectsInstancesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that the caller has on the specified instance resource.

      Args:
        request: (BigtableadminProjectsInstancesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'bigtableadmin.projects.instances.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'BigtableadminProjectsInstancesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an instance within a project. This method updates only the display.
name and type for an Instance. To update other Instance properties, such as
labels, use PartialUpdateInstance.

      Args:
        request: (Instance) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Instance) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/instances/{instancesId}',
        http_method=u'PUT',
        method_id=u'bigtableadmin.projects.instances.update',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='<request>',
        request_type_name=u'Instance',
        response_type_name=u'Instance',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = u'projects_locations'

    def __init__(self, client):
      super(BigtableadminV2.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (BigtableadminProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations/{locationsId}',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.locations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v2/{+name}',
        request_field='',
        request_type_name=u'BigtableadminProjectsLocationsGetRequest',
        response_type_name=u'Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (BigtableadminProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v2/projects/{projectsId}/locations',
        http_method=u'GET',
        method_id=u'bigtableadmin.projects.locations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v2/{+name}/locations',
        request_field='',
        request_type_name=u'BigtableadminProjectsLocationsListRequest',
        response_type_name=u'ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(BigtableadminV2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
