/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Properties;

final class PropertyCacheFile {
    private static final String CONFIG_HASH_KEY = "configuration*?";
    private final String mDetailsFile;
    private final Properties mDetails = new Properties();
    private static char[] sHexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int MASK_0X0F = 15;
    private static final int SHIFT_4 = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertyCacheFile(Configuration aCurrentConfig, String aFileName) {
        boolean setInActive = true;
        String fileName = aFileName;
        if (fileName != null) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(fileName);
                this.mDetails.load(inStream);
                String cachedConfigHash = this.mDetails.getProperty(CONFIG_HASH_KEY);
                String currentConfigHash = this.getConfigHashCode(aCurrentConfig);
                setInActive = false;
                if (cachedConfigHash == null || !cachedConfigHash.equals(currentConfigHash)) {
                    this.mDetails.clear();
                    this.mDetails.put(CONFIG_HASH_KEY, currentConfigHash);
                }
            }
            catch (FileNotFoundException e) {
                setInActive = false;
            }
            catch (IOException e) {
                System.out.println("Unable to open cache file, ignoring.");
                e.printStackTrace(System.out);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Unable to close cache file.");
                        ex.printStackTrace(System.out);
                    }
                }
            }
        }
        this.mDetailsFile = setInActive ? null : fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        if (this.mDetailsFile != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.mDetailsFile);
                this.mDetails.store(out, null);
            }
            catch (IOException e) {
                System.out.println("Unable to save cache file");
                e.printStackTrace(System.out);
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Unable to close cache file");
                        ex.printStackTrace(System.out);
                    }
                }
            }
        }
    }

    boolean alreadyChecked(String aFileName, long aTimestamp) {
        String lastChecked = this.mDetails.getProperty(aFileName);
        return lastChecked != null && lastChecked.equals(Long.toString(aTimestamp));
    }

    void checkedOk(String aFileName, long aTimestamp) {
        this.mDetails.put(aFileName, Long.toString(aTimestamp));
    }

    private String getConfigHashCode(Serializable aConfiguration) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(aConfiguration);
            oos.flush();
            oos.close();
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(baos.toByteArray());
            return PropertyCacheFile.hexEncode(md.digest());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "ALWAYS FRESH: " + System.currentTimeMillis();
        }
    }

    private static String hexEncode(byte[] aByteArray) {
        StringBuffer buf = new StringBuffer(2 * aByteArray.length);
        int i = 0;
        while (i < aByteArray.length) {
            byte b = aByteArray[i];
            int low = b & 0xF;
            int high = b >> 4 & 0xF;
            buf.append(sHexChars[high]);
            buf.append(sHexChars[low]);
            ++i;
        }
        return buf.toString();
    }
}

