"""Generated client library for pubsublite version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.pubsublite.v1 import pubsublite_v1_messages as messages


class PubsubliteV1(base_api.BaseApiClient):
  """Generated client library for service pubsublite version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://pubsublite.googleapis.com/'
  MTLS_BASE_URL = u'https://pubsublite.mtls.googleapis.com/'

  _PACKAGE = u'pubsublite'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = u'google-cloud-sdk'
  _CLIENT_CLASS_NAME = u'PubsubliteV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new pubsublite handle."""
    url = url or self.BASE_URL
    super(PubsubliteV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.admin_projects_locations_subscriptions = self.AdminProjectsLocationsSubscriptionsService(self)
    self.admin_projects_locations_topics_subscriptions = self.AdminProjectsLocationsTopicsSubscriptionsService(self)
    self.admin_projects_locations_topics = self.AdminProjectsLocationsTopicsService(self)
    self.admin_projects_locations = self.AdminProjectsLocationsService(self)
    self.admin_projects = self.AdminProjectsService(self)
    self.admin = self.AdminService(self)
    self.cursor_projects_locations_subscriptions_cursors = self.CursorProjectsLocationsSubscriptionsCursorsService(self)
    self.cursor_projects_locations_subscriptions = self.CursorProjectsLocationsSubscriptionsService(self)
    self.cursor_projects_locations = self.CursorProjectsLocationsService(self)
    self.cursor_projects = self.CursorProjectsService(self)
    self.cursor = self.CursorService(self)

  class AdminProjectsLocationsSubscriptionsService(base_api.BaseApiService):
    """Service class for the admin_projects_locations_subscriptions resource."""

    _NAME = u'admin_projects_locations_subscriptions'

    def __init__(self, client):
      super(PubsubliteV1.AdminProjectsLocationsSubscriptionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new subscription.

      Args:
        request: (PubsubliteAdminProjectsLocationsSubscriptionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Subscription) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/subscriptions',
        http_method=u'POST',
        method_id=u'pubsublite.admin.projects.locations.subscriptions.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'subscriptionId'],
        relative_path=u'v1/admin/{+parent}/subscriptions',
        request_field=u'subscription',
        request_type_name=u'PubsubliteAdminProjectsLocationsSubscriptionsCreateRequest',
        response_type_name=u'Subscription',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified subscription.

      Args:
        request: (PubsubliteAdminProjectsLocationsSubscriptionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/subscriptions/{subscriptionsId}',
        http_method=u'DELETE',
        method_id=u'pubsublite.admin.projects.locations.subscriptions.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/admin/{+name}',
        request_field='',
        request_type_name=u'PubsubliteAdminProjectsLocationsSubscriptionsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the subscription configuration.

      Args:
        request: (PubsubliteAdminProjectsLocationsSubscriptionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Subscription) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/subscriptions/{subscriptionsId}',
        http_method=u'GET',
        method_id=u'pubsublite.admin.projects.locations.subscriptions.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/admin/{+name}',
        request_field='',
        request_type_name=u'PubsubliteAdminProjectsLocationsSubscriptionsGetRequest',
        response_type_name=u'Subscription',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of subscriptions for the given project.

      Args:
        request: (PubsubliteAdminProjectsLocationsSubscriptionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSubscriptionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/subscriptions',
        http_method=u'GET',
        method_id=u'pubsublite.admin.projects.locations.subscriptions.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/admin/{+parent}/subscriptions',
        request_field='',
        request_type_name=u'PubsubliteAdminProjectsLocationsSubscriptionsListRequest',
        response_type_name=u'ListSubscriptionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates properties of the specified subscription.

      Args:
        request: (PubsubliteAdminProjectsLocationsSubscriptionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Subscription) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/subscriptions/{subscriptionsId}',
        http_method=u'PATCH',
        method_id=u'pubsublite.admin.projects.locations.subscriptions.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1/admin/{+name}',
        request_field=u'subscription',
        request_type_name=u'PubsubliteAdminProjectsLocationsSubscriptionsPatchRequest',
        response_type_name=u'Subscription',
        supports_download=False,
    )

  class AdminProjectsLocationsTopicsSubscriptionsService(base_api.BaseApiService):
    """Service class for the admin_projects_locations_topics_subscriptions resource."""

    _NAME = u'admin_projects_locations_topics_subscriptions'

    def __init__(self, client):
      super(PubsubliteV1.AdminProjectsLocationsTopicsSubscriptionsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the subscriptions attached to the specified topic.

      Args:
        request: (PubsubliteAdminProjectsLocationsTopicsSubscriptionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTopicSubscriptionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/topics/{topicsId}/subscriptions',
        http_method=u'GET',
        method_id=u'pubsublite.admin.projects.locations.topics.subscriptions.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/admin/{+name}/subscriptions',
        request_field='',
        request_type_name=u'PubsubliteAdminProjectsLocationsTopicsSubscriptionsListRequest',
        response_type_name=u'ListTopicSubscriptionsResponse',
        supports_download=False,
    )

  class AdminProjectsLocationsTopicsService(base_api.BaseApiService):
    """Service class for the admin_projects_locations_topics resource."""

    _NAME = u'admin_projects_locations_topics'

    def __init__(self, client):
      super(PubsubliteV1.AdminProjectsLocationsTopicsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new topic.

      Args:
        request: (PubsubliteAdminProjectsLocationsTopicsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Topic) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/topics',
        http_method=u'POST',
        method_id=u'pubsublite.admin.projects.locations.topics.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'topicId'],
        relative_path=u'v1/admin/{+parent}/topics',
        request_field=u'topic',
        request_type_name=u'PubsubliteAdminProjectsLocationsTopicsCreateRequest',
        response_type_name=u'Topic',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the specified topic.

      Args:
        request: (PubsubliteAdminProjectsLocationsTopicsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/topics/{topicsId}',
        http_method=u'DELETE',
        method_id=u'pubsublite.admin.projects.locations.topics.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/admin/{+name}',
        request_field='',
        request_type_name=u'PubsubliteAdminProjectsLocationsTopicsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the topic configuration.

      Args:
        request: (PubsubliteAdminProjectsLocationsTopicsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Topic) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/topics/{topicsId}',
        http_method=u'GET',
        method_id=u'pubsublite.admin.projects.locations.topics.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/admin/{+name}',
        request_field='',
        request_type_name=u'PubsubliteAdminProjectsLocationsTopicsGetRequest',
        response_type_name=u'Topic',
        supports_download=False,
    )

    def GetPartitions(self, request, global_params=None):
      r"""Returns the partition information for the requested topic.

      Args:
        request: (PubsubliteAdminProjectsLocationsTopicsGetPartitionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TopicPartitions) The response message.
      """
      config = self.GetMethodConfig('GetPartitions')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetPartitions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/topics/{topicsId}/partitions',
        http_method=u'GET',
        method_id=u'pubsublite.admin.projects.locations.topics.getPartitions',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/admin/{+name}/partitions',
        request_field='',
        request_type_name=u'PubsubliteAdminProjectsLocationsTopicsGetPartitionsRequest',
        response_type_name=u'TopicPartitions',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Returns the list of topics for the given project.

      Args:
        request: (PubsubliteAdminProjectsLocationsTopicsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTopicsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/topics',
        http_method=u'GET',
        method_id=u'pubsublite.admin.projects.locations.topics.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/admin/{+parent}/topics',
        request_field='',
        request_type_name=u'PubsubliteAdminProjectsLocationsTopicsListRequest',
        response_type_name=u'ListTopicsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates properties of the specified topic.

      Args:
        request: (PubsubliteAdminProjectsLocationsTopicsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Topic) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/admin/projects/{projectsId}/locations/{locationsId}/topics/{topicsId}',
        http_method=u'PATCH',
        method_id=u'pubsublite.admin.projects.locations.topics.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1/admin/{+name}',
        request_field=u'topic',
        request_type_name=u'PubsubliteAdminProjectsLocationsTopicsPatchRequest',
        response_type_name=u'Topic',
        supports_download=False,
    )

  class AdminProjectsLocationsService(base_api.BaseApiService):
    """Service class for the admin_projects_locations resource."""

    _NAME = u'admin_projects_locations'

    def __init__(self, client):
      super(PubsubliteV1.AdminProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class AdminProjectsService(base_api.BaseApiService):
    """Service class for the admin_projects resource."""

    _NAME = u'admin_projects'

    def __init__(self, client):
      super(PubsubliteV1.AdminProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class AdminService(base_api.BaseApiService):
    """Service class for the admin resource."""

    _NAME = u'admin'

    def __init__(self, client):
      super(PubsubliteV1.AdminService, self).__init__(client)
      self._upload_configs = {
          }

  class CursorProjectsLocationsSubscriptionsCursorsService(base_api.BaseApiService):
    """Service class for the cursor_projects_locations_subscriptions_cursors resource."""

    _NAME = u'cursor_projects_locations_subscriptions_cursors'

    def __init__(self, client):
      super(PubsubliteV1.CursorProjectsLocationsSubscriptionsCursorsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Returns all committed cursor information for a subscription.

      Args:
        request: (PubsubliteCursorProjectsLocationsSubscriptionsCursorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListPartitionCursorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/cursor/projects/{projectsId}/locations/{locationsId}/subscriptions/{subscriptionsId}/cursors',
        http_method=u'GET',
        method_id=u'pubsublite.cursor.projects.locations.subscriptions.cursors.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1/cursor/{+parent}/cursors',
        request_field='',
        request_type_name=u'PubsubliteCursorProjectsLocationsSubscriptionsCursorsListRequest',
        response_type_name=u'ListPartitionCursorsResponse',
        supports_download=False,
    )

  class CursorProjectsLocationsSubscriptionsService(base_api.BaseApiService):
    """Service class for the cursor_projects_locations_subscriptions resource."""

    _NAME = u'cursor_projects_locations_subscriptions'

    def __init__(self, client):
      super(PubsubliteV1.CursorProjectsLocationsSubscriptionsService, self).__init__(client)
      self._upload_configs = {
          }

  class CursorProjectsLocationsService(base_api.BaseApiService):
    """Service class for the cursor_projects_locations resource."""

    _NAME = u'cursor_projects_locations'

    def __init__(self, client):
      super(PubsubliteV1.CursorProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

  class CursorProjectsService(base_api.BaseApiService):
    """Service class for the cursor_projects resource."""

    _NAME = u'cursor_projects'

    def __init__(self, client):
      super(PubsubliteV1.CursorProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class CursorService(base_api.BaseApiService):
    """Service class for the cursor resource."""

    _NAME = u'cursor'

    def __init__(self, client):
      super(PubsubliteV1.CursorService, self).__init__(client)
      self._upload_configs = {
          }
