(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/actor/rpc/connection#rpc-server-connection
    (lambda (_rpc-server206415_
             _actors206416_
             _sock206417_
             _sa206418_
             _cliaddr206419_
             _proto-e206420_)
      (with-exception-catcher
       (lambda (_g206421206423_)
         (if '#t
             (let ((_e206426_ _g206421206423_))
               (std/actor/rpc/connection#rpc-connection-cleanup
                _rpc-server206415_
                _e206426_
                _sock206417_))
             (raise _g206421206423_)))
       (lambda ()
         (std/actor/rpc/connection#rpc-set-nodelay!
          _sock206417_
          (std/os/_socket#sockaddr_family _sa206418_))
         (std/actor/rpc/connection#rpc-connection-loop
          _rpc-server206415_
          _actors206416_
          _sock206417_
          _cliaddr206419_
          _proto-e206420_)))))
  (define std/actor/rpc/connection#rpc-client-connection
    (lambda (_rpc-server206398_ _actors206399_ _address206400_ _proto-e206401_)
      (with-exception-catcher
       (lambda (_g206402206404_)
         (if '#t
             (let ((_e206407_ _g206402206404_))
               (std/actor/rpc/connection#rpc-connection-cleanup
                _rpc-server206398_
                _e206407_
                '#f))
             (raise _g206402206404_)))
       (lambda ()
         (let* ((_sa206410_ (std/os/socket#socket-address _address206400_))
                (_cli206412_
                 (std/net/socket/api#ssocket-connect__0 _sa206410_)))
           (std/actor/rpc/connection#rpc-set-nodelay!
            _cli206412_
            (std/os/_socket#sockaddr_family _sa206410_))
           (std/actor/rpc/connection#rpc-connection-loop
            _rpc-server206398_
            _actors206399_
            _cli206412_
            _address206400_
            _proto-e206401_))))))
  (define std/actor/rpc/connection#rpc-set-nodelay!
    (lambda (_sock206392_ _safamily206393_)
      (if (or (eq? _safamily206393_ std/os/_socket#AF_INET)
              (eq? _safamily206393_ std/os/_socket#AF_INET6))
          (std/os/socket#socket-setsockopt
           (##direct-structure-ref
            _sock206392_
            '1
            std/net/socket/base#!socket::t
            '#f)
           std/os/_socket#IPPROTO_TCP
           std/os/_socket#TCP_NODELAY
           '1)
          '#!void)))
  (define std/actor/rpc/connection#rpc-keep-alive '60)
  (define std/actor/rpc/connection#set-rpc-keep-alive-interval!
    (lambda (_dt206387_)
      (if (or (not _dt206387_) (and (real? _dt206387_) (positive? _dt206387_)))
          (set! std/actor/rpc/connection#rpc-keep-alive _dt206387_)
          (error '"bad keep-alive; expected positive real or #f" _dt206387_))))
  (define std/actor/rpc/connection#rpc-idle-timeout '#f)
  (define std/actor/rpc/connection#set-rpc-idle-timeout!
    (lambda (_dt206382_)
      (if (or (not _dt206382_) (and (real? _dt206382_) (positive? _dt206382_)))
          (set! std/actor/rpc/connection#rpc-idle-timeout _dt206382_)
          (error '"bad idle interval; expected positive real or #f"
                 _dt206382_))))
  (define std/actor/rpc/connection#rpc-call-timeout '60)
  (define std/actor/rpc/connection#set-rpc-call-timeout!
    (lambda (_dt206380_)
      (if (and (real? _dt206380_) (positive? _dt206380_) (finite? _dt206380_))
          (set! std/actor/rpc/connection#rpc-call-timeout _dt206380_)
          (if (not _dt206380_)
              (set! std/actor/rpc/connection#rpc-call-timeout '#f)
              (error '"bad timeout; expected finite positive real or #f"
                     _dt206380_)))))
  (define std/actor/rpc/connection#continuation-table::t
    (make-struct-type
     'std/actor/rpc/connection#continuation-table::t
     '#f
     '6
     'continuation-table
     '((final: . #t))
     ':init!
     '(mx continuations
          stream-continuations
          stream-actors
          timeouts
          continuation-timeouts)))
  (define std/actor/rpc/connection#continuation-table?
    (make-struct-predicate std/actor/rpc/connection#continuation-table::t))
  (define std/actor/rpc/connection#make-continuation-table
    (lambda _$args206377_
      (apply make-struct-instance
             std/actor/rpc/connection#continuation-table::t
             _$args206377_)))
  (define std/actor/rpc/connection#continuation-table-mx
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '0))
  (define std/actor/rpc/connection#continuation-table-continuations
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '1))
  (define std/actor/rpc/connection#continuation-table-stream-continuations
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '2))
  (define std/actor/rpc/connection#continuation-table-stream-actors
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '3))
  (define std/actor/rpc/connection#continuation-table-timeouts
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '4))
  (define std/actor/rpc/connection#continuation-table-continuation-timeouts
    (make-struct-field-accessor
     std/actor/rpc/connection#continuation-table::t
     '5))
  (define std/actor/rpc/connection#continuation-table-mx-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '0))
  (define std/actor/rpc/connection#continuation-table-continuations-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '1))
  (define std/actor/rpc/connection#continuation-table-stream-continuations-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '2))
  (define std/actor/rpc/connection#continuation-table-stream-actors-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '3))
  (define std/actor/rpc/connection#continuation-table-timeouts-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '4))
  (define std/actor/rpc/connection#continuation-table-continuation-timeouts-set!
    (make-struct-field-mutator
     std/actor/rpc/connection#continuation-table::t
     '5))
  (define std/actor/rpc/connection#&continuation-table-mx
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '0))
  (define std/actor/rpc/connection#&continuation-table-continuations
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '1))
  (define std/actor/rpc/connection#&continuation-table-stream-continuations
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '2))
  (define std/actor/rpc/connection#&continuation-table-stream-actors
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '3))
  (define std/actor/rpc/connection#&continuation-table-timeouts
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '4))
  (define std/actor/rpc/connection#&continuation-table-continuation-timeouts
    (make-struct-field-unchecked-accessor
     std/actor/rpc/connection#continuation-table::t
     '5))
  (define std/actor/rpc/connection#&continuation-table-mx-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '0))
  (define std/actor/rpc/connection#&continuation-table-continuations-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '1))
  (define std/actor/rpc/connection#&continuation-table-stream-continuations-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '2))
  (define std/actor/rpc/connection#&continuation-table-stream-actors-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '3))
  (define std/actor/rpc/connection#&continuation-table-timeouts-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '4))
  (define std/actor/rpc/connection#&continuation-table-continuation-timeouts-set!
    (make-struct-field-unchecked-mutator
     std/actor/rpc/connection#continuation-table::t
     '5))
  (define std/actor/rpc/connection#continuation-table:::init!
    (lambda (_self206375_)
      (if (##fx< '6 (##vector-length _self206375_))
          (begin
            (##vector-set! _self206375_ '1 (make-mutex 'continuation-table))
            (##vector-set! _self206375_ '2 (make-table 'test: eqv?))
            (##vector-set! _self206375_ '3 (make-table 'test: eq?))
            (##vector-set! _self206375_ '4 (make-table 'test: eqv?))
            (##vector-set! _self206375_ '5 (make-table 'test: eq?))
            (##vector-set! _self206375_ '6 (make-table 'test: eqv?)))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self206375_))))
  (bind-method!
   std/actor/rpc/connection#continuation-table::t
   ':init!
   std/actor/rpc/connection#continuation-table:::init!
   '#f)
  (define std/actor/rpc/connection#continuation-table-get
    (lambda (_cont-table206242_ _cont206243_)
      (let ((_mx206245_
             (##unchecked-structure-ref
              _cont-table206242_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx206245_)
        (let ((_res206250_
               (let ((_ct206248_
                      (##unchecked-structure-ref
                       _cont-table206242_
                       '2
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-ref _ct206248_ _cont206243_ '#f))))
          (mutex-unlock! _mx206245_)
          _res206250_))))
  (define std/actor/rpc/connection#continuation-table-remove!
    (lambda (_cont-table206180_ _cont206181_)
      (let ((_mx206183_
             (##unchecked-structure-ref
              _cont-table206180_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx206183_)
        (let ((_res206239_
               (let* ((_ct206186_
                       (##unchecked-structure-ref
                        _cont-table206180_
                        '2
                        std/actor/rpc/connection#continuation-table::t
                        '#f))
                      (_continuation206187206189_
                       (table-ref _ct206186_ _cont206181_ '#f)))
                 (if _continuation206187206189_
                     (let ((_continuation206192_ _continuation206187206189_))
                       (table-set! _ct206186_ _cont206181_)
                       (let* ((_continuation206193206202_ _continuation206192_)
                              (_E206195206206_
                               (lambda ()
                                 (error '"No clause matching"
                                        _continuation206193206202_)))
                              (_K206196206212_
                               (lambda (_stream?206209_ _k206210_)
                                 (if _stream?206209_
                                     (table-set!
                                      (##unchecked-structure-ref
                                       _cont-table206180_
                                       '3
                                       std/actor/rpc/connection#continuation-table::t
                                       '#f)
                                      _k206210_)
                                     '#!void))))
                         (if (##fx= (if (##values? _continuation206193206202_)
                                        (##vector-length
                                         _continuation206193206202_)
                                        '1)
                                    '4)
                             (let* ((_e206197206215_
                                     (##vector-ref
                                      _continuation206193206202_
                                      '0))
                                    (_e206198206218_
                                     (##vector-ref
                                      _continuation206193206202_
                                      '1))
                                    (_e206199206221_
                                     (##vector-ref
                                      _continuation206193206202_
                                      '2))
                                    (_k206224_ _e206199206221_)
                                    (_e206200206226_
                                     (##vector-ref
                                      _continuation206193206202_
                                      '3))
                                    (_stream?206229_ _e206200206226_))
                               (_K206196206212_ _stream?206229_ _k206224_))
                             (_E206195206206_)))
                       (let* ((_tt206231_
                               (##unchecked-structure-ref
                                _cont-table206180_
                                '6
                                std/actor/rpc/connection#continuation-table::t
                                '#f))
                              (_timeo206232206234_
                               (table-ref _tt206231_ _cont206181_ '#f)))
                         (if _timeo206232206234_
                             (let ((_timeo206237_ _timeo206232206234_))
                               (table-set! _tt206231_ _cont206181_)
                               (table-set!
                                (##unchecked-structure-ref
                                 _cont-table206180_
                                 '5
                                 std/actor/rpc/connection#continuation-table::t
                                 '#f)
                                _timeo206237_))
                             '#f))
                       _continuation206192_)
                     '#f))))
          (mutex-unlock! _mx206183_)
          _res206239_))))
  (define std/actor/rpc/connection#continuation-table-get-stream-actor
    (lambda (_cont-table206169_ _cont206170_)
      (let ((_mx206172_
             (##unchecked-structure-ref
              _cont-table206169_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx206172_)
        (let ((_res206177_
               (let ((_st206175_
                      (##unchecked-structure-ref
                       _cont-table206169_
                       '4
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-ref _st206175_ _cont206170_ '#f))))
          (mutex-unlock! _mx206172_)
          _res206177_))))
  (define std/actor/rpc/connection#continuation-table-put-stream-actor!
    (lambda (_cont-table206157_ _cont206158_ _val206159_)
      (let ((_mx206161_
             (##unchecked-structure-ref
              _cont-table206157_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx206161_)
        (let ((_res206166_
               (let ((_st206164_
                      (##unchecked-structure-ref
                       _cont-table206157_
                       '4
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-set! _st206164_ _cont206158_ _val206159_))))
          (mutex-unlock! _mx206161_)
          _res206166_))))
  (define std/actor/rpc/connection#continuation-table-remove-stream-actor!
    (lambda (_cont-table206146_ _cont206147_)
      (let ((_mx206149_
             (##unchecked-structure-ref
              _cont-table206146_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx206149_)
        (let ((_res206154_
               (let ((_st206152_
                      (##unchecked-structure-ref
                       _cont-table206146_
                       '4
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-set! _st206152_ _cont206147_))))
          (mutex-unlock! _mx206149_)
          _res206154_))))
  (define std/actor/rpc/connection#continuation-table-get-stream-cont
    (lambda (_cont-table206135_ _k206136_)
      (let ((_mx206138_
             (##unchecked-structure-ref
              _cont-table206135_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx206138_)
        (let ((_res206143_
               (let ((_sct206141_
                      (##unchecked-structure-ref
                       _cont-table206135_
                       '3
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-ref _sct206141_ _k206136_ '#f))))
          (mutex-unlock! _mx206138_)
          _res206143_))))
  (define std/actor/rpc/connection#continuation-table-get-timeout
    (lambda (_cont-table206124_ _timeo206125_)
      (let ((_mx206127_
             (##unchecked-structure-ref
              _cont-table206124_
              '1
              std/actor/rpc/connection#continuation-table::t
              '#f)))
        (mutex-lock! _mx206127_)
        (let ((_res206132_
               (let ((_tt206130_
                      (##unchecked-structure-ref
                       _cont-table206124_
                       '5
                       std/actor/rpc/connection#continuation-table::t
                       '#f)))
                 (table-ref _tt206130_ _timeo206125_ '#f))))
          (mutex-unlock! _mx206127_)
          _res206132_))))
  (define std/actor/rpc/connection#continuation-table-dump!__%
    (lambda (_cont-table205998_ _port205999_)
      (call-with-parameters
       (lambda ()
         (let ((_mx206002_
                (##unchecked-structure-ref
                 _cont-table205998_
                 '1
                 std/actor/rpc/connection#continuation-table::t
                 '#f)))
           (mutex-lock! _mx206002_)
           (let* ((_cont-table206004206015_ _cont-table205998_)
                  (_E206006206019_
                   (lambda ()
                     (error '"No clause matching" _cont-table206004206015_)))
                  (_K206007206083_
                   (lambda (_ctmos206022_
                            _tmos206023_
                            _sactors206024_
                            _sconts206025_
                            _conts206026_)
                     (displayln
                      '"continuations: "
                      (table-length _conts206026_))
                     (table-for-each
                      (lambda (_wire-id206028_ _continuation206029_)
                        (let* ((_continuation206030206039_
                                _continuation206029_)
                               (_E206032206043_
                                (lambda ()
                                  (error '"No clause matching"
                                         _continuation206030206039_)))
                               (_K206033206051_
                                (lambda (_stream?206046_
                                         _k206047_
                                         _proto206048_
                                         _actor206049_)
                                  (displayln
                                   _wire-id206028_
                                   '" -> "
                                   (cons _actor206049_
                                         (cons _proto206048_
                                               (cons _k206047_
                                                     (cons _stream?206046_
                                                           '()))))))))
                          (if (##fx= (if (##values? _continuation206030206039_)
                                         (##vector-length
                                          _continuation206030206039_)
                                         '1)
                                     '4)
                              (let* ((_e206034206054_
                                      (##vector-ref
                                       _continuation206030206039_
                                       '0))
                                     (_actor206057_ _e206034206054_)
                                     (_e206035206059_
                                      (##vector-ref
                                       _continuation206030206039_
                                       '1))
                                     (_proto206062_ _e206035206059_)
                                     (_e206036206064_
                                      (##vector-ref
                                       _continuation206030206039_
                                       '2))
                                     (_k206067_ _e206036206064_)
                                     (_e206037206069_
                                      (##vector-ref
                                       _continuation206030206039_
                                       '3))
                                     (_stream?206072_ _e206037206069_))
                                (_K206033206051_
                                 _stream?206072_
                                 _k206067_
                                 _proto206062_
                                 _actor206057_))
                              (_E206032206043_))))
                      _conts206026_)
                     (displayln
                      '"stream-continuations: "
                      (table-length _sconts206025_))
                     (table-for-each
                      (lambda (_k206074_ _wire-id206075_)
                        (displayln _k206074_ '" -> " _wire-id206075_))
                      _sconts206025_)
                     (displayln
                      '"stream-actors: "
                      (table-length _sactors206024_))
                     (table-for-each
                      (lambda (_wire-id206077_ _sactor206078_)
                        (displayln _wire-id206077_ '" -> " _sactor206078_))
                      _sactors206024_)
                     (displayln '"timeouts: " (table-length _tmos206023_))
                     (table-for-each
                      (lambda (_tmo206080_ _wire-id206081_)
                        (displayln
                         (time->seconds _tmo206080_)
                         '" -> "
                         _wire-id206081_))
                      _tmos206023_))))
             (if (##structure-direct-instance-of?
                  _cont-table206004206015_
                  'std/actor/rpc/connection#continuation-table::t)
                 (let* ((_e206008206086_
                         (##vector-ref _cont-table206004206015_ '1))
                        (_e206009206089_
                         (##vector-ref _cont-table206004206015_ '2))
                        (_conts206092_ _e206009206089_)
                        (_e206010206094_
                         (##vector-ref _cont-table206004206015_ '3))
                        (_sconts206097_ _e206010206094_)
                        (_e206011206099_
                         (##vector-ref _cont-table206004206015_ '4))
                        (_sactors206102_ _e206011206099_)
                        (_e206012206104_
                         (##vector-ref _cont-table206004206015_ '5))
                        (_tmos206107_ _e206012206104_)
                        (_e206013206109_
                         (##vector-ref _cont-table206004206015_ '6))
                        (_ctmos206112_ _e206013206109_))
                   (_K206007206083_
                    _ctmos206112_
                    _tmos206107_
                    _sactors206102_
                    _sconts206097_
                    _conts206092_))
                 (_E206006206019_)))
           (mutex-unlock! _mx206002_)))
       current-output-port
       _port205999_)))
  (define std/actor/rpc/connection#continuation-table-dump!__0
    (lambda (_cont-table206117_)
      (let ((_port206119_ (current-error-port)))
        (std/actor/rpc/connection#continuation-table-dump!__%
         _cont-table206117_
         _port206119_))))
  (define std/actor/rpc/connection#continuation-table-dump!
    (lambda _g206623_
      (let ((_g206622_ (length _g206623_)))
        (cond ((##fx= _g206622_ 1)
               (apply std/actor/rpc/connection#continuation-table-dump!__0
                      _g206623_))
              ((##fx= _g206622_ 2)
               (apply std/actor/rpc/connection#continuation-table-dump!__%
                      _g206623_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/connection#continuation-table-dump!
                _g206623_))))))
  (define std/actor/rpc/connection#rpc-connection-loop
    (lambda (_rpc-server204948_
             _actors204949_
             _sock204950_
             _peer-address204951_
             _proto-e204952_)
      (letrec* ((_input-buffer204954_
                 (std/net/socket/buffer#open-ssocket-input-buffer__0
                  _sock204950_))
                (_output-buffer204955_
                 (std/net/socket/buffer#open-ssocket-output-buffer__0
                  _sock204950_))
                (_g206624_
                 (let ((_g206625_
                        (_proto-e204952_
                         _input-buffer204954_
                         _output-buffer204955_)))
                   (let ((_g206626_
                          (if (##values? _g206625_)
                              (##vector-length _g206625_)
                              1)))
                     (if (not (##fx= _g206626_ 2))
                         (error "Context expects 2 values" _g206626_)))
                   _g206625_))
                (_read-e204956_ (##vector-ref _g206624_ 0))
                (_write-e204957_ (##vector-ref _g206624_ 1))
                (_cont-table204958_
                 (let ((__obj206619
                        (make-object
                         std/actor/rpc/connection#continuation-table::t
                         '6)))
                   (std/actor/rpc/connection#continuation-table:::init!
                    __obj206619)
                   __obj206619))
                (_next-timeout204959_ '#f)
                (_next-continuation-id204960_ '0)
                (_next-heartbeat204961_
                 (seconds->time (+ (##current-time-point) '60)))
                (_writer204962_
                 (gerbil/gambit/threads#spawn/name
                  'rpc-connection-writer
                  std/actor/rpc/connection#rpc-connection-writer
                  _output-buffer204955_
                  _write-e204957_))
                (_reader204963_
                 (gerbil/gambit/threads#spawn/name
                  'rpc-connection-reader
                  std/actor/rpc/connection#rpc-connection-reader
                  (current-thread)
                  _peer-address204951_
                  _input-buffer204954_
                  _actors204949_
                  _cont-table204958_
                  _writer204962_
                  _read-e204956_))
                (_close-connection204964_
                 (lambda ()
                   (std/net/socket/api#ssocket-close _sock204950_)
                   (thread-send _writer204962_ 'exit)
                   (let ((_mx205915_
                          (##unchecked-structure-ref
                           _cont-table204958_
                           '1
                           std/actor/rpc/connection#continuation-table::t
                           '#f)))
                     (mutex-lock! _mx205915_)
                     (table-for-each
                      (lambda (_wire-id205918_ _cont205919_)
                        (let* ((_cont205920205929_ _cont205919_)
                               (_E205922205933_
                                (lambda ()
                                  (error '"No clause matching"
                                         _cont205920205929_)))
                               (_K205923205941_
                                (lambda (_stream?205936_
                                         _k205937_
                                         _proto205938_
                                         _actor205939_)
                                  (std/actor/message#send-message__%
                                   _actor205939_
                                   (##structure
                                    std/actor/proto#!error::t
                                    (make-struct-instance
                                     std/actor/proto#rpc-error::t
                                     'rpc
                                     '"connection error")
                                    _k205937_)
                                   '#f
                                   '#f))))
                          (if (##fx= (if (##values? _cont205920205929_)
                                         (##vector-length _cont205920205929_)
                                         '1)
                                     '4)
                              (let* ((_e205924205944_
                                      (##vector-ref _cont205920205929_ '0))
                                     (_actor205947_ _e205924205944_)
                                     (_e205925205949_
                                      (##vector-ref _cont205920205929_ '1))
                                     (_proto205952_ _e205925205949_)
                                     (_e205926205954_
                                      (##vector-ref _cont205920205929_ '2))
                                     (_k205957_ _e205926205954_)
                                     (_e205927205959_
                                      (##vector-ref _cont205920205929_ '3))
                                     (_stream?205962_ _e205927205959_))
                                (_K205923205941_
                                 _stream?205962_
                                 _k205957_
                                 _proto205952_
                                 _actor205947_))
                              (_E205922205933_))))
                      (##unchecked-structure-ref
                       _cont-table204958_
                       '2
                       std/actor/rpc/connection#continuation-table::t
                       '#f))
                     (table-for-each
                      (lambda (_wire-id205964_ _stream205965_)
                        (let* ((_stream205966205973_ _stream205965_)
                               (_E205968205977_
                                (lambda ()
                                  (error '"No clause matching"
                                         _stream205966205973_)))
                               (_K205969205985_
                                (lambda (_dest205980_ _actor205981_)
                                  (let ((_abort205983_
                                         (##structure
                                          std/actor/message#message::t
                                          (##structure
                                           std/actor/proto#!abort::t
                                           _wire-id205964_)
                                          _dest205980_
                                          _actor205981_
                                          '#f)))
                                    (std/actor/message#send__0
                                     _actor205981_
                                     _abort205983_)))))
                          (if (##pair? _stream205966205973_)
                              (let ((_hd205970205988_
                                     (##car _stream205966205973_))
                                    (_tl205971205990_
                                     (##cdr _stream205966205973_)))
                                (let* ((_actor205993_ _hd205970205988_)
                                       (_dest205995_ _tl205971205990_))
                                  (_K205969205985_
                                   _dest205995_
                                   _actor205993_)))
                              (_E205968205977_))))
                      (##unchecked-structure-ref
                       _cont-table204958_
                       '4
                       std/actor/rpc/connection#continuation-table::t
                       '#f))
                     (mutex-unlock! _mx205915_))
                   (std/actor/rpc/connection#rpc-connection-shutdown
                    _rpc-server204948_)
                   (raise 'shutdown)))
                (_write-message204965_
                 (lambda (_msg205662_)
                   (let* ((_msg205663205672_ _msg205662_)
                          (_E205665205676_
                           (lambda ()
                             (error '"No clause matching" _msg205663205672_)))
                          (_K205666205891_
                           (lambda (_opts205679_
                                    _dest205680_
                                    _src205681_
                                    _content205682_)
                             (if (##structure-direct-instance-of?
                                  _dest205680_
                                  'std/actor/proto#remote::t)
                                 (let* ((_dest205683205692_ _dest205680_)
                                        (_E205685205696_
                                         (lambda ()
                                           (error '"No clause matching"
                                                  _dest205683205692_)))
                                        (_K205686205870_
                                         (lambda (_proto205699_
                                                  _address205700_
                                                  _uuid205701_)
                                           (##direct-structure-set!
                                            _msg205662_
                                            _uuid205701_
                                            '3
                                            std/actor/message#message::t
                                            '#f)
                                           (let* ((_content205702205728_
                                                   _content205682_)
                                                  (_else205710205736_
                                                   (lambda ()
                                                     (_marshal-and-write204967_
                                                      _msg205662_
                                                      _proto205699_
                                                      '#t))))
                                             (let ((_K205724205859_
                                                    (lambda (_k205846_)
                                                      (let ((_wire-id205848_
                                                             (_next-continuation-id!204966_)))
                                                        (let ((_mx205850_
                                                               (##unchecked-structure-ref
                                                                _cont-table204958_
                                                                '1
                                                                std/actor/rpc/connection#continuation-table::t
                                                                '#f)))
                                                          (mutex-lock!
                                                           _mx205850_)
                                                          (table-set!
                                                           (##unchecked-structure-ref
                                                            _cont-table204958_
                                                            '2
                                                            std/actor/rpc/connection#continuation-table::t
                                                            '#f)
                                                           _wire-id205848_
                                                           (values _src205681_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           _proto205699_
                           _k205846_
                           '#f))
                  (let ((_timeo205852205854_
                         (std/actor/rpc/connection#rpc-options-timeout
                          _opts205679_
                          std/actor/rpc/connection#rpc-call-timeout)))
                    (if _timeo205852205854_
                        (let ((_timeo205857_ _timeo205852205854_))
                          (table-set!
                           (##unchecked-structure-ref
                            _cont-table204958_
                            '5
                            std/actor/rpc/connection#continuation-table::t
                            '#f)
                           _timeo205857_
                           _wire-id205848_)
                          (table-set!
                           (##unchecked-structure-ref
                            _cont-table204958_
                            '6
                            std/actor/rpc/connection#continuation-table::t
                            '#f)
                           _wire-id205848_
                           _timeo205857_)
                          (_set-timeout!204972_ _timeo205857_))
                        '#f))
                  (mutex-unlock! _mx205850_))
                (##direct-structure-set!
                 _content205682_
                 _wire-id205848_
                 '2
                 std/actor/proto#!call::t
                 '#f)
                (_marshal-and-write204967_ _msg205662_ _proto205699_ '#t))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (_K205721205832_
                                                    (lambda (_k205819_)
                                                      (let ((_wire-id205821_
                                                             (_next-continuation-id!204966_)))
                                                        (let ((_mx205823_
                                                               (##unchecked-structure-ref
                                                                _cont-table204958_
                                                                '1
                                                                std/actor/rpc/connection#continuation-table::t
                                                                '#f)))
                                                          (mutex-lock!
                                                           _mx205823_)
                                                          (table-set!
                                                           (##unchecked-structure-ref
                                                            _cont-table204958_
                                                            '2
                                                            std/actor/rpc/connection#continuation-table::t
                                                            '#f)
                                                           _wire-id205821_
                                                           (values _src205681_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           _proto205699_
                           _k205819_
                           '#t))
                  (table-set!
                   (##unchecked-structure-ref
                    _cont-table204958_
                    '3
                    std/actor/rpc/connection#continuation-table::t
                    '#f)
                   _k205819_
                   _wire-id205821_)
                  (let ((_timeo205825205827_
                         (std/actor/rpc/connection#rpc-options-timeout
                          _opts205679_
                          '#f)))
                    (if _timeo205825205827_
                        (let ((_timeo205830_ _timeo205825205827_))
                          (table-set!
                           (##unchecked-structure-ref
                            _cont-table204958_
                            '5
                            std/actor/rpc/connection#continuation-table::t
                            '#f)
                           _timeo205830_
                           _wire-id205821_)
                          (table-set!
                           (##unchecked-structure-ref
                            _cont-table204958_
                            '6
                            std/actor/rpc/connection#continuation-table::t
                            '#f)
                           _wire-id205821_
                           _timeo205830_)
                          (_set-timeout!204972_ _timeo205830_))
                        '#f))
                  (mutex-unlock! _mx205823_))
                (##direct-structure-set!
                 _content205682_
                 _wire-id205821_
                 '2
                 std/actor/proto#!stream::t
                 '#f)
                (_marshal-and-write204967_ _msg205662_ _proto205699_ '#t))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (_K205720205803_
                                                    (lambda ()
                                                      (_marshal-and-write204967_
                                                       _msg205662_
                                                       _proto205699_
                                                       '#t)))
                                                   (_K205718205790_
                                                    (lambda (_wire-id205788_)
                                                      (std/actor/rpc/connection#continuation-table-put-stream-actor!
                                                       _cont-table204958_
                                                       _wire-id205788_
                                                       (cons _src205681_
                                                             _dest205680_))
                                                      (_marshal-and-write204967_
                                                       _msg205662_
                                                       _proto205699_
                                                       '#t)))
                                                   (_K205716205776_
                                                    (lambda (_k205772_)
                                                      (let ((_wire-id205774_
                                                             (std/actor/rpc/connection#continuation-table-get-stream-cont
                                                              _cont-table204958_
                                                              _k205772_)))
                                                        (if _wire-id205774_
                                                            (begin
                                                              (##direct-structure-set!
                                                               _content205682_
                                                               _wire-id205774_
                                                               '1
                                                               std/actor/proto#!continue::t
                                                               '#f)
                                                              (_marshal-and-write204967_
                                                               _msg205662_
                                                               _proto205699_
                                                               '#t))
                                                            (std/logger#warning
                                                             '"bad continue; unknown stream ~a"
                                                             _k205772_)))))
                                                   (_K205714205760_
                                                    (lambda (_k205756_)
                                                      (let ((_wire-id205758_
                                                             (std/actor/rpc/connection#continuation-table-get-stream-cont
                                                              _cont-table204958_
                                                              _k205756_)))
                                                        (if _wire-id205758_
                                                            (begin
                                                              (##direct-structure-set!
                                                               _content205682_
                                                               _wire-id205758_
                                                               '1
                                                               std/actor/proto#!close::t
                                                               '#f)
                                                              (_marshal-and-write204967_
                                                               _msg205662_
                                                               _proto205699_
                                                               '#t))
                                                            (std/logger#warning
                                                             '"bad close; unknown stream ~a"
                                                             _k205756_)))))
                                                   (_K205712205744_
                                                    (lambda (_k205740_)
                                                      (let ((_wire-id205742_
                                                             (std/actor/rpc/connection#continuation-table-get-stream-cont
                                                              _cont-table204958_
                                                              _k205740_)))
                                                        (if _wire-id205742_
                                                            (begin
                                                              (##direct-structure-set!
                                                               _content205682_
                                                               _wire-id205742_
                                                               '1
                                                               std/actor/proto#!abort::t
                                                               '#f)
                                                              (std/actor/rpc/connection#continuation-table-remove!
                                                               _cont-table204958_
                                                               _wire-id205742_)
                                                              (_marshal-and-write204967_
                                                               _msg205662_
                                                               _proto205699_
                                                               '#t))
                                                            (std/logger#warning
                                                             '"bad abort; unknown stream ~a"
                                                             _k205740_))))))
                                               (let* ((_try-match205709205752_
                                                       (lambda ()
                                                         (if (##structure-direct-instance-of?
                                                              _content205702205728_
                                                              'std/actor/proto#!abort::t)
                                                             (let* ((_e205713205747_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             (##vector-ref _content205702205728_ '1))
                            (_k205750_ _e205713205747_))
                       (_K205712205744_ _k205750_))
                     (_else205710205736_))))
              (_try-match205708205768_
               (lambda ()
                 (if (##structure-direct-instance-of?
                      _content205702205728_
                      'std/actor/proto#!close::t)
                     (let* ((_e205715205763_
                             (##vector-ref _content205702205728_ '1))
                            (_k205766_ _e205715205763_))
                       (_K205714205760_ _k205766_))
                     (_try-match205709205752_))))
              (_try-match205707205784_
               (lambda ()
                 (if (##structure-direct-instance-of?
                      _content205702205728_
                      'std/actor/proto#!continue::t)
                     (let* ((_e205717205779_
                             (##vector-ref _content205702205728_ '1))
                            (_k205782_ _e205717205779_))
                       (_K205716205776_ _k205782_))
                     (_try-match205708205768_))))
              (_try-match205706205798_
               (lambda ()
                 (if (##structure-direct-instance-of?
                      _content205702205728_
                      'std/actor/proto#!sync::t)
                     (let* ((_e205719205793_
                             (##vector-ref _content205702205728_ '1))
                            (_wire-id205796_ _e205719205793_))
                       (_K205718205790_ _wire-id205796_))
                     (_try-match205707205784_))))
              (_try-match205705205815_
               (lambda ()
                 (if (or (##structure-direct-instance-of?
                          _content205702205728_
                          'std/actor/proto#!value::t)
                         (##structure-direct-instance-of?
                          _content205702205728_
                          'std/actor/proto#!yield::t)
                         (##structure-direct-instance-of?
                          _content205702205728_
                          'std/actor/proto#!error::t)
                         (##structure-direct-instance-of?
                          _content205702205728_
                          'std/actor/proto#!end::t))
                     (_K205720205803_)
                     (_try-match205706205798_))))
              (_try-match205704205843_
               (lambda ()
                 (if (##structure-direct-instance-of?
                      _content205702205728_
                      'std/actor/proto#!stream::t)
                     (let* ((_e205722205835_
                             (##vector-ref _content205702205728_ '1))
                            (_e205723205838_
                             (##vector-ref _content205702205728_ '2))
                            (_k205841_ _e205723205838_))
                       (_K205721205832_ _k205841_))
                     (_try-match205705205815_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (if (##structure-direct-instance-of?
                                                      _content205702205728_
                                                      'std/actor/proto#!call::t)
                                                     (let* ((_e205725205862_
                                                             (##vector-ref
                                                              _content205702205728_
                                                              '1))
                                                            (_e205726205865_
                                                             (##vector-ref
                                                              _content205702205728_
                                                              '2))
                                                            (_k205868_
                                                             _e205726205865_))
                                                       (_K205724205859_
                                                        _k205868_))
                                                     (_try-match205704205843_))))))))
                                   (if (##structure-direct-instance-of?
                                        _dest205683205692_
                                        'std/actor/proto#remote::t)
                                       (let* ((_e205687205873_
                                               (##vector-ref
                                                _dest205683205692_
                                                '1))
                                              (_e205688205876_
                                               (##vector-ref
                                                _dest205683205692_
                                                '2))
                                              (_uuid205879_ _e205688205876_)
                                              (_e205689205881_
                                               (##vector-ref
                                                _dest205683205692_
                                                '3))
                                              (_address205884_ _e205689205881_)
                                              (_e205690205886_
                                               (##vector-ref
                                                _dest205683205692_
                                                '4))
                                              (_proto205889_ _e205690205886_))
                                         (_K205686205870_
                                          _proto205889_
                                          _address205884_
                                          _uuid205879_))
                                       (_E205685205696_)))
                                 (std/logger#warning
                                  '"bad handle; no protocol ~a ~a"
                                  _dest205680_
                                  _msg205662_)))))
                     (if (##structure-direct-instance-of?
                          _msg205663205672_
                          'std/actor/message#message::t)
                         (let* ((_e205667205894_
                                 (##vector-ref _msg205663205672_ '1))
                                (_content205897_ _e205667205894_)
                                (_e205668205899_
                                 (##vector-ref _msg205663205672_ '2))
                                (_src205902_ _e205668205899_)
                                (_e205669205904_
                                 (##vector-ref _msg205663205672_ '3))
                                (_dest205907_ _e205669205904_)
                                (_e205670205909_
                                 (##vector-ref _msg205663205672_ '4))
                                (_opts205912_ _e205670205909_))
                           (_K205666205891_
                            _opts205912_
                            _dest205907_
                            _src205902_
                            _content205897_))
                         (_E205665205676_)))))
                (_next-continuation-id!204966_
                 (lambda ()
                   (let ((_next205660_ _next-continuation-id204960_))
                     (set! _next-continuation-id204960_ (+ _next205660_ '1))
                     _next205660_)))
                (_marshal-and-write204967_
                 (lambda (_msg205303_
                          _proto205304_
                          _dispatch-marshal-error?205305_)
                   (let ((_e205390_
                          (with-exception-catcher
                           (lambda (_g205379205381_)
                             (if ((lambda (_$obj205384_)
                                    (exception? _$obj205384_))
                                  _g205379205381_)
                                 (let ((_e205387_ _g205379205381_)) _e205387_)
                                 (raise _g205379205381_)))
                           (lambda ()
                             (std/actor/rpc/proto/message#rpc-proto-marshal-message
                              _msg205303_
                              _proto205304_)))))
                     (if (u8vector? _e205390_)
                         (if (fx<= (u8vector-length _e205390_)
                                   std/actor/rpc/proto/message#rpc-proto-message-max-length)
                             (thread-send _writer204962_ _e205390_)
                             (begin
                               (std/logger#warning
                                '"message too large; not sending %d bytes"
                                (u8vector-length _e205390_))
                               (let ((_content205392_
                                      (##direct-structure-ref
                                       _msg205303_
                                       '1
                                       std/actor/message#message::t
                                       '#f))
                                     (_dest205394_
                                      (##direct-structure-ref
                                       _msg205303_
                                       '3
                                       std/actor/message#message::t
                                       '#f)))
                                 (let* ((_content205396205412_ _content205392_)
                                        (_else205399205420_
                                         (lambda () '#!void)))
                                   (let ((_K205406205458_
                                          (lambda (_wire-id205455_ _e205456_)
                                            (_dispatch-error204968_
                                             _wire-id205455_
                                             '"message too large")))
                                         (_K205401205429_
                                          (lambda (_wire-id205424_ _e205426_)
                                            (if _dispatch-marshal-error?205305_
                                                (_dispatch-remote-error204969_
                                                 (##structure
                                                  std/actor/proto#!error::t
                                                  '"message too large"
                                                  _wire-id205424_)
                                                 _dest205394_)
                                                '#!void))))
                                     (let* ((___match206476206477_
                                             (lambda ()
                                               (if (##structure-direct-instance-of?
                                                    _content205396205412_
                                                    'std/actor/proto#!yield::t)
                                                   (let* ((_e205402205442_
                                                           (##vector-ref
                                                            _content205396205412_
                                                            '1))
                                                          (_e205403205447_
                                                           (##vector-ref
                                                            _content205396205412_
                                                            '2)))
                                                     (let ((_e205445_
                                                            _e205402205442_)
                                                           (_wire-id205450_
                                                            _e205403205447_))
                                                       (_K205401205429_
                                                        _wire-id205450_
                                                        _e205445_)))
                                                   '#!void)))
                                            (_try-match205398205452_
                                             (lambda ()
                                               (if (##structure-direct-instance-of?
                                                    _content205396205412_
                                                    'std/actor/proto#!error::t)
                                                   (let* ((_e205404205432_
                                                           (##vector-ref
                                                            _content205396205412_
                                                            '1))
                                                          (_e205405205437_
                                                           (##vector-ref
                                                            _content205396205412_
                                                            '2)))
                                                     (let ((_e205435_
                                                            _e205404205432_)
                                                           (_wire-id205440_
                                                            _e205405205437_))
                                                       (_K205401205429_
                                                        _wire-id205440_
                                                        _e205435_)))
                                                   (___match206476206477_))))
                                            (___match206462206463_
                                             (lambda ()
                                               (if (##structure-direct-instance-of?
                                                    _content205396205412_
                                                    'std/actor/proto#!stream::t)
                                                   (let* ((_e205407205471_
                                                           (##vector-ref
                                                            _content205396205412_
                                                            '1))
                                                          (_e205408205476_
                                                           (##vector-ref
                                                            _content205396205412_
                                                            '2)))
                                                     (let ((_e205474_
                                                            _e205407205471_)
                                                           (_wire-id205479_
                                                            _e205408205476_))
                                                       (_K205406205458_
                                                        _wire-id205479_
                                                        _e205474_)))
                                                   (_try-match205398205452_)))))
                                       (if (##structure-direct-instance-of?
                                            _content205396205412_
                                            'std/actor/proto#!call::t)
                                           (let* ((_e205409205461_
                                                   (##vector-ref
                                                    _content205396205412_
                                                    '1))
                                                  (_e205410205466_
                                                   (##vector-ref
                                                    _content205396205412_
                                                    '2)))
                                             (let ((_e205464_ _e205409205461_)
                                                   (_wire-id205469_
                                                    _e205410205466_))
                                               (_K205406205458_
                                                _wire-id205469_
                                                _e205464_)))
                                           (___match206462206463_))))))))
                         (if (##structure-instance-of?
                              _e205390_
                              'std/net/bio/buffer#chunked-output-buffer::t)
                             (if (fx<= (std/net/bio/buffer#chunked-output-length
                                        _e205390_)
                                       std/actor/rpc/proto/message#rpc-proto-message-max-length)
                                 (thread-send _writer204962_ _e205390_)
                                 (begin
                                   (std/logger#warning
                                    '"message too large; not sending %d bytes"
                                    (std/net/bio/buffer#chunked-output-length
                                     _e205390_))
                                   (let ((_content205481_
                                          (##direct-structure-ref
                                           _msg205303_
                                           '1
                                           std/actor/message#message::t
                                           '#f))
                                         (_dest205483_
                                          (##direct-structure-ref
                                           _msg205303_
                                           '3
                                           std/actor/message#message::t
                                           '#f)))
                                     (let* ((_content205485205501_
                                             _content205481_)
                                            (_else205488205509_
                                             (lambda () '#!void)))
                                       (let ((_K205495205547_
                                              (lambda (_wire-id205544_
                                                       _e205545_)
                                                (_dispatch-error204968_
                                                 _wire-id205544_
                                                 '"message too large")))
                                             (_K205490205518_
                                              (lambda (_wire-id205513_
                                                       _e205515_)
                                                (if _dispatch-marshal-error?205305_
                                                    (_dispatch-remote-error204969_
                                                     (##structure
                                                      std/actor/proto#!error::t
                                                      '"message too large"
                                                      _wire-id205513_)
                                                     _dest205483_)
                                                    '#!void))))
                                         (let* ((___match206505206506_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content205485205501_
                                                        'std/actor/proto#!yield::t)
                                                       (let* ((_e205491205531_
                                                               (##vector-ref
                                                                _content205485205501_
                                                                '1))
                                                              (_e205492205536_
                                                               (##vector-ref
                                                                _content205485205501_
                                                                '2)))
                                                         (let ((_e205534_
                                                                _e205491205531_)
                                                               (_wire-id205539_
                                                                _e205492205536_))
                                                           (_K205490205518_
                                                            _wire-id205539_
                                                            _e205534_)))
                                                       '#!void)))
                                                (_try-match205487205541_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content205485205501_
                                                        'std/actor/proto#!error::t)
                                                       (let* ((_e205493205521_
                                                               (##vector-ref
                                                                _content205485205501_
                                                                '1))
                                                              (_e205494205526_
                                                               (##vector-ref
                                                                _content205485205501_
                                                                '2)))
                                                         (let ((_e205524_
                                                                _e205493205521_)
                                                               (_wire-id205529_
                                                                _e205494205526_))
                                                           (_K205490205518_
                                                            _wire-id205529_
                                                            _e205524_)))
                                                       (___match206505206506_))))
                                                (___match206491206492_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content205485205501_
                                                        'std/actor/proto#!stream::t)
                                                       (let* ((_e205496205560_
                                                               (##vector-ref
                                                                _content205485205501_
                                                                '1))
                                                              (_e205497205565_
                                                               (##vector-ref
                                                                _content205485205501_
                                                                '2)))
                                                         (let ((_e205563_
                                                                _e205496205560_)
                                                               (_wire-id205568_
                                                                _e205497205565_))
                                                           (_K205495205547_
                                                            _wire-id205568_
                                                            _e205563_)))
                                                       (_try-match205487205541_)))))
                                           (if (##structure-direct-instance-of?
                                                _content205485205501_
                                                'std/actor/proto#!call::t)
                                               (let* ((_e205498205550_
                                                       (##vector-ref
                                                        _content205485205501_
                                                        '1))
                                                      (_e205499205555_
                                                       (##vector-ref
                                                        _content205485205501_
                                                        '2)))
                                                 (let ((_e205553_
                                                        _e205498205550_)
                                                       (_wire-id205558_
                                                        _e205499205555_))
                                                   (_K205495205547_
                                                    _wire-id205558_
                                                    _e205553_)))
                                               (___match206491206492_))))))))
                             (if _dispatch-marshal-error?205305_
                                 (begin
                                   (std/logger#log-error
                                    '"marshal error"
                                    _e205390_)
                                   (let ((_content205570_
                                          (##direct-structure-ref
                                           _msg205303_
                                           '1
                                           std/actor/message#message::t
                                           '#f))
                                         (_dest205572_
                                          (##direct-structure-ref
                                           _msg205303_
                                           '3
                                           std/actor/message#message::t
                                           '#f)))
                                     (let* ((_content205574205590_
                                             _content205570_)
                                            (_else205577205598_
                                             (lambda () '#!void)))
                                       (let ((_K205584205636_
                                              (lambda (_wire-id205633_
                                                       _e205634_)
                                                (_dispatch-error204968_
                                                 _wire-id205633_
                                                 '"marshal error")))
                                             (_K205579205607_
                                              (lambda (_wire-id205602_
                                                       _e205604_)
                                                (if _dispatch-marshal-error?205305_
                                                    (_dispatch-remote-error204969_
                                                     (##structure
                                                      std/actor/proto#!error::t
                                                      '"marshal error"
                                                      _wire-id205602_)
                                                     _dest205572_)
                                                    '#!void))))
                                         (let* ((___match206534206535_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content205574205590_
                                                        'std/actor/proto#!yield::t)
                                                       (let* ((_e205580205620_
                                                               (##vector-ref
                                                                _content205574205590_
                                                                '1))
                                                              (_e205581205625_
                                                               (##vector-ref
                                                                _content205574205590_
                                                                '2)))
                                                         (let ((_e205623_
                                                                _e205580205620_)
                                                               (_wire-id205628_
                                                                _e205581205625_))
                                                           (_K205579205607_
                                                            _wire-id205628_
                                                            _e205623_)))
                                                       '#!void)))
                                                (_try-match205576205630_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content205574205590_
                                                        'std/actor/proto#!error::t)
                                                       (let* ((_e205582205610_
                                                               (##vector-ref
                                                                _content205574205590_
                                                                '1))
                                                              (_e205583205615_
                                                               (##vector-ref
                                                                _content205574205590_
                                                                '2)))
                                                         (let ((_e205613_
                                                                _e205582205610_)
                                                               (_wire-id205618_
                                                                _e205583205615_))
                                                           (_K205579205607_
                                                            _wire-id205618_
                                                            _e205613_)))
                                                       (___match206534206535_))))
                                                (___match206520206521_
                                                 (lambda ()
                                                   (if (##structure-direct-instance-of?
                                                        _content205574205590_
                                                        'std/actor/proto#!stream::t)
                                                       (let* ((_e205585205649_
                                                               (##vector-ref
                                                                _content205574205590_
                                                                '1))
                                                              (_e205586205654_
                                                               (##vector-ref
                                                                _content205574205590_
                                                                '2)))
                                                         (let ((_e205652_
                                                                _e205585205649_)
                                                               (_wire-id205657_
                                                                _e205586205654_))
                                                           (_K205584205636_
                                                            _wire-id205657_
                                                            _e205652_)))
                                                       (_try-match205576205630_)))))
                                           (if (##structure-direct-instance-of?
                                                _content205574205590_
                                                'std/actor/proto#!call::t)
                                               (let* ((_e205587205639_
                                                       (##vector-ref
                                                        _content205574205590_
                                                        '1))
                                                      (_e205588205644_
                                                       (##vector-ref
                                                        _content205574205590_
                                                        '2)))
                                                 (let ((_e205642_
                                                        _e205587205639_)
                                                       (_wire-id205647_
                                                        _e205588205644_))
                                                   (_K205584205636_
                                                    _wire-id205647_
                                                    _e205642_)))
                                               (___match206520206521_)))))))
                                 (std/logger#log-error
                                  '"marshal error"
                                  _e205390_)))))))
                (_dispatch-error204968_
                 (lambda (_wire-id205252_ _what205253_)
                   (let* ((_g205254205264_
                           (std/actor/rpc/connection#continuation-table-remove!
                            _cont-table204958_
                            _wire-id205252_))
                          (_else205256205272_ (lambda () '#!void))
                          (_K205258205280_
                           (lambda (_stream?205275_
                                    _k205276_
                                    _proto205277_
                                    _actor205278_)
                             (std/actor/message#send-message__%
                              _actor205278_
                              (##structure
                               std/actor/proto#!error::t
                               (make-struct-instance
                                std/actor/proto#rpc-error::t
                                'rpc
                                _what205253_)
                               _k205276_)
                              '#f
                              '#f))))
                     (if (##fx= (if (##values? _g205254205264_)
                                    (##vector-length _g205254205264_)
                                    '1)
                                '4)
                         (let* ((_e205259205283_
                                 (##vector-ref _g205254205264_ '0))
                                (_actor205286_ _e205259205283_)
                                (_e205260205288_
                                 (##vector-ref _g205254205264_ '1))
                                (_proto205291_ _e205260205288_)
                                (_e205261205293_
                                 (##vector-ref _g205254205264_ '2))
                                (_k205296_ _e205261205293_)
                                (_e205262205298_
                                 (##vector-ref _g205254205264_ '3))
                                (_stream?205301_ _e205262205298_))
                           (_K205258205280_
                            _stream?205301_
                            _k205296_
                            _proto205291_
                            _actor205286_))
                         '#!void))))
                (_dispatch-remote-error204969_
                 (lambda (_what205249_ _dest205250_)
                   (_marshal-and-write204967_
                    (##structure
                     std/actor/message#message::t
                     _what205249_
                     '#!void
                     _dest205250_
                     '#f)
                    '#f
                    '#f)))
                (_dispatch-timeout204970_
                 (lambda (_timeo205242_)
                   (set! _next-timeout204959_ '#f)
                   (let ((_$e205244_
                          (std/actor/rpc/connection#continuation-table-get-timeout
                           _cont-table204958_
                           _timeo205242_)))
                     (if _$e205244_
                         ((lambda (_wire-id205247_)
                            (_dispatch-error204968_
                             _wire-id205247_
                             '"timeout"))
                          _$e205244_)
                         '#!void))))
                (_timeout<204971_
                 (lambda (_a205239_ _b205240_)
                   (< (time->seconds _a205239_) (time->seconds _b205240_))))
                (_set-timeout!204972_
                 (lambda (_timeo205234_)
                   (if (or (not _next-timeout204959_)
                           (_timeout<204971_
                            _timeo205234_
                            _next-timeout204959_))
                       (set! _next-timeout204959_ _timeo205234_)
                       '#!void)))
                (_timeout-event204973_
                 (lambda ()
                   (if _next-timeout204959_
                       '#!void
                       (let ((_mx205227_
                              (##unchecked-structure-ref
                               _cont-table204958_
                               '1
                               std/actor/rpc/connection#continuation-table::t
                               '#f)))
                         (mutex-lock! _mx205227_)
                         (let ((_timeouts205230_
                                (##unchecked-structure-ref
                                 _cont-table204958_
                                 '5
                                 std/actor/rpc/connection#continuation-table::t
                                 '#f)))
                           (if (fxzero? (table-length _timeouts205230_))
                               '#!void
                               (table-for-each
                                (lambda (_timeo205232_ _g206627_)
                                  (_set-timeout!204972_ _timeo205232_))
                                _timeouts205230_)))
                         (mutex-unlock! _mx205227_)))
                   _next-timeout204959_))
                (_heartbeat!204974_
                 (lambda ()
                   (let ((_dead-continuations205174_
                          (let ((_mx205130_
                                 (##unchecked-structure-ref
                                  _cont-table204958_
                                  '1
                                  std/actor/rpc/connection#continuation-table::t
                                  '#f)))
                            (mutex-lock! _mx205130_)
                            (let ((_res205171_
                                   (hash-fold
                                    (lambda (_wire-id205133_
                                             _continuation205134_
                                             _r205135_)
                                      (let* ((_continuation205136205145_
                                              _continuation205134_)
                                             (_E205138205149_
                                              (lambda ()
                                                (error '"No clause matching"
                                                       _continuation205136205145_)))
                                             (_K205139205154_
                                              (lambda (_actor205152_)
                                                (if (and (thread? _actor205152_)
                                                         (std/misc/threads#thread-dead?
                                                          _actor205152_))
                                                    (cons _wire-id205133_
                                                          _r205135_)
                                                    _r205135_))))
                                        (if (##fx= (if (##values?
                                                        _continuation205136205145_)
                                                       (##vector-length
                                                        _continuation205136205145_)
                                                       '1)
                                                   '4)
                                            (let* ((_e205140205157_
                                                    (##vector-ref
                                                     _continuation205136205145_
                                                     '0))
                                                   (_actor205160_
                                                    _e205140205157_)
                                                   (_e205141205162_
                                                    (##vector-ref
                                                     _continuation205136205145_
                                                     '1))
                                                   (_e205142205165_
                                                    (##vector-ref
                                                     _continuation205136205145_
                                                     '2))
                                                   (_e205143205168_
                                                    (##vector-ref
                                                     _continuation205136205145_
                                                     '3)))
                                              (_K205139205154_ _actor205160_))
                                            (_E205138205149_))))
                                    '()
                                    (##unchecked-structure-ref
                                     _cont-table204958_
                                     '2
                                     std/actor/rpc/connection#continuation-table::t
                                     '#f))))
                              (mutex-unlock! _mx205130_)
                              _res205171_))))
                     (for-each
                      (lambda (_wire-id205176_)
                        (let* ((_g205177205187_
                                (std/actor/rpc/connection#continuation-table-remove!
                                 _cont-table204958_
                                 _wire-id205176_))
                               (_else205179205195_ (lambda () '#!void))
                               (_K205181205203_
                                (lambda (_stream?205198_
                                         _k205199_
                                         _proto205200_
                                         _actor205201_)
                                  (std/logger#debug
                                   '"removing continuation ~a for dead actor ~a"
                                   _wire-id205176_
                                   _actor205201_)
                                  (if _stream?205198_
                                      (_dispatch-remote-error204969_
                                       (##structure
                                        std/actor/proto#!abort::t
                                        _wire-id205176_)
                                       std/actor/rpc/base#null-uuid)
                                      '#!void))))
                          (if (##fx= (if (##values? _g205177205187_)
                                         (##vector-length _g205177205187_)
                                         '1)
                                     '4)
                              (let* ((_e205182205206_
                                      (##vector-ref _g205177205187_ '0))
                                     (_actor205209_ _e205182205206_)
                                     (_e205183205211_
                                      (##vector-ref _g205177205187_ '1))
                                     (_proto205214_ _e205183205211_)
                                     (_e205184205216_
                                      (##vector-ref _g205177205187_ '2))
                                     (_k205219_ _e205184205216_)
                                     (_e205185205221_
                                      (##vector-ref _g205177205187_ '3))
                                     (_stream?205224_ _e205185205221_))
                                (_K205181205203_
                                 _stream?205224_
                                 _k205219_
                                 _proto205214_
                                 _actor205209_))
                              '#!void)))
                      _dead-continuations205174_))
                   (set! _next-heartbeat204961_
                         (seconds->time (+ (##current-time-point) '60)))))
                (_dump!204975_
                 (lambda (_port205126_)
                   (call-with-parameters
                    (lambda ()
                      (displayln '"=== rpc-connection ===")
                      (displayln '"peer-address: " _peer-address204951_)
                      (displayln
                       '"next-continuation-id: "
                       _next-continuation-id204960_)
                      (displayln
                       '"next-timeout: "
                       (if _next-timeout204959_
                           (time->seconds _next-timeout204959_)
                           '#f)))
                    current-output-port
                    _port205126_)
                   (std/actor/rpc/connection#continuation-table-dump!__%
                    _cont-table204958_
                    _port205126_)))
                (_loop204976_
                 (lambda ()
                   (let ((_g206628_
                          (std/actor/message#receive-timeout
                           (_timeout-event204973_)
                           _dispatch-timeout204970_
                           _next-heartbeat204961_
                           (lambda (_$e204990_) (_heartbeat!204974_)))))
                     (begin
                       (let ((_g206629_
                              (if (##values? _g206628_)
                                  (##vector-length _g206628_)
                                  1)))
                         (if (not (##fx= _g206629_ 2))
                             (error "Context expects 2 values" _g206629_)))
                       (let ((_timeo204993_ (##vector-ref _g206628_ 0))
                             (_K204995_ (##vector-ref _g206628_ 1)))
                         (let _loop204988204998_ ()
                           (let ((_next205002_
                                  (thread-mailbox-next
                                   _timeo204993_
                                   std/actor/message#mailbox-timeout)))
                             (if (eq? _next205002_
                                      std/actor/message#mailbox-timeout)
                                 (begin
                                   (thread-mailbox-rewind)
                                   (_K204995_ _timeo204993_))
                                 ((lambda (_msg205005_)
                                    (let* ((_msg205007205029_ _msg205005_)
                                           (_else205015205037_
                                            (lambda () (_loop204988204998_))))
                                      (let ((_K205027205121_
                                             (lambda (_msg205119_)
                                               (thread-mailbox-extract-and-rewind)
                                               (_write-message204965_
                                                _msg205119_)))
                                            (_K205026205113_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               (_close-connection204964_)))
                                            (_K205025205105_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               (_close-connection204964_)))
                                            (_K205024205095_
                                             (lambda (_thread205081_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g205082205084_)
                                                  (if ((lambda (_$obj205087_)
                                                         (uncaught-exception?
                                                          _$obj205087_))
                                                       _g205082205084_)
                                                      (let ((_e205090_
                                                             _g205082205084_))
                                                        (std/logger#log-error
                                                         '"connection error"
                                                         (uncaught-exception-reason
                                                          _e205090_)))
                                                      (if '#t
                                                          (let ((_e205092_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _g205082205084_))
                    (std/logger#log-error '"connection error" _e205092_))
                  (raise _g205082205084_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                (lambda ()
                                                  (thread-join! _thread205081_)
                                                  (std/logger#warning
                                                   '"connection error: i/o thread ~a exited unexpectedly"
                                                   (thread-name
                                                    _thread205081_))))
                                               (_close-connection204964_)))
                                            (_K205023205074_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               (_dump!204975_
                                                (current-error-port))))
                                            (_K205018205054_
                                             (lambda (_port205052_)
                                               (thread-mailbox-extract-and-rewind)
                                               (_dump!204975_ _port205052_)))
                                            (_K205017205043_
                                             (lambda (_bogus205041_)
                                               (thread-mailbox-extract-and-rewind)
                                               (std/logger#warning
                                                '"unexpected message ~a"
                                                _bogus205041_))))
                                        (let* ((_try-match205013205069_
                                                (lambda ()
                                                  (if (##pair? _msg205007205029_)
                                                      (let ((_tl205020205059_
                                                             (##cdr _msg205007205029_))
                                                            (_hd205019205057_
                                                             (##car _msg205007205029_)))
                                                        (if (##eq? _hd205019205057_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           'dump)
                    (if (##pair? _tl205020205059_)
                        (let ((_tl205022205064_ (##cdr _tl205020205059_))
                              (_hd205021205062_ (##car _tl205020205059_)))
                          (if (##null? _tl205022205064_)
                              (let ((_port205067_ _hd205021205062_))
                                (_K205018205054_ _port205067_))
                              (let ((_bogus205046_ _msg205007205029_))
                                (_K205017205043_ _bogus205046_))))
                        (let ((_bogus205046_ _msg205007205029_))
                          (_K205017205043_ _bogus205046_)))
                    (let ((_bogus205046_ _msg205007205029_))
                      (_K205017205043_ _bogus205046_))))
              (let ((_bogus205046_ _msg205007205029_))
                (_K205017205043_ _bogus205046_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                               (_try-match205012205077_
                                                (lambda ()
                                                  (if (##eq? _msg205007205029_
                                                             'dump)
                                                      (_K205023205074_)
                                                      (_try-match205013205069_))))
                                               (_try-match205011205100_
                                                (lambda ()
                                                  (if (thread? _msg205007205029_)
                                                      (let ((_thread205098_
                                                             _msg205007205029_))
                                                        (_K205024205095_
                                                         _thread205098_))
                                                      (_try-match205012205077_))))
                                               (_try-match205010205108_
                                                (lambda ()
                                                  (if (##eq? _msg205007205029_
                                                             'shutdown)
                                                      (_K205025205105_)
                                                      (_try-match205011205100_))))
                                               (_try-match205009205116_
                                                (lambda ()
                                                  (if (eof-object?
                                                       _msg205007205029_)
                                                      (_K205026205113_)
                                                      (_try-match205010205108_)))))
                                          (if (##structure-direct-instance-of?
                                               _msg205007205029_
                                               'std/actor/message#message::t)
                                              (let ((_msg205124_
                                                     _msg205007205029_))
                                                (_K205027205121_ _msg205124_))
                                              (_try-match205009205116_))))))
                                  _next205002_)))))))
                   (_loop204976_)))
                (_run204977_
                 (lambda ()
                   (call-with-parameters
                    (lambda () (_loop204976_))
                    std/actor/xdr#current-xdr-type-registry
                    std/actor/xdr#+xdr-default-type-registry+))))
        (begin
          (std/actor/rpc/base#rpc-monitor__0 _reader204963_)
          (std/actor/rpc/base#rpc-monitor__0 _writer204962_)
          (with-exception-catcher
           (lambda (_g204978204980_)
             (if '#t
                 (let ((_e204983_ _g204978204980_))
                   (if (eq? 'shutdown _e204983_)
                       '#!void
                       (begin
                         (std/logger#log-error
                          '"unhandled exception"
                          _e204983_)
                         (with-exception-catcher
                          void
                          _close-connection204964_))))
                 (raise _g204978204980_)))
           (lambda () (_run204977_)))))))
  (define std/actor/rpc/connection#rpc-connection-writer
    (lambda (_sockbuf204857_ _write-e204858_)
      (letrec ((_loop204860_
                (lambda ()
                  (let ((_g206630_
                         (std/actor/message#receive-timeout
                          std/actor/rpc/connection#rpc-keep-alive
                          (lambda (_$e204871_)
                            (_write-e204858_ _sockbuf204857_ '#!void)
                            (_loop204860_)))))
                    (begin
                      (let ((_g206631_
                             (if (##values? _g206630_)
                                 (##vector-length _g206630_)
                                 1)))
                        (if (not (##fx= _g206631_ 2))
                            (error "Context expects 2 values" _g206631_)))
                      (let ((_timeo204874_ (##vector-ref _g206630_ 0))
                            (_K204876_ (##vector-ref _g206630_ 1)))
                        (let _loop204869204879_ ()
                          (let ((_next204883_
                                 (thread-mailbox-next
                                  _timeo204874_
                                  std/actor/message#mailbox-timeout)))
                            (if (eq? _next204883_
                                     std/actor/message#mailbox-timeout)
                                (begin
                                  (thread-mailbox-rewind)
                                  (_K204876_ _timeo204874_))
                                ((lambda (_msg204886_)
                                   (let* ((_msg204888204900_ _msg204886_)
                                          (_else204893204908_
                                           (lambda () (_loop204869204879_))))
                                     (let ((_K204898204943_
                                            (lambda (_buf204941_)
                                              (thread-mailbox-extract-and-rewind)
                                              (_write-e204858_
                                               _sockbuf204857_
                                               _buf204941_)
                                              (_loop204860_)))
                                           (_K204897204933_
                                            (lambda (_data204931_)
                                              (thread-mailbox-extract-and-rewind)
                                              (_write-e204858_
                                               _sockbuf204857_
                                               _data204931_)
                                              (_loop204860_)))
                                           (_K204896204924_
                                            (lambda ()
                                              (thread-mailbox-extract-and-rewind)
                                              '#!void))
                                           (_K204895204914_
                                            (lambda (_bogus204912_)
                                              (thread-mailbox-extract-and-rewind)
                                              (std/logger#warning
                                               '"unexpected message ~a"
                                               _bogus204912_)
                                              (_loop204860_))))
                                       (let* ((_try-match204891204927_
                                               (lambda ()
                                                 (if (##eq? _msg204888204900_
                                                            'exit)
                                                     (_K204896204924_)
                                                     (let ((_bogus204917_
                                                            _msg204888204900_))
                                                       (_K204895204914_
                                                        _bogus204917_)))))
                                              (_try-match204890204938_
                                               (lambda ()
                                                 (if (u8vector?
                                                      _msg204888204900_)
                                                     (let ((_data204936_
                                                            _msg204888204900_))
                                                       (_K204897204933_
                                                        _data204936_))
                                                     (_try-match204891204927_)))))
                                         (if (##structure-instance-of?
                                              _msg204888204900_
                                              'std/net/bio/output#output-buffer::t)
                                             (let ((_buf204946_
                                                    _msg204888204900_))
                                               (_K204898204943_ _buf204946_))
                                             (_try-match204890204938_))))))
                                 _next204883_))))))))))
        (with-exception-catcher
         (lambda (_g204861204863_)
           (if '#t
               (let ((_e204866_ _g204861204863_))
                 (std/logger#log-error '"unhandled exception" _e204866_))
               (raise _g204861204863_)))
         (lambda () (_loop204860_))))))
  (define std/actor/rpc/connection#rpc-connection-reader
    (lambda (_conn204436_
             _connaddr204437_
             _sockbuf204438_
             _actor-table204439_
             _cont-table204440_
             _writer204441_
             _read-e204442_)
      (letrec ((_loop204444_
                (lambda (_u8buf204697_)
                  (let* ((_g204698204711_
                          (_read-e204442_ _sockbuf204438_ _u8buf204697_))
                         (_E204703204715_
                          (lambda ()
                            (error '"No clause matching" _g204698204711_))))
                    (let ((_K204707204844_
                           (lambda (_count204745_ _u8buf204746_)
                             (let* ((_buffer204748_
                                     (std/net/bio/buffer#open-input-buffer__%
                                      _u8buf204746_
                                      '0
                                      _count204745_))
                                    (_msg204750_
                                     (_read-envelope204451_ _buffer204748_)))
                               (let* ((_msg204752204759_ _msg204750_)
                                      (_else204754204767_ (lambda () '#!void))
                                      (_K204756204836_
                                       (lambda (_content204770_)
                                         (let* ((_content204771204781_
                                                 _content204770_)
                                                (_else204775204789_
                                                 (lambda ()
                                                   (_dispatch-call204445_
                                                    _msg204750_
                                                    _buffer204748_))))
                                           (let ((_K204779204827_
                                                  (lambda ()
                                                    (_dispatch-call204445_
                                                     _msg204750_
                                                     _buffer204748_)))
                                                 (_K204778204808_
                                                  (lambda ()
                                                    (_dispatch-value204446_
                                                     _msg204750_
                                                     _buffer204748_)))
                                                 (_K204777204794_
                                                  (lambda ()
                                                    (_dispatch-control204447_
                                                     _msg204750_
                                                     _buffer204748_))))
                                             (let* ((_try-match204774204803_
                                                     (lambda ()
                                                       (if (or (##structure-direct-instance-of?
                                                                _content204771204781_
                                                                'std/actor/proto#!continue::t)
                                                               (##structure-direct-instance-of?
                                                                _content204771204781_
                                                                'std/actor/proto#!close::t)
                                                               (##structure-direct-instance-of?
                                                                _content204771204781_
                                                                'std/actor/proto#!abort::t))
                                                           (_K204777204794_)
                                                           (_else204775204789_))))
                                                    (_try-match204773204823_
                                                     (lambda ()
                                                       (if (or (##structure-direct-instance-of?
                                                                _content204771204781_
                                                                'std/actor/proto#!value::t)
                                                               (##structure-direct-instance-of?
                                                                _content204771204781_
                                                                'std/actor/proto#!error::t)
                                                               (##structure-direct-instance-of?
                                                                _content204771204781_
                                                                'std/actor/proto#!yield::t)
                                                               (##structure-direct-instance-of?
                                                                _content204771204781_
                                                                'std/actor/proto#!end::t)
                                                               (##structure-direct-instance-of?
                                                                _content204771204781_
                                                                'std/actor/proto#!sync::t))
                                                           (_K204778204808_)
                                                           (_try-match204774204803_)))))
                                               (if (or (##structure-direct-instance-of?
                                                        _content204771204781_
                                                        'std/actor/proto#!call::t)
                                                       (##structure-direct-instance-of?
                                                        _content204771204781_
                                                        'std/actor/proto#!event::t)
                                                       (##structure-direct-instance-of?
                                                        _content204771204781_
                                                        'std/actor/proto#!stream::t))
                                                   (_K204779204827_)
                                                   (_try-match204773204823_))))))))
                                 (if (##structure-direct-instance-of?
                                      _msg204752204759_
                                      'std/actor/message#message::t)
                                     (let* ((_e204757204839_
                                             (##vector-ref
                                              _msg204752204759_
                                              '1))
                                            (_content204842_ _e204757204839_))
                                       (_K204756204836_ _content204842_))
                                     '#!void))
                               (_loop204444_ _u8buf204746_))))
                          (_K204706204739_
                           (lambda () (_loop204444_ _u8buf204697_)))
                          (_K204705204731_
                           (lambda () (thread-send _conn204436_ '#!eof)))
                          (_K204704204721_
                           (lambda (_unexpected204719_)
                             (error '"read unexpected object"
                                    _unexpected204719_))))
                      (let* ((_try-match204701204734_
                              (lambda ()
                                (if (eof-object? _g204698204711_)
                                    (_K204705204731_)
                                    (let ((_unexpected204724_ _g204698204711_))
                                      (_K204704204721_ _unexpected204724_)))))
                             (_try-match204700204742_
                              (lambda ()
                                (if (eq? _g204698204711_ '#!void)
                                    (_K204706204739_)
                                    (_try-match204701204734_)))))
                        (if (##fx= (if (##values? _g204698204711_)
                                       (##vector-length _g204698204711_)
                                       '1)
                                   '2)
                            (let* ((_e204708204847_
                                    (##vector-ref _g204698204711_ '0))
                                   (_e204709204852_
                                    (##vector-ref _g204698204711_ '1)))
                              (let ((_u8buf204850_ _e204708204847_)
                                    (_count204855_ _e204709204852_))
                                (_K204707204844_ _count204855_ _u8buf204850_)))
                            (_try-match204700204742_)))))))
               (_dispatch-call204445_
                (lambda (_msg204607_ _buffer204608_)
                  (let* ((_uuid204610_
                          (##direct-structure-ref
                           _msg204607_
                           '3
                           std/actor/message#message::t
                           '#f))
                         (_$e204612_
                          (std/misc/sync#sync-hash-get
                           _actor-table204439_
                           _uuid204610_)))
                    (if _$e204612_
                        ((lambda (_e204614204616_)
                           (let* ((_g204618204625_ _e204614204616_)
                                  (_E204620204629_
                                   (lambda ()
                                     (error '"No clause matching"
                                            _g204618204625_)))
                                  (_K204621204643_
                                   (lambda (_proto204632_ _actor204633_)
                                     (if (_read-payload!204452_
                                          _msg204607_
                                          _buffer204608_
                                          _proto204632_)
                                         (begin
                                           (##direct-structure-set!
                                            _msg204607_
                                            _actor204633_
                                            '3
                                            std/actor/message#message::t
                                            '#f)
                                           (##direct-structure-set!
                                            _msg204607_
                                            (let ((__obj206620
                                                   (make-object
                                                    std/actor/proto#remote::t
                                                    '4)))
                                              (std/actor/proto#remote:::init!
                                               __obj206620
                                               _conn204436_
                                               _uuid204610_
                                               _connaddr204437_
                                               _proto204632_)
                                              __obj206620)
                                            '2
                                            std/actor/message#message::t
                                            '#f)
                                           (std/actor/message#send__0
                                            _actor204633_
                                            _msg204607_))
                                         (if (or (##structure-direct-instance-of?
                                                  (##direct-structure-ref
                                                   _msg204607_
                                                   '1
                                                   std/actor/message#message::t
                                                   '#f)
                                                  'std/actor/proto#!call::t)
                                                 (##structure-direct-instance-of?
                                                  (##direct-structure-ref
                                                   _msg204607_
                                                   '1
                                                   std/actor/message#message::t
                                                   '#f)
                                                  'std/actor/proto#!stream::t))
                                             (let* ((_content204638_
                                                     (##direct-structure-ref
                                                      _msg204607_
                                                      '1
                                                      std/actor/message#message::t
                                                      '#f))
                                                    (_k204640_
                                                     (if (##structure-direct-instance-of?
                                                          _content204638_
                                                          'std/actor/proto#!call::t)
                                                         (##direct-structure-ref
                                                          _content204638_
                                                          '2
                                                          std/actor/proto#!call::t
                                                          '#f)
                                                         (##direct-structure-ref
                                                          _content204638_
                                                          '2
                                                          std/actor/proto#!stream::t
                                                          '#f))))
                                               (_dispatch-remote-error204450_
                                                (##structure
                                                 std/actor/proto#!error::t
                                                 '"unmarshal error"
                                                 _k204640_)
                                                _uuid204610_))
                                             '#!void)))))
                             (if (##fx= (if (##values? _g204618204625_)
                                            (##vector-length _g204618204625_)
                                            '1)
                                        '2)
                                 (let* ((_e204622204646_
                                         (##vector-ref _g204618204625_ '0))
                                        (_actor204649_ _e204622204646_)
                                        (_e204623204651_
                                         (##vector-ref _g204618204625_ '1))
                                        (_proto204654_ _e204623204651_))
                                   (_K204621204643_
                                    _proto204654_
                                    _actor204649_))
                                 (_E204620204629_))))
                         _$e204612_)
                        (begin
                          (std/logger#warning
                           '"cannot route message; no actor binding ~a"
                           (std/misc/uuid#uuid->string _uuid204610_))
                          (let* ((_g204655204665_
                                  (##direct-structure-ref
                                   _msg204607_
                                   '1
                                   std/actor/message#message::t
                                   '#f))
                                 (_else204657204673_ (lambda () '#!void))
                                 (_K204659204678_
                                  (lambda (_k204676_)
                                    (_dispatch-remote-error204450_
                                     (##structure
                                      std/actor/proto#!error::t
                                      '"no binding"
                                      _k204676_)
                                     _uuid204610_))))
                            (if (##structure-direct-instance-of?
                                 _g204655204665_
                                 'std/actor/proto#!call::t)
                                (let* ((_e204662204681_
                                        (##vector-ref _g204655204665_ '1))
                                       (_e204663204684_
                                        (##vector-ref _g204655204665_ '2))
                                       (_k204687_ _e204663204684_))
                                  (_K204659204678_ _k204687_))
                                (if (##structure-direct-instance-of?
                                     _g204655204665_
                                     'std/actor/proto#!stream::t)
                                    (let* ((_e204660204689_
                                            (##vector-ref _g204655204665_ '1))
                                           (_e204661204692_
                                            (##vector-ref _g204655204665_ '2))
                                           (_k204695_ _e204661204692_))
                                      (_K204659204678_ _k204695_))
                                    '#!void))))))))
               (_dispatch-value204446_
                (lambda (_msg204538_ _buffer204539_)
                  (let* ((_content204541_
                          (##direct-structure-ref
                           _msg204538_
                           '1
                           std/actor/message#message::t
                           '#f))
                         (_cont204543_ (_value-k204448_ _content204541_)))
                    (let ((_$e204546_
                           (std/actor/rpc/connection#continuation-table-get
                            _cont-table204440_
                            _cont204543_)))
                      (if _$e204546_
                          ((lambda (_e204548204550_)
                             (let* ((_g204552204561_ _e204548204550_)
                                    (_E204554204565_
                                     (lambda ()
                                       (error '"No clause matching"
                                              _g204552204561_)))
                                    (_K204555204584_
                                     (lambda (_stream?204568_
                                              _k204569_
                                              _proto204570_
                                              _actor204571_)
                                       (if (_read-payload!204452_
                                            _msg204538_
                                            _buffer204539_
                                            _proto204570_)
                                           (begin
                                             (_value-k-set!204449_
                                              _content204541_
                                              _k204569_)
                                             (##direct-structure-set!
                                              _msg204538_
                                              (let ((__obj206621
                                                     (make-object
                                                      std/actor/proto#remote::t
                                                      '4)))
                                                (std/actor/proto#remote:::init!
                                                 __obj206621
                                                 _conn204436_
                                                 (##direct-structure-ref
                                                  _msg204538_
                                                  '3
                                                  std/actor/message#message::t
                                                  '#f)
                                                 _connaddr204437_
                                                 _proto204570_)
                                                __obj206621)
                                              '2
                                              std/actor/message#message::t
                                              '#f)
                                             (if (or (##structure-direct-instance-of?
                                                      _content204541_
                                                      'std/actor/proto#!yield::t)
                                                     (##structure-direct-instance-of?
                                                      _content204541_
                                                      'std/actor/proto#!sync::t))
                                                 (let ((_ok204582_
                                                        (let ((_mx204576_
                                                               (##unchecked-structure-ref
                                                                _cont-table204440_
                                                                '1
                                                                std/actor/rpc/connection#continuation-table::t
                                                                '#f)))
                                                          (mutex-lock!
                                                           _mx204576_)
                                                          (let ((_res204579_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (if (table-ref
                              (##unchecked-structure-ref
                               _cont-table204440_
                               '2
                               std/actor/rpc/connection#continuation-table::t
                               '#f)
                              _cont204543_
                              '#f)
                             (begin
                               (std/actor/message#send__0
                                _actor204571_
                                _msg204538_)
                               '#t)
                             '#f)))
                    (mutex-unlock! _mx204576_)
                    _res204579_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (if _ok204582_
                                                       '#!void
                                                       (if (##structure-direct-instance-of?
                                                            _content204541_
                                                            'std/actor/proto#!sync::t)
                                                           (_dispatch-remote-error204450_
                                                            (##structure
                                                             std/actor/proto#!abort::t
                                                             _cont204543_)
                                                            (##direct-structure-ref
                                                             _msg204538_
                                                             '3
                                                             std/actor/message#message::t
                                                             '#f))
                                                           '#!void)))
                                                 (if (std/actor/rpc/connection#continuation-table-remove!
                                                      _cont-table204440_
                                                      _cont204543_)
                                                     (std/actor/message#send__0
                                                      _actor204571_
                                                      _msg204538_)
                                                     '#!void)))
                                           (begin
                                             (if (std/actor/rpc/connection#continuation-table-remove!
                                                  _cont-table204440_
                                                  _cont204543_)
                                                 (std/actor/message#send-message__%
                                                  _actor204571_
                                                  (##structure
                                                   std/actor/proto#!error::t
                                                   (make-struct-instance
                                                    std/actor/proto#rpc-error::t
                                                    'rpc
                                                    '"unmarshal error")
                                                   _k204569_)
                                                  '#f
                                                  '#f)
                                                 '#!void)
                                             (if (##structure-direct-instance-of?
                                                  _content204541_
                                                  'std/actor/proto#!sync::t)
                                                 (_dispatch-remote-error204450_
                                                  (##structure
                                                   std/actor/proto#!abort::t
                                                   _cont204543_)
                                                  (##direct-structure-ref
                                                   _msg204538_
                                                   '3
                                                   std/actor/message#message::t
                                                   '#f))
                                                 '#!void))))))
                               (if (##fx= (if (##values? _g204552204561_)
                                              (##vector-length _g204552204561_)
                                              '1)
                                          '4)
                                   (let* ((_e204556204587_
                                           (##vector-ref _g204552204561_ '0))
                                          (_actor204590_ _e204556204587_)
                                          (_e204557204592_
                                           (##vector-ref _g204552204561_ '1))
                                          (_proto204595_ _e204557204592_)
                                          (_e204558204597_
                                           (##vector-ref _g204552204561_ '2))
                                          (_k204600_ _e204558204597_)
                                          (_e204559204602_
                                           (##vector-ref _g204552204561_ '3))
                                          (_stream?204605_ _e204559204602_))
                                     (_K204555204584_
                                      _stream?204605_
                                      _k204600_
                                      _proto204595_
                                      _actor204590_))
                                   (_E204554204565_))))
                           _$e204546_)
                          (begin
                            (std/logger#warning
                             '"cannot route message; unknown continuation ~a"
                             _cont204543_)
                            (if (##structure-direct-instance-of?
                                 _content204541_
                                 'std/actor/proto#!sync::t)
                                (_dispatch-remote-error204450_
                                 (##structure
                                  std/actor/proto#!abort::t
                                  _cont204543_)
                                 (##direct-structure-ref
                                  _msg204538_
                                  '3
                                  std/actor/message#message::t
                                  '#f))
                                '#!void)))))))
               (_dispatch-control204447_
                (lambda (_msg204500_ _buffer204501_)
                  (let* ((_content204503_
                          (##direct-structure-ref
                           _msg204500_
                           '1
                           std/actor/message#message::t
                           '#f))
                         (_cont204505_ (_value-k204448_ _content204503_))
                         (_stream204507_
                          (std/actor/rpc/connection#continuation-table-get-stream-actor
                           _cont-table204440_
                           _cont204505_)))
                    (if _stream204507_
                        (let* ((_stream204509204516_ _stream204507_)
                               (_E204511204520_
                                (lambda ()
                                  (error '"No clause matching"
                                         _stream204509204516_)))
                               (_K204512204526_
                                (lambda (_dest204523_ _actor204524_)
                                  (##direct-structure-set!
                                   _msg204500_
                                   _dest204523_
                                   '2
                                   std/actor/message#message::t
                                   '#f)
                                  (std/actor/message#send__0
                                   _actor204524_
                                   _msg204500_)
                                  (std/actor/rpc/connection#continuation-table-remove-stream-actor!
                                   _cont-table204440_
                                   _cont204505_))))
                          (if (##pair? _stream204509204516_)
                              (let ((_hd204513204529_
                                     (##car _stream204509204516_))
                                    (_tl204514204531_
                                     (##cdr _stream204509204516_)))
                                (let* ((_actor204534_ _hd204513204529_)
                                       (_dest204536_ _tl204514204531_))
                                  (_K204512204526_
                                   _dest204536_
                                   _actor204534_)))
                              (_E204511204520_)))
                        (begin
                          (std/logger#warning
                           '"unexpected control message; unknown stream ~a"
                           _cont204505_)
                          (if (##structure-direct-instance-of?
                               _content204503_
                               'std/actor/proto#!abort::t)
                              '#!void
                              (_dispatch-remote-error204450_
                               (##structure
                                std/actor/proto#!error::t
                                '"uknown stream"
                                _cont204505_)
                               (##direct-structure-ref
                                _msg204500_
                                '3
                                std/actor/message#message::t
                                '#f))))))))
               (_value-k204448_
                (lambda (_obj204498_)
                  (##vector-ref
                   _obj204498_
                   (fx- (##vector-length _obj204498_) '1))))
               (_value-k-set!204449_
                (lambda (_obj204495_ _k204496_)
                  (##vector-set!
                   _obj204495_
                   (fx- (##vector-length _obj204495_) '1)
                   _k204496_)))
               (_dispatch-remote-error204450_
                (lambda (_err204487_ _dest204488_)
                  (let* ((_msg204490_
                          (##structure
                           std/actor/message#message::t
                           _err204487_
                           '#!void
                           _dest204488_
                           '#f))
                         (_data204492_
                          (std/actor/rpc/proto/message#rpc-proto-marshal-message
                           _msg204490_
                           '#f)))
                    (thread-send _writer204441_ _data204492_))))
               (_read-envelope204451_
                (lambda (_buffer204475_)
                  (with-exception-catcher
                   (lambda (_g204476204478_)
                     (if ((lambda (_$obj204481_) (exception? _$obj204481_))
                          _g204476204478_)
                         (let ((_e204484_ _g204476204478_))
                           (std/logger#log-error '"read error" _e204484_)
                           _e204484_)
                         (raise _g204476204478_)))
                   (lambda ()
                     (std/actor/rpc/proto/message#rpc-proto-read-envelope
                      _buffer204475_)))))
               (_read-payload!204452_
                (lambda (_msg204464_ _buffer204465_ _proto204466_)
                  (with-exception-catcher
                   (lambda (_g204467204469_)
                     (if '#t
                         (let ((_e204472_ _g204467204469_))
                           (std/logger#log-error '"unmarshal error" _e204472_)
                           '#f)
                         (raise _g204467204469_)))
                   (lambda ()
                     (std/actor/rpc/proto/message#rpc-proto-read-payload!
                      _msg204464_
                      _buffer204465_
                      _proto204466_)))))
               (_run204453_
                (lambda ()
                  (call-with-parameters
                   (lambda () (_loop204444_ (make-u8vector '4096)))
                   std/actor/xdr#current-xdr-type-registry
                   std/actor/xdr#+xdr-default-type-registry+))))
        (with-exception-catcher
         (lambda (_g204454204456_)
           (if '#t
               (let ((_e204459_ _g204454204456_))
                 (std/logger#log-error '"unhandled exception" _e204459_))
               (raise _g204454204456_)))
         (lambda () (_run204453_))))))
  (define std/actor/rpc/connection#rpc-options-timeout
    (lambda (_opts204423_ _default204424_)
      (letrec ((_timeout204426_
                (lambda (_dt204433_ _default204434_)
                  (if (real? _dt204433_)
                      (seconds->time (+ (##current-time-point) _dt204433_))
                      (if (time? _dt204433_)
                          _dt204433_
                          (if (not _dt204433_)
                              _dt204433_
                              (_timeout204426_ _default204434_ '#f)))))))
        (let ((_$e204428_ (if _opts204423_ (memq 'timeout: _opts204423_) '#f)))
          (if _$e204428_
              ((lambda (_plist204431_)
                 (_timeout204426_ (cadr _plist204431_) _default204424_))
               _$e204428_)
              (_timeout204426_ _default204424_ '#f))))))
  (define std/actor/rpc/connection#rpc-connection-shutdown
    (lambda (_rpc-server204325_)
      (std/actor/message#send-message__0
       _rpc-server204325_
       (##structure
        std/actor/proto#!event::t
        (##structure std/actor/rpc/base#rpc.connection-shutdown::t)))
      (let _lp204327_ ()
        (let _loop204329204331_ ()
          (let ((_next204335_ (thread-mailbox-next)))
            ((lambda (_msg204338_)
               (let* ((_msg204340204348_ _msg204338_)
                      (_else204343204356_ (lambda () (_loop204329204331_))))
                 (let ((_K204346204418_
                        (lambda (_msg204370_)
                          (thread-mailbox-extract-and-rewind)
                          (let* ((_msg204371204377_ _msg204370_)
                                 (_E204373204381_
                                  (lambda ()
                                    (error '"No clause matching"
                                           _msg204371204377_)))
                                 (_K204374204410_
                                  (lambda (_content204384_)
                                    (let* ((_content204385204392_
                                            _content204384_)
                                           (_else204387204400_
                                            (lambda ()
                                              (std/actor/rpc/connection#rpc-send-error-response
                                               _msg204370_
                                               '"connection error")
                                              (_lp204327_)))
                                           (_K204389204404_
                                            (lambda ()
                                              (std/actor/rpc/connection#rpc-send-error-responses
                                               '"connection error"))))
                                      (if (##structure-direct-instance-of?
                                           _content204385204392_
                                           'std/actor/proto#!event::t)
                                          (let ((_e204390204407_
                                                 (##vector-ref
                                                  _content204385204392_
                                                  '1)))
                                            (if (##structure-direct-instance-of?
                                                 _e204390204407_
                                                 'std/actor#rpc.connection-close::t)
                                                (_K204389204404_)
                                                (_else204387204400_)))
                                          (_else204387204400_))))))
                            (if (##structure-direct-instance-of?
                                 _msg204371204377_
                                 'std/actor/message#message::t)
                                (let* ((_e204375204413_
                                        (##vector-ref _msg204371204377_ '1))
                                       (_content204416_ _e204375204413_))
                                  (_K204374204410_ _content204416_))
                                (_E204373204381_)))))
                       (_K204345204362_
                        (lambda (_ignore204360_)
                          (thread-mailbox-extract-and-rewind)
                          (_lp204327_))))
                   (if (##structure-direct-instance-of?
                        _msg204340204348_
                        'std/actor/message#message::t)
                       (let ((_msg204421_ _msg204340204348_))
                         (_K204346204418_ _msg204421_))
                       (let ((_ignore204365_ _msg204340204348_))
                         (_K204345204362_ _ignore204365_))))))
             _next204335_))))))
  (define std/actor/rpc/connection#rpc-connection-cleanup
    (lambda (_rpc-server204321_ _exn204322_ _sock204323_)
      (std/logger#log-error '"connection error" _exn204322_)
      (if _sock204323_ (std/net/socket/api#ssocket-close _sock204323_) '#!void)
      (std/actor/rpc/connection#rpc-connection-shutdown _rpc-server204321_)))
  (define std/actor/rpc/connection#rpc-send-error-response
    (lambda (_msg204222_ _what204223_)
      (if (##structure-direct-instance-of?
           _msg204222_
           'std/actor/message#message::t)
          (let* ((_msg204224204232_ _msg204222_)
                 (_E204226204236_
                  (lambda () (error '"No clause matching" _msg204224204232_)))
                 (_K204227204303_
                  (lambda (_dest204239_ _src204240_ _content204241_)
                    (let* ((_content204242204255_ _content204241_)
                           (_else204245204263_ (lambda () '#!void)))
                      (let ((_K204249204284_
                             (lambda (_k204282_)
                               (std/actor/message#send-message__%
                                (##direct-structure-ref
                                 _msg204222_
                                 '2
                                 std/actor/message#message::t
                                 '#f)
                                (##structure
                                 std/actor/proto#!error::t
                                 (make-struct-instance
                                  std/actor/proto#rpc-error::t
                                  'rpc
                                  _what204223_)
                                 _k204282_)
                                '#f
                                '#f)))
                            (_K204247204271_
                             (lambda (_k204267_)
                               (let ((_abort204269_
                                      (##structure
                                       std/actor/message#message::t
                                       (##structure
                                        std/actor/proto#!abort::t
                                        _k204267_)
                                       _dest204239_
                                       _src204240_
                                       '#f)))
                                 (std/actor/message#send__0
                                  _src204240_
                                  _abort204269_)))))
                        (let* ((_try-match204244204279_
                                (lambda ()
                                  (if (##structure-direct-instance-of?
                                       _content204242204255_
                                       'std/actor/proto#!yield::t)
                                      (let* ((_e204248204274_
                                              (##vector-ref
                                               _content204242204255_
                                               '1))
                                             (_k204277_ _e204248204274_))
                                        (_K204247204271_ _k204277_))
                                      '#!void)))
                               (___match206600206601_
                                (lambda ()
                                  (if (##structure-direct-instance-of?
                                       _content204242204255_
                                       'std/actor/proto#!stream::t)
                                      (let* ((_e204250204295_
                                              (##vector-ref
                                               _content204242204255_
                                               '1))
                                             (_e204251204298_
                                              (##vector-ref
                                               _content204242204255_
                                               '2))
                                             (_k204301_ _e204251204298_))
                                        (_K204249204284_ _k204301_))
                                      (_try-match204244204279_)))))
                          (if (##structure-direct-instance-of?
                               _content204242204255_
                               'std/actor/proto#!call::t)
                              (let* ((_e204252204287_
                                      (##vector-ref _content204242204255_ '1))
                                     (_e204253204290_
                                      (##vector-ref _content204242204255_ '2))
                                     (_k204293_ _e204253204290_))
                                (_K204249204284_ _k204293_))
                              (___match206600206601_))))))))
            (if (##structure-direct-instance-of?
                 _msg204224204232_
                 'std/actor/message#message::t)
                (let* ((_e204228204306_ (##vector-ref _msg204224204232_ '1))
                       (_content204309_ _e204228204306_)
                       (_e204229204311_ (##vector-ref _msg204224204232_ '2))
                       (_src204314_ _e204229204311_)
                       (_e204230204316_ (##vector-ref _msg204224204232_ '3))
                       (_dest204319_ _e204230204316_))
                  (_K204227204303_ _dest204319_ _src204314_ _content204309_))
                (_E204226204236_)))
          '#!void)))
  (define std/actor/rpc/connection#rpc-send-error-responses
    (lambda (_what204169_)
      (let _lp204171_ ()
        (let _loop204173204175_ ()
          (let ((_next204179_ (std/actor/message#mailbox-next)))
            (if (eq? _next204179_ std/actor/message#mailbox-empty)
                ((lambda () (thread-mailbox-rewind) '#!void))
                ((lambda (_msg204183_)
                   (let* ((_msg204185204193_ _msg204183_)
                          (_else204188204201_
                           (lambda () (_loop204173204175_))))
                     (let ((_K204191204217_
                            (lambda (_msg204215_)
                              (thread-mailbox-extract-and-rewind)
                              (std/actor/rpc/connection#rpc-send-error-response
                               _msg204215_
                               _what204169_)
                              (_lp204171_)))
                           (_K204190204207_
                            (lambda (_ignore204205_)
                              (thread-mailbox-extract-and-rewind)
                              (_lp204171_))))
                       (if (##structure-direct-instance-of?
                            _msg204185204193_
                            'std/actor/message#message::t)
                           (let ((_msg204220_ _msg204185204193_))
                             (_K204191204217_ _msg204220_))
                           (let ((_ignore204210_ _msg204185204193_))
                             (_K204190204207_ _ignore204210_))))))
                 _next204179_))))))))
