/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import au.com.trgtd.tr.appl.Constants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.logging.Logger;
import tr.extract.Extract;
import tr.model.Data;
import tr.model.future.Future;

public class ExtractSomedayMaybe {
    private static final Logger LOG = Logger.getLogger("tr.extract");
    private static final DateFormat df = Constants.DATE_FORMAT_FIXED;

    public static void process(Data data, File xmlfile) {
        try {
            Writer out = ExtractSomedayMaybe.initialise(xmlfile);
            ExtractSomedayMaybe.process(data, out);
            ExtractSomedayMaybe.finalise(out);
        }
        catch (Exception ex) {
            LOG.severe("Extracting someday/maybe failed: " + ex.getMessage());
        }
    }

    private static Writer initialise(File xmlfile) throws Exception {
        if (xmlfile.exists()) {
            xmlfile.delete();
        }
        FileOutputStream fout = new FileOutputStream(xmlfile);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        return out;
    }

    private static void finalise(Writer out) throws Exception {
        out.flush();
        out.close();
    }

    public static void process(Data data, Writer out) {
        try {
            LOG.info("Extracting someday/maybe ... ");
            ExtractSomedayMaybe.writeItems(data, out);
            LOG.info("Extracting someday/maybe ... done");
        }
        catch (Exception ex) {
            LOG.severe("Extracting someday/maybe failed: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static void writeItems(Data data, Writer out) throws Exception {
        out.write("<somedays>\r\n");
        for (Future future : data.getFutureManager().list()) {
            out.write("<someday>\r\n");
            out.write("<created>" + df.format(future.getCreated()) + "</created>\r\n");
            out.write("<descr>" + ExtractSomedayMaybe.escape(future.getDescription()) + "</descr>\r\n");
            out.write("<topic>" + ExtractSomedayMaybe.escape(future.getTopic().getName()) + "</topic>\r\n");
            out.write("<notes>" + ExtractSomedayMaybe.escape(future.getNotes().trim()) + "</notes>\r\n");
            if (future.getTickle() != null) {
                out.write("<tickle>" + df.format(future.getTickle()) + "</tickle>\r\n");
            }
            out.write("</someday>\r\n");
        }
        out.write("</somedays>\r\n");
    }

    private static String escape(String string) {
        return Extract.FormatType.XML.escape(string);
    }
}

