/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.solr.util.SystemIdResolver;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public abstract class IndexSchemaFactory
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static IndexSchema buildIndexSchema(String resourceName, SolrConfig config) {
        return IndexSchemaFactory.newIndexSchemaFactory(config).create(resourceName, config);
    }

    public static IndexSchemaFactory newIndexSchemaFactory(SolrConfig config) {
        IndexSchemaFactory factory;
        PluginInfo info = config.getPluginInfo(IndexSchemaFactory.class.getName());
        if (null != info) {
            factory = config.getResourceLoader().newInstance(info.className, IndexSchemaFactory.class);
            factory.init(info.initArgs);
        } else {
            factory = config.getResourceLoader().newInstance(ManagedIndexSchemaFactory.class.getName(), IndexSchemaFactory.class);
        }
        return factory;
    }

    public String getSchemaResourceName(String cdResourceName) {
        return cdResourceName;
    }

    public IndexSchema create(String resourceName, SolrConfig config) {
        SolrResourceLoader loader = config.getResourceLoader();
        InputStream schemaInputStream = null;
        if (null == resourceName) {
            resourceName = "schema.xml";
        }
        try {
            schemaInputStream = loader.openSchema(resourceName);
        }
        catch (Exception e) {
            String msg = "Error loading schema resource " + resourceName;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
        InputSource inputSource = new InputSource(schemaInputStream);
        inputSource.setSystemId(SystemIdResolver.createSystemIdFromResourceName(resourceName));
        IndexSchema schema = new IndexSchema(resourceName, inputSource, config.luceneMatchVersion, loader);
        return schema;
    }
}

