# How you can help: your first commits!

If you’re interested in contributing to Bundler, that’s awesome! We’d love your help.

If at any point you get stuck, here's how to [get in touch with the Bundler team for help](GETTING_HELP.md).

## First contribution suggestions

We track [small bugs and features](https://github.com/bundler/bundler/labels/contribution%3A%20small) so that anyone who wants to help can start with something that's not too overwhelming.

Generally, great ways to get started helping out with Bundler are:

  - using prerelease versions (run `gem install bundler --pre`)
  - [reporting bugs you encounter or suggesting new features](https://github.com/bundler/bundler/issues/new)
    - see our [issues guide](ISSUES.md) for help on filing issues
    - see the [new features documentation](../development/NEW_FEATURES.md) for more
  - adding to or editing [the Bundler documentation website](http://bundler.io) and [Bundler man pages](http://bundler.io/man/bundle.1.html)
  - [checking issues for completeness](BUG_TRIAGE.md)
  - closing issues that are not complete
  - adding a failing test for reproducible [reported bugs](https://github.com/bundler/bundler/issues)
  - reviewing [pull requests](https://github.com/bundler/bundler/pulls) and suggesting improvements
  - improving existing code, including suggestions from [PullReview](https://www.pullreview.com/github/bundler/bundler/reviews/master) or [CodeClimate](https://codeclimate.com/github/bundler/bundler)
  - writing code (no patch is too small! fix typos or bad whitespace)
    - get started setting up your dev environment with [these instructions](../development/DEVELOPMENT_SETUP.md)
  - backfilling [unit tests](https://github.com/bundler/bundler/tree/master/spec/bundler) for modules that lack [coverage](https://codeclimate.com/github/bundler/bundler/coverage)

If nothing on those lists looks good, [talk to us](http://slack.bundler.io/), and we'll figure out what you can help with. We can absolutely use your help, no matter what level of programming skill you have at the moment.
