/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(38u, 35u) | (- uvec2(38u, 35u))) => uvec2(4294967294u, 4294967295u)
 * (uvec2(38u, 35u) | (- uvec2(64u, 9u))) => uvec2(4294967270u, 4294967287u)
 * (uvec2(64u, 9u) | (- uvec2(38u, 35u))) => uvec2(4294967258u, 4294967261u)
 * (uvec2(64u, 9u) | (- uvec2(64u, 9u))) => uvec2(4294967232u, 4294967295u)
 */
#version 130

void main()
{
  float[all(equal((uvec2(38u, 35u) | (- uvec2(38u, 35u))), uvec2(4294967294u, 4294967295u))) ? 1 : -1] array0;
  float[all(equal((uvec2(38u, 35u) | (- uvec2(64u, 9u))), uvec2(4294967270u, 4294967287u))) ? 1 : -1] array1;
  float[all(equal((uvec2(64u, 9u) | (- uvec2(38u, 35u))), uvec2(4294967258u, 4294967261u))) ? 1 : -1] array2;
  float[all(equal((uvec2(64u, 9u) | (- uvec2(64u, 9u))), uvec2(4294967232u, 4294967295u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
