/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.Domain;
import onl.netfishers.netshot.device.Module;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.NetworkInterface;
import onl.netfishers.netshot.device.PhysicalAddress;
import onl.netfishers.netshot.device.attribute.ConfigLongTextAttribute;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tester {
    private static Logger logger = LoggerFactory.getLogger(Tester.class);

    public static void createDevices() {
        List<Device.NetworkClass> networkClasses = Arrays.asList(Device.NetworkClass.values());
        try {
            for (int i = 1000; i < 1050; ++i) {
                Session session = Database.getSession();
                session.beginTransaction();
                Domain domain = (Domain)session.load(Domain.class, (Serializable)Long.valueOf(1L));
                Network4Address deviceAddress = new Network4Address(Network4Address.intToIP(0xA100000 + i), 32);
                Device device = new Device("CiscoIOS12", deviceAddress, domain, "Tester");
                device.setName(String.format("TEST%05d", i));
                device.setLocation("Fake location");
                device.setContact("Fake contact");
                device.setFamily("Fake Cisco IOS");
                device.setNetworkClass(networkClasses.get(new Random().nextInt(networkClasses.size())));
                device.setStatus(Device.Status.INPRODUCTION);
                device.setComments(String.format("Fake device %d ", i));
                ArrayList<Config> configs = new ArrayList<Config>();
                int configNumber = 100 + new Random().nextInt(300);
                int configLength = 100000 + new Random().nextInt(1200000);
                StringBuilder runningConfig = new StringBuilder();
                long baseDate = new Date().getTime();
                long[] configDates = new Random().longs(configNumber, baseDate - 94608000000L, baseDate).sorted().toArray();
                for (int j = 0; j < configNumber; ++j) {
                    Config config = new Config(device);
                    config.setAuthor("Fake");
                    String configPiece = "!This is a fake IOS configuration\r\ninterface Loopback0\r\n ip address 1.1.1.1 255.255.255.255\r\n!\r\n" + String.format("snmp-server contact CONF %05d\r\n", j) + "!";
                    while (runningConfig.length() < configLength) {
                        runningConfig.append(configPiece);
                    }
                    configLength += new Random().nextInt(1000);
                    config.setChangeDate(new Date(1000L * (configDates[j] / 1000L)));
                    config.addAttribute(new ConfigLongTextAttribute(config, "runningConfig", runningConfig.toString()));
                    configs.add(config);
                    device.setLastConfig(config);
                    if (j % 10 != 0) continue;
                    logger.warn(String.format("Device %05d, config %05d", i, j));
                }
                device.setConfigs(configs);
                ArrayList<NetworkInterface> netInterfaces = new ArrayList<NetworkInterface>();
                NetworkInterface managementInterface = new NetworkInterface(device, "Loopback0", "", "", true, true, "Management interface");
                managementInterface.addIpAddress(deviceAddress);
                managementInterface.setPhysicalAddress(new PhysicalAddress(16 << 32 + i));
                netInterfaces.add(managementInterface);
                device.setNetworkInterfaces(netInterfaces);
                ArrayList<Module> modules = new ArrayList<Module>();
                Module module = new Module();
                module.setDevice(device);
                module.setPartNumber("FAKE");
                module.setSlot("Fake Slot 0");
                module.setSerialNumber(String.format("ABCDXYZ%03X", i));
                modules.add(module);
                device.setModules(modules);
                session.save(device);
                session.getTransaction().commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.warn("Done");
    }
}

