/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.script.helper;

import java.io.File;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.device.access.Ssh;
import onl.netfishers.netshot.device.attribute.AttributeDefinition;
import onl.netfishers.netshot.device.attribute.ConfigBinaryAttribute;
import onl.netfishers.netshot.device.attribute.ConfigBinaryFileAttribute;
import onl.netfishers.netshot.device.attribute.ConfigLongTextAttribute;
import onl.netfishers.netshot.device.attribute.ConfigNumericAttribute;
import onl.netfishers.netshot.device.attribute.ConfigTextAttribute;
import onl.netfishers.netshot.work.TaskLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsConfigHelper {
    private static Logger logger = LoggerFactory.getLogger(JsConfigHelper.class);
    private final Device device;
    private Config config;
    private TaskLogger taskLogger;
    private Cli cli;

    public JsConfigHelper(Device device, Config config, Cli cli, TaskLogger taskLogger) {
        this.device = device;
        this.config = config;
        this.cli = cli;
        this.taskLogger = taskLogger;
    }

    public void set(String key, Double value) {
        if (value == null) {
            return;
        }
        try {
            DeviceDriver driver = this.device.getDeviceDriver();
            for (AttributeDefinition attribute : driver.getAttributes()) {
                if (!attribute.getLevel().equals((Object)AttributeDefinition.AttributeLevel.CONFIG) || !attribute.getName().equals(key)) continue;
                switch (attribute.getType()) {
                    case NUMERIC: {
                        this.config.addAttribute(new ConfigNumericAttribute(this.config, key, value));
                        break;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.warn("Error during snapshot while setting config attribute key '{}'.", (Object)key);
        }
    }

    public void set(String key, Boolean value) {
        if (value == null) {
            return;
        }
        try {
            DeviceDriver driver = this.device.getDeviceDriver();
            for (AttributeDefinition attribute : driver.getAttributes()) {
                if (!attribute.getLevel().equals((Object)AttributeDefinition.AttributeLevel.CONFIG) || !attribute.getName().equals(key)) continue;
                switch (attribute.getType()) {
                    case BINARY: {
                        this.config.addAttribute(new ConfigBinaryAttribute(this.config, key, value));
                        break;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.warn("Error during snapshot while setting config attribute key '{}'.", (Object)key);
            this.taskLogger.error(String.format("Can't set device attribute %s: %s", key, e.getMessage()));
        }
    }

    public void set(String key, Object value) {
        block9: {
            if (value == null) {
                return;
            }
            try {
                DeviceDriver driver = this.device.getDeviceDriver();
                if ("author".equals(key)) {
                    this.config.setAuthor((String)value);
                    break block9;
                }
                for (AttributeDefinition attribute : driver.getAttributes()) {
                    if (!attribute.getLevel().equals((Object)AttributeDefinition.AttributeLevel.CONFIG) || !attribute.getName().equals(key)) continue;
                    switch (attribute.getType()) {
                        case LONGTEXT: {
                            this.config.addAttribute(new ConfigLongTextAttribute(this.config, key, (String)value));
                            break;
                        }
                        case TEXT: {
                            this.config.addAttribute(new ConfigTextAttribute(this.config, key, (String)value));
                            break;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while setting config attribute key '{}'.", (Object)key);
                this.taskLogger.error(String.format("Can't set device attribute %s: %s", key, e.getMessage()));
            }
        }
    }

    public void download(String key, String method, String remoteFileName, String storeFileName) throws Exception {
        block20: {
            if (remoteFileName == null) {
                return;
            }
            String storeName = storeFileName;
            if (storeName != null && "".equals(storeName = storeName.trim())) {
                storeName = null;
            }
            if (storeName == null) {
                try {
                    storeName = new File(remoteFileName).getName();
                    storeName = storeName.trim();
                    storeName = storeName.replaceAll("[^0-9_a-zA-Z\\(\\)\\%\\-\\.]", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (storeName != null && "".equals(storeName = storeName.trim())) {
                storeName = null;
            }
            try {
                DeviceDriver driver = this.device.getDeviceDriver();
                if ("scp".equals(method)) {
                    for (AttributeDefinition attribute : driver.getAttributes()) {
                        if (!attribute.getLevel().equals((Object)AttributeDefinition.AttributeLevel.CONFIG) || !attribute.getName().equals(key)) continue;
                        if (AttributeDefinition.AttributeType.BINARYFILE.equals((Object)attribute.getType())) {
                            if (this.cli instanceof Ssh) {
                                ConfigBinaryFileAttribute fileAttribute = new ConfigBinaryFileAttribute(this.config, key, storeName);
                                ((Ssh)this.cli).scpDownload(remoteFileName, fileAttribute.getFileName().toString());
                                fileAttribute.setFileSize(fileAttribute.getFileName().length());
                                this.config.addAttribute(fileAttribute);
                            } else {
                                logger.warn("Error during snapshot: can't use SCP method with non-SSH CLI access (for attribute '{}').", (Object)key);
                                this.taskLogger.error(String.format("Can't use SCP method with non-SSH CLI access (for attribute '{}').", key));
                            }
                        } else {
                            logger.warn("Error during snapshot: can't use SCP download method on non-binary-file attribute '{}'.", (Object)key);
                            this.taskLogger.error(String.format("Can't use SCP download method on attribute '%s' which is not of type binary-file.", key));
                        }
                        break block20;
                    }
                    break block20;
                }
                if ("sftp".equals(method)) {
                    for (AttributeDefinition attribute : driver.getAttributes()) {
                        if (!attribute.getLevel().equals((Object)AttributeDefinition.AttributeLevel.CONFIG) || !attribute.getName().equals(key)) continue;
                        if (AttributeDefinition.AttributeType.BINARYFILE.equals((Object)attribute.getType())) {
                            if (this.cli instanceof Ssh) {
                                ConfigBinaryFileAttribute fileAttribute = new ConfigBinaryFileAttribute(this.config, key, storeName);
                                ((Ssh)this.cli).sftpDownload(remoteFileName, fileAttribute.getFileName().toString());
                                fileAttribute.setFileSize(fileAttribute.getFileName().length());
                                this.config.addAttribute(fileAttribute);
                            } else {
                                logger.warn("Error during snapshot: can't use SFTP method with non-SSH CLI access (for attribute '{}').", (Object)key);
                                this.taskLogger.error(String.format("Can't use SFTP method with non-SSH CLI access (for attribute '{}').", key));
                            }
                        } else {
                            logger.warn("Error during snapshot: can't use SFTP download method on non-binary-file attribute '{}'.", (Object)key);
                            this.taskLogger.error(String.format("Can't use SFTPdownload method on attribute '%s' which is not of type binary-file.", key));
                        }
                        break block20;
                    }
                    break block20;
                }
                logger.warn("Invalid download method '{}' during snapshot.", (Object)method);
                this.taskLogger.error(String.format("Invalid download method %s", method));
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while downloading file for attribute key '{}'.", (Object)key);
                this.taskLogger.error(String.format("Error while downloading file for attribute key %s: %s", key, e.getMessage()));
                throw e;
            }
        }
    }
}

