/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.credentials;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Domain;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv1Community;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv2cCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv3Community;
import onl.netfishers.netshot.device.credentials.DeviceSshAccount;
import onl.netfishers.netshot.device.credentials.DeviceSshKeyAccount;
import onl.netfishers.netshot.device.credentials.DeviceTelnetAccount;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.jasypt.hibernate4.type.EncryptedStringType;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DeviceSnmpv1Community.class, name="SNMP v1"), @JsonSubTypes.Type(value=DeviceSnmpv2cCommunity.class, name="SNMP v2"), @JsonSubTypes.Type(value=DeviceSnmpv3Community.class, name="SNMP v3"), @JsonSubTypes.Type(value=DeviceSshAccount.class, name="SSH"), @JsonSubTypes.Type(value=DeviceSshKeyAccount.class, name="SSH Key"), @JsonSubTypes.Type(value=DeviceTelnetAccount.class, name="Telnet")})
@TypeDefs(value={@TypeDef(name="credentialString", typeClass=EncryptedStringType.class, parameters={@Parameter(name="encryptorRegisteredName", value="credentialEncryptor")})})
public class DeviceCredentialSet {
    protected Date changeDate;
    private int version;
    protected long id;
    protected String name;
    protected Domain mgmtDomain;
    protected boolean deviceSpecific = false;

    protected DeviceCredentialSet() {
    }

    public DeviceCredentialSet(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceCredentialSet)) {
            return false;
        }
        DeviceCredentialSet other = (DeviceCredentialSet)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    @Version
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @XmlElement
    @XmlID
    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    @XmlElement
    @NaturalId(mutable=true)
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    @ManyToOne
    public Domain getMgmtDomain() {
        return this.mgmtDomain;
    }

    public void setMgmtDomain(Domain domain) {
        this.mgmtDomain = domain;
    }

    @XmlElement
    public boolean isDeviceSpecific() {
        return this.deviceSpecific;
    }

    public void setDeviceSpecific(boolean specific) {
        this.deviceSpecific = specific;
    }

    public static String generateSpecificName() {
        return String.format("DEVICESPECIFIC-%s", UUID.randomUUID());
    }
}

