/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.compliance;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.compliance.CheckResult;
import onl.netfishers.netshot.compliance.Exemption;
import onl.netfishers.netshot.compliance.Policy;
import onl.netfishers.netshot.compliance.rules.JavaScriptRule;
import onl.netfishers.netshot.compliance.rules.TextRule;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.work.TaskLogger;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"policy", "name"})})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY, property="type")
public abstract class Rule {
    private static Logger logger = LoggerFactory.getLogger(Rule.class);
    private static final Set<Class<? extends Rule>> RULE_CLASSES = new HashSet<Class<? extends Rule>>();
    protected boolean enabled = false;
    protected long id;
    protected Policy policy = null;
    protected String name = "";
    private Set<Exemption> exemptions = new HashSet<Exemption>();
    private Set<CheckResult> checkResults = new HashSet<CheckResult>();

    public static final Set<Class<? extends Rule>> getRuleClasses() {
        return RULE_CLASSES;
    }

    protected Rule() {
    }

    public Rule(String name, Policy policy) {
        this.name = name;
        this.policy = policy;
    }

    protected void setCheckResult(Device device, CheckResult.ResultOption result, String comment, Session session) {
        CheckResult checkResult = new CheckResult(this, device, result);
        checkResult.setComment(comment);
        if (session.contains(this)) {
            session.saveOrUpdate(checkResult);
        } else {
            this.checkResults.add(checkResult);
        }
    }

    public void check(Device device, Session session, TaskLogger taskLogger) {
        logger.warn("Called generic rule check.");
        if (!this.isEnabled()) {
            this.setCheckResult(device, CheckResult.ResultOption.DISABLED, "", session);
        } else if (device.isExempted(this)) {
            this.setCheckResult(device, CheckResult.ResultOption.EXEMPTED, "", session);
        } else {
            this.setCheckResult(device, CheckResult.ResultOption.NOTAPPLICABLE, "", session);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        return this.id == other.id;
    }

    @Id
    @GeneratedValue
    @XmlElement
    public long getId() {
        return this.id;
    }

    @ManyToOne
    public Policy getPolicy() {
        return this.policy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    @XmlElement
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="key.rule", cascade={CascadeType.ALL}, orphanRemoval=true)
    public Set<Exemption> getExemptions() {
        return this.exemptions;
    }

    public void setExemptions(Set<Exemption> exemptions) {
        this.exemptions = exemptions;
    }

    public void deleteExemption(Exemption exemption) {
        this.exemptions.remove(exemption);
    }

    public void addExemption(Exemption exemption) {
        this.exemptions.add(exemption);
    }

    public void clearExemptions() {
        this.exemptions.clear();
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="key.rule", cascade={CascadeType.ALL}, orphanRemoval=true)
    public Set<CheckResult> getCheckResults() {
        return this.checkResults;
    }

    public void setCheckResults(Set<CheckResult> checkResults) {
        this.checkResults = checkResults;
    }

    public boolean deleteCheckResult(CheckResult checkResult) {
        return this.checkResults.remove(checkResult);
    }

    public boolean addCheckResult(CheckResult checkResult) {
        return this.checkResults.add(checkResult);
    }

    public void clearCheckResults() {
        this.checkResults.clear();
    }

    static {
        RULE_CLASSES.add(JavaScriptRule.class);
        RULE_CLASSES.add(TextRule.class);
    }
}

