/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.aaa;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.EAPMD5Authenticator;
import net.jradius.client.auth.EAPMSCHAPv2Authenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_NASPort;
import net.jradius.dictionary.Attr_NASPortType;
import net.jradius.dictionary.Attr_ServiceType;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.aaa.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class Radius {
    private static Logger logger = LoggerFactory.getLogger(Radius.class);
    private static Logger aaaLogger = LoggerFactory.getLogger("AAA");
    private static List<RadiusClient> clients = new ArrayList<RadiusClient>();
    private static Class<? extends RadiusAuthenticator> authMethod = MSCHAPv2Authenticator.class;

    private static void loadServerConfig(int id) {
        RadiusClient client;
        InetAddress address;
        String path = String.format("netshot.aaa.radius%d", id);
        String ip = Netshot.getConfig(path + ".ip", ".");
        try {
            address = InetAddress.getByName(ip);
        }
        catch (Exception e) {
            logger.error("Invalid IP address for RADIUS server {}. Will be ignored.", (Object)id);
            return;
        }
        int authPort = 1812;
        try {
            authPort = Integer.parseInt(Netshot.getConfig(path + ".authport", "1812"));
        }
        catch (NumberFormatException e) {
            logger.error("Invalid authentication port number for RADIUS server {}. Will use {}.", (Object)id, (Object)authPort);
        }
        int acctPort = 1813;
        try {
            acctPort = Integer.parseInt(Netshot.getConfig(path + ".acctport", "1813"));
        }
        catch (NumberFormatException e) {
            logger.error("Invalid accounting port number for RADIUS server {}. Will use {}.", (Object)id, (Object)acctPort);
        }
        int timeout = 5;
        try {
            timeout = Integer.parseInt(Netshot.getConfig(path + ".timeout", "5"));
        }
        catch (NumberFormatException e) {
            logger.error("Invalid timeout value for RADIUS server {}. Will use {}.", (Object)id, (Object)timeout);
        }
        String key = Netshot.getConfig(path + ".secret");
        if (key == null) {
            logger.error("No key configured for RADIUS server {}. Will be ignored.", (Object)id);
            return;
        }
        try {
            client = new RadiusClient(address, key, authPort, acctPort, timeout);
        }
        catch (IOException e) {
            logger.error("Unable to create the RADIUS client for server {}.", (Object)id, (Object)e);
            return;
        }
        String method = Netshot.getConfig("netshot.aaa.radius.method");
        if ("pap".equals(method)) {
            authMethod = PAPAuthenticator.class;
        } else if ("chap".equals(method)) {
            authMethod = CHAPAuthenticator.class;
        } else if ("eap-md5".equals(method)) {
            authMethod = EAPMD5Authenticator.class;
        } else if ("eap-mschapv2".equals(method)) {
            authMethod = EAPMSCHAPv2Authenticator.class;
        } else if (method != null && !"mschapv2".equals(method)) {
            logger.error("Invalid configured RADIUS method '{}'. Defaulting to MSCHAPv2.", (Object)method);
        }
        clients.add(client);
    }

    public static boolean isAvailable() {
        return clients.size() > 0;
    }

    public static User authenticate(String username, String password) {
        if (!Radius.isAvailable()) {
            return null;
        }
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attr_UserName((Serializable)((Object)username)));
        attributeList.add(new Attr_NASPortType(Attr_NASPortType.Ethernet));
        attributeList.add(new Attr_NASPort(new Long(1L)));
        for (RadiusClient radiusClient : clients) {
            AccessRequest request = new AccessRequest(radiusClient, attributeList);
            request.addAttribute(new Attr_UserPassword((Serializable)((Object)password)));
            try {
                RadiusResponse reply = radiusClient.authenticate(request, authMethod.newInstance(), 3);
                if (reply == null) {
                    logger.error("Request to RADIUS server {} timed out.", (Object)radiusClient.getRemoteInetAddress().toString());
                    aaaLogger.error(MarkerFactory.getMarker("AAA"), "Request to RADIUS server {} timed out.", (Object)radiusClient.getRemoteInetAddress().toString());
                    continue;
                }
                if (reply instanceof AccessAccept) {
                    int level = 10;
                    try {
                        Long serviceType = (Long)reply.getAttributeValue(6L);
                        if (Attr_ServiceType.AdministrativeUser.equals(serviceType)) {
                            level = 1000;
                        } else if (Attr_ServiceType.OutboundUser.equals(serviceType)) {
                            level = 500;
                        } else if (Attr_ServiceType.NASPromptUser.equals(serviceType)) {
                            level = 100;
                        }
                    }
                    catch (Exception serviceType) {
                        // empty catch block
                    }
                    aaaLogger.info(MarkerFactory.getMarker("AAA"), "The user {} passed authentication on RADIUS server {} (with permission level {}).", username, radiusClient.getRemoteInetAddress().toString(), level);
                    User user = new User(username, level);
                    return user;
                }
                aaaLogger.info(MarkerFactory.getMarker("AAA"), "The user {} failed authentication on RADIUS server {}.", (Object)username, (Object)radiusClient.getRemoteInetAddress().toString());
                return null;
            }
            catch (Exception e) {
                logger.error("Error while authenticating against RADIUS server {}.", (Object)radiusClient.getRemoteInetAddress().toString(), (Object)e);
            }
        }
        return null;
    }

    static {
        AttributeFactory.loadAttributeDictionary("net.jradius.dictionary.AttributeDictionaryImpl");
        for (int i = 1; i < 4; ++i) {
            Radius.loadServerConfig(i);
        }
    }
}

