"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsManagementActionRegistry = void 0;

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var actions = new Map();
var SavedObjectsManagementActionRegistry = {
  register: function register(action) {
    if (!action.id) {
      throw new TypeError('Saved Objects Management Actions must have an id');
    }

    if (actions.has(action.id)) {
      throw new Error("Saved Objects Management Action with id '".concat(action.id, "' already exists"));
    }

    actions.set(action.id, action);
  },
  has: function has(actionId) {
    return actions.has(actionId);
  },
  get: function get() {
    return Array.from(actions.values());
  }
};
exports.SavedObjectsManagementActionRegistry = SavedObjectsManagementActionRegistry;