"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var uuid = __importStar(require("uuid"));
function identity(value) {
    return value;
}
exports.identity = identity;
function compareByValueAsc(firstEl, secondEl) {
    return firstEl - secondEl;
}
exports.compareByValueAsc = compareByValueAsc;
function clamp(value, min, max) {
    return Math.min(Math.max(value, min), max);
}
exports.clamp = clamp;
/**
 * This function returns a function to generate ids.
 * This can be used to generate unique, but predictable ids to pair labels
 * with their inputs. It takes an optional prefix as a parameter. If you don't
 * specify it, it generates a random id prefix. If you specify a custom prefix
 * it should begin with an letter to be HTML4 compliant.
 */
function htmlIdGenerator(idPrefix) {
    var prefix = idPrefix || "i" + uuid.v1();
    return function (suffix) { return prefix + "_" + (suffix || uuid.v1()); };
}
exports.htmlIdGenerator = htmlIdGenerator;
function getPartialValue(base, partial, partials) {
    if (partials === void 0) { partials = []; }
    var partialWithValue = partial !== undefined ? partial : partials.find(function (v) { return v !== undefined; });
    return partialWithValue !== undefined ? partialWithValue : base;
}
exports.getPartialValue = getPartialValue;
/**
 * Returns all top-level keys from one or more objects
 * @param object - first object to get keys
 * @param objects
 */
function getAllKeys(object, objects) {
    if (objects === void 0) { objects = []; }
    return objects.reduce(function (keys, obj) {
        if (obj && typeof obj === 'object') {
            keys.push.apply(keys, __spread(Object.keys(obj)));
        }
        return keys;
    }, Object.keys(object));
}
exports.getAllKeys = getAllKeys;
function hasPartialObjectToMerge(base, partial, additionalPartials) {
    if (additionalPartials === void 0) { additionalPartials = []; }
    if (Array.isArray(base)) {
        return false;
    }
    if (typeof base === 'object') {
        if (typeof partial === 'object' && !Array.isArray(partial)) {
            return true;
        }
        return additionalPartials.some(function (p) { return typeof p === 'object' && !Array.isArray(p); });
    }
    return false;
}
exports.hasPartialObjectToMerge = hasPartialObjectToMerge;
function shallowClone(value) {
    if (Array.isArray(value)) {
        return __spread(value);
    }
    if (typeof value === 'object' && value !== null) {
        return __assign({}, value);
    }
    return value;
}
exports.shallowClone = shallowClone;
/**
 * Merges values of a partial structure with a base structure.
 *
 * @note No nested array merging
 *
 * @param base structure to be duplicated, must have all props of `partial`
 * @param partial structure to override values from base
 *
 * @returns new base structure with updated partial values
 */
function mergePartial(base, partial, options, additionalPartials) {
    if (options === void 0) { options = {}; }
    if (additionalPartials === void 0) { additionalPartials = []; }
    var baseClone = shallowClone(base);
    if (hasPartialObjectToMerge(base, partial, additionalPartials)) {
        if (partial !== undefined && options.mergeOptionalPartialValues) {
            getAllKeys(partial, additionalPartials).forEach(function (key) {
                if (!(key in baseClone)) {
                    baseClone[key] =
                        partial[key] !== undefined
                            ? partial[key]
                            : (additionalPartials.find(function (v) { return v[key] !== undefined; }) || {})[key];
                }
            });
        }
        return Object.keys(base).reduce(function (newBase, key) {
            var partialValue = partial && partial[key];
            var partialValues = additionalPartials.map(function (v) { return (typeof v === 'object' ? v[key] : undefined); });
            var baseValue = base[key];
            newBase[key] = mergePartial(baseValue, partialValue, options, partialValues);
            return newBase;
        }, baseClone);
    }
    return getPartialValue(baseClone, partial, additionalPartials);
}
exports.mergePartial = mergePartial;
function isNumberArray(value) {
    return Array.isArray(value) && value.every(function (element) { return typeof element === 'number'; });
}
exports.isNumberArray = isNumberArray;
//# sourceMappingURL=commons.js.map