"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var utils_1 = require("../../../../state/utils");
var specs_1 = require("../../utils/specs");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var __1 = require("../../..");
var getSpecs = function (state) { return state.specs; };
exports.getAxisSpecsSelector = re_reselect_1.default([getSpecs], function (specs) {
    return utils_1.getSpecsFromStore(specs, __1.ChartTypes.XYAxis, specs_1.SpecTypes.Axis);
})(get_chart_id_1.getChartIdSelector);
exports.getSeriesSpecsSelector = re_reselect_1.default([getSpecs], function (specs) {
    var seriesSpec = utils_1.getSpecsFromStore(specs, __1.ChartTypes.XYAxis, specs_1.SpecTypes.Series);
    return seriesSpec;
})(get_chart_id_1.getChartIdSelector);
exports.getAnnotationSpecsSelector = re_reselect_1.default([getSpecs], function (specs) {
    return utils_1.getSpecsFromStore(specs, __1.ChartTypes.XYAxis, specs_1.SpecTypes.Annotation);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_specs.js.map