"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var compute_chart_transform_1 = require("./compute_chart_transform");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var getMouseDownPosition = function (state) { return state.interactions.pointer.down; };
var getCurrentPointerPosition = function (state) {
    return state.interactions.pointer.current.position;
};
exports.getBrushAreaSelector = re_reselect_1.default([
    getMouseDownPosition,
    getCurrentPointerPosition,
    get_chart_rotation_1.getChartRotationSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    compute_chart_transform_1.computeChartTransformSelector,
], function (mouseDownPosition, cursorPosition, chartRotation, _a, chartTransform) {
    var chartDimensions = _a.chartDimensions;
    if (!mouseDownPosition) {
        return null;
    }
    var brushStart = {
        x: mouseDownPosition.position.x - chartDimensions.left,
        y: mouseDownPosition.position.y - chartDimensions.top,
    };
    if (chartRotation === 0 || chartRotation === 180) {
        var area = {
            left: brushStart.x,
            top: 0,
            width: cursorPosition.x - brushStart.x - chartDimensions.left,
            height: chartDimensions.height,
        };
        return area;
    }
    else {
        return {
            left: chartDimensions.left + chartTransform.x,
            top: brushStart.y - chartDimensions.top,
            width: chartDimensions.width,
            height: cursorPosition.y - brushStart.y - chartDimensions.top,
        };
    }
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_brush_area.js.map