"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
var compute_series_domains_1 = require("./compute_series_domains");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_specs_1 = require("./get_specs");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var utils_1 = require("../utils");
var get_series_color_map_1 = require("./get_series_color_map");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
exports.computeSeriesGeometriesSelector = re_reselect_1.default([
    get_settings_specs_1.getSettingsSpecSelector,
    get_specs_1.getSeriesSpecsSelector,
    compute_series_domains_1.computeSeriesDomainsSelector,
    get_series_color_map_1.getSeriesColorsSelector,
    get_chart_theme_1.getChartThemeSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_specs_1.getAxisSpecsSelector,
    is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
], function (settingsSpec, seriesSpecs, seriesDomainsAndData, seriesColors, chartTheme, chartDimensions, axesSpecs, isHistogramMode) {
    var xDomain = seriesDomainsAndData.xDomain, yDomain = seriesDomainsAndData.yDomain, formattedDataSeries = seriesDomainsAndData.formattedDataSeries;
    return utils_1.computeSeriesGeometries(seriesSpecs, xDomain, yDomain, formattedDataSeries, seriesColors, chartTheme, chartDimensions.chartDimensions, settingsSpec.rotation, axesSpecs, isHistogramMode);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=compute_series_geometries.js.map