"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var fast_deep_equal_1 = require("../../../../utils/fast_deep_equal");
var rendering_props_utils_1 = require("./utils/rendering_props_utils");
var rendering_1 = require("../../rendering/rendering");
var commons_1 = require("../../../../utils/commons");
var bar_values_utils_1 = require("./bar_values_utils");
var LineGeometries = /** @class */ (function (_super) {
    __extends(LineGeometries, _super);
    function LineGeometries(props) {
        var _this = _super.call(this, props) || this;
        _this.barSeriesRef = react_1.default.createRef();
        _this.renderPoints = function (linePoints, lineKey, pointStyleProps) {
            var linePointElements = [];
            linePoints.forEach(function (linePoint, pointIndex) {
                var x = linePoint.x, y = linePoint.y, transform = linePoint.transform, styleOverrides = linePoint.styleOverrides;
                var key = "line-point-" + lineKey + "-" + pointIndex;
                var pointStyle = _this.mergePointPropsWithOverrides(pointStyleProps, styleOverrides);
                var pointProps = rendering_props_utils_1.buildPointRenderProps(transform.x + x, y, pointStyle);
                linePointElements.push(react_1.default.createElement(react_konva_1.Circle, __assign({}, pointProps, { key: key })));
            });
            return linePointElements;
        };
        _this.renderLineGeoms = function () {
            var _a = _this.props, lines = _a.lines, sharedStyle = _a.sharedStyle;
            return lines.reduce(function (acc, line) {
                var seriesLineStyle = line.seriesLineStyle, seriesPointStyle = line.seriesPointStyle, seriesIdentifier = line.seriesIdentifier;
                var key = rendering_1.getSeriesIdentifierPrefixedKey(seriesIdentifier, 'line-');
                if (seriesLineStyle.visible) {
                    acc.push(_this.getLineToRender(line, sharedStyle, key));
                }
                if (seriesPointStyle.visible) {
                    acc.push.apply(acc, __spread(_this.getPointToRender(line, sharedStyle, key)));
                }
                return acc;
            }, []);
        };
        _this.barSeriesRef = react_1.default.createRef();
        _this.state = {
            overPoint: undefined,
        };
        return _this;
    }
    LineGeometries.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    LineGeometries.prototype.render = function () {
        return (react_1.default.createElement(react_konva_1.Group, { ref: this.barSeriesRef, key: 'bar_series' }, this.renderLineGeoms()));
    };
    LineGeometries.prototype.mergePointPropsWithOverrides = function (props, overrides) {
        if (!overrides) {
            return props;
        }
        return commons_1.mergePartial(props, overrides);
    };
    LineGeometries.prototype.getLineToRender = function (line, sharedStyle, key) {
        var clippings = this.props.clippings;
        var linePath = line.line, color = line.color, transform = line.transform, seriesIdentifier = line.seriesIdentifier, seriesLineStyle = line.seriesLineStyle, clippedRanges = line.clippedRanges;
        var geometryStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, this.props.highlightedLegendItem, sharedStyle);
        var lineProps = rendering_props_utils_1.buildLineRenderProps(transform.x, linePath, color, seriesLineStyle, geometryStyle);
        if (clippedRanges.length > 0) {
            return (react_1.default.createElement(react_konva_1.Group, __assign({}, clippings, { key: key }),
                react_1.default.createElement(react_konva_1.Group, { clipFunc: bar_values_utils_1.clipRanges(clippedRanges, clippings) },
                    react_1.default.createElement(react_konva_1.Path, __assign({}, lineProps))),
                react_1.default.createElement(react_konva_1.Group, { clipFunc: bar_values_utils_1.clipRanges(clippedRanges, clippings, true) },
                    react_1.default.createElement(react_konva_1.Path, __assign({}, lineProps, { dash: [5, 5], dashEnabled: true })))));
        }
        return (react_1.default.createElement(react_konva_1.Group, __assign({}, clippings, { key: key }),
            react_1.default.createElement(react_konva_1.Path, __assign({}, lineProps))));
    };
    LineGeometries.prototype.getPointToRender = function (line, sharedStyle, key) {
        var points = line.points, color = line.color, seriesIdentifier = line.seriesIdentifier, seriesPointStyle = line.seriesPointStyle;
        var geometryStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, this.props.highlightedLegendItem, sharedStyle);
        var pointStyleProps = rendering_props_utils_1.buildPointStyleProps(color, seriesPointStyle, geometryStyle);
        return this.renderPoints(points, key, pointStyleProps);
    };
    LineGeometries.defaultProps = {
        animated: false,
    };
    return LineGeometries;
}(react_1.default.Component));
exports.LineGeometries = LineGeometries;
//# sourceMappingURL=line_geometries.js.map