"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_konva_1 = require("react-konva");
var fast_deep_equal_1 = require("../../../../utils/fast_deep_equal");
var rendering_props_utils_1 = require("./utils/rendering_props_utils");
var rendering_1 = require("../../rendering/rendering");
var commons_1 = require("../../../../utils/commons");
var bar_values_utils_1 = require("./bar_values_utils");
var AreaGeometries = /** @class */ (function (_super) {
    __extends(AreaGeometries, _super);
    function AreaGeometries(props) {
        var _this = _super.call(this, props) || this;
        _this.barSeriesRef = react_1.default.createRef();
        _this.renderAreaGeoms = function () {
            var _a = _this.props, sharedStyle = _a.sharedStyle, highlightedLegendItem = _a.highlightedLegendItem, areas = _a.areas, clippings = _a.clippings;
            return areas.reduce(function (acc, glyph, i) {
                var seriesAreaLineStyle = glyph.seriesAreaLineStyle, seriesAreaStyle = glyph.seriesAreaStyle, seriesPointStyle = glyph.seriesPointStyle, seriesIdentifier = glyph.seriesIdentifier;
                if (seriesAreaStyle.visible) {
                    acc.push(_this.renderArea(glyph, sharedStyle, highlightedLegendItem, clippings));
                }
                if (seriesAreaLineStyle.visible) {
                    acc.push(_this.renderAreaLines(glyph, i, sharedStyle, highlightedLegendItem, clippings));
                }
                if (seriesPointStyle.visible) {
                    var geometryStateStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, _this.props.highlightedLegendItem, sharedStyle);
                    var pointStyleProps = rendering_props_utils_1.buildPointStyleProps(glyph.color, seriesPointStyle, geometryStateStyle);
                    acc.push.apply(acc, __spread(_this.renderPoints(glyph.points, i, pointStyleProps, glyph.seriesIdentifier)));
                }
                return acc;
            }, []);
        };
        _this.renderArea = function (glyph, sharedStyle, highlightedLegendItem, clippings) {
            var area = glyph.area, color = glyph.color, transform = glyph.transform, seriesIdentifier = glyph.seriesIdentifier, seriesAreaStyle = glyph.seriesAreaStyle, clippedRanges = glyph.clippedRanges;
            var geometryStateStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, highlightedLegendItem, sharedStyle);
            var key = rendering_1.getSeriesIdentifierPrefixedKey(seriesIdentifier, 'area-');
            var areaProps = rendering_props_utils_1.buildAreaRenderProps(transform.x, area, color, seriesAreaStyle, geometryStateStyle);
            if (clippedRanges.length > 0) {
                return (react_1.default.createElement(react_konva_1.Group, __assign({}, clippings, { key: key }),
                    react_1.default.createElement(react_konva_1.Group, { clipFunc: bar_values_utils_1.clipRanges(clippedRanges, clippings) },
                        react_1.default.createElement(react_konva_1.Path, __assign({}, areaProps))),
                    react_1.default.createElement(react_konva_1.Group, { clipFunc: bar_values_utils_1.clipRanges(clippedRanges, clippings, true) },
                        react_1.default.createElement(react_konva_1.Path, __assign({}, areaProps, { opacity: areaProps.opacity ? Number(areaProps.opacity) / 2 : 0.5 })))));
            }
            return (react_1.default.createElement(react_konva_1.Group, __assign({}, clippings, { key: key }),
                react_1.default.createElement(react_konva_1.Path, __assign({}, areaProps))));
        };
        _this.renderAreaLines = function (glyph, areaIndex, sharedStyle, highlightedLegendItem, clippings) {
            var lines = glyph.lines, color = glyph.color, seriesIdentifier = glyph.seriesIdentifier, transform = glyph.transform, seriesAreaLineStyle = glyph.seriesAreaLineStyle, clippedRanges = glyph.clippedRanges;
            var geometryStateStyle = rendering_1.getGeometryStateStyle(seriesIdentifier, highlightedLegendItem, sharedStyle);
            var groupKey = rendering_1.getSeriesIdentifierPrefixedKey(seriesIdentifier, "area-line-" + areaIndex);
            var linesElementProps = lines.map(function (linePath, lineIndex) {
                var key = rendering_1.getSeriesIdentifierPrefixedKey(seriesIdentifier, "area-line-" + areaIndex + "-" + lineIndex);
                var props = rendering_props_utils_1.buildLineRenderProps(transform.x, linePath, color, seriesAreaLineStyle, geometryStateStyle);
                return { key: key, props: props };
            });
            if (clippedRanges.length > 0) {
                return (react_1.default.createElement(react_konva_1.Group, __assign({}, clippings, { key: groupKey }),
                    react_1.default.createElement(react_konva_1.Group, { clipFunc: bar_values_utils_1.clipRanges(clippedRanges, clippings) }, linesElementProps.map(function (_a) {
                        var key = _a.key, props = _a.props;
                        return (react_1.default.createElement(react_konva_1.Path, __assign({}, props, { key: key })));
                    })),
                    react_1.default.createElement(react_konva_1.Group, { clipFunc: bar_values_utils_1.clipRanges(clippedRanges, clippings, true) }, linesElementProps.map(function (_a) {
                        var key = _a.key, props = _a.props;
                        return (react_1.default.createElement(react_konva_1.Path, __assign({}, props, { key: key, dash: [5, 5], dashEnabled: true })));
                    }))));
            }
            return (react_1.default.createElement(react_konva_1.Group, __assign({}, clippings, { key: groupKey }), linesElementProps.map(function (_a) {
                var key = _a.key, props = _a.props;
                return (react_1.default.createElement(react_konva_1.Path, __assign({}, props, { key: key })));
            })));
        };
        _this.renderPoints = function (areaPoints, areaIndex, pointStyleProps, seriesIdentifier) {
            return areaPoints.map(function (areaPoint, pointIndex) {
                var x = areaPoint.x, y = areaPoint.y, transform = areaPoint.transform, styleOverrides = areaPoint.styleOverrides;
                var key = rendering_1.getSeriesIdentifierPrefixedKey(seriesIdentifier, "area-point-" + areaIndex + "-" + pointIndex + "-");
                var pointStyle = _this.mergePointPropsWithOverrides(pointStyleProps, styleOverrides);
                var pointProps = rendering_props_utils_1.buildPointRenderProps(transform.x + x, y, pointStyle);
                return react_1.default.createElement(react_konva_1.Circle, __assign({}, pointProps, { key: key }));
            });
        };
        _this.barSeriesRef = react_1.default.createRef();
        return _this;
    }
    AreaGeometries.prototype.shouldComponentUpdate = function (nextProps) {
        return !fast_deep_equal_1.deepEqual(this.props, nextProps);
    };
    AreaGeometries.prototype.render = function () {
        return (react_1.default.createElement(react_konva_1.Group, { ref: this.barSeriesRef, key: 'bar_series' }, this.renderAreaGeoms()));
    };
    AreaGeometries.prototype.mergePointPropsWithOverrides = function (props, overrides) {
        if (!overrides) {
            return props;
        }
        return commons_1.mergePartial(props, overrides);
    };
    AreaGeometries.defaultProps = {
        animated: false,
    };
    return AreaGeometries;
}(react_1.default.Component));
exports.AreaGeometries = AreaGeometries;
//# sourceMappingURL=area_geometries.js.map