/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.plugins.FeatureSpec;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.ProjectTestFixtures;

@Incubating
public class JavaTestFixturesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().withPlugin("java", plugin -> {
            JavaPluginConvention convention = this.findJavaConvention(project);
            JavaPluginExtension extension = this.findJavaPluginExtension(project);
            SourceSet testFixtures = (SourceSet)convention.getSourceSets().create("testFixtures");
            extension.registerFeature("testFixtures", (Action<? super FeatureSpec>)((Action)featureSpec -> featureSpec.usingSourceSet(testFixtures)));
            JvmPluginsHelper.addApiToSourceSet(testFixtures, project.getConfigurations());
            this.createImplicitTestFixturesDependencies(project, convention);
        });
    }

    private void createImplicitTestFixturesDependencies(Project project, JavaPluginConvention convention) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("testFixturesApi", (Object)dependencies.create((Object)project));
        ProjectDependency testDependency = (ProjectDependency)dependencies.add(this.findTestSourceSet(convention).getImplementationConfigurationName(), (Object)dependencies.create((Object)project));
        testDependency.capabilities((Action)new ProjectTestFixtures(project));
    }

    private SourceSet findTestSourceSet(JavaPluginConvention convention) {
        return (SourceSet)convention.getSourceSets().getByName("test");
    }

    private JavaPluginExtension findJavaPluginExtension(Project project) {
        return (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
    }

    private JavaPluginConvention findJavaConvention(Project project) {
        return (JavaPluginConvention)project.getConvention().getPlugins().get("java");
    }
}

