/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CodeAnalysisMeasurement;
import org.jetbrains.kotlin.cli.common.CodeGenerationMeasurement;
import org.jetbrains.kotlin.cli.common.CompilerInitializationMeasurement;
import org.jetbrains.kotlin.cli.common.GarbageCollectionMeasurement;
import org.jetbrains.kotlin.cli.common.JitCompilationMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceCounterMeasurement;
import org.jetbrains.kotlin.cli.common.PerformanceMeasurement;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0018J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dJ\"\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010#\u001a\u00020\u0018H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020\u0018H\u0016J \u0010&\u001a\u00020\u00182\u0006\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J\b\u0010(\u001a\u00020\u0018H\u0002J\b\u0010)\u001a\u00020\u0018H\u0002J\b\u0010*\u001a\u00020\u0018H\u0002J\b\u0010+\u001a\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "", "presentableName", "", "(Ljava/lang/String;)V", "analysisStart", "", "generationStart", "initStartNanos", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "measurements", "", "Lorg/jetbrains/kotlin/cli/common/PerformanceMeasurement;", "measurements$annotations", "()V", "getMeasurements", "()Ljava/util/List;", "createPerformanceReport", "", "dumpPerformanceReport", "", "destination", "Ljava/io/File;", "enableCollectingPerformanceStatistics", "getMeasurementResults", "", "notifyAnalysisFinished", "files", "", "lines", "additionalDescription", "notifyAnalysisStarted", "notifyCompilationFinished", "notifyCompilerInitialized", "notifyGenerationFinished", "notifyGenerationStarted", "recordGcTime", "recordInitializationTime", "recordJitCompilationTime", "recordPerfCountersMeasurements", "cli"})
public abstract class CommonCompilerPerformanceManager {
    @NotNull
    private final List<PerformanceMeasurement> measurements;
    private boolean isEnabled;
    private long initStartNanos;
    private long analysisStart;
    private long generationStart;
    private final String presentableName;

    protected static /* synthetic */ void measurements$annotations() {
    }

    @NotNull
    protected final List<PerformanceMeasurement> getMeasurements() {
        return this.measurements;
    }

    protected final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @NotNull
    public final List<PerformanceMeasurement> getMeasurementResults() {
        return this.measurements;
    }

    public final void enableCollectingPerformanceStatistics() {
        this.isEnabled = true;
        PerformanceCounter.Companion.setTimeCounterEnabled(true);
    }

    public void notifyCompilerInitialized() {
        if (!this.isEnabled) {
            return;
        }
        this.recordInitializationTime();
    }

    public void notifyCompilationFinished() {
        if (!this.isEnabled) {
            return;
        }
        this.recordGcTime();
        this.recordJitCompilationTime();
        this.recordPerfCountersMeasurements();
    }

    public void notifyAnalysisStarted() {
        this.analysisStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyAnalysisFinished(int files2, int lines, @Nullable String additionalDescription) {
        long time = PerformanceCounter.Companion.currentTime() - this.analysisStart;
        Collection collection = this.measurements;
        CodeAnalysisMeasurement codeAnalysisMeasurement = new CodeAnalysisMeasurement(files2, lines, TimeUnit.NANOSECONDS.toMillis(time), additionalDescription);
        boolean bl = false;
        collection.add(codeAnalysisMeasurement);
    }

    public void notifyGenerationStarted() {
        this.generationStart = PerformanceCounter.Companion.currentTime();
    }

    public void notifyGenerationFinished(int lines, int files2, @NotNull String additionalDescription) {
        Intrinsics.checkParameterIsNotNull((Object)additionalDescription, (String)"additionalDescription");
        long time = PerformanceCounter.Companion.currentTime() - this.generationStart;
        Collection collection = this.measurements;
        CodeGenerationMeasurement codeGenerationMeasurement = new CodeGenerationMeasurement(lines, files2, TimeUnit.NANOSECONDS.toMillis(time), additionalDescription);
        boolean bl = false;
        collection.add(codeGenerationMeasurement);
    }

    public final void dumpPerformanceReport(@NotNull File destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        FilesKt.writeBytes((File)destination, (byte[])this.createPerformanceReport());
    }

    private final void recordGcTime() {
        if (!this.isEnabled) {
            return;
        }
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            Collection collection = this.measurements;
            GarbageCollectorMXBean garbageCollectorMXBean = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)garbageCollectorMXBean, (String)"it");
            String string = garbageCollectorMXBean.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
            GarbageCollectionMeasurement garbageCollectionMeasurement = new GarbageCollectionMeasurement(string, it.getCollectionTime());
            boolean bl2 = false;
            collection.add(garbageCollectionMeasurement);
        }
    }

    private final void recordJitCompilationTime() {
        if (!this.isEnabled) {
            return;
        }
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean == null) {
            return;
        }
        CompilationMXBean bean = compilationMXBean;
        Collection collection = this.measurements;
        JitCompilationMeasurement jitCompilationMeasurement = new JitCompilationMeasurement(bean.getTotalCompilationTime());
        boolean bl = false;
        collection.add(jitCompilationMeasurement);
    }

    private final void recordInitializationTime() {
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.initStartNanos);
        Collection collection = this.measurements;
        CompilerInitializationMeasurement compilerInitializationMeasurement = new CompilerInitializationMeasurement(time);
        boolean bl = false;
        collection.add(compilerInitializationMeasurement);
    }

    private final void recordPerfCountersMeasurements() {
        PerformanceCounter.Companion.report((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ CommonCompilerPerformanceManager this$0;

            public final void invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                Collection collection = this.this$0.getMeasurements();
                PerformanceCounterMeasurement performanceCounterMeasurement = new PerformanceCounterMeasurement(s);
                boolean bl = false;
                collection.add(performanceCounterMeasurement);
            }
            {
                this.this$0 = commonCompilerPerformanceManager;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] createPerformanceReport() {
        void $this$mapTo$iv$iv;
        boolean bl = false;
        Comparable<StringBuilder> comparable = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $receiver = comparable;
        boolean bl4 = false;
        StringBuilder stringBuilder = $receiver;
        String string = this.presentableName + " performance report";
        boolean bl5 = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        Iterable $this$map$iv = this.measurements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerformanceMeasurement performanceMeasurement = (PerformanceMeasurement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            String string2 = it.render();
            collection.add(string2);
        }
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl7 = false;
            StringBuilder stringBuilder3 = $receiver;
            boolean bl8 = false;
            StringBuilder stringBuilder4 = stringBuilder3.append(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
        }
        String string3 = comparable.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String string4 = string3;
        comparable = Charsets.UTF_8;
        bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string5.getBytes((Charset)comparable);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public CommonCompilerPerformanceManager(@NotNull String presentableName2) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)presentableName2, (String)"presentableName");
        this.presentableName = presentableName2;
        CommonCompilerPerformanceManager commonCompilerPerformanceManager = this;
        boolean bl = false;
        commonCompilerPerformanceManager.measurements = list2 = (List)new ArrayList();
        this.initStartNanos = PerformanceCounter.Companion.currentTime();
    }
}

