<-- This file is part 12 of the GNU version of
    The Collaborative International Dictionary of English (GCIDE)

    Copyright (C) 1992-2012 Patrick J. Cassidy

    GCIDE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3, or (at your option)
    any later version.

    GCIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this copy of GCIDE.  If not, see <http://www.gnu.org/licenses/>.
-->

<p><-- p. 821 --></p>

<p><centered><point26>L.</point26></centered><br/
[<source>1913 Webster</source>]</p>

<p><ent>L</ent><br/
<hw>L</hw> <pr>(<ecr/l)</pr> <pos>n.</pos> <sn>1.</sn> <def>L is the twelfth letter of the English alphabet, and a vocal consonant. It is usually called a <xex>semivowel</xex> or <xex>liquid</xex>. Its form and value are from the Greek, through the Latin, the form of the Greek letter being from the Ph<oe/nician, and the ultimate origin prob. Egyptian. Etymologically, it is most closely related to <xex>r</xex> and <xex>u</xex>; as in pi<xex>l</xex>grim, pe<xex>r</xex>egrine, co<xex>u</xex>ch (fr. co<xex>ll</xex>ocare), a<xex>u</xex>bura (fr. LL. a<xex>l</xex>burnus).</def><br/
[<source>1913 Webster</source>]</p>

<p><note>    At the end of monosyllables containing a single vowel, it is often doubled, as in <xex>fall</xex>, <xex>full</xex>, <xex>bell</xex>; but not after digraphs, as in <xex>foul</xex>, <xex>fool</xex>, <xex>prowl</xex>, <xex>growl</xex>, <xex>foal</xex>. In English words, the terminating syllable <xex>le</xex> is unaccented, the <xex>e</xex> is silent, and <xex>l</xex> is preceded by a voice glide, as in <xex>able</xex>, <xex>eagle</xex>, pronounced <pr><amac/"b'l</pr>, <pr><emac/"g'l</pr>.
    See <it>Guide to Pronunciation</it>, <sect/241.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>As a numeral, L stands for fifty in the English, as in the Latin language.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For 50 the Romans used the Chalcidian <it>chi</it>, <?/, which assumed the less difficult lapidary type, <?/, and was then easily assimilated to L.</q> <rj><qau>I. Taylor (The Alphabet).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>L</ent><br/
<hw>L</hw> <pr>(<ecr/l)</pr>, <pos>n.</pos> <sn>1.</sn> <def>An extension at right angles to the length of a main building, giving to the ground plan a form resembling the letter <boxtype>L</boxtype>; sometimes less properly applied to a narrower, or lower, extension in the direction of the length of the main building; a wing.</def> <altsp>[Written also <asp>ell</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mech.)</fld> <def>A short right-angled pipe fitting, used in connecting two pipes at right angles.</def> <altsp>[Written also <asp>ell</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>L</ent><br/
<hw>L</hw>, <pos>a.</pos> <sn>1.</sn> <def>Having the general shape of the (capital) letter <universbold>L</universbold>; <as>as, an <universbold>L</universbold> beam, or <universbold>L</universbold>-beam</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>Elevated; -- a symbol for <altname>el.</altname> as an abbreviation of <xex>elevated</xex> in  <xex>elevated road</xex> or  <xex>railroad</xex>.</def> -- <def2><pos>n.</pos>  <def>An elevated road; <as>as, to ride on the <ex>L</ex></as>.</def> <mark>[Colloq., U. S.]</mark></def2><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>La</ent><br/
<hw>La</hw> <pr>(l<aum/)</pr>, <pos>n.</pos> <fld>(Mus.)</fld> <sd>(a)</sd> <def>A syllable applied to the sixth tone of the scale in music in solmization.</def> <sd>(b)</sd> <def>The tone A; -- so called among the French and Italians.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>La</ent><br/
<hw>La</hw> <pr>(?)</pr>, <pos>interj.</pos> <ety>[Cf. <er>Lo</er>.]</ety> <sn>1.</sn> <def>Look; see; behold; -- sometimes followed by <xex>you</xex>.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An exclamation of surprise; -- commonly followed by <xex>me</xex>; <as>as, <ex>La</ex> me!</as></def> <mark>[Low]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>laager</ent><br/
<hw>laa"ger</hw> <pr>(l<add/"g<etil/r <it>or</it> l<aum/"g<etil/r)</pr>, <pos>n.</pos> <ety>[D., also <ets>leger</ets>. Cf. 2d <er>Leaguer</er>, <er>Lair</er>.]</ety> <def>A camp, especially one surrounded by a circular formation of travelers' wagons for temporary defense.</def> <mark>[South Africa]</mark><br/
<syn><b>Syn. --</b> lager.</syn><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>Wagons . . . can be readily formed into a <qex>laager</qex>, a camp, by being drawn into a circle, with the oxen placed inside and so kept safe from the attacks of wild beasts.</q>  <rj><qau>James Bryce.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Laager</ent><br/
<hw>Laa"ger</hw>, <pos>v. t. & i.</pos> <ety>[From <er>Laager</er>, <pos>n.</pos>]</ety> <def>To form into, or camp in, a laager, or protected camp.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Laas</ent><br/
<hw>Laas</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A lace. See <er>Lace</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lab</ent><br/
<hw>Lab</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[Cf. OD. <ets>labben</ets> to babble.]</ety> <def>To prate; to gossip; to babble; to blab.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lab</ent><br/
<hw>lab</hw>, <pos>n.</pos> <sn>1.</sn> <def>A telltale; a prater; a blabber.</def> <mark>[Obs.]</mark> <ldquo/I am no <xex>lab</xex>.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[By truncation of <ets>laboratory</ets>.]</ety> <def>Laboratory.</def> <mark>[Colloq.]</mark><br/
[<source>PJC</source>]</p>

<p><ent>lab</ent><br/
<hw>lab</hw>, <pos>a.</pos> <def>Of or pertaining to a laboratory; <as>as, a <ex>lab</ex> bench</as>.</def> <mark>[Colloq.]</mark><br/
[<source>PJC</source>]</p>

<p><ent>Labadist</ent><br/
<hw>Lab"a*dist</hw>, <pos>n.</pos> <fld>(Eccl. Hist.)</fld> <def>A follower of <person>Jean de <etsep>Labadie</etsep></person>, a religious teacher of the 17th century, who left the Roman Catholic Church and taught a kind of mysticism, and the obligation of community of property among Christians.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labarraque's solution</ent><br/
<hw>La`bar`raque's" so*lu"tion</hw> <pr>(?)</pr> <pos>n.</pos> <ety>[From <persfn><etsep>Labarraque</etsep></persfn>, a Parisian apothecary.]</ety> <fld>(Med.)</fld> <def>An aqueous solution of sodium hypochlorite, extensively used as a disinfectant.</def><br/
[<source>1913 Webster</source>]</p>

<p><note>Sodium hypochlorite is the same compound used in the commercial trademarked bleach Clorox(TM).  It has both disinfectant and bleaching activity.</note><br/
[<source>PJC</source>]</p>

<p><ent>Labarum</ent><br/
\'d8<hw>Lab"a*rum</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Labara</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <def>The standard adopted by the Emperor Constantine after his conversion to Christianity. It is described as a pike bearing a silk banner hanging from a crosspiece, and surmounted by a golden crown. It bore a monogram of the first two letters (<CHI/<RHO/) (which appear like the English letters X and P), of the name of Christ in its Greek form. Later, the name was given to various modifications of this standard.</def>
<-- Illustration of monogram, an X (Greek CHI) superimposed on a lengthened P (Greek RHO) --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labdanum</ent><br/
<hw>Lab"da*num</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>See <er>Ladanum</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labefaction</ent><br/
<hw>Lab`e*fac"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Labefy</er>.]</ety> <def>The act of labefying or making weak; the state of being weakened; decay; ruin.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There is in it such a <qex>labefaction</qex> of all principles as may be injurious to morality.</q> <rj><qau>Johnson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labefy</ent><br/
<hw>Lab"e*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L. <ets>labefacere</ets>; <ets>labare</ets> to totter + <ets>facere</ets> to make.]</ety> <def>To weaken or impair.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Label</ent><br/
<hw>La"bel</hw> <pr>(l<amac/"b<ecr/l)</pr>, <pos>n.</pos> <ety>[OF. <ets>label</ets> sort of ribbon or fringe, label in heraldry, F. <ets>lambeau</ets> shred, strip, rag; of uncertain origin; cf. L. <ets>labellum</ets>, dim. of <ets>labrum</ets> lip, edge, margin, G. <ets>lappen</ets> flap, patch, rag, tatter (cf. <er>Lap</er> of a dress), W. <ets>llab</ets>, <ets>llabed</ets>, label, flap, Gael. <ets>leab</ets>, <ets>leob</ets>, slice, shred, hanging lip.]</ety> <sn>1.</sn> <def>A tassel.</def> <mark>[Obs.]</mark>  <rj><au>Huloet.</au>  <au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A slip of silk, paper, parchment, etc., affixed to anything, and indicating, usually by an inscription, the contents, ownership, destination, etc.; <as>as, the <ex>label</ex> of a bottle or a package</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A slip of ribbon, parchment, etc., attached to a document to hold the appended seal; also, the seal.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A writing annexed by way of addition, as a codicil added to a will.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Her.)</fld> <def>A barrulet, or, rarely, a bendlet, with pendants, or points, usually three, especially used as a mark of cadency to distinguish an eldest or only son while his father is still living.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A brass rule with sights, formerly used, in connection with a circumferentor, to take altitudes.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Gothic Arch.)</fld> <def>The name now generally given to the projecting molding by the sides, and over the tops, of openings in medi<ae/val architecture.  It always has a square form, as in the illustration.</def>  <rj><au>Arch. Pub. Soc.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>In medi<ae/val art, the representation of a band or scroll containing an inscription.</def>  <rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Label</ent><br/
<hw>La"bel</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Labeled</conjf> <pr>(l<amac/"b<ecr/ld)</pr> or <conjf>Labelled</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Labeling</conjf> or <conjf>Labelling</conjf>.]</vmorph> <sn>1.</sn> <def>To affix a label to; to mark with a name, etc.; <as>as, to <ex>label</ex> a bottle or a package</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To affix in or on a label.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labeler</ent><br/
<hw>La"bel*er</hw> <pr>(l<amac/"b<ecr/l*<etil/r)</pr>, <pos>n.</pos> <def>One who labels.</def> <altsp>[Written also <asp>labeller</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labellum</ent><br/
\'d8<hw>La*bel"lum</hw> <pr>(l<adot/*b<ecr/l"l<ucr/m)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Labella</plw> <pr>(l<adot/*b<ecr/l"l<adot/)</pr>, E. <plw>Labellums</plw> <pr>(l<adot/*b<ecr/l"l<ucr/mz)</pr>.</plu> <ety>[L., dim. of <ets>labrum</ets> lip.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>The lower or apparently anterior petal of an orchidaceous flower, often of a very curious shape.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A small appendage beneath the upper lip or labrum of certain insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labent</ent><br/
<hw>La"bent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>labens</ets>, p. pr. of <ets>labi</ets> to slide, glide.]</ety> <def>Slipping; sliding; gliding.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labia</ent><br/
\'d8<hw>La"bi*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>See <er>Labium</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labial</ent><br/
<hw>La"bi*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[LL. <ets>labialis</ets>, fr. L. <ets>labium</ets> lip: cf. F. <ets>labial</ets>. See <er>Lip</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to the lips or labia; <as>as, <ex>labial</ex> veins</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>Furnished with lips; <as>as, a <ex>labial</ex> organ pipe</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Phonetics)</fld> <sd>(a)</sd> <def>Articulated, as a consonant, mainly by the lips, as b, p, m, w.</def> <sd>(b)</sd> <def>Modified, as a vowel, by contraction of the lip opening, as <oomac/ (f<oomac/d), <omac/ (<omac/ld), etc., and as <it>eu</it> and <it>u</it> in French, and <it><oum/</it>, <it><uum/</it> in German. See Guide to Pronunciation, <sect/<sect/ 11, 178.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>Of or pertaining to the labium; <as>as, the <ex>labial</ex> palpi of insects</as>. See <er>Labium</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labial</ent><br/
<hw>La"bi*al</hw>, <pos>n.</pos> <sn>1.</sn> <fld>(Phonetics)</fld> <def>A letter or character representing an articulation or sound formed or uttered chiefly with the lips, as <stype>b</stype>, <stype>p</stype>, <stype>w</stype>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>An organ pipe that is furnished with lips; a flue pipe.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>One of the scales which border the mouth of a fish or reptile.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labialism</ent><br/
<hw>La"bi*al*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Phonetics)</fld> <def>The quality of being labial; <as>as, the <ex>labialism</ex> of an articulation</as>; conversion into a labial, as of a sound which is different in another language.</def>  <rj><au>J. Peile.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labialization</ent><br/
<hw>La`bi*al*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Phonetics)</fld> <def>The modification of an articulation by contraction of the lip opening.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labialize</ent><br/
<hw>La"bi*al*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <fld>(Phonetics)</fld> <def>To modify by contraction of the lip opening.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labially</ent><br/
<hw>La"bi*al*ly</hw>, <pos>adv.</pos> <def>In a labial manner; with, or by means of, the lips.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labiate</ent><br/
<hw>La"bi*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To labialize.</def>  <rj><au>Brewer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labiate</ent><br/
<hw>La"bi*ate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[NL. <ets>labiatus</ets>, fr. L. <ets>labium</ets> lip.]</ety> <fld>(Bot.)</fld> <sd>(a)</sd> <def>Having the limb of a tubular corolla or calyx divided into two unequal parts, one projecting over the other like the lips of a mouth, as in the snapdragon, sage, and catnip.</def> <sd>(b)</sd> <def>Belonging to a natural order of plants (<ord>Labiat<ae/</ord>), of which the mint, sage, and catnip are examples. They are mostly aromatic herbs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labiate</ent><br/
<hw>La"bi*ate</hw>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A plant of the order <ord>Labiat<ae/</ord>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labiated</ent><br/
<hw>La"bi*a`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Bot.)</fld> <def>Same as <er>Labiate</er>, <pos>a.</pos> <sd>(a)</sd>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labiatifloral</ent><br/
<ent>Labiatifloral</ent><br/
<mhw>{ <hw>La`bi*a`ti*flo"ral</hw> <pr>(?)</pr>, <hw>La`bi*a`ti*flo"ral</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Labiate</ets> + L. <ets>flos</ets>, <ets>floris</ets>, flower.]</ety> <fld>(Bot.)</fld> <def>Having labiate flowers, as the snapdragon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labidometer</ent><br/
<hw>Lab`i*dom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>labi`s</grk>, <grk>-i`dos</grk>, a forceps + <ets>meter</ets>:  cf. F. <ets>labidometre</ets>.]</ety> <fld>(Med.)</fld> <def>A forceps with a measuring attachment for ascertaining the size of the fetal head.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labile</ent><br/
<hw>La"bile</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>labilis</ets> apt to slip, fr. <ets>labi</ets> to slip.]</ety> <sn>1.</sn> <def>Liable to slip, err, fall, or apostatize.</def> <mark>[Obs.]</mark>  <rj><au>Cheyne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Liable or likely to change.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <fld>(Chem.)</fld> <def>Easily decomposed or inactivated when subjected to heat, radiation, or mildly acidic or alkaline conditions; -- of chemical compounds; <as>as, enzymes from thermophilic organisms are not as <ex>labile</ex> as those from mesophiles</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lability</ent><br/
<hw>La*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>Liability to lapse, err, or apostatize.</def> <mark>[Archaic]</mark>  <rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The property of changing readily.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <fld>(Chem.)</fld> <def>The property of being labile{3}; -- of chemical compounds; <as>as, the <ex>lability</ex> of some natural products makes them difficult to isolate and identify</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Labimeter</ent><br/
<hw>La*bim"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>labimetre</ets>.]</ety> <fld>(Med.)</fld> <def>See <er>Labidometer</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labiodental</ent><br/
<hw>La`bi*o*den"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Labium</ets> + <ets>dental</ets>.]</ety> <fld>(Phonetics)</fld> <def>Formed or pronounced by the cooperation of the lips and teeth, as <xex>f</xex> and <xex>v</xex>.</def> -- <def2><pos>n.</pos> <def>A labiodental sound or letter.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labionasal</ent><br/
<hw>La`bi*o*na"sal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Labium</ets> + <ets>nasal</ets>.]</ety> <fld>(Phonetics)</fld> <def>Formed by the lips and the nose.</def> -- <def2><pos>n.</pos> <def>A labionasal sound or letter.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labioplasty</ent><br/
<hw>La"bi*o*plas`ty</hw> <pr>(l<amac/"b<icr/*<osl/*pl<acr/s`t<ycr/)</pr>, <pos>n.</pos>  <ety>[<ets>Labium</ets> + <ets>-plasty</ets>.]</ety> <fld>(Surg.)</fld> <def>A plastic operation for making a new lip, or for replacing a lost tissue of a lip.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Labiose</ent><br/
<hw>La"bi*ose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Labium</er>.]</ety> <fld>(Bot.)</fld> <def>Having the appearance of being labiate; -- said of certain polypetalous corollas.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labipalp</ent><br/
<hw>La"bi*palp</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A labial palp.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Labipalpus</ent><br/
\'d8<hw>La`bi*pal"pus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Labipalpi</plw> <pr>(<?/)</pr>.</plu> <ety>[NL. See <er>Labium</er>, and <er>Palpus</er>.]</ety> <fld>(Zool.)</fld> <def>One of the labial palpi of an insect. See <xex>Illust.</xex> under <er>Labium</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labium</ent><br/
\'d8<hw>La"bi*um</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Labia</plw> <pr>(#)</pr>, E. <plw>Labiums</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <sn>1.</sn> <def>A lip, or liplike organ.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The lip of an organ pipe.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <fld>(Anat.)</fld> <def>The folds of integument at the opening of the vulva.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The organ of insects which covers the mouth beneath, and serves as an under lip. It consists of the second pair of maxill<ae/, usually closely united in the middle line, but bearing a pair of palpi in most insects. It often consists of a thin anterior part (<part>ligula</part> or <part>palpiger</part>) and a firmer posterior plate (<part>mentum</part>).</def> <sd>(b)</sd> <def>Inner margin of the aperture of a shell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lablab</ent><br/
<hw>Lab"lab</hw> <pr>(l<acr/b"l<acr/b)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>an East Indian name for several twining leguminous plants related to the bean, but commonly applied to the hyacinth bean (<spn>Dolichos Lablab</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labor</ent><br/
<hw>La"bor</hw> <pr>(l<amac/"b<etil/r)</pr>, <pos>n.</pos> <ety>[OE. <ets>labour</ets>, OF. <ets>labour</ets>, <ets>laber</ets>, <ets>labur</ets>, F. <ets>labeur</ets>, L. <ets>labor</ets>; cf. Gr. <grk>lamba`nein</grk> to take, Skr. <ets>labh</ets> to get, seize.]</ety> <altsp>[Written also <asp>labour</asp>.]</altsp> <sn>1.</sn> <def>Physical toil or bodily exertion, especially when fatiguing, irksome, or unavoidable, in distinction from sportive exercise; hard, muscular effort directed to some useful end, as agriculture, manufactures, and like; servile toil; exertion; work.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God hath set<br/
<qex>Labor</qex> and rest, as day and night, to men<br/
Successive.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Intellectual exertion; mental effort; <as>as, the <ex>labor</ex> of compiling a history</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which requires hard work for its accomplishment; that which demands effort.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Being a <qex>labor</qex> of so great a difficulty, the exact performance thereof we may rather wish than look for.</q> <rj><qau>Hooker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Travail; the pangs and efforts of childbirth.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The queen's in <qex>labor</qex>,<br/
They say, in great extremity; and feared<br/
She'll with the <qex>labor</qex> end.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Any pang or distress.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Naut.)</fld> <def>The pitching or tossing of a vessel which results in the straining of timbers and rigging.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <ety>[Sp.]</ety> <def>A measure of land in Mexico and Texas, equivalent to an area of 177<frac17/ acres.</def>  <rj><au>Bartlett.</au></rj></p>

<p><sn>8.</sn> <fld>(Mining.)</fld>  <def>A stope or set of stopes.</def> <mark>[Sp. Amer.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><syn><b>Syn.</b> -- Work; toil; drudgery; task; exertion; effort; industry; painstaking. See <er>Toll</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labor</ent><br/
<hw>La"bor</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Labored</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laboring</conjf>.]</vmorph> <ety>[OE. <ets>labouren</ets>, F. <ets>labourer</ets>, L. <ets>laborare</ets>. See <er>Labor</er>, <pos>n.</pos>]</ety> <altsp>[Written also <asp>labour</asp>.]</altsp> <sn>1.</sn> <def>To exert muscular strength; to exert one's strength with painful effort, particularly in servile occupations; to work; to toil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Adam, well may we <qex>labor</qex> still to dress<br/
This garden.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To exert one's powers of mind in the prosecution of any design; to strive; to take pains.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To be oppressed with difficulties or disease; to do one's work under conditions which make it especially hard, wearisome; to move slowly, as against opposition, or under a burden; to be burdened; -- often with <xex>under</xex>, and formerly with <xex>of</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The stone that <qex>labors</qex> up the hill.</q> <rj><qau>Granville.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The line too <qex>labors</qex>, and the words move slow.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To cure the disorder under which he <qex>labored</qex>.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Come unto me, all ye that <qex>labor</qex> and are heavy laden, and I will give you rest.</q> <rj><qau>Matt. xi. 28</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To be in travail; to suffer the pangs of childbirth; to be in labor.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Naut.)</fld> <def>To pitch or roll heavily, as a ship in a turbulent sea.</def>  <rj><au>Totten.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labor</ent><br/
<hw>La"bor</hw>, <pos>v. t.</pos> <ety>[F. <ets>labourer</ets>, L. <ets>laborare</ets>.]</ety> <sn>1.</sn> <def>To work at; to work; to till; to cultivate by toil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The most excellent lands are lying fallow, or only <qex>labored</qex> by children.</q> <rj><qau>W. Tooke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To form or fabricate with toil, exertion, or care.</def> <ldquo/To <xex>labor</xex> arms for Troy.<rdquo/  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To prosecute, or perfect, with effort; to urge strenuously; <as>as, to <ex>labor</ex> a point or argument</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To belabor; to beat.</def> <mark>[Obs.]</mark>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laborant</ent><br/
<hw>Lab"o*rant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>laborans</ets>, p. pr. of <ets>laborare</ets> to labor.]</ety> <def>A chemist.</def> <mark>[Obs.]</mark>  <rj><au>Boyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laboratory</ent><br/
<hw>Lab"o*ra*to*ry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Laboratories</plw> <pr>(#)</pr>.</plu> <ety>[Shortened fr. <ets>elaboratory</ets>; cf. OF. <ets>elaboratoire</ets>, F. <ets>laboratoire</ets>. See <er>Elaborate</er>, <er>Labor.</er>]</ety> <altsp>[Formerly written also <asp>elaboratory</asp>.]</altsp> <sn>1.</sn> <def>The workroom of a chemist; also, a place devoted to experiments in any branch of natural science; <as>as, a chemical, physical, or biological <ex>laboratory</ex></as>. Hence, by extension, a place where something is prepared, or some operation is performed; <as>as, the liver is the <ex>laboratory</ex> of the bile</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>Hence:</specif> <def>Any place, activity or situation suggestive of a scientific laboratory{1}, especially in being conducive to learning new facts by experimentation or by systematic observation; <as>as, the states serve as <ex>laboratories</ex> where different new policies may be tested prior to adoption throughout the country</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Labor Day</ent><br/
<hw>Labor Day</hw>. <def>In most of the States and Territories of the United States, a day, usually the first Monday of September, set aside as a legal holiday, in honor of, or in the interest of, workingmen as a class. Also, a similar holiday in Canada, Australia, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Labored</ent><br/
<hw>La"bored</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Bearing marks of labor and effort; elaborately wrought; not easy or natural; <as>as, <ex>labored</ex> poetry; a <ex>labored</ex> style.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn>  <def>appearing to require strong effort; <as>as, <ex>labored</ex> breathing</as>.</def><br/
<syn><b>Syn. --</b> heavy, laboured.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laboredly</ent><br/
<hw>La"bored*ly</hw>, <pos>adv.</pos> <def>In a labored manner; with labor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laborer</ent><br/
<hw>La"bor*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Written also <ets>labourer</ets>.]</ety> <def>One who labors in a toilsome occupation; a person who does work that requires strength rather than skill, as distinguished from that of an <contr>artisan</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laboring</ent><br/
<hw>La"bor*ing</hw>, <pos>a.</pos> <sn>1.</sn> <def>That labors; performing labor; esp., performing coarse, heavy work, not requiring skill also, set apart for labor; <as>as, <ex>laboring</ex> days</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The sleep of a <qex>laboring</qex> man is sweet.</q> <rj><qau>Eccl. v. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Suffering pain or grief.</def>  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Laboring oar</b></col>, <cd>the oar which requires most strength and exertion; often used figuratively; <as>as, to have, or pull, the <ex>laboring oar</ex> in some difficult undertaking</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laborious</ent><br/
<hw>La*bo"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laboriosus</ets>, fr. <ets>labor</ets> labor: cf. F. <ets>laborieux</ets>.]</ety> <sn>1.</sn> <def>Requiring labor, perseverance, or sacrifices; toilsome; tiresome.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Dost thou love watchings, abstinence, or toil,<br/
<qex>Laborious</qex> virtues all?  Learn these from Cato.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Devoted to labor; diligent; industrious; <as>as, a <ex>laborious</ex> mechanic</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>La*bo"ri*ous*ly</wf>, <pos>adv.</pos> -- <wf>La*bo"ri*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laborless</ent><br/
<hw>La"bor*less</hw> <pr>(l<amac/"b<etil/r*l<ecr/s)</pr>, <pos>a.</pos> <def>Not involving labor; not laborious; easy.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 822 --></p>

<p><ent>Laborous</ent><br/
<hw>La"bor*ous</hw> <pr>(l<amac/"b<etil/r*<ucr/s)</pr>, <pos>a.</pos> <def>Laborious.</def> <mark>[Obs.]</mark> <au>Wyatt.</au> -- <wordforms><wf>La"bor*ous*ly</wf>, <pos>adv.</pos> <mark>[Obs.]</mark> <au>Sir T. Elyot.</au></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labor-saving</ent><br/
<hw>La"bor-sav`ing</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Saving labor; adapted to supersede or diminish the labor of men; designed to replace or conserve human and especially manual labor; <as>as, <ex>labor-saving</ex> machinery;  <ex>labor-saving</ex> appliances{4}; <ex>labor-saving</ex> devices like washing machines</as>.</def><br/
<syn><b>Syn. --</b> laborsaving.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Laborsome</ent><br/
<hw>La"bor*some</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Made with, or requiring, great labor, pains, or diligence.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>Likely or inclined to roll or pitch, as a ship in a heavy sea; having a tendency to labor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>labour</ent><br/
<hw>la"bour</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>labor</er>; -- British spelling.</def> <mark>[Chiefly Brit.]</mark><br/
[<source>PJC</source>]</p>

<p><ent>laboured</ent><br/
<hw>laboured</hw> <pos>adj.</pos> <sn>1.</sn>  <def>same as <er>labored</er>; -- British spelling</def> <mark>[Chiefly British]</mark> <br/
<syn><b>Syn. --</b> graceless, labored, strained.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>labourer</ent><br/
<hw>labourer</hw> <pos>n.</pos> <def>a laborer; someone who works with their hands.</def> <mark>[Chiefly Brit.]</mark> <br/
<syn><b>Syn. --</b> laborer, manual laborer.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>labourious</ent><br/
<hw>labourious</hw> <pos>adj.</pos> <sn>1.</sn>  <def>characterized by toilsome effort; same as <er>laborious</er>; -- British spelling.</def> <mark>[Chiefly Brit.]</mark> <br/
<syn><b>Syn. --</b> arduous, backbreaking, back-breaking, grueling, gruelling, hard, heavy, laborious, punishing, slavish, strenuous, toilsome.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Labourite</ent><br/
<hw>Labourite</hw> <pos>n.</pos> <def>a member of the British <membof>Labour Party</membof>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Labrador</ent><br/
<hw>Lab`ra*dor"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A region of British America on the Atlantic coast, north of Newfoundland.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Labrador duck</b></col> <fld>(Zool.)</fld>, <cd>a sea duck (<spn>Camtolaimus Labradorius</spn>) allied to the eider ducks. It was formerly common on the coast of New England, but is now supposed to be extinct, no specimens having been reported since 1878.</cd> -- <col><b>Labrador feldspar</b></col>. <cd>See <er>Labradorite</er>.</cd> -- <col><b>Labrador tea</b></col> <fld>(Bot.)</fld>, <cd>a name of two low, evergreen shrubs of the genus <gen>Ledum</gen> (<spn>Ledum palustre</spn> and <spn>Ledum latifolium</spn>), found in Northern Europe and America. They are used as tea in British America, and in Scandinavia as a substitute for hops.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labradorite</ent><br/
<hw>Lab"ra*dor`ite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Min.)</fld> <def>A kind of feldspar commonly showing a beautiful play of colors, and hence much used for ornamental purposes. The finest specimens come from Labrador. See <er>Feldspar</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labras</ent><br/
<hw>La"bras</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[L. <ets>labrum</ets>; cf. It. <ets>labbro</ets>, pl. <ets>labbra</ets>.]</ety> <def>Lips.</def> <mark>[Obs. & R.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labret</ent><br/
<hw>La"bret</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>labrum</ets> lip.]</ety> <fld>(Anthropology)</fld> <def>A piece of wood, shell, stone, or other substance, worn in a perforation of the lip or cheek by many savages.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Labroid</ent><br/
<hw>La"broid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Labrus</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Like the genus <gen>Labrus</gen>; belonging to the family <fam>Labrid<ae/</fam>, an extensive family of marine fishes, often brilliantly colored, which are very abundant in the Indian and Pacific Oceans.  The tautog and cunner are American examples.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labrose</ent><br/
<hw>La"brose`</hw> <pr>(l<amac/"br<omac/s`)</pr>, <pos>a.</pos> <ety>[L. <ets>labrosus</ets>, fr. <ets>labrum</ets> lip.]</ety> <def>Having thick lips.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labrum</ent><br/
\'d8<hw>La"brum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Labra</plw> <pr>(#)</pr>, E. <plw>Labrums</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <sn>1.</sn> <def>A lip or edge, as of a basin.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>An organ in insects and crustaceans covering the upper part of the mouth, and serving as an upper lip. See <xex>Illust.</xex> of <er>Hymenoptera</er>.</def> <sd>(b)</sd> <def>The external margin of the aperture of a shell. See <er>Univalve</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labrus</ent><br/
\'d8<hw>La"brus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Labri</plw> <pr>(-br<imac/)</pr>.</plu> <ety>[L., a sort of fish.]</ety> <fld>(Zool.)</fld> <def>A genus of marine fishes, including the wrasses of Europe. See <er>Wrasse</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laburnic</ent><br/
<hw>La*bur`nic</hw> <pr>(l<adot/*b<ucir/r"n<icr/k)</pr>, <pos>a.</pos> <def>Of, pertaining to, or derived from, the laburnum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laburnine</ent><br/
<hw>La*bur`nine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A poisonous alkaloid found in the unripe seeds of the laburnum.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laburnum</ent><br/
<hw>La*bur"num</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <fld>(Bot.)</fld> <def>A small leguminous tree (<spn>Cytisus Laburnum</spn>), native of the Alps. The plant is reputed to be poisonous, esp. the bark and seeds. It has handsome racemes of yellow blossoms.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Scotch laburnum (<spn>Cytisus alpinus</spn>) is similar, but has smooth leaves; purple laburnum is <spn>Cytisus purpureus</spn>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinth</ent><br/
<hw>Lab"y*rinth</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>labyrinthus</ets>, Gr. <grk>laby`rinthos</grk>: cf. F. <ets>labyrinthe</ets>.]</ety> <sn>1.</sn> <def>An edifice or place full of intricate passageways which render it difficult to find the way from the interior to the entrance; <as>as, the Egyptian and Cretan <ex>labyrinths</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/  The <ex>Labyrinth</ex> of Classical Mythology was a vast maze constructed by Daedalus on the island of Crete, in order to confine the Minotaur; the task was done at the command of King Minos.  One theory suggests that the myth had some basis in the structure of the palace of King Minos at Knossos, in Crete, it being a multistoried royal palace with labyrinthine passages between rooms.</note><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <specif>Hence:</specif> <def>Any intricate or involved inclosure; especially, an ornamental maze or inclosure in a park or garden, having high hedges separating confusingly convoluted passages.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any object or arrangement of an intricate or involved form, or having a very complicated nature.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The serpent . . . fast sleeping soon he found,<br/
In <qex>labyrinth</qex> of many a round self-rolled.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>labyrinth</qex> of the mind.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An inextricable or bewildering difficulty.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I' the maze and winding <qex>labyrinths o' the world</qex>.</q> <rj><qau>Denham.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Anat.)</fld> <def>The internal ear. See Note under <er>Ear</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Metal.)</fld> <def>A series of canals through which a stream of water is directed for suspending, carrying off, and depositing at different distances, the ground ore of a metal.</def>  <rj><au>Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Arch.)</fld> <def>A pattern or design representing a maze, -- often inlaid in the tiled floor of a church, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Maze; confusion; intricacy; windings.</syn> <usage> -- <er>Labyrinth</er>, <er>Maze</er>. <xex>Labyrinth</xex>, originally; the name of an edifice or excavation, carries the idea of design, and construction in a permanent form, while <xex>maze</xex> is used of anything confused or confusing, whether fixed or shifting.  <xex>Maze</xex> is less restricted in its figurative uses than <xex>labyrinth</xex>. We speak of the <xex>labyrinth</xex> of the ear, or of the mind, and of a <xex>labyrinth</xex> of difficulties; but of the <xex>mazes</xex> of the dance, the <xex>mazes</xex> of political intrigue, or of the mind being in a <xex>maze</xex>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthal</ent><br/
<hw>Lab`y*rin"thal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to, or resembling, a labyrinth; intricate; labyrinthian.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthian</ent><br/
<hw>Lab`y*rin"thi*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Intricately winding; like a labyrinth; perplexed; labyrinthal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthibranch</ent><br/
<hw>Lab`y*rin"thi*branch</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Labyrinth</er>, and <er>Branchia</er>.]</ety> <fld>(Zool.)</fld> <def>Of or pertaining to the <ord>Labyrinthici</ord>.</def> -- <def2><pos>n.</pos> <def>One of the <ord>Labyrinthici</ord>.</def></def2></p>

<p><ent>Labyrinthical</ent><br/
<ent>Labyrinthic</ent><br/
<mhw>{ <hw>Lab`y*rin"thic</hw> <pr>(?)</pr>, <hw>Lab`y*rin`thic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>labyrinthicus</ets>: cf. F. <ets>labyrinthique</ets>.]</ety> <def>Like or pertaining to a labyrinth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthici</ent><br/
\'d8<hw>Lab`y*rin"thi*ci</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Labyrinth</er>.]</ety> <fld>(Zool.)</fld> <def>An order of teleostean fishes, including the Anabas, or climbing perch, and other allied fishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ They have, connected with the gill chamber, a special cavity in which a labyrinthiform membrane is arranged so as to retain water to supply the gills while the fish leaves the water and travels about on land, or even climbs trees.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthiform</ent><br/
<hw>Lab`y*rin"thi*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Labyrinth</ets> + <ets>-form</ets>: cf. F. <ets>labyrinthiforme</ets>.]</ety> <def>Having the form of a labyrinth; intricate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthine</ent><br/
<hw>Lab`y*rin"thine</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to, or like, a labyrinth; labyrinthal; labyrinthian.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthodon</ent><br/
<hw>Lab`y*rin"tho*don</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>laby`rinthos</grk> labyrinth + <grk>'odoy`s</grk>, <grk>'odo`ntos</grk>, tooth.]</ety> <fld>(Paleon.)</fld> <def>A genus of very large fossil amphibians, of the Triassic period, having bony plates on the under side of the body. It is the type of the order <ord>Labyrinthodonta</ord>. Called also <gen>Mastodonsaurus</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthodont</ent><br/
<hw>Lab`y*rin"tho*dont</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Paleon.)</fld> <def>Of or pertaining to the <ord>Labyrinthodonta</ord>.</def> -- <def2><pos>n.</pos> <def>One of the <ord>Labyrinthodonta</ord>.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Labyrinthodonta</ent><br/
\'d8<hw>Lab`y*rin`tho*don"ta</hw> <pr>(?)</pr>, <pos>prop. n. pl.</pos> <ety>[NL. See <er>Labyrinthodon</er>.]</ety> <fld>(Paleon.)</fld> <def>An extinct order of Amphibia, including the typical genus <gen>Labyrinthodon</gen>, and many other allied forms, from the Carboniferous, Permian, and Triassic formations. By recent writers they are divided into two or more orders. See <er>Stegocephala</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lakh</ent><br/
<ent>Lac</ent><br/
<mhw>{ <hw>Lac</hw> <pr>(l<acr/k)</pr>, \'d8<hw>Lakh</hw> <pr>(l<aum/k)</pr> }</mhw>, <pos>n.</pos> <ety>[Hind. <ets>lak</ets>, <ets>l<amac/kh</ets>, <ets>l<amac/ksh</ets>, Skr. <ets>laksha</ets> a mark, sign, lakh.]</ety> <def>One hundred thousand; also, a vaguely great number; <as>as, a <ex>lac</ex> of rupees</as>.</def> <altsp>[Written also <asp>lack</asp>.]</altsp> <mark>[East Indies]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lac</ent><br/
<hw>Lac</hw>, <pos>n.</pos> <ety>[Per. <ets>lak</ets>; akin to Skr. <ets>l<amac/ksh<amac/</ets>: cf. F. <ets>lague</ets>, It. & NL. <ets>lacca</ets>.  Cf. <er>Lake</er> a color, <er>Lacquer</er>, <er>Litmus</er>.]</ety> <def>A resinous substance produced mainly on the banyan tree, but to some extent on other trees, by the <spn>Laccifer lacca</spn> (formerly <spn>Coccus lacca</spn>), a scale-shaped insect, the female of which fixes herself on the bark, and exudes from the margin of her body this resinous substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <stype>Stick-lac</stype> is the substance in its natural state, incrusting small twigs. When broken off, and the coloring matter partly removed, the granular residuum is called <stype>seed-lac</stype>. When melted, and reduced to a thin crust, it is called <stype>shell-lac</stype> or <stype>shellac</stype>. Lac is an important ingredient in sealing wax, dyes, varnishes, and lacquers.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ceylon lac</b></col>, <cd>a resinous exudation of the tree <spn>Croton lacciferum</spn>, resembling lac.</cd> -- <col><b>Lac dye</b></col>, <cd>a scarlet dye obtained from stick-lac.</cd> -- <col><b>Lac lake</b></col>, <cd>the coloring matter of lac dye when precipitated from its solutions by alum.</cd> -- <col><b>Mexican lac</b></col>, <cd>an exudation of the tree <spn>Croton Draco</spn>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laccic</ent><br/
<hw>Lac"cic</hw> <pr>(l<acr/k"s<icr/k)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>laccique</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to lac, or produced from it; <as>as, <ex>laccic</ex> acid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laccin</ent><br/
<hw>Lac"cin</hw> <pr>(l<acr/k"s<icr/n)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>laccine</ets>.]</ety> <fld>(Chem.)</fld> <def>A yellow amorphous substance obtained from lac.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laccolith</ent><br/
<ent>Laccolite</ent><br/
<mhw>{ <hw>Lac"co*lite</hw> <pr>(?)</pr>, <hw>Lac"co*lith</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[Gr. <?/ a cistern + <ets>-lite</ets>, <ets>-lith</ets>.]</ety> <fld>(Geol.)</fld> <def>A mass of igneous rock intruded between sedimentary beds and resulting in a mammiform bulging of the overlying strata.</def> -- <wordforms><wf>Lac`co*lit"ic</wf> <pr>(#)</pr>, <pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lace</ent><br/
<hw>Lace</hw> <pr>(l<amac/s)</pr>, <pos>n.</pos> <ety>[OE. <ets>las</ets>, OF. <ets>laz</ets>, F. <ets>lacs</ets>, dim. <ets>lacet</ets>, fr. L. <ets>laqueus</ets> noose, snare; prob. akin to <ets>lacere</ets> to entice.  Cf. <er>Delight</er>, <er>Elicit</er>, <er>Lasso</er>, <er>Latchet</er>.]</ety> <sn>1.</sn> <def>That which binds or holds, especially by being interwoven; a string, cord, or band, usually one passing through eyelet or other holes, and used in drawing and holding together parts of a garment, of a shoe, of a machine belt, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His hat hung at his back down by a <qex>lace</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>For striving more, the more in <qex>laces</qex> strong<br/
Himself he tied.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A snare or gin, especially one made of interwoven cords; a net.</def> <mark>[Obs.]</mark>  <rj><au>Fairfax.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Vulcanus had caught thee [Venus] in his <qex>lace</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A fabric of fine threads of linen, silk, cotton, etc., often ornamented with figures; a delicate tissue of thread, much worn as an ornament of dress.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our English dames are much given to the wearing of costly <qex>laces</qex>.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Spirits added to coffee or some other beverage.</def> <mark>[Old Slang]</mark>  <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Alen<cced/on lace</b></col>, <cd>a kind of point lace, entirely of needlework, first made at Alen<cced/on in France, in the 17th century. It is very durable and of great beauty and cost.</cd> -- <mcol><col><b>Bone lace</b></col>, <col><b>Brussels lace</b></col></mcol>, <cd>etc. See under <er>Bone</er>, <er>Brussels</er>, etc.</cd> -- <mcol><col><b>Gold lace</b></col>, <it>or</it> <col><b>Silver lace</b></col></mcol>, <cd>lace having warp threads of silk, or silk and cotton, and a weft of silk threads covered with gold (or silver), or with gilt.</cd> -- <col><b>Lace leather</b></col>, <cd>thin, oil-tanned leather suitable for cutting into lacings for machine belts.</cd> -- <col><b>Lace lizard</b></col> <fld>(Zool.)</fld>, <cd>a large, aquatic, Australian lizard (<spn>Hydrosaurus giganteus</spn>), allied to the monitors.</cd> -- <col><b>Lace paper</b></col>, <cd>paper with an openwork design in imitation of lace.</cd> -- <col><b>Lace piece</b></col> <fld>(Shipbuilding)</fld>, <cd>the main piece of timber which supports the beak or head projecting beyond the stem of a ship.</cd> -- <mcol><col><b>Lace pillow</b></col>, and <col><b>Pillow lace</b></col></mcol>. <cd>See under <er>Pillow</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lace</ent><br/
<hw>Lace</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Laced</conjf> <pr>(<amac/st)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lacing</conjf> <pr>(?)</pr>.]</vmorph> <sn>1.</sn> <def>To fasten with a lace; to draw together with a lace passed through eyelet holes; to unite with a lace or laces, or, figuratively. with anything resembling laces.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When Jenny's stays are newly <qex>laced</qex>.</q> <rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To adorn with narrow strips or braids of some decorative material; <as>as, cloth <ex>laced</ex> with silver</as>.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To beat; to lash; to make stripes on.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I'll <qex>lace</qex> your coat for ye.</q> <rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To add something to (a food or beverage) so as to impart flavor, pungency, or some special quality; <as>as, to <ex>lace</ex> a punch with alcohol; to <ex>lace</ex> the Kool-Aid with LSD</as>.</def> <mark>[Old Slang]</mark><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>5.</sn> <def>To twine or draw as a lace; to interlace; to intertwine.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>The Gond . . . picked up a trail of the Karela, the vine that bears the bitter wild gourd, and <qex>laced</qex> it to and fro across the temple door.</q>  <rj><qau>Kipling.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lace</ent><br/
<hw>Lace</hw>, <pos>v. i.</pos> <def>To be fastened with a lace, or laces; <as>as, these boots <ex>lace</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lacebark</ent><br/
<hw>lacebark</hw> <pos>n.</pos> <def>A small tree or shrub (<spn>Hoheria populnea</spn>) of New Zealand having a profusion of axillary clusters of honey-scented paper-white flowers and whose bark is used for cordage.</def><br/
<syn><b>Syn. --</b> ribbonwood, houhere, <spn>Hoheria populnea</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lace-bark</ent><br/
<hw>Lace"-bark`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A shrub in the West Indies (<spn>Lagetta Iintearia</spn>); -- so called from the lacelike layers of its inner bark.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laced</ent><br/
<hw>Laced</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Fastened with a lace or laces; decorated with narrow strips or braid. See <er>Lace</er>, <pos>v. t.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Decorated with the fabric lace.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A shirt with <qex>laced</qex> ruffles.</q> <rj><qau>Fielding.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Laced mutton</b></col>, <cd>a prostitute.</cd> <mark>[Old slang]</mark> -- <col><b>Laced stocking</b></col>, <cd>a strong stocking which can be tightly laced; -- used in cases of weak legs, varicose veins, etc.</cd> <au>Dunglison.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacedaemonian</ent><br/
<hw>Lac`e*d<ae/*mo"ni*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>Lacedamonius</ets>, Gr. <grk>Lakedaimo`nios</grk>, fr. <grk>Lakedai`mwn</grk> Laced<ae/mon.]</ety> <def>Of or pertaining to Laced<ae/mon or Sparta, the chief city of Laconia in the Peloponnesus.</def> -- <def2><pos>n.</pos> <def>A Spartan.</def></def2> <altsp>[Written also <asp>Lacedemonian</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>lace into</ent><br/
<hw>lace into</hw>, <pos>v. t.</pos> <def>To attack vigorously; -- used of physical or verbal attacks; <as>as, the boss <ex>laced into</ex> him for coming to the meeting late</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Laceman</ent><br/
<hw>Lace"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lacemen</plw> <pr>(<?/)</pr>.</plu> <def>A man who deals in lace.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacerable</ent><br/
<hw>Lac"er*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lacerabilis</ets>: cf. F. <ets>lac<eacute/rable</ets>.]</ety> <def>That can be lacerated or torn.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacerate</ent><br/
<hw>Lac"er*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lacerated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lacerating</conjf> <pr>(<?/)</pr>.]</vmorph> <ety>[L. <ets>laceratus</ets>, p. p. of <ets>lacerare</ets> to lacerate, fr. <ets>lacer</ets> mangled, lacerated; cf. Gr. <?/ a rent, rending, <?/ to tear; perh. akin to E. <ets>slay</ets>.]</ety> <def>To tear; to rend; to separate by tearing; to mangle; <as>as, to <ex>lacerate</ex> the flesh</as>.</def> <specif>Hence:</specif> <def>To afflict; to torture; <as>as, to <ex>lacerate</ex> the heart</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacerated</ent><br/
<ent>Lacerate</ent><br/
<mhw>{ <hw>Lac"er*ate</hw> <pr>(?)</pr>, <hw>Lac"er*a`ted</hw> <pr>(?)</pr>, }</mhw> <pos>p. a.</pos> <ety>[L. <ets>laceratus</ets>, <ets>p. p.</ets>]</ety> <sn>1.</sn> <def>Rent; torn; mangled; <as>as, a <ex>lacerated</ex> wound</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>By each other's fury <qex>lacerate</qex></q> <rj><qau>Southey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot. & Zool.)</fld> <def>Jagged, or slashed irregularly, at the end, or along the edge.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lacerated</ent><br/
<hw>lacerated</hw> <pos>adj.</pos> <def>torn roughly; -- of skin.</def><br/
<syn><b>Syn. --</b> mangled, torn.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laceration</ent><br/
<hw>Lac`er*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>laceratio</ets>: cf. F. <ets>lac<eacute/ration</ets>.]</ety> <sn>1.</sn> <def>The act of lacerating.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A breach or wound made by lacerating.</def>  <rj><au>Arbuthnot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacerative</ent><br/
<hw>Lac"er*a*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Lacerating, or having the power to lacerate; <as>as, <ex>lacerative</ex> humors</as>.</def>  <rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacert</ent><br/
<hw>La"cert</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>lacerte</ets>. See <er>Lacertus</er>.]</ety> <def>A muscle of the human body.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacerta</ent><br/
<hw>La*cer"ta</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lacertus</ets> the arm.]</ety> <def>A fathom.</def> <mark>[Obs.]</mark>  <rj><au>Domesday Book.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacerta</ent><br/
<hw>La*cer"ta</hw>, <pos>n.</pos> <ety>[L. a lizard. See <er>Lizard</er>.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>A genus of lizards. See <er>Lizard</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Formerly it included nearly all the known lizards. It is now restricted to certain diurnal Old World species, like the green lizard (<spn>Lacerta viridis</spn>) and the sand lizard (<spn>Lacerta agilis</spn>), of Europe.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Astron.)</fld> <def>The Lizard, a northern constellation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacertian</ent><br/
<hw>La*cer"tian</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>lacertien</ets>.]</ety> <fld>(Zool.)</fld> <def>Like a lizard; of or pertaining to the <ord>Lacertilia</ord>.</def> -- <def2><pos>n.</pos> <def>One of the <ord>Lacertilia</ord>.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>lacertid</ent><br/
<hw>lacertid</hw> <pos>n.</pos> <def>Any lizard of the family <gen>Lacertidae</gen>, a family of Old World terrestrial lizard.</def><br/
<syn><b>Syn. --</b> lacertid lizard.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lacertidae</ent><br/
<hw>Lacertidae</hw> <pos>n.</pos> <def>A natural family of Old World lizards.</def><br/
<syn><b>Syn. --</b> family <gen>Lacertidae</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lacertilia</ent><br/
\'d8<hw>Lac`er*til"i*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>lacertus</ets> a lizard.]</ety> <fld>(Zool.)</fld> <def>An order of Reptilia, which includes the lizards.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ They are closely related to the snakes, and like the latter, usually have the body covered with scales or granules. They usually have eyelids, and most of then have well-formed legs; but in some groups (amphisb<ae/na, glass-snake, etc.) the legs are absent and the body is serpentlike. None are venomous, unless <gen>Heloderma</gen> be an exception. The order includes the chameleons, the <gen>Cionocrania</gen>, or typical lizards, and the amphisb<ae/nas. See <er>Amphisb<ae/na</er>, <er>Gecko</er>, <er>Gila monster</er>, and <er>Lizard</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacertilian</ent><br/
<hw>Lac`er*til"i*an</hw> <pr>(-an)</pr>, <pos>a. & n.</pos> <def>Same as <er>Lacertian</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacertiloid</ent><br/
<hw>La*cer"ti*loid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lacertilia</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Like or belonging to the <ord>Lacertilia</ord>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacertine</ent><br/
<hw>La*cer"tine</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Lacertian.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacertus</ent><br/
\'d8<hw>La*cer"tus</hw> <pr>(l<adot/*s<etil/r"t<ucr/s)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lacerti</plw> <pr>(-t<imac/)</pr>.</plu> <ety>[L., the upper arm.]</ety> <fld>(Anat.)</fld> <def>A bundle or fascicle of muscular fibers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacewing</ent><br/
<hw>Lace"wing`</hw> <pr>(l<amac/s"w<icr/ng`)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any one of several species of neuropterous insects of the genus <gen>Chrysopa</gen> and allied genera. They have delicate, lacelike wings and brilliant eyes. Their larv<ae/ are useful in destroying aphids. Called also <altname>lace-winged fly</altname>, and <altname>goldeneyed fly</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lace-winged</ent><br/
<hw>Lace"-winged`</hw>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Having thin, transparent, reticulated wings; <as>as, the <ex>lace-winged</ex> flies</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lache</ent><br/
<ent>Laches</ent><br/
<mhw>{ <hw>Lach"es</hw> <pr>(l<acr/sh"<ecr/z)</pr>, <hw>Lache</hw> <pr>(l<acr/sh)</pr>, }</mhw> <pos>n.</pos> <ety>[OF. <ets>lachesse</ets>, fr. <ets>lache</ets> lax, indolent, F. <ets>l<acir/che</ets>, ultimately fr. L. <ets>laxus</ets> loose, lax. See <er>Lax</er>.]</ety> <fld>(Law)</fld> <def>Neglect; negligence; remissness; neglect to do a thing at the proper time; especially, a delay in asserting a claim, sufficient to cause a person to lose the right to adjuducation of the claim by a court.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It ill became him to take advantage of such a <qex>laches</qex> with the eagerness of a shrewd attorney.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lachrymable</ent><br/
<hw>Lach"ry*ma*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lacrimabilis</ets>, fr. <ets>lacrima</ets> a tear.]</ety> <def>Lamentable.</def>  <rj><au>Martin Parker.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lachrymae Christi</ent><br/
\'d8<hw>Lach"ry*m<ae/ Chris"ti</hw> <pr>(?)</pr> <pos>n.</pos> <ety>[L., lit., Christ's tears.]</ety> <def>A rich, sweet, red Neapolitan wine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lachrymal</ent><br/
<hw>Lach"ry*mal</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>lacrymal</ets>. See <er>Lachrymose</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to tears; <as>as, <ex>lachrymal</ex> effusions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>Pertaining to, or secreting, tears; <as>as, the <ex>lachrymal</ex> gland</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Anat.)</fld> <def>Pertaining to the lachrymal{2} organs; <as>as, <ex>lachrymal</ex> bone; <ex>lachrymal</ex> duct.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacrymal</ent><br/
<ent>Lachrymal</ent><br/
<mhw>{ <hw>Lach"ry*mal</hw>, <hw>Lac"ry*mal</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lachrymatory</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lachrymals</ent><br/
<hw>Lach"ry*mals</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[<er>See Lachrymal</er>.]</ety> <def>Tears; also, lachrymal feelings or organs.</def> <mark>[Colloq.]</mark></p>

<p><q>People go to the theaters to have . . . their risibles and <qex>lachrymals</qex> set agoing.</q>  <rj><qau>The Lutheran.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lachrymary</ent><br/
<hw>Lach"ry*ma*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Containing, or intended to contain, tears; lachrymal.</def>  <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lachrymate</ent><br/
<hw>Lach"ry*mate</hw> <pr>(-m<amac/t)</pr>, <pos>v. i.</pos> <def>To weep.</def> <mark>[R.]</mark>  <rj><au>Blount.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lachrymation</ent><br/
<hw>Lach`ry*ma"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lacrimatio</ets>, from <ets>lacrimare</ets> to shed tears, fr. <ets>lacrima</ets> tear.]</ety> <def>The act of shedding tears; weeping.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lachrymator</ent><br/
<hw>lachrymator</hw> <pos>n.</pos> <def>A chemical substance that causes tears to flow; same as <er>lacrimator</er>.</def><br/
<syn><b>Syn. --</b> lacrimator.</syn><br/
[<source>PJC</source>]</p>

<p><ent>Lachrymatory</ent><br/
<hw>Lach"ry*ma*to*ry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> -<plw>ries</plw> <pr>(#)</pr>.</plu> <ety>[Cf. F. <ets>lacrymatoire</ets>.]</ety> <fld>(Antiq.)</fld> <def>A <ldquo/tear-bottle;<rdquo/ a narrow-necked vessel found in sepulchers of the ancient Romans; -- so called from a former notion that the tears of the deceased person's friends were collected in it. Called also <altname>lachrymal</altname> or <altname>lacrymal</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lachrymatory</ent><br/
<hw>lachrymatory</hw> <pos>adj.</pos> <def>Relating to or inducing tears; -- especially of chemical substances.</def> <see>lacrimator</see><br/
<syn><b>Syn. --</b> lacrimatory.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lachrymiform</ent><br/
<hw>Lach"ry*mi*form</hw> <pr>(?)</pr>, <pos>a.</pos>, <ety>[L. <ets>lacrima</ets> tear + <ets>-form</ets>; cf. F. <ets>lacrymiforme</ets>.]</ety> <def>Having the form of a tear; tear-shaped.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lachrymose</ent><br/
<hw>Lach"ry*mose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lacrymosus</ets>, better <ets>lacrimosus</ets>, fr. <ets>lacrima</ets>, <ets>lacruma</ets> (also badly spelt <ets>lachryma</ets>) a tear, for older <ets>dacrima</ets>, akin to E. <ets>tear</ets>. See <er>Tear</er> the secretion.]</ety> <def>Generating or shedding tears; given to shedding tears; suffused with tears; tearful.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>You should have seen his <qex>lachrymose</qex> visnomy.</q> <rj><qau>Lamb.</qau></rj></p>

<p>-- <wordforms><wf>Lach"ry*mose`ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 823 --></p>

<p><ent>Lacing</ent><br/
<hw>La"cing</hw> <pr>(l<amac/"s<icr/ng)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act of securing, fastening, or tightening, with a lace or laces.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A lace;</def> <specif>specifically</specif> <fld>(Mach.)</fld>, <def>a thong of thin leather for uniting the ends of belts.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <def>A rope or line passing through eyelet holes in the edge of a sail or an awning to attach it to a yard, gaff, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Bridge Building)</fld> <def>A system of bracing bars, not crossing each other in the middle, connecting the channel bars of a compound strut.</def>  <rj><au>Waddell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A quantity of a substance, such as an alcoholic liquor, added to a food or a drink; <as>as, punch with a <ex>lacing</ex> of rum</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>6.</sn> <def>A beating, especially with a lash.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lacinia</ent><br/
<ent>Laciniae</ent><br/
<hw>La*cin"i*a</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Lacini<ae/</plw> <pr>(#)</pr>.</plu> <ety>[L., the lappet or flap of a garment.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <sd>(a)</sd> <def>One of the narrow, jagged, irregular pieces or divisions which form a sort of fringe on the borders of the petals of some flowers.</def> <sd>(b)</sd> <def>A narrow, slender portion of the edge of a monophyllous calyx, or of any irregularly incised leaf.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The posterior, inner process of the stipes on the maxill<ae/ of insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laciniated</ent><br/
<ent>Laciniate</ent><br/
<mhw>{ <hw>La*cin"i*ate</hw> <pr>(?)</pr>, <hw>La*cin"i*a"ted</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[See <er>Lacinia</er>.]</ety> <sn>1.</sn> <def>Fringed; having a fringed border.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot. & Zool.)</fld> <def>Cut into deep, narrow, irregular lobes; slashed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laciniolate</ent><br/
<hw>La*cin"i*o*late</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Lacinia</er>.]</ety> <fld>(Bot.)</fld> <def>Consisting of, or abounding in, very minute lacini<ae/.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacinula</ent><br/
<ent>Lacinulaa</ent><br/
\'d8<hw>La*cin"u*la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lacinul<ae/</plw> <pr>(#)</pr>, E. <plw>Lacinulas</plw> <pr>(#)</pr>.</plu> <ety>[NL.]</ety> <fld>(Bot.)</fld> <def>A diminutive lacinia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lack</ent><br/
<hw>Lack</hw> <pr>(l<acr/k)</pr>, <pos>n.</pos> <ety>[OE. <ets>lak</ets>; cf. D. <ets>lak</ets> slander, <ets>laken</ets> to blame, OHG. <ets>lahan</ets>, AS. <ets>le<aacute/n</ets>.]</ety> <sn>1.</sn> <def>Blame; cause of blame; fault; crime; offense.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Deficiency; want; need; destitution; failure; <as>as, a <ex>lack</ex> of sufficient food</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She swooneth now and now for <qex>lakke</qex> of blood.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Let his <qex>lack</qex> of years be no impediment.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lack</ent><br/
<hw>Lack</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lacked</conjf> <pr>(l<acr/kt)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lacking</conjf>.]</vmorph> <sn>1.</sn> <def>To blame; to find fault with.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Love them and <qex>lakke</qex> them not.</q> <rj><qau>Piers Plowman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be without or destitute of; to want; to need.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If any of you <qex>lack</qex> wisdom, let him ask of God.</q> <rj><qau>James i. 5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lack</ent><br/
<hw>Lack</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To be wanting; often, impersonally, with <ptcl>of</ptcl>, meaning, to be less than, short, not quite, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What hour now?<br/
I think it <qex>lacks</qex> of twelve.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Peradventure there shall <qex>lack</qex> five of the fifty.</q> <rj><qau>Gen. xvii. 28.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be in want.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The young lions do <qex>lack</qex>, and suffer hunger.</q> <rj><qau>Ps. xxxiv. 10.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lack</ent><br/
<hw>Lack</hw>, <pos>interj.</pos> <ety>[Cf. <er>Alack</er>.]</ety> <def>Exclamation of regret or surprise.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lackadaisical</ent><br/
<hw>lack`a*dai"si*cal</hw> <pr>(l<acr/k`<adot/*d<amac/"z<icr/*k<ait/l)</pr>, <pos>a.</pos> <ety>[From <er>Lackadaisy</er>, <ets>interj</ets>.]</ety> <sn>1.</sn> <def>Affectedly pensive; languidly sentimental; dreamy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lacking spirit or liveliness; lethargic; listless; languid.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>Indolent; lazy; idle, especially in a dreamy manner.</def><br/
[<source>PJC</source>]</p>

<p> -- <wordforms><wf>Lack`a*dai"si*cal*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lackadaisy</ent><br/
<hw>Lack"a*dai`sy</hw> <pr>(?)</pr>, <pos>interj.</pos> <ety>[From <er>Lackaday</er>, <ets>interj</ets>.]</ety> <def>An expression of languor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lackadaisy</ent><br/
<hw>Lack"a*dai`sy</hw>, <pos>a.</pos> <def>Lackadaisical.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lackaday</ent><br/
<hw>Lack"a*day`</hw> <pr>(?)</pr>, <pos>interj.</pos> <ety>[Abbreviated from <ets>alackaday</ets>.]</ety> <def>Alack the day; alas; -- an expression of sorrow, regret, dissatisfaction, or surprise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lackbrain</ent><br/
<hw>Lack"brain`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who is deficient in understanding; a witless person.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacker</ent><br/
<hw>Lack"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who lacks or is in want.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacker</ent><br/
<hw>Lack"er</hw>, <pos>n. & v.</pos> <def>See <er>Lacquer</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lackey</ent><br/
<hw>Lack"ey</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lackeys</plw> <pr>(#)</pr>.</plu> <ety>[F. <ets>laquais</ets>; cf. Sp. & Pg. <ets>lacayo</ets>; of uncertain origin; perh. of German origin, and akin to E. <ets>lick</ets>, <pos>v.</pos>]</ety> <def>An attending male servant; a footman; a servile follower.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like a Christian footboy or a gentleman's <qex>lackey</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lackey caterpillar</b></col> <fld>(Zool.)</fld>, <cd>the caterpillar, or larva, of any bombycid moth of the genus <gen>Clisiocampa</gen>; -- so called from its party-colored markings. The common European species (<spn>Clisiocampa neustria</spn>) is striped with blue, yellow, and red, with a white line on the back. The American species (<spn>Clisiocampa Americana</spn> and <spn>Clisiocampa sylvatica</spn>) are commonly called <altname>tent caterpillars</altname>. See <cref>Tent caterpillar</cref>, under <er>Tent</er>.</cd> -- <col><b>Lackey moth</b></col> <fld>(Zool.)</fld>, <cd>the moth which produces the lackey caterpillar.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lackey</ent><br/
<hw>Lack"ey</hw>, <pos>v. t.</pos> <def>To attend as a lackey; to wait upon.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A thousand liveried angels <qex>lackey</qex> her.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lackey</ent><br/
<hw>Lack"ey</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lackeyed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lackeying</conjf>.]</vmorph> <def>To act or serve as lackey; to pay servile attendance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacklustre</ent><br/
<ent>Lackluster</ent><br/
<mhw>{ <hw>Lack"lus`ter</hw>, <hw>Lack"lus`tre</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <def>A lack of luster.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacklustre</ent><br/
<ent>Lackluster</ent><br/
<mhw>{ <hw>Lack"lus`ter</hw>, <hw>Lack"lus`tre</hw>  }</mhw> <pos>a.</pos> <sn>1.</sn> <def>Wanting luster or brightness.</def> <ldquo/<xex>Lackluster</xex> eye.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lacking spirit, liveliness, or enthusiasm; dull.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>Mediocre; <as>as, a <ex>lackluster</ex> performance</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lacmus</ent><br/
<hw>Lac"mus</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Litmus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laconian</ent><br/
<hw>La*co"ni*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Laconia, a division of ancient Greece; Spartan.</def> -- <def2><pos>n.</pos> <def>An inhabitant of Laconia; esp., a Spartan.</def></def2></p>

<p><ent>Laconic</ent><br/
<ent>Laconical</ent><br/
<mhw>{ <hw>La*con"ic</hw> <pr>(?)</pr>, <hw>La*con"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>Laconicus</ets> Laconian, Gr. <?/<?/, fr. <?/<?/ a Laconian, Laced<ae/monian, or Spartan: cf. F. <ets>laconique</ets>.]</ety> <sn>1.</sn> <def>Expressing much in few words, after the manner of the Laconians or Spartans; brief and pithy; concise; brusque; epigrammatic. In this sense <ex>laconic</ex> is the usual form.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I grow <qex>laconic</qex> even beyond laconicism; for sometimes I return only yes, or no, to questionary or petitionary epistles of half a yard long.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His sense was strong and his style <qex>laconic</qex>.</q> <rj><qau>Welwood.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Laconian; characteristic of, or like, the Spartans; hence, stern or severe; cruel; unflinching.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His head had now felt the razor, his back the rod; all that <qex>laconical</qex> discipline pleased him well.</q> <rj><qau>Bp. Hall.</qau></rj></p>

<p><syn><b>Syn.</b> -- Short; brief; concise; succinct; sententious; pointed; pithy.</syn> <usage> -- <er>Laconic</er>, <er>Concise</er>. <xex>Concise</xex> means without irrelevant or superfluous matter; it is the opposite of <xex>diffuse</xex>. <xex>Laconic</xex> means concise with the additional quality of pithiness, sometimes of brusqueness.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laconic</ent><br/
<hw>La*con"ic</hw>, <pos>n.</pos> <def>Laconism.</def> <mark>[Obs.]</mark>  <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laconical</ent><br/
<hw>La*con"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See <er>Laconic</er>, <pos>a.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laconically</ent><br/
<hw>La*con"ic*al*ly</hw>, <pos>adv.</pos> <def>In a laconic manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laconicism</ent><br/
<hw>La*con"i*cism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Laconism</er>.</def>  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laconism</ent><br/
<hw>Lac"o*nism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/, fr. <?/ to imitate Lacedaemonian manners, to speak laconically: cf. F. <ets>laconisme</ets>.]</ety> <sn>1.</sn> <def>A vigorous, brief manner of expression; laconic style.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An instance of laconic style or expression.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laconize</ent><br/
<hw>Lac"o*nize</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Laconized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laconizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Gr. <?/. See <er>Laconic</er>.]</ety> <def>To imitate the manner of the Laconians, especially in brief, pithy speech, or in frugality and austerity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacquer</ent><br/
<hw>Lac"quer</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lacre</ets> a sort of sealing wax, Pg. <ets>lacte</ets>, fr.  <ets>laca</ets> lac. See <er>Lac</er> the resin.]</ety> <altsp>[Written also <asp>lacker</asp>.]</altsp> <def>A varnish, consisting of a solution of shellac in alcohol, often colored with gamboge, saffron, or the like; -- used for varnishing metals, papier-mach<eacute/, and wood.  The name is also given to varnishes made of other ingredients, esp. the tough, solid varnish of the Japanese, with which ornamental objects are made.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacquer</ent><br/
<hw>Lac"quer</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lacquered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lacquering</conjf>.]</vmorph> <def>To cover with lacquer.</def> <ldquo/<xex>Lacquer'd</xex> chair.<rdquo/  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacquerer</ent><br/
<hw>Lac"quer*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who lacquers, especially one who makes a business of lacquering.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacquering</ent><br/
<hw>Lac"quer*ing</hw>, <pos>n.</pos> <def>The act or business of putting on lacquer; also, the coat of lacquer put on.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lacrimation</ent><br/
<hw>lacrimation</hw> <pos>n.</pos> <def>shedding tears; same as <er>lachrymation</er>.</def><br/
<syn><b>Syn. --</b> lachrymation, tearing, watering.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lacrimator</ent><br/
<hw>lacrimator</hw> <pos>n.</pos> <def>a chemical substance that causes tears to flow; same as <er>lachrymator</er>.</def><br/
<syn><b>Syn. --</b> lachrymator.</syn><br/
[<source>PJC</source>]</p>

<p><ent>lacrimatory</ent><br/
<hw>lacrimatory</hw> <pos>adj.</pos> <def>relating to or inducing tears; -- especially of chemical substances; same as <er>lachrymatory</er>.</def><br/
<syn><b>Syn. --</b> lachrymatory.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lacrimoso</ent><br/
\'d8<hw>La`cri*mo"so</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[It. See <er>Lachrymose</er>.]</ety> <fld>(Mus.)</fld> <def>Plaintive; -- a term applied to a mournful or pathetic movement or style.</def>  <rj><au>Moore.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacrosse</ent><br/
<hw>La*crosse"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>la crosse</ets>, lit., the crosier, hooked stick.  Cf. <er>Crosier</er>.]</ety> <def>A game of ball, originating among the North American Indians, now the popular field sport of Canada, and played also in England and the United States.  Each player carries a long-handled racket, called a <ldquo/<xex>crosse</xex><rdquo/.  The ball is not handled but caught with the crosse and carried on it, or tossed from it, the object being to carry it or throw it through one of the goals placed at opposite ends of the field.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacrymal</ent><br/
<hw>Lac"ry*mal</hw> <pr>(?)</pr>, <pos>n. & a.</pos> <def>See <er>Lachrymatory</er>, <pos>n.</pos>, and <er>Lachrymal</er>, <pos>a.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacrymose</ent><br/
<ent>Lacrytory</ent><br/
<ent>Lacrymary</ent><br/
<mhw>{ <hw>Lac"ry*ma*ry</hw>, <hw>Lac"ry*to*ry</hw>, <hw>Lac"ry*mose</hw>. }</mhw> <def>See <er>Lachrymary</er>, <er>Lachrymatory</er>, <er>Lachrymose</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactage</ent><br/
<hw>Lac"tage</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk: cf. F. <ets>laitage</ets>. See <er>Lacteal</er>.]</ety> <def>The produce of animals yielding milk; milk and that which is made from it.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactam</ent><br/
<hw>Lac"tam</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lact</ets>one + <ets>ami</ets>do.]</ety> <fld>(Chem.)</fld> <def>One of a series of anhydrides of an amido type, analogous to the lactones, as oxindol; a cyclic amide.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>beta-lactam</b></col> <it>or</it> <col><b><beta/-lactam</b></col></mcol>, <sd>(a)</sd> <cd>a lactam in which the amide bond is contained within a four-membered ring, which includes the amide nitrogen and the carbonyl carbon.</cd> <sd>(b)</sd> <cd>an antibiotic containing a beta-lactam, such as a <stype>penicillin</stype>, <stype>cephalosporin</stype>, or <stype>carbapenem</stype>; also called a <altname>beta-lactam antibiotic</altname>.</cd> <mark>[informal, laboratory slang]</mark></cs><br/
[<source>PJC</source>]</p>

<p><ent>Lactamic</ent><br/
<hw>Lac*tam"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an amido acid related to lactic acid, and called also <altname>amido-propionic</altname> acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactamide</ent><br/
<hw>Lac*tam"ide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lac</ets>tic + <ets>ami</ets>de.]</ety> <fld>(Chem.)</fld> <def>An acid amide derived from lactic acid, and obtained as a white crystalline substance having a neutral reaction. It is metameric with alanine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactant</ent><br/
<hw>Lac"tant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lactans</ets>, p. pr. of <ets>lactare</ets> to suck, fr. <ets>lac</ets>, <ets>lactis</ets>, milk.]</ety> <def>Suckling; giving suck.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactarene</ent><br/
<hw>Lac"ta*rene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk.]</ety> <def>A preparation of casein from milk, used in printing calico.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactary</ent><br/
<hw>Lac"ta*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lactarius</ets>, fr. <ets>lac</ets>, <ets>lactis</ets>, milk: cf. F. <ets>lactaire</ets>.]</ety> <def>Milky; full of white juice like milk.</def> <mark>[Obs.]</mark> <ldquo/<xex>Lactary</xex> or milky plants.<rdquo/  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactary</ent><br/
<hw>Lac"ta*ry</hw>, <pos>n.</pos> <def>a dairyhouse.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactate</ent><br/
<hw>Lac"tate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk: cf. F. <ets>lactate</ets>.]</ety> <fld>(Chem.)</fld> <def>A salt of lactic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lactating</ent><br/
<hw>lactating</hw> <pos>adj.</pos> <def>actively producing milk; -- of female mammals.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Lactation</ent><br/
<hw>Lac*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The secretion and yielding of milk by the mammary gland; giving suck.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacteal</ent><br/
<hw>Lac"te*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lacteus</ets> milky, fr. <ets>lac</ets>, <ets>lactis</ets>, milk.  Cf. <er>Galaxy</er>, <er>Lettuce</er>.]</ety> <sn>1.</sn> <def>Pertaining to, or resembling, milk; milky; <as>as, the <ex>lacteal</ex> fluid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat. & Physiol.)</fld> <def>Pertaining to, or containing, chyle; <as>as, the <ex>lacteal</ex> vessels</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacteal</ent><br/
<hw>Lac"te*al</hw>, <pos>n.</pos> <fld>(Anat.)</fld> <def>One of the lymphatic vessels which convey chyle from the small intestine through the mesenteric glands to the thoracic duct; a chyliferous vessel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacteally</ent><br/
<hw>Lac"te*al*ly</hw>, <pos>adv.</pos> <def>Milkily; in the manner of milk.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactean</ent><br/
<hw>Lac"te*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Lacteal</er>.]</ety> <sn>1.</sn> <def>Milky; consisting of, or resembling, milk.</def> <ldquo/This <xex>lactean</xex> whiteness.<rdquo/  <rj><au>Moxon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat. & Physiol.)</fld> <def>Lacteal; conveying chyle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacteous</ent><br/
<hw>Lac"te*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Lacteal</er>.]</ety> <sn>1.</sn> <def>Milky; resembling milk.</def> <ldquo/The <xex>lacteous</xex> circle.<rdquo/  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lacteal; conveying chyle; <as>as, <ex>lacteous</ex> vessels</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacteously</ent><br/
<hw>Lac"te*ous*ly</hw>, <pos>adv.</pos> <def>In a lacteous manner; after the manner of milk.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactescence</ent><br/
<hw>Lac*tes"cence</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lactescence</ets>.]</ety> <sn>1.</sn> <def>The state or quality of producing milk, or milklike juice; resemblance to milk; a milky color.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This <qex>lactescence</qex> does commonly ensue when . . . fair water is suddenly poured upon the solution.</q> <rj><qau>Boyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>The latex of certain plants. See <er>Latex</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactescent</ent><br/
<hw>Lac*tes"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lactescens</ets>, p. pr. of <ets>lactescere</ets> to turn to milk, incho. fr. <ets>lactere</ets> to be milky, fr. <ets>lac</ets>, <ets>lactis</ets>, milk: cf. F. <ets>lactescent</ets>.]</ety> <sn>1.</sn> <def>Having a milky look; becoming milky.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Producing milk or a milklike juice or fluid, as the milkweed. See <er>Latex</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactic</ent><br/
<hw>Lac"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk: cf. F. <ets>lactique</ets>. See <er>Lacteal</er>, and cf. <er>Galactic</er>.]</ety> <fld>(Physiol. Chem.)</fld> <def>Of or pertaining to milk; procured from sour milk or whey; <as>as, <ex>lactic</ex> acid; <ex>lactic</ex> fermentation, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lactic acid</b></col> <fld>(Physiol. Chem.)</fld>, <cd>a sirupy, colorless fluid, soluble in water, with an intensely sour taste and strong acid reaction. There is one center of optical activity, and this results in the observation of three isomeric modifications all having the formula <chform>C3H6O3</chform>; one is dextrorotatory (L-lactic acid), the other levorotatory (D-lactic acid), and the third an optically inactive mixture of the first two (DL-lactic acid); chemically it is <chname>2-hydroxypropanoic acid</chname>.  <stype>Sarcolactic acid</stype> or <stype>paralactic acid</stype> occurs chiefly in dead muscle tissue, while <stype>ordinary lactic acid</stype> (DL-lactic acid) results from fermentation, such as the fermentation of milk by lactic acid bacteria. The two acids are alike in having the same constitution (expressed by the name <altname>ethylidene lactic acid</altname>), but the latter is optically inactive, while sarcolactic acid rotates the plane of polarization to the right.  The third acid, <xex>ethylene lactic acid</xex>, accompanies sarcolactic acid in the juice of flesh, and is optically inactive.</cd> -- <col><b>Lactic ferment</b></col>, <cd>an organized ferment (<spn>Bacterium lacticum</spn> <it>or</it> <spn>Bacterium lactis</spn>), which produces lactic fermentation, decomposing the sugar of milk into carbonic and lactic acids, the latter, of which renders the milk sour, and precipitates the casein, thus giving rise to the so-called spontaneous coagulation of milk.</cd> -- <col><b>Lactic fermentation</b></col>. <cd>See under <er>Fermentation</er>.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Lactide</ent><br/
<hw>Lac"tide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lac</ets>tic + anhydride.]</ety> <fld>(Chem.)</fld> <def>A white, crystalline substance, obtained from lactic acid by distillation, and regarded as an anhydride; also, by extension, any similar substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactiferous</ent><br/
<hw>Lac*tif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[l. <ets>lac</ets>, <ets>lactis</ets>, milk + <ets>-ferous</ets>: cf. F. <ets>lactif<egrave/re</ets>.]</ety> <def>Bearing or containing milk or a milky fluid; <as>as, the <ex>lactiferous</ex> vessels, cells, or tissue of various vascular plants</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactifical</ent><br/
<ent>Lactific</ent><br/
<mhw>{ <hw>Lac*tif"ic</hw> <pr>(?)</pr>, <hw>Lac*tif"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk + <ets>facere</ets> to make.]</ety> <def>Producing or yielding milk.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactifuge</ent><br/
<hw>Lac"ti*fuge</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk + <ets>fugare</ets> to expel.]</ety> <fld>(Med.)</fld> <def>A medicine to check the secretion of milk, or to dispel a supposed accumulation of milk in any part of the body.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactim</ent><br/
<hw>Lac"tim</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lactic</ets> + <ets>im</ets>ido.]</ety> <fld>(Chem.)</fld> <def>One of a series of anhydrides resembling the lactams, but of an imido type; <as>as, isatine is a <ex>lactim</ex></as>.  Cf. <er>Lactam</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactimide</ent><br/
<hw>Lac*tim"ide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lactic</ets> + <ets>imide</ets>.]</ety> <fld>(Chem.)</fld> <def>A white, crystalline substance obtained as an anhydride of alanine, and regarded as an imido derivative of lactic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactin</ent><br/
<hw>Lac"tin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk: cf. F. <ets>lactine</ets>.  Cf. <er>Galactin</er>.]</ety> <fld>(Physiol. Chem.)</fld> <def>See <er>Lactose</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactoabumin</ent><br/
<hw>Lac`to*a*bu"min</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk + E. <ets>albumin</ets>.]</ety> <fld>(Physiol. Chem.)</fld> <def>The albumin present in milk, apparently identical with ordinary serum albumin. It is distinct from the casein of milk.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactobutyrometer</ent><br/
<hw>Lac`to*bu`ty*rom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk + E. <ets>butyrometer</ets>.]</ety> <def>An instrument for determining the amount of butter fat contained in a given sample of milk.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactodensimeter</ent><br/
<hw>Lac`to*den*sim"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk + E. <ets>densimeter</ets>.]</ety> <def>A form of hydrometer, specially graduated, for finding the density of milk, and thus discovering whether it has been mixed with water or some of the cream has been removed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactometer</ent><br/
<hw>Lac*tom"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk + <ets>meter</ets>: cf. F. <ets>lactom<egrave/tre</ets>.  Cf. <er>Galactometer</er>.]</ety> <def>An instrument for estimating the purity or richness of milk, as a measuring glass, a specific gravity bulb, or other apparatus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactone</ent><br/
<hw>Lac"tone</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>One of a series of organic compounds, being cyclic esters which may be regarded as anhydrides of certain hydroxy acids.  In general, they are colorless liquids, having a weak aromatic odor. They are so called because the typical lactone is derived from <xex>lactic</xex> acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactonic</ent><br/
<hw>Lac*ton"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Lactone</er>.]</ety> <fld>(Chem.)</fld> <def>Of, pertaining to, or derived from, a lactone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactonic</ent><br/
<hw>Lac*ton"ic</hw>, <pos>a.</pos> <ety>[From <er>Lactose</er>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an acid obtained by the oxidation of milk sugar (<xex>lactose</xex>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactoprotein</ent><br/
<hw>Lac`to*pro"te*in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets>, milk + E. <ets>protein</ets>.]</ety> <fld>(Physiol. Chem.)</fld> <def>A peculiar albuminous body considered a normal constituent of milk.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactory</ent><br/
<hw>Lac"to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Lactiferous.</def> <mark>[Obs.]</mark> <ldquo/<xex>Lactory</xex> or milky plants.<rdquo/  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactoscope</ent><br/
<hw>Lac"to*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lac</ets>, <ets>lactis</ets> + <ets>scope</ets>.]</ety> <def>An instrument for estimating the amount of cream contained in milk by ascertaining its relative opacity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lactose</ent><br/
<hw>lac"tose`</hw> <pr>(l<acr/k"t<omac/s`)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Physiol. Chem.)</fld> <def>The main sugar present in milk, called also <altname>sugar of milk</altname> or <altname>milk sugar</altname>.  When isolated pure it is obtained crystalline; it is separable from the whey by evaporation and crystallization.  It is a disaccharide with the formula <chform>C12H22O11</chform>, being chemically <chname>4-(<beta/-D-galactosido)-D-glucose</chname>. It has a slightly sweet taste, is dextrorotary, and is much less soluble in water than either cane sugar or glucose. Formerly called <altname>lactin</altname>.  When hydrolyzed it yields glucose and galactose.  In cells it may be hydrolyzed by the enzyme <beta/-galactosidase.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>See <er>Galactose</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lactose intolerance</ent><br/
<hw>lac"tose` in*tol"er*ance</hw> <pr>(l<acr/k"t<omac/s` <icr/n*t<ocr/l"<etil/r*<ait/ns)</pr>, <pos>n.</pos> <def>A physiological condition in which lactose cannot be hydrolyzed in the intestine, leading to uncomfortable gaseousness, cramps, or diarrhea after eating a lactose-containing food such as milk or ice cream.  The symptoms may be prevented by ingesting a preparation of beta-galactosidase before or together with dairy products.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lactuca</ent><br/
\'d8<hw>Lac*tu"ca</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., lettuce. See <er>Lettuce</er>.]</ety> <fld>(Bot.)</fld> <def>A genus of composite herbs, several of which are cultivated for salad; lettuce.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactucarium</ent><br/
\'d8<hw>Lac`tu*ca"ri*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L. <ets>lactuca</ets> lettuce.]</ety> <def>The inspissated juice of the common lettuce, sometimes used as a substitute for opium.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactucic</ent><br/
<hw>Lac*tu"cic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or derived from, the juice of the <spn>Lactuca virosa</spn>; -- said of certain acids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactucin</ent><br/
<hw>Lac*tu"cin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Lactuca</er>: cf. F. <ets>lactucine</ets>.]</ety> <fld>(Chem.)</fld> <def>A white, crystalline substance, having a bitter taste and a neutral reaction, and forming one of the essential ingredients of lactucarium.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactucone</ent><br/
<hw>Lac*tu"cone</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Lactuca</er>.]</ety> <fld>(Chem.)</fld> <def>A white, crystalline, tasteless substance, found in the milky sap of species of Lactuca, and constituting an essential ingredient of lactucarium.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacturamic</ent><br/
<hw>Lac`tu*ram"ic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[<ets>Lactic</ets> + <ets>urea</ets> + <ets>amic</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an organic amido acid, which is regarded as a derivative of lactic acid and urea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lactyl</ent><br/
<hw>Lac"tyl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lactic</ets> + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>An organic residue or radical (<chform>CH3.CHOH.CO-</chform>) derived from lactic acid.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Lacuna</ent><br/
<ent>Lacunae</ent><br/
\'d8<hw>La*cu"na</hw> <pr>(l<adot/*k<umac/"n<adot/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Lacun<ae/</plw> <pr>(l<adot/*k<umac/"n<ae/)</pr>; E. <plw>Lacunas</plw> <pr>(l<adot/*k<umac/"n<adot/z)</pr>.</plu> <ety>[L., ditch, pit, lake, orig., anything hollow. See <er>Lagoon</er>.]</ety> <sn>1.</sn> <def>A small opening; a small pit or depression; a small blank space; a gap or vacancy; a hiatus.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>A small opening; a small depression or cavity; a space, as a vacant space between the cells of plants, or one of the spaces left among the tissues of the lower animals, which serve in place of vessels for the circulation of the body fluids, or the cavity or sac, usually of very small size, in a mucous membrane.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 824 --></p>

<p><ent>Lacunar</ent><br/
<ent>Lacunal</ent><br/
<mhw>{ <hw>La*cu"nal</hw> <pr>(l<adot/*k<umac/"n<ait/l)</pr>, <hw>La*cu"nar</hw> <pr>(l<adot/*k<umac/"n<etil/r)</pr>, }</mhw> <pos>a.</pos> <def>Pertaining to, or having, lacun<ae/; <as>as, a <ex>lacunar</ex> circulation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacunar</ent><br/
<hw>La*cu"nar</hw>, <pos>n.</pos>; <plu><it>pl.</it> E. <plw>Lacunars</plw> <pr>(l<adot/*k<umac/"n<etil/rz)</pr>, L. <plw>Lacunaria</plw> <pr>(l<acr/k`<usl/*n<amac/"r<icr/*<adot/)</pr>.</plu> <ety>[L.]</ety> <fld>(Arch.)</fld> <sd>(a)</sd> <def>The ceiling or under surface of any part, especially when it consists of compartments, sunk or hollowed without spaces or bands between the panels.</def> <au>Gwilt</au> <sd>(b)</sd> <def>One of the sunken panels in such a ceiling.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacune</ent><br/
<hw>La*cune"</hw> <pr>(l<adot/*k<umac/n")</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A lacuna.</def> <mark>[R.]</mark> <au>Landor.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacunous</ent><br/
<ent>Lacunose</ent><br/
<mhw>{ <hw>Lac"u*nose`</hw> <pr>(?)</pr>, <hw>La*cu"nous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>lacunosus</ets> full of holes or hollows; cf. F. <ets>lacuneux</ets>. See <er>Lacuna</er>.]</ety> <fld>(Biol.)</fld> <def>Furrowed or pitted; having shallow cavities or lacun<ae/; <as>as, a <ex>lacunose</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacustrine</ent><br/
<ent>Lacustral</ent><br/
<mhw>{ <hw>La*cus"tral</hw> <pr>(?)</pr>, <hw>La*cus"trine</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>lacus</ets> lake: cf. F. <ets>lacustral</ets>, <ets>lacustre</ets>.]</ety> <def>Found in, or pertaining to, lakes or ponds, or growing in them; <as>as, <ex>lacustrine</ex> flowers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lacustrine deposits</b></col> <fld>(Geol.)</fld>, <cd>the deposits which have been accumulated in fresh-water areas.</cd> -- <col><b>Lacustrine dwellings</b></col>. <cd>See <cref>Lake dwellings</cref>, under <er>Lake</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lacwork</ent><br/
<hw>Lac"work`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Ornamentation by means of lacquer painted or carved, or simply colored, sprinkled with gold or the like; -- said especially of Oriental work of this kind.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lad</ent><br/
<hw>Lad</hw> <pr>(l<acr/d)</pr>, <mark>obs.</mark> <def><pos>p. p.</pos> of <er>Lead</er>, to guide.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lad</ent><br/
<hw>Lad</hw> <pr>(l<acr/d)</pr>, <pos>n.</pos> <ety>[OE. <ets>ladde</ets>, of Celtic origin; cf. W. <ets>llawd</ets>, Ir. <ets>lath</ets>. <root/123.  Cf. <er>Lass</er>.]</ety> <sn>1.</sn> <def>A boy; a youth; a stripling.</def> <ldquo/Cupid is a knavish <xex>lad</xex>.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There is a <qex>lad</qex> here, which hath five barley loaves and two small fishes.</q> <rj><qau>John vi. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A companion; a comrade; a mate.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lad's love</b></col>. <fld>(Bot.)</fld> <cd>See <cref>Boy's love</cref>, under <er>Boy</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladanum</ent><br/
<hw>Lad"a*num</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>ladanum</ets>, <ets>ledanum</ets>, Gr. <grk>la`danon</grk>, <grk>lh`danon</grk>, fr. <grk>lh^don</grk> name of a shrub, mastic; cf. Per. <ets>l<amac/dan</ets>, <ets>l<amac/den</ets>.  Cf. <er>Laudanum</er>.]</ety> <def>A gum resin gathered from certain Oriental species of <gen>Cistus</gen>. It has a pungent odor and is chiefly used in making plasters, and for fumigation.</def> <altsp>[Written also <asp>labdanum</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladde</ent><br/
<hw>Lad"de</hw> <pr>(?)</pr>, <mark>(obs.)</mark> <def><pos>imp.</pos> of <er>Lead</er>, to guide.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladder</ent><br/
<hw>Lad"der</hw> <pr>(l<acr/d"d<etil/r)</pr>, <pos>n.</pos> <ety>[OE. <ets>laddre</ets>, AS. <ets>hl<aemac/der</ets>, <ets>hl<aemac/dder</ets>; akin to OFries. <ets>hladder</ets>, OHG. <ets>leitara</ets>, G. <ets>leiter</ets>, and from the root of E. <ets>lean</ets>, v.  <root/40.  See <er>Lean</er>, <pos>v. i.</pos>, and cf. <er>Climax</er>.]</ety> <sn>1.</sn> <def>A frame usually portable, of wood, metal, or rope, for ascent and descent, consisting of two side pieces to which are fastened cross strips or rounds forming steps.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some the engines play,<br/
And some, more bold, mount <qex>ladders</qex> to the fire.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which resembles a ladder in form or use;</def> <specif>hence,</specif> <def>that by means of which one attains to eminence; <as>as, to climb the corporate <ex>ladder</ex></as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>Lowliness is young ambition's <qex>ladder</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Fish ladder</b></col>. <cd>See under <er>Fish</er>.</cd> -- <col><b>Ladder beetle</b></col> <fld>(Zool.)</fld>, <cd>an American leaf beetle (<spn>Chrysomela scalaris</spn>). The elytra are silvery white, striped and spotted with green; the under wings are rose-colored. It feeds upon the linden tree.</cd> -- <col><b>Ladder handle</b></col>, <cd>an iron rail at the side of a vertical fixed ladder, to grasp with the hand in climbing.</cd> -- <col><b>Ladder shell</b></col> <fld>(Zool.)</fld>, <cd>a spiral marine shell of the genus <gen>Scalaria</gen>. See <er>Scalaria</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>ladder-back</ent><br/
<hw>ladder-back</hw> <pos>n.</pos> <def>a chair with a ladder-back{2}.</def><br/
<syn><b>Syn. --</b> ladder-back chair.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>a chair backrest consisting of 2 uprights with several connecting slats.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ladder-backed</ent><br/
<hw>ladder-backed</hw> <pos>n.</pos> <def>Having horizontal stripes on the back, reminiscent of a ladder; -- used of birds; <as>as, a <ex>ladder-backed</ex> woodpecker</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>ladder truck</ent><br/
<ent>ladder company</ent><br/
<mhw><hw>ladder company</hw>, <hw>ladder truck</hw></mhw> <pos>n.</pos>  <def>Same as <er>hook-and-ladder company</er>, <er>hook-and-ladder truck</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>ladder-proof</ent><br/
<hw>ladder-proof</hw> <pos>adj.</pos>  <def>resistant to runs or (in Britain) ladders; -- of hosiery.</def><br/
<syn><b>Syn. --</b> runproof, run-resistant.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Laddie</ent><br/
<hw>Lad"die</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A lad; a male sweetheart.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lade</ent><br/
<hw>Lade</hw> <pr>(l<amac/d)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.</pos> <conjf>Laded</conjf>; <pos>p. p.</pos> <conjf>Laded</conjf>, <conjf>Laden</conjf> <pr>(l<amac/d'n)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lading</conjf>.]</vmorph> <ety>[AS. <ets>hladan</ets> to heap, load, draw (water); akin to D. & G. <ets>laden</ets> to load, OHG. <ets>hladan</ets>, <ets>ladan</ets>, Icel. <ets>hla<edh/a</ets>, Sw. <ets>ladda</ets>, Dan. <ets>lade</ets>, Goth. <ets>afhla<thorn/an</ets>.  Cf. <er>Load</er>, <er>Ladle</er>, <er>Lathe</er> for turning, <er>Last</er> a load.]</ety> <sn>1.</sn> <def>To load; to put a burden or freight on or in; -- generally followed by that which receives the load, as the direct object.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And they <qex>laded</qex> their asses with the corn.</q> <rj><qau>Gen. xlii. 26.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To throw in or out, with a ladle or dipper; to dip; <as>as, to <ex>lade</ex> water out of a tub, or into a cistern</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And chides the sea that sunders him from thence,<br/
Saying, he'll <qex>lade</qex> it dry to have his way.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Plate Glass Manuf.)</fld> <def>To transfer (the molten glass) from the pot to the forming table.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lade</ent><br/
<hw>Lade</hw>, <pos>v. i.</pos> <ety>[See <er>Lade</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>To draw water.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>To admit water by leakage, as a ship, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lade</ent><br/
<hw>Lade</hw>, <pos>n.</pos> <ety>[Prov. E., a ditch or drain.  Cf. <er>Lode</er>, <er>Lead</er> to conduct.]</ety> <sn>1.</sn> <def>The mouth of a river.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Gibson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A passage for water; a ditch or drain.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lademan</ent><br/
<hw>Lade"man</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who leads a pack horse; a miller's servant.</def> <mark>[Obs. or Local]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laden</ent><br/
<hw>Lad"en</hw> <pr>(?)</pr>, <pos>p. & a.</pos> <def>Loaded; freighted; burdened; <as>as, a <ex>laden</ex> vessel; a <ex>laden</ex> heart.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ah sinful nation, a people <qex>laden</qex> with iniquity.</q> <rj><qau>Is. i. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A ship <qex>laden</qex> with gold.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladied</ent><br/
<hw>La"died</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Ladylike; not rough; gentle.</def> <mark>[Obs.]</mark> <ldquo/Stroked with a <xex>ladied</xex> land.<rdquo/  <rj><au>Feltham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladies' eardrops</ent><br/
<hw>La"dies' ear`drops`</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>The small-flowered Fuchsia (<spn>Fuchsia coccinea</spn>), and other closely related species.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladify</ent><br/
<hw>La"di*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[<ets>Lady</ets> + <ets>-fy</ets>.]</ety> <def>To make a lady of; to make ladylike.</def> <mark>[Obs.]</mark>  <rj><au>Massinger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladin</ent><br/
<hw>La*din"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From L. <ets>Latinus</ets> Latin. See <er>Latin</er>]</ety> <sn>1.</sn> <def>A Romansch dialect spoken in some parts of Switzerland and the Tyrol.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A person speaking Ladin as a mother tongue.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lading</ent><br/
<hw>Lad"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act of loading.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which lades or constitutes a load or cargo; freight; burden; <as>as, the <ex>lading</ex> of a ship</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bill of lading</b></col>. <cd>See under <er>Bill</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladino</ent><br/
<hw>La*di"no</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Ladinos</plw> <pr>(#)</pr>.</plu> <ety>[Sp.]</ety> <def>One of the half-breed descendants of whites and Indians; a mestizo; -- so called throughout Central America. They are usually of a yellowish orange tinge.</def>  <rj><au>Am. Cyc.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladino</ent><br/
<hw>La*di"no</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl. <plw>-nos</plw> <pr>(<?/)</pr></plu> <sn>1.</sn> <def>The mixed Spanish and Hebrew language spoken by Sephardim.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>A cunningly vicious horse.</def> <mark>[Southeastern U. S.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>A ladin.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Ladkin</ent><br/
<hw>Lad"kin</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A little lad.</def> <mark>[R.]</mark>  <rj><au>Dr. H. More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladle</ent><br/
<hw>La"dle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>hl<ae/del</ets>, fr. <ets>hladan</ets> to load, drain. See <er>Lade</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>A cuplike spoon, often of large size, with a long handle, used in lading or dipping.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When the materials of glass have been kept long in fusion, the mixture casts up the superfluous salt, which the workmen take off with <qex>ladles</qex>.</q> <rj><qau>Boyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Founding)</fld> <def>A vessel to carry liquid metal from the furnace to the mold.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The float of a mill wheel; -- called also <altname>ladle board</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Gun.)</fld> <sd>(a)</sd> <def>An instrument for drawing the charge of a cannon.</def> <sd>(b)</sd> <def>A ring, with a handle or handles fitted to it, for carrying shot.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ladle wood</b></col> <fld>(Bot.)</fld>, <cd>the wood of a South African tree (<spn>Cassine Colpoon</spn>), used for carving.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladle</ent><br/
<hw>La"dle</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Ladled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Ladling</conjf> <pr>(?)</pr>.]</vmorph> <def>To take up and convey in a ladle; to dip with, or as with, a ladle; <as>as, to <ex>ladle</ex> out soup; to <ex>ladle</ex> oatmeal into a kettle.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladleful</ent><br/
<hw>La"dle*ful</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Ladlefuls</plw> <pr>(<?/)</pr>.</plu> <def>A quantity sufficient to fill a ladle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladrone</ent><br/
<hw>La*drone"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>ladron</ets>, L. <ets>latro</ets> servant, robber, Gr. (<?/) a servant.]</ety> <def>A robber; a pirate; hence, loosely, a rogue or rascal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady</ent><br/
<hw>La"dy</hw> <pr>(l<amac/"d<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Ladies</plw> <pr>(l<amac/"d<icr/z)</pr>.</plu> <ety>[OE. <ets>ladi</ets>, <ets>l<ae/fdi</ets>, AS. <ets>hl<aemac/fdige</ets>, <ets>hl<aemac/fdie</ets>; AS. <ets>hl<amac/f</ets> loaf + a root of uncertain origin, possibly akin to E. <ets>dairy</ets>. See <er>Loaf</er>, and cf. <er>Lord</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A woman who looks after the domestic affairs of a family; a mistress; the female head of a household.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Agar, the handmaiden of Sara, whence comest thou, and whither goest thou? The which answered, Fro the face of Sara my <qex>lady</qex>.</q> <rj><qau>Wyclif (Gen. xvi. 8.).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A woman having proprietary rights or authority; mistress; -- a feminine correlative of <xex>lord</xex>.</def> <ldquo/Lord or <xex>lady</xex> of high degree.<rdquo/  <rj><au>Lowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Of all these bounds, even from this line to this, . . . <br/
We make thee <qex>lady</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A woman to whom the particular homage of a knight was paid; a woman to whom one is devoted or bound; a sweetheart.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The soldier here his wasted store supplies,<br/
And takes new valor from his <qex>lady's</qex> eyes.</q> <rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A woman of social distinction or position. In England, a title prefixed to the name of any woman whose husband is not of lower rank than a baron, or whose father was a nobleman not lower than an earl. The wife of a baronet or knight has the title of <xex>Lady</xex> by courtesy, but not by right.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A woman of refined or gentle manners; a well-bred woman; -- the feminine correlative of <contr>gentleman</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A wife; -- not now in approved usage.</def>  <rj><au>Goldsmith.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <specif>Hence:</specif> <def>Any woman; <as>as, a lounge for <ex>ladies</ex>; a cleaning <ex>lady</ex></as>; also used in combination; <as>as, sales<ex>lady</ex></as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>8.</sn> <fld>(Zool.)</fld> <def>The triturating apparatus in the stomach of a lobster; -- so called from a fancied resemblance to a seated female figure. It consists of calcareous plates.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ladies' man</b></col>, <cd>a man who affects the society of ladies.</cd> -- <col><b>Lady altar</b></col>, <cd>an altar in a lady chapel.</cd> <au>Shipley.</au> -- <col><b>Lady chapel</b></col>, <cd>a chapel dedicated to the Virgin Mary.</cd> -- <col><b>Lady court</b></col>, <cd>the court of a lady of the manor.</cd> -- <col><b>Lady crab</b></col> <fld>(Zool.)</fld>, <cd>a handsomely spotted swimming crab (<spn>Platyonichus ocellatus</spn>) very common on the sandy shores of the Atlantic coast of the United States.</cd> -- <col><b>Lady fern</b></col>. <fld>(Bot.)</fld> <cd>See <cref>Female fern</cref>, under <er>Female</er>, and <xex>Illust.</xex> of <er>Fern</er>.</cd> -- <col><b>Lady in waiting</b></col>, <cd>a lady of the queen's household, appointed to wait upon or attend the queen.</cd> -- <col><b>Lady Mass</b></col>, <cd>a Mass said in honor of the Virgin Mary.</cd> <au>Shipley.</au> <col><b>Lady of the manor</b></col>, <cd>a lady having jurisdiction of a manor; also, the wife of a manor lord.</cd> <col><b>Lady's maid</b></col>, <cd>a maidservant who dresses and waits upon a lady.</cd> <au>Thackeray.</au> -- <col><b>Our Lady</b></col>, <cd>the Virgin Mary.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady</ent><br/
<hw>La"dy</hw>, <pos>a.</pos> <def>Belonging or becoming to a lady; ladylike.</def><br/
[<source>1913 Webster</source>]</p>

<p><ldquo/Some <qex>lady</qex> trifles.<rdquo/ <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>ladybeetle</ent><br/
<hw>ladybeetle</hw> <pos>n.</pos> <def>Same as <er>ladybird</er>.</def><br/
<syn><b>Syn. --</b> ladybug, lady beetle, ladybird, ladybird beetle.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Ladybird</ent><br/
<hw>La"dy*bird`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Equiv. to, bird of Our Lady.]</ety> <fld>(Zool.)</fld> <def>Any one of numerous species of small beetles of the genus <gen>Coccinella</gen> and allied genera (family <fam>Coccinellid<ae/</fam>); -- called also <altname>ladybug</altname>, <altname>ladyclock</altname>, <altname>lady cow</altname>, <altname>lady fly</altname>, <altname>ladybeetle</altname>, and <altname>lady beetle</altname>.  <spn>Coccinella seplempunctata</spn> in one of the common European species. See <er>Coccinella</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The ladybirds are usually more or less hemispherical in form, with a smooth, polished surface, and often colored red, brown, or black, with small spots of brighter colors. Both the larvae and the adult beetles of most species feed on aphids, and for this reason they are very beneficial to agriculture and horticulture.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladybug</ent><br/
<hw>La"dy*bug`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Ladybird</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladyclock</ent><br/
<hw>La"dy*clock`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Ladybird</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady Day</ent><br/
<hw>La"dy` Day`</hw> <pr>(d<amac/)</pr> <pos>n.</pos> <def>The day of the annunciation of the Virgin Mary, March 25. See <er>Annunciation</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladyfish</ent><br/
<hw>La"dy*fish`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <sd>(a)</sd> <def>A large, handsome oceanic fish (<spn>Albula vulpes</spn>), found both in the Atlantic and Pacific oceans; -- called also <altname>bonefish</altname>, <altname>grubber</altname>, <altname>French mullet</altname>, and <altname>macab<eacute/</altname>.</def> <sd>(b)</sd> <def>A labroid fish (<spn>Harpe rufa</spn>) of Florida and the West Indies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladyhood</ent><br/
<hw>La"dy*hood</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state or quality of being a lady; the personality of a lady.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lady-in-waiting</ent><br/
<hw>lady-in-waiting</hw> <pos>n.</pos> <def>a lady appointed to attend to a queen or princess.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lady-killer</ent><br/
<hw>La"dy-kill`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A gallant who captivates the hearts of women.</def> <ldquo/A renowned dandy and <xex>lady-killer</xex>.<rdquo/  <rj><au>Blackw. Mag.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady-killing</ent><br/
<hw>La"dy-kill`ing</hw>, <pos>n.</pos> <def>The art or practice of captivating the hearts of women.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Better for the sake of womankind that this dangerous dog should leave off <qex>lady-killing</qex>.</q> <rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladykin</ent><br/
<hw>La"dy*kin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lady</ets> + <ets>-kin</ets>.]</ety> <def>A little lady; -- applied by the writers of Queen Elizabeth's time, in the abbreviated form <altname>Lakin</altname>, to the Virgin Mary.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The diminutive does not refer to size, but is equivalent to <ldquo/dear.<rdquo/</note>  <rj><au>Brewer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladylike</ent><br/
<hw>La"dy*like`</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Like a lady in appearance or manners; well-bred.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She was <qex>ladylike</qex>, too, after the manner of the feminine gentility of those days.</q> <rj><qau>Hawthorne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Becoming or suitable to a lady; <as>as, <ex>ladylike</ex> manners</as>.</def> <ldquo/With fingers <xex>ladylike</xex>.<rdquo/  <rj><au>Warner.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Delicate; tender; feeble; effeminate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Too <qex>ladylike</qex> a long fatigue to bear.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladylikeness</ent><br/
<hw>La"dy*like`ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being ladylike.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladylove</ent><br/
<hw>La"dy*love`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A sweetheart or mistress.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lady-of-the-night</ent><br/
<hw>lady-of-the-night</hw> <pos>n.</pos> <fld>(Bot.)</fld> <def>A West Indian shrub (<spn>Brunfelsia americana</spn>) with fragrant showy yellowish-white flowers.</def><br/
<syn><b>Syn. --</b> lady of the night, Brunfelsia americana.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lady's bedstraw</ent><br/
<hw>La"dy's bed"straw`</hw> <pr>(?)</pr>, <fld>(Bot.)</fld> <def>The common bedstraw (<spn>Galium verum</spn>); also, a slender-leaved East Indian shrub (<spn>Pharnaceum Mollugo</spn>), with white flowers in umbels.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's bower</ent><br/
<hw>La"dy's bow"er</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>A climbing plant with fragrant blossoms (<spn>Clematis vitalba</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This term is sometimes applied to other plants of the same genus.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's cloth</ent><br/
<hw>La"dy's cloth`</hw> <pr>(?)</pr> <def>A kind of broadcloth of light weight, used for women's dresses, cloaks, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lady's comb</ent><br/
<hw>La"dy's comb"</hw> <pr>(?)</pr>, <fld>(Bot.)</fld> <def>An umbelliferous plant (<spn>Scandix Pecten-Veneris</spn>), its clusters of long slender fruits remotely resembling a comb.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's cushion</ent><br/
<hw>La"dy's cush"ion</hw> <pr>(?)</pr>, <fld>(Bot.)</fld> <def>An herb growing in dense tufts; the thrift (<spn>Armeria vulgaris</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lady's-eardrop</ent><br/
<hw>lady's-eardrop</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>An erect or climbing shrub (<spn>Fuchsia coccinea</spn>) of Brazil with deep pink to red flowers.</def><br/
<syn><b>Syn. --</b> ladies'-eardrop, lady's-eardrops, ladies'-eardrops, <spn>Fuchsia coccinea</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lady's finger</ent><br/
<hw>La"dy's fin"ger</hw> <pr>(?)</pr>, <sn>1.</sn> <pluf>pl.</pluf> <fld>(Bot.)</fld> <def>The kidney vetch, <spn>Anthyllis vulneraria</spn>; called also <altname>lady's fingers</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Cookery)</fld> <def>A variety of small cake of about the dimensions of a finger.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A long, slender variety of the potato.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>One of the branchiae of the lobster.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Bot.)</fld> <def>A tall coarse annual (<spn>Abelmoschus esculentus</spn>) of Old World tropics widely cultivated in southern U. S. and West Indies for its long mucilaginous green pods used as basis for soups and stews; it is sometimes placed in the genus <gen>Hibiscus</gen>.</def> <wns>[wns=1]</wns> <note>different from <er>lady's fingers</er></note><br/
<syn><b>Syn. --</b> okra, gumbo, okra plant, <spn>Abelmoschus esculentus</spn>, Hibiscus esculentus.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lady's garters</ent><br/
<hw>La"dy's gar"ters</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>Ribbon grass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's hair</ent><br/
<hw>La"dy's hair"</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>A plant of the genus <gen>Briza</gen> (<spn>Briza media</spn>); a variety of quaking grass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladyship</ent><br/
<hw>La"dy*ship</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The rank or position of a lady; -- given as a title (preceded by <xex>her</xex> or <xex>your</xex>).</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Your <qex>ladyship</qex> shall observe their gravity.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's laces</ent><br/
<hw>La"dy's la"ces</hw> <pr>(l<amac/"d<icr/z l<amac/"s<ecr/z)</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>A slender climbing plant; dodder.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lady-slipper</ent><br/
<hw>lady-slipper</hw> <pos>n.</pos> <pr>(l<amac/"d<ycr/ sl<icr/p"p<etil/r)</pr>, <fld>(Bot.)</fld> <def>Same as <er>lady's slipper</er>.</def><br/
<syn><b>Syn. --</b> lady's slipper, lady's-slipper, slipper orchid.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lady's looking-glass</ent><br/
<hw>La"dy's look"ing-glass`</hw> <pr>(l<amac/"d<icr/z l<oocr/k"<icr/ng gl<adot/s`)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>See <cref>Venus's looking-glass</cref>, under <er>Venus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's mantle</ent><br/
<hw>La"dy's man"tle</hw> <pr>(l<amac/"d<icr/z m<acr/n"t'l)</pr>. <fld>(Bot.)</fld> <def>A genus of rosaceous herbs (<gen>Alchemilla</gen>), esp. the European <spn>Alchemilla vulgaris</spn>, which has leaves with rounded and finely serrated lobes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's seal</ent><br/
<hw>La"dy's seal"</hw> <pr>(l<amac/"d<icr/z s<emac/l")</pr>.<fld>(Bot.)</fld> <sd>(a)</sd> <def>The European Solomon's seal (<spn>Polygonatum verticillatum</spn>).</def> <sd>(b)</sd> <def>The black bryony (<spn>Tamus communis</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's slipper</ent><br/
<hw>La"dy's slip"per</hw> <pr>(l<amac/"d<icr/z sl<icr/p"p<etil/r)</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>Any orchidaceous plant of the genus <gen>Cypripedium</gen>, the labellum of which resembles a slipper.  Less commonly, in the United States, the garden balsam (<spn>Impatiens Balsamina</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's smock</ent><br/
<hw>La"dy's smock"</hw> <pr>(l<amac/"d<icr/z sm<ocr/k")</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>A plant of the genus <gen>Cardamine</gen> (<spn>Cardamine pratensis</spn>); cuckoo flower.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's thimble</ent><br/
<hw>La"dy's thim"ble</hw> <pr>(l<amac/"d<icr/z th<icr/m"b'l)</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>The harebell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lady's thumb</ent><br/
<hw>La"dy's thumb"</hw> <pr>(l<amac/"d<icr/z th<ucr/m")</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>An annual weed (<spn>Polygonum Persicaria</spn>), having a lanceolate leaf with a dark spot in the middle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ladies' tresses</ent><br/
<ent>Lady's traces</ent><br/
<mhw>{ <hw>La"dy's tra"ces</hw> <pr>(l<amac/"d<icr/z tr<amac/"s<ecr/z)</pr>, <hw>La"dies' tress"es</hw> <pr>(l<amac/"d<icr/z tr<ecr/s"s<ecr/z)</pr>. }</mhw> <pos>n.</pos> <fld>(Bot.)</fld> <def>A name given to several species of the orchidaceous genus <gen>Spiranthes</gen>, in which the white flowers are set in spirals about a slender axis and remotely resemble braided hair.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laelaps</ent><br/
\'d8<hw>L<ae/"laps</hw> <pr>(l<emac/"l<acr/ps)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>lai^laps</grk> a dark, furious storm.]</ety> <fld>(Paleon.)</fld> <def>A genus of huge, carnivorous, dinosaurian reptiles from the Cretaceous formation of the United States.  They had very large hind legs and tail, and are supposed to have been bipedal.  Some of the species were about eighteen feet high.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laemmergeyer</ent><br/
<hw>Laem"mer*gey`er</hw> <pr>(l<ecr/m"m<etil/r*g<imac/`<etil/r)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Lammergeir</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laemodipod</ent><br/
<hw>L<ae/*mod"i*pod</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>One of the Laemodipoda.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laemodipoda</ent><br/
\'d8<hw>L<ae/`mo*dip"o*da</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., from Gr. <grk>lai`mos</grk> throat + <grk>di`s</grk> twice + <grk>poy`s</grk>, <grk>podo`s</grk>, foot.]</ety> <fld>(Zool.)</fld> <def>A division of amphipod Crustacea, in which the abdomen is small or rudimentary and the legs are often reduced to five pairs.  The whale louse, or <gen>Cyamus</gen>, and <gen>Caprella</gen> are examples.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laemodipodous</ent><br/
<hw>L<ae/`mo*dip"o*dous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the Laemodipoda.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laetere Sunday</ent><br/
<hw>L<ae/*te"re Sun"day</hw> <pr>(?)</pr> <pos>n.</pos> <def>The fourth Sunday of Lent; -- so named from the Latin word <xex>L<ae/tare</xex> (rejoice), the first word in the antiphone of the introit sung that day in the Roman Catholic service.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laevigate</ent><br/
<hw>L<ae/v"i*gate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Levigate</er>.]</ety> <fld>(Biol.)</fld> <def>Having a smooth surface, as if polished.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laevo-</ent><br/
<hw>L<ae/"vo-</hw> <pr>(?)</pr> <pos>pref.</pos> <def>A prefix. See <er>Levo</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laevorotatory</ent><br/
<hw>L<ae/"vo*ro"ta*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Same as <er>Levorotatory</er>.  Cf. <er>Dextrorotatory</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laevulose</ent><br/
<hw>L<ae/v"u*lose`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>See <er>Levulose</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lafayette</ent><br/
<hw>La`fa`yette"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The dollar fish.</def> <sd>(b)</sd> <def>A market fish, the goody, or spot (<spn>Liostomus xanthurus</spn>), of the southern coast of the United States.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laft</ent><br/
<hw>Laft</hw> <pr>(?)</pr>, <mark>obs.</mark> <def><pos>p. p.</pos> of <er>Leave</er>.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lafte</ent><br/
<hw>Laf"te</hw> <pr>(?)</pr>, <mark>obs.</mark> <def><pos>imp.</pos> of <er>Leave</er>.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lag</ent><br/
<hw>Lag</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Of Celtic origin: cf. Gael. & Ir. <ets>lag</ets>weak, feeble, faint, W. <ets>llag</ets>, <ets>llac</ets>, slack, loose, remiss, sluggish; prob. akin to E. <ets>lax</ets>, <ets>languid</ets>.]</ety> <sn>1.</sn> <def>Coming tardily after or behind; slow; tardy.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Came too <qex>lag</qex> to see him buried.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Last; long-delayed; -- obsolete, except in the phrase <xex>lag end</xex>.</def> <ldquo/The <xex>lag end</xex> of my life.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 825 --></p>

<p><sn>3.</sn> <def>Last made; hence, made of refuse; inferior.</def> <mark>[Obs.]</mark> <ldquo/<xex>Lag</xex> souls.<rdquo/  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lag</ent><br/
<hw>Lag</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who lags; that which comes in last.</def> <mark>[Obs.]</mark> <ldquo/The <xex>lag</xex> of all the flock.<rdquo/  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The fag-end; the rump; hence, the lowest class.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The common <qex>lag</qex> of people.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The amount of retardation of anything, as of a valve in a steam engine, in opening or closing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A stave of a cask, drum, etc.;</def> <specif>especially</specif>: <fld>(Mach.)</fld>, <def>one of the narrow boards or staves forming the covering of a cylindrical object, as a boiler, or the cylinder of a carding machine or a steam engine.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Zool.)</fld> <def>See <er>Graylag</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>The failing behind or retardation of one phenomenon with respect to another to which it is closely related; <as>as, the <ex>lag</ex> of magnetization compared with the magnetizing force (hysteresis); the <ex>lag</ex> of the current in an alternating circuit behind the impressed electro-motive force which produced it</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Lag of the tide</b></col>, <cd>the interval by which the time of high water falls behind the mean time, in the first and third quarters of the moon; -- opposed to <contr>priming</contr> of the tide, or the acceleration of the time of high water, in the second and fourth quarters; depending on the relative positions of the sun and moon.</cd> -- <col><b>Lag screw</b></col>, <cd>an iron bolt with a square head, a sharp-edged thread, and a sharp point, adapted for screwing into wood; a screw for fastening lags.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lag</ent><br/
<hw>Lag</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lagged</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lagging</conjf> <pr>(?)</pr>.]</vmorph> <def>To walk or more slowly; to stay or fall behind; to linger or loiter.</def> <ldquo/I shall not <xex>lag</xex> behind.<rdquo/  <rj><au>Milton.</au></rj></p>

<p><syn><b>Syn.</b> -- To loiter; linger; saunter; delay; be tardy.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lag</ent><br/
<hw>Lag</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To cause to lag; to slacken.</def> <mark>[Obs.]</mark> <ldquo/To <xex>lag</xex> his flight.<rdquo/  <rj><au>Heywood.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mach.)</fld> <def>To cover, as the cylinder of a steam engine, with lags. See <er>Lag</er>, <pos>n.</pos>, 4.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lag</ent><br/
<hw>Lag</hw>, <pos>n.</pos> <def>One transported for a crime.</def> <mark>[Slang, Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lag</ent><br/
<hw>Lag</hw>, <pos>v. t.</pos> <def>To transport for crime.</def> <mark>[Slang, Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>She <qex>lags</qex> us if we poach.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagan</ent><br/
<hw>La"gan</hw> <pr>(?)</pr>, <pos>n. & v.</pos> <def>See <er>Ligan</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagarto</ent><br/
<hw>La*gar"to</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Alligator</er>.]</ety> <def>An alligator.</def> <mark>[Obs.]</mark>  <rj><au>Sir W. Raleigh.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagena</ent><br/
<ent>Lagenae</ent><br/
\'d8<hw>La*ge"na</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Lagen<ae/</plw> <pr>(#)</pr>, E. <plw>Lagenas</plw> <pr>(#)</pr>.</plu> <ety>[L., a flask; cf. Gr. <?/, <?/.]</ety> <fld>(Anat.)</fld> <def>The terminal part of the cochlea in birds and most reptiles; an appendage of the sacculus, corresponding to the cochlea, in fishes and amphibians.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagenian</ent><br/
<hw>La*ge"ni*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Lagena</er>.]</ety> <fld>(Zool.)</fld> <def>Like, or pertaining to, <gen>Lagena</gen>, a genus of <ord>Foraminifera</ord> having a straight, chambered shell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lageniform</ent><br/
<hw>La*ge"ni*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Lagena</er>, and <er>-form</er>.]</ety> <fld>(Bot.)</fld> <def>Shaped like a bottle or flask; flag-shaped.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagenophera</ent><br/
<hw>Lagenophera</hw> <pos>prop. n.</pos> <def>A small genus of herbs of Australia and South America having small solidary white or purple flowers similar to true daisies of genus <gen>Bellis</gen>.</def><br/
<syn><b>Syn. --</b> genus <gen>Lagenophera</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lager</ent><br/
<hw>La"ger</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Lager beer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lager beer</ent><br/
<hw>La"ger beer`</hw> <pr>(?)</pr> <pos>n.</pos> <ety>[G. <ets>lager</ets> bed, storehouse + <ets>bier</ets> beer. See <er>Lair</er>, and <er>Beer</er>.]</ety> <def>Originally a German beer, but now also made in immense quantities in the United States; -- so called from its being laid up or stored for some months before use.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lager wine</ent><br/
<hw>La"ger wine`</hw> <pr>(?)</pr> <pos>n.</pos> <def>Wine which has been kept for some time in the cellar.</def>  <rj><au>Simmonds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laggard</ent><br/
<hw>Lag"gard</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lag</ets> + <ets>-ard</ets>.]</ety> <def>Slow; sluggish; backward.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laggard</ent><br/
<hw>Lag"gard</hw>, <pos>n.</pos> <def>One who lags; a loiterer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagger</ent><br/
<hw>Lag"ger</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A laggard.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagging</ent><br/
<hw>Lag"ging</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Mach.)</fld> <def>The clothing (esp., an outer, wooden covering), as of a steam cylinder, applied to prevent the radiation of heat; a covering of lags; -- called also <altname>deading</altname> and <altname>cleading</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lags, collectively; narrow planks extending from one rib to another in the centering of arches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laggingly</ent><br/
<hw>Lag"ging*ly</hw>, <pos>adv.</pos> <def>In a lagging manner; loiteringly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagly</ent><br/
<hw>Lag"ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>Laggingly.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagnappe</ent><br/
<ent>Lagniappe</ent><br/
<mhw>{ <hw>La*gniappe</hw> <pr>(?)</pr>, <hw>La*gnappe"</hw> <pr>(?)</pr> }</mhw>, <pos>n.</pos> <altsp>[Also spelled <asp>lagnappe</asp>.]</altsp><ety>[Etym. uncertain.]</ety> <sn>1.</sn> <def>In Louisiana, a trifling present given to customers by tradesmen; a gratuity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Lagniappe</qex> . . .is something thrown in, gratis, for good measure.</q>  <rj><qau>Mark Twain.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>A tip or gratuity.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <specif>Hence:</specif> <def>Anything obtained gratuitously or unexpectedly.</def><br/
[<source>PJC</source>]</p>

<p><ent>lagomorph</ent><br/
<hw>lag"o*morph</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>One of the <ord>Lagomorpha</ord>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagomorpha</ent><br/
\'d8<hw>Lag`o*mor"pha</hw> <pr>(l<acr/g`<osl/*m<ocir/r"f<adot/)</pr>, <pos>prop. n. pl.</pos> <ety>[NL., fr. Gr. <grk>lagw`s</grk> a hare + <grk>morfh`</grk> form.]</ety> <fld>(Zool.)</fld> <def>an order of rodent-like mammals, comprising the hares, rabbits, and pikas. They have four incisors in the upper jaw. Called also <altname>Duplicidentata</altname>.  They were formerly classified together with the rodents, but the <ord>Rodentia</ord> and <ord>Lagomorpha</ord> are now classed as separate orders.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>lagoon</ent><br/
<hw>la*goon"</hw> <pr>(l<adot/*g<oomac/n")</pr>, <pos>n.</pos> <ety>[It. or Sp. <ets>laguna</ets>, L. <ets>lacuna</ets> ditch, pool, pond, <ets>lacus</ets> lake. See <er>Lake</er>, and cf. <er>Lacuna</er>.]</ety> <altsp>[Written also <asp>lagune</asp>.]</altsp> <sn>1.</sn> <def>A shallow sound, channel, pond, or lake, especially one into which the sea flows; <as>as, the <ex>lagoons</ex> of Venice</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A lake in a coral island, often occupying a large portion of its area, and usually communicating with the sea. See <er>Atoll</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lagoon island</b></col>, <cd>a coral island consisting of a narrow reef encircling a lagoon.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagophthalmos</ent><br/
<ent>Lagophthalmia</ent><br/
<mhw>{ \'d8<hw>Lag`oph*thal"mi*a</hw> <pr>(?)</pr>,   \'d8<hw>Lag`oph*thal"mos</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[NL. <ets>lagophtalmia</ets>, fr. Gr. <grk>lagw`s</grk> hare + <grk>'ofqalmo`s</grk> eye; -- so called from the notion that a hare sleeps with his eyes open.]</ety> <fld>(Med.)</fld> <def>A morbid condition in which the eye stands wide open, giving a peculiar staring appearance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagopous</ent><br/
<hw>La*go"pous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <grk>lagw`s</grk> a hare + <grk>poy`s</grk>, <grk>podo`s</grk>, foot.]</ety> <fld>(Bot.)</fld> <def>Having a dense covering of long hair, like the foot of a hare.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lagorchestes</ent><br/
<hw>Lagorchestes</hw> <pos>prop. n.</pos> <def>A mammal genus comprising the hare wallabies.</def><br/
<syn><b>Syn. --</b> genus <gen>Lagorchestes</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lagostomus</ent><br/
<hw>Lagostomus</hw> <pos>prop. n.</pos> <def>A mammal genus comprising the viscachas.</def><br/
<syn><b>Syn. --</b> genus <gen>Lagostomus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lagothrix</ent><br/
<hw>Lagothrix</hw> <pos>prop. n.</pos> <def>A mammal genus comprising the woolly monkeys.</def><br/
<syn><b>Syn. --</b> genus <gen>Lagothrix</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lagthing</ent><br/
\'d8<hw>Lag"thing</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Norw. <ets>lagting</ets>, <ets>lagthing</ets>; <ets>lag</ets> company, society (akin to E. <ets>law</ets>, <ets>lay</ets>) + <ets>ting</ets>, <ets>thing</ets>, parliament. See <er>Thing</er>.]</ety> <def>See <er>Legislatature</er>, below.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lagune</ent><br/
<hw>La*gune"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lagoon</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laical</ent><br/
<ent>Laic</ent><br/
<mhw>{ <hw>La"ic</hw> <pr>(?)</pr>, <hw>La"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>laicus</ets>: cf. F. <ets>la<ium/que</ets>. See <er>Lay</er> laic.]</ety> <def>Of or pertaining to a layman or the laity.</def> <ldquo/<xex>Laical</xex> literature.<rdquo/  <rj><au>Lowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>An unprincipled, unedified, and <qex>laic</qex> rabble.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laic</ent><br/
<hw>La"ic</hw>, <pos>n.</pos> <def>A layman.</def>  <rj><au>Bp. Morton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laicality</ent><br/
<hw>La"ic*al"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state or quality of being laic; the state or condition of a layman.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laically</ent><br/
<hw>La"ic*al*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>As a layman; after the manner of a layman; <as>as, to treat a matter <ex>laically</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laid</ent><br/
<hw>Laid</hw> <pr>(?)</pr>, <pos>imp. & p. p.</pos> <def>of <er>Lay</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Laid paper</b></col>, <cd>paper marked with parallel lines or water marks, as if ribbed, from parallel wires in the mold. It is called <xex>blue laid</xex>, <xex>cream laid</xex>, etc., according to its color.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laidly</ent><br/
<hw>Laid"ly</hw>, <pos>a.</pos> <def>Ugly; loathsome.</def> <mark>[Prov. Eng. & Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>This <qex>laidly</qex> and loathsome worm.</q> <rj><qau>W. Howitt.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lain</ent><br/
<hw>Lain</hw> <pr>(?)</pr>, <def><pos>p. p.</pos> of <er>Lie</er>, <pos>v. i.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lainere</ent><br/
<hw>Lain"ere</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lanier</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lair</ent><br/
<hw>Lair</hw> <pr>(l<acir/r)</pr>, <pos>n.</pos> <ety>[OE. <ets>leir</ets>, AS. <ets>leger</ets>; akin to D. <ets>leger</ets>, G. <ets>lager</ets> couch, lair, OHG. <ets>legar</ets>, Goth. <ets>ligrs</ets>, and to E. <ets>lie</ets>. See <er>Lie</er> to be prostrate, and cf. <er>Layer</er>, <er>Leaguer</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A place in which to lie or rest; especially, the bed or couch of a wild beast.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A burying place.</def> <mark>[Scot.]</mark>  <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A pasture; sometimes, food.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laird</ent><br/
<hw>Laird</hw> <pr>(l<acir/rd)</pr>, <pos>n.</pos> <ety>[See <er>Lord</er>.]</ety> <def>A lord; a landholder, esp. one who holds land directly of the crown.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lairdship</ent><br/
<hw>Laird"ship</hw>, <pos>n.</pos> <def>The state of being a laird; an estate; landed property.</def> <mark>[Scot.]</mark>  <rj><au>Ramsay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laism</ent><br/
<hw>La"ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lamaism</er>.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laissez faire</ent><br/
\'d8<hw>Lais`sez" faire"</hw> <pr>(?)</pr> <pos>n.</pos> <ety>[F., let alone.]</ety> <def>Noninterference; -- an axiom of some political economists, deprecating interference of government by attempts to foster or regulate commerce, manufactures, etc., by bounty or by restriction; <as>as, the doctrine of <ex>laissez faire</ex>; <ex>the laissez faire</ex> system of government.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laity</ent><br/
<hw>La"i*ty</hw> <pr>(l<amac/"<icr/*t<ycr/)</pr>, <pos>n.</pos> <ety>[See <er>Lay</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>The people, as distinguished from the clergy; the body of the people not in orders.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A rising up of the <qex>laity</qex> against the sacerdotal caste.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The state of a layman.</def> <mark>[Obs.]</mark>  <rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Those who are not of a certain profession, as law or medicine, in distinction from those belonging to it.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lakao</ent><br/
\'d8<hw>La*ka"o</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Sap green.</def> <mark>[China]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lake</ent><br/
<hw>Lake</hw> <pr>(l<amac/k)</pr>, <pos>n.</pos> <ety>[F. <ets>laque</ets>, fr. Per. See <er>Lac</er>.]</ety> <def>A pigment formed by combining some coloring matter, usually by precipitation, with a metallic oxide or earth, esp. with aluminium hydrate; <as>as, madder <ex>lake</ex>; Florentine <ex>lake</ex>; yellow <ex>lake</ex>, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lake</ent><br/
<hw>Lake</hw>, <pos>n.</pos> <ety>[Cf. G. <ets>laken</ets>.]</ety> <def>A kind of fine white linen, formerly in use.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lake</ent><br/
<hw>Lake</hw> <pr>(l<amac/k)</pr>, <pos>v. i.</pos> <ety>[AS. <ets>l<amac/can</ets>, <ets>l<ae/can</ets>, to spring, jump, <ets>l<amac/c</ets> play, sport, or fr. Icel. <ets>leika</ets> to play, sport; both akin to Goth. <ets>laikan</ets> to dance. <root/120.  Cf. <er>Knowledge</er>.]</ety> <def>To play; to sport.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lake</ent><br/
<hw>Lake</hw>, <pos>n.</pos> <ety>[AS. <ets>lac</ets>, L. <ets>lacus</ets>; akin to AS. <ets>lagu</ets> lake, sea, Icel. <ets>l<oum/gr</ets>; OIr. <ets>loch</ets>; cf. Gr. <grk>la`kkos</grk> pond, tank.  Cf. <er>Loch</er>, <er>Lough</er>.]</ety> <def>A large body of water contained in a depression of the earth's surface, and supplied from the drainage of a more or less extended area.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Lakes are for the most part of fresh water; the salt lakes, like the Great Salt Lake of Utah, have usually no outlet to the ocean.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lake dwellers</b></col> <fld>(Ethnol.)</fld>, <cd>people of a prehistoric race, or races, which inhabited different parts of Europe. Their dwellings were built on piles in lakes, a short distance from the shore. Their relics are common in the lakes of Switzerland.</cd> -- <col><b>Lake dwellings</b></col> <fld>(Archaeol.)</fld>, <cd>dwellings built over a lake, sometimes on piles, and sometimes on rude foundations kept in place by piles; specifically, such dwellings of prehistoric times. Lake dwellings are still used by many savage tribes. Called also <altname>lacustrine dwellings</altname>. See <er>Crannog</er>.</cd> -- <col><b>Lake fly</b></col> <fld>(Zool.)</fld>, <cd>any one of numerous species of dipterous flies of the genus <gen>Chironomus</gen>. In form they resemble mosquitoes, but they do not bite. The larvae live in lakes.</cd> -- <col><b>Lake herring</b></col> <fld>(Zool.)</fld>, <cd>the cisco (<spn>Coregonus Artedii</spn>).</cd> -- <mcol><col><b>Lake poets</b></col>, <col><b>Lake school</b></col></mcol>, <cd>a collective name originally applied in contempt, but now in honor, to Southey, Coleridge, and Wordsworth, who lived in the lake country of Cumberland, England, Lamb and a few others were classed with these by hostile critics. Called also <altname>lakers</altname> and <altname>lakists</altname>.</cd> -- <col><b>Lake sturgeon</b></col> <fld>(Zool.)</fld>, <cd>a sturgeon (<spn>Acipenser rubicundus</spn>), of moderate size, found in the Great Lakes and the Mississippi River. It is used as food.</cd> -- <col><b>Lake trout</b></col> <fld>(Zool.)</fld>, <cd>any one of several species of trout and salmon; in Europe, esp. <spn>Salmo fario</spn>; in the United States, esp. <spn>Salvelinus namaycush</spn> of the Great Lakes, and of various lakes in New York, Eastern Maine, and Canada. A large variety of brook trout (<spn>Salvelinus fontinalis</spn>), inhabiting many lakes in New England, is also called <ex>lake trout</ex>. See <er>Namaycush</er>.</cd> -- <col><b>Lake whitefish</b></col>. <fld>(Zool.)</fld> <cd>See <er>Whitefish</er>.</cd> -- <col><b>Lake whiting</b></col> <fld>(Zool.)</fld>, <cd>an American whitefish (<spn>Coregonus Labradoricus</spn>), found in many lakes in the Northern United States and Canada. It is more slender than the common whitefish.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lake-dweller</ent><br/
<hw>Lake"-dwell`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <cref>Lake dwellers</cref>, under <er>Lake</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lakefront</ent><br/
<hw>lakefront</hw> <pos>n.</pos> <def>land bordering a lake.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lakelet</ent><br/
<hw>Lake"let</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A little lake.</def>  <rj><au>Southey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laker</ent><br/
<hw>Lak"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One that is connected with a lake or lakes, as in habitation, toil, etc.:</def> <sd>(a)</sd> <def>One of the poets of the Lake school. See <cref>Lake poets</cref>, under <er>Lake</er>, <pos>n.</pos></def> <sd>(b)</sd> <fld>(Zool.)</fld> <def>A fish living in, or taken from, a lake, esp. the namaycush.</def> <sd>(c)</sd> <def>A lake steamer or canal boat.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The bridge tender . . . thought the Cowies <ldquo/a little mite<rdquo/ longer than that <qex>laker</qex>.</q>  <rj><qau>The Century.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>lakeshore</ent><br/
<hw>lakeshore</hw> <pos>n.</pos> <def>the shore of a lake.</def><br/
<syn><b>Syn. --</b> lakeside.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lakeside</ent><br/
<hw>lakeside</hw> <pos>n.</pos> <def>the shore of a lake.</def><br/
<syn><b>Syn. --</b> lakeshore.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lakeweed</ent><br/
<hw>Lake"weed`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The water pepper (<spn>Polygonum Hydropiper</spn>), an aquatic plant of Europe and North America.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lakh</ent><br/
\'d8<hw>Lakh</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Lac</er>, one hundred thousand.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lakin</ent><br/
<hw>La"kin</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Ladykin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lakke</ent><br/
<hw>Lak"ke</hw> <pr>(?)</pr>, <pos>n. & v.</pos> <def>See <er>Lack</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laky</ent><br/
<hw>Lak"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to a lake.</def>  <rj><au>Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laky</ent><br/
<hw>Lak"y</hw>, <pos>a.</pos> <ety>[From <er>Lake</er> the pigment.]</ety> <def>Transparent; -- said of blood rendered transparent by the action of some solvent agent on the red blood corpuscles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lallation</ent><br/
<hw>Lal*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lallare</ets> to sing lalla, or lullaby: cf. F. <ets>lallation</ets>.]</ety> <def>An imperfect enunciation of the letter <it>r</it>, in which it sounds like <it>l</it>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lalo</ent><br/
<hw>La"lo</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The powdered leaves of the baobab tree, used by the Africans to mix in their soup, as the southern negroes use powdered sassafras.  Cf. <er>Couscous</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lam</ent><br/
<hw>Lam</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lammed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lamming</conjf>.]</vmorph> <ety>[Icel. <ets>lemja</ets> to beat, or <ets>lama</ets> to bruise, both fr. <ets>lami</ets>, <ets>lama</ets>, lame. See <er>Lame</er>.]</ety> <def>To beat soundly; to thrash.</def> <mark>[Obs. or Low]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lama</ent><br/
<hw>La"ma</hw> <pr>(?; 277)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Llama</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lama</ent><br/
<hw>La"ma</hw>, <pos>n.</pos> <ety>[Tibet. <ets>blama</ets> (pronounced <pr>l<aum/"ma</pr>) a chief, a high priest.]</ety> <def>In Tibet, Mongolia, etc., a priest or monk of the belief called Lamaism.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>The Grand Lama</b></col>, <it>or</it> <col><b>Dalai Lama</b></col></mcol> <ety>[lit., Ocean Lama]</ety>, <cd>the supreme pontiff in the lamaistic hierarchy.  Until the Chinese occupied Tibet he resided in Lhasa, but now (1998) is in exile.  See <er>Lamaism</er>.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Lamaic</ent><br/
<hw>La"ma*ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Lamaism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamaism</ent><br/
<hw>La"ma*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A modified form of Buddhism which prevails in Tibet, Mongolia, and some adjacent parts of Asia; -- so called from the name of its priests. See 2d <er>Lama</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamaite</ent><br/
<ent>Lamaist</ent><br/
<mhw>{ <hw>La"ma*ist</hw> <pr>(?)</pr>, <hw>La"ma*ite</hw> <pr>(?)</pr> }</mhw> <pos>n.</pos> <def>One who believes in Lamaism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamaistic</ent><br/
<hw>La`ma*is"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Lamaism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamantin</ent><br/
<hw>La*man"tin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lamantin</ets>, <ets>lamentin</ets>, prob. from the name of the animal in the Antilles.  Cf. <er>Manater</er>.]</ety> <fld>(Zool.)</fld> <def>The manatee.</def> <altsp>[Written also <asp>lamentin</asp>, and <asp>lamantine</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamarckian</ent><br/
<hw>La*marck"i*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to, or involved in, the doctrines of Lamarckianism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamarckianism</ent><br/
<hw>La*marck"i*an*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Biol.)</fld> <def>Lamarckism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamarckism</ent><br/
<hw>La"marck"ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <ets>Lamarck</ets>, a distinguished French naturalist.]</ety> <fld>(Biol.)</fld> <def>The theory that structural variations, characteristic of species and genera, are produced in animals and plants by the direct influence of physical environments, and esp., in the case of animals, by effort, or by use or disuse of certain organs.  It is a discredited theory, not believed by modern biologists.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Lamasery</ent><br/
<hw>La"ma*ser*y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See 2d <er>Lama</er>.]</ety> <def>A monastery or convent of lamas, in Tibet, Mongolia, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamb</ent><br/
<hw>Lamb</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>lamb</ets>; akin to D. & Dan. <ets>lam</ets>, G. & Sw. <ets>lamm</ets>, OS., Goth., & Icel. <ets>lamb</ets>.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>The young of the sheep.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any person who is as innocent or gentle as a lamb.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A simple, unsophisticated person; in the cant of the Stock Exchange, one who ignorantly speculates and is victimized.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Lamb of God</b></col>, <col><b>The Lamb</b></col></mcol> <fld>(Script.)</fld>, <cd>the Jesus Christ, in allusion to the paschal lamb.</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>The twelve apostles of <qex>the Lamb</qex>.</q> <rj><qau>Rev. xxi. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Behold the <qex>Lamb of God</qex>, which taketh away the sin of the world.</q> <rj><qau>John i. 29.</qau></rj></p>

<p>-- <col><b>Lamb's lettuce</b></col> <fld>(Bot.)</fld>, <cd>an annual plant with small obovate leaves (<spn>Valerianella olitoria</spn>), often used as a salad; corn salad.</cd> <altsp>[Written also <asp>lamb lettuce</asp>.]</altsp> -- <col><b>Lamb's tongue</b></col>, <cd>a carpenter's plane with a deep narrow bit, for making curved grooves.</cd> <au>Knight.</au> -- <col><b>Lamb's wool</b></col>. <sd>(a)</sd> <cd>The wool of a lamb.</cd> <sd>(b)</sd> <cd>Ale mixed with the pulp of roasted apples; -- probably from the resemblance of the pulp of roasted apples to lamb's wool.</cd> <mark>[Obs.]</mark> <au>Goldsmith.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamb</ent><br/
<hw>Lamb</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lambed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lambing</conjf>.]</vmorph> <def>To bring forth a lamb or lambs, as sheep.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambale</ent><br/
<hw>Lamb"ale`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A feast at the time of shearing lambs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lambast</ent><br/
<hw>lam*bast"</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>Same as <er>lambaste</er>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lambaste</ent><br/
<hw>Lam*baste"</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[<ets>Lam</ets> + <ets>baste</ets> to beat.]</ety> <def>To beat severely;</def> <specif>specifically,</specif> <def>to beat with a cane.</def> <mark>[Low]</mark>  <rj><au>Nares.</au></rj><br/
<syn><b>Syn. --</b> cane, flog, lambaste.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>to scold, reprimand, or berate harshly.</def><br/
<syn><b>Syn. --</b> rebuke, rag, reproof, reprimand, jaw, dress down, scold, chide, berate, bawl out, jaw at, remonstrate with, chew out, chew up, have words with, lambast.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lambative</ent><br/
<hw>Lam"ba*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lambere</ets> to lick. See <er>Lambent</er>.]</ety> <def>Taken by licking with the tongue.</def> <ldquo/Sirups and <xex>lambative</xex> medicines.<rdquo/  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambative</ent><br/
<hw>Lam"ba*tive</hw>, <pos>n.</pos> <def>A medicine taken by licking with the tongue; a lincture.</def>  <rj><au>Wiseman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambda</ent><br/
\'d8<hw>Lamb"da</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>la`mbda</grk>.]</ety> <sn>1.</sn> <def>The name of the Greek letter <LAMBDA/, <lambda/, corresponding with the English letter L, l.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>The point of junction of the sagittal and lambdoid sutures of the skull.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Phys.)</fld> <def>A subatomic particle carrying no charge, having a mass equal to 2183 times that of an electron; it decays rapidly, typically forming a nucleon and a pion.</def> <au>MW10</au><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Lambda moth</b></col> <fld>(Zool.)</fld>, <cd>a moth so called from a mark on its wings, resembling the Greek letter lambda (<LAMBDA/).</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambdacism</ent><br/
<hw>Lamb"da*cism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lambdacismus</ets>, Gr. <?/, fr. <grk>la`mbda</grk> the letter lambda (<LAMBDA/).]</ety> <sn>1.</sn> <def>A fault in speaking or in composition, which consists in too frequent use of the letter <it>l</it>, or in doubling it erroneously.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A defect in pronunciation of the letter <it>l</it> when doubled, which consists in giving it a sound as if followed by <it>y</it>, similar to that of the letters <it>lli</it> in <it>billion</it>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The use of the sound of <it>l</it> for that of <it>r</it> in pronunciation; lallation; <as>as, Ame<it>l</it>ican for Ame<it>r</it>ican</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambdoid</ent><br/
<hw>Lamb"doid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr. <?/, <grk>la`mbda</grk> the letter lambda (<LAMBDA/) + <grk>e"i^dos</grk> shape.]</ety> <def>Shaped like the Greek letter lambda (<LAMBDA/); <as>as, the <ex>lambdoid</ex> suture between the occipital and parietal bones of the skull</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambdoidal</ent><br/
<hw>Lamb*doid"al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Same as <er>Lambdoid</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambent</ent><br/
<hw>Lam"bent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L.  <ets>lambens</ets>, <ets>-enlis</ets>, p. pr. of <ets>lambere</ets> to lick; akin to <ets>lap</ets>. See <er>Lap</er> to drink by licking.]</ety> <sn>1.</sn> <def>Playing on the surface; touching lightly; gliding over.</def> <ldquo/A <xex>lambent</xex> flame.<rdquo/ <au>Dryden.</au> <ldquo/A <xex>lambent</xex> style.<rdquo/ <au>Beaconsfield.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Twinkling or gleaming; fickering.</def> <ldquo/The <xex>lambent</xex> purity of the stars.<rdquo/  <rj><au>W. Irving.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambertia</ent><br/
<hw>Lambertia</hw> <pos>n.</pos> <def>A small genus of Australian shrubs.</def><br/
<syn><b>Syn. --</b> genus <gen>Lambertia</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lambert pine</ent><br/
<hw>Lam"bert pine`</hw> <pr>(?)</pr> <pos>n.</pos> <ety>[So called from <etsep>Lambert</etsep>, an English botanist.]</ety> <fld>(Bot.)</fld> <def>The gigantic sugar pine of California and Oregon (<spn>Pinus Lambertiana</spn>). It has the leaves in fives, and cones a foot long. The timber is soft, and like that of the white pine of the Eastern States.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambis</ent><br/
<hw>Lambis</hw> <pos>n.</pos> <def>A genus of scorpion shells of shallow tropical waters of eastern hemisphere.</def><br/
<syn><b>Syn. --</b> genus <gen>Lambis</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lambkill</ent><br/
<hw>Lamb"kill`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A small American ericaceous shrub (<spn>Kalmia angustifolia</spn>), resembling mountain laurel but having narrower leaves and small red flowers; -- called also <altname>calfkill</altname>, <altname>sheepkill</altname>, <altname>sheep laurel</altname>, etc. It is supposed to poison young sheep and other animals that eat it at times when the snow is deep and they cannot find other food.</def><br/
<syn><b>Syn. --</b> sheep laurel, pig laurel, <spn>Kalmia angustifolia</spn>.</syn><br/
[<source>Webster 1913 Suppl.</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Lambkin</ent><br/
<hw>Lamb"kin</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A small lamb.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamblike</ent><br/
<hw>Lamb"like</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Like a lamb; gentle; meek; inoffensive.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamboys</ent><br/
<hw>Lam"boys</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[Cf. F. <ets>lambeau</ets>.  Cf. <er>Label</er>.]</ety> <fld>(Anc. Armor)</fld> <def>Same as <er>Base</er>, <pos>n.</pos>, 19.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambrequin</ent><br/
<hw>Lam"bre*quin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.  Cf. <er>Lamboys</er>, <er>Label</er>.]</ety> <sn>1.</sn> <def>A kind of pendent scarf or covering attached to the helmet, to protect it from wet or heat.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A leather flap hanging from a cuirass.</def>  <rj><au>Wilhelm.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A piece of ornament drapery or short decorative hanging, pendent from a shelf or from the casing above a window, hiding the curtain fixtures, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambskin</ent><br/
<hw>Lamb"skin`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The skin of a lamb; especially, a skin dressed with the wool on, and used as a mat. Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A kind of woolen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lambskinnet</ent><br/
<hw>Lamb"skin`net"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lansquenet</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamb's-quarters</ent><br/
<hw>Lamb's-quar"ters</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A name given to several common weedy European plants of the Goosefoot family, introduced into N. America, and sometimes used as pot herbs, as <spn>Chenopodium album</spn> and <spn>Atriplex patulsa</spn>.</def> <note>It is sometimes collected from the wild and eaten as a vegetable</note><br/
<syn><b>Syn. --</b> lamb's quarters, pigweed, wild spinach, Chenopodium album.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Lamdoidal</ent><br/
<hw>Lam*doid"al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Lambdoid.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lame</ent><br/
<hw>Lame</hw> <pr>(l<amac/m)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Lamer</adjf> <pr>(l<amac/m"<etil/r)</pr>; <pos>superl.</pos> <adjf>Lamest</adjf>.]</amorph> <ety>[OE. <ets>lame</ets>, AS. <ets>lama</ets>; akin to D. <ets>lam</ets>, G. <ets>lahm</ets>, OHG., Dan., & Sw. <ets>lam</ets>, Icel. <ets>lami</ets>, Russ. <ets>lomate</ets> to break, <ets>lomota</ets> rheumatism.]</ety> <sn>1.</sn> <sd>(a)</sd> <def>Moving with pain or difficulty on account of injury, defect, or temporary obstruction of a function; <as>as, a <ex>lame</ex> leg, arm, or muscle</as>.</def> <sd>(b)</sd> <def>To some degree disabled by reason of the imperfect action of a limb; crippled; <as>as, a <ex>lame</ex> man</as>.</def> <ldquo/<xex>Lame</xex> of one leg.<rdquo/ <au>Arbuthnot.</au> <ldquo/<xex>Lame</xex> in both his feet.<rdquo/ <au>2 Sam. ix. 13.</au> <ldquo/He fell, and became <xex>lame</xex>.<rdquo/ <au>2 Sam. iv. 4.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence, hobbling; limping; inefficient; imperfect; <as>as, a <ex>lame</ex> answer</as>.</def> <ldquo/A <xex>lame</xex> endeavor.<rdquo/  <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>O, most <qex>lame</qex> and impotent conclusion!</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lame duck</b></col> <sd>(a)</sd> <fld>(Stock Exchange)</fld>, <cd>a person who can not fulfill his contracts.</cd> <mark>[Cant]</mark>  <sd>(b)</sd> <cd>An elected politician who is completing a term after having been defeated at an election; also, an office holder who cannot or chooses not to run again for the same office; -- So called from the presumed lack of political power of one who is soon to be out of office.</cd> <sd>(b)</sd> <cd>Any office holder who is serving out a term after a replacement has been selected.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><-- p. 826 --></p>

<p><ent>Lame</ent><br/
<hw>Lame</hw> <pr>(l<amac/m)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lamed</conjf> <pr>(l<amac/md)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laming</conjf>.]</vmorph> <def>To make lame.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If you happen to let child fall and <qex>lame</qex> it.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lamedh</ent><br/
<hw>lamedh</hw> <pos>n.</pos> <def>The 12th letter of the Hebrew alphabet, corresponding to <sig>l</sig>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lamel</ent><br/
<hw>Lam"el</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lamella</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamella</ent><br/
<ent>Lamellae</ent><br/
<hw>La*mel"la</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Lamell<ae/</plw> <pr>(#)</pr>, E. <plw>Lamellas</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>lamella</ets>, dim. of <ets>lamina</ets> plate, leaf, layer: cf. F. <ets>lamelle</ets>.  Cf. <er>Lamina</er>, <er>Omelet</er>.]</ety> <def>A thin plate or scale of anything, as a thin scale growing from the petals of certain flowers; or one of the thin plates or scales of which certain shells are composed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellarly</ent><br/
<ent>Lamellar</ent><br/
<hw>Lam"el*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>lamellaire</ets>.]</ety> <def>Flat and thin; lamelliform; composed of lamellAE.</def> -- <def2><hw>Lam"el*lar*ly</hw>, <pos>adv.</pos> <def>In thin plates or scales.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellary</ent><br/
<hw>Lam"el*la*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to lamella or to lamellae; lamellar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellated</ent><br/
<ent>Lamellate</ent><br/
<mhw>{ <hw>Lam"el*late</hw> <pr>(?)</pr>, <hw>Lam"el*la`ted</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[See <er>Lamella</er>.]</ety> <def>Composed of, or furnished with, thin plates or scales. See <xex>Illust.</xex> of <er>Antenn<ae/</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellibranch</ent><br/
<hw>La*mel"li*branch</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>One of the <class>Lamellibranchia</class> (also called <class>Pelecypoda</class>). Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellibranchiata</ent><br/
<ent>Lamellibranchia</ent><br/
<mhw>{ \'d8<hw>La*mel`li*bran"chi*a</hw> <pr>(?)</pr>, \'d8<hw>La*mel`li*bran`chi*a"ta</hw> <pr>(?)</pr>, }</mhw> <pos>n. pl.</pos> <ety>[NL. See <er>lamella</er>, and <er>Branchia</er>, <er>Branchiate</er>.]</ety> <fld>(Zool.)</fld> <def>An earlier name for the class of <isa><phylum>Mollusca</phylum></isa> including all those that have bivalve shells, as the clams, oysters, mussels, etc., now called <altname><class>Pelecypoda</class></altname> or <altname><class>Bivalvia</class></altname>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><note><hand/ They usually have two (rarely but one) flat, lamelliform gills on each side of the body. They have an imperfectly developed head, concealed within the shell, whence they are called <altname><ord>Acephala</ord></altname>. Called also <altname>Conchifera</altname>, and <altname>Pelecypoda</altname>.  See <er>Bivalve</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellibranchiate</ent><br/
<hw>Lam`el*li*bran"chi*ate</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Having lamellar gills; belonging to the <class>Lamellibranchia</class> (also called <class>Pelecypoda</class>).</def> -- <def2><pos>n.</pos> <def>One of the <class>Lamellibranchia</class> (also called <class>Pelecypoda</class>).</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellicorn</ent><br/
<hw>La*mel"li*corn</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lamella</ets> + L. <ets>cornu</ets> a horn: cf. F. <ets>lamellicorne</ets>. See <er>Lamella</er>.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd> <def>Having antennae terminating in a group of flat lamellae; -- said of certain coleopterous insects.</def> <sd>(b)</sd> <def>Terminating in a group of flat lamellae; -- said of antennae.</def> -- <def2><pos>n.</pos> <def>A lamellicorn insect.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellicornia</ent><br/
\'d8<hw>La*mel`li*cor"ni*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Lamellicorn</er>.]</ety> <fld>(Zool.)</fld> <def>A group of lamellicorn, plant-eating beetles; -- called also <altname>Lamellicornes</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamelliferous</ent><br/
<hw>Lam`el*lif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lamella</ets> + <ets>-ferous</ets>:  cf. F. <ets>lamellif<egrave/re</ets>.]</ety> <def>Bearing, or composed of, lamellae, or thin layers, plates, or scales; foliated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamelliform</ent><br/
<hw>La*mel"li*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lamella</ets> + <ets>-form</ets> : cf. F. <ets>lamelliforme</ets>.]</ety> <def>Thin and flat; scalelike; lamellar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellirostral</ent><br/
<hw>Lam`el*li*ros"tral</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lamella</ets> + <ets>rostral</ets> : cf. F. <ets>lamellirostre</ets>.]</ety> <fld>(Zool.)</fld> <def>Having a lamellate bill, as ducks and geese.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellirostres</ent><br/
\'d8<hw>La*mel`li*ros"tres</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Lamella</er>, and <er>Rostrum</er>.]</ety> <fld>(Zool.)</fld> <def>A group of birds embracing the Anseres and flamingoes, in which the bill is lamellate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamellose</ent><br/
<hw>Lam"el*lose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>lamelleux</ets>.]</ety> <def>Composed of, or having, lamellae; lamelliform.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamely</ent><br/
<hw>Lame"ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[See <er>Lame</er>.]</ety> <def>In a lame, crippled, disabled, or imperfect manner; <as>as, to walk <ex>lamely</ex>; a figure <ex>lamely</ex> drawn.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lameness</ent><br/
<hw>Lame"ness</hw>, <pos>n.</pos> <def>The condition or quality of being lame; <as>as, the <ex>lameness</ex> of an excuse or an argument</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lament</ent><br/
<hw>La*ment"</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[F. <ets>lamenter</ets>, L. <ets>lamentari</ets>, fr. <ets>lamentum</ets> a lament.]</ety> <def>To express or feel sorrow; to weep or wail; to mourn.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Jeremiah <qex>lamented</qex> for Josiah.</q> <rj><qau>2 Chron. xxxv. 25.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ye shall weep and <qex>lament</qex>, but the world shall rejoice.</q> <rj><qau>John xvi. 20.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lament</ent><br/
<hw>La*ment"</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lamented</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Lamenting</conjf>.]</vmorph> <def>To mourn for; to bemoan; to bewail.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>One laughed at follies, one <qex>lamented</qex> crimes.</q> <rj><qau>Dryden.</qau></rj></p>

<p><syn><b>Syn.</b> -- To deplore; mourn; bewail. See <er>Deplore</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lament</ent><br/
<hw>La*ment"</hw>, <pos>n.</pos> <ety>[L. <ets>lamentum</ets>.  Cf. <er>Lament</er>, <pos>v.</pos>]</ety> <sn>1.</sn> <def>Grief or sorrow expressed in complaints or cries; lamentation; a wailing; a moaning; a weeping.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Torment, and loud <qex>lament</qex>, and furious rage.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An elegy or mournful ballad, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamentable</ent><br/
<hw>Lam"en*ta*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lamentabilis</ets>: cf. F. <ets>lamentable</ets>.]</ety> <sn>1.</sn> <def>Mourning; sorrowful; expressing grief; <as>as, a <ex>lamentable</ex> countenance</as>.</def> <mark>[Archaic]</mark> <ldquo/<xex>Lamentable</xex> eye.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fitted to awaken lament; to be lamented; sorrowful; pitiable; regrettable; unfortunate; <as>as, a <ex>lamentable</ex> misfortune, or error</as>.</def> <ldquo/<xex>Lamentable</xex> helplessness.<rdquo/  <rj><au>Burke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Miserable; pitiful; paltry; -- in a contemptuous or ridiculous sense.</def>  <rj><au>Bp. Stillingfleet.</au></rj></p>

<p>-- <wordforms><wf>Lam"en*ta*ble*ness</wf>, <pos>n.</pos> -- <wf>Lam"en*ta*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamentation</ent><br/
<hw>Lam`en*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lamentation</ets>, L. <ets>lamentatio</ets>.]</ety> <sn>1.</sn> <def>The act of bewailing; audible expression of sorrow; wailing; moaning.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In Rama was there a voice heard, <qex>lamentation</qex> and weeping.</q> <rj><qau>Matt. ii. 18.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <fld>(Script.)</fld> <def>A book of the Old Testament attributed to the prophet Jeremiah, and taking its name from the nature of its contents.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamented</ent><br/
<hw>La*ment"ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Mourned for; bewailed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This humble praise, <qex>lamented</qex> shade ! receive.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamenter</ent><br/
<hw>La*ment"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who laments.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamentin</ent><br/
<hw>La*men"tin</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lamantin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamenting</ent><br/
<hw>La*ment"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Lamentation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Lamentings</qex> heard i' the air.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamentingly</ent><br/
<hw>La*ment"ing*ly</hw>, <pos>adv.</pos> <def>In a lamenting manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lames</ent><br/
<hw>Lames</hw> <pr>(l<adot/mz)</pr>, <pos>n. pl.</pos> <ety>[F. <ets>lame</ets> a thin plate, L. <ets>lamina</ets>.]</ety> <fld>(Armor)</fld> <def>Small steel plates combined together so as to slide one upon the other and form a piece of armor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lametta</ent><br/
\'d8<hw>La*met"ta</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. It. <ets>lametta</ets>, dim. of <ets>lama</ets> a thin plate.]</ety> <def>Foil or wire made of gold, silver, or brass.</def>  <rj><au>De Colange.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamia</ent><br/
<hw>La"mi*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. Gr. <?/.]</ety> <fld>(Class. Myth.)</fld> <def>A monster capable of assuming a woman's form, who was said to devour human beings or suck their blood; a vampire; a sorceress; a witch.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamina</ent><br/
<ent>Laminaa</ent><br/
<hw>Lam"i*na</hw> <pr>(l<acr/m"<icr/*n<adot/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Lamin<ae/</plw> <pr>(-n<emac/)</pr> E. <plw>Laminas</plw> <pr>(-n<adot/z)</pr>.</plu> <ety>[L. cf. <er>Lamella</er>.]</ety> <sn>1.</sn> <def>A thin plate or scale; a layer or coat lying over another; -- said of thin plates or platelike substances, as of bone or minerals.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>The blade of a leaf; the broad, expanded portion of a petal or sepal of a flower.</def>  <rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>A thin plate or scale; specif., one of the thin, flat processes composing the vane of a feather.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminability</ent><br/
<hw>Lam`i*na*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality or state of being laminable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminable</ent><br/
<hw>Lam"i*na*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being split into lamin<ae/ or thin plates, as mica; capable of being extended under pressure into a thin plate or strip.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When a body can be readily extended in all directions under the hammer, it is said to be malleable; and when into fillets under the rolling press, it is said to be <qex>laminable</qex>.</q> <rj><qau>Ure.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminal</ent><br/
<ent>Laminar</ent><br/
<mhw>{ <hw>Lam"i*nar</hw> <pr>(?)</pr>, <hw>Lam"i*nal</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>laminaire</ets>. See <er>Lamina</er>]</ety> <def>In, or consisting of, thin plates or layers; having the form of a thin plate or lamina.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminaria</ent><br/
\'d8<hw>Lam`i*na"ri*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Lamina</er>.]</ety> <fld>(Bot.)</fld> <def>A genus of great seaweeds with long and broad fronds; kelp, or devil's apron. The fronds commonly grow in clusters, and are sometimes from thirty to fifty feet in length. See <xex>Illust.</xex> of <er>Kelp</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminarian</ent><br/
<hw>Lam`i*na"ri*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to seaweeds of the genus <gen>Laminaria</gen>, or to that zone of the sea (from two to ten fathoms in depth) where the seaweeds of this genus grow.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminarite</ent><br/
<hw>Lam"i*na*rite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lamina</er>.]</ety> <fld>(Paleon.)</fld> <def>A broad-leafed fossil alga.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminary</ent><br/
<hw>Lam"i*na*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Laminar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminate</ent><br/
<hw>Lam"i*nate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Lamina</er>.]</ety> <def>Consisting of, or covered with, laminae, or thin plates, scales, or layers, one over another; laminated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminate</ent><br/
<hw>Lam"i*nate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Laminated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laminating</conjf> <pr>(?)</pr>.]</vmorph> <ety>[See <er>Lamina</er>.]</ety> <sn>1.</sn> <def>To cause to separate into thin plates or layers; to divide into thin plates.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To form, as metal, into a thin plate, as by rolling.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To form by uniting two or more layers (in sheet form) of a material, so that the layers are bonded tightly; <as>as, plywood has at least three <ex>laminated</ex> layers</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>To unite (layers in sheet form) by bonding, so as to create a single object with multiple layers; -- used with the material in sheet form as the object; <as>as, to <ex>laminate</ex> plywood</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Laminate</ent><br/
<hw>Lam"i*nate</hw>, <pos>v. i.</pos> <def>To separate into laminae.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>laminated</ent><br/
<hw>lam"i*na`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Consisting of, or covered with, laminae, or thin plates, sheets, scales, or layers, one over another; laminate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>Hence:</specif> <def>Constructed of thin sheets of material, bonded together to form a composite structure having multiple layers.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Laminated arch</b></col> <fld>(Arch.)</fld>, <cd>a timber arch made of layers of bent planks secured by treenails.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminating</ent><br/
<hw>Lam"i*na`ting</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Forming, or separating into, scales or thin layers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamination</ent><br/
<hw>Lam`i*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The process of laminating, or the state of being laminated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminiferous</ent><br/
<hw>Lam`i*nif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lamina</ets> + <ets>-ferous</ets>.]</ety> <def>Having a structure consisting of lamin<ae/, or thin layers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminiplantar</ent><br/
<hw>Lam`i*ni*plan"tar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lamina</ets> + L. <ets>planta</ets> sole of the foot.]</ety> <fld>(Zool.)</fld> <def>Having the tarsus covered behind with a horny sheath continuous on both sides, as in most singing birds, except the larks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laminitis</ent><br/
\'d8<hw>Lam`i*ni"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Lamina</er>, and <er>-itis</er>.]</ety> <fld>(Far.)</fld> <def>Inflammation of the lamin<ae/ or fleshy plates along the coffin bone of a horse; founder.</def>  <rj><au>Youatt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamish</ent><br/
<hw>Lam"ish</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Somewhat lame.</def>  <rj><au>Wood.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamm</ent><br/
<hw>Lamm</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>See <er>Lam</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lammas</ent><br/
<hw>Lam"mas</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>hl<amac/mmesse</ets>, <ets>hl<amac/fm<ae/sse</ets>, loaf mass, bread feast, or feast of first fruits; <ets>hl<amac/f</ets> loaf + <ets>m<ae/sse</ets> mass. See <er>Loaf</er>, and <er>Mass</er> religious service.]</ety> <def>The first day of August; -- called also <altname>Lammas day</altname>, and <altname>Lammastide</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lammergeyer</ent><br/
<ent>Lammergeier</ent><br/
<ent>Lammergeir</ent><br/
<mhw>{ <hw>Lam"mer*geir</hw> <pr>(l<acr/m"m<etil/r*g<imac/r)</pr>, <hw>Lam"mer*gei`er</hw>, <hw>lam"mer*gey`er</hw> <pr>(l<acr/m"m<etil/r*g<imac/`<etil/r)</pr>, }</mhw> <pos>n.</pos> <ety>[G. <ets>l<aum/mmergeier</ets>; <ets>lamm</ets>, pl. <ets>l<aum/mmer</ets>, lamb + <ets>geier</ets> vulture.]</ety> <fld>(Zool.)</fld> <def>A very large vulture (<spn>Gypa<eum/tus barbatus</spn>), which inhabits the mountains of Southern Europe, Asia, and Northern Africa.  When full-grown it is nine or ten feet in extent of wings.  It is brownish black above, with the under parts and neck rusty yellow; the forehead and crown white; the sides of the head and beard black.  It feeds partly on carrion and partly on small animals, which it kills.  It has the habit of carrying tortoises and marrow bones to a great height, and dropping them on stones to obtain the contents, and is therefore called <altname>bonebreaker</altname> and <altname>ossifrage</altname>.  It is supposed to be the <altname>ossifrage</altname> of the Bible. Called also <altname>bearded vulture</altname> and <altname>bearded eagle</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamnidae</ent><br/
<hw>Lamnidae</hw> <pos>n.</pos> <def>A natural family of oceanic sharks.</def><br/
<syn><b>Syn. --</b> family <fam>Lamnidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lamnunguia</ent><br/
\'d8<hw>Lam*nun"gui*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>lamina</ets> a scale + <ets>unguis</ets> a nail.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Hyracoidea</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamp</ent><br/
<hw>Lamp</hw> <pr>(l<acr/mp)</pr>, <pos>n.</pos> <ety>[OE. (with excrescent <ets>p</ets>), fr. F. <ets>lame</ets>, L. <ets>lamina</ets>. See <er>Lamina</er>.]</ety> <def>A thin plate or lamina.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamp</ent><br/
<hw>Lamp</hw> <pr>(l<acr/mp)</pr>, <pos>n.</pos> <ety>[F. <ets>lampe</ets>, L. <ets>lampas</ets>, <ets>-adis</ets>, fr. Gr. <?/ , <?/, torch, fr. <?/ to give light, to shine.  Cf. <er>Lampad</er>, <er>Lantern</er>.]</ety> <sn>1.</sn> <def>A light-producing vessel, device, instrument or apparatus;</def> <specif>formerly referring especially to</specif> <def>a vessel with a wick used for the combustion of oil or other inflammable liquid, for the purpose of producing artificial light; also, a similar device using a gas as the combustible fuel;</def> <specif>now referring mainly to</specif> <def>an electric lamp.  See sense {3}.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>Figuratively, anything which enlightens intellectually or morally; anything regarded metaphorically a performing the uses of a lamp.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thy word is a <qex>lamp</qex> unto my feet, and a light unto my path.</q> <rj><qau>Ps. cxix. 105.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ages elapsed ere Homer's <qex>lamp</qex> appeared.</q> <rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Elec.)</fld> <def>A device or mechanism for producing light by electricity, usually having a glass bulb or tube containing the light-emitting element.  Most lamps belong to one of two categories, the <styp><cref>Incandescent lamp</cref></styp> (See under <er>Incandescent</er>) or the <stype>fluorescent lamp</stype>.  However, see also <styp><cref>arc lamp</cref></styp>, below.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>4.</sn> <def>A device that emits radiant energy in the form of heat, infrared, or ultraviolet rays; <as>as, a <ex>heat</ex> lamp</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Aeolipile lamp</b></col>, <cd>a hollow ball of copper containing alcohol which is converted into vapor by a lamp beneath, so as to make a powerful blowpipe flame when the vapor is ignited.</cd> <au>Weale.</au> -- <col><b>Arc lamp</b></col> <fld>(Elec.)</fld>, <cd>a form of lamp in which the voltaic arc is used as the source of light.</cd> -- <col><b>D<eum/bereiner's lamp</b></col>, <cd>an apparatus for the instantaneous production of a flame by the spontaneous ignition of a jet of hydrogen on being led over platinum sponge; -- named after the German chemist <etsep>D<oum/bereiner</etsep>, who invented it. Called also <altname>philosopher's lamp</altname>.</cd> -- <col><b>Flameless lamp</b></col>, <cd>an aphlogistic lamp.</cd> -- <col><b>Lamp burner</b></col>, <cd>the part of a lamp where the wick is exposed and ignited.</cd> <au>Knight.</au> -- <col><b>Lamp fount</b></col>, <cd>a reservoir for oil, in a lamp.</cd> -- <col><b>Lamp jack</b></col>. <cd>See 2d <er>Jack</er>, <pos>n.</pos>, 4 <sd>(l)</sd> & <sd>(n)</sd>.</cd> -- <col><b>Lamp shade</b></col>, <cd>a screen, as of paper, glass, or tin, for softening or obstructing the light of a lamp.</cd> -- <col><b>Lamp shell</b></col> <fld>(Zool.)</fld>, <cd>any brachiopod shell of the genus <gen>Terebratula</gen> and allied genera. The name refers to the shape, which is like that of an antique lamp. See <er>Terebratula</er>.</cd> -- <col><b>Safety lamp</b></col>, <cd>a miner's lamp in which the flame is surrounded by fine wire gauze, preventing the kindling of dangerous explosive gases; -- called also, from <person>Sir Humphry <etsep>Davy</etsep></person> the inventor, <altname>Davy lamp</altname>.</cd> -- <col><b>To smell of the lamp</b></col>, <cd>to bear marks of great study and labor, as a literary composition.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampad</ent><br/
<hw>Lam"pad</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ , <?/. See <er>Lamp</er>.]</ety> <def>A lamp or candlestick.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>By him who 'mid the golden <qex>lampads</qex> went.</q> <rj><qau>Trench.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampadist</ent><br/
<hw>Lam"pa*dist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/, fr. <?/, <?/, torch. See <er>Lamp</er>.]</ety> <fld>(Gr. Antiq.)</fld> <def>One who gained the prize in the lampadrome.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampadrome</ent><br/
<hw>Lam"pa*drome</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/; <?/, <?/, torch + <?/ course, race, fr. <?/ to run.]</ety> <fld>(Gr. Antiq.)</fld> <def>A race run by young men with lighted torches in their hands.  He who reached the goal first, with his torch unextinguished, gained the prize.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampas</ent><br/
<hw>Lam"pas</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lampas</ets>.]</ety> <def>An inflammation and swelling of the soft parts of the roof of the mouth immediately behind the fore teeth in the horse; -- called also <altname>lampers</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampate</ent><br/
<hw>Lam"pate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lampate</ets>.]</ety> <fld>(Chem.)</fld> <def>A supposed salt of lampic acid.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampblack</ent><br/
<hw>Lamp"black`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lamp</ets> + <ets>black</ets>.]</ety> <def>The fine impalpable soot obtained from the smoke of carbonaceous substances which have been only partly burnt, as in the flame of a smoking lamp. It consists of finely divided carbon, with sometimes a very small proportion of various impurities. It is used as an ingredient of printers' ink, and various black pigments and cements.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamper eel</ent><br/
<hw>Lam"per eel`</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Lamprey</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampern</ent><br/
<hw>Lam"pern</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lamprey</er>.]</ety> <fld>(Zool.)</fld> <def>The river lamprey (<spn>Ammoc<oe/tes  fluviatilis</spn> syn. <spn>Lampetra fluviatilis</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name is also applied to other river lampreys.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampers</ent><br/
<hw>Lam"pers</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lampas</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampic</ent><br/
<hw>Lam"pic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F. <ets>lampique</ets>, fr. <ets>lampe</ets> lamp. See <er>Lamp</er>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or produced by, a lamp; -- formerly said of a supposed acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamping</ent><br/
<hw>Lamp"ing</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Shining; brilliant.</def> <mark>[Obs.]</mark> <ldquo/<xex>Lamping</xex> eyes.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampless</ent><br/
<hw>Lamp"less</hw>, <pos>a.</pos> <def>Being without a lamp, or without light; hence, being without appreciation; dull.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Your ladies' eyes are <qex>lampless</qex> to that virtue.</q> <rj><qau>Beau. & Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamplight</ent><br/
<hw>Lamp"light`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Light from a lamp.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This world's artificial <qex>lamplights</qex>.</q> <rj><qau>Owen Meredith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamplighter</ent><br/
<hw>Lamp"light`er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who, or that which, lights a lamp;</def> <specif>esp.,</specif> <def>a person who in former times lighted street lamps which were illuminated by a combustible gas; -- such lamps are now little used, and primarily as nostalgic ornaments.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>He made the night a little brighter<br/
Wherever he did go,<br/
The old <qex>lamplighter</qex><br/
Of long, long ago.</q> <rj><qau>Song lyrics. (?)</qau></rj><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The calico bass.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A device used to light lamps.</def><br/
[<source>PJC</source>]</p>

<p><ent>lamplit</ent><br/
<hw>lamplit</hw> <pos>adj.</pos> <def>Illuminated by a lamp.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lampoon</ent><br/
<hw>Lam*poon"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lampon</ets> a drinking song, fr. <ets>lampons</ets> let us drink, -- the burden of such a song, fr.  <ets>lamper</ets> to guzzle, to drink much and greedily; of German origin, and akin to E. <ets>lap</ets> to drink. Prob. so called because drinking songs often contain personal slander or satire.]</ety> <sn>1.</sn> <def>A personal satire in writing; usually, malicious and abusive censure written only to reproach and distress.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like her who missed her name in a <qex>lampoon</qex>,<br/
And grieved to find herself decayed so soon.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>Hence:</specif> <def>Any satire ridiculing or mocking a person, activity, or institution by representing its character or behavior in an exaggerated or grotesque form; the representation may be written, filmed, or performed as a live skit, and may be intended as a severe reproach, or as good-natured humor.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lampoon</ent><br/
<hw>Lam*poon"</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lampooned</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lampooning</conjf>.]</vmorph> <def>To subject to abusive ridicule expressed in a work of art; to make (a person, behavior, or institution) the subject of a lampoon.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>Ribald poets had <qex>lampooned</qex> him.</q> <rj><qau>Macaulay.</qau></rj></p>

<p><syn><b>Syn.</b> -- To libel; defame; satirize; lash.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampooner</ent><br/
<hw>Lam*poon"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The writer of a lampoon.</def> <ldquo/Libelers, <xex>lampooners</xex>, and pamphleteers.<rdquo/  <rj><au>Tatler.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampoonry</ent><br/
<hw>Lam*poon"ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act of lampooning; a lampoon, or lampoons.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamp-post</ent><br/
<hw>Lamp"-post`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A post (generally a pillar of iron) supporting a lamp or lantern for lighting a street, park, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamprel</ent><br/
<hw>Lam"prel</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Lamprey</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lamprey</ent><br/
<hw>Lam"prey</hw> <pr>(l<acr/m"pr<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lampreys</plw> <pr>(l<acr/m"pr<icr/z)</pr>.</plu> <ety>[OE. <ets>lampreie</ets>, F. <ets>lamproie</ets>, LL. <ets>lampreda</ets>, <ets>lampetra</ets>, from L. <ets>lambere</ets> to lick + <ets>petra</ets> rock, stone. The lampreys are so called because they attach themselves with their circular mouths to rocks and stones, whence they are also called <altname>rocksuckers</altname>. See <er>Lap</er> to drink, <er>Petrify</er>.]</ety> <fld>(Zool.)</fld> <def>An eel-like marsipobranch of the genus <gen>Petromyzon</gen>, and allied genera; called also <altname>lamprey eel</altname> and <altname>lamper eel</altname>.  The lampreys have a round, sucking mouth, without jaws, but set with numerous minute teeth, and one to three larger teeth on the palate (see <xex>Illust.</xex> of <er>Cyclostomi</er>). There are seven small branchial openings on each side.</def> <altsp>[Written also <asp>lamprel</asp>, and <asp>lampron</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 827 --></p>

<p><note><hand/ The common or sea lamprey of America and Europe (<spn>Petromyzon marinus</spn>), which in spring ascends rivers to spawn, is considered excellent food by many, and is sold as a market fish in some localities.  The smaller river lampreys mostly belong to the genus <gen>Ammoc<oe/les</gen>, or <gen>Lampetra</gen>, as <spn>Ammoc<oe/les fluviatilis</spn>, of Europe, and <spn>Ammoc<oe/les <ae/pypterus</spn> of America.  All lampreys attach themselves to other fishes, as parasites, by means of the suckerlike mouth.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampron</ent><br/
<hw>Lam"pron</hw> <pr>(l<acr/m"pr<ocr/n)</pr>, <pos>n.</pos> <ety>[Cf. OE. <ets>lampreon</ets>. See <er>Lamprey</er>.]</ety> <fld>(Zool.)</fld> <def>See <er>Lamprey</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lamp shade</ent><br/
<ent>lampshade</ent><br/
<mhw><hw>lampshade</hw>, <hw>lamp shade</hw></mhw> <pos>n.</pos> <def>a protective ornamental covering used to screen the light bulb in a lamp from direct view.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lamp shell</ent><br/
<ent>lampshell</ent><br/
<mhw><hw>lampshell</hw>, <hw>lamp shell</hw></mhw> <pos>n.</pos> <def>A mollusklike marine animal with bivalve shell having a pair of arms bearing tentacles for capturing food, found worldwide.</def><br/
<syn><b>Syn. --</b> brachiopod.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lampyridae</ent><br/
<hw>Lampyridae</hw> <pos>prop. n.</pos> <def>A natural family of insects comprising the fireflies.</def><br/
<syn><b>Syn. --</b> family <fam>Lampyridae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lampyrine</ent><br/
<hw>Lam*py"rine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lampyris</er>.]</ety> <fld>(Zool.)</fld> <def>An insect of the genus <gen>Lampyris</gen>, or family <fam>Lampyrid<ae/</fam>. See <er>Lampyris</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lampyris</ent><br/
\'d8<hw>Lam*py"ris</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., glowworm, Gr. (<?/).]</ety> <fld>(Zool.)</fld> <def>A genus of coleopterous insects, including the glowworms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>LAN</ent><br/
<hw>LAN</hw> <pos>n.</pos> <ety>[<ets>L</ets>ocal <ets>A</ets>rea <ets>N</ets>etwork.]</ety> <def>A <altname>local area network</altname>; a network{3} connecting computers and word processors and other electronic office equipment within a small area, to create an inter-office system, typically within one building or one site of a corporation.  Contrasted to <contr>WAN</contr>, a wide-area network.</def><br/
<syn><b>Syn. --</b> local area network.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lanai</ent><br/
<hw>Lanai</hw> <pos>n.</pos> <sn>1.</sn> <mark>(upper case)</mark> <def>an island in the Hawaiian chain.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <mark>(lower case)</mark> <def>a veranda or roofed patio often furnished and used as a living room.</def> <mark>[Hawaii]</mark> <br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lanarkite</ent><br/
<hw>Lan"ark*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <etsep>Lanark</etsep>shire, a county in Scotland.]</ety> <fld>(Min.)</fld> <def>A mineral consisting of sulphate of lead, occurring either massive or in long slender prisms, of a greenish white or gray color.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanary</ent><br/
<hw>La"na*ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lanaria</ets>, fr. <ets>lanarius</ets> belonging to wool, <ets>lana</ets> wool.]</ety> <def>A place for storing wool.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanated</ent><br/
<ent>Lanate</ent><br/
<mhw>{ <hw>La"nate</hw> <pr>(?)</pr>, <hw>La"na*ted</hw> <pr>(?)</pr>, }</mhw> <ety>[L. <ets>lanatus</ets>, fr. <ets>lana</ets> wool, down.]</ety> <sn>1.</sn> <def>Wooly; covered with fine long hair, or hairlike filaments.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>Hence:</specif> <fld>(Biol.)</fld> <def>covered with dense often matted or curly hairs.</def><br/
<syn><b>Syn. --</b> wooly, woolly.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lancashire boiler</ent><br/
<hw>Lan"ca*shire boil"er</hw> <pr>(?)</pr> <pos>n.</pos> <def>A steam boiler having two flues which contain the furnaces and extend through the boiler from end to end.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancaster</ent><br/
<hw>Lancaster</hw> <pos>prop. n.</pos> <sn>1.</sn> <def>A city in Northwest England on the river Lune.</def> <wns>[wns=1]</wns><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>The English royal house that reigned from 1399 to 1461; its symbol was a red rose; called also the <altname>House of Lancaster</altname>.</def> <wns>[wns=2]</wns><br/
<syn><b>Syn. --</b> Lancastrian line.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lancasterian</ent><br/
<hw>Lan`cas*te"ri*an</hw> <pr>(?)</pr>, <pos>prop. a.</pos> <def>Of or pertaining to the monitorial system of instruction followed by <person>Joseph <etsep>Lancaster</etsep></person>, of England, in which advanced pupils in a school teach pupils below them.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancastrian</ent><br/
<hw>Lancastrian</hw> <pos>prop. a.</pos> <sn>1.</sn> <def>Of or pertaining to Lancaster{2}; <as>as, <ex>Lancastrian</ex> royalty</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to the city of Lancaster{1}; <as>as, <ex>Lancastrian</ex> city center</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>Of or pertaining to the members of the house of Lancaster; <as>as, <ex>Lancastrian</ex> members</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>4.</sn> <def>Of or pertaining to the inhabitants of Lancaster; <as>as, the <ex>Lancastrian</ex> population</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lancastrian</ent><br/
<hw>Lancastrian</hw> <pos>prop. n.</pos> <sn>1.</sn> <def>A member (or supporter) of the house of Lancaster.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A resident of Lancaster{1}.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lance</ent><br/
<hw>Lance</hw> <pr>(l<acr/ns)</pr>, <pos>n.</pos> <ety>[OE. <ets>lance</ets>, F. <ets>lance</ets>, <ets>fr</ets>. L. <ets>lancea</ets>; cf. Gr. <grk>lo`gchh</grk>.  Cf. <er>Launch</er>.]</ety> <sn>1.</sn> <def>A weapon of war, consisting of a long shaft or handle and a steel blade or head; a spear carried by horsemen, and often decorated with a small flag; also, a spear or harpoon used by whalers and fishermen.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A braver soldier never couched <qex>lance</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A soldier armed with a lance; a lancer.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Founding)</fld> <def>A small iron rod which suspends the core of the mold in casting a shell.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mil.)</fld> <def>An instrument which conveys the charge of a piece of ordnance and forces it home.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Pyrotech.)</fld> <def>One of the small paper cases filled with combustible composition, which mark the outlines of a figure.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Med.)</fld> <def>A lancet.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Free lance</b></col>, <cd>in the Middle Ages, and subsequently, a knight or roving soldier, who was free to engage for any state or commander that purchased his services; hence, a person who assails institutions or opinions on his own responsibility without regard to party lines or deference to authority.  See also <er>freelance</er>, <pos>n.</pos> and <pos>a.</pos>, and <er>freelancer</er>.</cd> -- <col><b>Lance bucket</b></col> <fld>(Cavalry)</fld>, <cd>a socket attached to a saddle or stirrup strap, in which to rest the but of a lance.</cd> -- <col><b>Lance corporal</b></col>, <cd>same as <er>Lancepesade</er>.</cd> -- <col><b>Lance knight</b></col>, <cd>a lansquenet.</cd> <au>B. Jonson.</au> -- <col><b>Lance snake</b></col> <fld>(Zool.)</fld>, <cd>the fer-de-lance.</cd> -- <col><b>Stink-fire lance</b></col> <fld>(Mil.)</fld>, <cd>a kind of fuse filled with a composition which burns with a suffocating odor; -- used in the counter operations of miners.</cd> -- <col><b>To break a lance</b></col>, <cd>to engage in a tilt or contest.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lance</ent><br/
<hw>Lance</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lanced</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lancing</conjf> <pr>(?)</pr>.]</vmorph> <sn>1.</sn> <def>To pierce with a lance, or with any similar weapon.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Seized the due victim, and with fury <qex>lanced</qex><br/
Her back.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To open with a lancet; to pierce; <as>as, to <ex>lance</ex> a vein or an abscess</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To throw in the manner of a lance. See <er>Lanch</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lance corporal</ent><br/
<hw>lance" cor`por*al</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A <er>lancepesade</er>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>An enlisted member of the United States Marine Corps ranking between a private first class and a corporal.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>The lowest rank of corporal; -- a term used in the British military.</def> <au>RHUD</au><br/
[<source>PJC</source>]</p>

<p><ent>Lance fish</ent><br/
<hw>Lance" fish`</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Zool.)</fld> <def>A slender marine fish of the genus <gen>Ammodytes</gen>, especially <spn>Ammodytes tobianus</spn> of the English coast; -- called also <altname>sand lance</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancegaye</ent><br/
<ent>Lancegay</ent><br/
<mhw>{ <hw>Lance"gay`</hw>, <hw>Lance"gaye`</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>lancegaie</ets>, corrupted from the same source as E. <ets>assagai</ets>, under the influence of F. <ets>lance</ets> lance. See <er>Assagai</er>.]</ety> <def>A kind of spear anciently used. Its use was prohibited by a statute of Richard II.</def>  <rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In his hand a <qex>launcegay</qex>,<br/
A long sword by his side.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancelet</ent><br/
<hw>Lance"let</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lance</ets> + <ets>-let</ets>.]</ety> <fld>(Zool.)</fld> <def>A small fishlike animal (<spn>Amphioxus lanceolatus</spn>), remarkable for the rudimentary condition of its organs. It is the type of the class <class>Leptocardia</class>. See <er>Amphioxus</er>, <er>Leptocardia</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancely</ent><br/
<hw>Lance"ly</hw>, <pos>a.</pos> <def>Like a lance.</def> <mark>[R.]</mark> <au>Sir P. Sidney.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanceolar</ent><br/
<hw>Lan"ce*o*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lanceola</ets> a little lance, dim. of <ets>lancea</ets> lance: cf. F. <ets>lanc<eacute/olaire</ets>.]</ety> <fld>(Bot.)</fld> <def>Lanceolate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanceolated</ent><br/
<ent>Lanceolate</ent><br/
<mhw>{ <hw>Lan"ce*o*late</hw> <pr>(?)</pr>, <hw>Lan"ce*o*la`ted</hw> <pr>(?)</pr> }</mhw> <pos>a.</pos> <ety>[L. <ets>lanceolatus</ets>: cf. F. <ets>lanc<eacute/ol<eacute/</ets>. See <er>Lanceolar</er>.]</ety> <fld>(Bot. & Zool.)</fld> <def>Rather narrow, tapering to a point at the apex, and sometimes at the base also; <as>as, a <ex>lanceolate</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancepesade</ent><br/
<hw>Lance`pe*sade"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lancepessade</ets>, <ets>lanspessade</ets>, <ets>anspessade</ets>, It. <ets>lancia spezzata</ets> a broken lance or demilance, a demilance roan, a light horseman, bodyguard.]</ety> <def>An assistant to a corporal; a private performing the duties of a corporal; -- called also <altname>lance corporal</altname>.</def> <mark>[Obsolete]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancer</ent><br/
<hw>Lan"cer</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lancier</ets>.]</ety> <sn>1.</sn> <def>One who lances; one who carries a lance; especially, a member of a mounted body of men armed with lances, attached to the cavalry service of some nations.</def>  <rj><au>Wilhelm.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A lancet.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <fld>(Dancing)</fld> <def>A set of quadrilles of a certain arrangement.</def> <altsp>[Written also <asp>lanciers</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>lancers</ent><br/
<hw>lancers</hw> <pos>n.</pos> <sn>1.</sn> <def>A set of quadrilles for 8 or 16 couples.</def> <wns>[wns=1]</wns>  <altsp>[Written also <asp>lanciers</asp>.]</altsp><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>Music appropriate for a set of lancers{1}.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lancet</ent><br/
<hw>Lan"cet</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lancette</ets>, dim. of <ets>lance</ets> lance. See <er>Lance</er>.]</ety> <sn>1.</sn> <def>A surgical knife-like instrument of various forms, commonly sharp-pointed and two-edged, used in venesection, and in opening abscesses, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Metal.)</fld> <def>An iron bar used for tapping a melting furnace.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lancet arch</b></col> <fld>(Arch.)</fld>, <cd>a pointed arch, of which the width, or span, is narrow compared with the height.</cd> -- <col><b>Lancet architecture</b></col>, <cd>a name given to a style of architecture, in which lancet arches are common; -- peculiar to England and 13th century.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>lancet fish</ent><br/
<ent>lancetfish</ent><br/
<mhw><hw>lan"cet*fish`</hw>, <hw>lan"cet fish`</hw></mhw> <pos>n.</pos> <fld>(Zool.)</fld> <def>A large, elongated, scaleless, voracious, deep-sea fish (<spn>Alepidosaurus ferox</spn>), having long, sharp, lancetlike teeth and a long saillike dorsal fin.</def> <wns>[wns=1]</wns><br/
<syn><b>Syn. --</b> lancet fish, wolffish.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>The doctor, or surgeon fish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancewood</ent><br/
<hw>Lance"wood`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A tough, elastic wood, often used for the shafts of gigs, archery bows, fishing rods, and the like.  Also, the tree which produces this wood, <spn>Duguetia Quitarensis</spn> (a native of Guiana and Cuba), and several other trees of the same family (<fam>Anonase<ae/</fam>).</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Australian lancewood</b></col>, <cd>a myrtaceous tree (<spn>Backhousia Australis</spn>).</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanch</ent><br/
<hw>Lanch</hw> <pr>(l<adot/nch)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lanched</conjf> <pr>(l<adot/ncht)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lanching</conjf>. See <er>Launch</er>, <er>Lance</er>.]</vmorph> <def>To throw, as a lance; to let fly; to launch.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>See Whose arm can <qex>lanch</qex> the surer bolt.</q> <rj><qau>Dryden & Lee.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanciferous</ent><br/
<hw>Lan*cif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lance</ets> + <ets>-ferous</ets>.]</ety> <def>Bearing a lance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanciform</ent><br/
<hw>Lan"ci*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Lance</ets> + <ets>-form</ets>: cf. F. <ets>lanciforme</ets>.]</ety> <def>Having the form of a lance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancinate</ent><br/
<hw>Lan"ci*nate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lancinated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lancinating</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>lancinatus</ets>, p. p. of <ets>lancinare</ets> to fear.]</ety> <def>To tear; to lacerate; to pierce or stab.</def>  <rj><au>De Quincey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancinating</ent><br/
<hw>Lan"ci*na`ting</hw>, <pos>a.</pos> <def>Piercing; seeming to pierce or stab; <as>as, <ex>lancinating</ex> pains (i.e., severe, darting pains)</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lancination</ent><br/
<hw>Lan`ci*na"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tearing; laceration.</def> <ldquo/<xex>Lancinations</xex> of the spirit.<rdquo/  <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Land</ent><br/
<hw>Land</hw> <pr>(l<acr/nd)</pr>, <pos>n.</pos> <def>Urine. See <er>Lant</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Land</ent><br/
<hw>Land</hw>, <pos>n.</pos> <ety>[AS. <ets>land</ets>, <ets>lond</ets>; akin to D., G., Icel., Sw., Dan., and Goth. <ets>land</ets>. ]</ety> <sn>1.</sn> <def>The solid part of the surface of the earth; -- opposed to water as constituting a part of such surface, especially to oceans and seas; <as>as, to sight <ex>land</ex> after a long voyage</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They turn their heads to sea, their sterns to <qex>land</qex>.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any portion, large or small, of the surface of the earth, considered by itself, or as belonging to an individual or a people, as a country, estate, farm, or tract.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Go view the <qex>land</qex>, even Jericho.</q> <rj><qau>Josh. ii. 1.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ill fares the <qex>land</qex>, to hastening ills a prey,<br/
Where wealth accumulates and men decay.</q> <rj><qau>Goldsmith.</qau></rj>
<-- See also, Goldsmith:
Where wealth and freedom reign contentment fails,
And honor sinks where commerce long prevails.
(THe captivity, an Oratorio.  Act II line 91) --><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the expressions <ldquo/to be, or dwell, upon <xex>land</xex>,<rdquo/ <ldquo/<xex>to go</xex>, <xex>or fare</xex>, on <xex>land</xex>,<rdquo/ as used by Chaucer, <xex>land</xex> denotes the country as distinguished from the town.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>A poor parson dwelling upon <qex>land</qex> [i.e., in the country].</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Ground, in respect to its nature or quality; soil; <as>as, wet <ex>land</ex>; good or bad <ex>land</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The inhabitants of a nation or people.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These answers, in the silent night received,<br/
The king himself divulged, the <qex>land</qex> believed.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The mainland, in distinction from islands.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>The ground or floor.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Herself upon the <qex>land</qex> she did prostrate.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Agric.)</fld> <def>The ground left unplowed between furrows; any one of several portions into which a field is divided for convenience in plowing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Law)</fld> <def>Any ground, soil, or earth whatsoever, as meadows, pastures, woods, etc., and everything annexed to it, whether by nature, as trees, water, etc., or by the hand of man, as buildings, fences, etc.; real estate.</def>  <rj><au>Kent. Bouvier. Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Naut.)</fld> <def>The lap of the strakes in a clinker-built boat; the lap of plates in an iron vessel; -- called also <altname>landing</altname>.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>In any surface prepared with indentations, perforations, or grooves, that part of the surface which is not so treated, as the level part of a millstone between the furrows, or the surface of the bore of a rifled gun between the grooves.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Land agent</b></col>, <cd>a person employed to sell or let land, to collect rents, and to attend to other money matters connected with land.</cd> -- <col><b>Land boat</b></col>, <cd>a vehicle on wheels propelled by sails.</cd> -- <col><b>Land blink</b></col>, <cd>a peculiar atmospheric brightness seen from sea over distant snow-covered land in arctic regions. See <er>Ice blink</er>.</cd> -- <col><b>Land breeze</b></col>. <cd>See under <er>Breeze</er>.</cd> -- <col><b>Land chain</b></col>. <cd>See <er>Gunter's chain</er>.</cd> -- <col><b>Land crab</b></col> <fld>(Zool.)</fld>, <cd>any one of various species of crabs which live much on the land, and resort to the water chiefly for the purpose of breeding. They are abundant in the West Indies and South America. Some of them grow to a large size.</cd> -- <col><b>Land fish</b></col> <cd>a fish on land; a person quite out of place.</cd> <au>Shak.</au> -- <col><b>Land force</b></col>, <cd>a military force serving on land, as distinguished from a naval force.</cd> -- <col><b>Land, ho!</b></col> <fld>(Naut.)</fld>, <cd>a sailor's cry in announcing sight of land.</cd> -- <col><b>Land ice</b></col>, <cd>a field of ice adhering to the coast, in distinction from a floe.</cd> -- <col><b>Land leech</b></col> <fld>(Zool.)</fld>, <cd>any one of several species of blood-sucking leeches, which, in moist, tropical regions, live on land, and are often troublesome to man and beast.</cd> -- <col><b>Land measure</b></col>, <cd>the system of measurement used in determining the area of land; also, a table of areas used in such measurement.</cd> -- <mcol><col><b>Land of bondage</b></col> <it>or</it> <col><b>House of bondage</b></col></mcol>, <cd>in Bible history, Egypt; by extension, a place or condition of special oppression.</cd> -- <col><b>Land o' cakes</b></col>, <cd>Scotland.</cd> -- <col><b>Land of Nod</b></col>, <cd>sleep.</cd> -- <col><b>Land of promise</b></col>, <cd>in Bible history, Canaan: by extension, a better country or condition of which one has expectation.</cd> -- <col><b>Land of steady habits</b></col>, <cd>a nickname sometimes given to the State of Connecticut.</cd> -- <col><b>Land office</b></col>, <cd>a government office in which the entries upon, and sales of, public land are registered, and other business respecting the public lands is transacted.</cd> <mark>[U.S.]</mark> -- <col><b>Land pike</b></col>. <fld>(Zool.)</fld> <sd>(a)</sd> <cd>The gray pike, or sauger.</cd> <sd>(b)</sd> <cd>The Menobranchus.</cd> -- <col><b>Land service</b></col>, <cd>military service as distinguished from naval service.</cd> -- <col><b>Land rail</b></col>. <fld>(Zool)</fld> <sd>(a)</sd> <cd>The crake or corncrake of Europe.</cd> See <er>Crake</er>. <sd>(b)</sd> <cd>An Australian rail (<spn>Hypot<ae/nidia Phillipensis</spn>); -- called also <altname>pectoral rail</altname>.</cd> -- <col><b>Land scrip</b></col>, <cd>a certificate that the purchase money for a certain portion of the public land has been paid to the officer entitled to receive it.</cd> <mark>[U.S.]</mark> -- <col><b>Land shark</b></col>, <cd>a swindler of sailors on shore.</cd> <mark>[Sailors' Cant]</mark> -- <col><b>Land side</b></col> <sd>(a)</sd> <cd>That side of anything in or on the sea, as of an island or ship, which is turned toward the land.</cd> <sd>(b)</sd> <cd>The side of a plow which is opposite to the moldboard and which presses against the unplowed land.</cd> -- <col><b>Land snail</b></col> <fld>(Zool.)</fld>, <cd>any snail which lives on land, as distinguished from the aquatic snails are Pulmonifera, and belong to the Geophila; but the operculated land snails of warm countries are Di<oe/cia, and belong to the T<ae/nioglossa. See <er>Geophila</er>, and <er>Helix</er>.</cd> -- <col><b>Land spout</b></col>, <cd>a descent of cloud and water in a conical form during the occurrence of a tornado and heavy rainfall on land.</cd> -- <col><b>Land steward</b></col>, <cd>a person who acts for another in the management of land, collection of rents, etc.</cd> -- <mcol><col><b>Land tortoise</b></col>, <col><b>Land turtle</b></col></mcol> <fld>(Zool.)</fld>, <cd>any tortoise that habitually lives on dry land, as the box tortoise. See <er>Tortoise</er>.</cd> -- <col><b>Land warrant</b></col>, <cd>a certificate from the Land Office, authorizing a person to assume ownership of a public land.</cd> <mark>[U.S.]</mark> -- <col><b>Land wind</b></col>. <cd>Same as <cref>Land breeze</cref> (above).</cd> -- <col><b>To make land</b></col> <fld>(Naut.)</fld>, <cd>to sight land.</cd> <col><b>To set the land</b></col>, <cd>to see by the compass how the land bears from the ship.</cd> -- <col><b>To shut in the land</b></col>, <cd>to hide the land, as when fog, or an intervening island, obstructs the view.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Land</ent><br/
<hw>Land</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Landed</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Landing</conjf>.]</vmorph> <sn>1.</sn> <def>To set or put on shore from a ship or other water craft; to disembark; to debark.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I 'll undertake to <qex>land</qex> them on our coast.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To catch and bring to shore; to capture; <as>as, to <ex>land</ex> a fish</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To set down after conveying; to cause to fall, alight, or reach; to bring to the end of a course; <as>as, he <ex>landed</ex> the quoit near the stake; to be thrown from a horse and <ex>landed</ex> in the mud; to <ex>land</ex> one in difficulties or mistakes.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <specif>Specifically:</specif> <fld>(Aeronautics)</fld> <def>To pilot (an airplane) from the air onto the land; <as>as, to <ex>land</ex> the plane on a highway</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Land</ent><br/
<hw>Land</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To come to the end of a course; to arrive at a destination, literally or figuratively; <as>as, he <ex>landed</ex> in trouble; after hithchiking for a week, he <ex>landed</ex> in Los Angeles</as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <specif>Specifically:</specif> <def>To go on shore from a ship or boat; to disembark.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <specif>Specifically:</specif> <def>To reach and come to rest on land after having been in the air; <as>as, the arrow <ex>landed</ex> in a flower bed; the golf ball <ex>landed</ex> in a sand trap; our airplane <ex>landed</ex> in Washington</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Landamman</ent><br/
<hw>Lan"dam*man</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G. <ets>Landamman</ets>; <ets>land</ets> land, country + <ets>amimann</ets> bailiff. See <er>Land</er>, and <er>Ambassador</er>.]</ety> <sn>1.</sn> <def>A chief magistrate in some of the Swiss cantons.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The president of the diet of the Helvetic republic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landau</ent><br/
<hw>Lan"dau</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the town <etsep>Ladau</etsep> in Germany; cf. F. <ets>landau</ets>. See <er>Land</er>, <er>Island</er>.]</ety> <def>A four-wheeled covered vehicle, the top of which is divided into two sections which can be let down, or thrown back, in such a manner as to make an open carriage.</def> <altsp>[Written also <asp>landaw</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landaulet</ent><br/
<hw>Lan`dau*let"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>landaulet</ets>, dim, of <ets>landau</ets>. See <er>Landau</er>.]</ety> <def>A small landau.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landtrost</ent><br/
<ent>Landdrost</ent><br/
<mhw>\'d8<hw>Land"drost`</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl. <plw>-drosten</plw>  <pr>(#)</pr></plu>. Sometimes incorrectly <hw>Landtrost</hw></mhw>. <ety>[D., fr. <ets>land</ets> land + <ets>drost</ets> a kind of official; akin to G. <ets>truchsess</ets>.]</ety> <mark>(In South Africa)</mark> <sd>(a)</sd> <def>A chief magistrate in rural districts. He was replaced in 1827 by <ldquo/resident magistrates.<rdquo/</def> <sd>(b)</sd> <def>The president of the Heemraad.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Landed</ent><br/
<hw>Land"ed</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having an estate in land.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The House of Commons must consist, for the most part, of <qex>landed</qex> men.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Consisting in real estate or land; <as>as, <ex>landed</ex> property; <ex>landed</ex> security.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lander</ent><br/
<hw>Land"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who lands, or makes a landing.</def> <ldquo/The <xex>lander</xex> in a lonely isle.<rdquo/  <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mining)</fld> <def>A person who waits at the mouth of the shaft to receive the kibble of ore.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landfall</ent><br/
<hw>Land"fall</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A sudden transference of property in land by the death of its owner.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>Sighting or making land when at sea.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>A good landfall</b></col> <fld>(Naut.)</fld>, <cd>the sighting of land in conformity with the navigator's reckoning and expectation.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landflood</ent><br/
<hw>Land"flood`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An overflowing of land by river; an inundation; a freshet.</def>  <rj><au>Clarendon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landgrave</ent><br/
<hw>Land"grave`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G. <ets>landgraf</ets>; <ets>land</ets> land + <ets>graf</ets> earl, count; cf. D. <ets>landgraaf</ets>, F. <ets>landgrave</ets>.]</ety> <def>A German nobleman of a rank corresponding to that of an earl in England and of a count in France.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The title was first adopted by some German counts in the twelfth century, to distinguish themselves from the inferior counts under their jurisdiction. Three of them were princes of the empire.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landgraviate</ent><br/
<hw>Land*gra"vi*ate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>landgraviat</ets>.]</ety> <sn>1.</sn> <def>The territory held by a landgrave.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The office, jurisdiction, or authority of a landgrave.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landgravine</ent><br/
<hw>Land"gra*vine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G. <ets>landgr<aum/fin</ets>; cf. D. <ets>landgravin</ets>.]</ety> <def>The wife of a landgrave.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landholder</ent><br/
<hw>Land"hold`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A holder, owner, or proprietor of land.</def> -- <wordforms><wf>Land"hold`ing</wf>, <pos>n. & a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>landholding</ent><br/
<hw>landholding</hw> <pos>n.</pos> <sn>1.</sn> <def>ownership of land; the state or fact of owning land.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A holding in the form of land; the land owned by a person.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Landing</ent><br/
<hw>Land"ing</hw>, <pos>a.</pos> <def>Of, pertaining to, or used for, setting, bringing, or going, on shore.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Landing charges</b></col>, <cd>charges or fees paid on goods unloaded from a vessel.</cd> -- <col><b>Landing net</b></col>, <cd>a small, bag-shaped net, used in fishing to take the fish from the water after being hooked.</cd> -- <col><b>Landing stage</b></col>, <cd>a floating platform attached at one end to a wharf in such a manner as to rise and fall with the tide, and thus facilitate passage between the wharf and a vessel lying beside the stage.</cd> -- <col><b>Landing waiter</b></col>, <cd>a customhouse officer who oversees the landing of goods, etc., from vessels; a landwaiter.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landing</ent><br/
<hw>Land"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>A going or bringing on shore.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A place for landing, as from a ship, a carriage. etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Arch.)</fld> <def>The level part of a staircase, at the top of a flight of stairs, or connecting one flight with another.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Aeronautics)</fld> <def>The act or process of bringing an aircraft to land after having been in the air; <as>as, the pilot made a perfect three-point <ex>landing</ex></as>.  Contrasted with <contr>take-off</contr>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Landing place</b></col>. <cd>me as <er>Landing</er>, <pos>n.</pos>, 2 and 3.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>landing gear</ent><br/
<hw>land"ing gear`</hw>, <pos>n.</pos> <def>The wheels and attached structures under an airplane that support it and allow it to move when on the ground; also, the floats or pontoons of an amphibious airplane together with their supporting structures.  Landing gear may be fixed rigidly in place, or retractable when in flight.</def><br/
[<source>PJC</source>]</p>

<p><ent>landing strip</ent><br/
<hw>land"ing strip`</hw>, <pos>n.</pos> <fld>(Aeronautics)</fld> <def>A runway at an airport, at which airplanes land{3}; the long smooth surface used for takeoff or landing{4}.</def><br/
[<source>PJC</source>]</p>

<p><ent>landlady</ent><br/
<hw>land"la`dy</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>landladies</plw> <pr>(#)</pr>.</plu> <ety>[Cf. <er>landlord</er>.]</ety> <sn>1.</sn> <def>A woman having real estate which she leases to a tenant or tenants.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The mistress of an inn or lodging house.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 828 --></p>

<p><ent>Land League</ent><br/
<hw>Land League</hw> <pos>n.</pos> <def>In Ireland, a combination of tenant farmers and other, organized, with <person>Charles Stewart Parnell</person> as president, in 1879 with a view to the reduction of farm rents and a reconstruction of the land laws.</def> -- <wordforms><wf>Land"*lea`guer</wf> <pr>(#)</pr>, <pos>n.</pos> -- <wf>Land"*lea`guism</wf> <pr>(#)</pr>, <pos>n.</pos></wordforms></p>

<p><q>The <qex>Land League</qex>, of which <person>Michael Davitt</person> was the founder, originated in Mayo in August, and at a Dublin in October the organization was extended to all Ireland, with <persfn>Parnell</persfn> as president.</q>  <rj><qau>Encyc. Brit.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Landleaper</ent><br/
<hw>Land"leap`er</hw> <pr>(l<acr/nd"l<emac/p`<etil/r)</pr>, <pos>n.</pos> <def>See <er>Landlouper</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landless</ent><br/
<hw>Land"less</hw> <pr>(l<acr/nd"l<ecr/s)</pr>, <pos>a.</pos> <def>Having no property in land.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landlock</ent><br/
<hw>Land"lock`</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To inclose, or nearly inclose, as a harbor or a vessel, with land.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landlocked</ent><br/
<hw>Land"locked`</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Inclosed, or nearly inclosed, by land; having no border on the sea; <as>as, a <ex>landlocked</ex> country</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Confined to a fresh-water lake by reason of waterfalls or dams; -- said of fishes that would naturally seek the sea, after spawning; <as>as, the <ex>landlocked</ex> salmon</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landloper</ent><br/
<hw>Land"lo`per</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Landlouper</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landlord</ent><br/
<hw>Land"lord`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Land</er>, and <er>Lord</er>.]</ety> <sn>1.</sn> <def>The lord of a manor, or of land; the owner of land or houses which he leases to a tenant or tenants.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The master of an inn or of any form of lodging house; <as>as, the <ex>landlord</ex> collects the rents on the first of the month</as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>Upon our arrival at the inn, my companion fetched out the jolly <qex>landlord</qex>.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landlordism</ent><br/
<hw>Land"lord`ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state of being a landlord; the characteristics of a landlord; specifically, in Great Britain, the relation of landlords to tenants, especially as regards leased agricultural lands.</def>  <rj><au>J. S. Mill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landlordry</ent><br/
<hw>Land"lord`ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state of a landlord.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landlouper</ent><br/
<hw>Land"loup`er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[D. <ets>landlooper</ets>, lit., <ets>landrunner</ets>; <ets>land</ets> land + <ets>loopen</ets> to run. See <er>Land</er>, and <er>Leap</er>.]</ety> <def>A vagabond; a vagrant.</def> <altsp>[Written also <asp>landleaper</asp> and <asp>landloper</asp>.]</altsp> <ldquo/Bands of <xex>landloupers</xex>.<rdquo/  <rj><au>Moltey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landlouping</ent><br/
<hw>Land"loup`ing</hw>, <pos>a.</pos> <def>Vagrant; wandering about.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landlubber</ent><br/
<hw>Land"lub`ber</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Prop. fr. <ets>land</ets> + <ets>lubber</ets>, or possibly corrupted fr. <ets>laudlouper</ets>.]</ety> <fld>(Naut.)</fld> <def>One who passes his life on land; -- so called among seamen in contempt or ridicule.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>landlubberly</ent><br/
<hw>landlubberly</hw> <pos>adj.</pos>  <def>Like a landlubber: inexperienced in seamanshap.</def><br/
<syn><b>Syn. --</b> lubberly.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Landman</ent><br/
<hw>Land"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Landmen</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <def>A man who lives or serves on land; -- opposed to <contr>seaman</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eng.)</fld> <def>An occupier of land.</def>  <rj><au>Cowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landmark</ent><br/
<hw>Land"mark`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>landmearc</ets>. See <er>Land</er>, and <er>Mark</er> a sign.]</ety> <sn>1.</sn> <def>A mark to designate the boundary of land; any mark or fixed object (as a marked tree, a stone, a ditch, or a heap of stones) by which the limits of a farm, a town, or other portion of territory may be known and preserved.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any conspicuous object on land that serves as a guide; some prominent object, as a hill or steeple.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A structure that has special significance, such as a building with historical associations;</def> <specif>especially,</specif> <def>a building that is protected from destruction or alteration by special laws intended to preserve structures of historical significance; <as>as, a <ex>landmark</ex> preservation law</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>An event or accomplishment of great significance; <as>as, Brown v. Board of Education was a <ex>landmark</ex> of the civil rights movement</as>.  Also used attributively, as a <ex>landmark</ex> court decision.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Landmarks of history</b></col>, <cd>important events by which eras or conditions are determined.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>landmass</ent><br/
<hw>landmass</hw> <pos>n.</pos> <def>a large continuous extent of land; <as>as, the Eurasian <ex>landmass</ex></as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Land of Steady Habits</ent><br/
<hw>Land of Steady Habits</hw> <pos>prop. n.</pos> <def>Connecticut; -- a nickname alluding to the moral character of its inhabitants, implied by the rigid laws (see <er>Blue laws</er>) of the early period.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Landowner</ent><br/
<hw>Land"own`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An owner of land.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landowning</ent><br/
<hw>Land"own`ing</hw>, <pos>n.</pos> <def>The owning of land.</def> -- <def2><pos>a.</pos> <def>Having property in land; of or pertaining to landowners.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Land-poor</ent><br/
<hw>Land"-poor`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pecuniarily embarrassed through owning much unprofitable land.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landreeve</ent><br/
<hw>Land"reeve`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Land</ets> + <ets>reeve</ets> an officer.]</ety> <def>A subordinate officer on an extensive estate, who acts as an assistant to the steward.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landscape</ent><br/
<hw>Land"scape</hw> <pr>(?)</pr>, <pos>n.</pos> <altsp>[Formerly written also <asp>landskip</asp>.]</altsp> <ety>[D. <ets>landschap</ets>; <ets>land</ets> land + <ets>-schap</ets>, equiv. to E. <ets>-schip</ets>; akin to G. <ets>landschaft</ets>, Sw. <ets>landskap</ets>, Dan. <ets>landskab</ets>. See <er>Land</er>, <er>and</er> <er>-schip</er>.]</ety> <sn>1.</sn> <def>A portion of land or territory which the eye can comprehend in a single view, including all the objects it contains.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A picture representing a scene by land or sea, actual or fancied, the chief subject being the general aspect of nature, as fields, hills, forests, water. etc.  Compare <contr>seascape</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The pictorial aspect of a country.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>landscape</qex> of his native country had taken hold on his heart.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Landscape gardening</b></col>, <cd>The art of laying out grounds and arranging trees, shrubbery, etc., in such a manner as to produce a picturesque effect.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>landscaping</ent><br/
<hw>landscaping</hw> <pos>n.</pos> <def>Working as a landscape gardner.</def><br/
<syn><b>Syn. --</b> landscape gardening.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Landscapist</ent><br/
<hw>Land"scap`ist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A painter of landscapes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landskip</ent><br/
<hw>Land"skip</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Landscape</er>.]</ety> <def>A landscape.</def> <mark>[Obs. except in poetry.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Straight my eye hath caught new pleasures,<br/
Whilst the <qex>landskip</qex> round it measures.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landslip</ent><br/
<ent>Landslide</ent><br/
<mhw>{ <hw>Land"slide`</hw> <pr>(?)</pr>, <hw>Land"slip`</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <sn>1.</sn> <def>The slipping down of a mass of land from a mountain, hill, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The land which slips down.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An election victory in which the winning candidate receives a substantial majority of the votes, usually meaning at least ten per cent more than any opposing candidate.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>Any overwhelming victory.</def><br/
[<source>PJC</source>]</p>

<p><ent>Landsman</ent><br/
<hw>Lands"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Landsmen</plw> <pr>(#)</pr>.</plu> <sn>1.</sn> <def>One who lives on the land; -- opposed to <contr>seaman</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>A sailor on his first voyage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landsthing</ent><br/
\'d8<hw>Lands"thing`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Dan. <ets>landsthing</ets>, <ets>landsting</ets>, fr. <ets>land</ets> land + <ets>thing</ets>, <ets>ting</ets>, parliament. See <er>Land</er>; <er>Thing</er>.]</ety> <fld>(Denmark.)</fld> <def>See <er>Legislature</er>, below.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Landstorm</ent><br/
\'d8<hw>Land"storm`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sw.]</ety> <def>See <er>Varnpligtige</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Landstreight</ent><br/
<hw>Land"streight`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Strait</er>.]</ety> <def>A narrow strip of land.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landsturm</ent><br/
\'d8<hw>Land"sturm`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G. See <er>Land</er>; <er>Storm</er>.]</ety> <mark>[In Germany and other European nations, and Japan:]</mark> <sd>(a)</sd> <def>A general levy in time of war.</def> <sd>(b)</sd> <def>The forces called out on such levy, composed of all men liable to service who are not in the army, navy, or Landwehr; the last line of defense, supposed to be called out only in case of invasion or other grave emergency. See <er>Army organization</er>, above.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Landtag</ent><br/
\'d8<hw>Land"tag`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G. See <er>Land</er>; <er>Day</er>.]</ety> <fld>(Prussia.)</fld> <def>The diet or legislative body; <as>as, the <ex>Landtag</ex> of Prussia</as>.  See <er>Legislature</er>, below.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Landwaiter</ent><br/
<hw>Land"wait`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <cref>Landing waiter</cref>, under <er>Landing</er>, <pos>a.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landward</ent><br/
<hw>Land"ward</hw> <pr>(?)</pr>, <pos>adv. & a.</pos> <def>Toward the land.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Landwehr</ent><br/
\'d8<hw>Land"wehr`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G., fr. <ets>land</ets> land, country + <ets>wehr</ets> defense.]</ety> <def>That part of the army, in Germany and Austria, which has completed the usual military service and is exempt from duty in time of peace, except that it is called out occasionally for drill.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lane</ent><br/
<hw>Lane</hw> <pr>(l<amac/n)</pr>, <pos>a.</pos> <ety>[See <er>Lone</er>.]</ety> <def>Alone.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>His lane</b></col>, <cd>by himself; himself alone.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lane</ent><br/
<hw>Lane</hw> <pr>(l<amac/n)</pr>, <pos>n.</pos> <ety>[OE. <ets>lane</ets>, <ets>lone</ets>, AS. <ets>lone</ets>, <ets>lone</ets>; akin to D. <ets>laan</ets>, OFries. <ets>lana</ets>, <ets>lona</ets>.]</ety> <def>A passageway between fences or hedges which is not traveled as a highroad; an alley between buildings; a narrow way among trees, rocks, and other natural obstructions; hence, in a general sense, a narrow passageway; <as>as, a <ex>lane</ex> between lines of men, or through a field of ice</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It is become a turn-again <qex>lane</qex> unto them which they can not go through.</q> <rj><qau>Tyndale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lang</ent><br/
<hw>Lang</hw> <pr>(?)</pr>, <pos>a. & adv.</pos> <def>Long.</def> <mark>[Obs. or Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langaha</ent><br/
<hw>Lan"ga*ha</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A curious colubriform snake of the genus <gen>Xyphorhynchus</gen>, from Madagascar. It is brownish red, and its nose is prolonged in the form of a sharp blade.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langarey</ent><br/
<hw>Lan`ga*rey"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>One of numerous species of long-winged, shrikelike birds of Australia and the East Indies, of the genus <gen>Artamus</gen>, and allied genera; called also <altname>wood swallow</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langate</ent><br/
<hw>Lan"gate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Surg.)</fld> <def>A linen roller used in dressing wounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langdak</ent><br/
<hw>Lang"dak`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A wolf (<spn>Canis pallipes</spn>), found in India, allied to the jackal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langrel</ent><br/
<ent>Langrage</ent><br/
<mhw>{ <hw>Lan"grage</hw> <pr>(?)</pr>, <hw>Lan"grel</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <def>A kind of shot formerly used at sea for tearing sails and rigging. It consisted of bolts, nails, and other pieces of iron fastened together or inclosed in a canister.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langret</ent><br/
<hw>Lan"gret</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of loaded die.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langridge</ent><br/
<hw>Lan"gridge</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Langrage</er>.</def> <note>[Sometimes compounded with <xex>shot</xex>.]</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langsyne</ent><br/
<hw>Lang`syne"</hw> <pr>(?)</pr>, <pos>adv. & n.</pos> <ety>[Scot. <ets>lang</ets> long + <ets>syne</ets> since.]</ety> <def>Long since; long ago.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langteraloo</ent><br/
<hw>Lang`ter*a*loo"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Loo</er>.]</ety> <def>An old game at cards. See <er>Loo</er> <sd>(a)</sd>.</def>  <rj><au>Tatler.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Language</ent><br/
<hw>Lan"guage</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>langage</ets>, F. <ets>langage</ets>, fr. L. <ets>lingua</ets> the tongue, hence speech, language; akin to E. <ets>tongue</ets>. See <er>Tongue</er>, cf. <er>Lingual</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Any means of conveying or communicating ideas;</def> <specif>specifically,</specif> <def>human speech; the expression of ideas by the voice; sounds, expressive of thought, articulated by the organs of the throat and mouth.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Language</xex> consists in the oral utterance of sounds which usage has made the representatives of ideas.  When two or more persons customarily annex the same sounds to the same ideas, the expression of these sounds by one person communicates his ideas to another.  This is the primary sense of <xex>language</xex>, the use of which is to communicate the thoughts of one person to another through the organs of hearing.  Articulate sounds are represented to the eye by letters, marks, or characters, which form words.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The expression of ideas by writing, or any other instrumentality.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The forms of speech, or the methods of expressing ideas, peculiar to a particular nation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The characteristic mode of arranging words, peculiar to an individual speaker or writer; manner of expression; style.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Others for <qex>language</qex> all their care express.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The inarticulate sounds by which animals inferior to man express their feelings or their wants.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>The suggestion, by objects, actions, or conditions, of ideas associated therewith; <as>as, the <ex>language</ex> of flowers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There was . . . <qex>language</qex> in their very gesture.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>The vocabulary and phraseology belonging to an art or department of knowledge; <as>as, medical <ex>language</ex>; the <ex>language</ex> of chemistry or theology.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>A race, as distinguished by its speech.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>All the people, the nations, and the <qex>languages</qex>, fell down and worshiped the golden image.</q> <rj><qau>Dan. iii. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>Any system of symbols created for the purpose of communicating ideas, emotions, commands, etc., between sentient agents.</def><br/
[<source>PJC</source>]</p>

<p><sn>10.</sn> <specif>Specifically:</specif> <fld>(computers)</fld> <def>Any set of symbols and the rules for combining them which are used to specify to a computer the actions that it is to take; also referred to as a <altname>computer lanugage</altname> or <altname>programming language</altname>; <as>as, JAVA is a new and flexible high-level <ex>language</ex> which has achieved popularity very rapidly</as>.</def><br/
[<source>PJC</source>]</p>

<p><note><hand/  Computer <ex>languages</ex> are classed a low-level if each instruction specifies only one operation of the computer, or high-level if each instruction may specify a complex combination of operations.  <stype>Machine language</stype> and <stype>assembly language</stype> are low-level computer languages.  <stype>FORTRAN</stype>, <stype>COBOL</stype> and <stype>C</stype> are high-level computer languages.  Other computer languages, such as JAVA, allow even more complex combinations of low-level operations to be performed with a single command.  Many programs, such as databases, are supplied with special <ex>languages</ex> adapted to manipulate the objects of concern for that specific program.  These are also high-level languages.</note><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Language master</b></col>, <cd>a teacher of languages.</cd> <mark>[Obs.]</mark></cs></p>

<p><syn><b>Syn.</b> -- Speech; tongue; idiom; dialect; phraseology; diction; discourse; conversation; talk.</syn> <usage> -- <er>Language</er>, <er>Speech</er>, <er>Tongue</er>, <er>Idiom</er>, <er>Dialect</er>. <xex>Language</xex> is generic, denoting, in its most extended use, any mode of conveying ideas; <xex>speech</xex> is the language of articulate sounds; <xex>tongue</xex> is the Anglo-Saxon term for language, esp. for spoken language; as, the English <xex>tongue</xex>. <xex>Idiom</xex> denotes the forms of construction peculiar to a particular language; <xex>dialects</xex> are varieties of expression which spring up in different parts of a country among people speaking substantially the same <xex>language</xex>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Language</ent><br/
<hw>Lan"guage</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Languaged</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Languaging</conjf> <pr>(?)</pr>.]</vmorph> <def>To communicate by language; to express in language.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Others were <qex>languaged</qex> in such doubtful expressions that they have a double sense.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languaged</ent><br/
<hw>Lan"guaged</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a language; skilled in language; -- chiefly used in composition.</def> <ldquo/ Many-<xex>languaged</xex> nations.<rdquo/  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languageless</ent><br/
<hw>Lan"guage*less</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Lacking or wanting language; speechless; silent.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langued</ent><br/
<hw>Langued</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F. <ets>langue</ets> tongue. See <er>Language</er>.]</ety> <fld>(Her.)</fld> <def>Tongued; having the tongue visible.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Lions . . . represented as armed and <qex>langued</qex> gules.</q> <rj><qau>Cussans.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langue d'oc</ent><br/
\'d8<hw>Langue` d'oc"</hw> <pr>(?)</pr> <pos>n.</pos> <ety>[F., language of <ets>oc</ets> yes.]</ety> <def>The dialect, closely akin to French, formerly spoken south of the Loire (in which the word for <ldquo/yes<rdquo/ was <tr>oc</tr>); Proven<cced/al.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langue d'oil</ent><br/
\'d8<hw>Langue` d'o<ium/l"</hw> <pr>(?)</pr>. <ety>[F., language of <ets>o<ium/l</ets> yes.]</ety> <def>The dialect formerly spoken north of the Loire (in which the word for <ldquo/yes<rdquo/ was <tr>oil</tr>, F. <xex>oui</xex>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languente</ent><br/
\'d8<hw>Lan*guen"te</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[It., p. pr. of <ets>languire</ets>. See <er>Languish</er>.]</ety> <fld>(Mus.)</fld> <def>In a languishing manner; pathetically.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languet</ent><br/
<hw>Lan"guet</hw>, <pos>n.</pos> <ety>[F. <ets>languette</ets>, dim. of <ets>langue</ets> tongue, L. <ets>lingua</ets>.]</ety> <sn>1.</sn> <def>Anything resembling the tongue in form or office; specif., the slip of metal in an organ pipe which turns the current of air toward its mouth.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That part of the hilt, in certain kinds of swords, which overlaps the scabbard.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languid</ent><br/
<hw>Lan"guid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>languidus</ets>, fr. <ets>languere</ets> to be faint or languid: cf. F. <ets>languide</ets>. See <er>Languish</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Drooping or flagging from exhaustion; indisposed to exertion; without animation; weak; weary; heavy; dull.</def> <ldquo/ <xex>Languid</xex>, powerless limbs. <rdquo/  <rj><au>Armstrong.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Fire their <qex>languid</qex> souls with Cato's virtue.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Slow in progress; tardy.</def> <ldquo/ No motion so swift or <xex>languid</xex>.<rdquo/  <rj><au>Bentley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Promoting or indicating weakness or heaviness; <as>as, a <ex>languid</ex> day</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Feebly she laugheth in the <qex>languid</qex> moon.</q> <rj><qau>Keats.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Their idleness, aimless flirtations and <qex>languid</qex> airs.</q> <rj><qau>W. Black.</qau></rj></p>

<p><syn><b>Syn.</b> -- Feeble; weak; faint; sickly; pining; exhausted; weary; listless; heavy; dull; heartless.</syn></p>

<p>-- <wordforms><wf>Lan"guid*ly</wf>, <pos>adv.</pos> -- <wf>Lan"guid*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languish</ent><br/
<hw>Lan"guish</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Languished</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Languishing</conjf>.]</vmorph> <ety>[OE. <ets>languishen</ets>, <ets>languissen</ets>, F. <ets>languir</ets>, L. <ets>languere</ets>; cf. Gr. <?/ to slacken, <?/ slack, Icel. <ets>lakra</ets> to lag behind; prob. akin to E. <ets>lag</ets>, <ets>lax</ets>, and perh. to E. <ets>slack</ets>.  See <er>-ish</er>.]</ety> <sn>1.</sn> <def>To become languid or weak; to lose strength or animation; to be or become dull, feeble or spiritless; to pine away; to linger in a weak or deteriorating condition; to wither or fade.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We . . . do <qex>languish</qex> of such diseases.</q> <rj><qau>2 Esdras viii. 31.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Cease, fond nature, cease thy strife,<br/
And let me <qex>languish</qex> into life.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>For the fields of Heshbon <qex>languish</qex>.</q> <rj><qau>Is. xvi. 8. </qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To assume an expression of weariness or tender grief, appealing for sympathy.</def>  <rj><au>Tennyson.</au></rj></p>

<p><sn>3.</sn> <def>To be neglected and unattended to; <as>as, the proposal <ex>languished</ex> on the director's desk for months</as>.</def><br/
[<source>PJC</source>]</p>

<p><syn><b>Syn.</b> -- To pine; wither; fade; droop; faint.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languish</ent><br/
<hw>Lan"guish</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To cause to droop or pine.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au>  <au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languish</ent><br/
<hw>Lan"guish</hw>, <pos>n.</pos> <def>See <er>Languishment</er>.</def> <mark>[Obs. or Poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>What, of death, too,<br/
That rids our dogs of <qex>languish</qex>?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And the blue <qex>languish</qex> of soft Allia's eye.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languisher</ent><br/
<hw>Lan"guish*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who languishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languishing</ent><br/
<hw>Lan"guish*ing</hw>, <pos>a.</pos> <sn>1.</sn> <def>Becoming languid and weak; pining; losing health and strength.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Amorously pensive; indicating melancholy; <as>as, <ex>languishing</ex> eyes, or look</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Suffering neglect; neglected.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>Continuing in a weak or deteriorating state; lingering.</def><br/
[<source>PJC</source>]</p>

<p><ent>Languishingly</ent><br/
<hw>Lan"guish*ing*ly</hw>, <pos>adv.</pos> <def>In a languishing manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languishment</ent><br/
<hw>Lan"guish*ment</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The state of languishing.</def>  <ldquo/Lingering <xex>languishment</xex>.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Tenderness of look or mien; amorous pensiveness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languishness</ent><br/
<hw>Lan"guish*ness</hw>, <pos>n.</pos> <def>Languishment.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languor</ent><br/
<hw>Lan"guor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>langour</ets>, OF. <ets>langour</ets>, F. <ets>langueur</ets>, L. <ets>languor</ets>. See Languish.]</ety> <sn>1.</sn> <def>A state of the body or mind which is caused by exhaustion of strength and characterized by a languid feeling; feebleness; lassitude; laxity.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any enfeebling disease.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Sick men with divers <qex>languors</qex>.</q> <rj><qau>Wyclif (Luke iv. 40).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Listless indolence; dreaminess.</def> <au>Pope.</au> <ldquo/ German dreams, Italian <xex>languors</xex>.<rdquo/  <rj><au>The Century.</au></rj></p>

<p><syn><b>Syn.</b> -- Feebleness; weakness; faintness; weariness; dullness; heaviness; lassitude; listlessness.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Languorous</ent><br/
<hw>Lan"guor*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Languor</er>: cf. F. <ets>langoureux</ets>.]</ety> <def>Producing, or tending to produce, languor; characterized by languor.</def> <mark>[Obs. or Poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Whom late I left in <qex>languorous</qex> constraint.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To wile the length from <qex>languorous</qex> hours, and draw<br/
The sting from pain.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langure</ent><br/
<hw>Lan"gure</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To languish.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Langya</ent><br/
<hw>Lan"gya</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <ety>[Native name Anglicized.]</ety> <def>One of several species of East Indian and Asiatic fresh-water fishes of the genus <gen>Ophiocephalus</gen>, remarkable for their power of living out of water, and for their tenacity of life; -- called also <altname>walking fishes</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laniard</ent><br/
<hw>Lan"iard</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lanyard</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laniariform</ent><br/
<hw>La`ni*ar"i*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Laniary</ets> + <ets>-form</ets>.]</ety> <fld>(Anat.)</fld> <def>Shaped like a laniary, or canine, tooth.</def>  <rj><au>Owen.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laniary</ent><br/
<hw>La"ni*a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laniarius</ets>, fr. <ets>lanius</ets> butcher, <ets>laniare</ets> to tear in pieces: cf. F. <ets>laniaire</ets>.]</ety> <fld>(Anat.)</fld> <def>Lacerating or tearing; <as>as, the <ex>laniary</ex> canine teeth</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laniary</ent><br/
<hw>La"ni*a*ry</hw>, <pos>n.</pos> <ety>[L. <er>Laniary</er>, <pos>a.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The shambles; a place of slaughter.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>A laniary, or canine, tooth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laniate</ent><br/
<hw>La"ni*ate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L. <ets>laniatus</ets>, p. p. of <ets>laniare</ets>.]</ety> <def>To tear in pieces.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laniation</ent><br/
<hw>La`ni*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>laniatio</ets>.]</ety> <def>A tearing in pieces.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanier</ent><br/
<hw>Lan"ier</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lani<egrave/re</ets>. See <er>Lanyard</er>.]</ety> <altsp>[Written also <asp>lanner</asp>, <asp>lanyer</asp>.]</altsp> <sn>1.</sn> <def>A thong of leather; a whip lash.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A strap used to fasten together parts of armor, to hold the shield by, and the like.</def>  <rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laniferous</ent><br/
<hw>La*nif"er*ous</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lanifer</ets>; <ets>lana</ets> wool + <ets>ferre</ets> to bear: cf. F. <ets>lanif<egrave/re</ets>.]</ety> <def>Bearing or producing wool.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanifical</ent><br/
<hw>La*nif"i*cal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lanificus</ets>; <ets>lana</ets> wool + <ets>facere</ets> to make.]</ety> <def>Working in wool.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanifice</ent><br/
<hw>Lan"i*fice</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lanificium</ets>: cf. OF. <ets>lanifice</ets>.]</ety> <def>Anything made of wool.</def> <mark>[Obs.]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanigerous</ent><br/
<hw>La*nig"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laniger</ets>; <ets>lano</ets> wool + <ets>gerere</ets> to hear.]</ety> <def>Bearing or producing wool.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanioid</ent><br/
<hw>La"ni*oid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[NL. <ets>Lanius</ets> (fr. L. <ets>lanius</ets> a butcher), the typical genus + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Of or pertaining to the shrikes (family <fam>Laniid<ae/</fam>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lank</ent><br/
<hw>Lank</hw> <pr>(l<acr/<nsm/k)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Lanker</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Lankest</adjf>.]</amorph> <ety>[<er>AS</er>. <ets>hlanc</ets>; cf. G. <ets>lenken</ets> to turn, <ets>gelenk</ets> joint, OHG. <ets>hlanca</ets> hip, side, flank, and E. <ets>link</ets> of a chain.]</ety> <sn>1.</sn> <def>Slender and thin; not well filled out; not plump; shrunken; lean.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Meager and <qex>lank</qex> with fasting grown.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Who would not choose . . . to have rather a <qex>lank</qex> purse than an empty brain?</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Languid; drooping.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Who, piteous of her woes, reared her <qex>lank</qex> head.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lank hair</b></col>, <cd>long, thin hair.</cd>  <rj><au>Macaulay.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lank</ent><br/
<hw>Lank</hw>, <pos>v. i. & t.</pos> <def>To become lank; to make lank.</def> <mark>[Obs.]</mark> <au>Shak.</au> <au>G. Fletcher.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lankiness</ent><br/
<hw>Lank"i*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The condition or quality or being lanky.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lankly</ent><br/
<hw>Lank"ly</hw>, <pos>adv.</pos> <def>In a lank manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lankness</ent><br/
<hw>Lank"ness</hw>, <pos>n.</pos> <def>The state or quality of being lank.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanky</ent><br/
<hw>Lank"y</hw>, <pos>a.</pos> <def>Somewhat lank; tall, thin, bony and ungraceful.</def>  <rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>lanky</qex> Dinka, nearly seven feet in height.</q> <rj><qau>The Century.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanneret</ent><br/
<ent>Lanner</ent><br/
<mhw>{ <hw>Lan"ner</hw> <pr>(?)</pr>, <pos>n. f.</pos> <hw>Lan"ner*et</hw> <pr>(?)</pr>, <pos>n. m.</pos>}</mhw> <ety>[F. <ets>lanier</ets>, OF. also, <ets>lasnier</ets>.  Cf. <er>Lanyard</er>.]</ety> <fld>(Zool.)</fld> <def>A long-tailed falcon (<spn>Falco lanarius</spn>), of Southern Europe, Asia, and Northern Africa, resembling the American prairie falcon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanolin</ent><br/
<hw>Lan"o*lin</hw> <pr>(l<acr/n"<osl/*l<icr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>lana</ets> wool + <ets>ole</ets>um oil.]</ety> <fld>(Physiol. Chem.)</fld> <def>A peculiar fatlike body, made up of cholesterin and certain fatty acids, found in feathers, hair, wool, and keratin tissues generally.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Under the same name, it is prepared from wool for commercial purposes, and forms an admirable basis for ointments, being readily absorbed by the skin.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>lansah</ent><br/
<ent>lansa</ent><br/
<mhw><hw>lansa</hw>, <hw>lansah</hw></mhw> <pos>n.</pos> <def>Same as <er>lanseh</er>.</def><br/
<syn><b>Syn. --</b> lanseh, lansat, lanset.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 829 --></p>

<p><ent>Lanseh</ent><br/
\'d8<hw>Lan"seh</hw> <pr>(l<adot/n"s<asl/)</pr>, <pos>n.</pos> <def>The small, yellow to whitish brown berrylike fruit of an East Indian tree (<spn>Lansium domesticum</spn>).  It has a fleshy pulp, with an agreeable tart subacid taste.</def>  <rj><au>Balfour.</au></rj><br/
<syn><b>Syn. --</b> lansah, lansa, lansat, lanset.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Lansquenet</ent><br/
<hw>Lans"que*net</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. G. <ets>landsknecht</ets> a foot soldier, also a game of cards introduced by these foot soldiers; <ets>land</ets> country + <ets>knecht</ets> boy, servant. See <er>Land</er>, and <er>Knight</er>.]</ety> <sn>1.</sn> <def>A German foot soldier in foreign service in the 15th and 16th centuries; a soldier of fortune; -- a term used in France and Western Europe.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A game at cards, vulgarly called <altname>lambskinnet</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[They play] their little game of <qex>lansquenet</qex>.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lant</ent><br/
<hw>Lant</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Urine.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lant</ent><br/
<hw>Lant</hw>, <pos>n.</pos> <ety>[Cf. <er>Lance</er>.]</ety> <fld>(Zool.)</fld> <def>Any one of several species of small, slender, marine fishes of the genus <gen>Ammedytes</gen>. The common European species (<spn>Ammedytes tobianus</spn>) and the American species (<spn>Ammedytes Americanus</spn>) live on sandy shores, buried in the sand, and are caught in large quantities for bait. Called also <altname>launce</altname>, and <altname>sand eel</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lant</ent><br/
<hw>Lant</hw>, <pos>n.</pos> <def>See <er>Lanterloo</er>.</def> <mark>[Obs.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lantanum</ent><br/
<ent>Lantanium</ent><br/
<mhw>{ <hw>Lan*ta"ni*um</hw> <pr>(?)</pr>, <hw>Lan"ta*num</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <fld>(Chem.)</fld> <def>See <er>Lanthanum</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lantanuric</ent><br/
<hw>Lan`ta*nu"ric</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Formed by transposition of the letters of <ets>allantoin</ets> and <ets>-uric</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, a nitrogenous organic acid of the uric acid group, obtained by the decomposition of allantoin, and usually called <altname>allanturic acid</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanterloo</ent><br/
<hw>Lan"ter*loo`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An old name of <altname>loo</altname> <sd>(a)</sd>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lantern</ent><br/
<hw>Lan"tern</hw> <pr>(l<acr/n"t<etil/rn)</pr>, <pos>n.</pos> <ety>[F. <ets>lanterne</ets>, L. <ets>lanterna</ets>, <ets>laterna</ets>, from Gr. <grk>lampth`r</grk> light, torch. See <er>Lamp</er>.]</ety> <sn>1.</sn> <def>Something inclosing a light, and protecting it from wind, rain, etc.; -- sometimes portable, as a closed vessel or case of horn, perforated tin, glass, oiled paper, or other material, having a lamp or candle within; sometimes fixed, as the glazed inclosure of a street light, or of a lighthouse light.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>An open structure of light material set upon a roof, to give light and air to the interior.</def> <sd>(b)</sd> <def>A cage or open chamber of rich architecture, open below into the building or tower which it crowns.</def> <sd>(c)</sd> <def>A smaller and secondary cupola crowning a larger one, for ornament, or to admit light; such as the lantern of the cupola of the Capitol at Washington, or that of the Florence cathedral.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mach.)</fld> <def>A lantern pinion or trundle wheel. See <cref>Lantern pinion</cref> (below).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Steam Engine)</fld> <def>A kind of cage inserted in a stuffing box and surrounding a piston rod, to separate the packing into two parts and form a chamber between for the reception of steam, etc.; -- called also <altname>lantern brass</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Founding)</fld> <def>A perforated barrel to form a core upon.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Zool.)</fld> <def>See <er>Aristotle's lantern</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Fig. 1 represents a <xex>hand lantern</xex>; fig. 2, an <xex>arm lantern</xex>; fig. 3, a <xex>breast lantern</xex>; -- so named from the positions in which they are carried.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Dark lantern</b></col>, <cd>a lantern with a single opening, which may be closed so as to conceal the light; -- called also <altname>bull's-eye</altname>.</cd> -- <col><b>Lantern jaws</b></col>, <cd>long, thin jaws; hence, a thin visage.</cd> -- <mcol><col><b>Lantern pinion</b></col>, <col><b>Lantern wheel</b></col></mcol> <fld>(Mach.)</fld>, <cd>a kind of pinion or wheel having cylindrical bars or trundles, instead of teeth, inserted at their ends in two parallel disks or plates; -- so called as resembling a lantern in shape; -- called also <altname>wallower</altname>, or <altname>trundle</altname>.</cd> -- <col><b>Lantern shell</b></col> <fld>(Zool.)</fld>, <cd>any translucent, marine, bivalve shell of the genus <altname>Anatina</altname>, and allied genera.</cd> -- <col><b>Magic lantern</b></col>, <cd>an optical instrument consisting of a case inclosing a light, and having suitable lenses in a lateral tube, for throwing upon a screen, in a darkened room or the like, greatly magnified pictures from slides placed in the focus of the outer lens.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lantern</ent><br/
<hw>Lan"tern</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lanterned</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lanterning</conjf>.]</vmorph> <ety>[Cf. F. <ets>lanterner</ets> to hang at the lamp post, fr. <ets>lanterne</ets>. See <er>Lantern</er>.]</ety> <def>To furnish with a lantern; <as>as, to <ex>lantern</ex> a lighthouse</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lanternfish</ent><br/
<hw>lanternfish</hw> <pos>n.</pos> <def>A small fish having rows of luminous organs along each side; some surface at night.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lantern fly</ent><br/
<ent>lanternfly</ent><br/
<mhw><hw>lanternfly</hw>, <hw>lantern fly</hw></mhw> <pos>n.</pos> <fld>(Zool.)</fld> <def>any one of several species of large, handsome, brightly marked, tropical hemipterous insects of the genera <gen>Laternaria</gen>, <gen>Fulgora</gen>, and allies, of the family <fam>Fulgorid<ae/</fam>. The largest species is <spn>Laternaria phosphorea</spn> of Brazil. The head has a snoutlike process in some species which was formerly thought to emit a phosphorescent light.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lantern-jawed</ent><br/
<hw>Lan"tern-jawed`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having lantern jaws or long, thin jaws; <as>as, a <ex>lantern-jawed</ex> person</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lanthanide</ent><br/
<hw>lanthanide</hw> <pos>n.</pos> <def>Any <isa>rare earth element</isa> of the lanthanide series (atomic numbers 57 through 71).</def><br/
<syn><b>Syn. --</b> rare earth, rare-earth element, lanthanon.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lanthanite</ent><br/
<hw>Lan"tha*nite</hw> <pr>(l<acr/n"th<adot/*n<imac/t)</pr>, <pos>n.</pos> <fld>(Min.)</fld> <def>Hydrous carbonate of lanthanum, found in tabular white crystals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lanthanon</ent><br/
<hw>lanthanon</hw> <pos>n.</pos> <def>Same as <er>lanthanide</er>.</def><br/
<syn><b>Syn. --</b> rare earth, rare-earth element, lanthanide.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lanthanotidae</ent><br/
<hw>Lanthanotidae</hw> <pos>n.</pos> <def>A natural family of stout-bodied lizards.</def><br/
<syn><b>Syn. --</b> family <fam>Lanthanotidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lanthanotus</ent><br/
<hw>Lanthanotus</hw> <pos>n.</pos> <def>A genus withonly one species.</def><br/
<syn><b>Syn. --</b> genus <gen>Lanthanotus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lanthanum</ent><br/
<hw>Lan"tha*num</hw> <pr>(l<acr/n"th<adot/*n<ucr/m)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>lanqa`nein</grk> to lie hid, to be concealed.]</ety> <fld>(Chem.)</fld> <def>A rare element of the rare earth group of the metals, of atomic number 57, allied to aluminum.  It occurs in certain rare minerals, as cerite, gadolinite, orthite, etc., and was so named from the difficulty of separating it from cerium, didymium, and other rare earth elements with which it is usually associated. Atomic weight 138.9. Symbol La.</def> <altsp>[Formerly written also <asp>lanthanium</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanthopine</ent><br/
<hw>Lan"tho*pine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lanqa`nein</grk> to lie hid + E. <ets>op</ets>ium.]</ety> <fld>(Chem.)</fld> <def>An alkaloid found in opium in small quantities, and extracted as a white crystalline substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanthorn</ent><br/
<hw>Lan"thorn</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lantern</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanuginous</ent><br/
<ent>Lanuginose</ent><br/
<mhw>{ <hw>La*nu"gi*nose`</hw> <pr>(?)</pr>, <hw>La*nu"gi*nous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>lanuginosus</ets>, fr. <ets>lanugo</ets>, <ets>-ginis</ets>, woolly substance, down, fr. <ets>lana</ets> wool: cf. F. <ets>lanugineux</ets>.]</ety> <def>Covered with down, or fine soft hair; downy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanugo</ent><br/
\'d8<hw>La*nu"go</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lanuginose</er>.]</ety> <fld>(Anat.)</fld> <def>The soft woolly hair which covers most parts of the mammal fetus, and in man is shed before or soon after birth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanyard</ent><br/
<hw>Lan"yard</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lani<egrave/re</ets> thong, strap, OF. <ets>lasniere</ets>, fr. <ets>lasne</ets> strap, thong, L. <ets>lacinia</ets> lappet. flap, edge of a garment.  Cf. <er>Lanier</er>.]</ety> <altsp>[Written also <asp>laniard</asp>.]</altsp> <sn>1.</sn> <fld>(Naut.)</fld> <def>A short piece of rope or line for fastening something in ships; <as>as, the <ex>lanyards</ex> of the gun ports, of the buoy, and the like</as>; esp., pieces passing through the dead-eyes, and used to extend shrouds, stays, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mil.)</fld> <def>A strong cord, about twelve feet long, with an iron hook at one end a handle at the other, used in firing cannon with a friction tube.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lanyer</ent><br/
<hw>Lan"yer</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lanier</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laocoon</ent><br/
<hw>La*oc"o*<oum/n</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <ety>[L., fr. Gr. <?/ ]</ety> <sn>1.</sn> <fld>(Class. Myth.)</fld> <def>A priest of Apollo, during the Trojan war. (See 2.)</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Sculp.)</fld> <def>A marble group in the Vatican at Rome, representing the priest Laoco<oum/n, with his sons, infolded in the coils of two serpents, as described by Virgil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laodicean</ent><br/
<hw>La*od`i*ce"an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to <etsep>Laodicea</etsep>, a city in Phrygia Major; like the Christians of Laodicea; lukewarm in religion.</def>  <rj><au>Rev. iii. 14-16.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laos</ent><br/
<hw>Laos</hw> <pos>prop. n.</pos> <def>a country in Southeast Asia.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laotian</ent><br/
<hw>Laotian</hw> <pos>prop. n.</pos> <def>a native or inhabitant of Laos.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laotian</ent><br/
<hw>Laotian</hw> <pos>prop. a.</pos> <sn>1.</sn> <def>of or pertaining to Laos; <as>as, the <ex>Laotian</ex> Prime Minister</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>of or pertaining to the inhabitants of Laos; <as>as, <ex>Laotian</ex> refugees</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laozi</ent><br/
<ent>Lao-tse</ent><br/
<mhw><hw>Lao-tse</hw>, <hw>Laozi</hw></mhw> <pos>prop. n.</pos> <def>A Chinese philosopher who founded Taoism in the 6th-century b.c.</def><br/
<syn><b>Syn. --</b> Lao-Tzu, Lao-Tse.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lap</ent><br/
<hw>Lap</hw> <pr>(l<acr/p)</pr>, <pos>n.</pos> <ety>[OE. <ets>lappe</ets>, AS. <ets>l<ae/ppa</ets>; akin to D. <ets>lap</ets> patch, piece, G. <ets>lappen</ets>, OHG. <ets>lappa</ets>, Dan. <ets>lap</ets>, Sw. <ets>lapp</ets>.]</ety> <sn>1.</sn> <def>The loose part of a coat; the lower part of a garment that plays loosely; a skirt; an apron.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An edge; a border; a hem, as of cloth.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>If he cuts off but a <qex>lap</qex> of truth's garment, his heart smites him.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The part of the clothing that lies on the knees or thighs when one sits down; that part of the person thus covered; figuratively, a place of rearing and fostering; <as>as, to be reared in the <ex>lap</ex> of luxury</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Men expect that happiness should drop into their <qex>laps</qex>.</q> <rj><qau>Tillotson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>That part of any substance or fixture which extends over, or lies upon, or by the side of, a part of another; <as>as, the <ex>lap</ex> of a board</as>; also, the measure of such extension over or upon another thing.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>lap</xex> of shingles or slates in roofing is the distance one course extends over the second course below, the distance over the course immediately below being called the <xex>cover</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Steam Engine)</fld> <def>The amount by which a slide valve at its half stroke overlaps a port in the seat, being equal to the distance the valve must move from its mid stroke position in order to begin to open the port. Used alone, <xex>lap</xex> refers to outside lap. See <cref>Outside lap</cref> (below).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>The state or condition of being in part extended over or by the side of something else; or the extent of the overlapping; <as>as, the second boat got a <ex>lap</ex> of half its length on the leader</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>One circuit around a race track, esp. when the distance is a small fraction of a mile; <as>as, to run twenty <ex>laps</ex>; to win by three <ex>laps</ex>. See <er>Lap</er>, to fold, 2.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>In card playing and other games, the points won in excess of the number necessary to complete a game; -- so called when they are counted in the score of the following game.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Cotton Manuf.)</fld> <def>A sheet, layer, or bat, of cotton fiber prepared for the carding machine.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Mach.)</fld> <def>A piece of brass, lead, or other soft metal, used to hold a cutting or polishing powder in cutting glass, gems, and the like, or in polishing cutlery, etc. It is usually in the form of wheel or disk, which revolves on a vertical axis.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lap joint</b></col>, <cd>a joint made by one layer, part, or piece, overlapping another, as in the scarfing of timbers.</cd> -- <col><b>Lap weld</b></col>, <cd>a lap joint made by welding together overlapping edges or ends.</cd> -- <col><b>Inside lap</b></col> <fld>(Steam Engine)</fld>, <cd>lap of the valve with respect to the exhaust port.</cd> -- <col><b>Outside lap</b></col>, <cd>lap with respect to the admission, or steam, port.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lap</ent><br/
<hw>Lap</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lapped</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lapping</conjf>.]</vmorph> <sn>1.</sn> <def>To rest or recline in a lap, or as in a lap.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>lap</qex> his head on lady's breast.</q> <rj><qau>Praed.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cut or polish with a lap, as glass, gems, cutlery, etc. See 1st <er>Lap</er>, 10.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lap</ent><br/
<hw>Lap</hw>, <pos>v. t.</pos> <ety>[OE. <ets>lappen</ets> to fold (see <er>Lap</er>, <pos>n.</pos>); cf. also OE. <ets>wlappen</ets>, perh. another form of <ets>wrappen</ets>, E, <ets>wrap</ets>.]</ety> <sn>1.</sn> <def>To fold; to bend and lay over or on something; <as>as, to <ex>lap</ex> a piece of cloth</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To wrap or wind around something.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>About the paper . . . I <qex>lapped</qex> several times a slender thread of very black silk.</q> <rj><qau>Sir I. Newton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To infold; to hold as in one's lap; to cherish.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Her garment spreads, and <qex>laps</qex> him in the folds.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To lay or place over anything so as to partly or wholly cover it; <as>as, to <ex>lap</ex> one shingle over another</as>; to lay together one partly over another; <as>as, to <ex>lap</ex> weather-boards</as>; also, to be partly over, or by the side of (something); <as>as, the hinder boat <ex>lapped</ex> the foremost one</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Carding & Spinning)</fld> <def>To lay together one over another, as fleeces or slivers for further working.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>To lap boards</b></col>, <col><b>shingles</b></col>, etc.</mcol>, <cd>to lay one partly over another.</cd> -- <col><b>To lap timbers</b></col>, <cd>to unite them in such a way as to preserve the same breadth and depth throughout, as by scarfing.</cd>  <rj><au>Weale.</au></rj>
</cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lap</ent><br/
<hw>Lap</hw>, <pos>v. i.</pos> <def>To be turned or folded; to lie partly upon or by the side of something, or of one another; <as>as, the cloth <ex>laps</ex> back; the boats <ex>lap</ex>; the edges <ex>lap</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The upper wings are opacous; at their hinder ends, where they <qex>lap</qex> over, transparent, like the wing of a flay.</q> <rj><qau>Grew.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lap</ent><br/
<hw>Lap</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[OE. <ets>lappen</ets>, <ets>lapen</ets>, AS. <ets>lapian</ets>; akin to LG. <ets>lappen</ets>, OHG. <ets>laffan</ets>, Icel. <ets>lepja</ets>, Dan. <ets>lade</ets>, Sw. <ets>l<aum/ppja</ets>, L. <ets>lambere</ets>; cf. Gr. <?/, W. <ets>llepio</ets>.  Cf. <er>Lambent</er>.]</ety> <sn>1.</sn> <def>To take up drink or food with the tongue; to drink or feed by licking up something.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The dogs by the River Nilus's side, being thirsty, <qex>lap</qex> hastily as they run along the shore.</q> <rj><qau>Sir K. Digby.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make a sound like that produced by taking up drink with the tongue.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I heard the ripple washing in the reeds,<br/
And the wild water <qex>lapping</qex> on the crag.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lap</ent><br/
<hw>Lap</hw>, <pos>v. t.</pos> <def>To take into the mouth with the tongue; to lick up with a quick motion of the tongue.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They 'II take suggestion as a cat <qex>laps</qex> milk.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lap</ent><br/
<hw>Lap</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of lapping with, or as with, the tongue; <as>as, to take anything into the mouth with a <ex>lap</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The sound of lapping.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laparocele</ent><br/
<hw>Lap"a*ro*cele`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ loins + <?/ tumor.]</ety> <fld>(Med.)</fld> <def>A rupture or hernia in the lumbar regions.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>laparoscope</ent><br/
<hw>laparoscope</hw> <pos>n.</pos> <fld>(Med.)</fld> <def>A slender endoscope, containing fiber-optic viewing capability and miniature surgical devices, which can be inserted through a small incision in the abdominal wall, allowing a surgeon to perform minor surgery with minimal damage to the abdominal muscles.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>laparoscopy</ent><br/
<hw>laparoscopy</hw> <pos>n.</pos> <def>Laparotomy performed with a laparoscope.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laparotomy</ent><br/
<hw>Lap`a*rot"o*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ loins + <grk>te`mnein</grk> to cut.]</ety> <fld>(Surg.)</fld> <def>A cutting through the walls of the abdomen, as in the Caesarean section.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapboard</ent><br/
<hw>Lap"board`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A board used on the lap as a substitute for a table, as by tailors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapdog</ent><br/
<hw>Lap"dog`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A small dog which is or can be fondled in the lap.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who does the bidding of another; a servile follower.</def> <mark>[informal]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Lapel</ent><br/
<hw>La*pel"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Dim. of <ets>lap</ets> a fold.]</ety> <def>That part of a garment which is turned back; specifically, the lap, or fold, of the front of a coat in continuation of collar.</def> <altsp>[Written also <asp>lappel</asp> and <asp>lapelle</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapelled</ent><br/
<hw>La*pelled"</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Furnished with lapels.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapful</ent><br/
<hw>Lap"ful</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lapfuls</plw> <pr>(<?/)</pr>.</plu> <def>As much as the lap can contain.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapicide</ent><br/
<hw>Lap"i*cide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lapicida</ets>, fr. <ets>lapis</ets> stone + <ets>caedere</ets> to cut.]</ety> <def>A stonecutter.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidarian</ent><br/
<hw>Lap`i*da"ri*an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to stone; inscribed on stone; <as>as, a <ex>lapidarian</ex> record</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidarious</ent><br/
<hw>Lap`i*da"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lapidarius</ets>, fr. <ets>lapis</ets>, <ets>-idis</ets>, stone.]</ety> <def>Consisting of stones.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidary</ent><br/
<hw>Lap"i*da*ry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lapidaries</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>lapidarius</ets>, fr. <ets>lapidarius</ets> pertaining to stone: cf. F. <ets>lapidaire</ets>.]</ety> <sn>1.</sn> <def>An artificer who cuts, polishes, and engraves precious stones; hence, a dealer in precious stones.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A virtuoso skilled in gems or precious stones; a connoisseur of lapidary work.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Lapidary's lathe</b></col>, <col><b>Lapidary's mill</b></col>, <col><b>Lapidary's wheel</b></col></mcol>, <cd>a machine consisting essentially of a revolving lap on a vertical spindle, used by a lapidary for grinding and polishing.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidary</ent><br/
<hw>Lap"i*da*ry</hw>, <pos>a.</pos> <ety>[L. <ets>lapidarius</ets> pertaining to stone: cf. F. <ets>lapidaire</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining to the art of cutting stones, or engraving on stones, either gems or monuments; <as>as, <ex>lapidary</ex> ornamentation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to monumental inscriptions; <as>as, <ex>lapidary</ex> adulation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lapidary style</b></col>, <cd>that style which is proper for monumental and other inscriptions; terse; sententious.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidate</ent><br/
<hw>Lap"i*date</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L. <ets>lapidatus</ets>, p. p. of <ets>lapidare</ets>, fr. <ets>lapis</ets> stone.]</ety> <def>To stone.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidation</ent><br/
<hw>Lap`i*da"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lapidatio</ets>: cf. F. <ets>lapidation</ets>.]</ety> <def>The act of stoning.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapideous</ent><br/
<hw>La*pid"e*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lapideus</ets>, fr. <ets>lapis</ets> stone.]</ety> <def>Of the nature of stone.</def> <mark>[Obs.]</mark>  <rj><au>Ray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidescence</ent><br/
<hw>Lap`i*des"cence</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The state or quality of being lapidescent.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A hardening into a stone substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A stony concretion.</def>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidescent</ent><br/
<hw>Lap`i*des"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lapidescens</ets>, p. pr. of <ets>lapidescere</ets> to become stone, fr. <ets>lapis</ets>, <ets>-idis</ets>, stone: cf. F. <ets>lapidescent</ets>.]</ety> <def>Undergoing the process of becoming stone; having the capacity of being converted into stone; having the quality of petrifying bodies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidescent</ent><br/
<hw>Lap"i*des"cent</hw>, <pos>n.</pos> <def>Any substance which has the quality of petrifying other bodies, or of converting or being converted into stone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidifical</ent><br/
<ent>Lapidific</ent><br/
<mhw>{ <hw>Lap`i*dif"ic</hw> <pr>(?)</pr>, <hw>Lap`i*dif"ic*al</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>lapis</ets>, <ets>-idis</ets>, stone + <ets>facere</ets> to make: cf. F. <ets>lapidifique</ets>.]</ety> <def>Forming or converting into stone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidification</ent><br/
<hw>La*pid`i*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lapidification</ets>.]</ety> <def>The act or process of lapidifying; fossilization; petrifaction.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidify</ent><br/
<hw>La*pid"i*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lapidified</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lapidifying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf. f. <ets>lapidifier</ets>. See <er>Lapidific</er>, and <er>-fy</er>.]</ety> <def>To convert into stone or stony material; to petrify.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidify</ent><br/
<hw>La*pid"i*fy</hw>, <pos>v. i.</pos> <def>To become stone or stony.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapidist</ent><br/
<hw>Lap"i*dist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lapis</ets>, <ets>-idis</ets>, a stone.]</ety> <def>A lapidary.</def>  <rj><au>Ray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapillation</ent><br/
<hw>Lap"il*la"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lapilli</er>.]</ety> <def>The state of being, or the act of making, stony.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapilli</ent><br/
\'d8<hw>La*pil"li</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[L. <ets>lapillus</ets> a little stone, dim. of <ets>lapis</ets> stone.]</ety> <fld>(Min.)</fld> <def>Volcanic ashes, consisting of small, angular, stony fragments or particles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapis</ent><br/
\'d8<hw>La"pis</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lapides</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <def>A stone.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lapis calaminaris</b></col> <pr>(<?/)</pr> <pos>n.</pos> <ety>[NL.]</ety> <fld>(Min.)</fld> <cd>Calamine.</cd> -- <col><b>Lapis infernalis</b></col> <pr>(<?/)</pr> <pos>n.</pos> <ety>[L.]</ety> <cd>Fused nitrate of silver; lunar caustic.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapis lazuli</ent><br/
<hw>La"pis laz"u*li</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Min.)</fld> <def>An albuminous mineral of a rich blue color; also called <altname>lapis</altname>. Same as <er>Lazuli</er>, which see.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lap-jointed</ent><br/
<hw>Lap"-joint`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a lap joint, or lap joints, as many kinds of woodwork and metal work.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laplander</ent><br/
<hw>Lap"land*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A native or inhabitant of Lapland; -- called also <altname>Lapp</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laplandish</ent><br/
<hw>Lap"land*ish</hw>, <pos>a.</pos> <def>Of or pertaining to Lapland.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapling</ent><br/
<hw>Lap"ling</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lap</ets> of a garment + <ets>ling</ets>.]</ety> <def>One who has been fondled to excess; one fond of ease and sensual delights; -- a term of contempt.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapp</ent><br/
<hw>Lapp</hw> <pr>(l<acr/p)</pr>, <pos>n.</pos> <def>Same as <er>Laplander</er>.  Cf. <er>Lapps</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 830 --></p>

<p><ent>Lappaceous</ent><br/
<hw>Lap*pa"ceous</hw> <pr>(l<acr/p*p<amac/"sh<ucr/s)</pr>, <pos>a.</pos> <ety>[L. <ets>lappaceus</ets> burlike, fr. <ets>lappa</ets> a bur.]</ety> <fld>(Bot.)</fld> <def>Resembling the capitulum of burdock; covered with forked points.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapper</ent><br/
<hw>Lap"per</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>La</er>p to drink.]</ety> <def>One who takes up food or liquid with his tongue.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lappet</ent><br/
<hw>Lap"pet</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Dim. of <ets>lap</ets> a fold.]</ety> <def>A small decorative fold or flap, esp. of lace or muslin, in a garment or headdress.</def>  <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lappet moth</b></col> <fld>(Zool.)</fld>, <cd>one of several species of bombycid moths, which have stout, hairy caterpillars, flat beneath.  Two common American species (<spn>Gastropacha Americana</spn>, and <spn>Tolype velleda</spn>) feed upon the apple tree.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lappet</ent><br/
<hw>Lap"pet</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lappeted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Lappeting</conjf>.]</vmorph> <def>To decorate with, or as with, a lappet.</def> <mark>[R.]</mark>  <rj><au>Landor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lappic</ent><br/
<hw>Lap"pic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Lapland, or the Lapps.</def> -- <def2><pos>n.</pos> <def>The language of the Lapps. See <er>Lappish</er>.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapping</ent><br/
<hw>Lap"ping</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of machine blanket or wrapping material used by calico printers.</def>  <rj><au>Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Lapping engine</b></col>, <col><b>Lapping machine</b></col></mcol> <fld>(Textile Manuf.)</fld>, <cd>A machine for forming fiber info a lap. See its <er>Lap</er>, 9.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lappish</ent><br/
<hw>Lap"pish</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to the Lapps; Laplandish.</def> -- <def2><pos>n.</pos> <def>The language spoken by the Lapps in Lapland. It is related to the Finnish and Hungarian, and is not an Aryan language.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapponic</ent><br/
<ent>Lapponian</ent><br/
<mhw>{ <hw>Lap*po"ni*an</hw> <pr>(?)</pr>, <hw>Lap*pon"ic</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <def>Laplandish; Lappish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapps</ent><br/
<hw>Lapps</hw> <pr>(?)</pr>, <pos>n. pl.</pos>; <sing>sing.  <singw>Lapp</singw> <pr>(<?/)</pr></sing>. <fld>(Ethnol.)</fld> <def>A branch of the Mongolian race, now living in the northern parts of Norway, Sweden, and the adjacent parts of Russia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapsable</ent><br/
<hw>Laps"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Lapsible.</def>  <rj><au>Cudworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapse</ent><br/
<hw>Lapse</hw> <pr>(l<acr/ps)</pr>, <pos>n.</pos> <ety>[L. <ets>lapsus</ets>, fr. <ets>labi</ets>, p. p. <ets>lapsus</ets>, to slide, to fall: cf. F. <ets>laps</ets>. See <er>Sleep</er>.]</ety> <sn>1.</sn> <def>A gliding, slipping, or gradual falling; an unobserved or imperceptible progress or passing away,; -- restricted usually to immaterial things, or to figurative uses.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>lapse</qex> to indolence is soft and imperceptible.</q> <rj><qau>Rambler.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Bacon was content to wait the <qex>lapse</qex> of long centuries for his expected revenue of fame.</q> <rj><qau>I. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A slip; an error; a fault; a failing in duty; a slight deviation from truth or rectitude.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To guard against those <qex>lapses</qex> and failings to which our infirmities daily expose us.</q> <rj><qau>Rogers.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>The termination of a right or privilege through neglect to exercise it within the limited time, or through failure of some contingency; hence, the devolution of a right or privilege.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Theol.)</fld> <def>A fall or apostasy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapse</ent><br/
<hw>Lapse</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lapsed</conjf> <pr>(#)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lapsing</conjf>.]</vmorph> <sn>1.</sn> <def>To pass slowly and smoothly downward, backward, or away; to slip downward, backward, or away; to glide; -- mostly restricted to figurative uses.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A tendency to <qex>lapse</qex> into the barbarity of those northern nations from whom we are descended.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Homer, in his characters of Vulcan and Thersites, has <qex>lapsed</qex> into the burlesque character.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To slide or slip in moral conduct; to fail in duty; to fall from virtue; to deviate from rectitude; to commit a fault by inadvertence or mistake.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>lapse</qex> in fullness<br/
Is sorer than to lie for need.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>To fall or pass from one proprietor to another, or from the original destination, by the omission, negligence, or failure of some one, as a patron, a legatee, etc.</def> <sd>(b)</sd> <def>To become ineffectual or void; to fall.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If the archbishop shall not fill it up within six months ensuing, it <qex>lapses</qex> to the king.</q> <rj><qau>Ayliffe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapse</ent><br/
<hw>Lapse</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To let slip; to permit to devolve on another; to allow to pass.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>An appeal may be deserted by the appellant's <qex>lapsing</qex> the term of law.</q> <rj><qau>Ayliffe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To surprise in a fault or error; hence, to surprise or catch, as an offender.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>For which, if be <qex>lapsed</qex> in this place,<br/
I shall pay dear.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapsed</ent><br/
<hw>Lapsed</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having slipped downward, backward, or away; having lost position, privilege, etc., by neglect; -- restricted to figurative uses.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Once more I will renew<br/
His <qex>lapsed</qex> powers, though forfeit.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Ineffectual, void, or forfeited; <as>as, a <ex>lapsed</ex> policy of insurance; a <ex>lapsed</ex> legacy.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Lapsed devise</b></col>, <col><b>Lapsed legacy</b></col></mcol> <fld>(Law)</fld>, <cd>a devise, or legacy, which fails to take effect in consequence of the death of the devisee, or legatee, before that of the testator, or for other cause.</cd>  <rj><au>Wharton (Law Dict.).</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapsible</ent><br/
<hw>Laps"i*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Liable to lapse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapsided</ent><br/
<hw>Lap"sid`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See <er>Lopsided</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapstone</ent><br/
<hw>Lap"stone`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A stone for the lap, on which shoemakers beat leather.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lap-straked</ent><br/
<ent>lap-streaked</ent><br/
<ent>Lapstrake</ent><br/
<ent>Lapstreak</ent><br/
<mhw>{ <hw>Lap"streak`</hw> <pr>(?)</pr>, <hw>Lap"strake`</hw> <pr>(?)</pr>, <hw>lap-streaked</hw>, <hw>lap-straked</hw> }</mhw> <pos>a.</pos> <def>Made with boards whose edges lap one over another; clinker-built; -- said of boats.  Contrasted with <contr>carvel-built</contr>.</def><br/
<syn><b>Syn. --</b> lap-jointed, overlapping.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>lap up</ent><br/
<hw>lap up</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[See <er>lap</er>, <pos>v. i.</pos>]</ety> <sn>1.</sn> <def>To take up (drink or food) with the tongue; to drink by licking up.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <mark>(fig.)</mark> <def>To accept or enjoy enthusiatically and uncritically; <as>as, to <ex>lap up</ex> praise</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Laputan</ent><br/
<hw>La*pu"tan</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to Laputa, an imaginary flying island described in <xex>Gulliver's Travels</xex> as the home of chimerical philosophers.</def> <specif>Hence,</specif> <def>fanciful; preposterous; absurd in science or philosophy.</def> <ldquo/<xex>Laputan</xex> ideas.<rdquo/  <rj><au>G. Eliot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lap-welded</ent><br/
<hw>Lap"-weld`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having edges or ends united by a lap weld; <as>as, a <ex>lap-welded</ex> pipe</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapwing</ent><br/
<hw>Lap"wing`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>lapwynke</ets>, <ets>leepwynke</ets>, AS. <ets>hle<aacute/pewince</ets>; <ets>hle<aacute/pan</ets> to leap, jump + (prob.) a word akin to AS. <ets>wincian</ets> to wink, E. <ets>wink</ets>, AS. <ets>wancol</ets> wavering; cf. G. <ets>wanken</ets> to stagger, waver. See <er>Leap</er>, and <er>Wink</er>.]</ety> <fld>(Zool.)</fld> <def>A small European bird of the Plover family (<spn>Vanellus cristatus</spn>, or <spn>Vanellus vanellus</spn>). It has long and broad wings, and is noted for its rapid, irregular fight, upwards, downwards, and in circles.  Its back is coppery or greenish bronze. Its eggs are the <ldquo/plover's eggs<rdquo/ of the London market, esteemed a delicacy.  It is called also <altname>peewit</altname>, <altname>dastard plover</altname>, and <altname>wype</altname>.  The <stype>gray lapwing</stype> is the <spn>Squatarola cinerea</spn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lapwork</ent><br/
<hw>Lap"work`</hw> <pr>(l<acr/p"w<ucir/rk`)</pr>, <pos>n.</pos> <def>Work in which one part laps over another.</def>  <rj><au>Grew.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laquay</ent><br/
<hw>Laq"uay</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A lackey.</def> <mark>[Obs.]</mark>  <rj><au>Evelyn.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laquear</ent><br/
<hw>La"que*ar</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Laquearia</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <fld>(Arch.)</fld> <def>A lacunar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laqueary</ent><br/
<hw>Laq"ue*a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laqueus</ets> a noose.]</ety> <def>Using a noose, as a gladiator.</def> <mark>[Obs. or R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Retiary and <qex>laqueary</qex> combatants.</q> <rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lar</ent><br/
<hw>Lar</hw> <pr>(l<aum/r)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lares</plw> <pr>(#)</pr>, sometimes <plw>Lars</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <fld>(Rom. Myth.)</fld> <def>A tutelary deity; a deceased ancestor regarded as a protector of the family. The domestic Lares were the tutelar deities of a house; household gods.</def> <specif>Hence,</specif> <mark>(Fig.)</mark>: <def>Hearth or dwelling house.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Nor will she her dear <qex>Lar</qex> forget,<br/
Victorious by his benefit.</q> <rj><qau>Lovelace.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>Lars</qex> and Lemures moan with midnight plaint.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Looking backward in vain toward their <qex>Lares</qex> and lands.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lar</ent><br/
<hw>Lar</hw> <pr>(l<aum/r)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A species of gibbon (<spn>Hylobates lar</spn>), found in Burmah. Called also <altname>white-handed gibbon</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laramie group</ent><br/
<hw>Lar"a*mie group`</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Geol.)</fld> <def>An extensive series of strata, principally developed in the Rocky Mountain region, as in the <etsep>Laramie</etsep> Mountains, and formerly supposed to be of the Tertiary age, but now generally regarded as Cretaceous, or of intermediate and transitional character. It contains beds of lignite, often valuable for coal, and is hence also called the <altname>lignitic group</altname>. See <xex>Chart</xex> of <er>Geology</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larboard</ent><br/
<hw>Lar"board`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lar-</ets> is of uncertain origin, possibly the same as <ets>lower</ets>, i. e., humbler in rank, because the starboard side is considered by mariners as higher in rank; cf. D. <ets>laag</ets> low, akin to E. <ets>low</ets>. See <er>Board</er>, <pos>n.</pos>, 8.]</ety> <fld>(Naut.)</fld> <def>The left-hand side of a ship to one on board facing toward the bow; port; -- opposed to <ant>starboard</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Larboard</xex> is a nearly obsolete term, having been superseded by <altname>port</altname> to avoid liability of confusion with <xex>starboard</xex>, owing to similarity of sound.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larboard</ent><br/
<hw>Lar"board`</hw>, <pos>a.</pos> <def>On or pertaining to the left-hand side of a vessel; port; <as>as, the <ex>larboard</ex> quarter</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larcenist</ent><br/
<ent>Larcener</ent><br/
<mhw>{ <hw>Lar"ce*ner</hw> <pr>(?)</pr>, <hw>Lar"ce*nist</hw> <pr>(?)</pr> }</mhw>, <pos>n.</pos> <def>One who commits larceny.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larcenous</ent><br/
<hw>Lar"ce*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. OE. <ets>larrecinos</ets>. See <er>Larceny</er>.]</ety> <def>Having the character of larceny; <as>as, a <ex>larcenous</ex> act</as>; committing larceny.</def> <ldquo/The <ex>larcenous</ex> and burglarious world.<rdquo/ <au>Sydney Smith.</au> -- <wordforms><wf>Lar"ce*nous*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larceny</ent><br/
<hw>Lar"ce*ny</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Larcenies</plw> <pr>(#)</pr>.</plu> <ety>[F. <ets>larcin</ets>, OE. <ets>larrecin</ets>, L. <ets>latrocinium</ets>, fr. <ets>latro</ets> robber, mercenary, hired servant; cf. Gr. (<?/) hired servant.  Cf. <er>Latrociny</er>.]</ety> <fld>(Law)</fld> <def>The unlawful taking and carrying away of things personal with intent to deprive the right owner of the same; theft.  Cf. <er>Embezzlement</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Grand larceny</b></col> <and/ <col><b>Petit larceny are</b></col></mcol> <cd>distinctions having reference to the nature or value of the property stolen. They are abolished in England.</cd> -- <mcol><col><b>Mixed larceny</b></col>, <it>or</it>  <col><b>Compound larceny</b></col></mcol>, <cd>that which, under statute, includes in it the aggravation of a taking from a building or the person.</cd> -- <col><b>Simple larceny</b></col>, <cd>that which is not accompanied with any aggravating circumstances.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larch</ent><br/
<hw>Larch</hw> <pr>(l<aum/rch)</pr>, <pos>n.</pos> <ety>[Cf. OE. <ets>larege</ets> (Cotgrave), It. <ets>larice</ets>, Sp. <ets>larice</ets>, <ets>alerce</ets>, G. <ets>l<aum/rche</ets>; all fr. L. <ets>larix</ets>, <ets>-icis</ets>, Gr. <grk>la`rix</grk>.]</ety> <fld>(Bot.)</fld> <def>A genus of coniferous trees, having deciduous leaves, in fascicles (see <xex>Illust.</xex> of <er>Fascicle</er>).</def> <note>The European larch is <spn>Larix Europ<ae/a</spn>. The American or black larch is <spn>Larix Americana</spn>, the hackmatack or tamarack. The trees are generally of a drooping, graceful appearance.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larchen</ent><br/
<hw>Larch"en</hw> <pr>(l<aum/rch"<ecr/n)</pr>, <pos>a.</pos> <def>Of or pertaining to the larch.</def>  <rj><au>Keats.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lard</ent><br/
<hw>Lard</hw> <pr>(l<aum/rd)</pr>, <pos>n.</pos> <ety>[F., bacon, pig's fat, L. <ets>lardum</ets>, <ets>laridum</ets>; cf. Gr. (<?/) fattened, fat.]</ety> <sn>1.</sn> <def>Bacon; the flesh of swine.</def> <mark>[Obs.]</mark>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The fat of swine, esp. the internal fat of the abdomen; also, this fat melted and strained.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lard oil</b></col>, <cd>an illuminating and lubricating oil expressed from lard.</cd> -- <col><b>Leaf lard</b></col>, <cd>the internal fat of the hog, separated in leaves or masses from the kidneys, etc.; also, the same melted.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lard</ent><br/
<hw>Lard</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Larded</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Larding</conjf>.]</vmorph> <ety>[F. <ets>larder</ets>. See <er>Lard</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To stuff with bacon; to dress or enrich with lard; esp., to insert lardons of bacon or pork in the surface of, before roasting; <as>as, to <ex>lard</ex> poultry</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And <qex>larded</qex> thighs on loaded altars laid.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To fatten; to enrich.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[The oak] with his nuts <qex>larded</qex> many a swine.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Falstaff sweats to death.<br/
And <qex>lards</qex> the lean earth as he walks along.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To smear with lard or fat.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In his buff doublet <qex>larded</qex> o'er with fat<br/
Of slaughtered brutes.</q> <rj><qau>Somerville.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To mix or garnish with something, as by way of improvement; to interlard.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Let no alien Sedley interpose<br/
To <qex>lard</qex> with wit thy hungry Epsom prose.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lard</ent><br/
<hw>Lard</hw> <pr>(l<aum/rd)</pr>, <pos>v. i.</pos> <def>To grow fat.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lardacein</ent><br/
<hw>Lar`da*ce"in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lardaceous</er>.]</ety> <fld>(Physiol. Chem.)</fld> <def>A peculiar amyloid substance, colored blue by iodine and sulphuric acid, occurring mainly as an abnormal infiltration into the spleen, liver, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lardaceous</ent><br/
<hw>Lar*da"ceous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>lardac<eacute/</ets>.]</ety> <def>Consisting of, or resembling, lard.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><cd>Lardaceous degeneration</cd> <fld>(Med.)</fld>, <cd>amyloid degeneration.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larder</ent><br/
<hw>Lard"er</hw> <pr>(l<aum/rd"<etil/r)</pr>, <pos>n.</pos> <ety>[OF. <ets>lardier</ets>. See <er>Lard</er>, <pos>n.</pos>]</ety> <def>A room or place where meat and other articles of food are kept before they are cooked.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larderer</ent><br/
<hw>Lard"er*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One in charge of the larder.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lardery</ent><br/
<hw>Lard"er*y</hw>, <pos>n.</pos> <ety>[Cf. OE. <ets>larderie</ets>.]</ety> <def>A larder.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lardoon</ent><br/
<ent>Lardon</ent><br/
<mhw>{ <hw>Lar"don</hw> <pr>(?)</pr>, <hw>Lar*doon"</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>lardon</ets>, fr. <ets>lard</ets> lard.]</ety> <def>A bit of fat pork or bacon used in larding.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lardry</ent><br/
<hw>Lard"ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lardery</er>.]</ety> <def>A larder.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lardy</ent><br/
<hw>Lard"y</hw> <pr>(l<aum/rd"<ycr/)</pr>, <pos>a.</pos> <def>Containing, or resembling, lard; of the character or consistency of lard.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lare</ent><br/
<hw>Lare</hw> <pr>(l<acir/r)</pr>, <pos>n.</pos> <ety>[See <er>Lore</er>.]</ety> <def>Lore; learning.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lare</ent><br/
<hw>Lare</hw>, <pos>n.</pos> <def>Pasture; feed. See <er>Lair</er>.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lare</ent><br/
<hw>Lare</hw>, <pos>v. t.</pos> <def>To feed; to fatten.</def> <mark>[Obs.]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lares</ent><br/
\'d8<hw>La"res</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>See 1st <er>Lar</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Large</ent><br/
<hw>Large</hw> <pr>(l<aum/rj)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Larger</adjf> <pr>(l<aum/r"j<etil/r)</pr>; <pos>superl.</pos> <adjf>Largest</adjf>.]</amorph> <ety>[F., fr. L. <ets>largus</ets>.  Cf. <er>Largo</er>.]</ety> <sn>1.</sn> <def>Exceeding most other things of like kind in bulk, capacity, quantity, superficial dimensions, or number of constituent units; big; great; capacious; extensive; -- opposed to <ant>small</ant>; <as>as, a <ex>large</ex> horse; a <ex>large</ex> house or room; a <ex>large</ex> lake or pool; a <ex>large</ex> jug or spoon; a <ex>large</ex> vineyard; a <ex>large</ex> army; a <ex>large</ex> city.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ For linear dimensions, and mere extent, <xex>great</xex>, and not <xex>large</xex>, is used as a qualifying word; as, <xex>great</xex> length, breadth, depth; a <xex>great</xex> distance; a <xex>great</xex> height.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Abundant; ample; <as>as, a <ex>large</ex> supply of provisions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We have yet <qex>large</qex> day.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Full in statement; diffuse; full; profuse.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I might be very <qex>large</qex> upon the importance and advantages of education.</q> <rj><qau>Felton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Having more than usual power or capacity; having broad sympathies and generous impulses; comprehensive; -- said of the mind and heart.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Free; unembarrassed.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Of burdens all he set the Paynims <qex>large</qex>.</q> <rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Unrestrained by decorum; -- said of language.</def> <mark>[Obs.]</mark> <ldquo/Some <xex>large</xex> jests he will make.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Prodigal in expending; lavish.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Naut.)</fld> <def>Crossing the line of a ship's course in a favorable direction; -- said of the wind when it is abeam, or between the beam and the quarter.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>At large</b></col>. <sd>(a)</sd> <cd>Without restraint or confinement; <as>as, to go <ex>at large</ex>; to be left <ex>at large</ex></as>.</cd> <sd>(b)</sd> <cd>Diffusely; fully; in the full extent; <as>as, to discourse on a subject <ex>at large</ex></as>.</cd> -- <col><b>Common at large</b></col>. <cd>See under <er>Common</er>, <pos>n.</pos></cd> -- <mcol><col><b>Electors at large</b></col>, <col><b>Representative at large</b></col></mcol>, <cd>electors, or a representative, as in Congress, chosen to represent the whole of a State, in distinction from those chosen to represent particular districts in a State.</cd> <mark>[U. S.]</mark> -- <mcol><col><b>To give large</b></col>, <col><b>To go large</b></col>, <col><b>To run large</b></col>, <it>or</it> <col><b>To sail large</b></col></mcol> <fld>(Naut.)</fld>, <cd>to have the wind crossing the direction of a vessel's course in such a way that the sails feel its full force, and the vessel gains its highest speed. See <er>Large</er>, <pos>a.</pos>, 8.</cd></cs></p>

<p><syn><b>Syn.</b> -- Big; bulky; huge; capacious; comprehensive; ample; abundant; plentiful; populous; copious; diffusive; liberal.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Large</ent><br/
<hw>Large</hw>, <pos>adv.</pos> <def>Freely; licentiously.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Large</ent><br/
<hw>Large</hw>, <pos>n.</pos> <fld>(Mus.)</fld> <def>A musical note, formerly in use, equal to two longs, four breves, or eight semibreves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Large-acred</ent><br/
<hw>Large"-a`cred</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Possessing much land.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Large-handed</ent><br/
<hw>Large"-hand`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having large hands.</def> <mark>(Fig.)</mark>: <def>Taking, or giving, in large quantities; rapacious or bountiful.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Large-hearted</ent><br/
<hw>Large"-heart`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a large or generous heart or disposition; noble; liberal.</def> -- <wordforms><wf>Large"-heart`ed*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Largely</ent><br/
<hw>Large"ly</hw>, <pos>adv.</pos> <def>In a large manner.</def>  <rj><au>Dryden.</au>  <au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Largeness</ent><br/
<hw>Large"ness</hw>, <pos>n.</pos> <def>The quality or state of being large.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>large-scale</ent><br/
<hw>large-scale</hw> <pos>adj.</pos> <sn>1.</sn>  <def>large in area, scope or degree; <as>as, a <ex>large-scale</ex> attack on AIDS is needed</as>.</def><br/
<syn><b>Syn. --</b> extensive, wide-ranging.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>constructed or drawn to a big scale{4}; <as>as, <ex>large-scale</ex> maps</as>.  See 3rd <er>scale</er>, <pos>n.</pos>, sense 4.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn>  <def>widespread; applying to all or most members of a category or group.</def><br/
<syn><b>Syn. --</b> mass.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Largesse</ent><br/
<ent>Largess</ent><br/
<mhw>{ <hw>Lar"gess</hw>, <hw>Lar"gesse</hw> <pr>(l<aum/r*j<ecr/s" <it>or</it>  l<aum/r"j<ecr/s)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>largesse</ets>, fr. <ets>large</ets>. See <er>Large</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>Liberality; generosity; bounty.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Fulfilled of <qex>largesse</qex> and of all grace.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A present; a gift; a bounty bestowed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The heralds finished their proclamation with their usual cry of <ldquo/<qex>Largesse</qex>, <qex>largesse</qex>, gallant knights!<rdquo/ and gold and silver pieces were showered on them from the galleries.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>largest</ent><br/
<hw>largest</hw> <pos>adj.</pos> <sn>1.</sn>  <def>greatest in size of those under consideration.</def><br/
<syn><b>Syn. --</b> biggest, greatest.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>maximal.</def><br/
<syn><b>Syn. --</b> outside.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Larget</ent><br/
<hw>Lar"get</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>larget</ets>.]</ety> <def>A short piece of bar iron for rolling into a sheet; a small billet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larghetto</ent><br/
\'d8<hw>Lar*ghet"to</hw> <pr>(?)</pr>, <pos>a. & adv.</pos> <ety>[It., dim. of <ets>largo</ets> largo.]</ety> <fld>(Mus.)</fld> <def>Somewhat slow or slowly, but not so slowly as <contr>largo</contr>, and rather more so than <contr>andante</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Largifical</ent><br/
<hw>Lar*gif"i*cal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>largificus</ets>; <ets>largus</ets> large + <ets>facere</ets>.]</ety> <def>Generous; ample; liberal.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Largifluous</ent><br/
<hw>Lar*gif"lu*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>largifluus</ets>; <ets>large</ets> abundantly + <ets>fluere</ets> to flow.]</ety> <def>Flowing copiously.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Largiloquent</ent><br/
<hw>Lar*gil"o*quent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. L. <ets>largiloquus</ets>.]</ety> <def>Grandiloquent.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Largish</ent><br/
<hw>Lar"gish</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Somewhat large.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Largition</ent><br/
<hw>Lar*gi"tion</hw> <pr>(?)</pr>, <ety>[L. <ets>largitio</ets>, fr. <ets>largiri</ets>, p. p. <ets>largitus</ets>, to give bountifully.]</ety> <def>The bestowment of a largess or gift.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Largo</ent><br/
\'d8<hw>Lar"go</hw> <pr>(?)</pr>, <pos>a. & adv.</pos> <ety>[It., large, L. <ets>largus</ets>, See <er>Large</er>.]</ety> <fld>(Mus.)</fld> <def>Slow or slowly; -- more so than <contr>adagio</contr>; next in slowness to <contr>grave</contr>, which is also weighty and solemn.</def> -- <def2><pos>n.</pos> <def>A movement or piece in <ex>largo</ex> time.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lari</ent><br/
<hw>Lari</hw> <pos>prop. n.</pos> <def>A suborder of birds including the gulls; terns; jaegers; and skimmers.</def><br/
<syn><b>Syn. --</b> suborder <subord>Lari</subord>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lariat</ent><br/
<hw>Lar"i*at</hw> <pr>(l<acr/r"<icr/*<acr/t)</pr>, <pos>n.</pos> <ety>[Sp. <ets>la reata</ets> the rope; <ets>la</ets> the + <ets>reata</ets> rope.  Cf. <er>Reata</er>.]</ety> <def>A long, slender rope made of hemp or strips of hide, esp. one with a noose; -- used as a lasso for catching cattle, horses, etc., and for picketing a horse so that he can graze without wandering.</def> <mark>[Mexico & Western U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 831 --></p>

<p><ent>Lariat</ent><br/
<hw>Lar"i*at</hw> <pr>(l<acr/r"<icr/*<acr/t)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lariated</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Lariating</conjf>.]</vmorph> <def>To secure with a lariat fastened to a stake, as a horse or mule for grazing; also, to lasso or catch with a lariat.</def> <mark>[Western U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laridae</ent><br/
<hw>Laridae</hw> <pos>prop. n.</pos> <def>The natural family of birds including the gulls and terns; the gull family.</def><br/
<syn><b>Syn. --</b> family <fam>Laridae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Larine</ent><br/
<hw>La"rine</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the Gull family (<fam>Larid<ae/</fam>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larix</ent><br/
<hw>Larix</hw> <pos>prop. n.</pos> <def>The genus of trees comrising the larches.</def><br/
<syn><b>Syn. --</b> genus <gen>Larix</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Larixinic</ent><br/
<hw>Lar`ix*in"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of, or derived from, the larch (<gen>Larix</gen>); <as>as, <ex>larixinic</ex> acid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lark</ent><br/
<hw>Lark</hw> <pr>(l<aum/rk)</pr>, <pos>n.</pos> <ety>[Perh fr. AS. <ets>l<amac/c</ets> play, sport.  Cf. <er>Lake</er>, <pos>v. i.</pos>]</ety> <def>A frolic; a jolly time.</def> <mark>[Colloq.]</mark> <au>Dickens.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lark</ent><br/
<hw>Lark</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Larked</conjf> <pr>(l<aum/rkt)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Larking</conjf>.]</vmorph> <def>To sport; to frolic.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lark</ent><br/
<hw>Lark</hw>, <pos>n.</pos> <ety>[OE. <ets>larke</ets>, <ets>laverock</ets>, AS. <ets>l<amac/werce</ets>; akin to D. <ets>leeuwerik</ets>, LG. <ets>lewerke</ets>, OHG. <ets>l<emac/rahha</ets>, G. <ets>lerche</ets>, Sw. <ets>l<aum/rka</ets>, Dan. <ets>lerke</ets>, Icel. <ets>l<ae/virki</ets>.]</ety> <fld>(Zool.)</fld> <def>Any one numerous species of singing birds of the genus <gen>Alauda</gen> and allied genera (family <fam>Alaudid<ae/</fam>). They mostly belong to Europe, Asia, and Northern Africa.  In America they are represented by the shore larks, or horned larks, of the genus <gen>Otocoris</gen>. The true larks have holaspidean tarsi, very long hind claws, and, usually, dull, sandy brown colors.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The European skylark, or lark of the poets (<spn>Alauda arvensis</spn>), is of a brown mottled color, and is noted for its clear and sweet song, uttered as it rises and descends almost perpendicularly in the air. It is considered a table delicacy, and immense numbers are killed for the markets. Other well-known European species are the crested, or tufted, lark (<spn>Alauda cristata</spn>), and the wood lark (<spn>Alauda arborea</spn>).  The pipits, or titlarks, of the genus <gen>Anthus</gen> (family <fam>Motacillid<ae/</fam>) are often called larks. See <er>Pipit</er>. The American meadow larks, of the genus <gen>Sturnella</gen>, are allied to the starlings. See <er>Meadow Lark</er>. The Australian bush lark is <spn>Mirafra Horsfieldii</spn>. See <er>Shore lark</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lark bunting</b></col> <fld>(Zool.)</fld>, <cd>a fringilline bird (<spn>Calamospiza melanocorys</spn>) found on the plains of the Western United States.</cd> -- <col><b>Lark sparrow</b></col> <fld>(Zool.)</fld>, <cd>a sparrow (<spn>Chondestes grammacus</spn>), found in the Mississippi Valley and the Western United States.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lark</ent><br/
<hw>Lark</hw>, <pos>v. i.</pos> <def>To catch larks; <as>as, to go <ex>larking</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lark-colored</ent><br/
<hw>Lark"-col`ored</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having the sandy brown color of the European larks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larker</ent><br/
<hw>Lark"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See 3d <er>Lark</er>, for sense 1, and 1st <er>Lark</er>, for sense 2.]</ety> <sn>1.</sn> <def>A catcher of larks.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who indulges in a lark or frolic.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lark's-heel</ent><br/
<hw>Lark's"-heel`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>Indian cress.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larkspur</ent><br/
<hw>Lark"spur</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A genus of ranunculaceous plants (<gen>Delphinium</gen>), having showy flowers, and a spurred calyx.  They are natives of the North Temperate zone.  The commonest larkspur of the gardens is <spn>Delphinium Consolida</spn>.  The flower of the bee larkspur (<spn>Delphinium elatum</spn>) has two petals bearded with yellow hairs, and looks not unlike a bee.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larmier</ent><br/
<hw>Lar"mi*er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. <ets>larme</ets> tear, drop, L. <ets>lacrima</ets>. See <er>Lachrymose</er>.]</ety> <fld>(Anat.)</fld> <def>See <er>Tearpit</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laroid</ent><br/
<hw>La"roid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Larus</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Like or belonging to the Gull family (<fam>Larid<ae/</fam>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larrikin</ent><br/
<hw>Lar"ri*kin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. E. dial. <ets>larrikin</ets>  a mischievous or frolicsome youth, <ets>larrick</ets> lively, careless, <ets>larack</ets> to frolic, to romp.]</ety> <def>A rowdy street loafer; a rowdyish or noisy ill-bred fellow; a hoodlum; -- variously applied, as to a street blackguard, a street Arab, a youth given to horse-play, etc.</def> <mark>[Australia & Eng.]</mark> -- <def2><pos>a.</pos>  <def>Rowdy; rough; disorderly.</def> <mark>[Australia & Eng.]</mark></def2></p>

<p><q>Mobs of unruly <qex>larrikins</qex>.</q>  <rj><qau>Sydney Daily Telegraph.</qau></rj></p>

<p><note><hand/ <xex>Larrikin</xex> is often popularly explained by the following anecdote (which is without foundation): An Irish policeman at Melbourne, on bringing a notorious rough into court, was asked by the magistrate what the prisoner had been doing, and replied, <ldquo/He was <xex>a-larrikin'</xex> [i. e., a-larking] about the streets.<rdquo/</note><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Larrup</ent><br/
<hw>Lar"rup</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Larruped</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Larruping</conjf>.]</vmorph> <ety>[Perh, a corrupt. of <ets>lee rope</ets>, used by sailors in beating the boys; but cf. D. <ets>larpen</ets> to thresh, <ets>larp</ets> a whip, blow.]</ety> <def>To beat or flog soundly.</def> <mark>[Prov. Eng. & Colloq. U.S.]</mark>  <rj><au>Forby.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larry</ent><br/
<hw>Lar"ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Lorry</er>, or <er>Lorrie</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larum</ent><br/
<hw>Lar"um</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Alarum</er>, and <er>Alarm</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larva</ent><br/
<ent>Larvae</ent><br/
<hw>Lar"va</hw> <pr>(l<aum/r"v<adot/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Larv<ae/</plw> <pr>(l<aum/r"v<ae/)</pr>, E. <plw>Larvas</plw> <pr>(l<aum/r"v<adot/z)</pr>.</plu> <ety>[L. <ets>larva</ets> ghost, specter, mask.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <def>Any young insect from the time that it hatches from the egg until it becomes a pupa, or chrysalis. During this time it usually molts several times, and may change its form or color each time.  The larv<ae/ of many insects are much like the adults in form and habits, but have no trace of wings, the rudimentary wings appearing only in the pupa stage.  In other groups of insects the larv<ae/ are totally unlike the parents in structure and habits, and are called <stype>caterpillars</stype>, <stype>grubs</stype>, <stype>maggots</stype>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The early, immature form of any animal when more or less of a metamorphosis takes place, before the assumption of the mature shape.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larvacea</ent><br/
<hw>Larvacea</hw> <pos>prop. n.</pos> <def>A class sometimes classified as an order.</def><br/
<syn><b>Syn. --</b> class <class>Larvacea</class>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>larval</ent><br/
<hw>lar"val</hw> <pr>(l<aum/r"v<ait/l)</pr>, <pos>a.</pos> <ety>[L. <ets>larvalis</ets> ghostly. See <er>Larva</er>.]</ety> <fld>(Zool.)</fld> <def>Of or pertaining to a larva.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larvalia</ent><br/
\'d8<hw>Lar*va"li*a</hw> <pr>(?)</pr>, <pos>prop. n. pl.</pos> <ety>[NL. See <er>Larval</er>.]</ety> <fld>(Zool.)</fld> <def>An order of <subphylum>Tunicata</subphylum>, including <gen>Appendicularia</gen>, and allied genera; -- so called because certain larval features are retained by them through life. Called also <altname>Copelata</altname>. See <er>Appendicularia</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larvate</ent><br/
<hw>Lar"vate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>larva</ets> mask.]</ety> <def>Masked; hence, concealed; obscure; -- applied in medicine to doubtful cases of some diseases; <as>as, <ex>larvate</ex> pneumonis; <ex>larvate</ex> epilepsy</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Larvated</ent><br/
<hw>Lar"va*ted</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>larvatus</ets> bewitched. See <er>Larva</er>.]</ety> <def>Masked; clothed as with a mask.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larve</ent><br/
<hw>Larve</hw> <pr>(l<aum/rv)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Larves</plw> <pr>(l<aum/rvz)</pr>.</plu> <ety>[F.]</ety> <def>A larva.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larviform</ent><br/
<hw>Lar"vi*form</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Larva</ets> + <ets>-form</ets>.]</ety> <fld>(Zool.)</fld> <def>Having the form or structure of a larva.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Larviparous</ent><br/
<hw>Lar*vip"a*rous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Larva</ets> + L. <ets>parete</ets> to bring forth.]</ety> <fld>(Zool.)</fld> <def>Depositing living larv<ae/, instead of eggs; -- said of certain insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lary</ent><br/
<hw>La"ry</hw> <pr>(l<amac/"r<ycr/)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lare</ets> sea gull, L. <ets>larus</ets> a sort of sea bird, Gr. <grk>la`ros</grk>.]</ety> <def>A guillemot; -- called also <altname>lavy</altname>.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngeal</ent><br/
<hw>Lar`yn*ge"al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Larynx</er>.]</ety> <def>Of or pertaining to the larynx; adapted to operations on the larynx; <as>as, <ex>laryngeal</ex> forceps</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngean</ent><br/
<hw>Lar`yn*ge"an</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See <er>Laryngeal</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngectomy</ent><br/
<hw>Lar`yn*gec"to*my</hw> <pr>(?)</pr>, <pos>n.</pos>  <ety>[<ets>Larynx</ets> + Gr. <?/ to cut out.]</ety> <fld>(Surg.)</fld> <def>Excision of the larynx.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Laryngismus</ent><br/
\'d8<hw>Lar`yn*gis"mus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>laryggismo`s</grk> a croaking. See <er>Larynx</er>.]</ety> <fld>(Med.)</fld> <def>A spasmodic state of the glottis, giving rise to contraction or closure of the opening.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngitis</ent><br/
\'d8<hw>Lar`yn*gi"tis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Larynx</er>, and <er>-tis</er>.]</ety> <fld>(Med.)</fld> <def>Inflammation of the larynx.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngograph</ent><br/
<hw>La*ryn"go*graph</hw> <pr>(?)</pr>, <pos>n.</pos>  <ety>[<ets>larynx</ets> + <ets>-graph</ets>.]</ety> <def>An instrument for recording the larynx movements in speech.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Laryngological</ent><br/
<hw>La*ryn`go*log"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to laryngology.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngologist</ent><br/
<hw>Lar`yn*gol"o*gist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who applies himself to laryngology.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngology</ent><br/
<hw>Lar`yn*gol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Larynx</ets> + <ets>-logy</ets>.]</ety> <def>Systematized knowledge of the action and functions of the larynx; in pathology, the department which treats of the diseases of the larynx.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngophony</ent><br/
<hw>Lar`yn*goph"o*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Larynx</ets> + Gr. (<?/) voice.]</ety> <def>The sound of the voice as heard through a stethoscope when the latter is placed upon the larynx.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngoscope</ent><br/
<hw>La*ryn"go*scope</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Larynx</ets> + <ets>-scope</ets>.]</ety> <sn>1.</sn> <fld>(Surg.)</fld> <def>An instrument, consisting of an arrangement of two mirrors, for reflecting light upon the larynx, and for examining its image.</def> <mark>[Archaic]</mark> <br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>A type of endoscope having a light source and lenses, permitting theviewing of a magnified image of the larynx.  It may be flexible or rigid.</def><br/
[<source>PJC</source>]</p>

<p><ent>Laryngoscopic</ent><br/
<hw>La*ryn`go*scop"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to the inspection of the larynx; of or pertaining to the laryngoscope or laryngoscopy.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Laryngoscopist</ent><br/
<hw>Lar`yn*gos"co*pist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One skilled in laryngoscopy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngoscopy</ent><br/
<hw>Lar`yn*gos"co*py</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The art of using the laryngoscope; investigations made with the laryngoscope.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngotome</ent><br/
<hw>La*ryn"go*tome</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Surg.)</fld> <def>An instrument for performing laryngotomy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngotomy</ent><br/
<hw>Lar`yn*got"o*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. (<?/); (<?/), (<?/), the larynx + <grk>te`mnein</grk> to cut: cf. F. <ets>laryngotomie</ets>.]</ety> <fld>(Surg.)</fld> <def>The operation of cutting into the larynx, from the outside of the neck, for assisting respiration when obstructed, or for removing foreign bodies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laryngotracheal</ent><br/
<hw>La*ryn`go*tra"che*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Larynx</ets> + <ets>tracheal</ets>.]</ety> <fld>(Anat.)</fld> <def>Pertaining to both larynx and trachea; <as>as, the <ex>laryngotracheal</ex> cartilage in the frog</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>laryngotracheotomy</ent><br/
<hw>la*ryn`go*tra`che*ot"o*my</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Larynx</ets> + <ets>tracheotomy</ets>.]</ety> <fld>(Surg.)</fld> <def>The operation of cutting into the larynx and the upper part of the trachea, -- a frequent operation for obstruction to breathing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>larynx</ent><br/
<hw>lar"ynx</hw> <pr>(l<acr/r"<icr/<nsm/ks; 277)</pr>, <pos>n.</pos> <ety>[NL. from Gr. <grk>la`rygx</grk>, <grk>la`ryggos</grk>.]</ety> <fld>(Anat.)</fld> <def>The expanded upper end of the windpipe or trachea, connected with the hyoid bone or cartilage. It contains the vocal cords, which produce the voice by their vibrations, when they are stretched and a current of air passes between them.  The larynx is connected with the pharynx by an opening, the glottis, which, in mammals, is protected by a lidlike epiglottis.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the framework of the human larynx, the thyroid cartilage, attached to the hyoid bone, makes the protuberance on the front of the neck known as <xex>Adam's apple</xex>, and is articulated below to the ringlike cricoid cartilage. This is narrow in front and high behind, where, within the thyroid, it is surmounted by the two arytenoid cartilages, from which the vocal cords pass forward to be attached together to the front of the thyroid. See <er>Syrinx</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Las</ent><br/
<hw>Las</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A lace. See <er>Lace</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Las</ent><br/
<hw>Las</hw>, <pos>a. & adv.</pos> <def>Less.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lasagne</ent><br/
<ent>lasagna</ent><br/
<mhw><hw>lasagna</hw>, <hw>lasagne</hw></mhw> <pr>(l<adot/*z<adot/n"y<ucr/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A baked dish of layers of lasagna{2} pasta with sauce and cheese and meat or vegetables; -- a popular dish of Italian cuisine.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>large flat rectangular strips of pasta.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lascar</ent><br/
<hw>Las"car</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Per. & Hind. <ets>lashkar</ets> an army, an inferior artillery man, a cooly, a native sailor.]</ety> <def>A native sailor, employed in European vessels; also, a menial employed about arsenals, camps, camps, etc.; a camp follower.</def> <mark>[East Indies]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lascious</ent><br/
<hw>Las"ci*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Loose; lascivious.</def> <mark>[Obs.]</mark> <ldquo/To depaint <xex>lascious</xex> wantonness.<rdquo/  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lasciviency</ent><br/
<hw>las*civ"i*en*cy</hw> <pr>(l<acr/s*s<icr/v"<icr/*<eit/n*s<ycr/)</pr>, <pos>n.</pos> <ety>[See <er>Lascivient</er>.]</ety> <def>Lasciviousness; wantonness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lascivient</ent><br/
<hw>Las*civ"i*ent</hw> <pr>(l<acr/s*s<icr/v"<icr/*<eit/nt)</pr>, <pos>a.</pos> <ety>[L. <ets>lasciviens</ets>, pr. of <ets>lascivire</ets> to be wanton, fr. <ets>lascivus</ets>. See <er>Lascivious</er>.]</ety> <def>Lascivious.</def> <mark>[Obs.]</mark>  <rj><au>Dr. H. More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lascivious</ent><br/
<hw>Las*civ"i*ous</hw> <pr>(l<acr/s*s<icr/v"<icr/*<ucr/s)</pr>, <pos>a.</pos> <ety>[L. <ets>lascivia</ets> wantonness, fr. <ets>lascivus</ets> wanton; cf. Gr. <grk>la`stauros</grk> lecherous, <grk>lh^n</grk> to wish, Skr. <ets>lash</ets> to desire.]</ety> <sn>1.</sn> <def>Wanton; lewd; lustful; <as>as, <ex>lascivious</ex> men; <ex>lascivious</ex> desires.</as></def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Tending to produce voluptuous or lewd emotions.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He capers nimbly in a lady's chamber<br/
To the <qex>lascivious</qex> pleasing of a lute.</q> <rj><qau>Shak.</qau></rj></p>

<p>-- <wordforms><wf>Las*civ"i*ous*ly</wf>, <pos>adv.</pos> -- <wf>Las*civ"i*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>lasciviousness</ent><br/
<hw>las*civ"i*ous*ness</hw> <pos>n.</pos> <def>The state or habitual condition of feeling an excessive or morbid sexual desire.</def><br/
<syn><b>Syn. --</b> prurience, pruriency, carnality.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lase</ent><br/
<hw>lase</hw> <pr>(l<amac/z)</pr> <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>lased</conjf> <pr>(l<amac/zd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>lasing</conjf>.]</vmorph> <ety>[by back-formation from <er>laser</er>.  See <er>laser</er>.]</ety> <def>To give off a beam of coherent light; -- of a laser.</def><br/
[<source>PJC</source>]</p>

<p><ent>laser</ent><br/
<hw>laser</hw> <pos>n.</pos> <ety>[acronym from <ets>L</ets>ight <ets>A</ets>mplification by <ets>S</ets>timulated <ets>E</ets>mission of <ets>R</ets>adiation: ca. <fu>1955</fu>.]</ety> <def>A device which produces an intense, usually narrow, monochromatic beam of coherent light; called also <altname>optical maser</altname>.  It has various forms, and is used in various applications in science and technology.  The beam is produced by boosting the majority of the electrons in specific radiation-absorbing atoms in a medium into a higher energy level, from which they are stimulated by their own emitted radiation to drop back synchronously to their lower energy level, and emit light which is in phase (coherent).</def><br/
<syn><b>Syn. --</b> optical maser.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>laser beam</ent><br/
<hw>laser beam</hw> <pos>n.</pos> <def>A beam of light from a laser.</def><br/
[<source>PJC</source>]</p>

<p><ent>laser disk</ent><br/
<hw>laser disk</hw> <pos>n.</pos> <def>A digital data storage medium consisting of a thin disk onto which the data is impressed by a laser, in the form of a linear sequence of dots; same as <altname>optical disk</altname>.  The data is subsequently read back by the use of a laser beam.  See also <stype>compact disk</stype>.</def>  <note>The original disk may be created by use of a laser, but copies of the original disk may be created by a replicating process which does not itself require a laser.</note><br/
[<source>PJC</source>]</p>

<p><ent>laser light</ent><br/
<hw>laser light</hw> <pos>n.</pos> <def>Light produced by a laser.</def><br/
[<source>PJC</source>]</p>

<p><ent>laser printer</ent><br/
<hw>laser printer</hw> <pos>n.</pos> <def>A printer controlled by a computer, using a laser beam to produce images in a fine dot-matrix pattern of charge on an electrostatic drum, to which fine particles of ink are subsequently caused to adhere, and the image of which is subsequently transferred to paper or another type of material in sheet form.  It is capable of high-speed production of images with a higher resolution than those from dot-matrix impact printers.</def><br/
[<source>PJC</source>]</p>

<p><ent>laser surgery</ent><br/
<hw>laser surgery</hw> <pos>n.</pos> <fld>(Med.)</fld> <def>Surgery using lasers.</def><br/
[<source>PJC</source>]</p>

<p><ent>Laserwort</ent><br/
<hw>La"ser*wort`</hw> <pr>(l<amac/"s<etil/r*w<ucir/rt`)</pr>, <pos>n.</pos> <ety>[L. <ets>laser</ets> the juice of the laserwort.]</ety> <fld>(Bot.)</fld> <def>Any plant of the umbelliferous genus <gen>Laserpitium</gen>, of several species (as <spn>Laserpitium glabrum</spn>, and <spn>Laserpitium siler</spn>), the root of which yields a resinous substance of a bitter taste. The genus is mostly European.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lash</ent><br/
<hw>Lash</hw> <pr>(l<acr/sh)</pr>, <pos>n.</pos> <ety>[OE. <ets>lasche</ets>; cf. D. <ets>lasch</ets> piece set in, joint, seam, G. <ets>lashe</ets> latchet, a bit of leather, gusset, stripe, <ets>laschen</ets> to furnish with flaps, to lash or slap, Icel. <ets>laski</ets> gusset, flap, <ets>laska</ets> to break.]</ety> <sn>1.</sn> <def>The thong or braided cord of a whip, with which the blow is given.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I observed that your whip wanted a <qex>lash</qex> to it.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A leash in which an animal is caught or held; hence, a snare.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A stroke with a whip, or anything pliant and tough; <as>as, the culprit received thirty-nine <ex>lashes</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A stroke of satire or sarcasm; an expression or retort that cuts or gives pain; a cut.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The moral is a <qex>lash</qex> at the vanity of arrogating that to ourselves which succeeds well.</q> <rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A hair growing from the edge of the eyelid; an eyelash.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>In carpet weaving, a group of strings for lifting simultaneously certain yarns, to form the figure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lash</ent><br/
<hw>Lash</hw> <pr>(l<acr/sh)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lashed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lashng</conjf>.]</vmorph> <sn>1.</sn> <def>To strike with a lash; to whip or scourge with a lash, or with something like one.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We <qex>lash</qex> the pupil, and defraud the ward.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To strike forcibly and quickly, as with a lash; to beat, or beat upon, with a motion like that of a lash; <as>as, a whale <ex>lashes</ex> the sea with his tail</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And big waves <qex>lash</qex> the frighted shores.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To throw out with a jerk or quickly.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He falls, and <qex>lashing</qex> up his heels, his rider throws.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To scold; to berate; to satirize; to censure with severity; <as>as, to <ex>lash</ex> vice</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lash</ent><br/
<hw>Lash</hw>, <pos>v. i.</pos> <def>To ply the whip; to strike; to utter censure or sarcastic language.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To laugh at follies, or to <qex>lash</qex> at vice.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To lash out</b></col>, <cd>to strike out wildly or furiously; also used figuratively.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lash</ent><br/
<hw>Lash</hw>, <pos>v. t.</pos> <ety>[Cf. D. <ets>lasschen</ets> to fasten together, <ets>lasch</ets> piece, joint, Sw. <ets>laska</ets> to stitch, Dan. <ets>laske</ets> stitch. See <er>Lash</er>, <pos>n.</pos> ]</ety> <def>To bind with a rope, cord, thong, or chain, so as to fasten; <as>as, to <ex>lash</ex> something to a spar; to <ex>lash</ex> a pack on a horse's back.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasher</ent><br/
<hw>Lash"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who whips or lashes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasher</ent><br/
<hw>Lash"er</hw>, <pos>n.</pos> <sn>1.</sn> <def>A piece of rope for binding or making fast one thing to another; -- called also <altname>lashing</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A weir in a river.</def> <mark>[Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lashing</ent><br/
<hw>Lash"ing</hw>, <pos>n.</pos> <def>The act of one who, or that which, lashes; castigation; chastisement.</def>  <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lashing out</b></col>, <cd>a striking out; also, extravagance.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lashing</ent><br/
<hw>Lash"ing</hw>, <pos>n.</pos> <def>See 2d <er>Lasher</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lasiocampid</ent><br/
<hw>lasiocampid</hw> <pos>n.</pos> <def>A member of the <fam>Lasiocampidae</fam>, a family of medium-sized stout-bodied neutral-colored moth with comblike antennae.</def><br/
<syn><b>Syn. --</b> lasiocampid moth.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lasiocampidae</ent><br/
<hw>Lasiocampidae</hw> <pos>n.</pos> <def>A natural family of moths whose larvae include the tent caterpillars; the eggars; the lappet moths.</def><br/
<syn><b>Syn. --</b> family <fam>Lasiocampidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lask</ent><br/
<hw>Lask</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A diarrhea or flux.</def> <mark>[Obs.]</mark>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasket</ent><br/
<hw>Las"ket</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Lash</er>, <er>Latching</er>.]</ety> <fld>(Naut.)</fld> <def>latching.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lass</ent><br/
<hw>Lass</hw> <pr>(l<adot/s)</pr>, <pos>n.</pos> <ety>[OE. <ets>lasse</ets>; prob. of Celtic origin; cf. W. <ets>llodes</ets> girl, fem. of <ets>llawd</ets> lad.  <root/123.  See <er>Lad</er> a youth.]</ety> <def>A young woman; a girl; a sweetheart.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasse</ent><br/
<hw>Lasse</hw> <pr>(l<acr/s)</pr>, <pos>a. & adv.</pos> <def>Less.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lassie</ent><br/
<hw>Las"sie</hw> <pr>(l<acr/s"s<icr/)</pr>, <pos>n.</pos> <def>A young girl; a lass.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lassitude</ent><br/
<hw>Las"si*tude</hw> <pr>(l<acr/s"s<icr/*t<umac/d)</pr>, <pos>n.</pos> <ety>[L. <ets>lassitudo</ets>, fr. <ets>lassus</ets> faint, weary; akin to E. <ets>late</ets>: cf. F. <ets>lassitude</ets>. See <er>Late</er>.]</ety> <def>A condition of the body, or mind, when its voluntary functions are performed with difficulty, and only by a strong exertion of the will; languor; debility; weariness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The corporeal instruments of action being strained to a high pitch . . . will soon feel a <qex>lassitude</qex>.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasslorn</ent><br/
<hw>Lass"lorn`</hw> <pr>(l<adot/s"l<ocir/rn`)</pr>, <pos>a.</pos> <def>Forsaken by a lass.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasso</ent><br/
<hw>Lass"o</hw> <pr>(l<acr/s"s<osl/)</pr> <pos>n.</pos>; <plu><it>pl.</it> <plw>Lassos</plw> <pr>(-s<omac/z)</pr>.</plu> <ety>[Sp. <ets>lazo</ets>, L. <ets>laqueus</ets>. See <er>Lace</er>.]</ety> <def>A rope or long thong of leather with a running noose, used for catching horses, cattle, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lasso cell</b></col> <fld>(Zool.)</fld>, <cd>one of a peculiar kind of defensive and offensive stinging cells, found in great numbers in all c<oe/lenterates, and in a few animals of other groups.  They are most highly developed in the tentacles of jellyfishes, hydroids, and Actini<ae/.  Each of these cells is filled with, fluid, and contains a long, slender, often barbed, hollow thread coiled up within it. When the cell contracts the thread is quickly ejected, being at the same time turned inside out.  The thread is able to penetrate the flesh of various small, soft-bodied animals, and carries a subtle poison by which they are speedily paralyzed and killed.  The threads, at the same time, hold the prey in position, attached to the tentacles.  Some of the jellyfishes, as the Portuguese man-of-war, and <gen>Cyanea</gen>, are able to penetrate the human skin, and inflict painful stings in the same way.  Called also <altname>nettling cell</altname>, <altname>cnida</altname>, <altname>cnidocell</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasso</ent><br/
<hw>Las"so</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lassoed</conjf> <pr>(l<acr/s"s<osl/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lassoing</conjf>.]</vmorph> <def>To catch with a lasso.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Last</ent><br/
<hw>Last</hw> <pr>(l<adot/st)</pr>, <pos>3d pers. sing. pres.</pos> <def>of <er>Last</er>, to endure, contracted from <sig>lasteth</sig>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Last</ent><br/
<hw>Last</hw> <pr>(l<adot/st)</pr>, <pos>a.</pos> <ety>[OE. <ets>last</ets>, <ets>latst</ets>, contr. of <ets>latest</ets>, superl. of <ets>late</ets>; akin to OS. <ets>lezt</ets>, <ets>lazt</ets>, <ets>last</ets>, D. <ets>laatst</ets>, G. <ets>letzt.</ets> See <er>Late</er>, and cf. <er>Latest</er>.]</ety> <sn>1.</sn> <def>Being after all the others, similarly classed or considered, in time, place, or order of succession; following all the rest; final; hindmost; farthest; <as>as, the <ex>last</ex> year of a century; the <ex>last</ex> man in a line of soldiers; the <ex>last</ex> page in a book; his last chance</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Also day by day, from the first day unto the <qex>last</qex> day, he read in the book of the law of God.</q> <rj><qau>Neh. viii. 18.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Fairest of stars, <qex>last</qex> in the train of night.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Next before the present; <as>as, I saw him <ex>last</ex> week</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Supreme; highest in degree; utmost.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Contending for principles of the <qex>last</qex> importance.</q> <rj><qau>R. Hall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Lowest in rank or degree; <as>as, the a <ex>last</ex> place finish</as>.</def>  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Farthest of all from a given quality, character, or condition; most unlikely; having least fitness; <as>as, he is the <ex>last</ex> person to be accused of theft</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 832 --></p>

<p><cs><col><b>At last</b></col>, <cd>at the end of a certain period; after delay.</cd> <ldquo/The duke of Savoy felt that the time had <xex>at last</xex> arrived.<rdquo/ <au>Motley.</au> -- <col><b>At the last</b></col>. <ety>[Prob. fr. AS. <ets>on l<amac/ste</ets> behind, following behind, fr. <ets>l<amac/st</ets> race, track, footstep. See <er>Last</er> mold of the foot.]</ety> <cd>At the end; in the conclusion.</cd> <mark>[Obs.]</mark> <ldquo/Gad, a troop shall overcome him; but he shall overcome <xex>at the last</xex>.<rdquo/ <au>Gen. xlix. 19.</au> -- <col><b>Last heir</b></col>, <cd>the person to whom lands escheat for lack of an heir.</cd> <mark>[Eng.]</mark> <au>Abbott.</au> -- <col><b>On one's last legs</b></col>, <cd>at, or near, the end of one's resources; hence, on the verge of failure or ruin, especially in a financial sense.</cd> <mark>[Colloq.]</mark> -- <col><b>To breathe one's last</b></col>, <cd>to die.</cd> -- <col><b>To the last</b></col>, <cd>to the end; till the conclusion.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>And blunder on in business <qex>to the last</qex>.</q> <rj><qau>Pope.</qau></rj></p>

<p><syn><b>Syn.</b> -- <er>At Last</er>, <er>At Length</er>.</syn> <usage> These phrases both denote that some delayed end or result has been reached. <xex>At length</xex> implies that a long period was spent in so doing; as, after a voyage of more than three months, we <xex>at Length</xex> arrived safe. <xex>At last</xex> commonly implies that something has occurred (as interruptions, disappointments, etc.) which leads us to emphasize the idea of having reached the end; as, in spite of every obstacle, we have <xex>at last</xex> arrived.</usage><-- "eventually" also suggests a (relatively) long interval, but does not specifically imply any interruptions --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Last</ent><br/
<hw>Last</hw> <pr>(l<adot/st)</pr>, <pos>adv.</pos> <ety>[See <er>Last</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>At a time or on an occasion which is the latest of all those spoken of or which have occurred; the last time; <as>as, I saw him <ex>last</ex> in New York</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In conclusion; finally; lastly.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Pleased with his idol, he commends, admires,<br/
Adores; and, <qex>last</qex>, the thing adored desires.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>At a time next preceding the present time.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How long is't now since <qex>last</qex> yourself and I<br/
Were in a mask ?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Last</ent><br/
<hw>Last</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lasted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Lasting</conjf>.]</vmorph> <ety>[OE. <ets>lasten</ets>, As. <ets>l<ae/stan</ets> to perform, execute, follow, last, continue, fr. <ets>l<amac/st</ets>, <ets>l<aemac/st</ets>, trace, footstep, course; akin to G. <ets>leisten</ets> to perform, Goth. <ets>laistjan</ets> to follow. See <er>Last</er> mold of the foot.]</ety> <sn>1.</sn> <def>To continue in time; to endure; to remain in existence.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[I] proffered me to be slave in all that she me would ordain while my life <qex>lasted</qex>.</q> <rj><qau>Testament of Love.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To endure use, or continue in existence, without impairment or exhaustion; <as>as, this cloth <ex>lasts</ex> better than that; the fuel will <ex>last</ex> through the winter.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Last</ent><br/
<hw>Last</hw>, <pos>n.</pos> <ety>[AS. <ets>l<amac/st</ets> trace, track, footstep; akin to D. <ets>leest</ets> a last, G. <ets>leisten</ets>, Sw. <ets>l<aum/st</ets>, Dan. <ets>l<ae/st</ets>, Icel. <ets>leistr</ets> the foot below the ankle, Goth. <ets>laists</ets> track, way; from a root signifying, to go.  Cf. <er>Last</er>, <pos>v. i.</pos>, <er>Learn</er>, <er>Delirium</er>.]</ety> <def>A wooden block shaped like the human foot, on which boots and shoes are formed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The cobbler is not to go beyond his <qex>last</qex>.</q> <rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Darning last</b></col>, <cd>a smooth, hard body, often egg-shaped, put into a stocking to preserve its shape in darning.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Last</ent><br/
<hw>Last</hw>, <pos>v. t.</pos> <def>To shape with a last; to fasten or fit to a last; to place smoothly on a last; <as>as, to <ex>last</ex> a boot</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Last</ent><br/
<hw>Last</hw>, <pos>n.</pos> <ety>[As. <ets>hl<ae/st</ets>, fr. <ets>hladan</ets> to lade; akin to OHG. <ets>hlast</ets>, G., D., Dan., & Sw. <ets>last</ets>: cf. F. <ets>laste</ets>, <ets>last</ets>, a last, of German or Dutch origin. See <er>Lade</er>.]</ety> <sn>1.</sn> <def>A load; a heavy burden; hence, a certain weight or measure, generally estimated at 4,000 lbs., but varying for different articles and in different countries. In England, a <ex>last</ex> of codfish, white herrings, meal, or ashes, is twelve barrels; a <ex>last</ex> of corn, ten quarters, or eighty bushels, in some parts of England, twenty-one quarters; of gunpowder, twenty-four barrels, each containing 100 lbs; of red herrings, twenty cades, or 20,000; of hides, twelve dozen; of leather, twenty dickers; of pitch and tar, fourteen barrels; of wool, twelve sacks; of flax or feathers, 1,700 lbs.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The burden of a ship; a cargo.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lastage</ent><br/
<hw>Last"age</hw> <pr>(?)</pr> <pos>n.</pos> <ety>[E. <ets>lestage</ets> ballasting, fr. <ets>lest</ets> ballast, or LL. <ets>lastagium</ets>, <ets>lestagium</ets>. See <er>Last</er> a load.]</ety> <sn>1.</sn> <def>A duty exacted, in some fairs or markets, for the right to carry things where one will.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tax on wares sold by the last.</def> <mark>[Obs.]</mark>  <rj><au>Cowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The lading of a ship; also, ballast.</def>  <rj><au>Spelman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Room for stowing goods, as in a ship.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laste</ent><br/
<hw>Last"e</hw> <pr>(?)</pr>, <mark>obs.</mark> <def><pos>imp.</pos> of <er>Last</er>, to endure.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laster</ent><br/
<hw>Last"er</hw>, <pos>n.</pos> <def>A workman whose business it is to shape boots or shoes, or place leather smoothly, on lasts; a tool for stretching leather on a last.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lastery</ent><br/
<hw>Last"er*y</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A red color.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasthenia</ent><br/
<hw>Lasthenia</hw> <pos>prop. n.</pos> <def>A small genus of herbs of the Pacific coast of North and South America.</def><br/
<syn><b>Syn. --</b> genus <gen>Lasthenia</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lasting</ent><br/
<hw>Last"ing</hw>, <pos>a.</pos> <def>Existing or continuing a long while; enduring; <as>as, a <ex>lasting</ex> good or evil; a <ex>lasting</ex> color.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Durable; permanent; undecaying; perpetual; unending.</syn> <usage> -- <er>Lasting</er>, <er>Permanent</er>, <er>Durable</er>. <xex>Lasting</xex> commonly means merely continuing in existence; <xex>permanent</xex> carries the idea of continuing in the same state, position, or course; <xex>durable</xex> means lasting in spite of agencies which tend to destroy.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lasting</ent><br/
<hw>Last"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>Continuance; endurance.</def>  <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A species of very durable woolen stuff, used for women's shoes; everlasting.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The act or process of shaping on a last.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lastingly</ent><br/
<hw>Last"ing*ly</hw>, <pos>adv.</pos> <def>In a lasting manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lastingness</ent><br/
<hw>lastingness</hw> <pos>n.</pos> <def>permanence by virtue of the power to resist stress or force.</def><br/
<syn><b>Syn. --</b> durability, enduringness, strength.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lastly</ent><br/
<hw>Last"ly</hw>, <pos>adv.</pos> <sn>1.</sn> <def>In the last place; in conclusion.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>at last; finally.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lastreopsis</ent><br/
<hw>Lastreopsis</hw> <pos>prop. n.</pos> <def>A genus of tropical terrestrial shield ferns.</def><br/
<syn><b>Syn. --</b> genus <gen>Lastreopsis</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lat</ent><br/
<hw>Lat</hw> <pr>(l<acr/t)</pr>, <pos>v. t.</pos> <def>To let; to allow.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latah</ent><br/
<ent>Lata</ent><br/
<mhw>{ <hw>La"ta</hw>, <hw>La"tah</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Malay.]</ety> <def>A convulsive tic or hysteric neurosis prevalent among Malays, similar to or identical with miryachit and jumping disease, the person affected performing various involuntary actions and making rapid inarticulate ejaculations in imitation of the actions and words of another person.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Latakia</ent><br/
<hw>Lat`a*ki"a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Turk.]</ety> <def>A superior quality of Turkish smoking tobacco, so called from the place where produced, the ancient Laodicea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latch</ent><br/
<hw>Latch</hw> <pr>(l<acr/ch)</pr>, <pos>v. t.</pos> <ety>[Cf. F. <ets>l<eacute/cher</ets> to lick (of German origin).  Cf. <er>Lick</er>.]</ety> <def>To smear; to anoint.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latch</ent><br/
<hw>Latch</hw>, <pos>n.</pos> <ety>[OE. <ets>lacche</ets>, fr. <ets>lacchen</ets> to seize, As. <ets>l<ae/ccan</ets>.]</ety> <sn>1.</sn> <def>That which fastens or holds; a lace; a snare.</def> <mark>[Obs.]</mark>  <rj><au>Rom. of R.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A movable piece which holds anything in place by entering a notch or cavity; specifically, the catch which holds a door or gate when closed, though it be not bolted.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <def>A latching.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A crossbow.</def> <mark>[Obs.]</mark>  <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latch</ent><br/
<hw>Latch</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Latched</conjf> <pr>(l<acr/cht)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Latching</conjf>.]</vmorph> <ety>[OE. <ets>lacchen</ets>. See <er>Latch</er>. <pos>n.</pos>]</ety> <sn>1.</sn> <def>To catch so as to hold.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Those that remained threw darts at our men, and <qex>latching</qex> our darts, sent them again at us.</q> <rj><qau>Golding.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To catch or fasten by means of a latch.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The door was only <qex>latched</qex>.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>latched</ent><br/
<hw>latched</hw> <pos>adj.</pos> <def>secured by means of a latch against opening.</def><br/
<syn><b>Syn. --</b> fastened.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Latchet</ent><br/
<hw>Latch"et</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>lachet</ets>, from an OF. dialect form of F. <ets>lacet</ets> plaited string, lace dim. of <ets>lacs</ets>. See <er>Lace</er>.]</ety> <def>The string that fastens a shoe; a shoestring.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latching</ent><br/
<hw>Latch"ing</hw>, <pos>n.</pos> <fld>(Naut.)</fld> <def>A loop or eye formed on the head rope of a bonnet, by which it is attached to the foot of a sail; -- called also <altname>latch</altname> and <altname>lasket</altname>.</def> <mark>[Usually in pl.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latchkey</ent><br/
<hw>Latch"key`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A key used to raise, or throw back, the latch of a door, esp. a night latch.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>latchkey child</ent><br/
<hw>latch"key` child</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A child who frequently spends part of the day at home without adult supervision, especially a school child who returns home before the parent(s) return from work.  Called also <altname>door-key child</altname>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Latchstring</ent><br/
<hw>Latch"string`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A string for raising the latch of a door by a person outside. It is fastened to the latch and passed through a hole above it in the door.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To find the latchstring out</b></col>, <cd>to meet with hospitality; to be welcome. (Intrusion is prevented by drawing in the latchstring.)</cd> <mark>[Colloq. U.S.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Late</ent><br/
<hw>Late</hw> <pr>(l<amac/t)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Later</adjf> <pr>(l<amac/t"<etil/r)</pr>, or <adjf>latter</adjf> <pr>(l<acr/t"t<etil/r)</pr>; <pos>superl.</pos> <adjf>Latest</adjf> <pr>(l<amac/t"<ecr/st)</pr> or <adjf>Last</adjf> <pr>(l<adot/st)</pr>.]</amorph> <ety>[OE. <ets>lat</ets> slow, slack, AS. <ets>l<ae/t</ets>; akin to OS. <ets>lat</ets>, D. <ets>laat</ets> late, G. <ets>lass</ets> weary, lazy, slack, Icel. <ets>latr</ets>, Sw. <ets>lat</ets>, Dan. <ets>lad</ets>, Goth. <ets>lats</ets>, and to E. <ets>let</ets>, <pos>v.</pos> See <er>Let</er> to permit, and cf. <er>Alas</er>, <er>Lassitude</er>.]</ety> <sn>1.</sn> <def>Coming after the time when due, or after the usual or proper time; not early; slow; tardy; long delayed; <as>as, a <ex>late</ex> spring</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Far advanced toward the end or close; <as>as, a <ex>late</ex> hour of the day; a <ex>late</ex> period of life.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Existing or holding some position not long ago, but not now; recently deceased, departed, or gone out of office; <as>as, the <ex>late</ex> bishop of London; the <ex>late</ex> administration.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Not long past; happening not long ago; recent; <as>as, the <ex>late</ex> rains; we have received <ex>late</ex> intelligence.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Continuing or doing until an advanced hour of the night; <as>as, <ex>late</ex> revels; a <ex>late</ex> watcher.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Late</ent><br/
<hw>Late</hw>, <pos>adv.</pos> <ety>[AS. <ets>late</ets>. See <er>Late</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>After the usual or proper time, or the time appointed; after delay; <as>as, he arrived <ex>late</ex></as>; -- opposed to <ant>early</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not long ago; lately.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Far in the night, day, week, or other particular period; <as>as, to lie abed <ex>late</ex>; to sit up <ex>late</ex> at night.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Of late</b></col>, <cd>in time not long past, or near the present; lately; <as>as, the practice is <ex>of late</ex> uncommon</as>.</cd> -- <col><b>Too late</b></col>, <cd>after the proper or available time; when the time or opportunity is past.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>latecomer</ent><br/
<hw>latecomer</hw> <pos>n.</pos> <def>someone who arrives late.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lated</ent><br/
<hw>Lat"ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Belated; too late.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lateen</ent><br/
<hw>la*teen"</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <fld>(Naut.)</fld> <def>Of or pertaining to a peculiar rig used in the Mediterranean and adjacent waters, esp. on the northern coast of Africa; pertaining to a lateen sail. See below.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>rigged with a triangular (lateen sail).</def><br/
<syn><b>Syn. --</b> lateen-rigged.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lateen sail</ent><br/
<hw>lateen sail</hw> <pos>n.</pos> <ety>[F. voile <ets>latine</ets> a sail in the shape of a right-angled triangle; cf. It. & Sp. vela <ets>latina</ets>; properly <ets>Latin</ets> sail. See <er>Latin</er>.]</ety> <fld>(Naut.)</fld> <def>A triangular sail, extended by a long yard, which is slung at about one fourth of its length from the lower end, to a low mast, this end being brought down at the tack, while the other end is elevated at an angle or about forty-five degrees; -- used in small boats, feluccas, xebecs, etc., especially in the Mediterranean and adjacent waters. Some lateen sails have also a boom on the lower side.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lateen-rig</ent><br/
<hw>lateen-rig</hw> <pos>n.</pos> <def>the rig on a sailing vessel with a lateen sail.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lateen-rigged</ent><br/
<hw>lateen-rigged</hw> <pos>adj.</pos> <def>rigged with a triangular (lateen sail).</def><br/
<syn><b>Syn. --</b> lateen.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lately</ent><br/
<hw>Late"ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>Not long ago; recently; <as>as, he has <ex>lately</ex> arrived from Italy</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latence</ent><br/
<hw>La"tence</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Latency.</def>  <rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latency</ent><br/
<hw>La"ten*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Latent</er>.]</ety> <sn>1.</sn> <def>The state or quality of being latent.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To simplify the discussion, I shall distinguish three degrees of this <qex>latency</qex>.</q> <rj><qau>Sir W. Hamilton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The time between a stimulus the appearance of the response; the time between any causal action and the first appearance of the effect.  Called also <altname>latent period</altname>.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <specif>Hence:</specif> <fld>(Med.)</fld> <def>The time between exposure to a carcinogen or other disease-causing agent and the appearance of the consequent disease.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lateness</ent><br/
<hw>Late"ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state, condition, or quality, of being late; <as>as, the <ex>lateness</ex> of his arrival; the <ex>lateness</ex> of the hour; the <ex>lateness</ex> of the season.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latent</ent><br/
<hw>La"tent</hw> <pr>(l<amac/"t<eit/nt)</pr>, <pos>a.</pos> <ety>[L. <ets>latens</ets>, <ets>-entis</ets>, p. pr. of <ets>latere</ets> to lie hid or concealed; cf. Gr. <grk>lanqa`nein</grk>, E. <ets>lethargy</ets>: cf. F. <ets>latent</ets>.]</ety> <sn>1.</sn> <def>Not visible or apparent; hidden; concealed; secret; dormant; <as>as, <ex>latent</ex> springs of action</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The evils <qex>latent</qex> in the most promising contrivances are provided for as they arise.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>Existing but not presenting symptoms; dormant or developing; -- of disease, especially infectious diseases; <as>as, the <ex>latent</ex> phase of an infection</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Latent buds</b></col> <fld>(Bot.)</fld>, <cd>buds which remain undeveloped or dormant for a long time, but may eventually grow.</cd> <col><b>Latent heat</b></col> <fld>(Physics)</fld>, <cd>that quantity of heat which disappears or becomes concealed in a body while producing some change in it other than rise of temperature, as fusion, evaporation, or expansion, the quantity being constant for each particular body and for each species of change; the amount of heat required to produce a change of phase.</cd> -- <col><b>Latent period</b></col>. <sd>(a)</sd> <fld>(Med.)</fld> <cd>The regular time in which a disease is supposed to be existing without manifesting itself.</cd> <sd>(b)</sd> <fld>(Physiol.)</fld> <cd>One of the phases in a simple muscular contraction, in which invisible preparatory changes are taking place in the nerve and muscle.</cd> <sd>(c)</sd> <fld>(Biol.)</fld> <cd>One of those periods or resting stages in the development of the ovum, in which development is arrested prior to renewed activity.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latently</ent><br/
<hw>La"tent*ly</hw>, <pos>adv.</pos> <def>In a secret or concealed manner; invisibly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Later</ent><br/
\'d8<hw>La"ter</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lateres</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <def>A brick or tile.</def>  <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Later</ent><br/
<hw>Lat"er</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Compar. of <er>Late</er>, <pos>a. & adv.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laterad</ent><br/
<hw>Lat"er*ad</hw> <pr>(?)</pr>, <pos>adv.</pos> <ety>[L. <ets>latus</ets>, <ets>lateris</ets>, side + <ets>ad</ets> to.]</ety> <fld>(Anat.)</fld> <def>Toward the side; away from the mesial plane; -- opposed to <ant>mesiad</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lateral</ent><br/
<hw>Lat"er*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lateralis</ets>, fr. <ets>latus</ets>, <ets>lateris</ets>, side: cf. F. <ets>lat<eacute/ral</ets>.]</ety> <sn>1.</sn> <def>Of or pertaining to the sides; <as>as, the <ex>lateral</ex> walls of a house; the <ex>lateral</ex> branches of a tree.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>Lying at, or extending toward, the side; away from the mesial plane; external; -- opposed to <ant>mesial</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Directed to the side; <as>as, a <ex>lateral</ex> view of a thing</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lateral cleavage</b></col> <fld>(Crystallog.)</fld>, <cd>cleavage parallel to the lateral planes.</cd> -- <col><b>Lateral equation</b></col> <fld>(Math.)</fld>, <cd>an equation of the first degree.</cd> <mark>[Obs.]</mark> -- <col><b>Lateral line</b></col> <fld>(Anat.)</fld>, <cd>in fishes, a line of sensory organs along either side of the body, often marked by a distinct line of color.</cd> -- <mcol><col><b>Lateral pressure</b></col> or <col><b>stress</b></col></mcol> <fld>(Mech.)</fld>, <cd>a pressure or stress at right angles to the length, as of a beam or bridge; -- distinguished from <xex>longitudinal pressure or stress</xex>.</cd> -- <col><b>Lateral strength</b></col> <fld>(Mech.)</fld>, <cd>strength which resists a tendency to fracture arising from lateral pressure.</cd> -- <col><b>Lateral system</b></col> <fld>(Bridge Building)</fld>, <cd>the system of horizontal braces (as between two vertical trusses) by which lateral stiffness is secured.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>lateral pass</ent><br/
<ent>lateral</ent><br/
<mhw><hw>lat"er*al</hw>, <hw>lat"er*al pass`</hw></mhw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Football)</fld> <sn>1.</sn> <def>A short pass to a receiver who is upfield from the passer, i.e. is behind the passer relative to the direction of the passer's goal.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>A part or extension of something that points sideways, as a drift in a mine that goes to the side from the main one.</def><br/
[<source>PJC</source>]</p>

<p><ent>lateral</ent><br/
<hw>lat"er*al</hw> <pr>(?)</pr>, <pos>v. t. & i.</pos> <fld>(Football)</fld> <def>To pass the footbal to a receiver who is behind the passer; to make a lateral pass; <as>as, the ball was <ex>lateraled</ex> to the fullback, who ran it for a touchdown</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Laterality</ent><br/
<hw>Lat`er*al"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state or condition of being lateral.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laterally</ent><br/
<hw>Lat"er*al*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>By the side; sidewise; toward, or from, the side.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lateran</ent><br/
<hw>Lat"er*an</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The church and palace of St. John Lateran, the church being the cathedral church of Rome, and the highest in rank of all churches in the Catholic world.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name is said to have been derived from that of the <etsep>Laterani</etsep> family, who possessed a palace on or near the spot where the church now stands. In this church several ecclesiastical councils, hence called <ex>Lateran</ex> councils, have been held.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latered</ent><br/
<hw>Lat"ered</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Inclined to delay; dilatory.</def> <mark>[Obs.]</mark> <ldquo/When a man is too <xex>latered</xex>.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laterifolious</ent><br/
<hw>Lat`er*i*fo"li*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>latus</ets>, <ets>lateris</ets>, side + <ets>folium</ets> leaf: cf. F. <ets>lat<eacute/rifoli<eacute/</ets>.]</ety> <fld>(Bot.)</fld> <def>Growing from the stem by the side of a leaf; <as>as, a <ex>laterifolious</ex> flower</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laterite</ent><br/
<hw>Lat"er*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>later</ets> brick, tile: cf. F. <ets>lat<eacute/rite</ets>.]</ety> <fld>(Geol.)</fld> <def>An argillaceous sandstone, of a red color, and much seamed; -- found in India.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lateritic</ent><br/
<hw>Lat`er*it"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Consisting of, containing, or characterized by, laterite; <as>as, <ex>lateritic</ex> formations</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lateritious</ent><br/
<hw>Lat"er*i"tious</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>lateritius</ets>, fr. <ets>later</ets> a brick.]</ety> <def>Like bricks; of the color of red bricks.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lateritious sediment</b></col> <fld>(Med.)</fld>, <cd>a sediment in urine resembling brick dust, observed after the crises of fevers, and at the termination of gouty paroxysms. It usually consists of uric acid or urates with some coloring matter.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lates</ent><br/
\'d8<hw>La"tes</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <?/ a fish of the Nile.]</ety> <fld>(Zool.)</fld> <def>A genus of large percoid fishes, of which one species (<spn>Lates Niloticus</spn>) inhabits the Nile, and another (<spn>Lates calcarifer</spn>) is found in the Ganges and other Indian rivers. They are valued as food fishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latescence</ent><br/
<hw>La*tes"cence</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A slight withdrawal from view or knowledge.</def>  <rj><au>Sir W. Hamilton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latescent</ent><br/
<hw>La*tes"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>latescens</ets>, <ets>-entis</ets>, p. pr. of <ets>latescere</ets> to be concealed, fr. <ets>latere</ets> to be hid.]</ety> <def>Slightly withdrawn from view or knowledge; <as>as, a <ex>latescent</ex> meaning</as>.</def>  <rj><au>Sir W. Hamilton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latewake</ent><br/
<hw>Late"wake`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <cref>Lich wake</cref>, under <er>Lich</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lateward</ent><br/
<hw>Late"ward</hw> <pr>(?)</pr>, <pos>a. & adv.</pos> <def>Somewhat late; backward.</def> <mark>[Obs.]</mark> <ldquo/<xex>Lateward</xex> lands.<rdquo/  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latex</ent><br/
\'d8<hw>La"tex</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>A milky or colored juice in certain plants in cavities (called <xex>latex cells</xex> or <xex>latex tubes</xex>). It contains the peculiar principles of the plants, whether aromatic, bitter, or acid, and in many instances yields caoutchouc upon coagulation.  The lattex of the India rubber plant produces the rubber of commerce on coagulation.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>Any aqueous emulsion of finely divided rubber or plastic particles, especially such an emulsion used as a base for paint; <as>as, a <ex>latex</ex> paint</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lath</ent><br/
<hw>Lath</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Laths</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>laththe</ets>, <ets>latthe</ets>, <ets>latte</ets>, AS. <ets>l<ae/tta</ets>; akin to D. <ets>lat</ets>, G. <ets>latte</ets>, OHG. <ets>latta</ets>; cf. W. <ets>llath</ets> a rod, staff, yard.  Cf. <er>Lattice</er>, <er>Latten</er>.]</ety> <def>A thin, narrow strip of wood, nailed to the rafters, studs, or floor beams of a building, for the purpose of supporting the tiles, plastering, etc. A corrugated metallic strip or plate is sometimes used.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lath brick</b></col>, <cd>a long, slender brick, used in making the floor on which malt is placed in the drying kiln.</cd> <col><b>Lath nail</b></col> <cd>a slender nail for fastening laths.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lath</ent><br/
<hw>Lath</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lathed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lathing</conjf>.]</vmorph> <def>To cover or line with laths.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lathe</ent><br/
<hw>Lathe</hw> <pr>(l<aum/<th/)</pr>, <pos>n.</pos> <ety>[AS. <ets>l<aemac/<edh/</ets>. Of uncertain origin.]</ety> <def>Formerly, a part or division of a county among the Anglo-Saxons. At present it consists of four or five hundreds, and is confined to the county of Kent.</def> <altsp>[Written also <asp>lath</asp>.]</altsp>  <rj><au>Brande & C.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lathe</ent><br/
<hw>Lathe</hw> <pr>(l<amac/<th/)</pr>, <pos>n.</pos> <ety>[OE. <ets>lathe</ets> a granary; akin to G. <ets>lade</ets> a chest, Icel. <ets>hla<edh/a</ets> a storehouse, barn; but cf. also Icel. <ets>l<oum/<edh/</ets> a smith's lathe. Senses 2 and 3 are perh. of the same origin as <ets>lathe</ets> a granary, the original meaning being, a frame to hold something. If so, the word is from an older form of E. <ets>lade</ets> to load. See <er>Lade</er> to load.]</ety> <sn>1.</sn> <def>A granary; a barn.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mach.)</fld> <def>A machine for turning, that is, for shaping articles of wood, metal, or other material, by causing them to revolve while acted upon by a cutting tool.</def>
<-- "turning" here is in the sense of cutting while turning.
    turn 6 and turning 4, in this dict. --><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The movable swing frame of a loom, carrying the reed for separating the warp threads and beating up the weft; -- called also <altname>lay</altname> and <altname>batten</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Blanchard lathe</b></col>, <cd>a lathe for turning irregular forms after a given pattern, as lasts, gunstocks, and the like.</cd> -- <mcol><col><b>Drill lathe</b></col>, <it>or</it> <col><b>Speed lathe</b></col></mcol>, <cd>a small lathe which, from its high speed, is adapted for drilling; a hand lathe.</cd> -- <col><b>Engine lathe</b></col>, <cd>a turning lathe in which the cutting tool has an automatic feed; -- used chiefly for turning and boring metals, cutting screws, etc.</cd> -- <col><b>Foot lathe</b></col>, <cd>a lathe which is driven by a treadle worked by the foot.</cd> -- <col><b>Geometric lathe</b></col>. See under <er>Geometric</er> -- <col><b>Hand lathe</b></col>, <cd>a lathe operated by hand; a power turning lathe without an automatic feed for the tool.</cd> -- <col><b>Slide lathe</b></col>, <cd>an engine lathe.</cd> -- <col><b>Throw lathe</b></col>, <cd>a small lathe worked by one hand, while the cutting tool is held in the other.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>lathee</ent><br/
<hw>lathee</hw> <pos>n.</pos> <def>a heavy stick (often bamboo) bound with iron; used by police in India.</def><br/
<syn><b>Syn. --</b> lathi.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 833 --></p>

<p><ent>Lather</ent><br/
<hw>Lath"er</hw> <pr>(l<acr/<th/"<etil/r)</pr>, <pos>n.</pos> <ety>[AS. <ets>le<aacute/<edh/or</ets> niter, in <ets>le<aacute/<edh/orwyrt</ets> soapwort; cf. Icel. <ets>lau<edh/r</ets>; perh. akin to E. <ets>lye</ets>.]</ety>  <sn>1.</sn> <def>Foam or froth made by soap moistened with water.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Foam from profuse sweating, as of a horse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lather</ent><br/
<hw>Lath"er</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lathered</conjf> <pr>(l<acr/<th/"<etil/rd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lathering</conjf>.]</vmorph> <ety>[AS. <ets>l<emac/<edh/rian</ets> to lather, anoint. See <er>Lather</er>, <pos>n.</pos> ]</ety> <def>To spread over with lather; <as>as, to <ex>lather</ex> the face</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lather</ent><br/
<hw>Lath"er</hw>, <pos>v. i.</pos> <def>To form lather, or a froth like lather; to accumulate foam from profuse sweating, as a horse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lather</ent><br/
<hw>Lath"er</hw>, <pos>v. t.</pos> <ety>[Cf. <er>Leather</er>.]</ety> <def>To beat severely with a thong, strap, or the like; to flog.</def> <mark>[Low]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lathreeve</ent><br/
<ent>Lathereeve</ent><br/
<mhw>{ <hw>Lathe"reeve`</hw> <pr>(?)</pr>, <hw>Lath"reeve`</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <def>Formerly, the head officer of a lathe. See 1st <er>Lathe</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lathing</ent><br/
<hw>Lath"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act or process of covering with laths.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Laths, collectively; a covering of laths.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lath-shaped</ent><br/
<hw>Lath"-shaped`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having a slender elongated form, like a lath; -- said of the feldspar of certain igneous rocks, as diabase, as seen in microscopic sections.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lathwork</ent><br/
<hw>Lath"work`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Lathing</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lathy</ent><br/
<hw>Lath"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Like a lath; long and slender.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>lathy</qex> horse, all legs and length.</q> <rj><qau>R. Browning.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latian</ent><br/
<hw>La"tian</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Belonging, or relating, to Latium, a country of ancient Italy. See <er>Latin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latibulize</ent><br/
<hw>La*tib"u*lize</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Latibulized</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Latibulizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>latibulum</ets> hiding place, fr. <ets>latere</ets> to lie hid.]</ety> <def>To retire into a den, or hole, and lie dormant in winter; to retreat and lie hid.</def> <mark>[R.]</mark>  <rj><au>G. Shaw.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latibulum</ent><br/
\'d8<hw>La*tib"u*lum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Latibula</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <def>A concealed hiding place; a burrow; a lair; a hole.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laticiferous</ent><br/
<hw>Lat`i*cif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>latex</ets>, <ets>laticis</ets>, a liquid + <ets>-ferous</ets>.]</ety> <fld>(Bot.)</fld> <def>Containing the latex; -- applied to the tissue or tubular vessels in which the latex of the plant is found.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laticlave</ent><br/
<hw>Lat"i*clave</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>laticlavus</ets>, <ets>laticlavium</ets>; <ets>latus</ets> broad + <ets>clavus</ets> nail, a purple stripe on the tunica: cf. F. <ets>laticlave</ets>.]</ety> <fld>(Rom. Antiq.)</fld> <def>A broad stripe of purple on the fore part of the tunic, worn by senators in ancient Rome as an emblem of office.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laticostate</ent><br/
<hw>Lat`i*cos"tate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>latus</ets> broad + E. <ets>costate</ets>.]</ety> <def>Broad-ribbed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latidentate</ent><br/
<hw>Lat`i*den"tate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>latus</ets> broad + E. <ets>dentate</ets>.]</ety> <def>Broad-toothed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latifolious</ent><br/
<ent>Latifoliate</ent><br/
<mhw>{ <hw>Lat`i*fo"li*ate</hw> <pr>(?)</pr>, <hw>Lat`i*fo"li*ous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>latifolius</ets>; <ets>latus</ets> broad + <ets>folium</ets> leaf: cf. F. <ets>latifoli<eacute/</ets>.]</ety> <fld>(Bot.)</fld> <def>Having broad leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latigo</ent><br/
\'d8<hw>La"ti*go</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>l<aacute/tigo</ets>.]</ety> <def>A strap for tightening a saddle girth.</def> <mark>[Western U. S. & Sp. Amer.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Latigo halter</ent><br/
<hw>La"ti*go hal"ter</hw> <pr>(?)</pr> <pos>n.</pos> <def>A kind of halter usually made of raw hide.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Latimer</ent><br/
<hw>Lat"i*mer</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>latinier</ets>, <ets>latimier</ets>, prop., one knowing Latin.]</ety> <def>An interpreter.</def> <mark>[Obs.]</mark> <au>Coke</au>.<br/
[<source>1913 Webster</source>]</p>

<p><ent>Latimeria</ent><br/
<hw>Latimeria</hw> <pos>prop. n.</pos> <def>The type genus of the <fam>Latimeridae</fam>, including the coelacanth.</def><br/
<syn><b>Syn. --</b> genus <gen>Latimeria</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Latimeridae</ent><br/
<hw>Latimeridae</hw> <pos>prop. n.</pos> <def>A natural family of fish extinct except for the coelacanth.</def><br/
<syn><b>Syn. --</b> family <fam>Latimeridae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Latin</ent><br/
<hw>Lat"in</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F., fr. L. <ets>Latinus</ets> belonging to Latium, Latin, fr. <ets>Latium</ets> a country of Italy, in which Rome was situated.  Cf. <er>Ladin</er>, <ets>Lateen sail</ets>, under <er>Lateen</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to Latium, or to the Latins, a people of Latium; Roman; <as>as, the <ex>Latin</ex> language</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of, pertaining to, or composed in, the language used by the Romans or Latins; <as>as, a <ex>Latin</ex> grammar; a <ex>Latin</ex> composition or idiom.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Latin Church</b></col> <fld>(Eccl. Hist.)</fld>, <cd>the Western or Roman Catholic Church, as distinct from the Greek or Eastern Church.</cd> -- <col><b>Latin cross</b></col>. <cd>See <xex>Illust.</xex> 1 of <er>Cross</er>.</cd> -- <col><b>Latin races</b></col>, <cd>a designation sometimes loosely given to certain nations, esp. the French, Spanish, and Italians, who speak languages principally derived from Latin.</cd> <col><b>Latin Union</b></col>, <cd>an association of states, originally comprising France, Belgium, Switzerland, and Italy, which, in 1865, entered into a monetary agreement, providing for an identity in the weight and fineness of the gold and silver coins of those countries, and for the amounts of each kind of coinage by each. Greece, Servia, Roumania, and Spain subsequently joined the Union.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latin</ent><br/
<hw>Lat"in</hw>, <pos>n.</pos> <sn>1.</sn> <def>A native or inhabitant of Latium; a Roman.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The language of the ancient Romans.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An exercise in schools, consisting in turning English into Latin.</def> <mark>[Obs.]</mark>  <rj><au>Ascham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Eccl.)</fld> <def>A member of the Roman Catholic Church.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Dog Latin</b></col>, <cd>barbarous Latin; a jargon in imitation of Latin; <as>as, the <ex>log Latin</ex> of schoolboys</as>.</cd> -- <mcol><col><b>Late Latin</b></col>, <col><b>Low Latin</b></col></mcol>, <cd>terms used indifferently to designate the latest stages of the Latin language; low Latin (and, perhaps, late Latin also), including the barbarous coinages from the French, German, and other languages into a Latin form made after the Latin had become a dead language for the people.</cd> -- <col><b>Law Latin</b></col>, <cd>that kind of late, or low, Latin, used in statutes and legal instruments; -- often barbarous.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latin</ent><br/
<hw>Lat"in</hw>, <pos>v. t.</pos> <def>To write or speak in Latin; to turn or render into Latin.</def> <mark>[Obs.]</mark>  <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latin America</ent><br/
<hw>Lat"in A*me"ri*ca</hw>, <pos>prop. n.</pos> <def>That part of the American continents that speak Spanish, Portuguese, or French; the part of the American continents south of the United States.</def><br/
[<source>PJC</source>]</p>

<p><ent>Latin American</ent><br/
<hw>Lat"in A*me"ri*can</hw>, <pos>prop. a.</pos> <def>Of, pertaining to, or characteristic of Latin America.</def><br/
[<source>PJC</source>]</p>

<p><ent>Latin American</ent><br/
<hw>Lat"in A*me"ri*can</hw>, <pos>prop. n.</pos> <def>A native or inhabitant of Latin America.</def><br/
[<source>PJC</source>]</p>

<p><ent>latinate</ent><br/
<hw>latinate</hw> <pos>adj.</pos> <def>derived from or imitative of Latin.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Latinise</ent><br/
<hw>Latinise</hw> <pos>v. t.</pos> <def>Same as <er>Latinize</er>.</def><br/
<syn><b>Syn. --</b> Romanize, Latinize.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Latinism</ent><br/
<hw>Lat"in*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>latinisme</ets>.]</ety> <def>A Latin idiom; a mode of speech peculiar to Latin; also, a mode of speech in another language, as English, formed on a Latin model.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The term is also sometimes used by Biblical scholars to designate a Latin word in Greek letters, or the Latin sense of a Greek word in the Greek Testament.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latinist</ent><br/
<hw>Lat"in*ist</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>latiniste</ets>.]</ety> <def>One skilled in Latin; a Latin scholar.</def>  <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He left school a good <qex>Latinist</qex>.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latinistic</ent><br/
<hw>Lat`in*is"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of, pertaining to, or derived from, Latin; in the Latin style or idiom.</def> <ldquo/<xex>Latinistic</xex> words.<rdquo/  <rj><au>Fitzed. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latinitaster</ent><br/
<hw>La*tin"i*tas`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Poetaster</er>.]</ety> <def>One who has but a smattering of Latin.</def>  <rj><au>Walker.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latinity</ent><br/
<hw>La*tin"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>latinitas</ets>: cf. F. <ets>latinit<eacute/</ets>.]</ety> <def>The Latin tongue, style, or idiom, or the use thereof; specifically, purity of Latin style or idiom.</def> <ldquo/His ele<?/ant <xex>Latinity</xex>.<rdquo/  <rj><au>Motley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latinization</ent><br/
<hw>Lat`in*i*za"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The act or process of Latinizing, as a word, language, or country.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Germanization of Britain went far deeper than the <qex>Latinization</qex> of France.</q> <rj><qau>M. Arnold.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latinize</ent><br/
<hw>Lat"in*ize</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Latinized</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Latinizing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>latinizare</ets>: cf. F. <ets>latiniser</ets>.]</ety> <sn>1.</sn> <def>To give Latin terminations or forms to, as to foreign words, in writing Latin.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To bring under the power or influence of the Romans or Latins; to affect with the usages of the Latins, especially in speech.</def> <ldquo/<xex>Latinized</xex> races.<rdquo/  <rj><au>Lowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To make like the Roman Catholic Church or diffuse its ideas in; <as>as, to <ex>Latinize</ex> the Church of England</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>to write in the latin alphabet.</def><br/
<syn><b>Syn. --</b> Romanize.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Latinize</ent><br/
<hw>Lat"in*ize</hw>, <pos>v. i.</pos> <def>To use words or phrases borrowed from the Latin.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To come under the influence of the Romans, or of the Roman Catholic Church.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latinly</ent><br/
<hw>Lat"in*ly</hw>, <pos>adv.</pos> <def>In the manner of the Latin language; in correct Latin.</def> <mark>[Obs.]</mark>  <rj><au>Heylin.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lation</ent><br/
<hw>La"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>latio</ets>, fr. <ets>latus</ets> borne. See <er>Tolerate</er>.]</ety> <def>Transportation; conveyance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latirostrous</ent><br/
<ent>Latirostral</ent><br/
<mhw>{ <hw>Lat`i*ros"tral</hw> <pr>(?)</pr>, <hw>Lat`i*ros"trous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>latirostre</ets>. See <er>Latirostres</er>.]</ety> <fld>(Zool.)</fld> <def>Having a broad beak.</def>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latirostres</ent><br/
\'d8<hw>Lat`i*ros"tres</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>latus</ets> broad + <ets>rostrum</ets> beak.]</ety> <fld>(Zool.)</fld> <def>The broad-billed singing birds, such as the swallows, and their allies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latish</ent><br/
<hw>Lat"ish</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Somewhat late.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latisternal</ent><br/
<hw>Lat`i*ster"nal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>latus</ets> broad + E. <ets>sternal</ets>.]</ety> <fld>(Zool.)</fld> <def>Having a broad breastbone, or sternum; -- said of anthropoid apes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitancy</ent><br/
<hw>Lat"i*tan*cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Latitant</er>.]</ety> <def>Act or state of lying hid, or lurking.</def> <mark>[R.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitant</ent><br/
<hw>Lat"i*tant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>latitans</ets>, pr. of <ets>latitare</ets> to lie hid, to lurk, v. intens. fr. <ets>latere</ets> to be hid: cf. F. <ets>latitant</ets>.]</ety> <def>Lying hid; concealed; latent.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitat</ent><br/
\'d8<hw>Lat"i*tat</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., he lies hid.]</ety> <fld>(O. Eng. Law)</fld> <def>A writ based upon the presumption that the person summoned was hiding.</def>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitation</ent><br/
<hw>Lat`i*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>latitatio</ets>.]</ety> <def>A lying in concealment; hiding.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitude</ent><br/
<hw>Lat"i*tude</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>latitude</ets>, L. <ets>latitudo</ets>, fr. <ets>latus</ets> broad, wide, for older <ets>stlatus</ets>; perh. akin to E. <ets>strew</ets>.]</ety> <sn>1.</sn> <def>Extent from side to side, or distance sidewise from a given point or line; breadth; width.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Provided the length do not exceed the <qex>latitude</qex> above one third part.</q> <rj><qau>Sir H. Wotton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Room; space; freedom from confinement or restraint; hence, looseness; laxity; independence.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In human actions there are no degrees and precise natural limits described, but a <qex>latitude</qex> is indulged.</q> <rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Extent or breadth of signification, application, etc.; extent of deviation from a standard, as truth, style, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No discreet man will believe Augustine's miracles, in the <qex>latitude</qex> of monkish relations.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Extent; size; amplitude; scope.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I pretend not to treat of them in their full <qex>latitude</qex>.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Geog.)</fld> <def>Distance north or south of the equator, measured on a meridian.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Astron.)</fld> <def>The angular distance of a heavenly body from the ecliptic.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Ascending latitude</b></col>, <col><b>Circle of latitude</b></col>, <col><b>Geographical latitude</b></col></mcol>, <cd>etc. See under <er>Ascending</er>. <er>Circle</er>, etc.</cd> -- <col><b>High latitude</b></col>, <cd>that part of the earth's surface near either pole, esp. that part within either the arctic or the antarctic circle.</cd> -- <col><b>Low latitude</b></col>, <cd>that part of the earth's surface which is near the equator.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitudinal</ent><br/
<hw>Lat`i*tu"di*nal</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to latitude; in the direction of latitude.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitudinarian</ent><br/
<hw>Lat`i*tu`di*na"ri*an</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>latitudinaire</ets>.]</ety> <sn>1.</sn> <def>Not restrained; not confined by precise limits.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Indifferent to a strict application of any standard of belief or opinion; hence, deviating more or less widely from such standard; lax in doctrine; <as>as, <ex>latitudinarian</ex> divines; <ex>latitudinarian</ex> theology.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Latitudinarian</qex> sentiments upon religious subjects.</q> <rj><qau>Allibone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Lax in moral or religious principles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitudinarian</ent><br/
<hw>Lat`i*tu`di*na"ri*an</hw>, <pos>n.</pos> <sn>1.</sn> <def>One who is moderate in his notions, or not restrained by precise settled limits in opinion; one who indulges freedom in thinking.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eng. Eccl. Hist.)</fld> <def>A member of the Church of England, in the time of Charles II., who adopted more liberal notions in respect to the authority, government, and doctrines of the church than generally prevailed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They were called <ldquo/men of latitude;<rdquo/ and upon this, men of narrow thoughts fastened upon them the name of <qex>latitudinarians</qex>.</q> <rj><qau>Bp. Burnet.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Theol.)</fld> <def>One who departs in opinion from the strict principles of orthodoxy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitudinarianism</ent><br/
<hw>Lat`i*tu`di*na"ri*an*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A latitudinarian system or condition; freedom of opinion in matters pertaining to religious belief.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Fierce sectarianism bred fierce <qex>latitudinarianism</qex>.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He [Ammonius Saccas] plunged into the wildest <qex>latitudinarianism</qex> of opinion.</q> <rj><qau>J. S. Harford.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latitudinous</ent><br/
<hw>Lat`i*tu"di*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having latitude, or wide extent.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latoun</ent><br/
<ent>Laton</ent><br/
<mhw>{ <hw>Lat"on</hw> <pr>(?)</pr>, <hw>Lat"oun</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <def>Latten, 1.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latrant</ent><br/
<hw>La"trant</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>latrans</ets>, p. pr. of <ets>latrare</ets>. See <er>Latrate</er>.]</ety> <def>Barking.</def> <mark>[Obs.]</mark>  <rj><au>Tickell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latrate</ent><br/
<hw>La"trate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[L. <ets>latratus</ets>, p. p. of <ets>latrare</ets> to bark.]</ety> <def>To bark as a dog.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latration</ent><br/
<hw>La*tra"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A barking.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latreutical</ent><br/
<hw>La*treu"tic*al</hw> <pr>(l<adot/*tr<udd/"t<icr/*k<ait/l)</pr>, <pos>a.</pos> <ety>[Gr. <grk>latreytiko`s</grk>, fr. <grk>latrey`ein</grk> to serve, to worship.]</ety> <sn>1.</sn> <def>Acting as a hired servant; serving; ministering; assisting.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to latria.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latria</ent><br/
\'d8<hw>La*tri"a</hw> <pr>(l<adot/*tr<imac/"<adot/; 277)</pr>, <pos>n.</pos> <ety>[L., fr. Gr. <grk>latrei`a</grk>, fr. <grk>latrey`ein</grk> to serve, fr. <grk>la`tris</grk> servant.]</ety> <def>The highest kind of worship, or that paid to God; -- distinguished by the Roman Catholics from <contr>dulia</contr>, or the inferior worship paid to saints.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latrine</ent><br/
<hw>La*trine"</hw> <pr>(l<adot/*tr<emac/n")</pr>, <pos>n.</pos> <ety>[L. <ets>latrina</ets>: cf. F. <ets>latrines</ets>.]</ety> <def>A privy, or water-closet, esp. in a camp, hospital, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latrociny</ent><br/
<hw>Lat"ro*cin`y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>latrocinium</ets>.  Cf. <er>Larceny</er>.]</ety> <def>Theft; larceny.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>latte</ent><br/
<hw>lat"te</hw> <pr>(l<adot/*t<amac/")</pr>, <pos>n.</pos> <def>Same as <er>cafe latte</er>; a type of espresso coffee served with foamy steamed milk, and usually served in a tall glass or mug.</def><br/
[<source>PJC</source>]</p>

<p><ent>Latten</ent><br/
<hw>Lat"ten</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>latoun</ets>, <ets>laton</ets>, OF. <ets>laton</ets>, F. <ets>laiton</ets>, prob. fr. OF. <ets>late</ets> lath, F. <ets>latte</ets>; -- because made in thin plates; cf. It. <ets>latta</ets> a sheet of tinned iron, tin plate. F. <ets>latte</ets> is of German origin. See <er>Lath</er> a thin board.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A kind of brass hammered into thin sheets, formerly much used for making church utensils, as candlesticks, crosses, etc.; -- called also <altname>latten brass</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He had a cross of <qex>latoun</qex> full of stones.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Sheet tin; iron plate, covered with tin; also, any metal in thin sheets; <as>as, gold <ex>latten</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Black latten</b></col>, <cd>brass in milled sheets, composed of copper and zinc, used by braziers, and for drawing into wire.</cd> -- <col><b>Roll latten</b></col>, <cd>latten polished on both sides ready for use.</cd> -- <col><b>Shaven latten</b></col>, <cd>a thinner kind than black latten.</cd> -- <col><b>White latten</b></col>, <cd>a mixture of brass and tin.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latter</ent><br/
<hw>Lat"ter</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OE. <ets>later</ets>, <ets>l<ae/tter</ets>, compar. of <ets>lat</ets> late. See <er>Late</er>, and cf. <er>Later</er>.]</ety> <sn>1.</sn> <def>Later; more recent; coming or happening after something else; -- opposed to <ant>former</ant>; <as>as, the former and <ex>latter</ex> rain</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of two things, the one mentioned second.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The difference between reason and revelation, and in what sense the <qex>latter</qex> is superior.</q> <rj><qau>I. Watts.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Recent; modern.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Hath not navigation discovered in these <qex>latter</qex> ages, whole nations at the bay of Soldania?</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Last; latest; final.</def> <mark>[R.]</mark> <ldquo/My <xex>latter</xex> gasp.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Latter harvest</b></col>, <cd>the last part of the harvest.</cd> -- <col><b>Latter spring</b></col>, <cd>the last part of the spring of the year.</cd>  <au>Shak.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latterday</ent><br/
<hw>Lat"ter*day`</hw>, <pos>a.</pos> <def>Belonging to present times or those recent by comparison.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Latter-day saint</ent><br/
<hw>Lat"ter-day` saint"</hw> <pr>(?)</pr> <pos>n.</pos> <def>A Mormon; -- the <membof>Church of Jesus Christ of Latter-day Saints</membof> being the name assumed by the whole body of Mormons.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latterkin</ent><br/
<hw>Lat"ter*kin</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A pointed wooden tool used in glazing leaden lattice.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latterly</ent><br/
<hw>Lat"ter*ly</hw>, <pos>adv.</pos> <def>Lately; of late; recently; at a later, as distinguished from a former, period.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Latterly</qex> Milton was short and thick.</q> <rj><qau>Richardson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lattermath</ent><br/
<hw>Lat"ter*math</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Aftermath</er>.]</ety> <def>The latter, or second, mowing; the aftermath.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lattice</ent><br/
<hw>Lat"tice</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>latis</ets>, F. <ets>lattis</ets> lathwork, fr. <ets>latte</ets> lath. See <er>Latten</er>, 1st <er>Lath</er>.]</ety> <sn>1.</sn> <def>Any work of wood, metal, plastic, or other solid material, made by crossing a series of parallel laths, or thin strips, with another series at a diagonal angle, and forming a network with openings between the strips; <as>as, the <ex>lattice</ex> of a window</as>; -- called also <altname>latticework</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The mother of Sisera looked out at a window, and cried through the <qex>lattice</qex>.</q> <rj><qau>Judg. v. 28. </qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Her.)</fld> <def>The representation of a piece of latticework used as a bearing, the bands being vertical and horizontal.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Crystallography)</fld> <def>The arrangement of atoms or molecules in a crystal, represented as a repeating arrangement of points in space, each point representing the location of an atom or molecule; called also <altname>crystal lattice</altname> and <altname>space lattice</altname>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Lattice bridge</b></col>, <cd>a bridge supported by lattice girders, or latticework trusses.</cd> -- <col><b>Lattice girder</b></col> <fld>(Arch.)</fld>, <cd>a girder of which the wed consists of diagonal pieces crossing each other in the manner of latticework.</cd> -- <col><b>Lattice plant</b></col> <fld>(Bot.)</fld>, <cd>an aquatic plant of Madagascar (<spn>Ouvirandra fenestralis</spn>), whose leaves have interstices between their ribs and cross veins, so as to resemble latticework. A second species is <spn>Ouvirandra Berneriana</spn>. The genus is merged in <gen>Aponogeton</gen> by recent authors.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lattice</ent><br/
<hw>Lat"tice</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Latticed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Latticing</conjf> <pr>(?)</pr>.]</vmorph> <sn>1.</sn> <def>To make a lattice of; <as>as, to <ex>lattice</ex> timbers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To close, as an opening, with latticework; to furnish with a lattice; <as>as, to <ex>lattice</ex> a window</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To lattice up</b></col>, <cd>to cover or inclose with a lattice.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>Therein it seemeth he [Alexander] hath <qex>latticed up</qex> Caesar.</q> <rj><qau>Sir T. North.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>latticed</ent><br/
<hw>latticed</hw> <pos>adj.</pos>  <def>having a lattice.</def><br/
<syn><b>Syn. --</b> fretted, interlaced, latticelike.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>latticelike</ent><br/
<hw>latticelike</hw> <pos>adj.</pos> <sn>1.</sn>  <def>same as <er>latticed</er>.</def><br/
<syn><b>Syn. --</b> fretted, interlaced, latticed.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Latticework</ent><br/
<hw>Lat"tice*work`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Lattice</er>, <pos>n.</pos>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latticing</ent><br/
<hw>Lat"ti*cing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act or process of making a lattice of, or of fitting a lattice to.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bridge Building)</fld> <def>A system of bars crossing in the middle to form braces between principal longitudinal members, as of a strut.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Latus rectum</ent><br/
\'d8<hw>La"tus rec"tum</hw> <pr>(?)</pr> <pos>n.</pos> <ety>[L., the right side.]</ety> <fld>(Conic Sections)</fld> <def>The line drawn through a focus of a conic section parallel to the directrix and terminated both ways by the curve. It is the parameter of the principal axis. See <er>Focus</er>, and <er>Parameter</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laud</ent><br/
<hw>Laud</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>laus</ets>, <ets>laudis</ets>. See <er>Laud</er>, <pos>v. i.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>High commendation; praise; honor; exaltation; glory.</def> <ldquo/<xex>Laud</xex> be to God.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>So do well and thou shalt have <qex>laud</qex> of the same.</q> <rj><qau>Tyndals.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A part of divine worship, consisting chiefly of praise; -- usually in the <pluf>pl.</pluf></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the Roman Catholic Church, the prayers used at daybreak, between those of matins and prime, are called <xex>lauds</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Music or singing in honor of any one.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laud</ent><br/
<hw>Laud</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lauded</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Lauding</conjf>.]</vmorph> <ety>[L. <ets>laudare</ets>, fr. <ets>laus</ets>, <ets>laudis</ets>, praise.  Cf. <er>Allow</er>.]</ety> <def>To praise in words alone, or with words and singing; to celebrate; to extol.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>With all the company of heaven, we <qex>laud</qex> and magnify thy glorious name.</q> <rj><qau>Book of Common Prayer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudability</ent><br/
<hw>Laud`a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>laudabilitas</ets>.]</ety> <def>Laudableness; praiseworthiness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudable</ent><br/
<hw>Laud"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laudabilis</ets>: cf. OE. <ets>laudable</ets>. See <er>Laud</er>, <pos>v. i.</pos>]</ety> <sn>1.</sn> <def>Worthy of being lauded; praiseworthy; commendable; <as>as, <ex>laudable</ex> motives; <ex>laudable</ex> actions; <ex>laudable</ex> ambition.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>Healthy; salubrious; normal; having a disposition to promote healing; not noxious; <as>as, <ex>laudable</ex> juices of the body; <ex>laudable</ex> pus.</as></def>  <rj><au>Arbuthnot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 834 --></p>

<p><ent>Laudableness</ent><br/
<hw>Laud"a*ble*ness</hw> <pr>(l<add/d"<adot/*b'l*n<ecr/s)</pr>, <pos>n.</pos> <def>The quality of being laudable; praiseworthiness; commendableness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudably</ent><br/
<hw>Laud"a*bly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a laudable manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudanine</ent><br/
<hw>Lau"da*nine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Laudanum</er>.]</ety> <fld>(Chem.)</fld> <def>A white organic base, resembling morphine, and obtained from certain varieties of opium.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudanum</ent><br/
<hw>Lau"da*num</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Orig. the same wort as <ets>ladanum</ets>, <ets>ladbdanum</ets>: cf. F. <ets>laudanum</ets>, It. <ets>laudano</ets>, <ets>ladano</ets>. See <er>Ladanum</er>.]</ety> <def>Tincture of opium, used for various medical purposes.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A fluid ounce of American laudanum should contain the soluble matter of one tenth of an ounce avoirdupois of powdered opium with equal parts of alcohol and water. English laudanum should have ten grains less of opium in the fluid ounce. <au>U. S. Disp.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Dutchman's laudanum</b></col> <fld>(Bot.)</fld> <cd>See under <er>Dutchman</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudation</ent><br/
<hw>Lau*da"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>laudatio</ets>: cf. OE. <ets>taudation</ets>. See <er>Land</er>, <pos>v. t.</pos>]</ety> <def>The act of lauding; praise; high commendation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudative</ent><br/
<hw>Laud"a*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laudativus</ets> laudatory: cf. F. <ets>laudatif</ets>.]</ety> <def>Laudatory.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudative</ent><br/
<hw>Laud"a*tive</hw>, <pos>n.</pos> <def>A panegyric; a eulogy.</def> <mark>[Obs.]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudator</ent><br/
\'d8<hw>Lau*da"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <sn>1.</sn> <def>One who lauds.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>An arbitrator.</def> <mark>[Obs.]</mark>  <rj><au>Cowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laudatory</ent><br/
<hw>Laud"a*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laudatorius</ets>: cf. OF. <ets>laudatoire</ets>.]</ety> <def>Of or pertaining praise, or to the expression of praise; <as>as, <ex>laudatory</ex> verses; the <ex>laudatory</ex> powers of Dryden.</as></def>  <rj><au>Sir J. Stephen.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lauder</ent><br/
<hw>Laud"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who lauds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laugh</ent><br/
<hw>Laugh</hw> <pr>(l<aum/f)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Laughed</conjf> <pr>(l<aum/ft)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laughing</conjf>.]</vmorph> <ety>[OE. <ets>laughen</ets>, <ets>laghen</ets>, <ets>lauhen</ets>, AS. <ets>hlehhan</ets>, <ets>hlihhan</ets>, <ets>hlyhhan</ets>, <ets>hliehhan</ets>; akin to OS. <ets>hlahan</ets>, D. & G. <ets>lachen</ets>, OHG. <ets>hlahhan</ets>, <ets>lahhan</ets>, <ets>lahh<emac/n</ets>, Icel. <ets>hl<ae/ja</ets>,W Dan. <ets>lee</ets>, Sw. <ets>le</ets>, Goth. <ets>hlahjan</ets>; perh. of imitative origin.]</ety> <sn>1.</sn> <def>To show mirth, satisfaction, or derision, by peculiar movement of the muscles of the face, particularly of the mouth, causing a lighting up of the face and eyes, and usually accompanied by the emission of explosive or chuckling sounds from the chest and throat; to indulge in laughter.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Queen Hecuba <qex>laughed</qex> that her eyes ran o'er.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>laugheth</qex> that winneth.</q> <rj><qau>Heywood's Prov.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: To be or appear gay, cheerful, pleasant, mirthful, lively, or brilliant; to sparkle; to sport.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Then <qex>laughs</qex> the childish year, with flowerets crowned.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In Folly's cup still <qex>laughs</qex> the bubble Joy.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To laugh at</b></col>, <cd>to make an object of laughter or ridicule; to make fun of; to deride.</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>No wit to flatter left of all his store,<br/
No fool <qex>to laugh at</qex>, which he valued more.</q> <rj><qau>Pope.</qau></rj></p>

<p>-- <mcol><col><b>To laugh in the sleeve</b></col>, <col><b>To laugh up one's sleeve</b></col></mcol>, <cd>to laugh secretly, or so as not to be observed, especially while apparently preserving a grave or serious demeanor toward the person or persons laughed at.</cd> -- <col><b>To laugh out</b></col>, <cd>to laugh in spite of some restraining influence; to laugh aloud.</cd> -- <mcol><col><b>To laugh out of the other corner of the mouth</b></col> <it>or</it> <col><b>To laugh out of the other side of the mouth</b></col></mcol>, <cd>to weep or cry; to feel regret, vexation, or disappointment after hilarity or exaltation.</cd> <mark>[Slang]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laugh</ent><br/
<hw>Laugh</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To affect or influence by means of laughter or ridicule.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Will you <qex>laugh</qex> me asleep, for I am very heavy?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I shall <qex>laugh</qex> myself to death.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To express by, or utter with, laughter; -- with <xex>out</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>From his deep chest <qex>laughs</qex> out a loud applause.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To laugh away</b></col>. <sd>(a)</sd> <cd>To drive away by laughter; <as>as, <ex>to laugh away</ex> regret</as>.</cd> <sd>(b)</sd> <cd>To waste in hilarity.</cd> <ldquo/Pompey doth this day <xex>laugh away</xex> his fortune.<rdquo/ <au>Shak.</au> -- <col><b>To laugh down</b></col>. <sd>(a)</sd> <cd>To cause to cease or desist by laughter; as, <xex>to laugh down</xex> a speaker.</cd> <sd>(b)</sd> <cd>To cause to be given up on account of ridicule; as, <xex>to laugh down</xex> a reform.</cd> -- <col><b>To laugh one out of</b></col>, <cd>to cause one by laughter or ridicule to abandon or give up; <as>as, <ex>to laugh one out of</ex> a plan or purpose</as>.</cd> -- <col><b>To laugh to scorn</b></col>, <cd>to deride; to treat with mockery, contempt, and scorn; to despise.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laugh</ent><br/
<hw>Laugh</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An expression of mirth peculiar to the human species; the sound heard in laughing; laughter. See <er>Laugh</er>, <pos>v. i.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><q>And the loud <qex>laugh</qex> that spoke the vacant mind.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>That man is a bad man who has not within him the power of a hearty <qex>laugh</qex>.</q> <rj><qau>F. W. Robertson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laughable</ent><br/
<hw>Laugh"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Fitted to excite laughter; <as>as, a <ex>laughable</ex> story; a <ex>laughable</ex> scene.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Droll; ludicrous; mirthful; comical. See <er>Droll</er>, and <er>Ludicrous</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Laugh"a*ble*ness</wf>, <pos>n.</pos> -- <wf>Laugh"a*bly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laugher</ent><br/
<hw>Laugh"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who laughs.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A variety of the domestic pigeon.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A contest in which one side wins easily; a lopsided victory.</def> <mark>[Informal]</mark> <br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>A blatantly false statement, especially a self-serving one.</def> <mark>[Slang]</mark><br/
[<source>PJC</source>]</p>

<p><ent>Laughing</ent><br/
<hw>Laugh"ing</hw> <pr>(?)</pr>, <pos>a. & n.</pos> <def>from <er>Laugh</er>, <pos>v. i.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Laughing falcon</b></col> <fld>(Zool.)</fld>, <cd>a South American hawk (<spn>Herpetotheres cachinnans</spn>); -- so called from its notes, which resemble a shrill laugh.</cd> -- <col><b>Laughing gas</b></col> <fld>(Chem.)</fld>, <cd>nitrous oxide, also called hyponitrous oxide, or protoxide of nitrogen; -- so called from the exhilaration and laughing which it sometimes produces when inhaled.  It has been much used as an anaesthetic agent, though now its use is primarily in dentistry</cd> -- <col><b>Laughing goose</b></col> <fld>(Zool.)</fld>, <cd>the European white-fronted goose.</cd> -- <col><b>Laughing gull</b></col>. <fld>(Zool.)</fld> <sd>(a)</sd> <cd>A common European gull (<spn>Xema ridibundus</spn>); -- called also <altname>pewit</altname>, <altname>black cap</altname>, <altname>red-legged gull</altname>, and <altname>sea crow</altname>.</cd> <sd>(b)</sd> <cd>An American gull (<spn>Larus atricilla</spn>). In summer the head is nearly black, the back slate color, and the five outer primaries black.</cd> -- <col><b>Laughing hyena</b></col> <fld>(Zool.)</fld>, <cd>the spotted hyena. See <er>Hyena</er>.</cd> -- <col><b>Laughing jackass</b></col> <fld>(Zool.)</fld>, <cd>the great brown kingfisher (<spn>Dacelo gigas</spn>), of Australia; -- called also <altname>giant kingfisher</altname>, and <altname>gogobera</altname>.</cd> -- <col><b>Laughing owl</b></col> <fld>(Zool.)</fld>, <cd>a peculiar owl (<spn>Sceloglaux albifacies</spn>) of New Zealand, said to be on the verge of extinction. The name alludes to its notes.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laughingly</ent><br/
<hw>Laugh"ing*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>With laughter or merriment.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laughingstock</ent><br/
<hw>Laugh"ing*stock`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An object of ridicule; a butt of sport.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When he talked, he talked nonsense, and made himself the <qex>laughingstock</qex> of his hearers.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laughsome</ent><br/
<hw>Laugh"some</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Exciting laughter; also, addicted to laughter; merry.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laughter</ent><br/
<hw>Laugh"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>hleahtor</ets>; akin to OHG. <ets>hlahtar</ets>, G. <ets>gel<aum/chter</ets>, Icel. <ets>hl<amac/tr</ets>, Dan. <ets>latter</ets>. See <er>Laugh</er>, <pos>v. i.</pos> ]</ety> <def>A movement (usually involuntary) of the muscles of the face, particularly of the lips, with a peculiar expression of the eyes, indicating merriment, satisfaction, or derision, and usually attended by a sonorous and interrupted expulsion of air from the lungs. See <er>Laugh</er>, <pos>v. i.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The act of <qex>laughter</qex>, which is a sweet contraction of the muscles of the face, and a pleasant agitation of the vocal organs, is not merely, or totally within the jurisdiction of ourselves.</q> <rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Archly the maiden smiled, and with eyes overrunning with <qex>laughter</qex>.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laughterless</ent><br/
<hw>Laugh"ter*less</hw>, <pos>a.</pos> <def>Not laughing; without laughter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laughworthy</ent><br/
<hw>Laugh"wor`thy</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Deserving to be laughed at.</def> <mark>[R.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laumontite</ent><br/
<hw>Lau"mont*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From Dr. <ets>Laumont</ets>, the discoverer.]</ety> <fld>(Min.)</fld> <def>A mineral, of a white color and vitreous luster. It is a hydrous silicate of alumina and lime. Exposed to the air, it loses water, becomes opaque, and crumbles.</def> <altsp>[Written also <asp>laumonite</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launce</ent><br/
<hw>Launce</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A lance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launce</ent><br/
<hw>Launce</hw>, <pos>n.</pos> <ety>[It. <ets>lance</ets>, L. <ets>lanx</ets>, <ets>lancis</ets>, plate, scale of a balance.  Cf. <er>Balance</er>.]</ety> <def>A balance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Fortune all in equal <qex>launce</qex> doth sway.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launce</ent><br/
<hw>Launce</hw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Lant</er>, the fish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launcegaye</ent><br/
<hw>Launce"gaye`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lancegaye</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launch</ent><br/
<hw>Launch</hw> <pr>(l<add/nch <it>or</it> l<aum/nch)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Launched</conjf> <pr>(l<add/ncht <it>or</it> l<aum/ncht)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Launching</conjf>.]</vmorph> <ety>[OE. <ets>launchen</ets> to throw as a lance, OF. <ets>lanchier</ets>, another form of <ets>lancier</ets>, F. <ets>lancer</ets>, fr. <ets>lance</ets> lance. See <er>Lance</er>.]</ety> <altsp>[Written also <asp>lanch</asp>.]</altsp> <sn>1.</sn> <def>To throw, as a lance or dart; to hurl; to let fly.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To strike with, or as with, a lance; to pierce.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Launch</qex> your hearts with lamentable wounds.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To cause to move or slide from the land into the water; to set afloat; <as>as, to <ex>launch</ex> a ship</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>With stays and cordage last he rigged the ship,<br/
And rolled on levers, <qex>launched</qex> her in the deep.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To send out; to start (one) on a career; to set going; to give a start to (something); to put in operation; <as>as, to <ex>launch</ex> a son in the world; to <ex>launch</ex> a business project or enterprise.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>All art is used to sink episcopacy, and <qex>launch</qex> presbytery in England.</q> <rj><qau>Eikon Basilike.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launch</ent><br/
<hw>Launch</hw>, <pos>v. i.</pos> <def>To move with force and swiftness like a sliding from the stocks into the water; to plunge; to make a beginning; <as>as, to <ex>launch</ex> into the current of a stream; to <ex>launch</ex> into an argument or discussion; to <ex>launch</ex> into lavish expenditures</as>; -- often with <xex>out</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Launch</qex> out into the deep, and let down your nets for a draught.</q> <rj><qau>Luke v. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He [Spenser] <qex>launches</qex> out into very flowery paths.</q> <rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launch</ent><br/
<hw>Launch</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of launching.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The movement of a vessel from land into the water; especially, the sliding on ways from the stocks on which it is built.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <ety>[Cf. Sp. <ets>lancha</ets>.]</ety> <fld>(Naut.)</fld> <def>The boat of the largest size belonging to a ship of war; also, an open boat of any size driven by steam, naphtha, electricity, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Launching ways</b></col>. <fld>(Naut.)</fld> <cd>See <er>Way</er>, <pos>n.</pos> <fld>(Naut.)</fld>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>launcher</ent><br/
<hw>launcher</hw> <pos>n.</pos> <sn>1.</sn> <def>a device capable of launching a rocket.</def><br/
<syn><b>Syn. --</b> rocket launcher.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A device which launches aircraft from an aircraft carrier; -- it provides additional velocity to the airplane, to supplement that from the airplane's engines, so that the airplane rapidly achieves a velocity sufficient to sustain it in flight when taking off.</def><br/
<syn><b>Syn. --</b> catapult.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>launching</ent><br/
<hw>launching</hw> <pos>n.</pos> <sn>1.</sn> <def>the act of moving a newly-built vessel into the water for the first time.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>the act of beginning something new.</def><br/
<syn><b>Syn. --</b> debut, first appearance, unveiling, introduction, entry.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>the act of propelling with force.</def><br/
<syn><b>Syn. --</b> launch.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>launchpad</ent><br/
<hw>launchpad</hw> <pos>n.</pos> <fld>(Rocketry)</fld> <def>a platform from which rockets or space craft are launched.</def><br/
<syn><b>Syn. --</b> launching pad, launch pad, launch area, pad.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laund</ent><br/
<hw>Laund</hw> <pr>(l<add/nd)</pr>, <pos>n.</pos> <ety>[See <er>Lawn</er> of grass.]</ety> <def>A plain sprinkled with trees or underbrush; a glade.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In a <qex>laund</qex> upon an hill of flowers.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Through this <qex>laund</qex> anon the deer will come.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launder</ent><br/
<hw>Laun"der</hw> <pr>(l<add/n"d<etil/r <it>or</it> l<aum/n"d<etil/r)</pr>, <pos>n.</pos> <ety>[Contracted fr. OE. <ets>lavender</ets>, F. <ets>lavandi<egrave/re</ets>, LL. <ets>lavandena</ets>, from L. <ets>lavare</ets> to wash. See <er>Lave</er>.]</ety> <sn>1.</sn> <def>A washerwoman.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mining)</fld> <def>A trough used by miners to receive the powdered ore from the box where it is beaten, or for carrying water to the stamps, or other apparatus, for comminuting, or sorting, the ore.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launder</ent><br/
<hw>Laun"der</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Laundered</conjf> <pr>(l<add/n"d<etil/rd <it>or</it> l<aum/n"d<etil/rd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laundering</conjf>.]</vmorph> <sn>1.</sn> <def>To wash, as clothes; to wash, and to smooth with a flatiron or mangle; to wash and iron; <as>as, to <ex>launder</ex> shirts</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To lave; to wet.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Launderer</ent><br/
<hw>Laun"der*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who follows the business of laundering.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laundering</ent><br/
<hw>Laun"der*ing</hw>, <pos>n.</pos> <def>The act, or occupation, of one who launders; washing and ironing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laundress</ent><br/
<hw>Laun"dress</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A woman whose employment is laundering.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laundress</ent><br/
<hw>Laun"dress</hw>, <pos>v. i.</pos> <def>To act as a laundress.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laundry</ent><br/
<hw>Laun"dry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Laundries</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>lavendrie</ets>, OF. <ets>lavanderie</ets>. See <er>Launder</er>.]</ety> <sn>1.</sn> <def>A laundering; a washing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A place or room where laundering is done; a laundry room.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A business establishment where clothing is laundered for a fee.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>A collection of items such as articles of clothing or bed linens that need to be laundered, or have just been laundered; <as>as, put the dirty <ex>laundry</ex> in the basket and take it downstairs; hang the <ex>laundry</ex> out to dry</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>coin laundry</b></col> <cd>A business establishment with washing and drying machines operated by coins, where items such as articles of clothing may be laundered and dried by the customer.</cd></cs><br/
[<source>PJC</source>]</p>

<p><ent>Laundryman</ent><br/
<hw>Laun"dry*man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Laundrymen</plw> <pr>(<?/)</pr>.</plu> <def>A man who follows the business of laundering.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laura</ent><br/
<hw>Lau"ra</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL., fr. Gr. (<?/) lane, defile, also, a kind of monastery.]</ety> <fld>(R. C. Ch.)</fld> <def>A number of hermitages or cells in the same neighborhood occupied by anchorites who were under the same superior.</def>  <rj><au>C. Kingsley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lauraceous</ent><br/
<hw>Lau*ra"ceous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Laurus</er>.]</ety> <fld>(Bot.)</fld> <def>Belonging to, or resembling, a natural order (<ord>Laurace<ae/</ord>) of trees and shrubs having aromatic bark and foliage, and including the laurel, sassafras, cinnamon tree, true camphor tree, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurate</ent><br/
<hw>Lau"rate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of lauric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laureate</ent><br/
<hw>Lau"re*ate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laureatus</ets>, fr. <ets>laurea</ets> laurel tree, fr. <ets>laureus</ets> of laurel, fr. <ets>laurus</ets> laurel: cf. F. <ets>laur<eacute/at</ets>.  Cf. <er>Laurel</er>.]</ety> <def>Crowned, or decked, with laurel.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To strew the <qex>laureate</qex> hearse where Lycid lies.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Soft on her lap her <qex>laureate</qex> son reclines.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Poet laureate</b></col>. <sd>(b)</sd> <cd>One who received an honorable degree in grammar, including poetry and rhetoric, at the English universities; -- so called as being presented with a wreath of laurel.</cd> <mark>[Obs.]</mark> <sd>(b)</sd> <cd>Formerly, an officer of the king's household, whose business was to compose an ode annually for the king's birthday, and other suitable occasions; now, a poet officially distinguished by such honorary title, the office being a sinecure. It is said this title was first given in the time of Edward IV.</cd> <mark>[Eng.]</mark> <sd>(c)</sd> <cd>A poet who has been publicly recognized as the most pre-eminent poet of a country or region; <as>as, the <ex>poet laureate</ex> of the United States</as>.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Laureate</ent><br/
<hw>Lau"re*ate</hw>, <pos>n.</pos> <sn>1.</sn> <def>One crowned with laurel; a poet laureate.</def> <ldquo/A learned <xex>laureate</xex>.<rdquo/  <rj><au>Cleveland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A person who has been presented with an award for some distinguished achievement; <as>as, a Nobel <ex>laureate</ex>; the Pris de Rome <ex>laureate</ex>; the Music Director <ex>Laureate</ex>; the conductor <ex>laureate</ex></as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Laureate</ent><br/
<hw>Lau"re*ate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Laureated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laureating</conjf> <pr>(?)</pr>.]</vmorph> <def>To honor with a wreath of laurel, as formerly was done in bestowing a degree at the English universities.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laureateship</ent><br/
<hw>Lau"re*ate*ship</hw>, <pos>n.</pos> <def>State, or office, of a laureate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laureation</ent><br/
<hw>Lau`re*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>laur<eacute/ation</ets>.]</ety> <def>The act of crowning with laurel; the act of conferring an academic degree, or honorary title.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurel</ent><br/
<hw>Lau"rel</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>lorel</ets>, <ets>laurer</ets>, <ets>lorer</ets>, OF. <ets>lorier</ets>, <ets>laurier</ets>, F. <ets>laurier</ets>, (assumed) LL. <ets>Laurarius</ets>, fr. L. <ets>laurus</ets>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>An evergreen shrub, of the genus <gen>Laurus</gen> (<spn>Laurus nobilis</spn>), having aromatic leaves of a lanceolate shape, with clusters of small, yellowish white flowers in their axils; -- called also <altname>sweet bay</altname>.</def> <note>The fruit is a purple berry. It is found about the Mediterranean, and was early used by the ancient Greeks to crown the victor in the games of Apollo. At a later period, academic honors were indicated by a crown of laurel, with the fruit. The leaves and tree yield an aromatic oil, used to flavor the bay water of commerce.</note><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name is extended to other plants which in some respect resemble the true laurel. See Phrases, below.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A crown of laurel; hence, honor; distinction; fame; -- especially in the plural; <as>as, to win <ex>laurels</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An English gold coin made in 1619, and so called because the king's head on it was crowned with laurel.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Laurel water</b></col>, <cd>water distilled from the fresh leaves of the cherry laurel, and containing prussic acid and other products carried over in the process.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>American laurel</b></col>, <it>or</it> <col><b>Mountain laurel</b></col></mcol>, <cd><spn>Kalmia latifolia</spn>; called also <altname>calico bush</altname>. See under <er>Mountain</er>.</cd> -- <col><b>California laurel</b></col>, <cd><spn>Umbellularia Californica</spn>.</cd> -- <col><b>Cherry laurel</b></col> <cd>(in England called <altname>laurel</altname>). See under <er>Cherry</er>.</cd> -- <col><b>Great laurel</b></col>, <cd>the rosebay (<spn>Rhododendron maximum</spn>).</cd> -- <col><b>Ground laurel</b></col>, <cd>trailing arbutus.</cd> -- <col><b>New Zealand laurel</b></col>, <cd>the <spn>Laurelia Nov<ae/ Zelandi<ae/</spn>.</cd> -- <col><b>Portugal laurel</b></col>, <cd>the <spn>Prunus Lusitanica</spn>.</cd> -- <col><b>Rose laurel</b></col>, <cd>the oleander. See <er>Oleander</er>.</cd> -- <col><b>Sheep laurel</b></col>, <cd>a poisonous shrub, <spn>Kalmia angustifolia</spn>, smaller than the mountain laurel, and with smaller and redder flowers.</cd> -- <col><b>Spurge laurel</b></col>, <cd><spn>Daphne Laureola</spn>.</cd> -- <col><b>West Indian laurel</b></col>, <cd><spn>Prunus occidentalis</spn>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laureled</ent><br/
<hw>Lau"reled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Crowned with laurel, or with a laurel wreath; laureate.</def> <altsp>[Written also <asp>laurelled</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>laurels</ent><br/
<hw>lau"rels</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>An honor or honors conferred for some notable achievement.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>to rest on one's laurels</b></col> <mark>[fig.]</mark>  <cd>to be content with one's past achievements and not strive to continue to excel; <as>as, he didn't <ex>rest on his laurels</ex> after receiving the Nobel Prize, but went on to made even more significant discoveries</as>.</cd></cs><br/
[<source>PJC</source>]</p>

<p><ent>laurel-tree</ent><br/
<hw>laurel-tree</hw> <pos>n.</pos> <def>A small tree (<spn>Persea borbonia</spn>) of the Southern U. S. having dark red heartwood.</def><br/
<syn><b>Syn. --</b> red bay, <spn>Persea borbonia</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laurentian</ent><br/
<hw>Lau*ren"tian</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Pertaining to, or near, the St. Lawrence River; <as>as, the <ex>Laurentian</ex> hills</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Laurentian period</b></col> <fld>(Geol.)</fld>, <cd>the lower of the two divisions of the Arch<ae/an age; -- called also <altname>the Laurentian</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurer</ent><br/
<hw>Lau"rer</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Laurel.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurestine</ent><br/
<hw>Lau"res*tine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. <ets>lautus tinus</ets>, fr. L. <ets>laurus</ets> the laurel + <ets>tinus</ets> laurestine. See <er>Laurel</er>.]</ety> <fld>(Bot.)</fld> <def>The <spn>Viburnum Tinus</spn>, an evergreen shrub or tree of the south of Europe, which flowers during the winter months.</def> <altsp>[Written also <asp>laurustine</asp> and <asp>laurestina</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lauric</ent><br/
<hw>Lau"ric</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Pertaining to, or derived from, the European bay or laurel (<spn>Laurus nobilis</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>pertaining to or combined with <er>lauric acid</er>, the 12-carbon member of the fatty acid series; combined with the acyl group of lauric acid.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lauric acid</ent><br/
<hw>Lauric acid</hw> <fld>(Chem.)</fld>, <def>a white, crystalline substance, <chform>CH3.(CH2)10.COOH</chform>, resembling palmitic acid, and obtained from the fruit of the bay tree, and various other vegetable sources. The sodium salt (<er>sodium lauryl sulfate</er>) is used as a detergent.</def>
<syn><b>Syn. --</b> dodecanoic acid, laurostearic acid, dodecoic acid.</syn><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><ent>Lauriferous</ent><br/
<hw>Lau*rif"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laurifer</ets>; <ets>laurus</ets> + <ets>ferre</ets> to bear.]</ety> <def>Producing, or bringing, laurel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurin</ent><br/
<hw>Lau"rin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>laurine</ets>.]</ety> <fld>(Chem.)</fld> <def>A white crystalline substance extracted from the fruit of the bay (<spn>Laurus nobilis</spn>), and consisting of a complex mixture of glycerin ethers of several organic acids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurinol</ent><br/
<hw>Lau"ri*nol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Laurin</ets> + <ets>-ol</ets>.]</ety> <fld>(Chem.)</fld> <def>Ordinary camphor; -- so called in allusion to the family name (<fam>Laurace<ae/</fam>) of the camphor trees. See <er>Camphor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lauriol</ent><br/
<hw>Lau"ri*ol</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Spurge laurel.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurite</ent><br/
<hw>Lau"rite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety> <fld>(Min.)</fld> <def>A rare sulphide of osmium and ruthenium found with platinum in Borneo and Oregon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurone</ent><br/
<hw>Lau"rone</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lauric</ets> + <ets>-one</ets>.]</ety> <fld>(Chem.)</fld> <def>The ketone of lauric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laurus</ent><br/
\'d8<hw>Lau"rus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., laurel.]</ety> <fld>(Bot.)</fld> <def>A genus of trees including, according to modern authors, only the true laurel (<spn>Laurus nobilis</spn>), and the larger <spn>Laurus Canariensis</spn> of Madeira and the Canary Islands. Formerly the sassafras, the camphor tree, the cinnamon tree, and several other aromatic trees and shrubs, were also referred to the genus <gen>Laurus</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laus</ent><br/
<hw>Laus</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Loose.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lautverschiebung</ent><br/
\'d8<hw>Laut"ver*schie`bung</hw> <pr>(lout"f<ecr/r*sh<emac/`b<oocr/ng)</pr>, <pos>n.</pos>; <plu>pl. <plw>Lautverschiebungen</plw> <pr>(lout"f<ecr/r*sh<emac/`b<oocr/ng*<eit/n)</pr></plu>. <ety>[G.; <ets>laut</ets> sound + <ets>verschiebung</ets> shifting.]</ety> <fld>(Philol.)</fld> <sd>(a)</sd> <def>The regular changes which the primitive Indo-European stops, or mute consonants, underwent in the Teutonic languages, probably as early as the 3d century <sc>b. c.</sc> , often called the <altname>first Lautverschiebung</altname>, <altname>sound shifting</altname>, or <altname>consonant shifting</altname>.</def> <sd>(b)</sd> <def>A somewhat similar set of changes taking place in the High German dialects (less fully in modern literary German) from the 6th to the 8th century, known as the <altname>second Lautverschiebung</altname>, the results of which form the striking differences between High German and The Low German Languages. The statement of these changes is commonly regarded as forming part of <er>Grimm's law</er>, because included in it as originally framed.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>lav</ent><br/
<hw>lav</hw> <pos>n.</pos> <ety>[by truncation of <ets>lav</ets>atory.]</ety> <def>Same as <er>lavatory</er>{5}; -- a shortened form of the word.</def> <mark>[informal]</mark> <br/
<syn><b>Syn. --</b> toilet, lavatory, can, facility, john, privy, bathroom.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lava</ent><br/
<hw>La"va</hw> <pr>(l<aum/"v<adot/; 277)</pr>, <pos>n.</pos> <ety>[It. <ets>lava</ets> lava, orig. in Naples, a torrent of rain overflowing the streets, fr. It. & L. <ets>lavare</ets> to wash. See <er>Lave</er>.]</ety> <def>The melted rock ejected by a volcano from its top or fissured sides. It flows out in streams sometimes miles in length. It also issues from fissures in the earth's surface, and forms beds covering many square miles, as in the Northwestern United States.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Lavas are classed, according to their structure, as scoriaceous or cellular, glassy, stony, etc., and according to the material of which they consist, as doleritic, trachytic, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lava millstone</b></col>, <cd>a hard and coarse basaltic millstone from the neighborhood of the Rhine.</cd> -- <col><b>Lava ware</b></col>, <cd>a kind of cheap pottery made of iron slag cast into tiles, urns, table tops, etc., resembling lava in appearance.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>lavalava</ent><br/
<hw>la`va*la"va</hw> <pr>(l<aum/`v<adot/*l<aum/"v<adot/)</pr>, <pos>n.</pos> <def>A printed cloth garment resembling a skirt or kilt, worn as the principle garment by both men and women in Polynesia, especialy in  Samoa; called also <altname>pareu</altname>.</def><br/
[<source>PJC</source>]</p>

<p><ent>La valliere</ent><br/
<ent>lavallier</ent><br/
<ent>lavaliere</ent><br/
<mhw>{ <hw>la`va`liere"</hw>, <hw>la`val`lier"</hw>, or  <hw>La val`liere"</hw> }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[after the <person>Duchesse de <ets>La Valliere</ets></person>, a mistress of <person>Louis XI.</person> <au>RHUD</au>.]</ety> <def>A neck ornament consisting of a chain and single jewelled pendant, or drop; also, the pendant itself.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>lavaliere microphone</ent><br/
<hw>la`va`liere" mic"ro*phone</hw> <pos>n.</pos> <def>A small microphone worn around the neck on a supporting string or chain.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lavandula</ent><br/
<hw>Lavandula</hw> <pos>n.</pos> <def>A genus of plants of the mint family including the lavender{1}.</def><br/
<syn><b>Syn. --</b> genus <gen>Lavandula</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lavaret</ent><br/
<hw>Lav"a*ret</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <fld>(Zool.)</fld> <def>A European whitefish (<spn>Coregonus laveretus</spn>), found in the mountain lakes of Sweden, Germany, and Switzerland.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavatera</ent><br/
<hw>Lavatera</hw> <pos>n.</pos> <def>A widespread genus of herbs or soft-wooded arborescent shrubs cultivated for their showy flowers.</def><br/
<syn><b>Syn. --</b> genus <gen>Lavatera</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 835 --></p>

<p><ent>Lavatic</ent><br/
<hw>La*vat"ic</hw> <pr>(l<adot/*v<acr/t"<icr/k)</pr>, <pos>a.</pos> <def>Like lava, or composed of lava; lavic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavation</ent><br/
<hw>La*va"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lavatio</ets>: cf. OF. <ets>lavation</ets>.]</ety> <def>A washing or cleansing.</def> <mark>[Obs. or R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavatory</ent><br/
<hw>Lav"a*to*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Washing, or cleansing by washing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavatory</ent><br/
<hw>Lav"a*to*ry</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lavatories</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>lavatorium</ets>: cf. <ets>lavatoire</ets>. See <er>Lave</er> to wash, and cf. <er>Laver</er>.]</ety> <sn>1.</sn> <def>A place for washing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A basin or other vessel for washing in.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A wash or lotion for a diseased part.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A place where gold is obtained by washing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A room containing one or more sinks for washing, as well as one or more toilet fixtures; also called <altname>bathroom</altname>, <altname>toilet</altname>, and sometimes <altname>commode</altname>.  Commode and toilet may refer to a room with only a toilet fixture, but without a sink.</def><br/
<syn><b>Syn. --</b> toilet, lavatory, can, facility, john, privy, bathroom.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Lavature</ent><br/
<hw>Lav"a*ture</hw> <pr>(?; 135)</pr>, <pos>n.</pos> <def>A wash or lotion.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lave</ent><br/
<hw>Lave</hw> <pr>(l<amac/v)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Laved</conjf> <pr>(l<amac/vd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laving</conjf>.]</vmorph> <ety>[F. <ets>laver</ets>, L. <ets>lavare</ets>, akin to <ets>luere</ets> to wash, Gr. <?/.  Cf. <er>Ablution</er>, <er>Deluge</er>, <er>Lavender</er>, <er>Lava</er>, <er>Lotion</er>.]</ety> <def>To wash; to bathe; <as>as, to <ex>lave</ex> a bruise</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His feet the foremost breakers <qex>lave</qex>.</q> <rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lave</ent><br/
<hw>Lave</hw>, <pos>v. i.</pos> <def>To bathe; to wash one's self.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In her chaste current oft the goddess <qex>laves</qex>.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lave</ent><br/
<hw>Lave</hw>, <pos>v. t.</pos> <ety>[OE. <ets>laven</ets>. See <er>Lavish</er>.]</ety> <def>To lade, dip, or pour out.</def> <mark>[Obs.]</mark>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lave</ent><br/
<hw>Lave</hw>, <pos>n.</pos> <ety>[AS. <ets>l<amac/f</ets> the remainder, what is left. <root/119.  See <er>Leave</er>.]</ety> <def>The remainder; others.</def> <mark>[Scot.]</mark>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lave-eared</ent><br/
<hw>Lave"-eared`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. W. <ets>llaf</ets> that extends round, <ets>llipa</ets> flaccid, flapping, G. <ets>lapp</ets> flabby, <ets>lappohr</ets> flap ear.]</ety> <def>Having large, pendent ears.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laveer</ent><br/
<hw>La*veer"</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[D. <ets>laveren</ets>.]</ety> <fld>(Naut.)</fld> <def>To beat against the wind; to tack.</def> <mark>[Obs.]</mark>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavement</ent><br/
<hw>Lave"ment</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>lavement</ets>, fr. <ets>laver</ets> to wash.]</ety> <def>A washing or bathing; also, an enema.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavender</ent><br/
<hw>Lav"en*der</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>lavendre</ets>, F. <ets>lavande</ets>, It. <ets>lavanda</ets> lavender, a washing, fr. L. <ets>lavare</ets> to wash; cf. It. <ets>lsavendola</ets>, LL. <ets>lavendula</ets>.  So called because it was used in bathing and washing. See <er>Lave</er>. to wash, and cf. <er>Lavender</er>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>An aromatic plant of the genus <gen>Lavandula</gen> (<spn>Lavandula vera</spn>), common in the south of Europe. It yields and oil used in medicine and perfumery. The <stype>Spike lavender</stype> (<spn>Lavandula Spica</spn>) yields a coarser oil (oil of spike), used in the arts.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The pale, purplish color of lavender flowers, paler and more delicate than lilac.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lavender cotton</b></col> <fld>(Bot.)</fld>, <cd>a low, twiggy, aromatic shrub (<spn>Santolina Cham<ae/cyparissus</spn>) of the Mediterranean region, formerly used as a vermifuge, etc., and still used to keep moths from wardrobes. Also called <altname>ground cypress</altname>.</cd> -- <col><b>Lavender water</b></col>, <cd>a perfume, toilet water, or shaving lotion containing the essential oil of lavender, and sometimes the essential oil of bergamot, and essence of ambergris.</cd> -- <col><b>Sea lavender</b></col>. <fld>(Bot.)</fld> <cd>See <er>Marsh rosemary</er>.</cd> -- <col><b>To lay in lavender</b></col>. <sd>(a)</sd> <cd>To lay away, as clothing, with sprigs of lavender.</cd> <sd>(b)</sd> <cd>To pawn.</cd> <mark>[Obs.]</mark></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Laver</ent><br/
<hw>Lav"er</hw> <pr>(l<amac/"v<etil/r)</pr>, <pos>n.</pos> <ety>[OE. <ets>lavour</ets>, F. <ets>lavoir</ets>, L. <ets>lavatorium</ets> a washing place. See <er>Lavatory</er>.]</ety> <sn>1.</sn> <def>A vessel for washing; a large basin.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Script. Hist.)</fld> <sd>(a)</sd> <def>A large brazen vessel placed in the court of the Jewish tabernacle where the officiating priests washed their hands and feet.</def> <sd>(b)</sd> <def>One of several vessels in Solomon's Temple in which the offerings for burnt sacrifices were washed.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which washes or cleanses.</def>  <rj><au>J. H. Newman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laver</ent><br/
<hw>Lav"er</hw>, <pos>n.</pos> <ety>[From <er>Lave</er> to wash.]</ety> <def>One who laves; a washer.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laver</ent><br/
<hw>La"ver</hw> <pr>(l<amac/"v<etil/r)</pr>, <pos>n.</pos> <def>The fronds of certain marine alg<ae/ used as food, and for making a sauce called laver sauce.  Green <ex>laver</ex> is the <spn>Ulva latissima</spn>; purple <ex>laver</ex>, <spn>Porphyra laciniata</spn> and <spn>Porphyra vulgaris</spn>. It is prepared by stewing, either alone or with other vegetables, and with various condiments; -- called also <altname>sloke</altname>, or <altname>sloakan</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Mountain laver</b></col> <fld>(Bot.)</fld>, <cd>a reddish gelatinous alga of the genus <gen>Palmella</gen>, found on the sides of mountains</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laverock</ent><br/
<hw>La"ver*ock</hw> <pr>(l<amac/"v<etil/r*<ocr/k)</pr>, <pos>n.</pos> <ety>[See <er>Lark</er> the bird.]</ety> <def>The lark.</def> <mark>[Old Eng. & Scot.]</mark> <altsp>[Written also <asp>lavrock</asp>.]</altsp>  <rj><au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavic</ent><br/
<hw>La"vic</hw> <pr>(l<aum/"v<icr/k)</pr>, <pos>a.</pos> <def>See <er>Lavatic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavish</ent><br/
<hw>Lav"ish</hw> <pr>(l<acr/v"<icr/sh)</pr>, <pos>a.</pos> <ety>[Akin to E. <ets>lave</ets> to lade out; cf. AS. <ets>gelafian</ets> to refresh, G. <ets>laben</ets>.]</ety> <sn>1.</sn> <def>Expending or bestowing profusely; profuse; prodigal; <as>as, <ex>lavish</ex> of money; <ex>lavish</ex> of praise.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Superabundant; excessive; <as>as, <ex>lavish</ex> spirits</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let her have needful, but not <qex>lavish</qex>, means.</q> <rj><qau>Shak.</qau></rj></p>

<p><syn><b>Syn.</b> -- Profuse; prodigal; wasteful; extravagant; exuberant; immoderate. See <er>Profuse</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavish</ent><br/
<hw>Lav"ish</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lavished</conjf> <pr>(-<icr/sht)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lavishing</conjf>.]</vmorph> <def>To expend or bestow with profusion; to use with prodigality; to squander; <as>as, to <ex>lavish</ex> money or praise</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavisher</ent><br/
<hw>Lav"ish*er</hw> <pr>(-<etil/r)</pr>, <pos>n.</pos> <def>One who lavishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavishly</ent><br/
<hw>Lav"ish*ly</hw>, <pos>adv.</pos> <def>In a lavish manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavishment</ent><br/
<hw>Lav"ish*ment</hw> <pr>(-m<eit/nt)</pr>, <pos>n.</pos> <def>The act of lavishing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavishness</ent><br/
<hw>Lav"ish*ness</hw>, <pos>n.</pos> <def>The quality or state of being lavish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavoesium</ent><br/
\'d8<hw>La*v<oe/"si*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. <persfn><etsep>Lavoisier</etsep></persfn>, the celebrated French chemist.]</ety> <fld>(Chem.)</fld> <def>A supposed new metallic element, which was said to have been discovered in pyrites, and some other minerals, and to be of a silver-white color, and malleable.  It is not currently (1998) a recognized element.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Lavolta</ent><br/
<ent>Lavolt</ent><br/
<mhw>{ <hw>La*volt"</hw> <pr>(?)</pr>, <hw>La*vol"ta</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[It. <ets>la volta</ets> the turn, turning, whirl.  Cf. <er>Volt</er> of a horse, <er>Volta</er>.]</ety> <def>An old dance, for two persons, being a kind of waltz, in which the woman made a high spring or bound.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavoltateer</ent><br/
<hw>La*vol`ta*teer"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A dancer of the lavolta.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavour</ent><br/
<hw>Lav"our</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A laver.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lavrock</ent><br/
<hw>La"vrock</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Laverock</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Law</ent><br/
<hw>Law</hw> <pr>(l<add/)</pr>, <pos>n.</pos> <ety>[OE. <ets>lawe</ets>, <ets>laghe</ets>, AS. <ets>lagu</ets>, from the root of E. <ets>lie</ets>: akin to OS. <ets>lag</ets>, Icel. <ets>l<oum/g</ets>, Sw. <ets>lag</ets>, Dan. <ets>lov</ets>; cf. L. <ets>lex</ets>, E. <ets>legal</ets>. A <ets>law</ets> is that which is <ets>laid</ets>, set, or fixed; like <ets>statute</ets>, fr. L. <ets>statuere</ets> to make to stand. See <er>Lie</er> to be prostrate.]</ety> <sn>1.</sn> <def>In general, a rule of being or of conduct, established by an authority able to enforce its will; a controlling regulation; the mode or order according to which an agent or a power acts.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A law may be universal or particular, written or unwritten, published or secret. From the nature of the highest laws a degree of permanency or stability is always implied; but the power which makes a law, or a superior power, may annul or change it.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>These are the statutes and judgments and <qex>laws</qex>, which the Lord made.</q> <rj><qau>Lev. xxvi. 46.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>law</qex> of thy God, and the <qex>law</qex> of the King.</q> <rj><qau>Ezra vii. 26.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>As if they would confine the Interminable . . . <br/
Who made our <qex>laws</qex> to bind us, not himself.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His mind his kingdom, and his will his <qex>law</qex>.</q> <rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In morals: The will of God as the rule for the disposition and conduct of all responsible beings toward him and toward each other; a rule of living, conformable to righteousness; the rule of action as obligatory on the conscience or moral nature.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The Jewish or Mosaic code, and that part of Scripture where it is written, in distinction from the <contr>gospel</contr>; hence, also, the Old Testament.</def>  <specif>Specifically:</specif> <def>the first five books of the bible, called also <altname>Torah</altname>, <altname>Pentatech</altname>, or <altname>Law of Moses</altname>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>What things soever the <qex>law</qex> saith, it saith to them who are under the <qex>law</qex> . . . But now the righteousness of God without the <qex>law</qex> is manifested, being witnessed by the <qex>law</qex> and the prophets.</q> <rj><qau>Rom. iii. 19, 21. </qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> In human government: <sd>(a)</sd> <def>An organic rule, as a constitution or charter, establishing and defining the conditions of the existence of a state or other organized community.</def> <sd>(b)</sd> <def>Any edict, decree, order, ordinance, statute, resolution, judicial, decision, usage, etc., or recognized, and enforced, by the controlling authority.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>In philosophy and physics: A rule of being, operation, or change, so certain and constant that it is conceived of as imposed by the will of God or by some controlling authority; <as>as, the <ex>law</ex> of gravitation; the <ex>laws</ex> of motion; the <ex>law</ex> heredity; the <ex>laws</ex> of thought; the <ex>laws</ex> of cause and effect; <ex>law</ex> of self-preservation.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>In mathematics: The rule according to which anything, as the change of value of a variable, or the value of the terms of a series, proceeds; mode or order of sequence.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>In arts, works, games, etc.: The rules of construction, or of procedure, conforming to the conditions of success; a principle, maxim; or usage; <as>as, the <ex>laws</ex> of poetry, of architecture, of courtesy, or of whist</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>Collectively, the whole body of rules relating to one subject, or emanating from one source; -- including usually the writings pertaining to them, and judicial proceedings under them; <as>as, divine <ex>law</ex>; English <ex>law</ex>; Roman <ex>law</ex>; the <ex>law</ex> of real property; insurance <ex>law</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>Legal science; jurisprudence; the principles of equity; applied justice.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Reason is the life of the <qex>law</qex>; nay, the common <qex>law</qex> itself is nothing else but reason.</q> <rj><qau>Coke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Law</qex> is beneficence acting by rule.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And sovereign <qex>Law</qex>, that state's collected will<br/
O'er thrones and globes elate,<br/
Sits empress, crowning good, repressing ill.</q> <rj><qau>Sir W. Jones.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>Trial by the laws of the land; judicial remedy; litigation; <as>as, to go <ex>law</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When every case in <qex>law</qex> is right.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He found <qex>law</qex> dear and left it cheap.</q> <rj><qau>Brougham.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <def>An oath, as in the presence of a court.</def> <mark>[Obs.]</mark> <see>See <cref>Wager of law</cref>, under <er>Wager</er>.</see><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Avogadro's law</b></col> <fld>(Chem.)</fld>, <cd>a fundamental conception, according to which, under similar conditions of temperature and pressure, all gases and vapors contain in the same volume the same number of ultimate molecules; -- so named after <etsep>Avogadro</etsep>, an Italian scientist. Sometimes called <altname>Amp<egrave/re's law</altname>.</cd> -- <col><b>Bode's law</b></col> <fld>(Astron.)</fld>, <cd>an approximative empirical expression of the distances of the planets from the sun, as follows: -- </p>

<p><table><pre>
<row>Mer. Ven. Earth. Mars.  Aste.  Jup.  Sat.  Uran.   Nep.</row>
<row> 4    4     4     4      4      4     4      4      4</row>
<row> 0    3     6    12     24     48    96     192   384</row>
<row> --   --   --    --     --     --    --     ---   ---</row>
<row> 4    7    10    16     28     52   100     196   388</row>
<row> 5.9  7.3  10    15.2   27.4   52    95.4   192   300</row>
</pre></table></p>

<p>where each distance (line third) is the sum of 4 and a multiple of 3 by the series 0, 1, 2, 4, 8, etc., the true distances being given in the lower line.</cd> -- <col><b>Boyle's law</b></col> <fld>(Physics)</fld>, <cd>an expression of the fact, that when an elastic fluid is subjected to compression, and kept at a constant temperature, the product of the pressure and volume is a constant quantity, <it>i. e.</it>, the volume is inversely proportioned to the pressure; -- known also as <altname>Mariotte's law</altname>, and the <altname>law of Boyle and Mariotte</altname>.</cd> -- <col><b>Brehon laws</b></col>. <cd>See under <er>Brehon</er>.</cd> -- <col><b>Canon law</b></col>, <cd>the body of ecclesiastical law adopted in the Christian Church, certain portions of which (for example, the law of marriage as existing before the Council of Tent) were brought to America by the English colonists as part of the common law of the land.</cd> <au>Wharton.</au> -- <col><b>Civil law</b></col>, <cd>a term used by writers to designate Roman law, with modifications thereof which have been made in the different countries into which that law has been introduced. The civil law, instead of the <contr>common law</contr>, prevails in the State of Louisiana.</cd> <au>Wharton.</au> -- <col><b>Commercial law</b></col>. <cd>See <cref>Law merchant</cref> (below).</cd> -- <col><b>Common law</b></col>. <cd>See under <er>Common</er>.</cd> -- <col><b>Criminal law</b></col>, <cd>that branch of jurisprudence which relates to crimes.</cd> -- <col><b>Ecclesiastical law</b></col>. <cd>See under <er>Ecclesiastical</er>.</cd> -- <col><b>Grimm's law</b></col> <fld>(Philol.)</fld>, <cd>a statement (propounded by the German philologist <person>Jacob <etsep>Grimm</etsep></person>) of certain regular changes which the primitive Indo-European mute consonants, so-called (most plainly seen in Sanskrit and, with some changes, in Greek and Latin), have undergone in the Teutonic languages. Examples: Skr. <xex>bh</xex><amac/t<rsdot/, L. <xex>f</xex>rater, E. <xex>b</xex>rother, G. <xex>b</xex>ruder; L. <xex>t</xex>res, E. <xex>th</xex>ree, G. <xex>dr</xex>ei, Skr. <xex>g</xex>o, E. <xex>c</xex>ow, G. <xex>k</xex>uh; Skr. <xex>dh</xex><amac/ to put, Gr. <grk>ti-qe`-nai</grk>, E. <xex>d</xex>o, OHG, <xex>t</xex>uon, G. <xex>th</xex>un.  See also <er>lautverschiebung</er>.</cd> -- <col><b>Kepler's laws</b></col> <fld>(Astron.)</fld>, <cd>three important laws or expressions of the order of the planetary motions, discovered by John <etsep>Kepler</etsep>. They are these: (1) The orbit of a planet with respect to the sun is an ellipse, the sun being in one of the foci. (2) The areas swept over by a vector drawn from the sun to a planet are proportioned to the times of describing them. (3) The squares of the times of revolution of two planets are in the ratio of the cubes of their mean distances.</cd> -- <col><b>Law binding</b></col>, <cd>a plain style of leather binding, used for law books; -- called also <altname>law calf</altname>.</cd> -- <col><b>Law book</b></col>, <cd>a book containing, or treating of, laws.</cd> -- <col><b>Law calf</b></col>. <cd>See <cref>Law binding</cref> (above).</cd> -- <col><b>Law day</b></col>. <sd>(a)</sd> <cd>Formerly, a day of holding court, esp. a court-leet.</cd> <sd>(b)</sd> <cd>The day named in a mortgage for the payment of the money to secure which it was given.</cd> <mark>[U. S.]</mark> -- <col><b>Law French</b></col>, <cd>the dialect of Norman, which was used in judicial proceedings and law books in England from the days of <person>William the Conqueror</person> to the thirty-sixth year of Edward III.</cd> -- <col><b>Law language</b></col>, <cd>the language used in legal writings and forms.</cd> -- <col><b>Law Latin</b></col>. <cd>See under <er>Latin</er>.</cd> -- <col><b>Law lords</b></col>, <cd>peers in the British Parliament who have held high judicial office, or have been noted in the legal profession.</cd> -- <mcol><col><b>Law merchant</b></col>, <it>or</it> <col><b>Commercial law</b></col></mcol>, <cd>a system of rules by which trade and commerce are regulated; -- deduced from the custom of merchants, and regulated by judicial decisions, as also by enactments of legislatures.<-- now in most state superseded by the Uniform Commercial Code --></cd> -- <col><b>Law of Charles</b></col> <fld>(Physics)</fld>, <cd>the law that the volume of a given mass of gas increases or decreases, by a definite fraction of its value for a given rise or fall of temperature; -- sometimes less correctly styled <altname>Gay Lussac's law</altname>, or <altname>Dalton's law</altname>.</cd> -- <col><b>Law of nations</b></col>. <cd>See <cref>International law</cref>, under <er>International</er>.</cd> -- <col><b>Law of nature</b></col>. <sd>(a)</sd> <cd>A broad generalization expressive of the constant action, or effect, of natural conditions; <as>as, death is a <ex>law of nature</ex>; self-defense is a <ex>law of nature</ex></as>. See <er>Law</er>, 4.</cd> <sd>(b)</sd> <cd>A term denoting the standard, or system, of morality deducible from a study of the nature and natural relations of human beings independent of supernatural revelation or of municipal and social usages.</cd> -- <col><b>Law of the land</b></col>, <cd>due process of law; the general law of the land.</cd> -- <col><b>Laws of honor</b></col>. <cd>See under <er>Honor</er>.</cd> -- <col><b>Laws of motion</b></col> <fld>(Physics)</fld>, <cd>three laws defined by <person>Sir Isaac Newton</person>: (1) Every body perseveres in its state of rest or of moving uniformly in a straight line, except so far as it is made to change that state by external force. (2) Change of motion is proportional to the impressed force, and takes place in the direction in which the force is impressed. (3) Reaction is always equal and opposite to action, that is to say, the actions of two bodies upon each other are always equal and in opposite directions.</cd> -- <mcol><col><b>Marine law</b></col>, <it>or</it> <col><b>Maritime law</b></col></mcol>, <cd>the law of the sea; a branch of the law merchant relating to the affairs of the sea, such as seamen, ships, shipping, navigation, and the like.</cd> <au>Bouvier.</au> -- <col><b>Mariotte's law</b></col>. <cd>See <cref>Boyle's law</cref> (above).</cd> -- <col><b>Martial law</b></col>.<cd>See under <er>Martial</er>.</cd> -- <col><b>Military law</b></col>, <cd>a branch of the general municipal law, consisting of rules ordained for the government of the military force of a state in peace and war, and administered in courts martial.</cd> <au>Kent.</au>  <au>Warren's Blackstone.</au> -- <col><b>Moral law</b></col>, <cd>the law of duty as regards what is right and wrong in the sight of God; specifically, the ten commandments given by Moses. See <er>Law</er>, 2.</cd> -- <mcol><col><b>Mosaic law</b></col>, <it>or</it> <col><b>Ceremonial law</b></col></mcol>. <fld>(Script.)</fld> <cd>See <er>Law</er>, 3.</cd> -- <mcol><col><b>Municipal law</b></col>, <it>or</it> <col><b>Positive law</b></col></mcol>, <cd>a rule prescribed by the supreme power of a state, declaring some right, enforcing some duty, or prohibiting some act; -- distinguished from <contr>international law</contr> and <contr>constitutional law</contr>. See <er>Law</er>, 1.</cd> -- <col><b>Periodic law</b></col>. <fld>(Chem.)</fld> <cd>See under <er>Periodic</er>.</cd> -- <col><b>Roman law</b></col>, <cd>the system of principles and laws found in the codes and treatises of the lawmakers and jurists of ancient Rome, and incorporated more or less into the laws of the several European countries and colonies founded by them. See <cref>Civil law</cref> (above).</cd> -- <col><b>Statute law</b></col>, <cd>the law as stated in statutes or positive enactments of the legislative body.</cd> -- <col><b>Sumptuary law</b></col>. <cd>See under <er>Sumptuary</er>.</cd> -- <col><b>To go to law</b></col>, <cd>to seek a settlement of any matter by bringing it before the courts of law; to sue or prosecute some one.</cd> -- <mcol><col><b>To take the law of</b></col>, <it>or</it> <col><b>To have the law of</b></col></mcol>, <cd>to bring the law to bear upon; <as>as, <ex>to take the law of</ex> one's neighbor</as>.</cd> <au>Addison.</au> -- <col><b>Wager of law</b></col>. <cd>See under <er>Wager</er>.</cd></cs></p>

<p><syn><b>Syn.</b> -- Justice; equity.</syn> <usage> -- <er>Law</er>, <er>Statute</er>, <er>Common law</er>, <er>Regulation</er>, <er>Edict</er>, <er>Decree</er>. <xex>Law</xex> is generic, and, when used with reference to, or in connection with, the other words here considered, denotes whatever is commanded by one who has a right to require obedience. A <xex>statute</xex> is a particular law drawn out in form, and distinctly enacted and proclaimed. <xex>Common law</xex> is a rule of action founded on long usage and the decisions of courts of justice. A <xex>regulation</xex> is a limited and often, temporary law, intended to secure some particular end or object. An <xex>edict</xex> is a command or law issued by a sovereign, and is peculiar to a despotic government. A <xex>decree</xex> is a permanent order either of a court or of the executive government. See <er>Justice</er>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Law</ent><br/
<hw>Law</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>Same as <er>Lawe</er>, <pos>v. t.</pos></def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Law</ent><br/
<hw>Law</hw>, <pos>interj.</pos> <ety>[Cf. <er>La</er>.]</ety> <def>An exclamation of mild surprise.</def> <mark>[Archaic or Low]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Law-abiding</ent><br/
<hw>Law"-a*bid`ing</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Abiding the law; waiting for the operation of law for the enforcement of rights; also, abiding by the law; obedient to the law; <as>as, <ex>law-abiding</ex> people</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>law-breaking</ent><br/
<hw>law-breaking</hw> <pos>n.</pos> <sn>1.</sn> <def>an act punishable by law; usually considered an evil act.</def><br/
<syn><b>Syn. --</b> crime.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>law-breaker</ent><br/
<ent>lawbreaker</ent><br/
<mhw><hw>law"break`er</hw>, <hw>law"-break`er</hw></mhw> <pr>(?)</pr>, <pos>n.</pos> <def>One who disobeys the law; someone who violates the law; a criminal.</def><br/
<syn><b>Syn. --</b> violator, lawbreaker, law breaker, perpetrator.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p> -- <wordforms><wf>Law"break`ing</wf>, <pos>n. & a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawe</ent><br/
<hw>Lawe</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[See 2d <er>Lawing</er>.]</ety> <def>To cut off the claws and balls of, as of a dog's fore feet.</def>  <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawer</ent><br/
<hw>Law"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A lawyer.</def> <mark>[Obs.]</mark>  <rj><au>Bale.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawful</ent><br/
<hw>Law"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Conformable to law; allowed by law; legitimate; competent.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Constituted or authorized by law; rightful; <as>as, the <ex>lawful</ex> owner of lands</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lawful age</b></col>, <cd>the age when the law recognizes one's right of independent action; majority; -- generally the age of twenty-one years.  Also called <altname>legal age</altname> or <altname>age of majority</altname>.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><note><hand/ In some of the States, and for some purposes, a woman attains <xex>lawful age</xex> at eighteen. <au>Abbott.</au></note></p>

<p><syn><b>Syn.</b> -- Legal; constitutional; allowable; regular; rightful.</syn> <usage> -- <er>Lawful</er>, <er>Legal</er>. <xex>Lawful</xex> means conformable to the principle, spirit, or essence of the law, and is applicable to moral as well as juridical law. <xex>Legal</xex> means conformable to the letter or rules of the law as it is administered in the courts; conformable to juridical law. <xex>Legal</xex> is often used as antithetical to <xex>equitable</xex>, but <xex>lawful</xex> is seldom used in that sense.</usage></p>

<p>-- <wordforms><wf>Law"ful*ly</wf>, <pos>adv.</pos> -- <wf>Law"ful*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>lawfully-begotten</ent><br/
<hw>lawfully-begotten</hw> <pos>adj.</pos> <def>born in wedlock; legitimate; enjoying full filial rights; not illegitimate; -- of people.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lawgiver</ent><br/
<hw>Law"giv`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who makes or enacts a law or system of laws; a legislator.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawgiving</ent><br/
<hw>Law"giv`ing</hw>, <pos>a.</pos> <def>Enacting laws; legislative.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawing</ent><br/
<hw>Law"ing</hw>, <pos>n.</pos> <def>Going to law; litigation.</def>  <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawing</ent><br/
<hw>Law"ing</hw>, <pos>n.</pos> <ety>[So called because done in compliance with an English forest <ets>law</ets>.]</ety> <def>Expeditation.</def>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawless</ent><br/
<hw>Law"less</hw>, <pos>a.</pos> <sn>1.</sn> <def>Contrary to, or unauthorized by, law; illegal; <as>as, a <ex>lawless</ex> claim</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He needs no indirect nor <qex>lawless</qex> course.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not subject to, or restrained by, the law of morality or of society; <as>as, <ex>lawless</ex> men or behavior</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Not subject to the laws of nature; uncontrolled.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Or, meteorlike, flame <qex>lawless</qex> through the void.</q> <rj><qau>Pope.</qau></rj></p>

<p>-- <wordforms><wf>Law"less*ly</wf>, <pos>adv.</pos> -- <wf>Law"less*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawmaker</ent><br/
<hw>Law"mak`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A legislator; a lawgiver.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>law-makers</ent><br/
<hw>law-makers</hw> <pos>n. pl.</pos> <def>Those persons who make or amend or repeal laws, collectively.</def><br/
<syn><b>Syn. --</b> legislature, legislative assembly, general assembly.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 836 --></p>

<p><ent>Lawmaking</ent><br/
<hw>Law"mak`ing</hw> <pr>(l<add/"m<amac/`k<icr/ng)</pr>, <pos>a.</pos> <def>Enacting laws; legislative.</def> -- <def2><pos>n.</pos> <def>The enacting of laws; legislation.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawmonger</ent><br/
<hw>Law"mon`ger</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A trader in law; one who practices law as if it were a trade.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawn</ent><br/
<hw>Lawn</hw> <pr>(l<add/n)</pr>, <pos>n.</pos> <ety>[OE. <ets>laund</ets>, <ets>launde</ets>, F. <ets>lande</ets> heath, moor; of Celtic origin; cf. W. <ets>llan</ets> an open, clear place, <ets>llawnt</ets> a smooth rising hill, lawn, Armor. <ets>lann</ets> or <ets>lan</ets> territory, country, <ets>lann</ets> a prickly plant, pl. <ets>lannou</ets> heath, moor.]</ety> <sn>1.</sn> <def>An open space between woods.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><ldquo/Orchard <qex>lawns</qex> and bowery hollows.<rdquo/</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Ground (generally in front of or around a house) covered with grass kept closely mown.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lawn mower</b></col>, <cd>a machine for clipping the short grass of lawns.</cd> -- <col><b>Lawn tennis</b></col>, <cd>a variety of the game of tennis, played in the open air, sometimes upon a lawn, instead of in a tennis court. See <er>Tennis</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawn</ent><br/
<hw>Lawn</hw>, <pos>n.</pos> <ety>[Earlier <ets>laune lynen</ets>, i. e., <ets>lawn linen</ets>; prob. from the town <ets>Laon</ets> in France.]</ety> <def>A very fine linen (or sometimes cotton) fabric with a rather open texture. Lawn is used for the sleeves of a bishop's official dress in the English Church, and, figuratively, stands for the office itself.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A saint in crape is twice a saint in <qex>lawn</qex>.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawnd</ent><br/
<hw>Lawnd</hw> <pr>(l<add/nd)</pr>, <pos>n.</pos> <mark>[Obs.]</mark> <def>See <er>Laund</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawny</ent><br/
<hw>Lawn"y</hw> <pr>(l<add/n"<ycr/)</pr>, <pos>a.</pos> <def>Having a lawn; characterized by a lawn or by lawns; like a lawn.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Musing through the <qex>lawny</qex> park.</q> <rj><qau>T. Warton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawny</ent><br/
<hw>Lawn"y</hw>, <pos>a.</pos> <def>Made of lawn or fine linen.</def>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lawrencium</ent><br/
<hw>lawrencium</hw> <pos>n.</pos> <ety>[from <person>Ernest O. <etsep>Lawrence</etsep></person>, inventer of the cyclotron.]</ety> <def>A transuranic element of atomic number 103.  It was discovered in 1961 by bombardment of californium in a cyclotron with boron nuclei.  Other isotopes were prepared in 1965 at Dubna.  The atomic weight of the most stable isotope is 256, having a half-life of 35 seconds.  Symbol Lr.</def> <au>HCP61</au><br/
<syn><b>Syn. --</b> Lr.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laws</ent><br/
<hw>Laws</hw> <pos>n.</pos> <def>the first five books of the Old Testament, also called <altname>The Law</altname> and <altname>Torah</altname>.</def><br/
<syn><b>Syn. --</b> Pentateuch, Law of Moses, Torah.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lawsonia</ent><br/
<hw>Law*so"ni*a</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>An Asiatic and North African shrub (<spn>Lawsonia inermis</spn>), with smooth oval leaves, and fragrant white flowers. <prod>Henna</prod> is prepared from the leaves and twigs. In England the shrub is called <altname>Egyptian privet</altname>, and in the West Indies, <altname>Jamaica mignonette</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawsuit</ent><br/
<hw>Law"suit`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An action at law; a suit in equity or admiralty; any legal proceeding before a court for the enforcement of a claim.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lawyer</ent><br/
<hw>Law"yer</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Law</er>, like <ets>bowyer</ets>, fr. <ets>bow</ets>.]</ety> <sn>1.</sn> <def>One versed in the laws, or a practitioner of law; one whose profession is to conduct lawsuits for clients, or to advise as to prosecution or defence of lawsuits, or as to legal rights and obligations in other matters. It is a general term, comprehending attorneys, counselors, solicitors, barristers, sergeants, and advocates.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The black-necked stilt. See <er>Stilt</er>.</def> <sd>(b)</sd> <def>The bowfin (<spn>Amia calva</spn>).</def> <sd>(c)</sd> <def>The burbot (<spn>Lota maculosa</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Philadelphia lawyer</b></col>, <cd>A lawyer knowledgeable about the most detailed and minute points of law, especially one with an exceptional propensity and ability to exploit fine technical points of law for the client's advantage.</cd></cs><br/
[<source>PJC</source>]</p>

<p><ent>lawyerbush</ent><br/
<hw>lawyerbush</hw> <pos>n.</pos> <def>A stout-stemmed trailing shrub (<spn>Rubus cissoides</spn>) of New Zealand that scrambles over other growth.</def><br/
<syn><b>Syn. --</b> lawyer bush, bush lawyer, <spn>Rubus cissoides</spn>, <spn>Rubus australis</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lawyerly</ent><br/
<ent>Lawyerlike</ent><br/
<mhw>{ <hw>Law"yer*like`</hw> <pr>(?)</pr>, <hw>Law"yer*ly</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <def>Like, or becoming, a lawyer; <as>as, <ex>lawyerlike</ex> sagacity</as>.</def> <ldquo/<xex>Lawyerly</xex> mooting of this point.<rdquo/  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lax</ent><br/
<hw>Lax</hw> <pr>(l<acr/ks)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Laxer</adjf> <pr>(l<acr/ks"<etil/r)</pr>; <pos>superl.</pos> <adjf>Laxest</adjf>.]</amorph> <ety>[L. <ets>laxus</ets> Cf. <er>Laches</er>, <er>Languish</er>, <er>Lease</er>, <pos>v. t.</pos>, <er>Leash</er>.]</ety> <sn>1.</sn> <def>Not tense, firm, or rigid; loose; slack; <as>as, a <ex>lax</ex> bandage; <ex>lax</ex> fiber.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The flesh of that sort of fish being <qex>lax</qex> and spongy.</q> <rj><qau>Ray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not strict or stringent; not exact; loose; weak; vague; equivocal.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The discipline was <qex>lax</qex>.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Society at that epoch was lenient, if not <qex>lax</qex>, in matters of the passions.</q> <rj><qau>J. A. Symonds.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The word <ldquo/<ae/ternus<rdquo/ itself is sometimes of a <qex>lax</qex> signification.</q> <rj><qau>Jortin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Having a looseness of the bowels; diarrheal.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Loose; slack; vague; unconfined; unrestrained; dissolute; licentious.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lax</ent><br/
<hw>Lax</hw>, <pos>n.</pos> <def>A looseness; diarrhea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laxation</ent><br/
<hw>Lax*a"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>laxatio</ets>, fr. <ets>laxare</ets> to loosen, fr. <ets>laxus</ets> loose, slack.]</ety> <def>The act of loosening or slackening, or the state of being loosened or slackened.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laxative</ent><br/
<hw>Lax"a*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>laxativus</ets> mitigating, assuaging: cf. F. <ets>laxatif</ets>. See <er>Lax</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>Having a tendency to loosen or relax.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Med.)</fld> <def>Having the effect of loosening or opening the intestines, and relieving from constipation; -- opposed to <contr>astringent</contr>.</def> -- <def2><pos>n.</pos> <fld>(Med.)</fld> <def>A laxative medicine. See the Note under <er>Cathartic</er>.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laxativeness</ent><br/
<hw>Lax"a*tive*ness</hw>, <pos>n.</pos> <def>The quality of being laxative.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laxator</ent><br/
\'d8<hw>Lax*a"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L. <ets>laxare</ets>, <ets>laxatum</ets>, to loosen.]</ety> <fld>(Anat.)</fld> <def>That which loosens; -- esp., a muscle which by its contraction loosens some part.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laxity</ent><br/
<hw>Lax"i*ty</hw> <pr>(l<acr/ks"<icr/*t<ycr/)</pr>, <pos>n.</pos> <ety>[L. <ets>laxitas</ets>, fr. <ets>laxus</ets> loose, slack: cf. F. <ets>laxit<eacute/</ets>, See <er>Lax</er>, <pos>a.</pos>]</ety> <def>The state or quality of being lax; lack of tenseness, strictness, or exactness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laxly</ent><br/
<hw>Lax"ly</hw>, <pos>adv.</pos> <def>In a lax manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laxness</ent><br/
<hw>Lax"ness</hw>, <pos>n.</pos> <def>The state of being lax; laxity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw> <pr>(?)</pr>, <pos>imp.</pos> <def>of <er>Lie</er>, to recline.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw>, <pos>a.</pos> <ety>[F. <ets>lai</ets>, L. <ets>laicus</ets>, Gr. <?/ of or from the people, lay, from <?/, <?/, people.  Cf. <er>Laic</er>.]</ety> <sn>1.</sn> <def>Of or pertaining to the laity, as distinct from the clergy; <as>as, a <ex>lay</ex> person; a <ex>lay</ex> preacher; a <ex>lay</ex> brother.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not educated or cultivated; ignorant.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Not belonging to, or emanating from, a particular profession; unprofessional; <as>as, a <ex>lay</ex> opinion regarding the nature of a disease</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lay baptism</b></col> <fld>(Eccl.)</fld>, <cd>baptism administered by a lay person.</cd> <au>F. G. Lee.</au> -- <col><b>Lay brother</b></col> <fld>(R. C. Ch.)</fld>, <cd>one received into a convent of monks under the three vows, but not in holy orders.</cd> -- <col><b>Lay clerk</b></col> <fld>(Eccl.)</fld>, <cd>a layman who leads the responses of the congregation, etc., in the church service.</cd> <au>Hook.</au> -- <col><b>Lay days</b></col> <fld>(Com.)</fld>, <cd>time allowed in a charter party for taking in and discharging cargo.</cd> <au>McElrath.</au> -- <col><b>Lay elder</b></col>. <cd>See 2d <er>Elder</er>, 3, note.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The laity; the common people.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The learned have no more privilege than the <qex>lay</qex>.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw>, <pos>n.</pos> <def>A meadow. See <er>Lea</er>.</def> <mark>[Obs.]</mark>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw>, <pos>n.</pos> <ety>[OF. <ets>lei</ets> faith, law, F. <ets>loi</ets> law. See <er>Legal</er>.]</ety> <sn>1.</sn> <def>Faith; creed; religious profession.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Of the sect to which that he was born<br/
He kept his <qex>lay</qex>, to which that he was sworn.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A law.</def> <mark>[Obs.]</mark> <ldquo/Many goodly <xex>lays</xex>.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An obligation; a vow.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>They bound themselves by a sacred <qex>lay</qex> and oath.</q> <rj><qau>Holland.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OF. <ets>lai</ets>, <ets>lais</ets>, prob. of Celtic origin; cf. Ir. <ets>laoi</ets>, <ets>laoidh</ets>, song, poem, OIr. <ets>laoidh</ets> poem, verse; but cf. also AS. <ets>l<amac/c</ets> play, sport, G. <ets>leich</ets> a sort of poem (cf. <er>Lake</er> to sport). <?/.]</ety> <sn>1.</sn> <def>A song; a simple lyrical poem; a ballad.</def>  <rj><au>Spenser. Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A melody; any musical utterance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The throstle cock made eke his <qex>lay</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw> <pr>(l<amac/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Laid</conjf> <pr>(l<amac/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Laying</conjf>.]</vmorph> <ety>[OE. <ets>leggen</ets>, AS. <ets>lecgan</ets>, causative, fr. <ets>licgan</ets> to lie; akin to D. <ets>leggen</ets>, G. <ets>legen</ets>, Icel. <ets>leggja</ets>, Goth. <ets>lagjan</ets>. See <er>Lie</er> to be prostrate.]</ety> <sn>1.</sn> <def>To cause to lie down, to be prostrate, or to lie against something; to put or set down; to deposit; <as>as, to <ex>lay</ex> a book on the table; to <ex>lay</ex> a body in the grave; a shower <ex>lays</ex> the dust.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>A stone was brought, and <qex>laid</qex> upon the mouth of the den.</q> <rj><qau>Dan. vi. 17.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Soft on the flowery herb I found me <qex>laid</qex>.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To place in position; to establish firmly; to arrange with regularity; to dispose in ranks or tiers; <as>as, to <ex>lay</ex> a corner stone; to <ex>lay</ex> bricks in a wall; to <ex>lay</ex> the covers on a table.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To prepare; to make ready; to contrive; to provide; <as>as, to <ex>lay</ex> a snare, an ambush, or a plan</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To spread on a surface; <as>as, to <ex>lay</ex> plaster or paint</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To cause to be still; to calm; to allay; to suppress; to exorcise, as an evil spirit.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>After a tempest when the winds are <qex>laid</qex>.</q> <rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To cause to lie dead or dying.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Brave C<ae/neus <qex>laid</qex> Ortygius on the plain,<br/
The victor C<ae/neus was by Turnus slain.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To deposit, as a wager; to stake; to risk.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I dare <qex>lay</qex> mine honor<br/
He will remain so.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>To bring forth and deposit; <as>as, to <ex>lay</ex> eggs</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>To apply; to put.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She <qex>layeth</qex> her hands to the spindle.</q> <rj><qau>Prov. xxxi. 19.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>To impose, as a burden, suffering, or punishment; to assess, as a tax; <as>as, to <ex>lay</ex> a tax on land</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Lord hath <qex>laid</qex> on him the iniquity of us all.</q> <rj><qau>Is. liii. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <def>To impute; to charge; to allege.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God <qex>layeth</qex> not folly to them.</q> <rj><qau>Job xxiv. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Lay</qex> the fault on us.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <def>To impose, as a command or a duty; <as>as, to <ex>lay</ex> commands on one</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <def>To present or offer; <as>as, to <ex>lay</ex> an indictment in a particular county; to <ex>lay</ex> a scheme before one.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>14.</sn> <fld>(Law)</fld> <def>To state; to allege; <as>as, to <ex>lay</ex> the venue</as>.</def>  <rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>15.</sn> <fld>(Mil.)</fld> <def>To point; to aim; <as>as, to <ex>lay</ex> a gun</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>16.</sn> <fld>(Rope Making)</fld> <def>To put the strands of (a rope, a cable, etc.) in their proper places and twist or unite them; <as>as, to <ex>lay</ex> a cable or rope</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>17.</sn> <fld>(Print.)</fld> <sd>(a)</sd> <def>To place and arrange (pages) for a form upon the imposing stone.</def> <sd>(b)</sd> <def>To place (new type) properly in the cases.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To lay asleep</b></col>, <cd>to put sleep; to make unobservant or careless.</cd> <au>Bacon.</au> -- <col><b>To lay bare</b></col>, <cd>to make bare; to strip.</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>And <qex>laid</qex> those proud roofs <qex>bare</qex> to summer's rain.</q> <rj><qau>Byron.</qau></rj></p>

<p>-- <col><b>To lay before</b></col>, <cd>to present to; to submit for consideration; <as>as, the papers are <ex>laid before</ex> Congress</as>.</cd> -- <col><b>To lay by</b></col>. <sd>(a)</sd> <cd>To save.</cd> <sd>(b)</sd> <cd>To discard.</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>Let brave spirits . . . not be <qex>laid by</qex>.</q> <rj><qau>Bacon.</qau></rj></p>

<p>-- <col><b>To lay by the heels</b></col>, <cd>to put in the stocks.</cd> <au>Shak.</au> -- <col><b>To lay down</b></col>. <sd>(a)</sd> <cd>To stake as a wager.</cd> <sd>(b)</sd> <cd>To yield; to relinquish; to surrender; <as>as, to <ex>lay down</ex> one's life; to <ex>lay down</ex> one's arms</as>.</cd> <sd>(c)</sd> <cd>To assert or advance, as a proposition or principle.</cd> -- <col><b>To lay forth</b></col>. <sd>(a)</sd> <cd>To extend at length; (reflexively) to exert one's self; to expatiate.</cd> <mark>[Obs.]</mark> <sd>(b)</sd> <cd>To lay out (as a corpse).</cd> <mark>[Obs.]</mark> <au>Shak.</au> -- <col><b>To lay hands on</b></col>, <cd>to seize.</cd> -- <mcol><col><b>To lay hands on one's self</b></col>, or <col><b>To lay violent hands on one's self</b></col></mcol>, <cd>to injure one's self; specif., to commit suicide.</cd> -- <col><b>To lay heads together</b></col>, <cd>to consult.</cd> -- <mcol><col><b>To lay hold of</b></col>, <it>or</it> <col><b>To lay hold on</b></col></mcol>, <cd>to seize; to catch.</cd> -- <col><b>To lay in</b></col>, <cd>to store; to provide.</cd> -- <col><b>To lay it on</b></col>, <cd>to apply without stint.</cd> <au>Shak.</au> -- <col><b>To lay it on thick</b></col>, <cd>to flatter excessively.</cd> -- <col><b>To lay on</b></col>, <cd>to apply with force; to inflict; <as>as, <ex>to lay on</ex> blows</as>.</cd> -- <col><b>To lay on load</b></col>, <cd>to lay on blows; to strike violently.</cd> <mark>[Obs. <or/ Archaic]</mark> -- <col><b>To lay one's self out</b></col>, <cd>to strive earnestly.</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>No selfish man will be concerned <qex>to lay out himself</qex> for the good of his country.</q> <rj><qau>Smalridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <col><b>To lay one's self open to</b></col>, <cd>to expose one's self to, as to an accusation.</cd> -- <col><b>To lay open</b></col>, <cd>to open; to uncover; to expose; to reveal.</cd> -- <col><b>To lay over</b></col>, <cd>to spread over; to cover.</cd> -- <col><b>To lay out</b></col>. <sd>(a)</sd> <cd>To expend.</cd> <au>Macaulay.</au> <sd>(b)</sd> <cd>To display; to discover.</cd> <sd>(c)</sd> <cd>To plan in detail; to arrange; as, <xex>to lay out</xex> a garden.</cd> <sd>(d)</sd> <cd>To prepare for burial; <as>as, <ex>to lay out</ex> a corpse</as>.</cd> <sd>(e)</sd> <cd>To exert; <as>as, <ex>to lay out</ex> all one's strength</as>.</cd> -- <col><b>To lay siege to</b></col>. <sd>(a)</sd> <cd>To besiege; to encompass with an army.</cd> <sd>(b)</sd> <cd>To beset pertinaciously.</cd> -- <col><b>To lay the course</b></col> <fld>(Naut.)</fld>, <cd>to sail toward the port intended without jibing.</cd> -- <col><b>To lay the land</b></col> <fld>(Naut.)</fld>, <cd>to cause it to disappear below the horizon, by sailing away from it.</cd> -- <col><b>To lay to</b></col> <sd>(a)</sd> <cd>To charge upon; to impute.</cd> <sd>(b)</sd> <cd>To apply with vigor.</cd> <sd>(c)</sd> <cd>To attack or harass.</cd> <mark>[Obs.]</mark> <au>Knolles.</au> <sd>(d)</sd> <fld>(Naut.)</fld> <cd>To check the motion of (a vessel) and cause it to be stationary.</cd> -- <col><b>To lay to heart</b></col>, <cd>to feel deeply; to consider earnestly.</cd> -- <col><b>To lay under</b></col>, <cd>to subject to; <as>as, <ex>to lay under</ex> obligation or restraint</as>.</cd> -- <col><b>To lay unto</b></col>. <sd>(a)</sd> <cd>Same as <cref>To lay to</cref> (above).</cd> <sd>(b)</sd> <cd>To put before.</cd> <au>Hos. xi. 4.</au> -- <col><b>To lay up</b></col>. <sd>(a)</sd> <cd>To store; to reposit for future use.</cd> <sd>(b)</sd> <cd>To confine; to disable.</cd> <sd>(c)</sd> <cd>To dismantle, and retire from active service, as a ship.</cd> -- <col><b>To lay wait for</b></col>, <cd>to lie in ambush for.</cd> -- <col><b>To lay waste</b></col>, <cd>to destroy; to make desolate; <as>as, <ex>to lay waste</ex> the land</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Put</er>, <pos>v. t.</pos>, and the Note under 4th <er>Lie</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To produce and deposit eggs.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>To take a position; to come or go; <as>as, to <ex>lay</ex> forward; to <ex>lay</ex> aloft.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To lay a wager; to bet.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>To lay about</b></col>, <it>or</it> <col><b>To lay about one</b></col></mcol>, <cd>to strike vigorously in all directions.</cd> <au>J. H. Newman.</au> -- <col><b>To lay at</b></col>, <cd>to strike or strike at.</cd> <au>Spenser.</au> -- <col><b>To lay for</b></col>, <cd>to prepare to capture or assault; to lay wait for.</cd> <mark>[Colloq.]</mark> <au>Bp Hall.</au> -- <col><b>To lay in for</b></col>, <cd>to make overtures for; to engage or secure the possession of.</cd> <mark>[Obs.]</mark> <ldquo/I have <xex>laid in for</xex> these.<rdquo/ <au>Dryden.</au> -- <col><b>To lay on</b></col>, <cd>to strike; to beat; to attack.</cd> <au>Shak.</au> -- <col><b>To lay out</b></col>, <cd>to purpose; to plan; <as>as, he <ex>lays out</ex> to make a journey</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lay</ent><br/
<hw>Lay</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>That which lies or is laid or is conceived of as having been laid or placed in its position; a row; a stratum; a layer; <as>as, a <ex>lay</ex> of stone or wood</as>.</def>  <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A viol should have a <qex>lay</qex> of wire strings below.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>lay</xex> of a rope is right-handed or left-handed according to the hemp or strands are laid up. See <er>Lay</er>, <pos>v. t.</pos>, 16. The <xex>lay</xex> of land is its topographical situation, esp. its slope and its surface features.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A wager.</def> <ldquo/My fortunes against any <xex>lay</xex> worth naming.<rdquo/<br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <sd>(a)</sd> <def>A job, price, or profit.</def> <mark>[Prov. Eng.]</mark> <au>Wright.</au> <sd>(b)</sd> <def> A share of the proceeds or profits of an enterprise; <as>as, when a man ships for a whaling voyage, he agrees for a certain <ex>lay</ex></as>.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Textile Manuf.)</fld> <sd>(a)</sd> <def>A measure of yarn; a lea. See 1st <er>Lea</er> <sd>(a)</sd>.</def> <sd>(b)</sd> <def>The lathe of a loom. See <er>Lathe</er>, 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A plan; a scheme.</def> <mark>[Slang]</mark>  <rj><au>Dickens.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lay figure</b></col>. <sd>(a)</sd> <cd>A jointed model of the human body that may be put in any attitude; -- used for showing the disposition of drapery, etc.</cd>  <sd>(b)</sd> <cd>A mere puppet; one who serves the will of others without independent volition.</cd> -- <col><b>Lay race</b></col>, <cd>that part of a lay on which the shuttle travels in weaving; -- called also <altname>shuttle race</altname>.</cd> -- <col><b>the lay of the land</b></col>, <cd>the general situation or state of affairs.</cd> -- <col><b>to get the lay of the land</b></col>, <cd>to learn the general situation or state of affairs, especially in preparation for action.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>layabout</ent><br/
<hw>layabout</hw> <pos>n.</pos> <def>A person who does no work.</def><br/
<syn><b>Syn. --</b> idler, loafer, do-nothing, bum.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>layby</ent><br/
<hw>layby</hw> <pos>n.</pos> <def>A paved area beside a main road where cars can stop temporarily.</def> <mark>[Chiefly Brit.]</mark> <br/
<syn><b>Syn. --</b> pull-off, turnout.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Layer</ent><br/
<hw>Lay"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lay</er> to cause to lie flat.]</ety> <sn>1.</sn> <def>One who, or that which, lays.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[Prob. a corruption of <ets>lair</ets>.]</ety> <def>That which is laid; a stratum; a bed; one thickness, course, or fold laid over another; <as>as, a <ex>layer</ex> of clay or of sand in the earth; a <ex>layer</ex> of bricks, or of plaster; the <ex>layers</ex> of an onion.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A shoot or twig of a plant, not detached from the stock, laid under ground for growth or propagation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An artificial oyster bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>layered</ent><br/
<hw>layered</hw> <pos>adj.</pos> <def>arranged in layers.</def><br/
<syn><b>Syn. --</b> superimposed.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Layering</ent><br/
<hw>Lay"er*ing</hw>, <pos>n.</pos> <def>A propagating by layers.</def>  <rj><au>Gardner.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Layette</ent><br/
<hw>Lay*ette"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <fld>(Med.)</fld> <def>The outfit of clothing, blankets, etc., prepared for a newborn infant, and placed ready for use.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Layia</ent><br/
<hw>Layia</hw> <pos>n.</pos> <def>A genus of Western U. S. annuals with showy yellow or white flowers.</def><br/
<syn><b>Syn. --</b> genus <gen>Layia</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Laying</ent><br/
<hw>Lay"ing</hw> <pr>(?)</pr>, <pos>n.</pos><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The act of one who, or that which, lays.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act or period of laying eggs; the eggs laid for one incubation; a clutch.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The first coat on laths of plasterer's two-coat work.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Layland</ent><br/
<hw>Lay"land`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Lay</ets> a meadow + <ets>land</ets>.]</ety> <def>Land lying untilled; fallow ground.</def> <mark>[Obs.]</mark>  <rj><au>Blount.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Layman</ent><br/
<hw>Lay"man</hw> <pr>(?)</pr> <pos>n.</pos>; <plu><it>pl.</it> <plw>Laymen</plw> <pr>(<?/)</pr>.</plu> <ety>[<ets>Lay</ets>, <pos>adj.</pos> + <ets>man</ets>.]</ety> <sn>1.</sn> <def>One of the people, in distinction from the clergy; one of the laity; sometimes, a man not belonging to some particular profession, in distinction from those who do.</def><-- used esp. by physicians of those w/o medical training --><br/
[<source>1913 Webster</source>]</p>

<p><q>Being a <qex>layman</qex>, I ought not to have concerned myself with speculations which belong to the profession.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A lay figure. See under <er>Lay</er>, <pos>n.</pos> (above).</def>  <rj><au>Dryden</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Layner</ent><br/
<hw>Lay"ner</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Lanier</er>.]</ety> <def>A whiplash.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>layperson</ent><br/
<hw>layperson</hw> <pos>n.</pos> <def>someone who is not a clergyman or a professional person; a <er>layman</er>.</def><br/
<syn><b>Syn. --</b> layman.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lay reader</ent><br/
<hw>Lay" read"er</hw>. <fld>(Eccl.)</fld> <def>A layman authorized to read parts of the public service of the church.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Layshaft</ent><br/
<ent>Lay shaft</ent><br/
<mhw>{ <hw>Lay shaft</hw>, <it>or</it> <hw>Lay"shaft`</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Mach.)</fld> <def>A secondary shaft, as in a sliding change gear for an automobile; a cam shaft operated by a two-to-one gear in an internal-combustion engine. It is generally a shaft moving more or less independently of the other parts of a machine, <as>as, in some marine engines, a shaft, driven by a small auxiliary engine, for independently operating the valves of the main engine to insure uniform motion</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Layship</ent><br/
<hw>Lay"ship</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The condition of being a layman.</def> <mark>[Obs.]</mark>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laystall</ent><br/
<hw>Lay"stall`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A place where rubbish, dung, etc., are laid or deposited.</def> <mark>[Obs.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Smithfield was a <qex>laystall</qex> of all ordure and filth.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A place where milch cows are kept, or cattle on the way to market are lodged.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazar</ent><br/
<hw>La"zar</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>lazare</ets>, fr. <ets>Lazarus</ets> the beggar. <ets>Luke xvi</ets>. <ets>20</ets>.]</ety> <def>A person infected with a filthy or pestilential disease; a leper.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Like loathsome <qex>lazars</qex>, by the hedges lay.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lazar house</b></col> <cd>a lazaretto; also, a hospital for quarantine.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazaretto</ent><br/
<ent>Lazaret</ent><br/
<mhw>{ <hw>Laz`a*ret"</hw> <pr>(l<acr/z`<adot/*r<ecr/t")</pr>, <hw>Laz`a*ret"to</hw> <pr>(l<acr/z`<adot/*r<ecr/t"t<osl/)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>lazaret</ets>, or It. <ets>lazzeretto</ets>, fr. <ets>Lazarus</ets>. See <er>Lazar</er>.]</ety> <sn>1.</sn> <def>A public building, hospital, or pesthouse for the reception of diseased persons, particularly those affected with contagious diseases.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <note>(Pronounced by seamen <pr>l<acr/z`<adot/*r<emac/t"</pr>)</note> <def>A low space under the after part of the main deck, used as a storeroom.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lazaret fever</ent><br/
<hw>Lazaret fever</hw>. <fld>(Med.)</fld> <def>Typhus fever.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lazarite</ent><br/
<ent>Lazarist</ent><br/
<mhw>{ <hw>Laz"a*rist</hw> <pr>(?)</pr>, <hw>Laz"a*rite</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <fld>(R. C. Ch.)</fld> <def>One of the <membof>Congregation of the Priests of the Mission</membof>, a religious institute founded by <person>Vincent de Paul</person> in 1624, and popularly called Lazarists or Lazarites from the College of St. Lazare in Paris, which was occupied by them until 1792.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazarly</ent><br/
<ent>Lazarlike</ent><br/
<mhw>{ <hw>La"zar*like`</hw> <pr>(?)</pr>, <hw>La"zar*ly</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <def>Full of sores; leprous.</def>  <rj><au>Shak.</au>  <au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazaroni</ent><br/
<hw>Laz`a*ro"ni</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>See <er>Lazzaroni</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazarwort</ent><br/
<hw>La"zar*wort`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>Laserwort.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laze</ent><br/
<hw>Laze</hw> <pr>(l<amac/z)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lazed</conjf> <pr>(l<amac/zd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lazing</conjf>.]</vmorph> <ety>[See <er>Lazy</er>.]</ety> <def>To be lazy or idle.</def> <mark>[Colloq.]</mark>  <rj><au>Middleton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laze</ent><br/
<hw>Laze</hw>, <pos>v. t.</pos> <def>To waste in sloth; to spend, as time, in idleness; <as>as, to <ex>laze</ex> away whole days</as>.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazily</ent><br/
<hw>La"zi*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a lazy manner.</def>  <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Laziness</ent><br/
<hw>La"zi*ness</hw>, <pos>n.</pos> <def>The state or quality of being lazy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Laziness</qex> travels so slowly, that Poverty soon overtakes him.</q> <rj><qau>Franklin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazuli</ent><br/
<hw>Laz"u*li</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. & NL. <ets>lapis lazuli</ets>, LL. <ets>lazulus</ets>, <ets>lazurius</ets>, <ets>lazur</ets> from the same Oriental source as E. <ets>azure</ets>. See <er>Azure</er>.]</ety> <fld>(Min.)</fld> <def>A mineral of a fine azure-blue color, usually in small rounded masses. It is essentially a silicate of alumina, lime, and soda, with some sodium sulphide, is often marked by yellow spots or veins of sulphide of iron, and is much valued for ornamental work.  Called also <altname>lapis lazuli</altname>, and <altname>Armenian stone</altname>.</def>
<-- and lapis. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazulite</ent><br/
<hw>Laz"u*lite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <ets>lazuli</ets> : cf. F. <ets>lazulite</ets>, G. <ets>lazulith</ets>.]</ety> <fld>(Min.)</fld> <def>A mineral of a light indigo-blue color, occurring in small masses, or in monoclinic crystals; blue spar. It is a hydrous phosphate of alumina and magnesia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazy</ent><br/
<hw>La"zy</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Lazier</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Laziest</adjf>.]</amorph> <ety>[OE. <ets>lasie</ets>, <ets>laesic</ets>, of uncertain origin; cf. F. <ets>las</ets> tired, L. <ets>lassus</ets>, akin to E. <ets>late</ets>; or cf. LG. <ets>losig</ets>, <ets>lesig</ets>.]</ety> <sn>1.</sn> <def>Disinclined to action or exertion; averse to labor; idle; shirking work.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Inactive; slothful; slow; sluggish; <as>as, a <ex>lazy</ex> stream</as>.</def> <ldquo/The night owl's <xex>lazy</xex> flight.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Wicked; vicious.</def> <mark>[Obs. or Prov. Eng.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 837 --></p>

<p><cs><col><b>Lazy tongs</b></col>, <cd>a system of jointed bars capable of great extension, originally made for picking up something at a distance, now variously applied in machinery.</cd></cs></p>

<p><syn><b>Syn.</b> -- Idle; indolent; sluggish; slothful. See <er>Idle</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazyback</ent><br/
<hw>La"zy*back`</hw> <pr>(l<amac/"z<ycr/*b<acr/k`)</pr>, <pos>n.</pos> <def>A support for the back, attached to the seat of a carriage.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazybones</ent><br/
<hw>La"zy*bones`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A lazy person.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lazzaroni</ent><br/
<hw>Laz`za*ro"ni</hw> <pr>(l<acr/z`z<adot/*r<omac/"n<icr/; It. l<aum/t`s<adot/*r<omac/"n<esl/)</pr>, <pos>n. pl.</pos> <ety>[It. <ets>lazzarone</ets>, pl. <ets>lazzaroni</ets>.]</ety> <def>The homeless idlers of Naples who live by chance work or begging; -- so called from the Hospital of St. Lazarus, which serves as their refuge.</def> <altsp>[Written also, but improperly, <asp>lazaroni</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>lcm</ent><br/
<hw>lcm</hw> <pos>n.</pos> <def>Abbreviation for the least common multiple, the smallest multiple that is exactly divisible by every member of a set of numbers; <as>as, the <ex>least common multiple</ex> of 12 and 18 is 36</as>.</def> <mark>[abbr.]</mark> <br/
<syn><b>Syn. --</b> lowest common multiple, least common multiple.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Ld.</ent><br/
<hw>Ld.</hw> <pos>n.</pos> <def>The abbreviation for <altname>limited</altname>, term appended to the name of a company that is organized to give its owners limited liability; also abbreviated <altname>Ltd.</altname>  It corresponds to <altname>Inc.</altname> in the United States.</def> <mark>[Chiefly British]</mark> <mark>[abbr.]</mark> <br/
<syn><b>Syn. --</b> limited company, Ltd.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>LDL</ent><br/
<hw>LDL</hw> <pr>(<ecr/l`d<emac/*<ecr/l/")</pr> <pos>n.</pos> <ety>[acronym from <ets>L</ets>ow-<ets>D</ets>ensity <ets>L</ets>ipoprotein.]</ety> <fld>(Med., Biochem.)</fld> <def><altname>Low-density lipoprotein</altname>, a lipoprotein that transports cholesterol in the blood; high levels are thought to be associated with increased risk of coronary heart disease and atherosclerosis; sometimes called informally <altname>bad cholesterol</altname>.</def><br/
<syn><b>Syn. --</b> low-density lipoprotein.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lea</ent><br/
<hw>Lea</hw>, <pos>n.</pos> <ety>[Cf. <er>Lay</er>, <pos>n.</pos> (that which is laid), 4.]</ety> <fld>(Textile Manuf.)</fld> <sd>(a)</sd> <def>A measure of yarn; for linen, 300 yards; for cotton, 120 yards; a lay.</def> <sd>(b)</sd> <def>A set of warp threads carried by a loop of the heddle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lea</ent><br/
<hw>Lea</hw>, <pos>n.</pos> <ety>[OE. <ets>ley</ets>, <ets>lay</ets>, As. <ets>le<aacute/h</ets>, <ets>le<aacute/</ets>; akin to Prov. G. <ets>lon</ets> bog, morass, grove, and perh. to L. <ets>lucus</ets> grove, E. <ets>light</ets>, <pos>n.</pos>]</ety> <def>A meadow or sward land; a grassy field.</def> <ldquo/Plow-torn <xex>leas</xex>.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The lowing herd wind slowly o'er the <qex>lea</qex>.</q> <rj><qau>Gray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leach</ent><br/
<hw>Leach</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> <def>See 3d <er>Leech</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leach</ent><br/
<hw>Leach</hw>, <pos>n.</pos> <altsp>[Written also <asp>letch</asp>.]</altsp> <ety>[Cf. As. <ets>le<aacute/h</ets> lye, G. <ets>lauge</ets>. See <er>Lye</er>.]</ety> <sn>1.</sn> <def>A quantity of wood ashes, through which water passes, and thus imbibes the alkali.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A tub or vat for leaching ashes, bark, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leach tub</b></col>, <cd>a wooden tub in which ashes are leached.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leach</ent><br/
<hw>Leach</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leached</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leaching</conjf>.]</vmorph> <ety>[Written also <ets>leech</ets> and <ets>letch</ets>.]</ety> <sn>1.</sn> <def>To remove the soluble constituents from by subjecting to the action of percolating water or other liquid; <as>as, to <ex>leach</ex> ashes or coffee</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To dissolve out; -- often used with <xex>out</xex>; <as>as, to <ex>leach</ex> out alkali from ashes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leach</ent><br/
<hw>Leach</hw>, <pos>v. i.</pos> <def>To part with soluble constituents by percolation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leach</ent><br/
<hw>Leach</hw>, <pos>n.</pos> <def>See <er>Leech</er>, a physician.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leachy</ent><br/
<hw>Leach"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Permitting liquids to pass by percolation; not capable of retaining water; porous; pervious; -- said of gravelly or sandy soils, and the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lead</ent><br/
<hw>Lead</hw> <pr>(l<ecr/d)</pr>, <pos>n.</pos> <ety>[OE. <ets>led</ets>, <ets>leed</ets>, <ets>lead</ets>, AS. <ets>le<aacute/d</ets>; akin to D. <ets>lood</ets>, MHG. <ets>l<omac/t</ets>, G. <ets>loth</ets> plummet, sounding lead, small weight, Sw. & Dan. <ets>lod</ets>. <root/123.]</ety> <sn>1.</sn> <fld>(Chem.)</fld> <def>One of the elements, a heavy, pliable, inelastic metal, having a bright, bluish color, but easily tarnished.  It is both malleable and ductile, though with little tenacity, and is used for tubes, sheets, bullets, etc. Its specific gravity is 11.37. It is easily fusible (melting point 327.5<deg/ C), forms alloys with other metals, and is an ingredient of solder and type metal. Atomic number 82.  Atomic weight, 207.2. Symbol Pb (L. <xex>Plumbum</xex>). It is chiefly obtained from the mineral galena, lead sulphide.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An article made of lead or an alloy of lead</def>; as: <sd>(a)</sd> <def>A plummet or mass of lead, used in sounding at sea.</def> <sd>(b)</sd> <fld>(Print.)</fld> <def>A thin strip of type metal, used to separate lines of type in printing.</def> <sd>(c)</sd> <def>Sheets or plates of lead used as a covering for roofs; hence, <pluf>pl.</pluf>, a roof covered with lead sheets or terne plates.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I would have the tower two stories, and goodly <qex>leads</qex> upon the top.</q> <rj><qau>Bacon</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A small cylinder of black lead or graphite, used in pencils.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Black lead</b></col>, <cd>graphite or plumbago; -- so called from its leadlike appearance and streak.</cd> <mark>[Colloq.]</mark> -- <col><b>Coasting lead</b></col>, <cd>a sounding lead intermediate in weight between a hand lead and deep-sea lead.</cd> -- <col><b>Deep-sea lead</b></col>, <cd>the heaviest of sounding leads, used in water exceeding a hundred fathoms in depth.</cd> <au>Ham. Nav. Encyc.</au> -- <col><b>Hand lead</b></col>, <cd>a small lead use for sounding in shallow water.</cd> -- <mcol><col><b>Krems lead</b></col>, <col><b>Kremnitz lead</b></col></mcol> <ety>[so called from <etsep>Krems</etsep> or <etsep>Kremnitz</etsep>, in Austria]</ety>, <cd>a pure variety of white lead, formed into tablets, and called also <altname>Krems white</altname>, <it>or</it> <altname>Kremnitz white</altname>, and <altname>Vienna white</altname>.</cd> -- <col><b>Lead arming</b></col>, <cd>tallow put in the hollow of a sounding lead. See <cref>To arm the lead</cref> (below).</cd> -- <col><b>Lead colic</b></col>. <cd>See under <er>Colic</er>.</cd> -- <col><b>Lead color</b></col>, <cd>a deep bluish gray color, like tarnished lead.</cd> -- <col><b>Lead glance</b></col>. <fld>(Min.)</fld> <cd>Same as <er>Galena</er>.</cd> -- <col><b>Lead line</b></col> <sd>(a)</sd> <fld>(Med.)</fld> <cd>A dark line along the gums produced by a deposit of metallic lead, due to lead poisoning.</cd> <sd>(b)</sd> <fld>(Naut.)</fld> <cd>A sounding line.</cd> -- <col><b>Lead mill</b></col>, <cd>a leaden polishing wheel, used by lapidaries.</cd> -- <col><b>Lead ocher</b></col> <fld>(Min.)</fld>, <cd>a massive sulphur-yellow oxide of lead. Same as <er>Massicot</er>.</cd> -- <col><b>Lead pencil</b></col>, <cd>a pencil of which the marking material is graphite (black lead).</cd> -- <col><b>Lead plant</b></col> <fld>(Bot.)</fld>, <cd>a low leguminous plant, genus <gen>Amorpha</gen> (<spn>Amorpha canescens</spn>), found in the Northwestern United States, where its presence is supposed to indicate lead ore.</cd> <au>Gray.</au> -- <col><b>Lead tree</b></col>. <sd>(a)</sd> <fld>(Bot.)</fld> <cd>A West Indian name for the tropical, leguminous tree, <spn>Leuc<ae/na glauca</spn>; -- probably so called from the glaucous color of the foliage.</cd> <sd>(b)</sd> <fld>(Chem.)</fld> <cd>Lead crystallized in arborescent forms from a solution of some lead salt, as by suspending a strip of zinc in lead acetate.</cd> -- <col><b>Mock lead</b></col>, <cd>a miner's term for blende.</cd> -- <col><b>Red lead</b></col>, <cd>a scarlet, crystalline, granular powder, consisting of minium when pure, but commonly containing several of the oxides of lead. It is used as a paint or cement and also as an ingredient of flint glass.</cd> -- <col><b>Red lead ore</b></col> <fld>(Min.)</fld>, <cd>crocoite.</cd> -- <col><b>Sugar of lead</b></col>, <cd>acetate of lead.</cd> -- <col><b>To arm the lead</b></col>, <cd>to fill the hollow in the bottom of a sounding lead with tallow in order to discover the nature of the bottom by the substances adhering.</cd> <au>Ham. Nav. Encyc.</au> -- <mcol><col><b>To cast the lead</b></col>, <it>or</it> <col><b>To heave the lead</b></col></mcol>, <cd>to cast the sounding lead for ascertaining the depth of water.</cd> -- <col><b>White lead</b></col>, <cd>hydrated carbonate of lead, obtained as a white, amorphous powder, and much used as an ingredient of white paint.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lead</ent><br/
<hw>Lead</hw> <pr>(l<ecr/d)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leaded</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Leading</conjf>.]</vmorph> <sn>1.</sn> <def>To cover, fill, or affect with lead; <as>as, continuous firing <ex>leads</ex> the grooves of a rifle</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Print.)</fld> <def>To place leads between the lines of; <as>as, to <ex>lead</ex> a page; <ex>leaded</ex> matter.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lead</ent><br/
<hw>Lead</hw> <pr>(l<emac/d)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Led</conjf> <pr>(l<ecr/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leading</conjf>.]</vmorph> <ety>[OE. <ets>leden</ets>, AS. <ets>l<aemac/dan</ets> (akin to OS. <ets>l<emac/dian</ets>, D. <ets>leiden</ets>, G. <ets>leiten</ets>, Icel. <ets>le<imac/<edh/a</ets>, Sw. <ets>leda</ets>, Dan. <ets>lede</ets>), properly a causative fr. AS. <ets>li<edh/an</ets> to go; akin to OHG. <ets>l<imac/dan</ets>, Icel. <ets>l<imac/<edh/a</ets>, Goth. <ets>lei<thorn/an</ets> (in comp.).  Cf. <er>Lode</er>, <er>Loath</er>.]</ety> <sn>1.</sn> <def>To guide or conduct with the hand, or by means of some physical contact or connection; <as>as, a father <ex>leads</ex> a child; a jockey <ex>leads</ex> a horse with a halter; a dog <ex>leads</ex> a blind man.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>If a blind man <qex>lead</qex> a blind man, both fall down in the ditch.</q> <rj><qau>Wyclif (Matt. xv. 14.)</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They thrust him out of the city, and <qex>led</qex> him unto the brow of the hill.</q> <rj><qau>Luke iv. 29.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In thy right hand <qex>lead</qex> with thee<br/
The mountain nymph, sweet Liberty.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To guide or conduct in a certain course, or to a certain place or end, by making the way known; to show the way, esp. by going with or going in advance of.</def>  <specif>Hence,</specif> <mark>figuratively</mark>: <def>To direct; to counsel; to instruct; <as>as, to <ex>lead</ex> a traveler; to <ex>lead</ex> a pupil.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Lord went before them by day in a pillar of a cloud, to <qex>lead</qex> them the way.</q> <rj><qau>Ex. xiii. 21.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>leadeth</qex> me beside the still waters.</q> <rj><qau>Ps. xxiii. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This thought might <qex>lead</qex> me through the world's vain mask.<br/
Content, though blind, had I no better guide.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To conduct or direct with authority; to have direction or charge of; <as>as, to <ex>lead</ex> an army, an exploring party, or a search; to <ex>lead</ex> a political party.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Christ took not upon him flesh and blood that he might conquer and rule nations, <qex>lead</qex> armies, or possess places.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To go or to be in advance of; to precede; hence, to be foremost or chief among; <as>as, the big sloop <ex>led</ex> the fleet of yachts; the Guards <ex>led</ex> the attack; <persfn>Demosthenes</persfn> <ex>leads</ex> the orators of all ages.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>As Hesperus, that <qex>leads</qex> the sun his way.</q> <rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And <qex>lo</qex> ! Ben Adhem's name <qex>led</qex> all the rest.</q> <rj><qau>Leigh Hunt.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To draw or direct by influence, whether good or bad; to prevail on; to induce; to entice; to allure; <as>as, to <ex>lead</ex> one to espouse a righteous cause</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He was driven by the necessities of the times, more than <qex>led</qex> by his own disposition, to any rigor of actions.</q> <rj><qau>Eikon Basilike.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Silly women, laden with sins, <qex>led</qex> away by divers lusts.</q> <rj><qau>2 Tim. iii. 6 (Rev. Ver.).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To guide or conduct one's self in, through, or along (a certain course); hence, to proceed in the way of; to follow the path or course of; to pass; to spend. Also, to cause (one) to proceed or follow in (a certain course).</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That we may <qex>lead</qex> a quiet and peaceable life.</q> <rj><qau>1 Tim. ii. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Nor thou with shadowed hint confuse<br/
A life that <qex>leads</qex> melodious days.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>You remember . . . the life he used to <qex>lead</qex> his wife and daughter.</q> <rj><qau>Dickens.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Cards & Dominoes)</fld> <def>To begin a game, round, or trick, with; <as>as, to <ex>lead</ex> trumps; the double five was <ex>led</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To lead astray</b></col>, <cd>to guide in a wrong way, or into error; to seduce from truth or rectitude.</cd> -- <col><b>To lead captive</b></col>, <cd>to carry or bring into captivity.</cd> -- <col><b>To lead the way</b></col>, <cd>to show the way by going in front; to act as guide.</cd> <au>Goldsmith.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lead</ent><br/
<hw>Lead</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To guide or conduct, as by accompanying, going before, showing, influencing, directing with authority, etc.; to have precedence or pre<eum/minence; to be first or chief; -- used in most of the senses of <xex>lead</xex>, <pos>v. t.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To tend or reach in a certain direction, or to a certain place; <as>as, the path <ex>leads</ex> to the mill; gambling <ex>leads</ex> to other vices.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The mountain foot that <qex>leads</qex> towards Mantua.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>To lead off</b></col> <it>or</it> <col><b>To lead out</b></col></mcol>, <cd>to go first; to begin; <as>as, Mickey Mantle <ex>led off</ex> in the fifth inning of the game</as>.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Lead</ent><br/
<hw>Lead</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of leading or conducting; guidance; direction; <as>as, to take the <ex>lead</ex>; to be under the <ex>lead</ex> of another.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>At the time I speak of, and having a momentary <qex>lead</qex>, . . . <qex>I am sure I did my country important service</qex>.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Precedence; advance position; also, the measure of precedence; <as>as, the white horse had the <ex>lead</ex>; <ex>a lead</ex> of a boat's length, or of half a second.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Cards & Dominoes)</fld> <def>The act or right of playing first in a game or round; the card suit, or piece, so played; <as>as, your partner has the <ex>lead</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An open way in an ice field.</def>  <rj><au>Kane.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Mining)</fld> <def>A lode.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Naut.)</fld> <def>The course of a rope from end to end.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Steam Engine)</fld> <def>The width of port opening which is uncovered by the valve, for the admission or release of steam, at the instant when the piston is at end of its stroke.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ When used alone it means <xex>outside lead</xex>, or lead for the admission of steam. <xex>Inside lead</xex> refers to the release or exhaust.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Civil Engineering)</fld> <def>the distance of haul, as from a cutting to an embankment.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Horology)</fld> <def>The action of a tooth, as a tooth of a wheel, in impelling another tooth or a pallet.</def>  <rj><au>Saunier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Music.)</fld> <sd>(a)</sd> <def>The announcement by one voice part of a theme to be repeated by the other parts.</def> <sd>(b)</sd> <def>A mark or a short passage in one voice part, as of a canon, serving as a cue for the entrance of others.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>11.</sn>  <def>In an internal-combustion engine, the distance, measured in actual length of piston stroke or the corresponding angular displacement of the crank, of the piston from the end of the compression stroke when ignition takes place; -- called in full <col><b>lead of the ignition</b></col>. When ignition takes place during the working stroke the corresponding distance from the commencement of the stroke is called <col><b>negative lead</b></col>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>12.</sn>  <fld>(Mach.)</fld> <def>The excess above a right angle in the angle between two consecutive cranks, as of a compound engine, on the same shaft.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>13.</sn>  <fld>(Mach.)</fld> <def>In spiral screw threads, worm wheels, or the like, the amount of advance of any point in the spiral for a complete turn.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>14.</sn>  <fld>(Elec.)</fld> <sd>(a)</sd> <def>The angle between the line joining the brushes of a continuous-current dynamo and the diameter symmetrical between the poles.</def> <sd>(b)</sd> <def>The advance of the current phase in an alternating circuit beyond that of the electromotive force producing it.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>15.</sn>  <fld>(Theat.)</fld> <def>A role for a leading man or leading woman; also, one who plays such a role.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>16.</sn> <def>The first story in a newspaper or broadcast news program.</def><br/
[<source>PJC</source>]</p>

<p><sn>17.</sn> <def>an electrical conductor, typically as an insulated wire or cable, connecting an electrical device to another device or to a power source, such as a conductor conveying electricity from a dynamo.</def><br/
[<source>PJC</source>]</p>

<p><sn>18.</sn> <fld>(Baseball)</fld> <def>the distance a runner on base advances from one base toward the next before the pitch; <as>as, the long <ex>lead</ex> he usually takes tends to distract the pitchers</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Lead angle</b></col> <fld>(Steam Engine)</fld>, <cd>the angle which the crank maker with the line of centers, in approaching it, at the instant when the valve opens to admit steam.</cd> -- <col><b>Lead screw</b></col> <fld>(Mach.)</fld>, <cd>the main longitudinal screw of a lathe, which gives the feed motion to the carriage.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaded</ent><br/
<hw>Lead"ed</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Fitted with lead; set in lead; <as>as, <ex>leaded</ex> windows</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Print.)</fld> <def>Separated by leads, as the lines of a page.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaden</ent><br/
<hw>Lead"en</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Made of lead; of the nature of lead; <as>as, a <ex>leaden</ex> ball</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Like lead in color, etc.; <as>as, a <ex>leaden</ex> sky</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Heavy; dull; sluggish.</def> <ldquo/<xex>Leaden</xex> slumber.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leader</ent><br/
<hw>Lead"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who, or that which, leads or conducts; a guide; a conductor.</def> <specif>Especially:</specif> <sd>(a)</sd> <def>One who goes first.</def> <sd>(b)</sd> <def>One having authority to direct; a chief; a commander.</def> <sd>(c)</sd> <fld>(Mus.)</fld> <def>A performer who leads a band or choir in music; also, in an orchestra, the principal violinist; the one who plays at the head of the first violins.</def> <sd>(d)</sd> <fld>(Naut.)</fld> <def>A block of hard wood pierced with suitable holes for leading ropes in their proper places.</def> <sd>(e)</sd> <fld>(Mach.)</fld> <def>The principal wheel in any kind of machinery.</def> <mark>[Obs. or R.]</mark> <au>G. Francis.</au> <sd>(f)</sd> <def>A horse placed in advance of others; one of the forward pair of horses.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He forgot to pull in his <qex>leaders</qex>, and they gallop away with him at times.</q> <rj><qau>Hare.</qau></rj></p>

<p><sd>(g)</sd> <def>A pipe for conducting rain water from a roof to a cistern or to the ground; a conductor.</def> <sd>(h)</sd> <fld>(Fishing)</fld> <def>A net for leading fish into a pound, weir, etc.; also, a line of gut, to which the snell of a fly hook is attached.</def> <sd>(i)</sd> <fld>(Mining)</fld> <def>A branch or small vein, not important in itself, but indicating the proximity of a better one.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The first, or the principal, editorial article in a newspaper; a leading or main editorial article.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Print.)</fld> <sd>(a)</sd> <def>A type having a dot or short row of dots upon its face.</def> <sd>(b)</sd> <pluf>pl.</pluf> <def>a row of dots, periods, or hyphens, used in tables of contents, etc., to lead the eye across a space to the right word or number.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- chief; chieftain; commander. See <er>Chief</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>leaderless</ent><br/
<hw>leaderless</hw> <pos>adj.</pos> <def>lacking a leader; <as>as, a <ex>leaderless</ex> mob running riot in the streets</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leaders</ent><br/
<hw>leaders</hw> <pos>n.</pos> <def>the body of people who lead a group; the leadership{3}; <as>as, they hung the <ex>leaders</ex> of the insurrection</as>.</def><br/
<syn><b>Syn. --</b> leadership.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leadership</ent><br/
<hw>Lead"er*ship</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The office, position or function of a leader; <as>as, Gingrich held the House <ex>leadership</ex> for six years</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The quality of character and personality giving a person the ability to gain the confidence of and lead others; <as>as, Washington's <ex>leadership</ex> was indispensible to success of the American Revolution</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>The people who serve as leaders of a group; <as>as, the party <ex>leadership</ex> was in disarray after the election</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>lead-free</ent><br/
<hw>lead-free</hw> <pos>adj.</pos> <sn>1.</sn> <def>not containing the element lead.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <specif>specifically:</specif> <def>Not containing a lead additive such as tetraethyllead or tetramethyllead; -- of gasoline; <as>as, Most modern cars run on <ex>lead-free</ex> gasoline</as>.  Oposite of <ant>leaded</ant>.</def><br/
<syn><b>Syn. --</b> nonleaded, unleaded.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <specif>specifically:</specif> <def>Not containing a pigment having lead as a component; -- of paints; <as>as, <ex>lead-free</ex> paint should be used wherever children are exposed to the painted surface</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Leadhillite</ent><br/
<hw>Lead"hill*ite</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Min.)</fld> <def>A mineral of a yellowish or greenish white color, consisting of the sulphate and carbonate of lead; -- so called from having been first found at <etsep>Leadhills</etsep>, Scotland.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lead-in</ent><br/
<hw>lead-in</hw> <pos>n.</pos> <sn>1.</sn> <fld>(Elec.)</fld> <def>a wire connecting an antenna to a receiver or a transmitter to a transmission line.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <fld>(Radio and Television Broadcasting)</fld> <def>The short segment of a program or program script introducing and immediately preceding another part of the program or a commercial.</def><br/
[<source>PJC</source>]</p>

<p><ent>Leading</ent><br/
<hw>Lead"ing</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Guiding; directing; controlling; foremost; <as>as, a <ex>leading</ex> motive; a <ex>leading</ex> man; a <ex>leading</ex> example.</as></def> -- <wordforms><wf>Lead"ing*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leading case</b></col> <fld>(Law)</fld>, <cd>a reported decision which has come to be regarded as settling the law of the question involved.</cd> <au>Abbott.</au> -- <col><b>Leading motive</b></col> <ety>[a translation of G. <ets>leitmotif</ets>]</ety> <fld>(Mus.)</fld>, <cd>a guiding theme; in the musical drama of Wagner, a marked melodic phrase or short passage which always accompanies the reappearance of a certain person, situation, abstract idea, or allusion in the course of the play; a sort of musical label.  Also called <altname>leitmotif</altname> or <altname>leitmotiv</altname>.</cd> -- <col><b>Leading note</b></col> <fld>(Mus.)</fld>, <cd>the seventh note or tone in the ascending major scale; the sensible note.</cd> -- <col><b>Leading question</b></col>, <cd>a question so framed as to guide the person questioned in making his reply.</cd> -- <col><b>Leading strings</b></col>, <cd>strings by which children are supported when beginning to walk.</cd> -- <col><b>To be in leading strings</b></col>, <cd>to be in a state of infancy or dependence, or under the guidance of others.</cd> -- <col><b>Leading wheel</b></col>, <cd>a wheel situated before the driving wheels of a locomotive engine.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leading</ent><br/
<hw>Lead"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of guiding, directing, governing, or enticing; guidance.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Suggestion; hint; example.</def> <mark>[Archaic]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leading edge</ent><br/
<hw>Lead"ing edge</hw> <pr>(?)</pr> <pos>n.</pos><sn>1.</sn> <fld>(Aeronautics)</fld> <def>the front edge of an airfoil; same as <altname><er>Advancing edge</er></altname>, above.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>the front edge of anything that moves; also used metaphorically, <as>as the <ex>leading edge</ex> in art</as>.  See also <er>cutting edge</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Leadman</ent><br/
<hw>Lead"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Leadmen</plw> <pr>(<?/)</pr>.</plu> <def>One who leads a dance.</def> <mark>[Obs.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leadsman</ent><br/
<hw>Leads"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Leadsmen</plw> <pr>(<?/)</pr>.</plu> <fld>(Naut.)</fld> <def>The man who heaves the lead.</def>  <rj><au>Totten.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>leadplant</ent><br/
<hw>leadplant</hw> <pos>n.</pos> <def>A shrub (<spn>Amorpha canescens</spn>) of sandy woodlands and streambanks of the Western U. S. having hoary pinnate flowers and dull-colored racemose flowers; it is thought to indicate the presence of lead ore.</def><br/
<syn><b>Syn. --</b> lead plant, <spn>Amorpha canescens</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lead to</ent><br/
<hw>lead to</hw> <pos>v. t.</pos> <sn>1.</sn> <def>Same as <er>cause</er>; <as>as, the roaring stock market <ex>led to</ex> an increase in the purchase of big-ticket items during the 1996 Christmas season</as>.</def><br/
<syn><b>Syn. --</b> result in, lead to.</syn><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>to be a contributory cause of; <as>as, IBM's inattention to the needs of individual users <ex>led to</ex> the demise of OS/2 as a viable alternative to Windows 95</as>.</def><br/
<syn><b>Syn. --</b> be conducive to, contribute to, lead to, conduce to.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Leadwort</ent><br/
<hw>Lead"wort`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A genus of maritime herbs (<gen>Plumbago</gen>).  <spn>Plumbago Europ<ae/a</spn> has lead-colored spots on the leaves, and nearly lead-colored flowers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leady</ent><br/
<hw>Lead"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Resembling lead.</def>  <rj><au>Sir T. Elyot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaf</ent><br/
<hw>Leaf</hw> <pr>(l<emac/f)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Leaves</plw> <pr>(l<emac/vz)</pr>.</plu> <ety>[OE. <ets>leef</ets>, <ets>lef</ets>, <ets>leaf</ets>, AS. <ets>le<aacute/f</ets>; akin to S. <ets>l<omac/f</ets>, OFries. <ets>laf</ets>, D. <ets>loof</ets> foliage, G. <ets>laub</ets>, OHG. <ets>loub</ets> leaf, foliage, Icel. <ets>lauf</ets>, Sw. <ets>l<oum/f</ets>, Dan. <ets>l<oum/v</ets>, Goth. <ets>laufs</ets>; cf. Lith. <ets>lapas</ets>.  Cf. <er>Lodge</er>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>A colored, usually green, expansion growing from the side of a stem or rootstock, in which the sap for the use of the plant is elaborated under the influence of light; one of the parts of a plant which collectively constitute its foliage.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Such leaves usually consist of a blade, or <part>lamina</part> , supported upon a leafstalk or <part>petiole</part>, which, continued through the blade as the <part>midrib</part>, gives off woody <parts>ribs</parts> and <parts>veins</parts> that support the cellular texture.  The petiole has usually some sort of an appendage on each side of its base, which is called the <part>stipule</part>. The green parenchyma of the leaf is covered with a thin epiderm pierced with closable microscopic openings, known as <parts>stomata</parts>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>A special organ of vegetation in the form of a lateral outgrowth from the stem, whether appearing as a part of the foliage, or as a cotyledon, a scale, a bract, a spine, or a tendril.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In this view every part of a plant, except the root and the stem, is either a leaf, or is composed of leaves more or less modified and transformed.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Something which is like a leaf in being wide and thin and having a flat surface, or in being attached to a larger body by one edge or end;</def> <specif>as</specif>: <sd>(a)</sd> <def>A part of a book or folded sheet containing two pages upon its opposite sides.</def> <sd>(b)</sd> <def>A side, division, or part, that slides or is hinged, as of window shutters, folding doors, etc.</def> <sd>(c)</sd> <def>The movable side of a table.</def> <sd>(d)</sd> <def>A very thin plate; <as>as, gold <ex>leaf</ex></as>.</def> <sd>(e)</sd> <def>A portion of fat lying in a separate fold or layer.</def> <sd>(f)</sd> <def>One of the teeth of a pinion, especially when small.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leaf beetle</b></col> <fld>(Zool.)</fld>, <cd>any beetle which feeds upon leaves; esp., any species of the family <fam>Chrysomelid<ae/</fam>, as the potato beetle and helmet beetle.</cd> -- <col><b>Leaf bridge</b></col>, <cd>a draw-bridge having a platform or leaf which swings vertically on hinges.</cd> -- <col><b>Leaf bud</b></col> <fld>(Bot.)</fld>, <cd>a bud which develops into leaves or a leafy branch.</cd> -- <col><b>Leaf butterfly</b></col> <fld>(Zool.)</fld>, <cd>any butterfly which, in the form and colors of its wings, resembles the leaves of plants upon which it rests; esp., butterflies of the genus <gen>Kallima</gen>, found in Southern Asia and the East Indies.</cd> -- <col><b>Leaf crumpler</b></col> <fld>(Zool.)</fld>, <cd>a small moth (<spn>Phycis indigenella</spn>), the larva of which feeds upon leaves of the apple tree, and forms its nest by crumpling and fastening leaves together in clusters.</cd> -- <col><b>Leaf fat</b></col>, <cd>the fat which lies in leaves or layers within the body of an animal.</cd> -- <col><b>Leaf flea</b></col> <fld>(Zool.)</fld>, <cd>a jumping plant louse of the family <fam>Psyllid<ae/</fam>.</cd> -- <col><b>Leaf frog</b></col> <fld>(Zool.)</fld>, <cd>any tree frog of the genus <gen>Phyllomedusa</gen>.</cd> -- <col><b>Leaf green</b></col>.<fld>(Bot.)</fld> <cd>See <er>Chlorophyll</er>.</cd> -- <col><b>Leaf hopper</b></col> <fld>(Zool.)</fld>, <cd>any small jumping hemipterous insect of the genus <gen>Tettigonia</gen>, and allied genera. They live upon the leaves and twigs of plants. See <er>Live hopper</er>.</cd> -- <col><b>Leaf insect</b></col> <fld>(Zool.)</fld>, <cd>any one of several genera and species of orthopterous insects, esp. of the genus <gen>Phyllium</gen>, in which the wings, and sometimes the legs, resemble leaves in color and form. They are common in Southern Asia and the East Indies.</cd> -- <col><b>Leaf lard</b></col>, <cd>lard from leaf fat. See under <er>Lard</er>.</cd> -- <col><b>Leaf louse</b></col> <fld>(Zool.)</fld>, <cd>an aphid.</cd> -- <col><b>Leaf metal</b></col>, <cd>metal in thin leaves, as gold, silver, or tin.</cd> -- <col><b>Leaf miner</b></col> <fld>(Zool.)</fld>, <cd>any one of various small lepidopterous and dipterous insects, which, in the larval stages, burrow in and eat the parenchyma of leaves; <as>as, the pear-tree <ex>leaf miner</ex> (<spn>Lithocolletis geminatella</spn>)</as>.</cd> -- <col><b>Leaf notcher</b></col> <fld>(Zool.)</fld>, <cd>a pale bluish green beetle (<spn>Artipus Floridanus</spn>), which, in Florida, eats the edges of the leaves of orange trees.</cd> -- <col><b>Leaf roller</b></col> <fld>(Zool.)</fld>, <cd>See <er>leaf roller</er> in the vocabulary.</cd>  -- <col><b>Leaf scar</b></col> <fld>(Bot.)</fld>, <cd>the cicatrix on a stem whence a leaf has fallen.</cd> -- <col><b>Leaf sewer</b></col> <fld>(Zool.)</fld>, <cd>a tortricid moth, whose caterpillar makes a nest by rolling up a leaf and fastening the edges together with silk, as if sewn; esp., <spn>Phoxopteris nubeculana</spn>, which feeds upon the apple tree.</cd> -- <col><b>Leaf sight</b></col>, <cd>a hinged sight on a firearm, which can be raised or folded down.</cd> -- <col><b>Leaf trace</b></col> <fld>(Bot.)</fld>, <cd>one or more fibrovascular bundles, which may be traced down an endogenous stem from the base of a leaf.</cd> -- <col><b>Leaf tier</b></col> <fld>(Zool.)</fld>, <cd>a tortricid moth whose larva makes a nest by fastening the edges of a leaf together with silk; esp., <spn>Teras cinderella</spn>, found on the apple tree.</cd> -- <col><b>Leaf valve</b></col>, <cd>a valve which moves on a hinge.</cd> -- <col><b>Leaf wasp</b></col> <fld>(Zool.)</fld>, <cd>a sawfly.</cd> -- <col><b>To turn over a new leaf</b></col>, <cd>to make a radical change for the better in one's way of living or doing.</cd> <mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><q> They were both determined <qex>to turn over a new leaf</qex>.</q> <rj><qau>Richardson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 838 --></p>

<p><ent>Leaf out</ent><br/
<ent>Leaf</ent><br/
<mhw><hw>Leaf</hw>, <hw>Leaf out</hw></mhw> <pr>(l<emac/f)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leafed</conjf> <pr>(l<emac/ft)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leafing</conjf>.]</vmorph> <def>To shoot out leaves; to produce leaves; to leave; <as>as, the trees <ex>leaf</ex> in May</as>.</def>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leafage</ent><br/
<hw>Leaf"age</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Leaves, collectively; foliage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leafcup</ent><br/
<hw>Leaf"cup`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A coarse American composite weed (<spn>Polymnia Uvedalia</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leaf-cutter</ent><br/
<ent>leaf cutter</ent><br/
<mhw><hw>leaf cutter</hw>, <hw>leaf-cutter</hw></mhw> <pos>n.</pos> <fld>(Zool.)</fld> <def>Any one of various species of wild bees of the genus <gen>Megachile</gen>, which cut rounded pieces from the edges of leaves, or the petals of flowers, to be used in the construction of their nests, which are made in holes and crevices, or in a leaf rolled up for the purpose. Among the common American species are <spn>Megachile brevis</spn> and <spn>Megachile centuncularis</spn>. Called also <altname>rose-cutting bee</altname>.</def><br/
<syn><b>Syn. --</b> leaf-cutting bee, leaf-cutter bee.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Leafed</ent><br/
<hw>Leafed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having (such) a leaf or (so many) leaves; -- used in composition; <as>as, broad<ex>-leafed</ex>; four<ex>-leafed</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leafet</ent><br/
<hw>Leaf"et</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A leaflet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaf-footed</ent><br/
<hw>Leaf"-foot`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Having leaflike expansions on the legs; -- said of certain insects; <as>as, the <ex>leaf-footed</ex> bug (<spn>Leptoglossus phyllopus</spn>)</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leaf-hopper</ent><br/
<hw>leaf-hopper</hw> <pos>n.</pos> <def>A small leaping insect that sucks the juices of plants.</def><br/
<syn><b>Syn. --</b> leafhopper.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leafiness</ent><br/
<hw>Leaf"i*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state of being leafy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leafless</ent><br/
<hw>Leaf"less</hw>, <pos>a.</pos> <def>Having no leaves or foliage; bearing no foliage.</def> <ldquo/<xex>Leafless</xex> groves.<rdquo/ <au>Cowper.</au> -- <wordforms><wf>Leaf"less*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leafless plants</b></col>, <cd>plants having no foliage, though leaves may be present in the form of scales and bracts. See <er>Leaf</er>, <pos>n.</pos>, 1 and 2.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaflet</ent><br/
<hw>Leaf"let</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A little leaf.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>One of the divisions of a compound leaf; a foliole.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>A leaflike organ or part; <as>as, a <ex>leaflet</ex> of the gills of fishes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A printed sheet of paper, of one page, or one sheet folded over, containing an advertisement, tract, or other notice, and usually distributed for free or included in the package with a purchased item.</def><br/
[<source>PJC</source>]</p>

<p><ent>Leaf-nosed</ent><br/
<hw>Leaf"-nosed`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Having a leaflike membrane on the nose; -- said of certain bats, esp. of the genera <gen>Phyllostoma</gen> and <gen>Rhinonycteris</gen>. See <er>Vampire</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leaf roller</ent><br/
<ent>leafroller</ent><br/
<mhw><hw>leafroller</hw>, <hw>leaf roller</hw></mhw> <pos>n.</pos> <fld>(Zool.)</fld> <def>The larva of any tortricid moth which makes a nest by rolling up the leaves of plants and tying the leaves with spun silk; aalso, the moth itself.  See <er>Tortrix</er>.</def><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Leafstalk</ent><br/
<hw>Leaf"stalk`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The stalk or petiole which supports a leaf.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leafy</ent><br/
<hw>Leaf"y</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Leafier</adjf> <pr>(?)</pr>; <pos>superl</pos>. <adjf>Leafiest</adjf>.]</amorph> <sn>1.</sn> <def>Full of leaves; abounding in leaves; <as>as, the <ex>leafy</ex> forest</as>.</def> <ldquo/The <xex>leafy</xex> month of June.<rdquo/  <rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Consisting of leaves.</def> <ldquo/A <xex>leafy</xex> bed.<rdquo/  <rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>League</ent><br/
<hw>League</hw> <pr>(l<emac/g)</pr>, <pos>n.</pos> <ety>[Cf. OE. <ets>legue</ets>, <ets>lieue</ets>, a measure of length, F. <ets>lieue</ets>, Pr. <ets>lega</ets>, <ets>legua</ets>, It. & LL. <ets>lega</ets>, Sp. <ets>legua</ets>, Pg. <ets>legoa</ets>, <ets>legua</ets>; all fr. LL. <ets>leuca</ets>, of Celtic origin: cf. Arm. <ets>leo</ets>, <ets>lev</ets> (perh. from French), Ir. <ets>leige</ets> (perh. from English); also Ir. & Gael. <ets>leac</ets> a flag, a broad, flat stone, W. <ets>llech</ets>, -- such stones having perh. served as a sort of milestone (cf. <er>Cromlech</er>).]</ety> <sn>1.</sn> <def>A measure of length or distance, varying in different countries from about 2.4 to 4.6 English statute miles of 5,280 feet each, and used (as a land measure) chiefly on the continent of Europe, and in the Spanish parts of America. The <xex>marine league</xex> of England and the United States is equal to three marine, or geographical, miles of 6080 feet each.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The English land league is equal to three English statute miles. The Spanish and French leagues vary in each country according to usage and the kind of measurement to which they are applied. The Dutch and German leagues contain about four geographical miles, or about 4.6 English statute miles.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A stone erected near a public road to mark the distance of a league.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>League</ent><br/
<hw>League</hw> <pr>(l<emac/g)</pr>, <pos>n.</pos> <ety>[F. <ets>ligue</ets>, LL. <ets>liga</ets>, fr. L. <ets>ligare</ets> to bind; cf. Sp. <ets>liga</ets>.  Cf. <er>Ally</er> a confederate, <er>Ligature</er>.]</ety> <sn>1.</sn> <def>An alliance or combination of two or more nations, parties, organizations, or persons, for the accomplishment of a purpose which requires a continued course of action, as for mutual defense, or for furtherance of commercial, religious, or political interests, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And let there be<br/
'Twixt us and them no <qex>league</qex>, nor amity.</q> <rj><qau>Denham.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>Specifically:</specif> <fld>(Sports)</fld> <def>An association of sports teams that establishes rules of play, decides questions of membership in the league, and organizes matches between the member teams.  In some cases a sports league is called a <altname>conference</altname>, as in the <stype>National Football Conference</stype>.</def><br/
[<source>PJC</source>]</p>

<p><note><hand/ A <xex>league</xex> may be <xex>offensive</xex> or <xex>defensive</xex>, or both; <xex>offensive</xex>, when the parties agree to unite in attacking a common enemy; <xex>defensive</xex>, when they agree to a mutual defense of each other against an enemy.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>The Holy League</b></col>, <cd>an alliance of Roman Catholics formed in 1576 by influence of the Duke of Guise for the exclusion of Protestants from the throne of France.</cd> -- <col><b>Solemn League and Covenant</b></col>. <cd>See <er>Covenant</er>,2.</cd> -- <col><b>The land league</b></col>, <cd>an association, organized in Dublin in 1879, to promote the interests of the Irish tenantry, its avowed objects being to secure fixity of tenure, fair rent, and free sale of the tenants' interest.  It was declared illegal by Parliament, but vigorous prosecutions have failed to suppress it.</cd></cs></p>

<p><syn><b>Syn.</b> -- Alliance; confederacy; confederation; coalition; combination; compact; cooperation.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>League</ent><br/
<hw>League</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leagued</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leaguing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf. F. <ets>se liguer</ets>. See 2d <er>League</er>.]</ety> <def>To unite in a league or confederacy; to combine for mutual support; to confederate.</def>  <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>League</ent><br/
<hw>League</hw>, <pos>v. t.</pos> <def>To join in a league; to cause to combine for a joint purpose; to combine; to unite; <as>as, common interests will <ex>league</ex> heterogeneous elements</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaguer</ent><br/
<hw>Lea"guer</hw>, <pos>n.</pos> <ety>[D. <ets>leger</ets> camp, bed, couch, lair. See <er>Lair</er>, and cf.<er>Beleaguer</er>.]</ety> <sn>1.</sn> <def>The camp of a besieging army; a camp in general.</def>  <rj><au>b. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A siege or beleaguering.</def> <mark>[R.]</mark>  <rj><au>Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaguer</ent><br/
<hw>Lea"guer</hw>, <pos>v. t.</pos> <def>To besiege; to beleaguer.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaguerer</ent><br/
<hw>Lea"guer*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A besieger.</def> <mark>[R.]</mark>  <rj><au>J. Webster.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leak</ent><br/
<hw>Leak</hw> <pr>(l<emac/k)</pr>, <pos>n.</pos> <ety>[Akin to D. <ets>lek</ets> leaky, a leak, G. <ets>leck</ets>, Icel. <ets>lekr</ets> leaky, Dan. <ets>l<ae/k</ets> leaky, a leak, Sw. <ets>l<aum/ck</ets>; cf. AS. <ets>hlec</ets> full of cracks or leaky.  Cf. <er>Leak</er>, <pos>v.</pos>]</ety> <sn>1.</sn> <def>A crack, crevice, fissure, or hole which admits water or other fluid, or lets it escape; <as>as, a <ex>leak</ex> in a roof; a <ex>leak</ex> in a boat; a <ex>leak</ex> in a gas pipe.</as></def> <ldquo/One <xex>leak</xex> will sink a ship.<rdquo/  <rj><au>Bunyan.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The entrance or escape of a fluid through a crack, fissure, or other aperture; <as>as, the <ex>leak</ex> gained on the ship's pumps</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Elec.)</fld> <def>A loss of electricity through imperfect insulation; also, the point at which such loss occurs.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>4.</sn> <def>an act of urinating; -- used mostly in the phrase <col><b>take a leak</b></col>, <it>i. e.</it> to urinate.</def> <mark>[vulgar]</mark> <br/
[<source>PJC</source>]</p>

<p><sn>5.</sn> <def>The disclosure of information that is expected to be kept confidential; <as>as, <ex>leaks</ex> by the White House staff infuriated Nixon; <ex>leaks</ex> by the Special Prosecutor were criticized as illegal</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>To spring a leak</b></col>, <cd>to open or crack so as to let in water; to begin to let in water; <as>as, the ship <ex>sprung a leak</ex></as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leak</ent><br/
<hw>Leak</hw>, <pos>a.</pos> <def>Leaky.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leak</ent><br/
<hw>Leak</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leaked</conjf> <pr>(l<emac/kt)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leaking</conjf>.]</vmorph> <ety>[Akin to D. <ets>lekken</ets>, G. <ets>lecken</ets>, <ets>lechen</ets>, Icel. <ets>leka</ets>, Dan. <ets>l<ae/kke</ets>, Sw. <ets>l<aum/cka</ets>, AS. <ets>leccan</ets> to wet, moisten. See <er>Leak</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To let water or other fluid in or out through a hole, crevice, etc.; <as>as, the cask <ex>leaks</ex>; the roof <ex>leaks</ex>; the boat <ex>leaks</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To enter or escape, as a fluid, through a hole, crevice, etc.; to pass gradually into, or out of, something; -- usually with <ptcl>in</ptcl> or <ptcl>out</ptcl>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To leak out</b></col>, <cd>to be divulged gradually or clandestinely; to become public; as, <as>the facts <ex>leaked out</ex></as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leakage</ent><br/
<hw>Leak"age</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. D. <ets>lekkage</ets>, for sense 1.]</ety> <sn>1.</sn> <def>A leaking; also, the quantity that enters or issues by leaking.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Com.)</fld> <def>An allowance of a certain rate per cent for the leaking of casks, or waste of liquors by leaking.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Elec.)</fld> <def>A <er>leak{3}</er>; also; the quantity of electricity thus wasted.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Leakiness</ent><br/
<hw>Leak"i*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality of being leaky.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leaking</ent><br/
<hw>leak"ing</hw> <pos>adj.</pos> <def>having liquid seeping in or out through openings; leaky.</def><br/
<syn><b>Syn. --</b> leaky.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leakproof</ent><br/
<hw>leak"proof`</hw> <pos>adj.</pos> <def>having no leaks.</def><br/
<syn><b>Syn. --</b> watertight.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leaky</ent><br/
<hw>Leak"y</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Leakier</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Leakiest</adjf>.]</amorph> <sn>1.</sn> <def>Permitting water or other fluid to leak in or out; <as>as, a <ex>leaky</ex> roof or cask; a <ex>leaky</ex> faucet</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Apt to disclose secrets; tattling; not close.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Genetics)</fld> <def>Retaining some function; not completely inactivating the gene; <as>as, substitution mutations are sometimes <ex>leaky</ex></as>; -- of mutations.</def><br/
[<source>PJC</source>]</p>

<p><ent>Leal</ent><br/
<hw>Leal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OE. <ets>leial</ets>, another form of <ets>loial</ets>, F. <ets>loyal</ets>. See <er>Loyal</er>.]</ety> <def>Faithful; loyal; true.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All men true and <qex>leal</qex>, all women pure.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Land of the leal</b></col>, <cd>the place of the faithful; heaven.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leam</ent><br/
<hw>Leam</hw> <pr>(?)</pr>, <pos>n. & v. i.</pos> <def>See <er>Leme</er>.</def> <mark>[Obs.]</mark>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leam</ent><br/
<hw>Leam</hw>, <pos>n.</pos> <ety>[See <er>Leamer</er>, <er>Lien</er>.]</ety> <def>A cord or strap for leading a dog.</def>  <rj><au>Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leamer</ent><br/
<hw>Leam"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>limier</ets>, OF. <ets>liemier</ets>, fr. L. <ets>ligamen</ets> band, bandage. See <er>Lien</er>.]</ety> <def>A dog held by a leam.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lean</ent><br/
<hw>Lean</hw> <pr>(l<emac/n)</pr>, <pos>v. t.</pos> <ety>[Icel. <ets>leyna</ets>; akin to G. <ets>l<aum/ugnen</ets> to deny, AS. <ets>l<ymac/gnian</ets>, also E. <ets>lie</ets> to speak falsely.]</ety> <def>To conceal.</def> <mark>[Obs.]</mark>  <rj><au>Ray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lean</ent><br/
<hw>Lean</hw> <pr>(l<emac/n)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leaned</conjf> <pr>(l<emac/nd)</pr>, sometimes <conjf>Leant</conjf> (l<ecr/nt); <pos>p. pr. & vb. n.</pos> <conjf>Leaning</conjf>.]</vmorph> <ety>[OE. <ets>lenen</ets>, AS. <ets>hlinian</ets>, <ets>hleonian</ets>, <pos>v. i.</pos>; akin to OS. <ets>hlin<omac/n</ets>, D. <ets>leunen</ets>, OHG. <ets>hlin<emac/n</ets>, <ets>lin<emac/n</ets>, G. <ets>lehnen</ets>, L. <ets>inclinare</ets>, Gr. <grk>kli`nein</grk>, L. <ets>clivus</ets> hill, slope. <root/40.  Cf. <er>Declivity</er>, <er>Climax</er>, <er>Incline</er>, <er>Ladder</er>.]</ety> <sn>1.</sn> <def>To incline, deviate, or bend, from a vertical position; to be in a position thus inclining or deviating; <as>as, she <ex>leaned</ex> out at the window; a <ex>leaning</ex> column.</as></def> <ldquo/He <xex>leant</xex> forward.<rdquo/  <rj><au>Dickens.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To incline in opinion or desire; to conform in conduct; -- with <ptcl>to</ptcl>, <ptcl>toward</ptcl>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They delight rather to <qex>lean</qex> to their old customs.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To rest or rely, for support, comfort, and the like; -- with <ptcl>on</ptcl>, <ptcl>upon</ptcl>, or <ptcl>against</ptcl>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>leaned</qex> not on his fathers but himself.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lean</ent><br/
<hw>Lean</hw>, <pos>v. t.</pos> <ety>[From <er>Lean</er>, <pos>v. i.</pos>; AS. <ets>hl<aemac/nan</ets>, v. t., fr. <ets>hleonian</ets>, <ets>hlinian</ets>, <pos>v. i.</pos>]</ety> <def>To cause to lean; to incline; to support or rest.</def>  <rj><au>Mrs. Browning.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His fainting limbs against an oak he <qex>leant</qex>.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lean</ent><br/
<hw>Lean</hw> <pr>(l<emac/n)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Leaner</adjf> <pr>(l<emac/n"<etil/r)</pr>; <pos>superl.</pos> <adjf>Leanest</adjf>.]</amorph> <ety>[OE. <ets>lene</ets>, AS. <ets>hl<aemac/ne</ets>; prob. akin to E. <ets>lean</ets> to incline. See <er>Lean</er>, <pos>v. i.</pos> ]</ety> <sn>1.</sn> <def>Wanting flesh; destitute of or deficient in fat; slim; not plump; slender; meager; thin; lank; <as>as, a <ex>lean</ex> body; a <ex>lean</ex> cattle.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Wanting fullness, richness, sufficiency, or productiveness; deficient in quality or contents; slender; scant; barren; bare; mean; -- used literally and figuratively; <as>as, the <ex>lean</ex> harvest; a <ex>lean</ex> purse; a <ex>lean</ex> discourse; <ex>lean</ex> wages.</as></def> <ldquo/No <xex>lean</xex> wardrobe.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Their <qex>lean</qex> and flashy songs.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>What the land is, whether it be fat or <qex>lean</qex>.</q> <rj><qau>Num. xiii. 20.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Out of my <qex>lean</qex> and low ability<br/
I'll lend you something.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Typog.)</fld> <def>Of a character which prevents the compositor from earning the usual wages; -- opposed to <ant>fat</ant>; <as>as, <ex>lean</ex> copy, matter, or type</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- slender; spare; thin; meager; lank; skinny; gaunt.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lean</ent><br/
<hw>Lean</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>That part of flesh which consists principally of muscle without the fat.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The fat was so white and the <qex>lean</qex> was so ruddy.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Typog.)</fld> <def>Unremunerative copy or work.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lean-faced</ent><br/
<hw>Lean"-faced`</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having a thin face.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Typog.)</fld> <def>slender or narrow; -- said of type the letters of which have thin lines, or are unusually narrow in proportion to their height.</def>  <rj><au>W. Savage.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaning</ent><br/
<hw>Lean"ing</hw>, <pos>n.</pos> <def>The act, or state, of inclining; inclination; tendency; <as>as, a <ex>leaning</ex> towards Calvinism</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leanly</ent><br/
<hw>Lean"ly</hw>, <pos>adv.</pos> <def>Meagerly; without fat or plumpness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leanness</ent><br/
<hw>Lean"ness</hw>, <pos>n.</pos> <ety>[AS. <ets>hl<aemac/nnes</ets>.]</ety> <def>The condition or quality of being lean.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lean-to</ent><br/
<hw>Lean"-to`</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Arch.)</fld> <def>Having only one slope or pitch; -- said of a roof.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lean-to</ent><br/
<hw>Lean"-to`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Arch.)</fld> <def>A shed or slight building placed against the wall of a larger structure and having a single-pitched roof; -- called also <altname>penthouse</altname>, and <altname>to-fall</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The outer circuit was covered as a <qex>lean-to</qex>, all round this inner apartment.</q> <rj><qau>De Foe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A crude, usually temporary shelter comprising a lean-to roof braced against any convenient support, as a wall, a tree or a pole. The roof may extend all the way to the ground.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lean-witted</ent><br/
<hw>Lean"-wit`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having but little sense or shrewdness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leany</ent><br/
<hw>Lean"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Lean.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leap</ent><br/
<hw>Leap</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>le<aacute/p</ets>.]</ety> <sn>1.</sn> <def>A basket.</def> <mark>[Obs.]</mark>  <rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A weel or wicker trap for fish.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leap</ent><br/
<hw>Leap</hw> <pr>(l<emac/p)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leaped</conjf> <pr>(l<emac/pt; 277)</pr>, rarely <conjf>Leapt</conjf>  <pr>(l<emac/pt <it>or</it> l<ecr/pt)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leaping</conjf>.]</vmorph> <ety>[OE. <ets>lepen</ets>, <ets>leapen</ets>, AS. <ets>hle<aacute/pan</ets> to leap, jump, run; akin to OS. <ets><amac/hl<omac/pan</ets>, OFries. <ets>hlapa</ets>, D. <ets>loopen</ets>, G. <ets>laufen</ets>, OHG. <ets>louffan</ets>, <ets>hlauffan</ets>, Icel. <ets>hlaupa</ets>, Sw. <ets>l<oum/pa</ets>, Dan. <ets>l<oum/be</ets>, Goth. <ets>ushlaupan</ets>.  Cf. <er>Elope</er>, <er>Lope</er>, <er>Lapwing</er>, <er>Loaf</er> to loiter.]</ety> <sn>1.</sn> <def>To spring clear of the ground, with the feet; to jump; to vault; <as>as, a man <ex>leaps</ex> over a fence, or <ex>leaps</ex> upon a horse</as>.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q> <qex>Leap</qex> in with me into this angry flood.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To spring or move suddenly, as by a jump or by jumps; to bound; to move swiftly. Also Fig.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>My heart <qex>leaps</qex> up when I behold<br/
A rainbow in the sky.</q> <rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leap</ent><br/
<hw>Leap</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To pass over by a leap or jump; <as>as, to <ex>leap</ex> a wall, or a ditch</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To copulate with (a female beast); to cover.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To cause to leap; <as>as, to <ex>leap</ex> a horse across a ditch</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leap</ent><br/
<hw>Leap</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of leaping, or the space passed by leaping; a jump; a spring; a bound.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Wickedness comes on by degrees, . . . and sudden <qex>leaps</qex> from one extreme to another are unnatural.</q> <rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Changes of tone may proceed either by <qex>leaps</qex> or glides.</q> <rj><qau>H. Sweet.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Copulation with, or coverture of, a female beast.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mining)</fld> <def>A fault.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mus.)</fld> <def>A passing from one note to another by an interval, especially by a long one, or by one including several other and intermediate intervals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaper</ent><br/
<hw>Leap"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>hle<aacute/pere</ets>.]</ety> <def>One who, or that which, leaps.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaper</ent><br/
<hw>Leap"er</hw>, <pos>n.</pos> <ety>[See 1st <er>Leap</er>.]</ety> <def>A kind of hooked instrument for untwisting old cordage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leapfrog</ent><br/
<hw>Leap"frog`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A play among boys, in which one stoops down and another leaps over him by placing his hands on the shoulders of the former.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leapful</ent><br/
<hw>Leap"ful</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See 1st <er>Leap</er>.]</ety> <def>A basketful.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaping</ent><br/
<hw>Leap"ing</hw>, <pos>a. & n.</pos> <def>from <er>Leap</er>, to jump.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leaping house</b></col>, <cd>a brothel.</cd> <mark>[Obs.]</mark> <au>Shak.</au> -- <col><b>Leaping pole</b></col>, <cd>a pole used in some games of leaping.</cd> -- <col><b>Leaping spider</b></col> <fld>(Zool.)</fld>, <cd>a jumping spider; one of the <fam>Saltigrad<ae/</fam>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leapingly</ent><br/
<hw>Leap"ing*ly</hw>, <pos>adv.</pos> <def>By leaps.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leap year</ent><br/
<hw>Leap" year`</hw> <pr>(?)</pr> <pos>n.</pos><def>Bissextile; a year containing 366 days; every fourth year which <xex>leaps</xex> over a day more than a common year, giving to February twenty-nine days. See <er>Bissextile</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Every year whose number is divisible by four without a remainder is a leap year, excepting the full centuries, which, to be leap years, must be divisible by 400 without a remainder. If not so divisible they are common years. 1900, therefore, is not a leap year, but 2000 is.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lear</ent><br/
<hw>Lear</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To learn. See <er>Lere</er>, to learn.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lear</ent><br/
<hw>Lear</hw>, <pos>n.</pos> <def>Lore; lesson.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lear</ent><br/
<hw>Lear</hw>, <pos>a.</pos> <def>See <er>Leer</er>, <pos>a.</pos></def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lear</ent><br/
<hw>Lear</hw>, <pos>n.</pos> <def>An annealing oven. See <er>Leer</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Learn</ent><br/
<hw>Learn</hw> <pr>(l<etil/rn)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Learned</conjf> <pr>(l<etil/rnd)</pr>, or <conjf>Learnt</conjf> (l<etil/rnt); <pos>p. pr. & vb. n.</pos> <conjf>Learning</conjf>.]</vmorph> <ety>[OE. <ets>lernen</ets>, <ets>leornen</ets>, AS. <ets>leornian</ets>; akin to OS. <ets>lin<omac/n</ets>, for <ets>lirn<omac/n</ets>, OHG. <ets>lirn<emac/n</ets>, <ets>lern<emac/n</ets>, G. <ets>lernen</ets>, fr. the root of AS. <ets>l<aemac/ran</ets> to teach, OS. <ets>l<emac/rian</ets>, OHG. <ets>l<emac/ran</ets>, G. <ets>lehren</ets>, Goth. <ets>laisjan</ets>, also Goth <ets>lais</ets> I know, <ets>leis</ets> acquainted (in comp.); all prob. from a root meaning, to go, go over, and hence, to learn; cf. AS. <ets>leoran</ets> to go.  Cf. <er>Last</er> a mold of the foot, <er>lore</er>.]</ety> <sn>1.</sn> <def>To gain knowledge or information of; to ascertain by inquiry, study, or investigation; to receive instruction concerning; to fix in the mind; to acquire understanding of, or skill; <as>as, to <ex>learn</ex> the way; to <ex>learn</ex> a lesson; to <ex>learn</ex> dancing; to <ex>learn</ex> to skate; to <ex>learn</ex> the violin; to <ex>learn</ex> the truth about something.</as></def> <ldquo/<xex>Learn</xex> to do well.<rdquo/  <rj><au>Is. i. 17.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Now <qex>learn</qex> a parable of the fig tree.</q> <rj><qau>Matt. xxiv. 32.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To communicate knowledge to; to teach.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Hast thou not <qex>learned</qex> me how<br/
To make perfumes ?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Learn</xex> formerly had also the sense of <xex>teach</xex>, in accordance with the analogy of the French and other languages, and hence we find it with this sense in Shakespeare, Spenser, and other old writers.  This usage has now passed away.  To <xex>learn</xex> is to receive instruction, and to <xex>teach</xex> is to give instruction.  He who is <xex>taught</xex> learns, not he who <xex>teaches</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Learn</ent><br/
<hw>Learn</hw>, <pos>v. i.</pos> <def>To acquire knowledge or skill; to make progress in acquiring knowledge or skill; to receive information or instruction; <as>as, this child <ex>learns</ex> quickly</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Take my yoke upon you and <qex>learn</qex> of me.</q> <rj><qau>Matt. xi. 29.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To learn by heart</b></col>. <cd>See <cref>By heart</cref>, under <er>Heart</er>.</cd> -- <col><b>To learn by rote</b></col>, <cd>to memorize by repetition without exercise of the understanding.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 839 --></p>

<p><ent>Learnable</ent><br/
<hw>Learn"a*ble</hw> <pr>(l<etil/rn"<adot/*b'l)</pr>, <pos>a.</pos> <def>Such as can be learned.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Learned</ent><br/
<hw>Learn"ed</hw> <pr>(l<etil/rn"<ecr/d)</pr>, <pos>a.</pos> <def>Of or pertaining to learning; possessing, or characterized by, learning, esp. scholastic learning; erudite; well-informed; <as>as, a <ex>learned</ex> scholar, writer, or lawyer; a <ex>learned</ex> book; a <ex>learned</ex> theory.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>learned</qex>lover lost no time.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Men of much reading are greatly <qex>learned</qex>, but may be little knowing.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Words of <qex>learned</qex> length and thundering sound.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>The learned</b></col>, <cd>learned men; men of erudition; scholars.</cd></cs></p>

<p>-- <wordforms><wf>Learn"ed*ly</wf>, <pos>adv.</pos> <wf>Learn"ed*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q>Every coxcomb swears as <qex>learnedly</qex> as they.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>learnedness</ent><br/
<hw>learn"ed*ness</hw> <pos>n.</pos> <def>profound knowledge.</def><br/
<syn><b>Syn. --</b> eruditeness, erudition, learning, scholarship.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Learner</ent><br/
<hw>Learn"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who learns; a scholar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Learning</ent><br/
<hw>Learn"ing</hw>, <pos>n.</pos> <ety>[AS. <ets>leornung</ets>.]</ety> <sn>1.</sn> <def>The acquisition of knowledge or skill; <as>as, the <ex>learning</ex> of languages; the <ex>learning</ex> of telegraphy.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The knowledge or skill received by instruction or study; acquired knowledge or ideas in any branch of science or literature; erudition; literature; science; <as>as, he is a man of great <ex>learning</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Book learning</b></col>. <cd>See under <er>Book</er>.</cd></cs></p>

<p><syn><b>Syn.</b> -- Literature; erudition; lore; scholarship; science; letters. See <er>Literature</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leasable</ent><br/
<hw>Leas"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From 2d <er>Lease</er>.]</ety> <def>Such as can be leased.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lease</ent><br/
<hw>Lease</hw> <pr>(l<emac/z)</pr>, <pos>v. i.</pos> <ety>[AS. <ets>lesan</ets> to gather; akin to D. <ets>lezen</ets> to gather, read, G. <ets>lesen</ets>, Goth. <ets>lisan</ets> to gather; cf. Lith <ets>lesti</ets> to peck.]</ety> <def>To gather what harvesters have left behind; to glean.</def> <mark>[Obs.]</mark>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lease</ent><br/
<hw>Lease</hw> <pr>(l<emac/s)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leased</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leasing</conjf>.]</vmorph> <ety>[F. <ets>laisser</ets>, OF. <ets>laissier</ets>, <ets>lessier</ets>, to leave, transmit, L. <ets>laxare</ets> to loose, slacken, from <ets>laxus</ets> loose, wide. See <er>Lax</er>, and cf. <er>Lesser</er>.]</ety> <sn>1.</sn> <def>To grant to another by lease the possession of, as of lands, tenements, and hereditaments; to let; to demise; <as>as, a landowner <ex>leases</ex> a farm to a tenant</as>; -- sometimes with <ptcl>out</ptcl>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There were some [houses] that were <qex>leased</qex> out for three lives.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To hold under a lease; to take lease of; <as>as, a tenant <ex>leases</ex> his land from the owner</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lease</ent><br/
<hw>Lease</hw> <pr>(l<emac/s)</pr>, <pos>n.</pos> <ety>[Cf. OF. <ets>lais</ets>. See <er>Lease</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>The temporary transfer of a possession to another person in return for a fee or other valuable consideration paid for the transfer;</def> <specif>especially,</specif> <def>A demise or letting of lands, tenements, or hereditaments to another for life, for a term of years, or at will, or for any less interest than that which the lessor has in the property, usually for a specified rent or compensation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The contract for such letting.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any tenure by grant or permission; the time for which such a tenure holds good; allotted time.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our high-placed Macbeth<br/
Shall live the <qex>lease</qex> of nature.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lease and release</b></col> <cd>a mode of conveyance of freehold estates, formerly common in England and in New York. its place is now supplied by a simple deed of grant.</cd>  <rj><au>Burrill.</au>  <au>Warren's Blackstone.</au></rj>
</cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leasehold</ent><br/
<hw>Lease"hold`</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Held by lease.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leasehold</ent><br/
<hw>Lease"hold`</hw>, <pos>n.</pos> <def>A tenure by lease; specifically, land held as personalty under a lease for years.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaseholder</ent><br/
<hw>Lease"hold`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A tenant under a lease.</def> -- <wordforms><wf>Lease"hold`ing</wf>, <pos>a. & n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>lease-lend</ent><br/
<hw>lease-lend</hw> <pos>n.</pos> <def>Same as <er>lend-lease</er>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leaser</ent><br/
<hw>Leas"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From 1st <er>Lease</er>.]</ety> <def>One who leases or gleans.</def> <mark>[Obs.]</mark>  <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaser</ent><br/
<hw>Leas"er</hw>, <pos>n.</pos> <def>A liar.</def> <mark>[Obs.]</mark> <see>See <er>Leasing</er>.</see><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leash</ent><br/
<hw>Leash</hw> <pr>(l<emac/sh)</pr>, <pos>n.</pos> <ety>[OE. <ets>lese</ets>, <ets>lees</ets>, <ets>leece</ets>, OF. <ets>lesse</ets>, F. <ets>laisse</ets>, LL. <ets>laxa</ets>, fr. L. <ets>laxus</ets> loose. See <er>Lax</er>.]</ety> <sn>1.</sn> <def>A thong of leather, or a long cord, by which a person may hold or restrain an animal, such as a falconer holding his hawk, or a courser his dog.  For dogs and cats, the <ex>leash</ex> is commonly attached to a collar around the neck of the animal.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Even like a fawning greyhound in the <qex>leash</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Sporting)</fld> <def>A brace and a half; a tierce; three; three creatures of any kind, especially greyhounds, foxes, bucks, and hares; hence, the number three in general.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[I] kept my chamber a <qex>leash</qex> of days.</q> <rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Then were I wealthier than a <qex>leash</qex> of kings.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Weaving)</fld> <def>A string with a loop at the end for lifting warp threads, in a loom.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To keep (a person) on a short leash</b></col> <cd>to maintain close control over the activities of (a person).</cd></cs><br/
[<source>PJC</source>]</p>

<p><ent>Leash</ent><br/
<hw>Leash</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leashed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leashing</conjf>.]</vmorph> <def>To tie together, or hold, with a leash.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leasing</ent><br/
<hw>Leas"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>le<aacute/sung</ets>, fr. <ets>le<aacute/s</ets> loose, false, deceitful. See <er>-less</er>, <er>Loose</er>, <pos>a.</pos>]</ety> <def>The act of lying; falsehood; a lie or lies.</def> <mark>[Archaic]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou shalt destroy them that speak <qex>leasing</qex>.</q> <rj><qau>Ps. v. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Blessed be the lips that such a <qex>leasing</qex> told.</q> <rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leasing making</b></col> <fld>(Scots Law)</fld>, <cd>the uttering of lies or libels upon the personal character of the sovereign, his court, or his family.</cd>  <rj><au>Bp. Burnet.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leasow</ent><br/
<hw>Lea"sow</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>lesu</ets>, <ets>l<ae/su</ets>.]</ety> <def>A pasture.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Least</ent><br/
<hw>Least</hw> <pr>(l<emac/st)</pr>, <pos>a.</pos> <ety>[OE. <ets>last</ets>, <ets>lest</ets>, AS. <ets>l<aemac/sast</ets>, <ets>l<aemac/sest</ets>, superl. of <ets>l<aemac/ssa</ets> less. See <er>Less</er>, <pos>a.</pos>]</ety> <mark>[Used as the superlative of <xex>little</xex>.]</mark> <def>Smallest, either in size or degree; shortest; lowest; most unimportant; <as>as, the <ex>least</ex> insect; the <ex>least</ex> mercy; the <ex>least</ex> space.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Least</xex> is often used with <xex>the</xex>, as if a noun.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>I am the <qex>least</qex> of the apostles.</q> <rj><qau>1 Cor. xv. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>At least</b></col>, <it>or</it> <col><b>At the least</b></col></mcol>, <cd>at the least estimate, consideration, chance, etc.; being no less than; hence, at any rate; at all events; even. See <er>However</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>He who tempts, though in vain, <qex>at least</qex> asperses<br/
The tempted with dishonor.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Upon the mast they saw a young man, <qex>at least</qex> if he were a man, who sat as on horseback.</q> <rj><qau>Sir P. Sidney.</qau></rj></p>

<p>-- <mcol><col><b>In least</b></col>, <it>or</it>  <col><b>In the least</b></col></mcol>, <cd>in the least degree, manner, etc.</cd> <ldquo/He that is unjust <xex>in the least</xex> is unjust also in much.<rdquo/ <au>Luke xvi. 10.</au> -- <col><b>Least squares</b></col> <fld>(Math.)</fld>, <cd>a method of deducing from a number of carefully made yet slightly discordant observations of a phenomenon the most probable values of the unknown quantities.</cd> <note>It takes as its fundamental principle that the most probable values are those which make the sum of the squares of the residual errors of the observation a minimum.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Least</ent><br/
<hw>Least</hw>, <pos>adv.</pos> <def>In the smallest or lowest degree; in a degree below all others; <as>as, to reward those who <ex>least</ex> deserve it</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Least</ent><br/
<hw>Least</hw>, <pos>conj.</pos> <def>See <er>Lest</er>, <pos>conj.</pos></def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leastwise</ent><br/
<ent>Leastways</ent><br/
<mhw>{ <hw>Least"ways`</hw> <pr>(?)</pr>, <hw>Least"wise`</hw> <pr>(?)</pr>, }</mhw> <pos>adv.</pos> <def>At least; at all events.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>At leastways</b></col>, <it>or</it> <col><b>At leastwise</b></col></mcol>, <cd>at least.</cd> <mark>[Obs.]</mark>  <rj><au>Fuller.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leasy</ent><br/
<hw>Lea"sy</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[AS. <ets>le<aacute/s</ets> void, loose, false.  Cf. <er>Leasing</er>.]</ety> <def>Flimsy; vague; deceptive.</def> <mark>[Obs.]</mark>  <rj><au>Ascham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leat</ent><br/
<hw>Leat</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Lead</er> to conduct.]</ety> <def>An artificial water trench, esp. one to or from a mill.</def>  <rj><au>C. Kingsley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leather</ent><br/
<hw>Leath"er</hw> <pr>(l<ecr/<th/"<etil/r)</pr>, <pos>n.</pos> <ety>[OE. <ets>lether</ets>, AS. <ets>le<edh/er</ets>; akin to D. <ets>leder</ets>, <ets>le<ecir/r</ets>, G. <ets>leder</ets>, OHG. <ets>ledar</ets>, Icel. <ets>le<edh/r</ets>, Sw. <ets>l<aum/der</ets>, Dan. <ets>l<ae/der</ets>.]</ety> <sn>1.</sn> <def>The skin of an animal, or some part of such skin, with the hair removed, and tanned, tawed, or otherwise dressed for use; also, dressed hides, collectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The skin.</def> <mark>[Ironical or Sportive]</mark><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Leather</xex> is much used adjectively in the sense of <xex>made of</xex>, <xex>relating to</xex>, <xex>or like</xex>, <xex>leather</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leather board</b></col>, <cd>an imitation of sole leather, made of leather scraps, rags, paper, etc.</cd> -- <col><b>Leather carp</b></col> <fld>(Zool.)</fld> <cd>, a variety of carp in which the scales are all, or nearly all, absent. See <xex>Illust.</xex> under <er>Carp</er>.</cd> -- <col><b>Leather jacket</b></col>. <fld>(Zool.)</fld> <sd>(a)</sd> <cd>A California carangoid fish (<spn>Oligoplites saurus</spn>).</cd> <sd>(b)</sd> <cd>A trigger fish (<spn>Balistes Carolinensis</spn>).</cd> -- <col><b>Leather flower</b></col> <fld>(Bot.)</fld>, <cd>a climbing plant (<spn>Clematis Viorna</spn>) of the Middle and Southern States having thick, leathery sepals of a purplish color.</cd> -- <col><b>Leather leaf</b></col> <fld>(Bot.)</fld>, <cd>a low shrub (<spn>Cassandra calyculata</spn>), growing in Northern swamps, and having evergreen, coriaceous, scurfy leaves.</cd> -- <col><b>Leather plant</b></col> <fld>(Bot.)</fld>, <cd>one or more New Zealand plants of the composite genus <gen>Celmisia</gen>, which have white or buff tomentose leaves.</cd> -- <col><b>Leather turtle</b></col>. <fld>(Zool.)</fld> <cd>See <er>Leatherback</er>.</cd> -- <col><b>Vegetable leather</b></col>. <sd>(a)</sd> <cd>An imitation of leather made of cotton waste.</cd> <sd>(b)</sd> <cd>Linen cloth coated with India rubber.</cd>  <rj><au>Ure.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leather</ent><br/
<hw>Leath"er</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leathered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leathering</conjf>.]</vmorph> <def>To beat, as with a thong of leather.</def> <mark>[Obs. or Colloq.]</mark>  <rj><au>G. Eliot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>leather</ent><br/
<hw>leath"er</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of, pertaining to or made of leather; consisting of leather; <as>as, a black <ex>leather</ex> jacket</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Leatherback</ent><br/
<hw>Leath"er*back`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A large sea turtle (<spn>Sphargis coriacea</spn>), having no bony shell on its back. It is common in the warm and temperate parts of the Atlantic, and sometimes weighs over a thousand pounds; -- called also <altname>leather turtle</altname>, <altname>leathery turtle</altname>, <altname>leather-backed tortoise</altname>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leatherette</ent><br/
<ent>Leatheret</ent><br/
<mhw>{ <hw>Leath"er*et</hw> <pr>(?)</pr>, <hw>Leath`er*ette"</hw> <pr>(?)</pr> }</mhw>, <pos>n.</pos> <ety>[<ets>Leather</ets> + <ets>et</ets>, F. <ets>-ette</ets>.]</ety> <def>A material made in imitation of leather, made of paper and cloth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leatherfish</ent><br/
<hw>leatherfish</hw> <pos>n.</pos> <def>any of several brightly colored tropical filefishes.</def><br/
<syn><b>Syn. --</b> leatherjacket.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leatherhead</ent><br/
<hw>Leath"er*head`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The friar bird.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leatherjack</ent><br/
<hw>leatherjack</hw> <pos>n.</pos> <def>any of several New World tropical fishes having tiny embedded scales; the leatherjacket{2}.</def><br/
<syn><b>Syn. --</b> leatherjacket.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leatherjacket</ent><br/
<hw>leatherjacket</hw> <pos>n.</pos> <sn>1.</sn> <def>any of several brightly colored tropical filefishes.</def><br/
<syn><b>Syn. --</b> leatherfish.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>any of several New World tropical fishes having tiny embedded scales.</def><br/
<syn><b>Syn. --</b> leatherjack.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>The tough-skinned larva of certain crane flies.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leatherleaf</ent><br/
<hw>leatherleaf</hw> <pos>n.</pos> <sn>1.</sn> <def>A stiff leathery-leaved fern (<spn>Polypodium scouleri</spn>) of Western North America having ovate fronds parted to the midrib.</def><br/
<syn><b>Syn. --</b> leathery polypody, coast polypody, <spn>Polypodium scouleri</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A northern temperate bog shrub (<spn>Chamaedaphne calyculata</spn>) with evergreen leathery leaves and small white cylindrical flowers.</def><br/
<syn><b>Syn. --</b> <spn>Chamaedaphne calyculata</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leatherlike</ent><br/
<hw>leatherlike</hw> <pos>adj.</pos>  <def>resembling or made to resemble leather; tough but pliable; leathery.</def><br/
<syn><b>Syn. --</b> coriaceous, leathered, leathery.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leathern</ent><br/
<hw>Leath"ern</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Made of leather; consisting of leather; <as>as, a <ex>leathern</ex> purse</as>.</def> <ldquo/A <xex>leathern</xex> girdle about his loins.<rdquo/  <rj><au>Matt. iii. 4.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>leatherneck</ent><br/
<hw>leath"er*neck`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Zool.)</fld> <def>The sordid friar bird of Australia (<spn>Tropidorhynchus sordidus</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[from the leather collar that was once part of their uniform.]</ety> <def>A member of the United States Marine Corps; a United States Marine.</def> <mark>[slang]</mark><br/
[<source>PJC</source>]</p>

<p><ent>Leatherwood</ent><br/
<hw>Leath"er*wood`</hw>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A small branching shrub (<spn>Dirca palustris</spn>), with a white, soft wood, and a tough, leathery bark, common in damp woods in the Northern United States; -- called also <altname>moosewood</altname>, and <altname>wicopy</altname>.</def>  <rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>leatherwork</ent><br/
<hw>leatherwork</hw> <pos>n.</pos> <def>Articles made of leather.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leathery</ent><br/
<hw>Leath"er*y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Resembling leather in appearance or consistency; tough; <as>as, nothing but a <ex>leathery</ex> steak left to eat</as>.</def> <ldquo/A <xex>leathery</xex> skin.<rdquo/  <rj><au>Grew.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leave</ent><br/
<hw>Leave</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leaved</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leaving</conjf>]</vmorph> <def>To send out leaves; to leaf; -- often with <ptcl>out</ptcl>.</def>  <rj><au>G. Fletcher.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leave</ent><br/
<hw>Leave</hw>, <pos>v. t.</pos> <ety>[See <er>Levy</er>.]</ety> <def>To raise; to levy.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>An army strong she <qex>leaved</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leave</ent><br/
<hw>Leave</hw>, <pos>n.</pos> <ety>[OE. <ets>leve</ets>, <ets>leave</ets>, AS. <ets>le<aacute/f</ets>; akin to <ets>le<oacute/f</ets> pleasing, dear, E. <ets>lief</ets>, D. oor<ets>lof</ets> leave, G. ar<ets>laub</ets>, and er<ets>lauben</ets> to permit, Icel. <ets>leyfi</ets>.  <root/124.  See <er>Lief</er>.]</ety> <sn>1.</sn> <def>Liberty granted by which restraint or illegality is removed; permission; allowance; license.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>David earnestly asked <qex>leave</qex> of me.</q> <rj><qau>1 Sam. xx. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>No friend has <qex>leave</qex> to bear away the dead.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act of leaving or departing; a formal parting; a leaving; farewell; adieu; -- used chiefly in the phrase, <xex>to take leave</xex>, i. e., literally, to take permission to go.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A double blessing is a'double grace;<br/
Occasion smiles upon a second <qex>leave</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And Paul after this tarried there yet a good while, and then took his <qex>leave</qex> of the brethren.</q> <rj><qau>Acts xviii. 18.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>French leave</b></col>. <cd>See under <er>French</er>.</cd></cs></p>

<p><syn><b>Syn.</b> -- See <er>Liberty</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leave</ent><br/
<hw>Leave</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Left</conjf> <pr>(l<ecr/ft)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leaving</conjf>.]</vmorph> <ety>[OE. <ets>leven</ets>, AS. <ets>l<?/fan</ets>, fr. <ets>l<amac/f</ets> remnant, heritage; akin to <ets>lifian</ets>, <ets>libban</ets>, to live, orig., to remain; cf. be<ets>l<imac/fan</ets> to remain, G. b<ets>leiben</ets>, Goth. bi<ets>leiban</ets>. <root/119.  See <er>Live</er>, <pos>v.</pos>]</ety> <sn>1.</sn> <def>To withdraw one's self from; to go away from; to depart from; <as>as, to <ex>leave</ex> the house</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Therefore shall a man <qex>leave</qex> his father and his mother, and shall cleave unto his wife.</q> <rj><qau>Gen. ii. 24.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To let remain unremoved or undone; to let stay or continue, in distinction from what is removed or changed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If grape gatherers come to thee, would they not <qex>leave</qex> some gleaning grapes ?</q> <rj><qau>Jer. xlix. 9. </qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>These ought ye to have done, and not to <qex>leave</qex> the other undone.</q> <rj><qau>Matt. xxiii. 23. </qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Besides it <qex>leaveth</qex> a suspicion, as if more might be said than is expressed.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To cease from; to desist from; to abstain from.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Now <qex>leave</qex> complaining and begin your tea.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To desert; to abandon; to forsake; hence, to give up; to relinquish.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Lo, we have <qex>left</qex> all, and have followed thee.</q> <rj><qau>Mark x. 28.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The heresies that men do <qex>leave</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To let be or do without interference; <as>as, I <ex>left</ex> him to his reflections; I <ex>leave</ex> my hearers to judge.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will <qex>leave</qex> you now to your gossiplike humor.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To put; to place; to deposit; to deliver; to commit; to submit -- with a sense of withdrawing one's self from; <as>as, <ex>leave</ex> your hat in the hall; we <ex>left</ex> our cards; to <ex>leave</ex> the matter to arbitrators.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Leave</qex> there thy gift before the altar and go thy way.</q> <rj><qau>Matt. v. 24.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The foot<br/
That <qex>leaves</qex> the print of blood where'er it walks.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To have remaining at death; hence, to bequeath; <as>as, he <ex>left</ex> a large estate; he <ex>left</ex> a good name; he <ex>left</ex> a legacy to his niece.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>to cause to be; -- followed by an adjective or adverb describing a state or condition; <as>as, the losses due to fire <ex>leave</ex> me penniless; The cost of defending himself <ex>left</ex> <person>Bill Clinton</person> with a mountain of lawyers' bills</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><cs><col><b>To leave alone</b></col>. <sd>(a)</sd> <cd>To leave in solitude.</cd> <sd>(b)</sd> <cd>To desist or refrain from having to do with; <as>as, <ex>to leave</ex> dangerous chemicals <ex>alone</ex></as>.</cd> -- <col><b>To leave off</b></col>. <sd>(a)</sd> <cd>To desist from; to forbear; to stop; <as>as, <ex>to leave off</ex> work at six o'clock</as>.</cd> <sd>(b)</sd> <cd>To cease wearing or using; to omit to put in the usual position; <as>as, <ex>to leave off</ex> a garment; <ex>to leave off</ex> the tablecloth</as>.</cd> <sd>(c)</sd> <cd>To forsake; <as>as, <ex>to leave off</ex> a bad habit</as>.</cd> -- <col><b>To leave out</b></col>, <cd>to omit; <as>as, <ex>to leave out</ex> a word or name in writing</as>.</cd> -- <col><b>To leave to one's self</b></col>, <cd>to let (one) be alone; to cease caring for (one).</cd></cs></p>

<p><syn>Syn>- To quit; depart from; forsake; abandon; relinquish; deliver; bequeath; give up; forego; resign; surrender; forbear. See <er>Quit</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leave</ent><br/
<hw>Leave</hw> <pr>(?)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To depart; to set out.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>By the time I <qex>left</qex> for Scotland.</q> <rj><qau>Carlyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cease; to desist; to leave off.</def> <ldquo/He . . . began at the eldest, and <xex>left</xex> at the youngest.<rdquo/  <rj><au>Gen. xliv. 12.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To leave off</b></col>, <cd>to cease; to desist; to stop.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Leave off</qex>, and for another summons wait.</q> <rj><qau>Roscommon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaved</ent><br/
<hw>Leaved</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From <er>Leaf</er>.]</ety> <def>Bearing, or having, a leaf or leaves; having folds; -- used in combination; <as>as, a four<ex>-leaved</ex> clover; a two-<ex>leaved</ex> gate; long<ex>-leaved</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaveless</ent><br/
<hw>Leave"less</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Leafless.</def> <mark>[Obs.]</mark>  <rj><au>Carew.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaven</ent><br/
<hw>Leav"en</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>levain</ets>, <ets>levein</ets>, F. <ets>levain</ets>, L. <ets>levamen</ets> alleviation, mitigation; but taken in the sense of, a raising, that which raises, fr. <ets>levare</ets> to raise. See <er>Lever</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>Any substance that produces, or is designed to produce, fermentation, as in dough or liquids; esp., a portion of fermenting dough, which, mixed with a larger quantity of dough, produces a general change in the mass, and renders it light; yeast; barm.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Anything which makes a general assimilating (especially a corrupting) change in the mass.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Beware of the <qex>leaven</qex> of the Pharisees, which is hypocrisy.</q> <rj><qau>Luke xii. 1.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaven</ent><br/
<hw>Leav"en</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leavened</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leavening</conjf> <pr>(?)</pr>.]</vmorph> <sn>1.</sn> <def>To make light by the action of leaven; to cause to ferment.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A little leaven <qex>leaveneth</qex> the whole lump.</q> <rj><qau>1 Cor. v. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To imbue; to infect; to vitiate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>With these and the like deceivable doctrines, he <qex>leavens</qex> also his prayer.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>leavened</ent><br/
<hw>leavened</hw> <pos>adj.</pos> <def>made light by aerating, as with yeast or baking powder.  Opposite of <ant>unleavened</ant>.</def> [Narrower terms: <stype>sourdough(prenominal) </stype>]<br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leavening</ent><br/
<hw>Leav"en*ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act of making light, or causing to ferment, by means of leaven.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which leavens or makes light.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leavenous</ent><br/
<hw>Leav"en*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Containing leaven.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaver</ent><br/
<hw>Leav"er</hw> <pr>(l<emac/v"<etil/r)</pr>, <pos>n.</pos> <def>One who leaves, or withdraws.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaves</ent><br/
<hw>Leaves</hw> <pr>(l<emac/vz)</pr>, <pos>n.</pos>, <def><pos>pl.</pos> of <er>Leaf</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leave-taking</ent><br/
<hw>Leave"-tak`ing</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Taking of leave; the act of departing politely; the giving of parting compliments.</def>  <rj><au>Shak.</au></rj><br/
<syn><b>Syn. --</b> farewell, leave, parting.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leaviness</ent><br/
<hw>Leav"i*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Fr. <er>Leaf</er>.]</ety> <def>Leafiness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leavings</ent><br/
<hw>Leav"ings</hw>, <pos>n. pl.</pos> <sn>1.</sn> <def>Things left; remnants; relics.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Refuse; offal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leavy</ent><br/
<hw>Leav"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Leafy.</def> <mark>[Obs.]</mark>  <rj><au>Chapman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lebban</ent><br/
<ent>Leban</ent><br/
<mhw>{ <hw>Leb"an</hw>, <hw>Leb"ban</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <def>Coagulated sour milk diluted with water; -- a common beverage among the Arabs.  Also, a fermented liquor made of the same.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecama</ent><br/
<hw>Le*ca"ma</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The hartbeest.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecanomancy</ent><br/
<hw>Le*can"o*man`cy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>leka`nh</grk> bowl or basin + <ets>-mancy</ets>.]</ety> <def>Divination practiced with water in a basin, by throwing three stones into it, and invoking the demon whose aid was sought.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecanoric</ent><br/
<hw>Lec`a*no"ric</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an organic acid which is obtained from several varieties of lichen (<gen>Lecanora</gen>, <gen>Roccella</gen>, etc.), as a white, crystalline substance, and is called also <altname>orsellic acid</altname>, <altname>diorsellinic acid</altname>, <altname>lecanorin</altname>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecanorin</ent><br/
<hw>Lec`a*no"rin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>See <er>Lecanoric</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lech</ent><br/
<hw>Lech</hw> <pr>(l<ecr/ch)</pr>, <pos>v. t.</pos> <ety>[F. <ets>l<eacute/cher</ets>. See <er>Lick</er>.]</ety> <def>To lick.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>lech</ent><br/
<hw>lech</hw> <pr>(l<ecr/ch)</pr>, <pos>n. & v. i.</pos> <def>Same as <er>letch</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lechanorales</ent><br/
<hw>Lechanorales</hw> <pos>n.</pos> <fld>(Biol.)</fld> <def>A category used in some classification systems for all lichens that produce apothecia.</def><br/
<syn><b>Syn. --</b> order <ord>Lechanorales</ord>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lechatelierite</ent><br/
<hw>lechatelierite</hw> <pos>n.</pos> <def>A naturally occurring colorless glass made of almost pure silica, and found in fulgurites, which are produced by lightning striking sand.</def><br/
<syn><b>Syn. --</b> quartz glass, vitreous silica, crystal.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Leche</ent><br/
<hw>Le*che"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <cref>water buck</cref>, under 3d <er>Buck</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecher</ent><br/
<hw>Lech"er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>lechur</ets>, <ets>lechour</ets>, OF. <ets>lecheor</ets>, <ets>lecheur</ets>, gormand, glutton, libertine, parasite, fr. <ets>lechier</ets> to lick, F. <ets>l<eacute/cher</ets>; of Teutonic origin. See <er>Lick</er>.]</ety> <def>A man given to lewdness; one addicted, in an excessive degree, to the indulgence of sexual desire, or to illicit sexual relations with women; also called <altname>letch</altname> and <altname>lech</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecher</ent><br/
<hw>Lech"er</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lechered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lechering</conjf>.]</vmorph> <def>To practice lewdness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecherer</ent><br/
<hw>Lech"er*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Lecher</er>, <pos>n.</pos></def>  <rj><au>Marston.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecherous</ent><br/
<hw>Lech"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Like a lecher; addicted to lewdness; excessively lustful; -- used mostly of men;</def> <specif>also,</specif> <def>lust-provoking.</def> <ldquo/A <xex>lecherous</xex> thing is wine.<rdquo/ <au>Chaucer.</au> -- <wordforms><wf>Lech"er*ous*ly</wf>, <pos>adv.</pos> -- <wf>Lech"er*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>lecherousness</ent><br/
<hw>lech"er*ous*ness</hw> <pos>n.</pos> <def>an inclination to excessive indulgence in sexual activity; habitually developing a strong sexual arousal.</def><br/
<syn><b>Syn. --</b> lust, lustfulness, itch.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lechery</ent><br/
<hw>Lech"er*y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>lecherie</ets>, OF. <ets>lecherie</ets>. See <er>Lecher</er>.]</ety> <sn>1.</sn> <def>Free indulgence of lust; excessive indulgence in sexual relations; -- used mostly of men.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Selfish pleasure; delight.</def> <mark>[Obs.]</mark>  <rj><au>Massinger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecithin</ent><br/
<hw>Lec"i*thin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <grk>le`kiqos</grk> the yolk of an egg.]</ety> <fld>(Physiol. Chem.)</fld> <def>A complex, nitrogenous phosphorized substance widely distributed through the animal body, and especially conspicuous in the brain and nerve tissue, in yolk of eggs, and in the white blood corpuscles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lectern</ent><br/
<hw>Lec"tern</hw> <pr>(l<ecr/k"t<ucr/rn)</pr>, <pos>n.</pos> <altsp>[Written also <asp>lecturn</asp> and <asp>lettern</asp>.]</altsp>  <ety>[LL. <ets>lectrinum</ets>, fr. <ets>lectrum</ets>; cf. L. <ets>legere</ets>, <ets>lectum</ets>, to read.]</ety> <sn>1.</sn> <def>A choir desk, or reading desk, in some churches, from which the lections, or Scripture lessons, are chanted or read.</def> <rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>Hence:</specif> <def>A reading desk, usually in the form of a stand with a slanted top that holds books or lecture notes at a height convenient for reading by a speaker who is standing.   A modern <ex>lectern</ex> may be of adjustable height, and be fitted with a light to illuminate the material on the desk, and sometimes a microphone or other electrical equipment for use of a speaker.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lectica</ent><br/
\'d8<hw>Lec*ti"ca</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lectic<ae/</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <fld>(Rom. Antiq.)</fld> <def>A kind of litter or portable couch.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lection</ent><br/
<hw>Lec"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>lectio</ets>, fr. <ets>legere</ets>, <ets>lectum</ets>, to read. See <er>lesson</er>, <er>Legend</er>.]</ety> <sn>1.</sn> <fld>(Eccl.)</fld> <def>A lesson or selection, especially of Scripture, read in divine service.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A reading; a variation in the text.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We ourselves are offended by the obtrusion of the new <qex>lections</qex> into the text.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lectionary</ent><br/
<hw>Lec"tion*a*ry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>-ries</plw> <pr>(#)</pr>.</plu> <ety>[LL. <ets>lectionarium</ets>, <ets>lectionarius</ets> : cf. F. <ets>lectionnaire</ets>.]</ety> <fld>(Eccl.)</fld> <def>A book, or a list, of lections, for reading in divine service.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 840 pr=VMG --></p>

<p><ent>Lector</ent><br/
<hw>Lec"tor</hw> <pr>(l<ecr/k"t<ocr/r)</pr>, <pos>n.</pos> <ety>[L. See <er>Lection</er>.]</ety> <fld>(Eccl.)</fld> <def>A reader of lections; formerly, a person designated to read lessons to the illiterate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lectual</ent><br/
<hw>Lec"tu*al</hw> <pr>(-t<usl/*<ait/l)</pr>, <pos>a.</pos> <ety>[LL. <ets>lectualis</ets>, fr. L. <ets>lectus</ets> bed.]</ety> <fld>(Med.)</fld> <def>Confining to the bed; <as>as, a <ex>lectual</ex> disease</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecture</ent><br/
<hw>Lec"ture</hw> <pr>(-t<usl/r; 135)</pr>, <pos>n.</pos> <ety>[F. <ets>lecture</ets>, LL. <ets>lectura</ets>, fr. L. <ets>legere</ets>, <ets>lectum</ets>, to read. See <er>Legend</er>.]</ety> <sn>1.</sn> <def>The act of reading; <as>as, the <ex>lecture</ex> of Holy Scripture</as>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A discourse on any subject; especially, a formal or methodical discourse, intended for instruction; sometimes, a familiar discourse, in contrast with a sermon.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A reprimand or formal reproof from one having authority.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Eng. Universities)</fld> <def>A rehearsal of a lesson.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecture</ent><br/
<hw>Lec"ture</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lectured</conjf> <pr>(-t<usl/rd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lecturing</conjf>.]</vmorph> <sn>1.</sn> <def>To read or deliver a lecture to.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To reprove formally and with authority.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecture</ent><br/
<hw>Lec"ture</hw>, <pos>v. i.</pos> <def>To deliver a lecture or lectures.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecturer</ent><br/
<hw>Lec"tur*er</hw> <pr>(-<etil/r)</pr>, <pos>n.</pos> <def>One who lectures; an assistant preacher.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lectureship</ent><br/
<hw>Lec"ture*ship</hw>, <pos>n.</pos> <def>The office of a lecturer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecturn</ent><br/
<hw>Lec"turn</hw> <pr>(l<ecr/k"t<ucr/rn)</pr>, <pos>n.</pos> <ety>[LL. <ets>lectrinum</ets>, fr. <ets>lectrum</ets>; cf. L. <ets>legere</ets>, <ets>lectum</ets>, to read.]</ety> <def>Same as <er>lectern</er>.</def> <altsp>[Written also <asp>lectern</asp> and <asp>lettern</asp>.]</altsp> <rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lecythis</ent><br/
\'d8<hw>Lec"y*this</hw> <pr>(l<ecr/s"<icr/*th<icr/s)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. 3 an oil flask.]</ety> <fld>(Bot.)</fld> <def>A genus of gigantic trees, chiefly Brazilian, of the order <ord>Myrtace<ae/</ord>, having woody capsules opening by an apical lid. <spn>Lecythis Zabucajo</spn> yields the delicious sapucaia nuts. <spn>Lecythis Ollaria</spn> produces the monkey-pots, its capsules. Its bark separates into thin sheets, like paper, used by the natives for cigarette wrappers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Led</ent><br/
<hw>Led</hw> <pr>(l<ecr/d)</pr>, <pos>imp. & p. p.</pos> <def>of <er>Lead</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Led captain</b></col>. <cd>An obsequious follower or attendant.</cd> <mark>[Obs.]</mark> <au>Swift.</au> -- <col><b>Led horse</b></col>, <cd>a sumpter horse, or a spare horse, that is led along.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ledden</ent><br/
<ent>Leden</ent><br/
<mhw>{ <hw>Led"en</hw> <pr>(l<ecr/d"'n)</pr>, <hw>Led"den</hw> <pr>(-d'n)</pr> }</mhw> <pos>n.</pos> <ety>[AS. <ets>l<emac/den</ets>, <ets>l<ymac/den</ets>, language, speech. Cf. <er>Leod</er>.]</ety> <def>Language; speech; voice; cry.</def> <mark>[Obs.]</mark> <rj><au>Chaucer. Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ledge</ent><br/
<hw>Ledge</hw> <pr>(l<ecr/j)</pr>, <pos>n.</pos> <ety>[Akin to AS. <ets>licgan</ets> to lie, Icel. <ets>liggja</ets>; cf. Icel. <ets>l<oum/gg</ets> the ledge or rim at the bottom of a cask. See <er>Lie</er> to be prostrate.]</ety> <altsp>[Formerly written <asp>lidge</asp>.]</altsp> <sn>1.</sn> <def>A shelf on which articles may be laid; also, that which resembles such a shelf in form or use, as a projecting ridge or part, or a molding or edge in joinery.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A shelf, ridge, or reef, of rocks.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A layer or stratum.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The lowest <qex>ledge</qex> or row should be of stone.</q> <rj><qau>Sir H. Wotton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mining)</fld> <def>A lode; a limited mass of rock bearing valuable mineral.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Shipbuilding)</fld> <def>A piece of timber to support the deck, placed athwartship between beams.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ledgement</ent><br/
<hw>Ledge"ment</hw> <pr>(l<ecr/j"m<eit/nt)</pr>, <pos>n.</pos> <def>See <er>Ledgment</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ledger</ent><br/
<hw>Ledg"er</hw><pr>(l<ecr/j"<etil/r)</pr>, <pos>n.</pos> <ety>[Akin to D. <ets>legger</ets> layer, daybook (fr. <ets>leggen</ets> to lay, <ets>liggen</ets> to lie), E. <ets>ledge</ets>, <ets>lie</ets>. See <er>Lie</er> to be prostrate.]</ety> <sn>1.</sn> <def>A book in which a summary of accounts is laid up or preserved; the final book of record in business transactions, in which all debits and credits from the journal, etc., are placed under appropriate heads.</def> <altsp>[Written also <asp>leger</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>A large flat stone, esp. one laid over a tomb.</def> <au>Oxf. Gloss.</au> <sd>(b)</sd> <def>A horizontal piece of timber secured to the uprights and supporting floor timbers, a staircase, scaffolding, or the like. It differs from an <xex>intertie</xex> in being intended to carry weight.</def> <altsp>[Written also <asp>ligger</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ledger bait</b></col>, <cd>fishing bait attached to a floating line fastened to the bank of a stream, pond, etc.</cd> <au>Walton.</au> <au>J. H. Walsh.</au> -- <col><b>Ledger blade</b></col>,<cd>a stationary shearing blade in a machine for shearing the nap of cloth.</cd> -- <col><b>Ledger line</b></col>. <cd>See <cref>Leger line</cref>, under 3d <er>Leger</er>, <pos>a.</pos></cd> -- <col><b>Ledger wall</b></col> <fld>(Mining)</fld>, <cd>the wall under a vein; the foot wall.</cd> <au>Raymond.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ledgment</ent><br/
<hw>Ledg"ment</hw> <pr>(-m<eit/nt)</pr>, <pos>n.</pos> <fld>(Arch.)</fld> <sd>(a)</sd> <def>A string-course or horizontal suit of moldings, such as the base moldings of a building.</def> <au>Oxf. Gloss.</au> <sd>(b)</sd> <def> The development of the surface of a body on a plane, so that the dimensions of the different sides may be easily ascertained.</def> <au>Gwilt.</au> <altsp>[Written also <asp>ledgement</asp>, <asp>legement</asp>, and <asp>ligement</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ledgy</ent><br/
<hw>Ledg"y</hw> <pr>(-<ycr/)</pr>, <pos>a.</pos> <def>Abounding in ledges; consisting of a ledge or reef; <as>as, a <ex>ledgy</ex> island</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ledum</ent><br/
<hw>Ledum</hw> <pos>prop. n.</pos> <def>A genus of evergreen shrubs of the north temperate regions.</def><br/
<syn><b>Syn. --</b> genus <gen>Ledum</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lee</ent><br/
<hw>Lee</hw> <pr>(l<emac/)</pr>, <pos>v. i.</pos>, <def>To lie; to speak falsely.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lee</ent><br/
<hw>Lee</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lees</plw> <pr>(l<emac/z)</pr>.</plu> <ety>[F. <ets>lie</ets>, perh. fr. L. <ets>levare</ets> to lift up, raise. Cf. <er>Lever</er>.]</ety> <def>That which settles at the bottom, as of a cask of liquor (esp. wine); sediment; dregs; -- used now only in the plural.</def> <mark>[Lees occurs also as a form of the singular.]</mark> <ldquo/The <xex>lees</xex> of wine.<rdquo/ <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A thousand demons lurk within the <qex>lee</qex>.</q> <rj><qau>Young.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The wine of life is drawn, and the mere <qex>lees</qex><br/
Is left this vault to brag of.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lee</ent><br/
<hw>Lee</hw>, <pos>n.</pos> <ety>[OE. <ets>lee</ets> shelter, Icel. <ets>hl<emac/</ets>, akin to AS. <ets>hle<oacute/</ets>, <ets>hle<oacute/w</ets>, shelter, protection, OS. <ets>hl<egrave/o</ets>, D. <ets>lij</ets> lee, Sw. <ets>l<aum/</ets>, Dan. <ets>l<ae/</ets>.]</ety> <sn>1.</sn> <def>A sheltered place; esp., a place protected from the wind by some object; the side sheltered from the wind; shelter; protection; <as>as, the <ex>lee</ex> of a mountain, an island, or a ship</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We lurked under <qex>lee</qex>.</q> <rj><qau>Morte d'Arthure.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Desiring me to take shelter in his <qex>lee</qex>.</q> <rj><qau>Tyndall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>That part of the hemisphere, as one stands on shipboard, toward which the wind blows. See <er>Lee</er>, <pos>a.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>By the lee</b></col>, <col><b>To bring by the lee</b></col></mcol>. <cd>See under <er>By</er>, and <er>Bring</er>.</cd> -- <col><b>Under the lee of</b></col>, <cd>on that side which is sheltered from the wind; <as>as, to be <ex>under the lee of</ex> a ship</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lee</ent><br/
<hw>Lee</hw>, <pos>a.</pos> <fld>(Naut.)</fld> <def>Of or pertaining to the part or side opposite to that against which the wind blows; -- opposed to <contr>weather</contr>; <as>as, the <ex>lee</ex> side or <ex>lee</ex> rail of a vessel</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lee gauge</b></col>. <cd>See <er>Gauge</er>, <pos>n.</pos></cd> <fld>(Naut.)</fld> -- <col><b>Lee shore</b></col>, <cd>the shore on the lee side of a vessel.</cd> -- <col><b>Lee tide</b></col>, <cd>a tide running in the same direction that the wind blows.</cd> -- <col><b>On the lee beam</b></col>, <cd>directly to the leeward; in a line at right angles to the length of the vessel and to the leeward.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liangle</ent><br/
<ent>Leeangle</ent><br/
<mhw>{ <hw>Lee"an`gle</hw>, <hw>Li"an`gle</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From native name.]</ety> <def>A heavy weapon of the Australian aborigines with a sharp-pointed end, about nine inches in length, projecting at right angles from the main part.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Leeboard</ent><br/
<hw>Lee"board`</hw> <pr>(l<emac/"b<omac/rd`)</pr>, <pos>n.</pos> <def>A board, or frame of planks, lowered over the side of a vessel to lessen her leeway when closehauled, by giving her greater draught.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leech</ent><br/
<hw>Leech</hw> <pr>(l<emac/ch)</pr>, <pos>n.</pos> <def>See 2d <er>Leach</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leech</ent><br/
<hw>Leech</hw>, <pos>v. t.</pos> <def>See <er>Leach</er>, <pos>v. t.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leech</ent><br/
<hw>Leech</hw>, <pos>n.</pos> <ety>[Cf. LG. <ets>leik</ets>, Icel. <ets>l<imac/k</ets>, Sw. <ets>lik</ets> boltrope, st<aring/ende <ets>liken</ets> the leeches.]</ety> <fld>(Naut.)</fld> <def>The border or edge at the side of a sail.</def> <altsp>[Written also <asp>leach</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leech line</b></col>, <cd>a line attached to the leech ropes of sails, passing up through blocks on the yards, to haul the leeches by.</cd> <au>Totten.</au> -- <col><b>Leech rope</b></col>, <cd>that part of the boltrope to which the side of a sail is sewed.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leech</ent><br/
<hw>Leech</hw>, <pos>n.</pos> <ety>[OE. <ets>leche</ets>, <ets>l<ae/che</ets>, physician, AS. <ets>l<aemac/ce</ets>; akin to Fries. <ets>l<emac/tza</ets>, OHG. <ets>l<amac/hh<imac/</ets>, <ets>Icel</ets>. <ets>l<ae/knari</ets>, Sw. <ets>l<aum/kare</ets>, Dan. <ets>l<ae/ge</ets>, Goth. <ets>l<emac/keis</ets>, AS. <ets>l<amac/cnian</ets> to heal, Sw. <ets>l<aum/ka</ets>, Dan. <ets>l<ae/ge</ets>, Icel. <ets>l<ae/kna</ets>, Goth. <ets>l<emac/kin<omac/n</ets>.]</ety> <sn>1.</sn> <def>A physician or surgeon; a professor of the art of healing.</def> <altsp>[Written also <asp>leach</asp>.]</altsp> <mark>[Archaic]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Leech</qex>, heal thyself.</q> <rj><qau>Wyclif (Luke iv. 23).</qau></rj></p>
 
<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Any one of numerous genera and species of annulose worms, belonging to the order <ord>Hirudinea</ord>, or Bdelloidea, esp. those species <-- formerly! --> used in medicine, as <spn>Hirudo medicinalis</spn> of Europe, and allied species.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the mouth of bloodsucking leeches are three convergent, serrated jaws, moved by strong muscles. By the motion of these jaws a stellate incision is made in the skin, through which the leech sucks blood till it is gorged, and then drops off. The stomach has large pouches on each side to hold the blood. The common large bloodsucking leech of America (<spn>Macrobdella decora</spn>) is dark olive above, and red below, with black spots. Many kinds of leeches are parasitic on fishes; others feed upon worms and mollusks, and have no jaws for drawing blood. See <er>Bdelloidea</er>. <er>Hirudinea</er>, and <er>Clepsine</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Surg.)</fld> <def>A glass tube of peculiar construction, adapted for drawing blood from a scarified part by means of a vacuum.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Horse leech</b></col>, <cd>a less powerful European leech (<spn>H<ae/mopis vorax</spn>), commonly attacking the membrane that lines the inside of the mouth and nostrils of animals that drink at pools where it lives.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leech</ent><br/
<hw>Leech</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leeched</conjf> <pr>(l<emac/cht)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leeching</conjf>.]</vmorph> <sn>1.</sn> <def>To treat as a surgeon; to doctor; <as>as, to <ex>leech</ex> wounds</as>.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To bleed by the use of leeches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leechcraft</ent><br/
<hw>Leech"craft`</hw> <pr>(-kr<adot/ft`)</pr>, <pos>n.</pos> <def>The art of healing; skill of a physician.</def> <mark>[Archaic]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leede</ent><br/
<ent>Leed</ent><br/
<mhw>{ <hw>Leed</hw>, <hw>Leede</hw> <pr>(l<emac/d)</pr> }</mhw>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety> <def>A caldron; a copper kettle.</def> <mark>[Obs.]</mark> <ldquo/A furnace of a <xex>leed</xex>.<rdquo/ <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leef</ent><br/
<hw>Leef</hw> <pr>(l<emac/f)</pr>, <pos>a. & adv.</pos> <def>See <er>Lief</er>.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leek</ent><br/
<hw>Leek</hw> <pr>(l<emac/k)</pr>, <pos>n.</pos> <ety>[AS. <ets>le<aacute/c</ets>; akin to D. <ets>look</ets>, G. <ets>lauch</ets>, OHG. <ets>louh</ets>, Icel. <ets>laukr</ets>, Sw. <ets>l<oum/k</ets>, Dan <ets>l<oum/g</ets>. Cf. <er>Garlic</er>.]</ety> <fld>(Bot.)</fld> <def>A plant of the genus <gen>Allium</gen> (<spn>Allium Porrum</spn>), having broadly linear succulent leaves rising from a loose oblong cylindrical bulb. The flavor is stronger than that of the common onion.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Wild leek</b></col> , <cd>in America, a plant (<spn>Allium tricoccum</spn>) with a cluster of ovoid bulbs and large oblong elliptical leaves.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leeme</ent><br/
<hw>Leeme</hw> <pr>(l<emac/m)</pr>, <pos>v. & n.</pos> <def>See <er>Leme</er>.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leep</ent><br/
<hw>Leep</hw> <pr>(l<emac/p)</pr>, <mark>obs.</mark> <pos>strong imp.</pos> <mord>of <er>Leap</er></mord>. <def>Leaped.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leer</ent><br/
<hw>Leer</hw> <pr>(l<emac/r)</pr>, <pos>v. t.</pos> <def>To learn.</def> <mark>[Obs.]</mark> <see>See <er>Lere</er>, to learn.</see><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leer</ent><br/
<hw>Leer</hw>, <pos>a.</pos> <ety>[OE. <ets>lere</ets>; akin to G. <ets>leer</ets>, OHG. & OS. <ets>l<amac/ri</ets>.]</ety> <mark>[Obs. or Prov. Eng.]</mark> <def>Empty; destitute; wanting</def>; as: <sd>(a)</sd> <def>Empty of contents.</def> <ldquo/A <xex>leer</xex> stomach.<rdquo/ <au>Gifford.</au> <sd>(b)</sd> <def>Destitute of a rider; and hence, led, not ridden; <as>as, a <ex>leer</ex> horse</as>.</def> <au>B. Jonson.</au> <sd>(c)</sd> <def>Wanting sense or seriousness; trifling; trivolous; <as>as, <ex>leer</ex> words</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leer</ent><br/
<hw>Leer</hw>, <pos>n.</pos> <def>An oven in which glassware is annealed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leer</ent><br/
<hw>Leer</hw>, <pos>n.</pos> <ety>[OE. <ets>lere</ets> cheek, face, look, AS. <ets>hle<oacute/r</ets> cheek, face; akin to OS. <ets>hlear</ets>, <ets>hlior</ets>, OD. <ets>lier</ets>, Icel. <ets>hl<ymac/r</ets>.]</ety> <sn>1.</sn> <def>The cheek.</def> <mark>[Obs.]</mark> <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Complexion; aspect; appearance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>A Rosalind of a better <qex>leer</qex> than you.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A distorted expression of the face, or an indirect glance of the eye, conveying a sinister or immodest suggestion.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>With jealous <qex>leer</qex> malign<br/
Eyed them askance.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She gives the <qex>leer</qex> of invitation.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Damn with faint praise, assent with civil <qex>leer</qex>.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leer</ent><br/
<hw>Leer</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leered</conjf> <pr>(l<emac/rd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Leering</conjf>.]</vmorph> <def>To look with a leer; to look askance with a suggestive expression, as of hatred, contempt, lust, etc.; to cast a sidelong lustful or malign look.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will <qex>leer</qex>upon him as a' comes by.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The priest, above his book,<br/
<qex>Leering</qex> at his neighbor's wife.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leer</ent><br/
<hw>Leer</hw>, <pos>v. t.</pos> <def>To entice with a leer, or leers; <as>as, to <ex>leer</ex> a man to ruin</as>.</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leere</ent><br/
<hw>Leere</hw> <pr>(l<emac/r)</pr>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety> <def>Tape or braid; an ornament.</def> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leere side</b></col>, <cd>the left side, as that on which a leere or ornament was worn.</cd> <rj><au>B. Jonson.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leeringly</ent><br/
<hw>Leer"ing*ly</hw>, <pos>adv.</pos> <def>In a leering manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lees</ent><br/
<hw>Lees</hw> <pr>(l<emac/z)</pr>, <pos>n. pl.</pos> <def>Dregs. See 2d <er>Lee</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lees</ent><br/
<hw>Lees</hw> <pr>(l<emac/s)</pr>, <pos>n.</pos> <def>A leash.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leese</ent><br/
<hw>Leese</hw> <pr>(l<emac/z)</pr>, <pos>v. t.</pos> <ety>[See <er>Lose</er>.]</ety> <def>To lose.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>They would rather <qex>leese</qex> their friend than their jest.</q> <rj><qau>Lord Burleigh.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leese</ent><br/
<hw>Leese</hw>, <pos>v. t.</pos> <ety>[Cf. F. <ets>l<eacute/ser</ets>, L. <ets>laesus</ets>, p. p. of <ets>laedere</ets>.]</ety> <def>To hurt.</def> <mark>[Obs.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leet</ent><br/
<hw>Leet</hw> <pr>(l<emac/t)</pr>, <pos>obs. imp.</pos> <def>of <er>Let</er>, to allow.</def> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leet</ent><br/
<hw>Leet</hw>, <pos>n.</pos> <ety>[Cf. AS. <ets>hl<emac/t</ets> share, lot.]</ety> <def>A portion; a list, esp. a list of candidates for an office.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leet</ent><br/
<hw>Leet</hw>, <pos>n.</pos> <ety>[LL. <ets>leta</ets>. Cf. F. <ets>lit de justice</ets> a solemn sitting of the king in Parliament, L. <ets>lis</ets>, <ets>litis</ets>, a lawsuit, It., Sp., & Pg. <ets>lite</ets>.]</ety> <fld>(Eng. Hist.)</fld> <def>A court-leet; the district within the jurisdiction of a court-leet; the day on which a court-leet is held.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The original intent of the court-leet was to view the frankpledges or freemen within the liberty; hence called <xex>the view of frankpledge</xex>. Latterly it has fallen into almost entire disuse.</note> <rj><au>Burrill. Warren's Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leet ale</b></col>, <cd>a feast or merrymaking in time of leet.</cd> <mark>[Obs.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leet</ent><br/
<hw>Leet</hw>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety> <fld>(Zool.)</fld> <def>The European pollock.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leetman</ent><br/
<hw>Leet"man</hw> <pr>(-m<ait/n)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Leetmen</plw> <pr>(-m<eit/n)</pr>.</plu> <def>One subject to the jurisdiction of a court-leet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leeward</ent><br/
<hw>Lee"ward</hw> <pr>(l<emac/"w<etil/rd <or/ l<umac/"<etil/rd)</pr>, <pos>a.</pos> <fld>(Naut.)</fld> <def>Pertaining to, or in the direction of, the part or side toward which the wind blows; -- opposed to <ant>windward</ant>; <as>as, a <ex>leeward</ex> berth; a <ex>leeward</ex> ship.</as></def> -- <def2><pos>n.</pos> <def>The lee side; the lee.</def></def2> -- <def2><pos>adv.</pos> <def>Toward the lee.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leeway</ent><br/
<hw>Lee"way`</hw> <pr>(l<emac/"w<amac/`)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> <def>The lateral movement of a ship to the leeward of her course; drift.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Left</ent><br/
<hw>Left</hw> <pr>(l<ecr/ft)</pr>, <pos>imp. & p. p.</pos> <def>of <er>Leave</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Left</ent><br/
<hw>Left</hw>, <pos>a.</pos> <ety>[OE. <ets>left</ets>, <ets>lift</ets>, <ets>luft</ets>; akin to Fries. <ets>leeft</ets>, OD. <ets>lucht</ets>, <ets>luft</ets>; cf. AS. <ets>left</ets> (equiv. to L. <ets>inanis</ets>), <ets>lyft<amac/dl</ets> palsy; or cf. AS. <ets>l<emac/f</ets> weak.]</ety> <sn>1.</sn> <def>Of or pertaining to that side of the body in man on which the muscular action of the limbs is usually weaker than on the other side; -- opposed to <ant>right</ant>, when used in reference to a part of the body; <as>as, the <ex>left</ex> hand, or arm; the <ex>left</ex> ear</as>. Also said of the corresponding side of the lower animals.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Situated so that the left side of the body is toward it; <as>as, the <ex>left</ex> side of a deliberative meeting is that to the left of the presiding officer; the <ex>left</ex> wing of an army is that to the left of the center to one facing an enemy</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Left bank of a river</b></col>, <cd>that which is on the <xex>left</xex> hand of a person whose face is turned downstream.</cd> -- <col><b>Left bower</b></col>. <cd>See under 2d <er>Bower</er>.</cd> -- <col><b>Left center</b></col>, <cd>the members whose sympathies are, in the main, with the members of the Left, but who do not favor extreme courses, and on occasions vote with the government. They sit between the Center and the extreme Left.</cd> -- <mcol><col><b>Over the left shoulder</b></col>, <it>or</it> <col><b>Over the left</b></col></mcol>, <cd>an old but still current colloquialism, or slang expression, used as an aside to indicate insincerity, negation, or disbelief; <as>as, he said it, and it is true, -- <ex>over the left</ex></as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Left</ent><br/
<hw>Left</hw>, <pos>n.</pos> <sn>1.</sn> <def>That part of surrounding space toward which the left side of one's body is turned; <as>as, the house is on the <ex>left</ex> when you face North</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Put that rose a little more to the <qex>left</qex>.</q> <rj><qau>Ld. Lytton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Those members of a legislative assembly (as in France) who are in the opposition; the advanced republicans and extreme radicals. They have their seats at the left-hand side of the presiding officer. See <er>Center</er>, and <er>Right</er>.</def><-- now used of any group advocating a leftist policy -- which is variously interpeted, as meaning "radical", "liberal", "reformist", "anti-establishment" "advocating change in the name of greater freedom or well-being of the common man[MW10]" -- opposed to rightist, and in the "liberal" interpretation, opposed to "conservative". --><br/
[<source>1913 Webster</source>]</p>

<p><ent>left brain</ent><br/
<hw>left" brain`</hw>, <pos>n.</pos> <def>The left cerebral hemisphere of the brain; in humans, it controls motor activity on the right side of the body, and in most people is the primary location for control of language, logic, and mathematical thought.</def><br/
[<source>PJC</source>]</p>

<p><ent>left-brain</ent><br/
<hw>left"-brain`</hw>, <pos>a.</pos> <def>Of or pertaining to the left cerebral hemisphere of the brain.</def><br/
[<source>PJC</source>]</p>

<p><ent>left-brained</ent><br/
<hw>left"-brained`</hw>, <pos>a.</pos> <def>Exhibiting intellectual or personality characteristics suggesting dominance of linguistic or logical modes of thought, which are usually controlled by the left cerebral hemisphere; <as>as, <ex>left-brained</ex> pedants unable to appreciate music</as>; also referred to as <altname>linear</altname>.  See <er>linear</er>{3}.  Contrasted with <contr>right-brained</contr>.</def><br/
[<source>PJC</source>]</p>

<p><ent>leftfield</ent><br/
<ent>left field</ent><br/
<mhw><hw>left` field"</hw>, <hw>left`field"</hw></mhw> <pos>n.</pos> <fld>(Baseball)</fld>  <def>the part of the outfield on the catcher's or batter's left.</def><br/
<syn><b>Syn. --</b> left.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Left-hand</ent><br/
<hw>Left"-hand`</hw> <pr>(l<ecr/ft"h<acr/nd`)</pr>, <pos>a.</pos> <def>Situated on the left; nearer the left hand than the right; <as>as, the <ex>left-hand</ex> side; the <ex>left-hand</ex> road.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Left-hand rope</b></col>, <cd>rope laid up and twisted over from right to left, or against the sun; -- called also <altname>water-laid rope</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Left-handed</ent><br/
<hw>Left"-hand`ed</hw>, <pos>a.</pos> <sn>1.</sn> <def>Having the left hand or arm stronger and more dexterous than the right; using the left hand and arm with more dexterity than the right.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Clumsy; awkward; unlucky; insincere; sinister; malicious; <as>as, a <ex>left-handed</ex> compliment</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The commendations of this people are not always <qex>left-handed</qex> and detractive.</q> <rj><qau>Landor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Having a direction contrary to that of the hands of a watch when seen in front; -- said of a twist, a rotary motion, etc., looked at from a given direction.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Left-handed marriage</b></col>, <cd>a morganatic marriage. See <er>Morganatic</er>.</cd> -- <col><b>Left-handed screw</b></col>, <cd>a screw constructed to advance away from the observer, when turned, as in a nut, with a left-handed rotation. An ordinary wood screw is right-handed.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Left-handiness</ent><br/
<ent>Left-handedness</ent><br/
<mhw>{ <hw>Left"-hand`ed*ness</hw>, <hw>Left"-hand`i*ness</hw> <pr>(-<icr/*n<ecr/s)</pr>, }</mhw> <pos>n.</pos> <def>The state or quality of being left-handed; awkwardness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>An awkward address, ungraceful attitudes and actions, and a certain <qex>left-handiness</qex> (if I may use the expression) proclaim low education.</q> <rj><qau>Chesterfield.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>left-hander</ent><br/
<ent>lefthander</ent><br/
<mhw><hw>left`hand"er</hw>, <hw>left`-hand"er</hw></mhw> <pos>n.</pos>  <def>a person who uses the left hand with greater skill than the right; a left-handed{1} person.</def><br/
<syn><b>Syn. --</b> lefty, southpaw.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leftish</ent><br/
<hw>leftish</hw> <pos>adj.</pos> <def>Inclined toward the political left.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leftist</ent><br/
<hw>leftist</hw> <pos>adj.</pos> <def>same as <er>left-wing</er>.</def><br/
<syn><b>Syn. --</b> left-of-center, left-wing.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leftist</ent><br/
<hw>leftist</hw> <pos>n.</pos> <def>a person who belongs to the political left.</def><br/
<syn><b>Syn. --</b> socialist, collectivist, left-winger.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>left-of-center</ent><br/
<hw>left-of-center</hw> <pos>adj.</pos>  <def>same as <er>left-wing</er>.</def><br/
<syn><b>Syn. --</b> leftist, left-wing.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Left-off</ent><br/
<hw>Left"-off`</hw> <pr>(-<ocr/f`; 115)</pr>, <pos>a.</pos> <def>Laid aside; cast-off.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leftover</ent><br/
<hw>leftover</hw> <pos>adj.</pos> <sn>1.</sn> <def>not used up; remaining after use of part; <as>as, unusable <ex>leftover</ex> auto parts</as>.</def><br/
<syn><b>Syn. --</b> left over(predicate), left(predicate), odd, remaining, unexpended.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <specif>Specifically:</specif> <def>remaining from a previous meal; -- of food; <as>as, <ex>leftover</ex> food served at a later meal</as>.</def><br/
<syn><b>Syn. --</b> cooked-over, warmed-over, reheated.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leftover</ent><br/
<hw>leftover</hw> <pos>n.</pos> <def>An unused part or portion; -- used especially of food remaining uneaten from a previous meal; <as>as, to have <ex>leftovers</ex> for dinner</as>.</def><br/
<syn><b>Syn. --</b> remnant.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>left-slanting</ent><br/
<hw>left-slanting</hw> <pos>adj.</pos> <def>slanting toward the left; -- of handwriting.</def> <note>Such handwriting is usually found in left-handed writers</note><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leftward</ent><br/
<hw>Left"ward</hw> <pr>(-w<etil/rd)</pr>, <pos>adv.</pos> <def>Toward or on the left side.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Rightward and <qex>leftward</qex> rise the rocks.</q> <rj><qau>Southey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>left-wing</ent><br/
<hw>left-wing</hw> <pos>a.</pos>  <sn>1.</sn> <def>Of or pertaining to the political left or its ideology.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>Believing in or supporting tenets of the political left.</def><br/
<syn><b>Syn. --</b> leftist, left-of-center.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>left wing</ent><br/
<hw>left wing</hw> <pos>n.</pos> <def>Those trying to reform the established order, particularly in political matters, to enhance the condition of the common people; -- sometimes applied to those advocating overthrow of an existing government by radical means.</def><br/
<syn><b>Syn. --</b> left, left wing, leftists, political left.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>left-winger</ent><br/
<hw>left-winger</hw> <pos>n.</pos> <sn>1.</sn> <def>a person who belongs to the political left.</def><br/
<syn><b>Syn. --</b> socialist, collectivist, leftist.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lefty</ent><br/
<hw>lefty</hw> <pos>n.</pos> <sn>1.</sn> <def>a person who uses the left hand with greater skill than the right; a left-handed person.</def><br/
<syn><b>Syn. --</b> lefthander, southpaw.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>a baseball pitcher who throws the ball with the left hand.</def><br/
<syn><b>Syn. --</b> left-handed pitcher, left-hander, southpaw.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leful</ent><br/
<hw>Le"ful</hw> <pr>(l<emac/"f<usdot/l)</pr>, <pos>a.</pos> <def>See <er>Leveful</er>.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leg</ent><br/
<hw>Leg</hw> <pr>(l<ecr/g)</pr>, <pos>n.</pos> <ety>[Icel. <ets>leggr</ets>; akin to Dan. <ets>l<ae/g</ets> calf of the leg, Sw. <ets>l<aum/gg</ets>.]</ety> <sn>1.</sn> <def>A limb or member of an animal used for supporting the body, and in running, climbing, and swimming; esp., that part of the limb between the knee and foot.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which resembles a leg in form or use; especially, any long and slender support on which any object rests; <as>as, the <ex>leg</ex> of a table; the <ex>leg</ex> of a pair of compasses or dividers.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The part of any article of clothing which covers the leg; <as>as, the <ex>leg</ex> of a stocking or of a pair of trousers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A bow, esp. in the phrase <xex>to make a leg</xex>; probably from drawing the leg backward in bowing.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He that will give a cap and make a <qex>leg</qex> in thanks for a favor he never received.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A disreputable sporting character; a blackleg.</def> <mark>[Slang, Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Naut.)</fld> <def>The course and distance made by a vessel on one tack or between tacks.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Steam Boiler)</fld> <def>An extension of the boiler downward, in the form of a narrow space between vertical plates, sometimes nearly surrounding the furnace and ash pit, and serving to support the boiler; -- called also <altname>water leg</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Grain Elevator)</fld> <def>The case containing the lower part of the belt which carries the buckets.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Cricket)</fld> <def>A fielder whose position is on the outside, a little in rear of the batter.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Math.)</fld> <def>Either side of a triangle distinguished from the base or, in a right triangle, from the hypotenuse; also, an indefinitely extending branch of a curve, as of a hyperbola.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>11.</sn>  <fld>(Telephony)</fld> <def>A branch or lateral circuit connecting an instrument with the main line.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>12.</sn>  <fld>(Elec.)</fld> <def>A branch circuit; one phase of a polyphase system.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>A good leg</b></col> <fld>(Naut.)</fld>, <cd>a course sailed on a tack which is near the desired course.</cd> -- <col><b>Leg bail</b></col>, <cd>escape from custody by flight.</cd> <mark>[Slang]</mark> -- <col><b>Legs of an hyperbola</b></col> (or other curve) <fld>(Geom.)</fld>, <cd>the branches of the curve which extend outward indefinitely.</cd> -- <col><b>Legs of a triangle</b></col>, <cd>the sides of a triangle; -- a name seldom used unless one of the sides is first distinguished by some appropriate term; <as>as, the hypotenuse and two <ex>legs</ex> of a right-angled triangle</as>.</cd> <col><b>On one's legs</b></col>, <cd>standing to speak.</cd> -- <col><b>On one's last legs</b></col>. <cd>See under <er>Last</er>.</cd> -- <col><b>To have legs</b></col> <fld>(Naut.)</fld>, <cd>to have speed.</cd><-- also, to have endurance, to continue longer than usual. --> -- <col><b>To stand on one's own legs</b></col>, <cd>to support one's self; to be independent.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 841 pr=VMG --></p>

<p><ent>Leg</ent><br/
<hw>Leg</hw> <pr>(l<ecr/g)</pr>, <pos>v. t.</pos> <def>To use as a leg, with <xex>it</xex> as object</def>: <sd>(a)</sd> <def>To bow.</def> <mark>[Obs.]</mark> <sd>(b)</sd> <def>To run.</def> <mark>[Low]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legacy</ent><br/
<hw>Leg"a*cy</hw> <pr>(l<ecr/g"<adot/*s<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Legacies</plw> <pr>(-s<icr/z)</pr>.</plu> <ety>[L. (assumed) <ets>legatia</ets>, for <ets>legatum</ets>, from <ets>legare</ets> to appoint by last will, to bequeath as a legacy, to depute: cf. OF. <ets>legat</ets> legacy. See <er>Legate</er>.]</ety> <sn>1.</sn> <def>A gift of property by will, esp. of money or personal property; a bequest. Also Fig.; <as>as, a <ex>legacy</ex> of dishonor or disease</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A business with which one is intrusted by another; a commission; -- obsolete, except in the phrases <xex>last legacy</xex>, <xex>dying legacy</xex>, and the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>My <qex>legacy</qex> and message wherefore I am sent into the world.</q> <rj><qau>Tyndale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He came and told his <qex>legacy</qex>.</q> <rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Legacy duty</b></col>, <cd>a tax paid to government on legacies.</cd> <au>Wharton.</au> -- <col><b>Legacy hunter</b></col>, <cd>one who flatters and courts any one for the sake of a legacy.</cd></cs><-- related to gold-digger (latter for any riches, not just a legacy) --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legal</ent><br/
<hw>Le"gal</hw> <pr>(l<emac/"g<ait/l)</pr>, <pos>a.</pos> <ety>[L. <ets>legalis</ets>, fr. <ets>lex</ets>, <ets>legis</ets>, law; prob. orig., that which lies or is fixed (cf. L. <ets>lectus</ets> bed), and if so akin to E. <ets>lie</ets>, <ets>law</ets>: cf. F. <ets>l<eacute/gal</ets>. Cf. <er>Lie</er> to be prostrate, <er>Loyal</er>, <er>Leal</er>.]</ety> <sn>1.</sn> <def>Created by, permitted by, in conformity with, or relating to, law; <as>as, a <ex>legal</ex> obligation; a <ex>legal</ex> standard or test; a <ex>legal</ex> procedure; a <ex>legal</ex> claim; a <ex>legal</ex> trade; anything is <ex>legal</ex> which the laws do not forbid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Theol.)</fld> <sd>(a)</sd> <def>According to the law of works, as distinguished from free grace; or resting on works for salvation.</def> <sd>(b)</sd> <def>According to the old or Mosaic dispensation; in accordance with the law of Moses.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>Governed by the rules of law as distinguished from the rules of equity; <as>as, <ex>legal</ex> estate; <ex>legal</ex> assets.</as></def> <rj><au>Bouvier.</au> <au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Legal cap</b></col>. <cd>See under <er>Cap</er>.</cd> -- <col><b>Legal tender</b></col>. <sd>(a)</sd> <cd>The act of tendering in the performance of a contract or satisfaction of a claim that which the law prescribes or permits, and at such time and place as the law prescribes or permits.</cd> <sd>(b)</sd> <cd>That currency, or money, which the law authorizes a debtor to tender and requires a creditor to receive. It differs in different countries.</cd></cs></p>

<p><syn><b>Syn.</b> -- Lawful; constitutional; legitimate; licit; authorized. See <er>Lawful</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>legalese</ent><br/
<hw>legalese</hw> <pos>n.</pos> <def>A style of writing or speaking heavily emphasizing the abstruse technical vocabulary of the law, to the point where a speech or document may be incomprehensible to non-specialists.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>legalisation</ent><br/
<hw>legalisation</hw> <pos>n.</pos> <sn>1.</sn> <def>the act of legalizing; same as <er>legalization</er>.</def><br/
<syn><b>Syn. --</b> legalization.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Legalism</ent><br/
<hw>Le"gal*ism</hw> <pr>(l<emac/"g<ait/l*<icr/z'm)</pr>, <pos>n.</pos> <def>Strictness, or the doctrine of strictness, in conforming to law.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legalist</ent><br/
<hw>Le"gal*ist</hw>, <pos>n.</pos> <def>One who practices or advocates strict conformity to law; in theology, one who holds to the law of works. See <er>Legal</er>, 2 <sd>(a)</sd>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legality</ent><br/
<hw>Le*gal"i*ty</hw> <pr>(l<esl/*g<acr/l"<icr/*t<ycr/)</pr>, <pos>n.</pos> <ety>[Cf. LL. <ets>legalitas</ets>, F. <ets>l<eacute/galit<eacute/</ets>. Cf. <er>Loyalty</er>.]</ety> <sn>1.</sn> <def>The state or quality of being legal; conformity to law.</def><br/
[<source>1913 Webster</source>]</p> 
 
<p><sn>2.</sn> <fld>(Theol.)</fld> <def>A conformity to, and resting upon, the letter of the law.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legalization</ent><br/
<hw>Le`gal*i*za"tion</hw> <pr>(l<emac/`g<ait/l*<icr/*z<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <def>The act of making legal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legalize</ent><br/
<hw>Le"gal*ize</hw> <pr>(l<emac/"g<ait/l*<imac/z)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Legalized</conjf> <pr>(-<imac/zd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Legalizing</conjf> <pr>(-<imac/`z<icr/ng)</pr>.]</vmorph> <ety>[Cf. F. <ets>l<eacute/galiser</ets>.]</ety> <sn>1.</sn> <def>To make legal.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Theol.)</fld> <def>To interpret or apply in a legal spirit.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legally</ent><br/
<hw>Le"gal*ly</hw>, <pos>adv.</pos> <def>In a legal manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legantine</ent><br/
<hw>Le*gan"tine</hw> <pr>(l<esl/*g<acr/n"t<icr/n)</pr>, <pos>a.</pos> <mark>[Obs.]</mark> <def>See <er>Legatine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legatary</ent><br/
<hw>Leg"a*ta*ry</hw> <pr>(l<ecr/g"<adot/*t<asl/*r<ycr/)</pr>, <pos>n.</pos> <ety>[L. <ets>legatarius</ets>, fr. <ets>legaturius</ets> enjoined by a last will: cf. F. <ets>l<eacute/gataire</ets>. See <er>Legacy</er>.]</ety> <def>A legatee.</def> <mark>[R.]</mark> <rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legate</ent><br/
<hw>Leg"ate</hw> <pr>(l<ecr/g"<asl/t)</pr>, <pos>n.</pos> <ety>[OE. <ets>legat</ets>, L. <ets>legatus</ets>, fr. <ets>legare</ets> to send with a commission or charge, to depute, fr. <ets>lex</ets>, <ets>legis</ets>, law: cf. F. <ets>l<eacute/gat</ets>, It. <ets>legato</ets>. See <er>Legal</er>.]</ety> <sn>1.</sn> <def>An ambassador or envoy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An ecclesiastic representing the pope and invested with the authority of the Holy See.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Legates are of three kinds: (<stype>a</stype>) <xex>Legates a latere</xex>, now always cardinals. They are called <xex>ordinary</xex> or <xex>extraordinary</xex> legates, the former governing provinces, and the latter class being sent to foreign countries on extraordinary occasions. (<stype>b</stype>) <xex>Legati missi</xex>, who correspond to the ambassadors of temporal governments. (<stype>c</stype>) <xex>Legati nati</xex>, or <xex>legates by virtue of their office</xex>, as the archbishops of Salzburg and Prague.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Rom. Hist.)</fld> <sd>(a)</sd> <def>An official assistant given to a general or to the governor of a province.</def> <sd>(b)</sd> <def>Under the emperors, a governor sent to a province.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legatee</ent><br/
<hw>Leg`a*tee"</hw> <pr>(l<ecr/g`<adot/*t<emac/")</pr>, <pos>n.</pos> <ety>[See <er>Legacy</er>.]</ety> <fld>(Law)</fld> <def>One to whom a legacy is bequeathed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legateship</ent><br/
<hw>Leg"ate*ship</hw> <pr>(l<ecr/g"<asl/t*sh<icr/p)</pr>, <pos>n.</pos> <def>The office of a legate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legatine</ent><br/
<hw>Leg"a*tine</hw> <pr>(-<adot/*t<imac/n)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of or pertaining to a legate; <as>as, <ex>legatine</ex> power</as>.</def> <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Made by, proceeding from, or under the sanction of, a legate; <as>as, a <ex>legatine</ex> constitution</as>.</def> <rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legation</ent><br/
<hw>Le*ga"tion</hw> <pr>(l<esl/*g<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>legatio</ets>: cf. F. <ets>l<eacute/gation</ets>, It. <ets>legazione</ets>. See <er>Legate</er>.]</ety> <sn>1.</sn> <def>The sending forth or commissioning one person to act for another.</def> <ldquo/The Divine <xex>legation</xex> of Moses.<rdquo/ <rj><au>Bp. Warburton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A legate, or envoy, and the persons associated with him in his mission; an embassy; or, in stricter usage, a diplomatic minister and his suite; a deputation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The place of business or official residence of a diplomatic minister at a foreign court or seat of government.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A district under the jurisdiction of a legate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legato</ent><br/
\'d8<hw>Le*ga"to</hw> <pr>(l<asl/*g<aum/"t<osl/)</pr>, <pos>a.</pos> <ety>[It., tied, joined, fr. <ets>legare</ets> to tie, bind, L. <ets>ligare</ets>.]</ety> <fld>(Mus.)</fld> <def>Connected; tied; -- a term used when successive tones are to be produced in a closely connected, smoothly gliding manner. It is often indicated by a <xex>tie</xex>, thus <?/, <?/, or <?/, <?/, written over or under the notes to be so performed; -- opposed to <contr>staccato</contr>.</def><-- music notation: slur down, slur up, legato down, legato up. Use graphic? --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legator</ent><br/
\'d8<hw>Leg`a*tor"</hw> <pr>(l<ecr/g`<adot/*t<ocir/r")</pr>, <pos>n.</pos> <ety>[L., fr. <ets>legare</ets>: cf. OF. <ets>legateur</ets>. See <er>Legacy</er>.]</ety> <fld>(Law)</fld> <def>A testator; one who bequeaths a legacy.</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legatura</ent><br/
\'d8<hw>Le`ga*tu"ra</hw> <pr>(l<asl/`g<adot/*t<oomac/"r<adot/)</pr>, <pos>n.</pos> <ety>[It. See <er>Ligature</er>.]</ety> <fld>(Mus.)</fld> <def>A tie or brace; a syncopation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legature</ent><br/
<hw>Leg"a*ture</hw> <pr>(l<ecr/g"<adot/*t<usl/r; 135)</pr>, <pos>n.</pos> <def>Legateship.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leg bridge</ent><br/
<hw>Leg bridge</hw>. <def>A type of bridge for small spans in which  the floor girders are rigidly secured at their extremities to supporting steel legs, driven into the ground as piling, or resting on mudsills.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lege</ent><br/
<hw>Lege</hw> <pr>(l<ecr/j)</pr>, <pos>v. t.</pos> <ety>[Abbrev. fr. <ets>allege</ets> to assert.]</ety> <def>To allege; to assert.</def> <mark>[Obs.]</mark> <rj><au>Bp. Fisher.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legement</ent><br/
<hw>Lege"ment</hw> <pr>(-m<eit/nt)</pr>, <pos>n.</pos> <def>See <er>Ledgment</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legend</ent><br/
<hw>Leg"end</hw> <pr>(l<ecr/j"<ecr/nd <or/ l<emac/"j<ecr/nd; 277)</pr>, <pos>n.</pos> <ety>[OE. <ets>legende</ets>, OF. <ets>legende</ets>, F. <ets>l<eacute/gende</ets>, LL. <ets>legenda</ets>, fr. L. <ets>legendus</ets> to be read, fr. <ets>legere</ets> to read, gather; akin to Gr. <grk>le`gein</grk> to gather, speak. Cf. <er>Collect</er>, <er>Dialogue</er>, <er>Lesson</er>, <er>Logic</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>That which is appointed to be read; especially, a chronicle or register of the lives of saints, formerly read at matins, and in the refectories of religious houses.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A story respecting saints; especially, one of a marvelous nature.</def> <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any wonderful story coming down from the past, but not verifiable by historical record; a myth; a fable.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And in this <qex>legend</qex> all that glorious deed<br/
Read, whilst you arm you.</q> <rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An inscription, motto, or title, esp. one surrounding the field in a medal or coin, or placed upon an heraldic shield or beneath an engraving or illustration.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Golden legend</b></col>. <cd>See under <er>Golden</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legend</ent><br/
<hw>Leg"end</hw>, <pos>v. t.</pos> <def>To tell or narrate, as a legend.</def> <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legendary</ent><br/
<hw>Leg"end*a*ry</hw> <pr>(l<ecr/j"<ecr/n*d<asl/*r<ycr/)</pr>, <pos>a.</pos> <def>Of or pertaining to a legend or to legends; consisting of legends; like a legend; fabulous.</def> <ldquo/<xex>Legendary</xex> writers.<rdquo/ <rj><au>Bp. Lloyd.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Legendary</qex> stories of nurses and old women.</q> <rj><qau>Bourne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legendary</ent><br/
<hw>Leg"end*a*ry</hw>, <pos>n.</pos> <ety>[Cf. OF. <ets>legendaire</ets>, LL. <ets>legendarius</ets>.]</ety> <sn>1.</sn> <def>A book of legends; a tale or narrative.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Read the Countess of Pembroke's <ldquo/Arcadia,<rdquo/ a gallant <qex>legendary</qex> full of pleasurable accidents.</q> <rj><qau>James I.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who relates legends.</def> <rj><au>Bp. Lavington.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leger</ent><br/
<hw>Leg"er</hw> <pr>(l<ecr/j"<etil/r)</pr>, <pos>n.</pos> <ety>[See <er>Ledger</er>.]</ety> <sn>1.</sn> <def>Anything that lies in a place; that which, or one who, remains in a place.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A minister or ambassador resident at a court or seat of government.</def> <altsp>[Written also <asp>lieger</asp>, <asp>leiger</asp>.]</altsp> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Sir Edward Carne, the queen's <qex>leger</qex> at Rome.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A ledger.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leger</ent><br/
<hw>Leg"er</hw>, <pos>a.</pos> <def>Lying or remaining in a place; hence, resident; <as>as, <ex>leger</ex> ambassador</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leger</ent><br/
<hw>Leg"er</hw>, <pos>a.</pos> <ety>[F. <ets>l<eacute/ger</ets>, fr. LL. (assumed) <ets>leviarius</ets>, fr. L. <ets>levis</ets> light in weight. See <er>Levity</er>.]</ety> <def>Light; slender; slim; trivial.</def> <mark>[Obs. except in special phrases.]</mark> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leger line</b></col> <fld>(Mus.)</fld>, <cd>a line added above or below the staff to extend its compass; -- called also <altname>added line</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legerdemain</ent><br/
<hw>Leg`er*de*main"</hw> <pr>(l<ecr/j`<etil/r*d<esl/*m<amac/n")</pr>, <pos>n.</pos> <ety>[F. <ets>l<eacute/ger</ets> light, nimble + <ets>de</ets> of + <ets>main</ets> hand, L. <ets>manus</ets>. See 3d <er>Leger</er>, and <er>Manual</er>.]</ety> <def>Sleight of hand; a trick of sleight of hand; hence, any artful deception or trick.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He of <qex>legierdemayne</qex> the mysteries did know.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The tricks and <qex>legerdemain</qex> by which men impose upon their own souls.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legerdemainist</ent><br/
<hw>Leg`er*de*main"ist</hw>, <pos>n.</pos> <def>One who practices sleight of hand; a prestidigitator.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legerity</ent><br/
<hw>Le*ger"i*ty</hw> <pr>(l<esl/*j<ecr/r"<icr/*t<ycr/)</pr>, <pos>n.</pos> <ety>[F. <ets>l<eacute/g<egrave/ret<eacute/</ets>. See 3d <er>Leger</er>.]</ety> <def>Lightness; nimbleness.</def> <mark>[Archaic]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legge</ent><br/
<hw>Legge</hw> <pr>(l<ecr/g)</pr>, <pos>v. t.</pos> <ety>[See <er>Lay</er>, <pos>v. t.</pos> ]</ety> <def>To lay.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legge</ent><br/
<hw>Legge</hw>, <pos>v. t.</pos> <ety>[Abbrev. fr. <ets>alegge</ets>.]</ety> <def>To lighten; to allay.</def> <mark>[Obs.]</mark> <rj><au>Rom. of R.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legged</ent><br/
<hw>Legged</hw> <pr>(l<ecr/gd <or/ l<ecr/g"g<ecr/d)</pr>, <pos>a.</pos> <ety>[From <er>Leg</er>.]</ety> <def>Having (such or so many) legs; -- used in composition; <as>as, a long<ex>-legged</ex> man; a two<ex>-legged</ex> animal.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leggiero</ent><br/
<ent>Leggiadro</ent><br/
<mhw>{ \'d8<hw>Leg`gi*a"dro</hw> <pr>(l<asl/d`j<esl/*<aum/"dr<osl/)</pr>, \'d8<hw>Leg`gi*e"ro</hw> <pr>(l<asl/d`j<esl/*<asl/"r<osl/)</pr>, }</mhw> <pos>a. & adv.</pos> <ety>[It.]</ety> <fld>(Mus.)</fld> <def>Light or graceful; in a light, delicate, and brisk style.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leggin</ent><br/
<ent>Legging</ent><br/
<mhw>{ <hw>Leg"ging</hw> <pr>(l<ecr/g"g<icr/ng)</pr>, <hw>Leg"gin</hw> <pr>(l<ecr/g"g<icr/n)</pr>, }</mhw> <pos>n.</pos> <ety>[From <er>Leg</er>.]</ety> <def>A cover for the leg, like a long gaiter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legging</ent><br/
<hw>Leg"ging</hw>, <def><pos>a. & vb. n.</pos>, from <er>Leg</er>, <pos>v. t.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leggy</ent><br/
<hw>Leg"gy</hw> <pr>(l<ecr/g"g<ycr/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>having tall spindly stems; -- of plants.</def> <wns>[wns=1]</wns><br/
<syn><b>Syn. --</b> tall-growing.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>Having long legs.</def> <wns>[wns=2]</wns> <rj><au>Thackeray.</au></rj><br/
<syn><b>Syn. --</b> long-legged, long-shanked.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leghorn</ent><br/
<hw>Leg"horn</hw> <pr>(l<ecr/g"h<ocir/rn)</pr>, <pos>n.</pos> <def>A straw plaiting used for bonnets and hats, made from the straw of a particular kind of wheat, grown for the purpose in Tuscany, Italy; -- so called from Leghorn, the place of exportation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legibility</ent><br/
<hw>Leg`i*bil"i*ty</hw> <pr>(l<ecr/j`<icr/*b<icr/l"<icr/*t<ycr/)</pr>, <pos>n.</pos> <def>The quality of being legible; legibleness.</def> <rj><au>Sir. D. Brewster.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legible</ent><br/
<hw>Leg"i*ble</hw> <pr>(l<ecr/j"<icr/*b'l)</pr>, <pos>a.</pos> <ety>[L. <ets>legibilis</ets>, fr. <ets>legere</ets> to read: cf. OF. <ets>legible</ets>. See <er>Legend</er>.]</ety> <sn>1.</sn> <def>Capable of being read or deciphered; distinct to the eye; plain; -- used of writing or printing; <as>as, a fair, <ex>legible</ex> manuscript</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The stone with moss and lichens so overspread,<br/
Nothing is <qex>legible</qex> but the name alone.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Capable of being discovered or understood by apparent marks or indications; <as>as, the thoughts of men are often <ex>legible</ex> in their countenances</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legibleness</ent><br/
<hw>Leg"i*ble*ness</hw>, <pos>n.</pos> <def>The state or quality of being legible.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legibly</ent><br/
<hw>Leg"i*bly</hw>, <pos>adv.</pos> <def>In a legible manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legific</ent><br/
<hw>Le*gif"ic</hw> <pr>(l<esl/*j<icr/f"<icr/k)</pr>, <pos>a.</pos> <ety>[L. <ets>lex</ets>, <ets>legis</ets>, law + <ets>-ficare</ets> (in comp.) to make. See <er>-fy</er>.]</ety> <def>Of or pertaining to making laws.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Practically, in many cases, authority or <qex>legific</qex> competence has begun in bare power.</q> <rj><qau>J. Grote.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legion</ent><br/
<hw>Le"gion</hw> <pr>(l<emac/"j<ucr/n)</pr>, <pos>n.</pos> <ety>[OE. <ets>legioun</ets>, OF. <ets>legion</ets>, F. <ets>l<eacute/gion</ets>, fr. L. <ets>legio</ets>, fr. <ets>legere</ets> to gather, collect. See <er>Legend</er>.]</ety> <sn>1.</sn> <fld>(Rom. Antiq.)</fld> <def>A body of foot soldiers and cavalry consisting of different numbers at different periods, -- from about four thousand to about six thousand men, -- the cavalry being about one tenth.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A military force; an army; military bands.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A great number; a multitude.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Where one sin has entered, <qex>legions</qex> will force their way through the same breach.</q> <rj><qau>Rogers.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Taxonomy)</fld> <def>A group of orders inferior to a class.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Legion of honor</b></col>, <cd>an order instituted by the French government in 1802, when Bonaparte was First Consul, as a reward for merit, both civil and military.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legionary</ent><br/
<hw>Le"gion*a*ry</hw> <pr>(-<asl/*r<ycr/)</pr>, <pos>a.</pos> <ety>[L. <ets>legionarius</ets>: cf. F. <ets>l<eacute/gionnaire</ets>.]</ety> <def>Belonging to a legion; consisting of a legion or legions, or of an indefinitely great number; <as>as, <ex>legionary</ex> soldiers; a <ex>legionary</ex> force.</as></def> <ldquo/The <xex>legionary</xex> body of error.<rdquo/ <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legionary</ent><br/
<hw>Le"gion*a*ry</hw> <pr>(l<emac/"j<ucr/n*<asl/*r<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Legionaries</plw> <pr>(-r<icr/z)</pr>.</plu> <def>A member of a legion.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legioned</ent><br/
<hw>Le"gioned</hw> <pr>(l<emac/"j<ucr/nd)</pr>, <pos>a.</pos> <def>Formed into a legion or legions; legionary.</def> <rj><au>Shelley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legionry</ent><br/
<hw>Le"gion*ry</hw> <pr>(l<emac/"j<ucr/n*r<ycr/)</pr>, <pos>n.</pos> <def>A body of legions; legions, collectively.</def> <mark>[R.]</mark> <rj><au>Pollok.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legislate</ent><br/
<hw>Leg"is*late</hw> <pr>(l<ecr/j"<icr/s*l<amac/t)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Legislated</conjf> <pr>(-l<amac/`t<ecr/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Legislating</conjf> <pr>(-l<amac/`t<icr/ng)</pr>.]</vmorph> <ety>[See <er>Legislator</er>.]</ety> <def>To make or enact a law or laws.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Solon, in <qex>legislating</qex> for the Athenians, had an idea of a more perfect constitution than he gave them.</q> <rj><qau>Bp. Watson (1805).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>legislating</ent><br/
<hw>legislating</hw> <pos>n.</pos> <def>the act of making or enacting laws; legislation{1}.</def><br/
<syn><b>Syn. --</b> legislation, lawmaking.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Legislation</ent><br/
<hw>Leg`is*la"tion</hw> <pr>(-l<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>l<eacute/gislation</ets>, L. <ets>legis latio</ets>. See <er>Legislator</er>.]</ety> <def>The act of legislating; preparation and enactment of laws; the laws enacted.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Pythagoras joined <qex>legislation</qex> to his philosophy.</q> <rj><qau>Lyttelton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legislative</ent><br/
<hw>Leg"is*la*tive</hw> <pr>(l<ecr/j"<icr/s*l<asl/*t<icr/v)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>l<eacute/gislatif</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Making, or having the power to make, a law or laws; lawmaking; -- distinguished from <contr>executive</contr>; <as>as, a <ex>legislative</ex> act; a <ex>legislative</ex> body</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The supreme <qex>legislative</qex> power of England was lodged in the king and great council, or what was afterwards called the Parliament.</q> <rj><qau>Hume.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to the making of laws; suitable to legislation; <as>as, the transaction of <ex>legislative</ex> business; the <ex>legislative</ex> style.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legislatively</ent><br/
<hw>Leg"is*la*tive*ly</hw>, <pos>adv.</pos> <def>In a legislative manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legislator</ent><br/
<hw>Leg"is*la`tor</hw> <pr>(l<ecr/j"<icr/s*l<amac/`t<etil/r)</pr>, <pos>n.</pos> <ety>[L. <ets>legis lator</ets>, prop., a proposer of a law; <ets>lex</ets>, <ets>legis</ets>, law + <ets>lator</ets> a proposer, bearer, fr. <ets>latus</ets>, used as p. p. of <ets>ferre</ets> to bear: cf. F. <ets>l<eacute/gislateur</ets>. See <er>Legal</er>, and <er>Tolerate</er>.]</ety> <def>A lawgiver; one who makes laws for a state or community; a member of a legislative body.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>legislators</qex> in ancient and heroical times.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Many of the <qex>legislators</qex> themselves had taken an oath of abjuration of his Majesty's person and family.</q> <rj><qau>E. Phillips.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legislatorial</ent><br/
<hw>Leg`is*la*to"ri*al</hw> <pr>(-l<adot/*t<omac/"r<icr/*<ait/l)</pr>, <pos>a.</pos> <def>Of or pertaining to a legislator or legislature.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legislatorship</ent><br/
<hw>Leg"is*la`tor*ship</hw> <pr>(l<ecr/j"<icr/s*l<amac/`t<etil/r*sh<icr/p)</pr>, <pos>n.</pos> <def>The office of a legislator.</def> <rj><au>Halifax.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legislatrix</ent><br/
<ent>Legislatress</ent><br/
<mhw>{ <hw>Leg"is*la`tress</hw> <pr>(-tr<ecr/s)</pr>, <hw>Leg"is*la`trix</hw> <pr>(-tr<icr/ks)</pr>, }</mhw> <pos>n.</pos> <def>A woman who makes laws.</def> <rj><au>Shaftesbury.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legislature</ent><br/
<hw>Leg"is*la`ture</hw> <pr>(l<ecr/j"<icr/s*l<amac/`t<usl/r; 135)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>l<eacute/gislature</ets>.]</ety> <def>The body of persons in a state or kingdom invested with power to make and repeal laws; a legislative body.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Without the concurrent consent of all three parts of the <qex>legislature</qex>, no law is, or can be, made.</q> <rj><qau>Sir M. Hale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <ex>legislature</ex> of Great Britain consists of the Lords and Commons, with the king or queen, whose sanction is necessary to every bill before it becomes a law. The <ex>legislatures</ex> of most of the United States consist of two houses or branches; but the sanction or consent of the governor is required to give their acts the force of law, or a concurrence of two thirds of the two houses after he has refused his sanction and assigned his objections.</note><br/
[<source>1913 Webster</source>]</p>

<p><note>The legislatures of some of the more important states having constitutional government are as follows, the general name (or a translation of it) of the  legislative body collectively being given under the heading <xex>legislature</xex>, <xex>or parliament</xex>:</p>

<p><-- ##?? Untyped: a Table of countries with their types of legislatures. -->
<table><pre>
<headrow><item>State</item><item>Legislature, or parliament</item><mitem>Upper House<colret/<item>Name</item><item>Number of members -- how chosen or composed -- term of office</item></mitem><mitem>Lower House<colret/<item>Name</item><item>Number of members -- suffrage -- term of office</item></mitem></headrow>
-----------------------------------------------------------------
<row><item>Argentina</item><item>National Congress</item><item>Senate</item><item>30 -- 2 from each provincew and 2 from capital -- 9 years</item><item>House of Deputies</item><item>120  (1 to 33,000) -- Manhood -- 4 years</item></row>
<row><item>Austria</item><item>Reichsrath</item><item></item><item></item><item></item><item></item></row>
<row><item>Belgium</item><item>The Chambers</item><item></item><item></item><item></item><item></item></row>
<row><item>Brazil</item><item>National Congress</item><item></item><item></item><item></item><item></item></row>
<row><item>Chile</item><item>National Congress</item><item></item><item></item><item></item><item></item></row>
<row><item>Denmark</item><item>Rigsdag</item><item></item><item></item><item></item><item></item></row>
<row><item>France</item><item>National Assembly</item><item></item><item></item><item></item><item></item></row>
<row><item>German Empire</item><item>Imperial legislature</item><item></item><item></item><item></item><item></item></row>
<row><item>*Great Britain</item><item>Parliament</item><item>House of Lords</item><item>About 600</item><item>House of Commons</item><item>About 670 -- 7 years, or until dissolution</item></row>
<row><item>Greece</item><item></item><item></item><item></item><item></item><item></item></row>
<row><item>Hungary</item><item>Orz<aacute/g-gy<uum/l<eacute/s</item><item></item><item></item><item></item><item></item></row>
<row><item>Italy</item><item>Parliament</item><item></item><item></item><item></item><item></item></row>
<row><item>Japan</item><item>Imperial Diet</item><item></item><item></item><item></item><item></item></row>
<row><item>Mexico</item><item>Congress</item><item></item><item></item><item></item><item></item></row>
<row><item>Netherlands</item><item>States-General</item><item></item><item></item><item></item><item></item></row>
<row><item>#Norway</item><item>Storthing</item><item></item><item></item><item></item><item></item></row>
<row><item>Portugal</item><item>Cortes Geraes (general Assembly)</item><item></item><item></item><item></item><item></item></row>
<row><item>Prussia</item><item>Landtag</item>Herrenhaus<item></item><item>No limit -- very various classes -- For different terms</item><item>Abgeordnetenhaus</item><item>433 -- Indirect election, general suffrage<sect/ -- 5 years, or until dissolution</item></row>
<row><item>Spain</item><item>Cortes</item><item></item><item></item><item></item><item></item></row>
<row><item>Sweden</item><item>Diet</item><item></item><item></item><item></item><item></item></row>
<row><item>Switzerland</item><item>Bundesversammlung</item><item></item><item></item><item></item><item></item></row>
<row><item>United States</item><item>Congress</item><item>Senate</item><item>92(1908) -- 6 years</item><item>House of Representatives</item><item>391 (1908) -- 2 years.</item></row>
</pre></table>
----------------------------------------------------------------
*In the self-governing colonies of Great Britain the legislative body usually consists of two chambers, the names of the legislature and the chambers varying.  Thus in Australia the Federal Parliament is composed of the Senate and the House of Commons, in New Zealand the General Assembly is composed of the Legislative Council and the House of Representatives, etc.</p>

<p>#Members of the Storthing are chosen for three years by direct election by manhood suffrage, forty-one being elected from the towns and eighty-two from the rural districts.  The Storthing on assembling divides into the Lagthing including one fourth and the Odelsthing including three fourths of the total membership of the Storthing.  All new laws are laid first before the Odelsthing.  If the two houses do not agree they vote in joint session, a majority of two thirds of those voting being necessary to a decision.</p>

<p><sect/ While theoretically general, the suffrage is so classified as often practically to disfranchise those who are not property holders.
</note><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Legist</ent><br/
<hw>Le"gist</hw> <pr>(l<emac/"j<icr/st)</pr>, <pos>n.</pos> <ety>[F. <ets>l<eacute/giste</ets>, LL. <ets>legista</ets>, fr. L. <ets>lex</ets>, <ets>legis</ets>, law. See <er>Legal</er>.]</ety> <def>One skilled in the laws; a writer on law.</def> <rj><au>Milman.</au> <au>J. Morley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitim</ent><br/
<hw>Le*git"im</hw> <pr>(l<esl/*j<icr/"<icr/m)</pr>, <pos>n.</pos> <ety>[See <er>Legitimate</er>, <pos>a.</pos>]</ety> <fld>(Scots Law)</fld> <def>The portion of movable estate to which the children are entitled upon the death of the father.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimacy</ent><br/
<hw>Le*git"i*ma*cy</hw> <pr>(-<icr/*m<adot/*s<ycr/)</pr>, <pos>n.</pos> <ety>[See <er>Legitimate</er>, <pos>a.</pos>]</ety> <def>The state, or quality, of being legitimate, or in conformity with law; hence, the condition of having been lawfully begotten, or born in wedlock.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The doctrine of Divine Right, which has now come back to us, like a thief from transportation, under the alias of <qex>Legitimacy</qex>.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimate</ent><br/
<hw>Le*git"i*mate</hw> <pr>(-m<asl/t)</pr>, <pos>a.</pos> <ety>[LL. <ets>legitimatus</ets>, p. p. of <ets>legitimare</ets> to legitimate, fr. L. <ets>legitimus</ets> legitimate. See <er>Legal</er>.]</ety> <sn>1.</sn> <def>Accordant with law or with established legal forms and requirements; lawful; <as>as, <ex>legitimate</ex> government; <ex>legitimate</ex> rights; the <ex>legitimate</ex> succession to the throne; a <ex>legitimate</ex> proceeding of an officer; a <ex>legitimate</ex> heir.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lawfully begotten; born in wedlock.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Authorized; real; genuine; not false, counterfe`t, or spurious; <as>as,$<ex>legitimate</ex> poems of Chaucer; <ex>legitimate</ex> inscriptions.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Conforming to known principles, or accepted rules; <as>as, <ex>legitimate</ex> reasoning; a <ex>legitimate</ex> standard, or method; a <ex>legitimate</ex> combination of colors.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Tillotson still keeps his place as a <qex>legitimate</qex> English classic.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Following by logical sequence; reasonable; <as>as, a <ex>legitimate</ex> result; a <ex>legitimate</ex> inference.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimate</ent><br/
<hw>Le*git"i*mate</hw> <pr>(-m<amac/t)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Legitimated</conjf> <pr>(-m<amac/`t<ecr/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Legitimating</conjf> <pr>(-m<amac/`t<icr/ng)</pr>.]</vmorph> <def>To make legitimate, lawful, or valid; esp., to put in the position or state of a legitimate person before the law, by legal means; <as>as, to <ex>legitimate</ex> a bastard child</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To enact a statute of that which he dares not seem to approve, even to <qex>legitimate</qex> vice.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimately</ent><br/
<hw>Le*git"i*mate*ly</hw> <pr>(-m<asl/t*l<ycr/)</pr>, <pos>adv.</pos> <def>In a legitimate manner; lawfully; genuinely.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimateness</ent><br/
<hw>Le*git"i*mate*ness</hw>, <pos>n.</pos> <def>The state or quality of being legitimate; lawfulness; genuineness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimation</ent><br/
<hw>Le*git`i*ma"tion</hw> <pr>(-m<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>l<eacute/gitimation</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The act of making legitimate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The coining or <qex>legitimation</qex> of money.</q> <rj><qau>East.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lawful birth.</def> <mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimatist</ent><br/
<hw>Le*git"i*ma*tist</hw> <pr>(l<esl/*j<icr/t"<icr/*m<adot/*t<icr/st)</pr>, <pos>n.</pos> <def>See <er>Legitimist</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimatize</ent><br/
<hw>Le*git"i*ma*tize</hw> <pr>(-t<imac/z)</pr>, <pos>v. t.</pos> <def>To legitimate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimism</ent><br/
<hw>Le*git"i*mism</hw> <pr>(-m<icr/z'm)</pr>, <pos>n.</pos> <def>The principles or plans of legitimists.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legitimist</ent><br/
<hw>Le*git"i*mist</hw> <pr>(-m<icr/st)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>l<eacute/gitimiste</ets>.]</ety> <sn>1.</sn> <def>One who supports legitimate authority; esp., one who believes in hereditary monarchy, as a divine right.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Specifically, a supporter of the claims of the elder branch of the Bourbon dynasty to the crown of France.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 842 pr=VMG --></p>

<p><ent>Legitimize</ent><br/
<hw>Le*git"i*mize</hw> <pr>(l<esl/*j<icr/t"<icr/*m<imac/z)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Legitimized</conjf> <pr>(-m<imac/zd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Legitimizing</conjf>.]</vmorph> <def>To legitimate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legless</ent><br/
<hw>Leg"less</hw> <pr>(l<ecr/g"l<ecr/s)</pr>, <pos>a.</pos> <def>Not having a leg.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leg-of-mutton</ent><br/
<hw>Leg"-of-mut"ton</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having the general shape or outline of a leg of mutton; <as>as, a <ex>leg-of-mutton</ex>, or shoulder-of-mutton, sail</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lego-literary</ent><br/
<hw>Le"go-lit"er*a*ry</hw> <pr>(l<emac/"g<osl/-l<icr/t"<etil/r*<asl/*r<ycr/)</pr>, <pos>a.</pos> <ety>[See <er>Legal</er>, and <er>Literary</er>.]</ety> <def>Pertaining to the literature of law.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leg-pull</ent><br/
<hw>leg-pull</hw> <pos>n.</pos> <def>An attempt to make somebody believe something that is not true, done as a joke.</def><br/
<syn><b>Syn. --</b> leg-pulling.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leg-pulling</ent><br/
<hw>leg-pulling</hw> <pos>n.</pos> <def>The act of attempting to make somebody believe something that is not true, done as a joke.</def><br/
<syn><b>Syn. --</b> leg-pull.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leguleian</ent><br/
<hw>Le`gu*le"ian</hw> <pr>(l<emac/`g<usl/*l<emac/"y<ait/n)</pr>, <pos>a.</pos> <ety>[L. <ets>leguleius</ets> pettifogger, fr. <ets>lex</ets>, <ets>legis</ets>, law.]</ety> <def>Lawyerlike; legal.</def> <mark>[R.]</mark> <ldquo/<xex>Leguleian</xex> barbarism.<rdquo/ <au>De Quincey.</au> -- <def2><pos>n.</pos> <def>A lawyer.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legume</ent><br/
<hw>Leg"ume</hw> <pr>(l<ecr/g"<usl/m <or/ l<esl/*g<umac/m")</pr>, <pos>n.</pos> <ety>[F. <ets>l<eacute/gume</ets>, L. <ets>legumen</ets>, fr. <ets>legere</ets> to gather. So called because they may be gathered without cutting. See <er>Legend</er>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>A pod dehiscent into two pieces or valves, and having the seed attached at one suture, as that of the pea.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the latter circumstance, it differs from a <xex>siliqua</xex>, in which the seeds are attached to both sutures. In popular use, a <xex>legume</xex> is called a <xex>pod</xex>, or <xex>cod</xex>; as, pea <xex>pod</xex>, or peas <xex>cod</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>The fruit of leguminous plants, as peas, beans, lupines; pulse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legumen</ent><br/
\'d8<hw>Le*gu"men</hw> <pr>(l<esl/*g<umac/"m<ecr/n)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Legumina</plw> <pr>(-m<icr/*n<adot/)</pr>, E. <plw>Legumens</plw> <pr>(-m<ecr/nz)</pr>.</plu> <ety>[L.]</ety> <def>Same as <er>Legume</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Legumin</ent><br/
<hw>Le*gu"min</hw> <pr>(-m<icr/n)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>l<eacute/gumine</ets>.]</ety> <fld>(Physiol. Chem.)</fld> <def>An albuminous substance resembling casein, found as a characteristic ingredient of the seeds of leguminous and grain-bearing plants.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leguminous</ent><br/
<hw>Le*gu"mi*nous</hw> <pr>(-m<icr/*n<ucr/s)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>l<eacute/gumineux</ets>.]</ety> <sn>1.</sn> <def>Pertaining to pulse; consisting of pulse.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Belonging to, or resembling, a very large natural order of plants (<ord>Leguminos<ae/</ord>), which bear legumes, including peas, beans, clover, locust trees, acacias, and mimosas.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leiger</ent><br/
<hw>Lei"ger</hw> <pr>(l<emac/"j<etil/r)</pr>, <pos>n.</pos> <ety>[See <er>Leger</er>, and <er>Ledger</er>.]</ety> <def>See <er>Leger</er>, <pos>n.</pos>, 2.</def> <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leiopelma</ent><br/
<hw>Leiopelma</hw> <pos>n.</pos> <def>The type and sole genus of the family <fam>Leiopelmatidae</fam>.</def>  <altsp>[Also spelled <asp><gen>Liopelma</gen></asp>.]</altsp><br/
<syn><b>Syn. --</b> genus <gen>Leiopelma</gen>, Liopelma, genus <gen>Liopelma</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leiopelmatidae</ent><br/
<hw>Leiopelmatidae</hw> <pos>n.</pos> <def>A natural family of primitive New Zealand frogs.</def>  <altsp>[Also spelled <asp><fam>Liopelmidae</fam></asp>.]</altsp><br/
<syn><b>Syn. --</b> family <fam>Leiopelmatidae</fam>, Liopelmidae, family <fam>Liopelmidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leiophyllum</ent><br/
<hw>Leiophyllum</hw> <pos>n.</pos> <def>A genus having only one species, the sand myrtle.</def><br/
<syn><b>Syn. --</b> genus <gen>Leiophyllum</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leiotrichan</ent><br/
<hw>Lei*ot"ri*chan</hw> <pr>(l<isl/*<ocr/t"r<icr/*k<ait/n)</pr>, <pos>a.</pos> <def>Of or pertaining to the Leiotrichi.</def> -- <def2><pos>n.</pos> <def>One of the Leiotrichi.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leiotrichi</ent><br/
\'d8<hw>Lei*ot"ri*chi</hw> <pr>(-k<imac/)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>lei^os</grk> smooth + <grk>qri`x</grk>, <grk>tricho`s</grk>, hair.]</ety> <fld>(Anthropol.)</fld> <def>The division of mankind which embraces the smooth-haired races.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leiotrichous</ent><br/
<hw>Lei*ot"ri*chous</hw> <pr>(-k<ucr/s)</pr>, <pos>a.</pos> <ety>[See <er>Leiotrichi</er>.]</ety> <fld>(Anthropol.)</fld> <def>Having smooth, or nearly smooth, hair.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leipoa</ent><br/
\'d8<hw>Lei*po"a</hw> <pr>(l<isl/*p<omac/"<adot/)</pr>, <pos>n.</pos> <ety>[NL.]</ety> <fld>(Zool.)</fld> <def>A genus of Australian gallinaceous birds including but a single species (<spn>Leipoa ocellata</spn>), about the size of a turkey. Its color is variegated, brown, black, white, and gray. Called also <altname>native pheasant</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It makes large mounds of sand and vegetable material, in which its eggs are laid to be hatched by the heat of the decomposing mass.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leipothymic</ent><br/
<hw>Lei`po*thym"ic</hw> <pr>(l<imac/`p<osl/*th<icr/m"<icr/k)</pr>, <pos>a.</pos> <def>See <er>Lipothymic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lister</ent><br/
<ent>Leister</ent><br/
<mhw>{ <hw>Leis"ter</hw>, <hw>Lis"ter</hw> }</mhw> <pr>(l<icr/s"t<etil/r)</pr>, <pos>n.</pos> <def>A spear armed with three or more prongs, for striking fish.</def> <mark>[Scotland]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leisurable</ent><br/
<hw>Lei"sur*a*ble</hw> <pr>(l<emac/"zh<usl/r*<adot/*b'l; 135)</pr>, <pos>a.</pos> <ety>[See <er>Leisure</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Leisurely.</def> <mark>[Obs.]</mark> <rj><au>Hooker.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Vacant of employment; not occupied; idle; leisure; <as>as <ex>leisurable</ex> hours</as>.</def> <mark>[Obs.]</mark> <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leisurably</ent><br/
<hw>Lei"sur*a*bly</hw>, <pos>adv.</pos> <def>At leisure.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leisure</ent><br/
<hw>Lei"sure</hw> <pr>(l<emac/"zh<usl/r; 135)</pr>, <pos>n.</pos> <ety>[OE. <ets>leisere</ets>, <ets>leiser</ets>, OF. <ets>leisir</ets>, F. <ets>loisir</ets>, orig., permission, fr. L. <ets>licere</ets> to be permitted. See <er>License</er>.]</ety> <sn>1.</sn> <def>Freedom from occupation or business; vacant time; time free from employment.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The desire of <qex>leisure</qex> is much more natural than of business and care.</q> <rj><qau>Sir W. Temple.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Time at one's command, free from engagement; convenient opportunity; hence, convenience; ease.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He sighed, and had no <qex>leisure</qex> more to say.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>At leisure</b></col>. <sd>(a)</sd> <cd>Free from occupation; not busy.</cd> <sd>(b)</sd> <cd>In a leisurely manner; at a convenient time.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leisure</ent><br/
<hw>Lei"sure</hw>, <pos>a.</pos> <def>Unemployed; <as>as, <ex>leisure</ex> hours</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leisured</ent><br/
<hw>Lei"sured</hw> <pr>(l<emac/"zh<usl/rd)</pr>, <pos>a.</pos> <def>Having leisure.</def> <ldquo/The <xex>leisured</xex> classes.<rdquo/ <rj><au>Gladstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leisurely</ent><br/
<hw>Lei"sure*ly</hw> <pr>(l<emac/"zh<usl/r*l<ycr/)</pr>, <pos>a.</pos> <def>Characterized by leisure; taking abundant time; not hurried; <as>as, a <ex>leisurely</ex> manner; a <ex>leisurely</ex> walk.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leisurely</ent><br/
<hw>Lei"sure*ly</hw>, <pos>adv.</pos> <def>In a leisurely manner.</def> <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leitmotiv</ent><br/
<ent>Leitmotif</ent><br/
<mhw><hw>Leit"mo*tif"</hw>, \'d8<hw>Leit"mo*tiv"</hw></mhw> <pr>(l<imac/t"m<osl/*t<esl/f")</pr>, <pos>n.</pos> <ety>[G., leading motive.]</ety> <sn>1.</sn> <fld>(Mus.)</fld> <def>a guiding theme; in Wagnerian opera, a marked melodic phrase or short musical passage which always accompanies the reappearance of a certain person, situation, abstract idea, or allusion in the course of the play; a sort of musical label.  Also called <cref>Leading motive</cref>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>a recurring theme in the activities of a person or group.</def><br/
[<source>PJC</source>]</p>

<p><ent>Leitneria</ent><br/
<hw>Leitneria</hw> <pos>prop. n.</pos> <def>A genus of trees or shrubs coextensive with the family <fam>Leitneriaceae</fam>, and including the corkwood (<spn>Leitneria floridana</spn>).</def><br/
<syn><b>Syn. --</b> family <fam>Leitneriaceae</fam>, corkwood family.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leitneriaceae</ent><br/
<hw>Leitneriaceae</hw> <pos>prop. n.</pos> <def>A natural family of trees coextensive with the genus <gen>Leitneria</gen>; commonly isolated in a distinct order.</def><br/
<syn><b>Syn. --</b> family Leitneriaceae, corkwood family.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>L.E.M.</ent><br/
<ent>LEM</ent><br/
<mhw><hw>LEM</hw>, <hw>L.E.M.</hw></mhw> <pos>n.</pos> <ety>[acronym from <ets>L</ets>unar <ets>E</ets>xcursion <ets>M</ets>odule.]</ety> <fld>(Astronautics)</fld> <def>A <altname>lunar excursion module</altname>, a spacecraft designed to transport people from a command module in orbit around the moon to the surface of the moon and back again.</def><br/
<syn><b>Syn. --</b> lunar excursion module, lunar module.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lemaireocereus</ent><br/
<hw>Lemaireocereus</hw> <pos>n.</pos> <def>A genus of tropical American cacti, usually tall and branching with stout spines and funnel-shaped flowers and globular or ovoid often edible fruit.</def><br/
<syn><b>Syn. --</b> genus <gen>Lemaireocereus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leman</ent><br/
<hw>Le"man</hw> <pr>(l<emac/"m<ait/n <or/ l<ecr/m"<ait/n; 277)</pr>, <pos>n.</pos> <ety>[OE. <ets>lemman</ets>, <ets>lefman</ets>; AS. <ets>le<oacute/f</ets> dear + <ets>mann</ets> man. See <er>Lief</er>, and <er>Man</er>.]</ety> <def>A sweetheart, of either sex; a gallant, or a mistress; -- usually in a bad sense.</def> <mark>[Archaic]</mark> <rj><au>Chaucer.</au> <au>Spenser.</au> <au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lemanderin</ent><br/
<hw>lemanderin</hw> <pos>n.</pos> <def>A fruit tree (<spn>Citrus limonia</spn>) which is a hybrid between the mandarin orange and the lemon, having a very acid fruit with an orange peel; also, the fruit of this tree, the <altname>rangpur</altname>.</def><br/
<syn><b>Syn. --</b> rangpur, rangpur lime, <spn>Citrus limonia</spn>.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Leme</ent><br/
<hw>Leme</hw> <pr>(l<emac/m)</pr>, <pos>n.</pos> <ety>[OE. <ets>leem</ets>, <ets>leme</ets>, <ets>leam</ets>, AS. <ets>le<oacute/ma</ets> light, brightness; akin to E. <ets>light</ets>, <pos>n.</pos> <root/122.]</ety> <def>A ray or glimmer of light; a gleam.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leme</ent><br/
<hw>Leme</hw>, <pos>v. i.</pos> <def>To shine.</def> <mark>[Obs.]</mark> <rj><au>Piers Plowman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemma</ent><br/
<hw>Lem"ma</hw> <pr>(l<ecr/m"m<adot/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> L. <plw>Lemmata</plw> <pr>(-m<adot/*t<adot/)</pr>, E. <plw>Lemmas</plw> <pr>(-m<adot/z)</pr>.</plu> <ety>[L. <ets>lemma</ets>, Gr. <grk>lh^mma</grk> anything received, an assumption or premise taken for granted, fr. <grk>lamba`nein</grk> to take, assume. Cf. <er>Syllable</er>.]</ety> <sn>1.</sn> <fld>(Math., Logic)</fld> <def>A preliminary or auxiliary proposition demonstrated or accepted for immediate use in the demonstration of some other proposition, as in mathematics or logic.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A word that is included in a glossary or list of headwords; a headword.</def><br/
[<source>PJC</source>]</p>

<p><ent>lemmatization</ent><br/
<hw>lem`ma*tiz*a"tion</hw> <pr>(l<ecr/m`m<adot/*t<icr/z*<amac/"sh<ucr/n)</pr>, <pos>v. t.</pos> <def>The act or process of lemmatizing; conversion into a lemma{2}.</def><br/
[<source>PJC</source>]</p>

<p><note><hand/  <ex>Lemmatization</ex> of search words in a computerized Information Retrieval System may allow more effective retrieval of documents of interest to the searcher.</note><br/
[<source>PJC</source>]</p>

<p><ent>lemmatize</ent><br/
<hw>lem"ma*tize</hw> <pr>(l<ecr/m"m<adot/*t<imac/z`)</pr>, <pos>v. t.</pos> <def>To convert into a lemma{2}; to normalize the form of (a word) to that form used as the headword in a dictionary, glossary, or index; <as>as, <ldquo/ride<rdquo/ is the <ex>lemmatized</ex> form for <ldquo/riding<rdquo/ and <ldquo/ridden<rdquo/</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lemman</ent><br/
<hw>Lem"man</hw> <pr>(l<ecr/m"m<ait/n)</pr>, <pos>n.</pos> <def>A leman.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemming</ent><br/
<hw>Lem"ming</hw> <pr>(l<ecr/m"m<icr/ng)</pr>, <pos>n.</pos> <ety>[Nor. <ets>lemming</ets>, <ets>lemende</ets>; cf. Sw. <ets>lemel</ets>, Lapp. <ets>lummik</ets>.]</ety> <fld>(Zool.)</fld> <def>Any one of several species of small arctic rodents of the genera <gen>Myodes</gen> and <gen>Cuniculus</gen>, resembling the meadow mice in form. They are found in both hemispheres.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The common Northern European lemming (<spn>Myodes lemmus</spn>) is remarkable for making occasional devastating migrations in enormous numbers from the mountains into the lowlands.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemna</ent><br/
<hw>Lemna</hw> <pos>n.</pos> <def>A genus of minute acquatic herbs floating on or below the water surface of still water consisting of a leaflike frond or plant body and single root.</def><br/
<syn><b>Syn. --</b> genus <gen>Lemna</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lemnaceae</ent><br/
<hw>Lemnaceae</hw> <pos>n.</pos> <def>A natural family of small free-floating thalloid plants.</def><br/
<syn><b>Syn. --</b> family <fam>Lemnaceae</fam>, duckweed family.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lemnian</ent><br/
<hw>Lem"ni*an</hw> <pr>(l<ecr/m"n<icr/*<ait/n)</pr>, <pos>a.</pos> <ety>[L. <ets>Lemnius</ets>, fr. <ets>Lemnus</ets>, Gr. <grk>Lh^mnos</grk>.]</ety> <def>Of or pertaining to the isle of Lemnos.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Lemnian bole</b></col>, <col><b>Lemnian earth</b></col></mcol>, <cd>an aluminous earth of a grayish yellow color; sphragide; -- formerly sold as medicine, having astringent properties.</cd> -- <col><b>Lemnian reddle</b></col>, <cd>a reddle of firm consistence and deep red color; -- used by artificers in coloring.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemniscate</ent><br/
<ent>Lemniscata</ent><br/
<mhw>{ <hw>Lem`nis*ca"ta</hw> <pr>(l<ecr/m`n<icr/s*k<amac/"t<adot/)</pr>, <hw>Lem*nis"cate</hw> <pr>(l<ecr/m*n<icr/s"k<asl/t)</pr>, }</mhw> <pos>n.</pos> <ety>[L. <ets>lemniscatus</ets> adorned with ribbons, fr. <ets>lemniscus</ets> a ribbon hanging down, Gr. <grk>lhmni`skos</grk>.]</ety> <fld>(Geom.)</fld> <def>A curve in the form of the figure 8, with both parts symmetrical, generated by the point in which a tangent to an equilateral hyperbola meets the perpendicular on it drawn from the center.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemniscus</ent><br/
\'d8<hw>Lem*nis"cus</hw> <pr>(l<ecr/m*n<icr/s"k<ucr/s)</pr>, <pos>n.</pos>; <plu><it>pl.</it></plu> <plw>Lemnisci</plw> <pr>(-s<imac/)</pr> <pos>n.</pos><ety>[L. See <er>Lemniscata</er>.]</ety> <fld>(Zool.)</fld> <def>One of two oval bodies hanging from the interior walls of the body in the Acanthocephala.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemon</ent><br/
<hw>Lem"on</hw> <pr>(l<ecr/m"<ucr/n)</pr>, <pos>n.</pos> <ety>[F. <ets>limon</ets>, Per. <ets>l<imac/m<umac/n</ets>; cf. Ar. <ets>laim<umac/n</ets>, Sp. <ets>limon</ets>, It. <ets>limone</ets>. Cf. <er>Lime</er> a fruit.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Bot.)</fld> <def>An oval or roundish fruit resembling the orange, and containing a pulp usually intensely acid. It is produced by a tropical tree of the genus <gen>Citrus</gen>, the common fruit known in commerce being that of the species <spn>Citrus Limonum</spn> or <spn>Citrus Medica</spn> (var. <varn>Limonum</varn>). There are many varieties of the fruit, some of which are sweet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The tree which bears lemons; the lemon tree.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lemon grass</b></col> <fld>(Bot.)</fld>, <cd>a fragrant East Indian grass (<spn>Andropogon Sh<oe/nanthus</spn>, and perhaps other allied species), which yields the grass oil used in perfumery.</cd> -- <col><b>Lemon sole</b></col> <fld>(Zool.)</fld>, <cd>a yellow European sole (<spn>Solea aurantiaca</spn>).</cd> -- <col><b>Salts of lemon</b></col> <fld>(Chem.)</fld>, <cd>a white crystalline substance, inappropriately named, as it consists of an acid potassium oxalate and contains no citric acid, which is the characteristic acid of lemon; -- called also <altname>salts of sorrel</altname>. It is used in removing ink stains. See <cref>Oxalic acid</cref>, under <er>Oxalic</er>.</cd> <mark>[Colloq.]</mark></cs></p>

<p><-- Lemon adj. 1. of the color lemon-yellow. 2. of or relating to lemons, as lemon pie. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemonade</ent><br/
<hw>Lem`on*ade"</hw> <pr>(l<ecr/m`<ucr/n*<amac/d")</pr>, <pos>n.</pos> <ety>[F. <ets>limonade</ets>; cf. Sp. <ets>limonada</ets>, It. <ets>limonata</ets>. See <er>Lemon</er>.]</ety> <def>A beverage consisting of lemon juice mixed with water and sweetened.</def> <ldquo/If you have lemons, make <xex>lemonade</xex><rdquo/ <br/
[<source>1913 Webster</source>]</p>

<p><ent>lemonwood</ent><br/
<hw>lemonwood</hw> <pos>n.</pos> <sn>1.</sn> <def>hard tough elastic wood of the lemonwood tree; used for making bows and fishing rods.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A South African evergreen having hard tough wood.</def><br/
<syn><b>Syn. --</b> lemonwood tree, <spn>Psychotria capensis</spn> .</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lemony</ent><br/
<hw>lemony</hw> <pos>adj.</pos> <sn>1.</sn> <def>tasting like lemons.</def><br/
<syn><b>Syn. --</b> sourish, tangy, tart.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lemur</ent><br/
<hw>Le"mur</hw> <pr>(l<emac/"m<ucr/r)</pr>, <pos>n.</pos> <ety>[L., a ghost, specter. So called on account of its habit of going abroad by night.]</ety> <fld>(Zool.)</fld> <def>One of a family (<fam>Lemurid<ae/</fam>) of nocturnal mammals allied to the monkeys, but of small size, and having a sharp and foxlike muzzle, and large eyes. They feed upon birds, insects, and fruit, and are mostly natives of Madagascar and the neighboring islands, one genus (<gen>Galago</gen>) occurring in Africa.  The slow lemur or <stype>kukang</stype> of the East Indies is <spn>Nycticebus tardigradus</spn>. See <er>Galago</er>, <er>Indris</er>, and <er>Colugo</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemures</ent><br/
\'d8<hw>Lem"u*res</hw> <pr>(l<ecr/m"<usl/*r<emac/z; E. l<emac/"m<umac/rz)</pr>, <pos>n. pl.</pos> <ety>[L. See <er>Lemur</er>.]</ety> <def>Spirits or ghosts of the departed; specters.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Lars and <qex>Lemures</qex> moan with midnight plaint.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemuria</ent><br/
<hw>Le*mu"ri*a</hw> <pr>(l<esl/*m<umac/"r<icr/*<adot/)</pr>, <pos>n.</pos> <ety>[So named from the supposition that it was the original home of the <ets>lemurs</ets>.]</ety> <def>A hypothetical land, or continent, supposed by some to have existed formerly in the Indian Ocean, of which Madagascar is a remnant.</def> <rj><au>Herschel.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemurid</ent><br/
<hw>Lem"u*rid</hw> <pr>(l<ecr/m"<usl/*r<icr/d)</pr>, <pos>a. & n.</pos> <fld>(Zool.)</fld> <def>Same as <er>Lemuroid</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemurine</ent><br/
<ent>Lemuridous</ent><br/
<mhw>{ <hw>Le*mu"ri*dous</hw> <pr>(l<esl/*m<umac/"r<icr/*d<ucr/s)</pr>, <hw>Lem"u*rine</hw> <pr>(l<ecr/m"<usl/*r<icr/n <or/ -r<imac/n)</pr>, }</mhw> <pos>a.</pos> <fld>(Zool.)</fld> <def>Lemuroid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemuroid</ent><br/
<hw>Lem"u*roid</hw> <pr>(l<ecr/m"<usl/*roid)</pr>, <pos>a.</pos> <ety>[<ets>Lemur</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Like or pertaining to the lemurs or the <ord>Lemuroidea</ord>.</def> -- <def2><pos>n.</pos> <def>One of the Lemuroidea.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lemuroidea</ent><br/
\'d8<hw>Lem`u*roi"de*a</hw> <pr>(l<ecr/m`<usl/*roi"d<esl/*<adot/)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Lemur</er>, and <er>-oid</er>.]</ety> <fld>(Zool.)</fld> <def>A suborder of primates, including the lemurs, the aye-aye, and allied species.</def> <altsp>[Written also <asp>Lemuroida</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lena</ent><br/
\'d8<hw>Le"na</hw> <pr>(l<emac/"n<adot/)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>A procuress.</def> <rj><au>J. Webster.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenard rays</ent><br/
<hw>Le*nard" rays</hw> <pr>(?)</pr> <pos>n.</pos> <fld>(Physics.)</fld> <def>Rays emanating from the outer surface of a plate composed of any material permeable by cathode rays, as aluminium, which forms a portion of a wall of a vacuum tube, or which is mounted within the tube and exposed to radiation from the cathode. Lenard rays are similar in all their known properties to cathode rays. So called from the German physicist Philipp Lenard (b. 1862), who first described them.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lenard tube</ent><br/
<hw>Lenard tube</hw>. <fld>(Elec.)</fld> <def>A tube for producing Lenard rays.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lend</ent><br/
<hw>Lend</hw> <pr>(l<ecr/nd)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lent</conjf> <pr>(l<ecr/nt)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lending</conjf>.]</vmorph> <ety>[OE. <ets>lenen</ets>, AS. <ets>l<aemac/nan</ets>, fr. <ets>l<aemac/n</ets> loan; akin to G. <ets>lehnen</ets> to lend. See <er>Loan</er>.]</ety> <sn>1.</sn> <def>To allow the custody and use of, on condition of the return of the same; to grant the temporary use of; <as>as, to <ex>lend</ex> a book</as>; -- opposed to <contr>borrow</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Give me that ring.<br/
I'll <qex>lend</qex> it thee, my dear, but have no power<br/
To give it from me.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To allow the possession and use of, on condition of the return of an equivalent in kind; <as>as, to <ex>lend</ex> money or some article of food</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou shalt not give him thy money upon usury, nor <qex>lend</qex> him thy victuals for increase.</q> <rj><qau>Levit. xxv. 37.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To afford; to grant or furnish in general; <as>as, to <ex>lend</ex> assistance; to <ex>lend</ex> one's name or influence.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Cato, <qex>lend</qex> me for a while thy patience.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Mountain lines and distant horizons <qex>lend</qex> space and largeness to his compositions.</q> <rj><qau>J. A. Symonds.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To let for hire or compensation; <as>as, to <ex>lend</ex> a horse or gig</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This use of the word is rare in the United States, except with reference to money.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To lend a hand</b></col>, <cd>to give assistance; to help.</cd> <mark>[Colloq.]</mark> -- <mcol><col><b>To lend one's ears</b></col> <it>or</it> <col><b>To lend an ear</b></col></mcol>, <cd>to give attention.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lendable</ent><br/
<hw>Lend"a*ble</hw> <pr>(-<adot/*b'l)</pr>, <pos>a.</pos> <def>Such as can be lent.</def> <rj><au>Sherwood.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lender</ent><br/
<hw>Lend"er</hw> <pr>(-<etil/r)</pr>, <pos>n.</pos> <def>One who lends.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The borrower is servant to the <qex>lender</qex>. </q> <rj><qau>Prov. xxii. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lendes</ent><br/
<hw>Lend"es</hw> <pr>(l<ecr/nd"<ecr/z)</pr>, <pos>n. pl.</pos> <def>See <er>Lends</er>.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lending</ent><br/
<hw>Lend"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of one who lends.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is lent or furnished.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lend-lease</ent><br/
<hw>lend-lease</hw> <pos>n.</pos> <def>the temporary transfer of goods and services to an ally to aid in a common cause; <as>as, <ex>lend-lease</ex> during World War II was extremely generous</as>.</def><br/
<syn><b>Syn. --</b> lease-lend.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lends</ent><br/
<hw>Lends</hw> <pr>(l<ecr/ndz)</pr>, <pos>n. pl.</pos> <ety>[AS. <ets>lend</ets>, <ets>lenden</ets>; akin to D. & G. <ets>lende</ets>, OHG. <ets>lenti</ets>, Icel. <ets>lend</ets>, and perh to E. <ets>loin</ets>.]</ety> <def>Loins.</def> <mark>[Obs.]</mark> <rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lene</ent><br/
<hw>Lene</hw> <pr>(l<emac/n)</pr>, <pos>v. t.</pos> <ety>[See <er>Lend</er>.]</ety> <def>To lend; to grant; to permit.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lene</ent><br/
<hw>Le"ne</hw> <pr>(l<emac/"n<esl/)</pr>, <pos>a.</pos> <ety>[L. <ets>lenis</ets> smooth.]</ety> <fld>(Phonetics)</fld> <sd>(a)</sd> <def>Smooth; <as>as, the <ex>lene</ex> breathing</as>.</def> <sd>(b)</sd> <def>Applied to certain mute consonants, as <it>p</it>, <it>k</it>, and <it>t</it> (or Gr. <pi/, <kappa/, <tau/).</def> <rj><au>W. E. Jelf.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lene</ent><br/
<hw>Le"ne</hw>, <pos>n.</pos> <fld>(Phonetics)</fld> <sd>(a)</sd> <def>The smooth breathing (spiritus lenis).</def> <sd>(b)</sd> <def>Any one of the lene consonants, as <it>p</it>, <it>k</it>, or <it>t</it> (or Gr. <pi/, <kappa/, <tau/).</def> <rj><au>W. E. Jelf.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lengest</ent><br/
<ent>Lenger</ent><br/
<mhw>{ <hw>Leng"er</hw> <pr>(l<ecr/ng"<etil/r)</pr>, <hw>Leng"est</hw> }</mhw>, <pos>a.</pos> <def>Longer; longest; -- obsolete compar. and superl. of <xex>long</xex>.</def> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Length</ent><br/
<hw>Length</hw> <pr>(l<ecr/ngth)</pr>, <pos>n.</pos> <ety>[OE. <ets>lengthe</ets>, AS. <ets>leng<edh/</ets>, fr. <ets>lang</ets>, <ets>long</ets>, long; akin to D. <ets>lengte</ets>, Dan. <ets>l<ae/ngde</ets>, Sw. <ets>l<aum/ngd</ets>, Icel. <ets>lengd</ets>. See <er>Long</er>, <pos>a.</pos> ]</ety> <sn>1.</sn> <def>The longest, or longer, dimension of any object, in distinction from <contr>breadth</contr> or <contr>width</contr>; extent of anything from end to end; the longest line which can be drawn through a body, parallel to its sides; <as>as, the <ex>length</ex> of a church, or of a ship; the <ex>length</ex> of a rope or line.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A portion of space or of time considered as measured by its length; -- often in the plural.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Large <qex>lengths</qex> of seas and shores.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The future but a <qex>length</qex> behind the past.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The quality or state of being long, in space or time; extent; duration; <as>as, some sea birds are remarkable for the <ex>length</ex> of their wings; he was tired by the <ex>length</ex> of the sermon, and the <ex>length</ex> of his walk.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A single piece or subdivision of a series, or of a number of long pieces which may be connected together; <as>as, a <ex>length</ex> of pipe; a <ex>length</ex> of fence.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Detail or amplification; unfolding; continuance as, to pursue a subject to a great <xex>length</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>May Heaven, great monarch, still augment your bliss<br/
With <qex>length</qex> of days, and every day like this.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Distance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He had marched to the <qex>length</qex> of Exeter.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>At length</b></col>. <sd>(a)</sd> <cd>At or in the full extent; without abbreviation; as, let the name be inserted <xex>at length</xex>.</cd> <sd>(b)</sd> <cd>At the end or conclusion; after a long period. See <sc>Syn.</sc> of <xex>At last</xex>, under <er>Last</er>.</cd> -- <col><b>At arm's length</b></col>. <cd>See under <er>Arm</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Length</ent><br/
<hw>Length</hw>, <pos>v. t.</pos> <def>To lengthen.</def> <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lengthen</ent><br/
<hw>Length"en</hw> <pr>(-'n)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lengthened</conjf> <pr>(-'nd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lengthening</conjf> <pr>(-'n*<icr/ng)</pr>.]</vmorph> <def>To extent in length; to make longer in extent or duration; <as>as, to <ex>lengthen</ex> a line or a road; to <ex>lengthen</ex> life; -- sometimes followed by <ptcl>out</ptcl>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>What if I please to <qex>lengthen</qex> out his date.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lengthen</ent><br/
<hw>Length"en</hw>, <pos>v. i.</pos> <def>To become longer.</def> <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lengthful</ent><br/
<hw>Length"ful</hw> <pr>(-f<usdot/l)</pr>, <pos>a.</pos> <def>Long.</def> <mark>[Obs.]</mark> <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lengthily</ent><br/
<hw>Length"i*ly</hw> <pr>(-<icr/*l<ycr/)</pr>, <pos>adv.</pos> <def>In a lengthy manner; at great length or extent.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lengthiness</ent><br/
<hw>Length"i*ness</hw>, <pos>n.</pos> <def>The state or quality of being lengthy; prolixity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lengthwise</ent><br/
<ent>Lengthways</ent><br/
<mhw>{ <hw>Length"ways`</hw> <pr>(-w<amac/z`)</pr>, <hw>Length"wise`</hw> <pr>(-w<imac/z`)</pr>, }</mhw> <pos>adv.</pos> <def>In the direction of the length; running or extending in the direction of the length of a thing; in a longitudinal direction.  Contrasted with <ant>crosswise</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lengthy</ent><br/
<hw>Length"y</hw> <pr>(-<ycr/)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Lengthier</adjf> <pr>(-<icr/*<etil/r)</pr>; <pos>superl.</pos> <adjf>Lengthiest</adjf>.]</amorph> <def>Having length; rather long or too long; prolix; not brief; -- said chiefly of discourses, writings, and the like.</def> <ldquo/<xex>Lengthy</xex> periods.<rdquo/ <au>Washington.</au> <ldquo/Some <xex>lengthy</xex> additions.<rdquo/ <au>Byron.</au> <ldquo/These would be details too <xex>lengthy</xex>.<rdquo/ <au>Jefferson.</au> <ldquo/To cut short <xex>lengthy</xex> explanations.<rdquo/ <rj><au>Trench.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leniency</ent><br/
<ent>Lenience</ent><br/
<mhw>{ <hw>Le"ni*ence</hw> <pr>(l<emac/"n<icr/*<eit/ns <or/ l<emac/n"y<eit/ns; 106)</pr>, <hw>Le"ni*en*cy</hw> <pr>(l<emac/"n<icr/*<eit/n*s<ycr/ <or/ l<emac/n"y<eit/n*s<ycr/)</pr>, }</mhw> <pos>n.</pos> <def>The quality or state of being lenient; lenity; clemency.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenient</ent><br/
<hw>Le"ni*ent</hw> <pr>(l<emac/"n<icr/*<eit/nt <or/ l<emac/n"y<eit/nt)</pr>, <pos>a.</pos> <ety>[L. <ets>leniens</ets>, <ets>-entis</ets>, p. pr. of <ets>lenire</ets> to soften, fr. <ets>lenis</ets> soft, mild. Cf. <er>Lithe</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Relaxing; emollient; softening; assuasive; -- sometimes followed by <xex>of</xex>.</def> <ldquo/<xex>Lenient</xex> of grief.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>O<?/<?/ relax the fibers, are <qex>lenient</qex>, balsamic.</q> <rj><qau>Arbuthnot.</qau></rj> <-- illegible: oils? --><br/
[<source>1913 Webster</source>]</p>

<p><q>Time, that on all things lays his <qex>lenient</qex> hand.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Mild; clement; merciful; not rigorous or severe; <as>as, a <ex>lenient</ex> disposition; a <ex>lenient</ex> judge or sentence.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenient</ent><br/
<hw>Le"ni*ent</hw>, <pos>n.</pos> <fld>(Med.)</fld> <def>A lenitive; an emollient.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leniently</ent><br/
<hw>Le"ni*ent*ly</hw>, <pos>adv.</pos> <def>In a lenient manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenify</ent><br/
<hw>Len"i*fy</hw> <pr>(l<ecr/n"<icr/*f<imac/)</pr>, <pos>v. t.</pos> <ety>[L. <ets>lenis</ets> soft, mild + <ets>-fy</ets>: cf. F. <ets>l<eacute/nifier</ets>.]</ety> <def>To assuage; to soften; to mitigate; to alleviate.</def> <rj><au>Bacon.</au> <au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leniment</ent><br/
<hw>Len"i*ment</hw> <pr>(-m<eit/nt)</pr>, <pos>n.</pos> <ety>[L. <ets>lenimentum</ets>: cf. OF. <ets>leniment</ets>. See <er>Lenient</er>.]</ety> <def>An assuasive.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leningrad</ent><br/
<hw>Leningrad</hw> <pos>prop. n.</pos> <def>A city in the European part of Soviet Russia; the former capital of Russia.  The name was formerly <altname>St. Petersburg</altname> and <altname>Petrograd</altname>, and was changed back to <altname>Saint Petersburg</altname> (<tran>Sankt Peterburg</tran> in Russian) in 1992.</def><br/
<syn><b>Syn. --</b> St. Petersburg, Peterburg, Petrograd, Saint Petersburg.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Leninism</ent><br/
<hw>Leninism</hw> <pos>prop. n.</pos> <def>a form of communism based on the writings of Marx and Lenin; called also <altname>Marxism-Leninism</altname>.</def><br/
<syn><b>Syn. --</b> bolshevism, collectivism, Marxism-Leninism, Marxism, Sovietism, sovietism.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lenitive</ent><br/
<hw>Len"i*tive</hw> <pr>(-t<icr/v)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>l<eacute/nitif</ets>. See <er>Lenient</er>.]</ety> <def>Having the quality of softening or mitigating, as pain or acrimony; assuasive; emollient.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenitive</ent><br/
<hw>Len"i*tive</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>l<eacute/nitif</ets>.]</ety> <sn>1.</sn> <fld>(Med.)</fld> <sd>(a)</sd> <def>A medicine or application that has the quality of easing pain or protecting from the action of irritants.</def> <sd>(b)</sd> <def>A mild purgative; a laxative.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which softens or mitigates; that which tends to allay passion, excitement, or pain; a palliative.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There is one sweet <qex>lenitive</qex> at least for evils, which Nature holds out; so I took it kindly at her hands, and fell asleep.</q> <rj><qau>Sterne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenitiveness</ent><br/
<hw>Len"i*tive*ness</hw>, <pos>n.</pos> <def>The quality of being lenitive.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenitude</ent><br/
<hw>Len"i*tude</hw> <pr>(-t<umac/d)</pr>, <pos>n.</pos> <ety>[L. <ets>lenitudo</ets>.]</ety> <def>The quality or habit of being lenient; lenity.</def> <mark>[Obs.]</mark> <rj><au>Blount.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenity</ent><br/
<hw>Len"i*ty</hw> <pr>(-t<ycr/)</pr>, <pos>n.</pos> <ety>[L. <ets>lenitas</ets>, fr. <ets>lenis</ets> soft, mild: cf. OF. <ets>lenit<eacute/</ets>. See <er>Lenient</er>.]</ety> <def>The state or quality of being lenient; mildness of temper or disposition; gentleness of treatment; softness; tenderness; clemency; -- opposed to <ant>severity</ant> and <ant>rigor</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His exceeding <qex>lenity</qex> disposes us to be somewhat too severe.</q> <rj><qau>Macaulay.</qau></rj></p>

<p><syn><b>Syn.</b> -- Gentleness; kindness; tenderness; softness; humanity; clemency; mercy.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenni-Lenape</ent><br/
<hw>Len`ni-Len*a"pe</hw> <pr>(l<ecr/n`n<icr/-l<ecr/n*<aum/"p<asl/)</pr>, <pos>n. pl.</pos> <fld>(Ethnol.)</fld> <def>A general name for a group of Algonquin tribes which formerly occupied the coast region of North America from Connecticut to Virginia. They included the Mohicans, Delawares, Shawnees, and several other tribes.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 843 pr=VMG --></p>

<p><ent>Leno</ent><br/
<hw>Le"no</hw> <pr>(l<emac/"n<osl/)</pr>, <pos>n.</pos> <ety>[Cf. It. <ets>leno</ets> weak, flexible.]</ety> <def>A light open cotton fabric used for window curtains.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenocinant</ent><br/
<hw>Le*noc"i*nant</hw> <pr>(l<esl/*n<ocr/s"<icr/*n<ait/nt)</pr>, <pos>a.</pos> <ety>[L. <ets>lenocinans</ets>, p. pr. of <ets>lenocinari</ets> to pander, cajole; akin to <ets>leno</ets> pimp.]</ety> <def>Given to lewdness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lens</ent><br/
<hw>Lens</hw> <pr>(l<ecr/nz)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Lenses</plw> <pr>(-<ecr/z)</pr>.</plu> <ety>[L. <ets>lens</ets> a lentil. So named from the resemblance in shape of a double convex lens to the seed of a lentil. Cf. <er>Lentil</er>.]</ety> <fld>(Opt.)</fld> <def>A piece of glass, or other transparent substance, ground with two opposite regular surfaces, either both curved, or one curved and the other plane, and commonly used, either singly or combined, in optical instruments, for changing the direction of rays of light, and thus magnifying objects, or otherwise modifying vision. In practice, the curved surfaces are usually spherical, though rarely cylindrical, or of some other figure.</def><br/
[<source>1913 Webster</source>]</p>

<p><figure><figtitle>Lenses</figtitle></figure><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Of spherical lenses, there are six varieties, as shown in section in the figures herewith given: viz., <figref>a</figref> plano-concave; <figref>b</figref> double-concave; <figref>c</figref> plano-convex; <figref>d</figref> double-convex; <figref>e</figref> converging concavo-convex, or converging meniscus; <figref>f</figref> diverging concavo-convex, or diverging meniscus.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Crossed lens</b></col> <fld>(Opt.)</fld>, <cd>a double-convex lens with one radius equal to six times the other.</cd> -- <col><b>Crystalline lens</b></col>. <fld>(Anat.)</fld> <cd>See <er>Eye</er>.</cd> -- <col><b>Fresnel lens</b></col> <fld>(Opt.)</fld>, <cd>a compound lens formed by placing around a central convex lens rings of glass so curved as to have the same focus; used, especially in lighthouses, for concentrating light in a particular direction; -- so called from the inventor.</cd> -- <mcol><col><b>Multiplying lens</b></col> <it>or</it> <col><b>Multiplying glass</b></col></mcol> <fld>(Opt.)</fld>, <cd>a lens one side of which is plane and the other convex, but made up of a number of plane faces inclined to one another, each of which presents a separate image of the object viewed through it, so that the object is, as it were, multiplied.</cd> -- <col><b>Polyzonal lens</b></col>. <cd>See <er>Polyzonal</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lent</ent><br/
<hw>Lent</hw> <pr>(l<ecr/nt)</pr>, <def><pos>imp. & p. p.</pos> of <er>Lend</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lent</ent><br/
<hw>Lent</hw>, <pos>n.</pos> <ety>[OE. <ets>lente</ets>, <ets>lenten</ets>, <ets>leynte</ets>, AS. <ets>lengten</ets>, <ets>lencten</ets>, spring, lent, akin to D. <ets>lente</ets>, OHG. <ets>lenzin</ets>, <ets>langiz</ets>, G. <ets>lenz</ets>, and perh. fr. AS. <ets>lang</ets> long, E. <ets>long</ets>, because at this season of the year the days lengthen.]</ety> <fld>(Eccl.)</fld> <def>A fast of forty days, beginning with Ash Wednesday and continuing till Easter, observed by some Christian churches as commemorative of the fast of our Savior.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lent lily</b></col> <fld>(Bot.)</fld>, <cd>the daffodil; -- so named from its blossoming in spring.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lent</ent><br/
<hw>Lent</hw>, <pos>a.</pos> <ety>[L. <ets>lentus</ets>; akin to <ets>lenis</ets> soft, mild: cf. F. <ets>lent</ets>. See <er>Lenient</er>.]</ety> <sn>1.</sn> <def>Slow; mild; gentle; <as>as, <ex>lenter</ex> heats</as>.</def> <mark>[Obs.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>See <er>Lento</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentamente</ent><br/
\'d8<hw>Len`ta*men"te</hw> <pr>(l<asl/n`t<adot/*m<asl/n"t<asl/; E. l<ecr/n`t<adot/*m<ecr/n"t<esl/)</pr>, <pos>adv.</pos> <ety>[It.]</ety> <fld>(Mus.)</fld> <def>Slowly; in slow time.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentando</ent><br/
\'d8<hw>Len*tan"do</hw> <pr>(l<asl/n*t<aum/n"d<osl/; E. l<ecr/n*t<acr/n"d<osl/)</pr>, <pos>a.</pos> <ety>[It., p. pr. of <ets>lentare</ets> to make slow. See <er>Lent</er>, <pos>a.</pos>]</ety> <fld>(Mus.)</fld> <def>Slackening; retarding. Same as <er>Rallentando</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenten</ent><br/
<hw>Lent"en</hw> <pr>(l<ecr/nt"'n)</pr>, <pos>n.</pos> <def>Lent.</def> <mark>[Obs.]</mark> <rj><au>Piers Plowman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenten</ent><br/
<hw>Lent"en</hw>, <pos>a.</pos> <ety>[From OE. <ets>lenten</ets> lent. See <er>Lent</er>, <pos>n.</pos> ]</ety> <sn>1.</sn> <def>Of or pertaining to the fast called Lent; used in, or suitable to, Lent; <as>as, the <ex>Lenten</ex> season</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She quenched her fury at the flood,<br/
And with a <qex>Lenten</qex> salad cooled her blood.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Spare; meager; plain; somber; unostentatious; not abundant or showy.</def> <ldquo/<xex>Lenten</xex> entertainment.<rdquo/ <ldquo/ <xex>Lenten</xex> answer.<rdquo/ <au>Shak.</au> <ldquo/ <xex>Lenten</xex> suit.<rdquo/ <au>Beau. & Fl.</au><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lenten color</b></col>, <cd>black or violet.</cd> <rj><au>F. G. Lee.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lententide</ent><br/
<hw>Lent"en*tide`</hw> <pr>(-t<imac/d`)</pr>, <pos>n.</pos> <def>The season of Lenten or Lent.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenticel</ent><br/
<hw>Len"ti*cel</hw> <pr>(l<ecr/n"t<icr/*s<ecr/l)</pr>, <pos>n.</pos> <ety>[F. <ets>lenticelle</ets>, dim. fr. L. <ets>lens</ets>, <ets>lentis</ets>, a lentil. Cf. <er>Lentil</er>.]</ety> <fld>(Bot.)</fld> <sd>(a)</sd> <def>One of the small, oval, rounded spots upon the stem or branch of a plant, from which the underlying tissues may protrude or roots may issue, either in the air, or more commonly when the stem or branch is covered with water or earth.</def> <sd>(b)</sd> <def>A small, lens-shaped gland on the under side of some leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenticellate</ent><br/
<hw>Len`ti*cel"late</hw> <pr>(l<ecr/n`t<icr/*s<ecr/l"l<asl/t)</pr>, <pos>a.</pos> <fld>(Bot.)</fld> <def>Producing lenticels; dotted with lenticels.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenticelle</ent><br/
<hw>Len`ti*celle"</hw> <pr>(l<ecr/n`t<icr/*s<ecr/l")</pr>, <pos>n.</pos> <ety>[F.]</ety> <fld>(Bot.)</fld> <def>Lenticel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenticula</ent><br/
\'d8<hw>Len*tic"u*la</hw> <pr>(l<ecr/n*t<icr/k"<usl/*l<adot/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E. <plw>Lenticulas</plw> <pr>(-l<adot/z)</pr>, L. <plw>Lenticul<ae/</plw> <pr>(-l<emac/)</pr>.</plu> <ety>[L. See <er>Lenticel</er>.]</ety> <sn>1.</sn> <fld>(Med.)</fld> <def>A kind of eruption upon the skin; lentigo; freckle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Opt.)</fld> <def>A lens of small size.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>A lenticel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenticular</ent><br/
<hw>Len*tic"u*lar</hw> <pr>(-l<etil/r)</pr>, <pos>a.</pos> <ety>[L. <ets>lenticularis</ets>: cf. F. <ets>lenticulaire</ets>. See <er>Lenticel</er>.]</ety> <def>Resembling a lentil in size or form; having the form of a double-convex lens.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lenticularly</ent><br/
<hw>Len*tic"u*lar*ly</hw>, <pos>adv.</pos> <def>In the manner of a lens; with a curve.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentiform</ent><br/
<hw>Len"ti*form</hw> <pr>(l<ecr/n"t<icr/*f<ocir/rm)</pr>, <pos>a.</pos> <ety>[L. <ets>lens</ets>, <ets>lentis</ets>, lentil + <ets>-form</ets>: cf. F. <ets>lentiforme</ets>.]</ety> <def>Lenticular.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentiginose</ent><br/
<hw>Len*tig"i*nose`</hw> <pr>(l<ecr/n*t<icr/j"<icr/*n<omac/s`)</pr>, <pos>a.</pos> <ety>[See <er>Lentiginous</er>.]</ety> <fld>(Bot.)</fld> <def>Bearing numerous dots resembling freckles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentiginous</ent><br/
<hw>Len*tig"i*nous</hw> <pr>(-n<ucr/s)</pr>, <pos>a.</pos> <ety>[L. <ets>lentiginosus</ets>. See <er>Lentigo</er>.]</ety> <def>Of or pertaining to lentigo; freckly; scurfy; furfuraceous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentigo</ent><br/
\'d8<hw>Len*ti"go</hw> <pr>(l<ecr/n*t<imac/"g<osl/)</pr>, <pos>n.</pos> <ety>[L., fr. <ets>lens</ets>, <ets>lentis</ets>, lentil.]</ety> <fld>(Med.)</fld> <def>A freckly eruption on the skin; freckles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentil</ent><br/
<hw>Len"til</hw> <pr>(l<ecr/n"t<icr/l)</pr>, <pos>n.</pos> <ety>[F. <ets>lentille</ets>, fr. L. <ets>lenticula</ets>, dim. of <ets>lens</ets>, <ets>lentis</ets>, lentil. Cf. <er>Lens</er>.]</ety> <fld>(Bot.)</fld> <def>A leguminous plant of the genus <gen>Ervum</gen> (<spn>Ervum Lens</spn>), of small size, common in the fields in Europe. Also, its seed, which is used for food on the continent.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>lentil</xex> of the Scriptures probably included several other vetchlike plants.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lentil shell</b></col> <fld>(Zool.)</fld>, <cd>a small bivalve shell of the genus <gen>Ervillia</gen>, family <fam>Tellinid<ae/</fam>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentinus</ent><br/
<hw>Lentinus</hw> <pos>n.</pos> <def>The most important genus of mushrooms in the Far East.</def><br/
<syn><b>Syn. --</b> genus <gen>Lentinus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lentisk</ent><br/
<ent>Lentiscus</ent><br/
<mhw>{ <hw>Len*tis"cus</hw> <pr>(l<ecr/n*t<icr/s"k<ucr/s)</pr>, <hw>Len"tisk</hw> <pr>(l<ecr/n"t<icr/sk)</pr>, }</mhw> <pos>n.</pos> <ety>[L. <ets>lentiscus</ets>, <ets>lentiscum</ets>: cf. F. <ets>lentisque</ets>.]</ety> <fld>(Bot.)</fld> <def>A tree; the mastic. See <er>Mastic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lentissimo</ent><br/
<hw>lentissimo</hw> <pos>a. & adv.</pos> <fld>(Music)</fld> <def>very slow; very slowly; -- of music tempo.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lentitude</ent><br/
<hw>Len"ti*tude</hw> <pr>(l<ecr/n"t<icr/*t<umac/d)</pr>, <pos>n.</pos> <ety>[L. <ets>lentitudo</ets>, fr. <ets>lentus</ets> slow: cf. OF. <ets>lentitude</ets>. See <er>Lent</er>, <pos>a.</pos>]</ety> <def>Slowness; sluggishness.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lento</ent><br/
\'d8<hw>Len"to</hw> <pr>(l<asl/n"t<osl/; E. l<ecr/n"t<osl/)</pr>, <pos>a. & adv.</pos> <ety>[It.]</ety> <fld>(Mus.)</fld> <def>Slow; in slow time; slowly; -- rarely written <altname>lente</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentoid</ent><br/
<hw>Len"toid</hw> <pr>(l<ecr/n"toid)</pr>, <pos>a.</pos> <ety>[<ets>Lens</ets> + <ets>-oid</ets>.]</ety> <def>Having the form of a lens; lens-shaped.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentor</ent><br/
\'d8<hw>Len"tor</hw> <pr>(-t<ocr/r)</pr>, <pos>n.</pos> <ety>[L., fr. <ets>lentus</ets> pliant, tough, slow. See <er>Lent</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>Tenacity; viscidity, as of fluids.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Slowness; delay; sluggishness.</def> <au>Arbuthnot.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lentous</ent><br/
<hw>Len"tous</hw> <pr>(-t<ucr/s)</pr>, <pos>a.</pos> <ety>[L. <ets>lentus</ets>. See <er>Lentor</er>.]</ety> <def>Viscid; viscous; tenacious.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Spawn of a <qex>lentous</qex> and transparent body.</q> <rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>L'envoy</ent><br/
<ent>L'envoi</ent><br/
<mhw>\'d8<hw>L'en`voi"</hw>, <it>or</it> <hw>L'en`voy"</hw> <pr>(l<aum/n`vw<aum/")</pr></mhw>, <pos>n.</pos> <ety>[F. <ets>le</ets> the + <ets>envoi</ets> a sending. See <er>Envoy</er>.]</ety> <sn>1.</sn> <def>One or more detached verses at the end of a literary composition, serving to convey the moral, or to address the poem to a particular person; -- orig. employed in old French poetry.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A conclusion; a result.</def> <rj><au>Massinger.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leo</ent><br/
\'d8<hw>Le"o</hw> <pr>(l<emac/"<omac/)</pr>, <pos>n.</pos> <ety>[L. See <er>Lion</er>.]</ety> <fld>(Astron.)</fld> <sn>1.</sn> <def>The Lion, the fifth sign of the zodiac, marked thus [<Leo/] in almanacs.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A northern constellation east of Cancer, containing the bright star Regulus at the end of the handle of the Sickle.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leo Minor</b></col>, <cd>a small constellation between Leo and the Great Bear.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leod</ent><br/
<hw>Le"od</hw> <pr>(l<emac/"<ocr/d)</pr>, <pos>n.</pos> <ety>[AS. <ets>le<oacute/d</ets> people, nation, man, chief; akin to OS. <ets>liud</ets>, OHG. <ets>liut</ets>, pl. <ets>liuti</ets>, G. <ets>leute</ets>, pl., fr. AS. <ets>le<oacute/dan</ets> to grow, akin to Goth. <ets>liudan</ets>, OS. <ets>liodan</ets>, <ets>OHG</ets>. <ets>liotan</ets> to grow; cf. Skr. <ets>ruh</ets>. <root/123.]</ety> <def>People; a nation; a man.</def> <mark>[Obs.]</mark> <rj><au>Piers Plowman. Bp. Gibson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leon</ent><br/
<hw>Le"on</hw> <pr>(l<emac/"<ocr/n)</pr>, <pos>n.</pos> <def>A lion.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leonced</ent><br/
<hw>Le"onced</hw> <pr>(l<emac/"<ocr/nst)</pr>, <pos>a.</pos> <fld>(Her.)</fld> <def>See <er>Lionced</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leonese</ent><br/
<hw>Le`o*nese"</hw> <pr>(l<emac/`<osl/*n<emac/z" <it>or</it> -n<emac/s")</pr>, <pos>a.</pos> <def>Of or pertaining to Leon, in Spain.</def> -- <def2><pos>n. sing. & pl.</pos> <def>A native or natives of Leon.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leonid</ent><br/
<hw>Le"o*nid</hw> <pr>(l<emac/"<osl/*n<icr/d)</pr>, <pos>n.</pos> <ety>[From <er>Leo</er>: cf. F. <ets>l<eacute/onides</ets>, pl.]</ety> <fld>(Astron.)</fld> <def>One of the shooting stars which constitute the star shower that recurs near the fourteenth of November at intervals of about thirty-three years; -- so called because these shooting stars appear on the heavens to move in lines directed from the constellation Leo.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leonine</ent><br/
<hw>Le"o*nine</hw> <pr>(l<emac/"<osl/*n<imac/n)</pr>, <pos>a.</pos> <ety>[L. <ets>leoninus</ets>, fr. <ets>leo</ets>, <ets>leonis</ets>, lion: cf. F. <ets>l<eacute/onin</ets>. See <er>Lion</er>.]</ety> <def>Pertaining to, or characteristic of, the lion; <as>as, a <ex>leonine</ex> look; <ex>leonine</ex> rapacity.</as></def> -- <wordforms><wf>Le"o*nine*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leonine verse</b></col>, <cd>a kind of verse, in which the end of the line rhymes with the middle; -- so named from <etsep>Leo</etsep>, or <etsep>Leoninus</etsep>, a Benedictine and canon of Paris in the twelfth century, who wrote largely in this measure, though he was not the inventor. The following line is an example:</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>Gloria <xex>factorum</xex> temere conceditur <xex>horum</xex>.</q><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leonotis</ent><br/
<hw>Leonotis</hw> <pos>n.</pos> <def>A small genus of tropical herbs and subshrubs of S Africa.</def><br/
<syn><b>Syn. --</b> genus <gen>Leonotis</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leontocebus</ent><br/
<hw>Leontocebus</hw> <pos>prop. n.</pos> <def>A genus of marmosets including some of the tamarins.  Called also <altname><gen>Leontopithecus</gen></altname> and <altname><gen>Leontideus</gen></altname>.</def><br/
<syn><b>Syn. --</b> genus <gen>Leontocebus</gen>, genus <gen>Leontideus</gen>, genus <gen>Leontopithecus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leontopodium</ent><br/
<hw>Leontopodium</hw> <pos>n.</pos> <def>A genus of plants including the edelweiss (<spn>Leontopodium alpinum</spn>).</def><br/
<syn><b>Syn. --</b> genus <gen>Leontopodium</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leontodon</ent><br/
<hw>Le*on"to*don</hw> <pr>(l<esl/*<ocr/n"t<osl/*d<ocr/n)</pr>, <pos>n.</pos> <ety>[Gr. <grk>le`wn</grk>, <grk>le`ontos</grk>, lion + <grk>'odoy`s</grk>, <grk>'odo`ntos</grk>, tooth. Cf. <er>Lion's-tooth</er>, <er>Dandelion</er>.]</ety> <fld>(Bot.)</fld> <def>A genus of liguliflorous composite plants, including the fall dandelion (<spn>Leontodon autumnale</spn>), and formerly the true dandelion; -- called also <altname>lion's tooth</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leonurus</ent><br/
<hw>Leonurus</hw> <pos>n.</pos> <def>A genus of stout Old World herbs having cut-lobed leaves and flowers in whorls.</def><br/
<syn><b>Syn. --</b> genus <gen>Leonurus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leopard</ent><br/
<hw>Leop"ard</hw> <pr>(l<ecr/p"<etil/rd)</pr>, <pos>n.</pos> <ety>[OE. <ets>leopart</ets>, <ets>leparde</ets>, <ets>lebarde</ets>, <ets>libbard</ets>, OF. <ets>leopard</ets>, <ets>liepart</ets>, F. <ets>l<eacute/opard</ets>, L. <ets>leopardus</ets>, fr. Gr. <grk>leo`pardos</grk>; <grk>le`wn</grk> lion + <grk>pa`rdos</grk> pard. See <er>Lion</er>, and <er>Pard</er>.]</ety> <fld>(Zool.)</fld> <def>A large, savage, carnivorous mammal (<spn>Felis leopardus</spn>). It is of a yellow or fawn color, with rings or roselike clusters of black spots along the back and sides. It is found in Southern Asia and Africa. By some the panther (<spn>Felis pardus</spn>) is regarded as a variety of leopard.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Hunting leopard</b></col>. <cd>See <er>Cheetah</er>.</cd> --<col><b>Leopard cat</b></col> <fld>(Zool.)</fld> <cd>any one of several species or varieties of small, spotted cats found in Africa, Southern Asia, and the East Indies; esp., <spn>Felis Bengalensis</spn>.</cd> -- <col><b>Leopard marmot</b></col>. <cd>See <er>Gopher</er>, 2.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>leopardbane</ent><br/
<hw>leop"ard*bane</hw> <pr>(l<ecr/p"<etil/rd*b<amac/n`)</pr>, <pos>n.</pos> <def>Any of several herbs of the genus <gen>Doronicum</gen> (as <spn>Doronicum acaule</spn> syn. <spn>Arnica acaulis</spn>) having alternate often clasping stem leaves cultivated for their long stalks of yellow flower heads.  See <er>leopard's bane</er>.</def><br/
<syn><b>Syn. --</b> leopard's-bane, leopard's bane.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><cs><col><b>false" leop`ard*bane</b></col> <pr>(f<add/ls" l<ecr/p`<etil/rd*b<amac/n`)</pr>, <pos>n.</pos> <cd>Any of several herbs of the genus <gen>Doronicum</gen>, such as the <stype>great false leopardbane</stype> (<spn>Doronicum pardalianches</spn>) of North America and the <stype>oriental false leopardbane</stype> (<spn>Doronicum orientale</spn> syn. <spn>Doronicum caucasicum</spn>).</cd></cs><br/
[<source>PJC</source>]</p>

<p><ent>leopardess</ent><br/
<hw>leop"ard*ess</hw> <pr>(l<ecr/p"<etil/rd*<ecr/s)</pr>, <pos>n.</pos> <def>A female leopard.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leopard's bane</ent><br/
<hw>leop"ard's bane`</hw> <pr>(l<ecr/p"<etil/rdz b<amac/n`)</pr> <pos>n.</pos> <fld>(Bot.)</fld> <def>A name of several harmless plants, as <spn>Arnica montana</spn> (<spn>Arnica acaulis</spn> syn. <spn>Doronicum acaule</spn>), <spn>Senecio Doronicum</spn>, and <spn>Paris quadrifolia</spn>.</def><br/
<syn><b>Syn. --</b> leopardbane, leopard's-bane.</syn><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>leopardwood</ent><br/
<hw>leop"ard*wood`</hw>, <pos>n.</pos> <fld>(Bot.)</fld> <def>See <er>Letterwood</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lep</ent><br/
<hw>lep</hw> <pr>(l<ecr/p)</pr>, <mark>obs.</mark> <pos>strong imp.</pos> <mord>of <er>Leap</er></mord>. <def>Leaped.</def> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepadidae</ent><br/
<hw>Lepadidae</hw> <pos>prop. n.</pos> <def>A natural family of crustaceans including the goose barnacles.</def><br/
<syn><b>Syn. --</b> family <fam>Lepadidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lepadite</ent><br/
<hw>Lep"a*dite</hw> <pr>(l<ecr/p"<adot/*d<imac/t)</pr>, <pos>n.</pos> <ety>[L. <ets>lepas</ets>, <ets>lepadis</ets>, limpet, Gr. <grk>lepa`s</grk>, <grk>lepa`dos</grk>.]</ety> <fld>(Zool.)</fld> <def>Same as <er>Lepadoid</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepadoid</ent><br/
<hw>Lep"a*doid</hw> <pr>(l<ecr/p"<adot/*doid)</pr>, <pos>n.</pos> <ety>[<ets>Lepas</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>A stalked barnacle of the genus Lepas, or family <fam>Lepadid<ae/</fam>; a goose barnacle. Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepal</ent><br/
<hw>Lep"al</hw> <pr>(l<ecr/p"<ait/l)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lepi`s</grk> a scale: cf. F. <ets>l<eacute/pale</ets>.]</ety> <fld>(Bot.)</fld> <def>A sterile transformed stamen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepanto</ent><br/
<hw>Lepanto</hw> <pos>n.</pos> <def>The name of a battle in which Turkish seapower was destroyed by the Christian League in 1571.</def><br/
<syn><b>Syn. --</b> battle of Lepanto.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lepas</ent><br/
\'d8<hw>Le"pas</hw> <pr>(l<emac/"p<acr/s)</pr>, <pos>n.</pos> <ety>[L., a limpet, fr. Gr. <grk>lepa`s</grk>.]</ety> <fld>(Zool.)</fld> <def>Any one of various species of <gen>Lepas</gen>, a genus of pedunculated barnacles found attached to floating timber, bottoms of ships, Gulf weed, etc.; -- called also <altname>goose barnacle</altname>. See <er>Barnacle</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leper</ent><br/
<hw>Lep"er</hw> <pr>(l<ecr/p"<etil/r)</pr>, <pos>n.</pos> <ety>[OE. <ets>lepre</ets> leprosy, F. <ets>l<egrave/pre</ets>, L. <ets>leprae</ets>, <ets>lepra</ets>, fr. Gr. <grk>le`pra</grk>, fr. <grk>lepro`s</grk> scaly, fr. <grk>le`pos</grk> scale, <grk>le`pein</grk> to peel.]</ety> <def>A person affected with leprosy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepered</ent><br/
<hw>Lep"ered</hw> <pr>(-<etil/rd)</pr>, <pos>a.</pos> <def>Affected or tainted with leprosy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leperize</ent><br/
<hw>Lep"er*ize</hw> <pr>(l<ecr/p"<etil/r*<imac/z)</pr>, <pos>v. t.</pos> <def>To affect with leprosy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leperous</ent><br/
<hw>Lep"er*ous</hw> <pr>(-<etil/r*<ucr/s)</pr>, <pos>a.</pos> <def>Leprous; infectious; corrupting; poisonous.</def> <ldquo/The <xex>leperous</xex> distillment.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepid</ent><br/
<hw>Lep"id</hw> <pr>(-<icr/d)</pr>, <pos>a.</pos> <ety>[L. <ets>lepidus</ets>.]</ety> <def>Pleasant; jocose.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The joyous and <qex>lepid</qex> consul.</q> <rj><qau>Sydney Smith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidine</ent><br/
<hw>Lep"i*dine</hw> <pr>(l<ecr/p"<icr/*d<icr/n <it>or</it> *d<emac/n)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>An organic base, <chform>C9H6.N.CH3</chform>, metameric with quinaldine, and obtained by the distillation of cinchonine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidodendrales</ent><br/
<hw>Lepidodendrales</hw> <pos>n.</pos> <def>An order of fossil arborescent plants arising during the Lower Devonian and conspicuous throughout the Carboniferous.</def><br/
<syn><b>Syn. --</b> order <ord>Lepidodendrales</ord>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lepidodendrid</ent><br/
<hw>Lep`i*do*den"drid</hw> <pr>(l<ecr/p`<icr/*d<osl/*d<ecr/n"dr<icr/d)</pr>, <pos>n.</pos> <fld>(Paleon.)</fld> <def>One of an extinct family of trees allied to the modern club mosses, and including <gen>Lepidodendron</gen> and its allies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidodendroid</ent><br/
<hw>Lep`i*do*den"droid</hw> <pr>(-droid)</pr>, <pos>a.</pos> <fld>(Paleon.)</fld> <def>Allied to, or resembling, Lepidodendron.</def> -- <def2><pos>n.</pos> <def>A lepidodendrid.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidodendron</ent><br/
\'d8<hw>Lep`i*do*den"dron</hw> <pr>(-dr<ocr/n)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale + <grk>de`ndron</grk> tree.]</ety> <fld>(Paleon.)</fld> <def>A genus of fossil trees of the Devonian and Carboniferous ages, having the exterior marked with scars, mostly in quincunx order, produced by the separation of the leafstalks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidoganoid</ent><br/
<hw>Lep`i*do*ga"noid</hw> <pr>(l<ecr/p`<icr/*d<osl/*g<amac/"noid <it>or</it> -g<acr/n"oid)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale + E. <ets>ganoid</ets>.]</ety> <fld>(Zool.)</fld> <def>Any one of a division (<ord>Lepidoganoidei</ord>) of ganoid fishes, including those that have scales forming a coat of mail. Also used adjectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidolite</ent><br/
<hw>Le*pid"o*lite</hw> <pr>(l<esl/*p<icr/d"<osl/*l<imac/t; 277)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale + <ets>-lite</ets>: cf. F. <ets>l<eacute/pidolithe</ets>.]</ety> <fld>(Min.)</fld> <def>A species of mica, of a lilac or rose-violet color, containing lithia. It usually occurs in masses consisting of small scales. See <er>Mica</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidomelane</ent><br/
<hw>Lep`i*dom"e*lane</hw> <pr>(l<ecr/p`<icr/*d<ocr/m"<esl/*l<amac/n)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale + <grk>me`las</grk>, <grk>me`laina</grk>, black.]</ety> <fld>(Min.)</fld> <def>An iron-potash mica, of a raven-black color, usually found in granitic rocks in small six-sided tables, or as an aggregation of minute opaque scales. See <er>Mica</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidopter</ent><br/
<hw>Lep`i*dop"ter</hw> <pr>(l<ecr/p`<icr/*d<ocr/p"t<etil/r)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>l<eacute/pidopt<egrave/re</ets>.]</ety> <fld>(Zool.)</fld> <def>One of the Lepidoptera.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidoptera</ent><br/
\'d8<hw>Lep`i*dop"te*ra</hw> <pr>(-d<ocr/p"t<esl/*r<adot/)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale + <grk>ptero`n</grk> a feather, wing.]</ety> <fld>(Zool.)</fld> <def>An order of insects, which includes the butterflies and moths. They have broad wings, covered with minute overlapping scales, usually brightly colored.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ They have a tubular proboscis, or haustellum, formed by the two slender maxill<ae/. The labial palpi are usually large, and the proboscis, when not in use, can be coiled up spirally between them. The mandibles are rudimentary. The larv<ae/, called <stage>caterpillars</stage>, are often brightly colored, and they commonly feed on leaves. The adults feed chiefly on the honey of flowers.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidopterous</ent><br/
<ent>Lepidopteral</ent><br/
<mhw>{ <hw>Lep`i*dop"ter*al</hw> <pr>(-t<etil/r*<ait/l)</pr>, <hw>Lep`i*dop"ter*ous</hw> <pr>(-<ucr/s)</pr>, }</mhw> <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the Lepidoptera.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lepidopteran</ent><br/
<hw>lepidopteran</hw> <pos>a.</pos> <def>Same as <er>lepidopterous</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>lepidopteran</ent><br/
<hw>lepidopteran</hw> <pos>n.</pos> <def>An insect that in the adult state has four wings more or less covered with tiny scales; a lepidopterous insect.</def><br/
<syn><b>Syn. --</b> lepidopterous insect, lepidopteron.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lepidopterist</ent><br/
<hw>Lep`i*dop"ter*ist</hw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>One who studies the Lepidoptera.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lepidopteron</ent><br/
<hw>lepidopteron</hw> <pos>n.</pos> <def>An insect that in the adult state has four wings more or less covered with tiny scales.</def><br/
<syn><b>Syn. --</b> lepidopterous insect, lepidopteran.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lepidopterous</ent><br/
<hw>lepidopterous</hw> <pos>a.</pos>  <def>See <er>lepidopteral</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lepidosauria</ent><br/
\'d8<hw>Lep`i*do*sau"ri*a</hw> <pr>(-d<osl/*s<add/"r<icr/*<adot/)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale + <grk>say^ros</grk> a lizard.]</ety> <fld>(Zool.)</fld> <def>A division of reptiles, including the serpents and lizards; the Plagiotremata.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidosiren</ent><br/
<hw>Lep`i*do*si"ren</hw> <pr>(-s<imac/"r<ecr/n)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale + <grk>seirh`n</grk> a siren.]</ety> <fld>(Zool.)</fld> <def>An eel-shaped ganoid fish of the order Dipnoi, having both gills and lungs. It inhabits the rivers of South America. The name is also applied to a related African species (<spn>Protopterus annectens</spn>). The lepidosirens grow to a length of from four to six feet. Called also <altname>doko</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepidoted</ent><br/
<ent>Lepidote</ent><br/
<mhw>{ <hw>Lep"i*dote</hw> <pr>(l<ecr/p"<icr/*d<omac/t)</pr>, <hw>Lep"i*do`ted</hw> <pr>(-d<omac/`t<ecr/d)</pr>, }</mhw> <pos>a.</pos> <ety>[Gr. <grk>lepidwto`s</grk> covered with scales, fr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale.]</ety> <fld>(Bot.)</fld> <def>Having a coat of scurfy scales, as the leaves of the oleaster.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lepiota</ent><br/
<hw>lepiota</hw> <pos>n.</pos> <def>any fungus of the genus <gen>Lepiota</gen>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lepisma</ent><br/
\'d8<hw>Le*pis"ma</hw> <pr>(l<esl/*p<icr/z"m<adot/)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>le`pisma</grk> peel, fr. <grk>lepi`s</grk> <grk>-i`dos</grk>, a scale.]</ety> <fld>(Zool.)</fld> <def>A genus of wingless thysanurous insects having an elongated flattened body, covered with shining scales and terminated by seven unequal bristles. A common species (<spn>Lepisma saccharina</spn>) is found in houses, and often injures books and furniture; it feeds on starch and eats sized paper and starched clothes. Called also <altname>shiner</altname>, <altname>silverfish</altname>, <altname>silver witch</altname>, <altname>silver moth</altname>, and <altname>furniture bug</altname>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Lepismoid</ent><br/
<hw>Le*pis"moid</hw> <pr>(-moid)</pr>, <pos>a.</pos> <ety>[<ets>Lepisma</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Like or pertaining to the Lepisma.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepomis</ent><br/
<hw>Lepomis</hw> <pos>n.</pos> <def>A genus of freshwater sunfishes, inclding some of the breams.</def><br/
<syn><b>Syn. --</b> genus <gen>Lepomis</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leporid</ent><br/
<hw>leporid</hw> <pos>n.</pos> <def>A mammal of the family <fam>Leporidae</fam>, including the rabbits and hares.</def><br/
<syn><b>Syn. --</b> leporid mammal.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leporidae</ent><br/
<hw>Leporidae</hw> <pos>n.</pos> <def>A natural family of mammals comprising the hares and rabbits.</def><br/
<syn><b>Syn. --</b> family <fam>Leporidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>leporide</ent><br/
<hw>leporide</hw> <pos>n.</pos> <sn>1.</sn> <def>red breed of domestic rabbits, also called <altname>Belgian hare</altname>.</def><br/
<syn><b>Syn. --</b> Belgian hare.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leporine</ent><br/
<hw>Lep"o*rine</hw> <pr>(l<ecr/p"<osl/*r<imac/n <it>or</it> -r<icr/n)</pr>, <pos>a.</pos> <ety>[L. <ets>leporinus</ets>, fr. <ets>lepus</ets>, <ets>leporis</ets>, hare. See <er>Leveret</er>.]</ety> <fld>(Zool.)</fld> <def>Of or pertaining to a hare; like or characteristic of, a hare.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leppy</ent><br/
<hw>leppy</hw> <pos>n.</pos> <def>A motherless calf in a range herd of cattle.</def> <mark>[Western U. S.]</mark> <br/
<syn><b>Syn. --</b> dogie, dogy, dogey.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lepra</ent><br/
\'d8<hw>Le"pra</hw> <pr>(l<emac/"pr<adot/)</pr>, <pos>n.</pos> <ety>[L. See <er>Leper</er>.]</ety> <fld>(Med.)</fld> <def>Leprosy.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The term <xex>lepra</xex> was formerly given to various skin diseases, the leprosy of modern authors being <stype>Lepra Arabum</stype>. See <er>Leprosy</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 844 pr=VMG --></p>

<p><ent>Lepre</ent><br/
<hw>Lep"re</hw> <pr>(l<ecr/p"<etil/r)</pr>, <pos>n.</pos> <def>Leprosy.</def> <mark>[Obs.]</mark> <rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>leprechaun</ent><br/
<hw>leprechaun</hw> <pos>n.</pos> <fld>(Irish folklore)</fld>  <def>A small mischevous elf or spirit in Irish folklore; it is often depicted in literature as a dwarfish bearded old man; -- legend tells that if a leprechaun is captured, he will reveal the location of his hidden pot of gold.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Leprose</ent><br/
<hw>Lep"rose`</hw> <pr>(l<ecr/p"r<omac/s`)</pr>, <pos>a.</pos> <ety>[See <er>Leprous</er>.]</ety> <fld>(Nat. Hist.)</fld> <def>Covered with thin, scurfy scales.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leprosity</ent><br/
<hw>Le*pros"i*ty</hw> <pr>(l<esl/*pr<ocr/s"<icr/*t<ycr/)</pr>, <pos>n.</pos> <def>The state or quality of being leprous or scaly; also, a scale.</def> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leprosy</ent><br/
<hw>Lep"ro*sy</hw> <pr>(l<ecr/p"r<osl/*s<ycr/)</pr>, <pos>n.</pos> <ety>[See <er>Leprous</er>.]</ety> <fld>(Med.)</fld> <def>A cutaneous disease which first appears as blebs or as reddish, shining, slightly prominent spots, with spreading edges. These are often followed by an eruption of dark or yellowish prominent nodules, frequently producing great deformity. In one variety of the disease, an<ae/sthesia of the skin is a prominent symptom. In addition there may be wasting of the muscles, falling out of the hair and nails, and distortion of the hands and feet with destruction of the bones and joints. It is incurable, and is probably contagious.</def><-- caused by the bacterium <spn>Mycobacterium leprae</spn>, curable in most cases by therapy with a combination of antibiotics, but cases resistant to therapy are increasing. --><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The disease now called leprosy, also designated as <xex>Lepra</xex> or <xex>Lepra Arabum</xex>, and <xex>Elephantiasis Gr<ae/corum</xex>, is not the same as the leprosy of the ancients. The latter was, indeed, a generic name for many varieties of skin disease (including our modern leprosy, psoriasis, etc.), some of which, among the Hebrews, rendered a person ceremonially unclean. A variety of leprosy of the Hebrews (probably identical with modern leprosy) was characterized by the presence of smooth, shining, depressed white patches or scales, the hair on which participated in the whiteness, while the skin and adjacent flesh became insensible. It was an incurable disease.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leprous</ent><br/
<hw>Lep"rous</hw> <pr>(-r<umac/s)</pr>, <pos>a.</pos> <ety>[OF. <ets>leprous</ets>, <ets>lepros</ets>, F. <ets>l<eacute/preux</ets>, fr. L. <ets>leprosus</ets>, fr. <ets>lepra</ets>, <ets>leprae</ets>, leprosy. See <er>Leper</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Infected with leprosy; pertaining to or resembling leprosy.</def> <ldquo/His hand was <xex>leprous</xex> as snow.<rdquo/ <rj><au>Ex. iv. 6.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Nat. Hist.)</fld> <def>Leprose.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Lep"rous*ly</wf>, <pos>adv.</pos> -- <wf>Lep"rous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepry</ent><br/
<hw>Lep"ry</hw> <pr>(-r<ycr/)</pr>, <pos>n.</pos> <def>Leprosy.</def> <mark>[Obs.]</mark> <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptiform</ent><br/
<hw>Lep"ti*form</hw> <pr>(-t<icr/*f<ocir/rm)</pr>, <pos>a.</pos> <ety>[<ets>Leptus</ets> + <ets>-form</ets>.]</ety> <fld>(Zool.)</fld> <def>Having a form somewhat like leptus; -- said of active insect larvae having three pairs of legs. See <er>Larva</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptocardia</ent><br/
\'d8<hw>Lep`to*car"di*a</hw> <pr>(l<ecr/p`t<osl/*k<aum/r"d<icr/*<adot/)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>lepto`s</grk> small + <grk>kardi`a</grk> the heart.]</ety> <fld>(Zool.)</fld> <def>The lowest class of Vertebrata, including only the Amphioxus. The heart is represented only by a simple pulsating vessel. The blood is colorless; the brain, renal organs, and limbs are wanting, and the backbone is represented only by a simple, unsegmented notochord. See <er>Amphioxus</er>.</def> <altsp>[Written also <asp>Leptocardii</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptocardian</ent><br/
<hw>Lep`to*car"di*an</hw> <pr>(l<ecr/p`t<osl/*k<aum/r"d<icr/*<ait/n)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Of or pertaining to the <er>Leptocardia</er>.</def> -- <def2><pos>n.</pos> <def>One of the Leptocardia.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptocercous</ent><br/
<ent>Leptocercal</ent><br/
<mhw><hw>Lep`to*cer"cal</hw>,  <pr>(l<ecr/p`t<osl/*s<etil/r"k<ait/l)</pr>, <hw>Lep`to*cerc"ous</hw> <pr>(l<ecr/p`t<osl/*s<etil/rk"<ucr/s)</pr>,</mhw> <pos>a.</pos> <fld>(Zool.)</fld> <def>Having a long slender tail.</def><br/
[<source>PJC</source>]</p>

<p><ent>Leptodactyl</ent><br/
<hw>Lep`to*dac"tyl</hw> <pr>(l<ecr/p`t<osl/*d<acr/k"t<icr/l)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lepto`s</grk> small, thin + <grk>da`ktylos</grk> finger, toe.]</ety> <fld>(Zool.)</fld> <def>A bird or other animal having slender toes.</def> <altsp>[Written also <asp>lepodactyle</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptodactylidae</ent><br/
<hw>Leptodactylidae</hw> <pos>n.</pos> <ety>[See <er>leptodactyl</er>.]</ety> <def>A natural family of New World frogs; in some classifications it is essentially coextensive with the family <fam>Bufonidae</fam>.</def><br/
<syn><b>Syn. --</b> family <fam>Leptodactylidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leptodactylous</ent><br/
<hw>Lep`to*dac"tyl*ous</hw> <pr>(-<ucr/s)</pr>, <pos>a.</pos> <def>Having slender toes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptodactylus</ent><br/
<hw>Leptodactylus</hw> <pos>n.</pos> <def>The type genus of the <fam>Leptodactylidae</fam>; in some classifications it is placed in the family <fam>Bufonidae</fam>.</def><br/
<syn><b>Syn. --</b> genus Leptodactylus.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leptoglossus</ent><br/
<hw>Leptoglossus</hw> <pos>n.</pos> <def>A genus of leaf-footed bugs.</def><br/
<syn><b>Syn. --</b> genus <gen>Leptoglossus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leptology</ent><br/
<hw>Lep*tol"o*gy</hw> <pr>(l<ecr/p*t<ocr/l"<osl/*j<ycr/)</pr>, <pos>n.</pos> <ety>[Gr. <grk>leptologi`a</grk>; <grk>lepto`s</grk> small, subtile + <grk>lo`gos</grk> discourse.]</ety> <def>A minute and tedious discourse on trifling things.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptomeningitis</ent><br/
\'d8<hw>Lep`to*men`in*gi"tis</hw> <pr>(l<ecr/p`t<osl/*m<ecr/n`<icr/n*j<imac/"t<icr/s)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>lepto`s</grk> small + <ets>meningitis</ets>.]</ety> <fld>(Med.)</fld> <def>Inflammation of the <xex>pia mater</xex> or of the arachnoid membrane.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lepton</ent><br/
<hw>lepton</hw> <pos>n.</pos> <fld>(Physics)</fld> <def>an elementary particle that participates in weak interactions but does not participate in the strong interaction; it has a baryon number of 0.  Some known leptons are the <stype>electron</stype>, the <stype>negative muon</stype>, the <stype>tau-minus particle</stype>, and the neutrinos associated with each of these particles.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Leptopteris</ent><br/
<hw>Leptopteris</hw> <pos>n.</pos> <def>A genus including some ferns sometimes placed in genus <gen>Todea</gen>.</def><br/
<syn><b>Syn. --</b> genus <gen>Leptopteris</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leptoptilus</ent><br/
<hw>Leptoptilus</hw> <pos>n.</pos> <def>A genus of birds including the adjutant bird (<spn>Leptoptilus dubius</spn>, also called adjutant stork) and marabous.</def><br/
<syn><b>Syn. --</b> genus <gen>Leptoptilus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leptorhine</ent><br/
<hw>Lep"to*rhine</hw> <pr>(l<ecr/p"t<osl/*r<imac/n <or/ *r<icr/n)</pr>, <pos>a.</pos> <ety>[Gr. <grk>lepto`s</grk> small + <grk>"ri`s</grk>, <grk>"rino`s</grk>, the nose.]</ety> <fld>(Anat.)</fld> <def>Having the nose narrow; -- said especially of the skull.  Opposed to <contr>platyrhine</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptostraca</ent><br/
\'d8<hw>Lep*tos"tra*ca</hw> <pr>(l<ecr/p*t<ocr/s"tr<adot/*k<adot/)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. Gr. <grk>lepto`s</grk> thin, slender + <grk>'o`strakon</grk> shell of a testacean.]</ety> <fld>(Zool.)</fld> <def>An order of Crustacea, including Nebalia and allied forms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptothrix</ent><br/
\'d8<hw>Lep"to*thrix</hw> <pr>(l<ecr/p"t<osl/*thr<icr/ks)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>lepto`s</grk> small + <grk>qri`x</grk> hair.]</ety> <fld>(Biol.)</fld> <def>A genus of bacteria, characterized by having their filaments very long, slender, and indistinctly articulated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptothrix</ent><br/
\'d8<hw>Lep"to*thrix</hw>, <pos>a.</pos> <ety>[See <er>Leptothrix</er>, <pos>n.</pos> ]</ety> <fld>(Biol.)</fld> <def>Having the form of a little chain; -- applied to bacteria when, as in multiplication by fission, they form a chain of filiform individuals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptus</ent><br/
\'d8<hw>Lep"tus</hw> <pr>(l<ecr/p"t<ucr/s)</pr>, <pos>n.</pos> <ety>[NL., from Gr. <grk>lepto`s</grk> thin, small.]</ety> <fld>(Zool.)</fld> <def>The six-legged young, or larva, of certain mites; -- sometimes used as a generic name. See <cref>Harvest mite</cref>, under <er>Harvest</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leptynite</ent><br/
<hw>Lep"ty*nite</hw> <pr>(l<ecr/p"t<icr/*n<imac/t)</pr>, <pos>n.</pos> <fld>(Min.)</fld> <def>See <er>Granulite</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lepus</ent><br/
<hw>Lepus</hw> <pos>n.</pos> <def>The type genus of the <fam>Leporidae</fam>, comprising the hares.</def><br/
<syn><b>Syn. --</b> genus <fam>Lepus</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Ler</ent><br/
<hw>Ler</hw> <pos>n.</pos> <fld>(Irish mythology)</fld> <def>the sea personified; father of Manannan; corresponds to the Welsh Llyr.</def><br/
<syn><b>Syn. --</b> Lir.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lere</ent><br/
<hw>Lere</hw> <pr>(l<emac/r)</pr>, <pos>n.</pos> <ety>[See <er>Lore</er> knowledge.]</ety> <def>Learning; lesson; lore.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lere</ent><br/
<hw>Lere</hw>, <pos>v. t. & i.</pos> <ety>[OE. <ets>leeren</ets>, <ets>leren</ets>, AS. <ets>l<aemac/ran</ets>. See <er>Lore</er>, <er>Learn</er>.]</ety> <def>To learn; to teach.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lere</ent><br/
<hw>Lere</hw>, <pos>a.</pos> <def>Empty.</def> <mark>[Obs.]</mark> <see>See <er>Leer</er>, <pos>a.</pos></see><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lere</ent><br/
<hw>Lere</hw>, <pos>n.</pos> <ety>[AS. <ets>lira</ets> flesh; cf. Icel. <ets>l<ae/r</ets> thigh.]</ety> <def>Flesh; skin.</def> <mark>[Obs.]</mark> <ldquo/His white <xex>leer</xex>.<rdquo/ <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lered</ent><br/
<hw>Ler"ed</hw> <pr>(l<emac/r"<ecr/d)</pr>, <pos>a.</pos> <ety>[From <ets>lere</ets>, <pos>v. t.</pos>]</ety> <def>Learned.</def> <mark>[Obs.]</mark> <ldquo/ Lewed man or <xex>lered</xex>.<rdquo/ <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lernaea</ent><br/
\'d8<hw>Ler*n<ae/"a</hw> <pr>(l<etil/r*n<emac/"<adot/)</pr>, <pos>n.</pos> <ety>[NL., fr. L. <ets>Lernaeus</ets> Lern<ae/an, fr. <ets>Lerna</ets>, Gr. <grk>Le`rnh</grk>, a forest and marsh near Argos, the mythological abode of the hydra.]</ety> <fld>(Zool.)</fld> <def>A Linn<ae/an genus of parasitic Entomostraca, -- the same as the family <fam>Lern<ae/id<ae/</fam>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The genus is restricted by modern Zoologists to a limited number of species similar to <spn>Lern<ae/a branchialis</spn> found on the gills of the cod.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lernaeacea</ent><br/
\'d8<hw>Ler`n<ae/*a"ce*a</hw> <pr>(l<etil/r`n<esl/*<amac/"sh<esl/*<adot/)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Lern<ae/a</er>.]</ety> <fld>(Zool.)</fld> <def>A suborder of copepod Crustacea, including a large number of remarkable forms, mostly parasitic on fishes. The young, however, are active and swim freely. See <xex>Illustration</xex> in Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lernean</ent><br/
<hw>Ler*ne"an</hw> <pr>(l<etil/r*n<emac/"<ait/n)</pr>, <pos>n.</pos> <ety>[See <er>Lern<ae/a</er>.]</ety> <fld>(Zool.)</fld> <def>One of a family (<fam>Lern<ae/id<ae/</fam>) of parasitic Crustacea found attached to fishes and other marine animals. Some species penetrate the skin and flesh with the elongated head, and feed on the viscera. See <xex>Illust.</xex> in Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lerot</ent><br/
<ent>lerot</ent><br/
<mhw><hw>lerot</hw>, \'d8<hw>L<eacute/`rot"</hw></mhw> <pr>(l<asl/`r<osl/")</pr>, <pos>n.</pos> <ety>[F.]</ety> <fld>(Zool.)</fld> <def>A small rodent (<spn>Eliomys nitela</spn>) of Europe and Northern Africa, allied to the dormouse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Les</ent><br/
<hw>Les</hw> <pr>(l<ecr/s)</pr>, <pos>n.</pos> <def>A leash.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lesbian</ent><br/
<hw>Les"bi*an</hw> <pr>(l<ecr/z"b<icr/*<ait/n)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of or pertaining to the island anciently called <etsep>Lesbos</etsep>, now Mitylene, in the Grecian Archipelago.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Amatory; erotic; -- in allusion to the reputed sensuality of the Lesbian people and literature; <as>as, <ex>Lesbian</ex> novels</as>.</def> <mark>[archaic]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn> <def>Homosexual; -- applied to female homosexuals.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lesbian</ent><br/
<hw>Les"bi*an</hw> <pr>(l<ecr/z"b<icr/*<ait/n)</pr>, <pos>n.</pos> <def>A female homosexual.</def><br/
<syn><b>Syn. --</b> dyke[vulgar, deprecatory].</syn>
[<source>PJC</source>]</p>

<p><ent>Lesbianism</ent><br/
<hw>Les"bi*an*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Med.)</fld> <def>Homosexual relations between women.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lesbian love</ent><br/
<hw>Lesbian love</hw>. <def>See <er>Lesbianism</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lese</ent><br/
<hw>Lese</hw> <pr>(l<emac/z)</pr>, <pos>v. t.</pos> <def>To lose.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lese-majesty</ent><br/
<hw>Lese`-maj"es*ty</hw> <pr>(l<emac/z`-m<acr/j"<ecr/s*t<ycr/)</pr>, <pos>n.</pos> <def>See <er>Leze majesty</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lesion</ent><br/
<hw>Le"sion</hw> <pr>(l<emac/"zh<ucr/n)</pr>, <pos>n.</pos> <ety>[F. <ets>l<eacute/sion</ets>, L. <ets>laesio</ets>, fr. <ets>laedere</ets>, <ets>laesum</ets>, to hurt, injure.]</ety> <def>A hurt; an injury.</def> Specifically: <sd>(a)</sd> <fld>(Civil Law)</fld> <def>Loss sustained from failure to fulfill a bargain or contract.</def> <au>Burrill.</au> <sd>(b)</sd> <fld>(Med.)</fld> <def>Any morbid change in the exercise of functions or the texture of organs.</def> <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lespedeza</ent><br/
<hw>lespedeza</hw> <pos>n.</pos> <def>Any shrubby or herbaceous plant of the genus <gen>Lespedeza</gen>, widely used for forage, soil improvement, and especially hay in the Southern U.S.</def><br/
<syn><b>Syn. --</b> bush clover.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lesquerella</ent><br/
<hw>Lesquerella</hw> <pos>prop. n.</pos> <def>A genus of low-growing hairy herbs, comprising some of the bladderpods.</def><br/
<syn><b>Syn. --</b> genus <gen>Lesquerella</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>-less</ent><br/
<hw>-less</hw> <pr>(-l<ecr/s)</pr> <pr>suff.</pr> <ety>[AS. <ets>le<aacute/s</ets> loose, false; akin to OS. <ets>l<omac/s</ets> loose, false, D. <ets>los</ets> loose, <ets>loos</ets> false, sly, G. <ets>los</ets> loose, Icel. <ets>lauss</ets> loose, vacant, Goth. <ets>laus</ets> empty, vain, and also to E. <ets>loose</ets>, <ets>lose</ets>. <root/127. See <er>Lose</er>, and cf. <er>Loose</er>, <er>Leasing</er>.]</ety> <def>A privative adjective suffix, denoting <xex>without</xex>, <xex>destitute of</xex>, <xex>not having</xex>; as wit<xex>less</xex>, child<xex>less</xex>, father<xex>less</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Less</ent><br/
<hw>Less</hw> <pr>(l<ecr/s)</pr>, <pos>conj.</pos> <def>Unless.</def> <mark>[Obs.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Less</ent><br/
<hw>Less</hw>, <pos>a.</pos> <ety>[OE. <ets>lesse</ets>, AS. <ets>l<aemac/ssa</ets>; akin to OFries. <ets>l<emac/ssa</ets>; a compar. from a lost positive form. Cf. <er>Lesser</er>, <er>Lest</er>, <er>Least</er>. <ets>Less</ets> has the sense of the comparative degree of <ets>little</ets>.]</ety> <def>Smaller; not so large or great; not so much; shorter; inferior; <as>as, a <ex>less</ex> quantity or number; a horse of <ex>less</ex> size or value; in <ex>less</ex> time than before.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The substantive which <xex>less</xex> qualifies is often omitted; as, the purse contained <xex>less</xex> (money) than ten dollars. See <er>Less</er>, <pos>n.</pos></note><br/
[<source>1913 Webster</source>]</p>

<p><q>Thus in <qex>less</qex> [time] than a hundred years from the coming of Augustine, all England became Christian.</q> <rj><qau>E. A. Freeman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Less</ent><br/
<hw>Less</hw>, <pos>adv.</pos> <ety>[AS. <ets>l<aemac/s</ets>. See <er>Less</er>, <pos>adj.</pos>, and cf. <er>Lest</er>.]</ety> <def>Not so much; in a smaller or lower degree; <as>as, <ex>less</ex> bright or loud; <ex>less</ex> beautiful.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Less</ent><br/
<hw>Less</hw>, <pos>n.</pos> <sn>1.</sn> <def>A smaller portion or quantity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The children of Israel did so, and gathered, some more, some <qex>less</qex>.</q> <rj><qau>Ex. xvi. 17.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The inferior, younger, or smaller.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>less</qex> is blessed of the better.</q> <rj><qau>Heb. vii. 7. </qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Less</ent><br/
<hw>Less</hw>, <pos>v. t.</pos> <def>To make less; to lessen.</def> <mark>[Obs.]</mark> <rj><au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lessee</ent><br/
<hw>Les*see"</hw> <pr>(l<ecr/s*s<emac/")</pr>, <pos>n.</pos> <ety>[F. <ets>laiss<eacute/</ets>, p. p. of <ets>laisser</ets>. See <er>Lease</er>, <pos>v. t.</pos>]</ety> <fld>(Law)</fld> <def>The person to whom a lease is given, or who takes an estate by lease.</def> <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lessen</ent><br/
<hw>Less"en</hw> <pr>(l<ecr/s"'n)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lessened</conjf> <pr>(-'nd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lessening</conjf>.]</vmorph> <ety>[From <er>Less</er>, <pos>a.</pos>]</ety> <def>To make less; to reduce; to make smaller, or fewer; to diminish; to lower; to degrade; <as>as, to <ex>lessen</ex> a kingdom, or a population; to <ex>lessen</ex> speed, rank, fortune.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Charity . . . shall <qex>lessen</qex> his punishment.</q> <rj><qau>Calamy.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>St. Paul chose to magnify his office when ill men conspired to <qex>lessen</qex> it.</q> <rj><qau>Atterbury.</qau></rj></p>

<p><syn><b>Syn.</b> -- To diminish; reduce; abate; decrease; lower; impair; weaken; degrade.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lessen</ent><br/
<hw>Less"en</hw>, <pos>v. i.</pos> <def>To become less; to shrink; to contract; to decrease; to be diminished; <as>as, the apparent magnitude of objects <ex>lessens</ex> as we recede from them; his care, or his wealth, <ex>lessened</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>The objection <qex>lessens</qex> much, and comes to no more than this: there was one witness of no good reputation.</q> <rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lessener</ent><br/
<hw>Less"en*er</hw> <pr>(-<etil/r)</pr>, <pos>n.</pos> <def>One who, or that which, lessens.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His wife . . . is the <qex>lessener</qex> of his pain, and the augmenter of his pleasure.</q> <rj><qau>J. Rogers (1839). </qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>lessening</ent><br/
<hw>lessening</hw> <pos>adj.</pos> <def>becoming less in dimension or degree; <as>as, the <ex>lessening</ex> distance between us</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lessening</ent><br/
<hw>lessening</hw> <pos>n.</pos> <def>a change downward; a decrease; a reduction.</def><br/
<syn><b>Syn. --</b> decrease, drop-off.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lesser</ent><br/
<hw>Less"er</hw> <pr>(l<ecr/s"<etil/r)</pr>, <pos>a.</pos> <ety>[This word is formed by adding anew the compar. suffix <ets>-er</ets> (in which <ets>r</ets> is from an original <ets>s</ets>) to <ets>less</ets>. See <er>Less</er>, <pos>a.</pos>]</ety> <def>Less; smaller; inferior.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God made . . . the <qex>lesser</qex> light to rule the night.</q> <rj><qau>Gen. i. 15.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Lesser</xex> is used for <xex>less</xex>, now the compar. of <xex>little</xex>, in certain special instances in which its employment has become established by custom; as, <xex>Lesser</xex> Asia (i. e., Asia Minor), the <xex>lesser</xex> light, and some others; also in poetry, for the sake of the meter, and in prose where its use renders the passage more euphonious.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>The more my prayer, the <qex>lesser</qex> is my grace.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The larger here, and there the <qex>lesser</qex> lambs.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>By the same reason may a man, in the state of nature, punish the <qex>lesser</qex> breaches of the law.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lesser</ent><br/
<hw>Less"er</hw>, <pos>adv.</pos> <def>Less.</def> <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lesses</ent><br/
<hw>Les"ses</hw> <pr>(l<ecr/s"s<ecr/z)</pr>, <pos>n. pl.</pos> <ety>[F. <ets>laiss<eacute/es</ets>, from <ets>laisser</ets> to leave. See <er>Lease</er>, <pos>v. t.</pos>]</ety> <def>The leavings or dung of beasts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lesson</ent><br/
<hw>Les"son</hw> <pr>(l<ecr/s"s'n)</pr>, <pos>n.</pos> <ety>[OE. <ets>lessoun</ets>, F. <ets>le<cced/on</ets> lesson, reading, fr. L. <ets>lectio</ets> a reading, fr. <ets>legere</ets> to read, collect. See <er>Legend</er>, and cf. <er>Lection</er>.]</ety> <sn>1.</sn> <def>Anything read or recited to a teacher by a pupil or learner; something, as a portion of a book, assigned to a pupil to be studied or learned at one time.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is learned or taught by an express effort; instruction derived from precept, experience, observation, or deduction; a precept; a doctrine; <as>as, to take or give a <ex>lesson</ex> in drawing</as>.</def><ldquo/ A smooth and pleasing <xex>lesson</xex>.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Emprinteth well this <qex>lesson</qex> in your mind.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A portion of Scripture read in divine service for instruction; <as>as, here endeth the first <ex>lesson</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A severe lecture; reproof; rebuke; warning.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She would give her a <qex>lesson</qex> for walking so late.</q> <rj><qau>Sir. P. Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Mus.)</fld> <def> An exercise; a composition serving an educational purpose; a study.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lesson</ent><br/
<hw>Les"son</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lessoned</conjf> <pr>(-s'nd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lessoning</conjf>.]</vmorph> <def>To teach; to instruct.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To rest the weary, and to soothe the sad,<br/
Doth <qex>lesson</qex> happier men, and shame at least the bad.</q> <rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lessor</ent><br/
<hw>Les"sor</hw> <pr>(l<ecr/s"s<ocr/r <or/ l<ecr/s*s<ocir/r")</pr>, <pos>n.</pos> <ety>[See <er>Lessee</er>, <er>Lease</er>, <pos>v. t.</pos>]</ety> <fld>(Law)</fld> <def>One who leases; the person who lets to farm, or gives a lease.</def> <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>less-traveled</ent><br/
<hw>less-traveled</hw> <pos>adj.</pos> <def>not visited by many travelers; <as>as, the tourist's desire to visit <ex>less-traveled</ex> countries</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lest</ent><br/
<hw>Lest</hw> <pr>(l<ecr/st)</pr>, <pos>v. i.</pos> <def>To listen.</def> <mark>[Obs.]</mark> <rj><au>Chaucer. Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lest</ent><br/
<hw>Lest</hw>, <pos>n.</pos> <ety>[See List to choose.]</ety> <def>Lust; desire; pleasure.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lest</ent><br/
<hw>Lest</hw>, <pos>a.</pos> <def>Last; least.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lest</ent><br/
<hw>Lest</hw>, <pos>conj.</pos> <ety>[OE. <ets>leste</ets>, fr. AS. <ets><edh/<ymac/ l<aemac/s <edh/<emac/</ets> the less that, where <ets><edh/<ymac/</ets> is the instrumental case of the definite article, and <ets><edh/<emac/</ets> is an indeclinable relative particle, <ets>that</ets>, <ets>who</ets>, <ets>which</ets>. See <er>The</er>, <er>Less</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>For fear that; that . . . not; in order that . . . not.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Love not sleep, <qex>lest</qex> thou come to poverty.</q> <rj><qau>Prov. xx. 13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Wherefore let him that thinketh he standeth take heed <qex>lest</qex> he fall.</q> <rj><qau>1 Cor. x. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That (without the negative particle); -- after certain expressions denoting <xex>fear</xex> or <xex>apprehension</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I feared<br/
<qex>Lest</qex> I might anger thee.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lester</ent><br/
\'d8<hw>Les"ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Pg., prob. fr. Fr. <ets>l'est</ets> the east.]</ety> <fld>(Meteor.)</fld> <def>A dry sirocco in the Madeira Islands.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>-let</ent><br/
<hw>-let</hw> <pr>(-l<ecr/t)</pr> <pos>suff.</pos> <ety>[From two French dim. endings <ets>-el</ets> (L. <ets>-ellus</ets>) and <ets>-et</ets>, as in brace<ets>let</ets>.]</ety> <def>A noun suffix having a diminutive force; <as>as in stream<ex>let</ex>, wave<ex>let</ex>, arm<ex>let</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Let</ent><br/
<hw>Let</hw> <pr>(l<ecr/t)</pr>, <pos>v. t.</pos> <ety>[OE. <ets>letten</ets>, AS. <ets>lettan</ets> to delay, to hinder, fr. <ets>l<ae/t</ets> slow; akin to D. <ets>letten</ets> to hinder, G. <ets>verletzen</ets> to hurt, Icel. <ets>letja</ets> to hold back, Goth. <ets>latjan</ets>. See <er>Late</er>.]</ety> <def>To retard; to hinder; to impede; to oppose.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He was so strong that no man might him <qex>let</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He who now <qex>letteth</qex> will <qex>let</qex>, until he be taken out of the way.</q> <rj><qau>2. Thess. ii. 7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Mine ancient wound is hardly whole,<br/
And <qex>lets</qex> me from the saddle.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Let</ent><br/
<hw>Let</hw>, <pos>n.</pos> <sn>1.</sn> <def>A retarding; hindrance; obstacle; impediment; delay; -- common in the phrase <xex>without let or hindrance</xex>, but elsewhere archaic.</def> <rj><au>Keats.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Consider whether your doings be to the <qex>let</qex> of your salvation or not.</q> <rj><qau>Latimer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Lawn Tennis)</fld> <def>A stroke in which a ball touches the top of the net in passing over.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Let</ent><br/
<hw>Let</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Let</conjf> (<conjf>Letted</conjf> <pr>(l<ecr/t"t<ecr/d)</pr>, <mark>[Obs]</mark>.); <pos>p. pr. & vb. n.</pos> <conjf>Letting</conjf>.]</vmorph> <ety>[OE. <ets>leten</ets>, <ets>l<ae/ten</ets> (past tense <ets>lat</ets>, <ets>let</ets>, p. p. <ets>laten</ets>, <ets>leten</ets>, <ets>lete</ets>), AS. <ets>l<aemac/tan</ets> (past tense <ets>l<emac/t</ets>, p. p. <ets>l<aemac/ten</ets>); akin to OFries. <ets>l<emac/ta</ets>, OS. <ets>l<amac/tan</ets>, D. <ets>laten</ets>, G. <ets>lassen</ets>, OHG. <ets>l<amac/zzan</ets>, Icel. <ets>l<amac/ta</ets>, Sw. <ets>l<aring/ta</ets>, Dan. <ets>lade</ets>, Goth. <ets>l<emac/tan</ets>, and L. <ets>lassus</ets> weary. The original meaning seems to have been, to let loose, let go, let drop. Cf. <er>Alas</er>, <er>Late</er>, <er>Lassitude</er>, <er>Let</er> to hinder.]</ety> <sn>1.</sn> <def>To leave; to relinquish; to abandon.</def> <mark>[Obs. or Archaic, except when followed by <xex>alone</xex> or <xex>be</xex>.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He . . . prayed him his voyage for to <qex>let</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Yet neither spins nor cards, ne cares nor frets,<br/
But to her mother Nature all her care she <qex>lets</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Let</qex> me alone in choosing of my wife.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To consider; to think; to esteem.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To cause; to make; -- used with the infinitive in the active form but in the passive sense; <as>as, <ex>let</ex> make, <it>i. e.</it>, cause to be made; <ex>let</ex> bring, <it>i. e.</it>, cause to be brought</as>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>This irous, cursed wretch<br/
<qex>Let</qex> this knight's son anon before him fetch.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He . . . thus <qex>let</qex> do slay hem all three.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Anon he <qex>let</qex> two coffers make.</q> <rj><qau>Gower.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To permit; to allow; to suffer; -- either affirmatively, by positive act, or negatively, by neglecting to restrain or prevent.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In this sense, when followed by an infinitive, the latter is commonly without the sign <xex>to</xex>; <as>as to <ex>let</ex> us walk, <it>i. e.</it>, to permit or suffer us to walk</as>. Sometimes there is entire omission of the verb; <as>as, to <ex>let</ex> [to be or to go] loose</as>.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Pharaoh said, I will <qex>let</qex> you go.</q> <rj><qau>Ex. viii. 28.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>If your name be Horatio, as I am <qex>let</qex> to know it is.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To allow to be used or occupied for a compensation; to lease; to rent; to hire out; -- often with <ptcl>out</ptcl>; <as>as, to <ex>let</ex> a farm; to <ex>let</ex> a house; to <ex>let</ex> out horses.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To give, grant, or assign, as a work, privilege, or contract; -- often with <ptcl>out</ptcl>; <as>as, to <ex>let</ex> the building of a bridge; to <ex>let</ex> out the lathing and the plastering.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The active form of the infinitive of <xex>let</xex>, as of many other English verbs, is often used in a passive sense; as, a house <xex>to let</xex> (<it>i. e.</it>, for letting, or to be let). This form of expression conforms to the use of the Anglo-Saxon gerund with <xex>to</xex> (dative infinitive) which was commonly so employed. See <er>Gerund</er>, 2. <ldquo/ Your elegant house in Harley Street is <xex>to let</xex>.<rdquo/ <au>Thackeray.</au>
  In the imperative mood, before the first person plural, <xex>let</xex> has a hortative force. <ldquo/ Rise up, <xex>let</xex> us go.<rdquo/ <au>Mark xiv. 42.</au> <ldquo/ <xex>Let</xex> us seek out some desolate shade.<rdquo/ <au>Shak.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To let alone</b></col>, <cd>to leave; to withdraw from; to refrain from interfering with.</cd> -- <col><b>To let blood</b></col>, <cd>to cause blood to flow; to bleed.</cd> -- <col><b>To let down</b></col>. <sd>(a)</sd> <cd>To lower.</cd> <sd>(b)</sd> <cd>To soften in tempering; as, <xex>to let down</xex> tools, cutlery, and the like.</cd><-- to let (someone) down. to disappoint (someone) by failing to perform as expected. --> -- <mcol><col><b>To let fly</b></col> <it>or</it> <col><b>To let drive</b></col></mcol>, <cd>to discharge with violence, as a blow, an arrow, or stone. See under <er>Drive</er>, and <er>Fly</er>.</cd> -- <mcol><col><b>To let in</b></col> <it>or</it> <col><b>To let into</b></col></mcol>. <sd>(a)</sd> <cd>To permit or suffer to enter; to admit.</cd> <sd>(b)</sd> <cd>To insert, or imbed, as a piece of wood, in a recess formed in a surface for the purpose.</cd> -- <col><b>To let loose</b></col>, <cd>to remove restraint from; to permit to wander at large.</cd> -- <col><b>To let off</b></col>. <sd>(a)</sd> <cd>To discharge; to let fly, as an arrow; to fire the charge of, as a gun.</cd> <sd>(b)</sd> <cd>To release, as from an engagement or obligation.</cd> <mark>[Colloq.]</mark> -- <col><b>To let out</b></col>. <sd>(a)</sd> <cd>To allow to go forth; <as>as, <ex>to let out</ex> a prisoner</as>.</cd> <sd>(b)</sd> <cd>To extend or loosen, as the folds of a garment; to enlarge; to suffer to run out, as a cord.</cd> <sd>(c)</sd> <cd>To lease; to give out for performance by contract, as a job.</cd> <sd>(d)</sd> <cd>To divulge.</cd> -- <col><b>To let slide</b></col>, <cd>to let go; to cease to care for.</cd> <mark>[Colloq.]</mark> <ldquo/ <xex>Let</xex> the world <xex>slide</xex>.<rdquo/ <au>Shak.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Let</ent><br/
<hw>Let</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To forbear.</def> <mark>[Obs.]</mark> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be let or leased; <as>as, the farm <ex>lets</ex> for $500 a year</as>. See note under <er>Let</er>, <pos>v. t.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To let on</b></col>, <cd>to tell; to tattle; to divulge something.</cd> <mark>[Low]</mark> -- <col><b>To let up</b></col>, <cd>to become less severe; to diminish; to cease; <as>as, when the storm <ex>lets up</ex>.</as></cd> <mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Let-alone</ent><br/
<hw>Let"-a*lone"</hw> <pr>(l<ecr/t"<adot/*l<omac/n")</pr>, <pos>a.</pos> <def>Letting alone.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>The let-alone principle</b></col>, <col><b>The let-alone doctrine</b></col>, <it>or</it> <col><b>The let-alone policy</b></col></mcol>. <fld>(Polit. Econ.)</fld> <cd>See <er>Laissez faire</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letch</ent><br/
<hw>Letch</hw> <pr>(l<ecr/ch)</pr>, <pos>v. & n.</pos> <def>See <er>Leach</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letch</ent><br/
<hw>Letch</hw>, <pos>n.</pos> <ety>[See <er>Lech</er>, <er>Lecher</er>.]</ety> <sn>1.</sn> <def>Strong desire; passion; especially, lust.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Some people have a <qex>letch</qex> for unmasking impostors, or for avenging the wrongs of others.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A <er>lecher</er>.</def> <mark>[slang]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Letchy</ent><br/
<hw>Letch"y</hw> <pr>(-<ycr/)</pr>, <pos>a.</pos> <def>See <er>Leachy</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lete</ent><br/
<hw>Lete</hw> <pr>(l<ecr/t)</pr>, <pos>v. t.</pos> <def>To let; to leave.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leten</ent><br/
<hw>Let"en</hw> <pr>(l<ecr/t"<eit/n)</pr>, <mark>obs.</mark> <def><pos>p. p.</pos> of <er>Lete</er>.</def> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethal</ent><br/
<hw>Leth"al</hw> <pr>(l<ecr/th"<acr/l)</pr>, <pos>n.</pos> <ety>[<ets>L</ets>auric + <ets>eth</ets>er + <ets>al</ets>cohol.]</ety> <fld>(Chem.)</fld> <def>One of the higher alcohols of the paraffine series obtained from spermaceti as a white crystalline solid. It is so called because it occurs in the ethereal salt of lauric acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 845 pr=VMG --></p>

<p><ent>Lethal</ent><br/
<hw>Le"thal</hw> <pr>(l<emac/"th<ait/l)</pr>, <pos>a.</pos> <ety>[L. <ets>lethalis</ets>, <ets>letalis</ets>, fr. <ets>lethum</ets>, <ets>letum</ets>, death: cf. F. <ets>l<eacute/thal</ets>.]</ety> <def>Deadly; mortal; fatal.</def> <ldquo/The <xex>lethal</xex> blow.<rdquo/ <au>W. Richardson.</au> -- <wordforms><wf>Le"thal*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethality</ent><br/
<hw>Le*thal"i*ty</hw> <pr>(l<esl/*th<acr/l"<icr/*t<ycr/)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>l<eacute/thalit<eacute/</ets>.]</ety> <def>The quality of being lethal; mortality.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethargical</ent><br/
<ent>Lethargic</ent><br/
<mhw>{ <hw>Le*thar"gic</hw> <pr>(l<esl/*th<aum/r"j<icr/k)</pr>, <hw>Le*thar"gic*al</hw> <pr>(-j<icr/*k<ait/l)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>lethargicus</ets>, Gr. <grk>lhqargiko`s</grk>: cf. F. <ets>l<eacute/thargique</ets>. See <er>Lethargy</er>.]</ety> <def>Pertaining to, affected with, or resembling, lethargy; morbidly drowsy; dull; heavy.</def> -- <wordforms><wf>Le*thar"gic*al*ly</wf>, <pos>adv.</pos> -- <wf>Le*thar"gic*al*ness</wf>, <pos>n.</pos> -- <wf>Le*thar"gic*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethargize</ent><br/
<hw>Leth"ar*gize</hw> <pr>(l<ecr/th"<adot/r*j<imac/z)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lethargized</conjf> <pr>(-j<imac/zd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lethargizing</conjf> <pr>(-j<imac/`z<icr/ng)</pr>.]</vmorph> <def>To make lethargic.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All bitters are poison, and act by stilling, and depressing, and <qex>lethargizing</qex> the irritability.</q> <rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethargy</ent><br/
<hw>Leth"ar*gy</hw> <pr>(-j<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>-gies</plw> <pr>(-j<icr/z)</pr>.</plu> <ety>[F. <ets>l<eacute/thargie</ets>, L. <ets>lethargia</ets>, Gr. <grk>lhqargi`a</grk>, fr. <grk>lh`qargos</grk> forgetful, fr. <grk>lh`qh</grk> forgetfulness. See <er>Lethe</er>.]</ety> <sn>1.</sn> <def>Morbid drowsiness; continued or profound sleep, from which a person can scarcely be awaked.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A state of inaction or indifference.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Europe lay then under a deep <qex>lethargy</qex>.</q> <rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethargy</ent><br/
<hw>Leth"ar*gy</hw>, <pos>v. t.</pos> <def>To lethargize.</def> <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethe</ent><br/
<hw>Le"the</hw> <pr>(l<emac/"th<esl/ <or/ l<emac/th)</pr>, <pos>n.</pos> <ety>[See <er>Lethal</er>.]</ety> <def>Death.</def> <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethe</ent><br/
<hw>Le"the</hw> <pr>(l<emac/"th<esl/)</pr>, <pos>n.</pos> <ety>[L., fr. Gr. <grk>lh`qh</grk>, prop., forgetfulness; akin to <grk>lanqa`nesqai</grk> to forget, <grk>lanqa`nein</grk> to escape notice.]</ety> <sn>1.</sn> <fld>(Class. Myth.)</fld> <def>A river of Hades whose waters when drunk caused forgetfulness of the past.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Oblivion; a draught of oblivion; forgetfulness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethean</ent><br/
<hw>Le*the"an</hw> <pr>(l<esl/*th<emac/"<ait/n)</pr>, <pos>a.</pos> <ety>[L. <ets>Lethaeus</ets>, Gr. <grk>lh`qaios</grk> or <grk>lhqai^os</grk>.]</ety> <def>Of or pertaining to Lethe; resembling in effect the water of Lethe.</def> <rj><au>Milton. Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letheed</ent><br/
<hw>Le"theed</hw> <pr>(l<emac/"th<emac/d)</pr>, <pos>a.</pos> <def>Caused by Lethe.</def> <ldquo/ <xex>Letheed</xex> dullness.<rdquo/ <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letheon</ent><br/
<hw>Le"the*on</hw> <pr>(l<emac/"th<esl/*<ocr/n)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>lh`qh</grk>.]</ety> <fld>(Med.)</fld> <def>Sulphuric ether used as an an<ae/sthetic agent.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letheonize</ent><br/
<hw>Le"the*on*ize</hw> <pr>(-<imac/z)</pr>, <pos>v. t.</pos> <def>To subject to the influence of letheon.</def> <mark>[R. or Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethiferous</ent><br/
<hw>Le*thif"er*ous</hw> <pr>(l<esl/*th<icr/f"<etil/r*<ucr/s)</pr>, <pos>a.</pos> <ety>[L. <ets>lethifer</ets>, <ets>letifer</ets>, fr. <ets>lethum</ets>, <ets>letum</ets>, death + <ets>ferre</ets> to bear, to bring: cf. F. <ets>l<eacute/thif<egrave/re</ets>.]</ety> <def>Deadly; bringing death or destruction.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lethy</ent><br/
<hw>Le"thy</hw> <pr>(l<emac/"th<ycr/)</pr>, <pos>a.</pos> <def>Lethean.</def> <mark>[Obs.]</mark> <rj><au>Marston.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Let-off</ent><br/
<hw>Let"-off`</hw> <pr>(l<ecr/t"<ocr/f`; 115)</pr>, <pos>n.</pos> <fld>(Mach.)</fld> <def>A device for letting off, releasing, or giving forth, as the warp from the cylinder of a loom.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lette</ent><br/
<hw>Let"te</hw> <pr>(l<ecr/t"t<eit/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Letted</conjf>.]</vmorph> <def>To let; to hinder. See <er>Let</er>, to hinder.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letter</ent><br/
<hw>Let"ter</hw> <pr>(l<ecr/t"t<etil/r)</pr>, <pos>n.</pos> <ety>[From <er>Let</er> to permit.]</ety> <def>One who lets or permits; one who lets anything for hire.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letter</ent><br/
<hw>Let"ter</hw>, <pos>n.</pos> <ety>[From <er>Let</er> to hinder.]</ety> <def>One who retards or hinders.</def> <mark>[Archaic.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letter</ent><br/
<hw>Let"ter</hw>, <pos>n.</pos> <ety>[OE. <ets>lettre</ets>, F. <ets>lettre</ets>, OF. <ets>letre</ets>, fr. L. <ets>littera</ets>, <ets>litera</ets>, a letter; pl., an epistle, a writing, literature, fr. <ets>linere</ets>, <ets>litum</ets>, to besmear, to spread or rub over; because one of the earliest modes of writing was by graving the characters upon tablets smeared over or covered with wax. <au>Pliny, xiii. 11.</au> See <er>Liniment</er>, and cf. <er>Literal</er>.]</ety> <sn>1.</sn> <def>A mark or character used as the representative of a sound, or of an articulation of the human organs of speech; a first element of written language.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And a superscription also was written over him in <qex>letters</qex> of Greek, and Latin, and Hebrew.</q> <rj><qau>Luke xxiii. 38.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A written or printed communication; a message expressed in intelligible characters on something adapted to conveyance, as paper, parchment, etc.; an epistle.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The style of <qex>letters</qex> ought to be free, easy, and natural.</q> <rj><qau>Walsh.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A writing; an inscription.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>None could expound what this <qex>letter</qex> meant.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Verbal expression; literal statement or meaning; exact signification or requirement.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We must observe the <qex>letter</qex> of the law, without doing violence to the reason of the law and the intention of the lawgiver.</q> <rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I broke the <qex>letter</qex> of it to keep the sense.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Print.)</fld> <def>A single type; type, collectively; a style of type.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Under these buildings . . . was the king's printing house, and that famous <qex>letter</qex> so much esteemed.</q> <rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <pluf>pl.</pluf> <def>Learning; erudition; <as>as, a man of <ex>letters</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <pluf>pl.</pluf> <def>A letter; an epistle.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Teleg.)</fld> <def>A telegram longer than an ordinary message sent at rates lower than the standard message rate in consideration of its being sent and delivered subject to priority in service of regular messages. Such telegrams are called by the Western Union Company <altname>day letters</altname>, <it>or</it> <altname>night letters</altname> according to the time of sending, and by The Postal Telegraph Company <altname>day lettergrams</altname>, <it>or</it> <altname>night lettergrams</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><mcol><col><b>Dead letter</b></col>, <col><b>Drop letter</b></col></mcol>, <cd>etc. See under <er>Dead</er>, <er>Drop</er>, etc.</cd> -- <col><b>Letter book</b></col>, <cd>a book in which copies of letters are kept.</cd> -- <col><b>Letter box</b></col>, <cd>a box for the reception of letters to be mailed or delivered.</cd> -- <col><b>Letter carrier</b></col>, <cd>a person who carries letters; a postman; specif., an officer of the post office who carries letters to the persons to whom they are addressed, and collects letters to be mailed.</cd> -- <col><b>Letter cutter</b></col>, <cd>one who engraves letters or letter punches.</cd> -- <col><b>Letter lock</b></col>, <cd>a lock that can not be opened when fastened, unless certain movable lettered rings or disks forming a part of it are in such a position (indicated by a particular combination of the letters) as to permit the bolt to be withdrawn.</cd><br/
[<source>1913 Webster</source>]</p>

<p><q>A strange lock that opens with AMEN.</q> <rj><qau>Beau. & Fl.</qau></rj></p>

<p>-- <col><b>Letter paper</b></col>, <cd>paper for writing letters on; especially, a size of paper intermediate between note paper and foolscap. See <er>Paper</er>.</cd> -- <col><b>Letter punch</b></col>, <cd>a steel punch with a letter engraved on the end, used in making the matrices for type.</cd> -- <col><b>Letters of administration</b></col> <fld>(Law)</fld>, <cd>the instrument by which an administrator or administratrix is authorized to administer the goods and estate of a deceased person.</cd> -- <mcol><col><b>Letter of attorney</b></col>, <col><b>Letter of credit</b></col></mcol>, etc. <cd>See under <er>Attorney</er>, <er>Credit</er>, etc.</cd> -- <col><b>Letter of license</b></col>, <cd>a paper by which creditors extend a debtor's time for paying his debts.</cd> -- <mcol><col><b>Letters close</b></col> <it>or</it> <col><b>Letters clause</b></col></mcol> <fld>(Eng. Law.)</fld>, <cd>letters or writs directed to particular persons for particular purposes, and hence <xex>closed</xex> or sealed on the outside; -- distinguished from <contr>letters patent</contr>.</cd> <au>Burrill.</au> -- <col><b>Letters of orders</b></col> <fld>(Eccl.)</fld>, <cd>a document duly signed and sealed, by which a bishop makes it known that he has regularly ordained a certain person as priest, deacon, etc.</cd> -- <mcol><col><b>Letters patent</b></col>, <col><b>Letters overt</b></col>, <it>or</it> <col><b>Letters open</b></col></mcol> <fld>(Eng. Law)</fld>, <cd>a writing executed and sealed, by which power and authority are granted to a person to do some act, or enjoy some right; <as>as, <ex>letters patent</ex> under the seal of England</as>.  The common commercial <er>patent</er> is a derivative form of such a right.</cd> -- <col><b>Letter-sheet envelope</b></col>, <cd>a stamped sheet of letter paper issued by the government, prepared to be folded and sealed for transmission by mail without an envelope.</cd> -- <col><b>Letters testamentary</b></col> <fld>(Law)</fld>, <cd>an instrument granted by the proper officer to an executor after probate of a will, authorizing him to act as executor.</cd> -- <col><b>Letter writer</b></col>. <sd>(a)</sd> <cd>One who writes letters.</cd> <sd>(b)</sd> <cd>A machine for copying letters.</cd> <sd>(c)</sd> <cd>A book giving directions and forms for the writing of letters.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letter</ent><br/
<hw>Let"ter</hw> <pr>(l<ecr/t"t<etil/r)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Lettered</conjf> <pr>(-t<etil/rd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Lettering</conjf>.]</vmorph> <def>To impress with letters; to mark with letters or words; <as>as, a book gilt and <ex>lettered</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>letter-bomb</ent><br/
<ent>letter bomb</ent><br/
<mhw><hw>let"ter bomb`</hw>, <hw>let"ter-bomb`</hw></mhw> <pos>n.</pos> <def>A bomb disguised as a letter and sent through the mail, usually rigged to explode and kill or harm the recipient when opened.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>letter-bomb</ent><br/
<hw>letter-bomb</hw> <pos>v. t.</pos> <def>to send a letter-bomb to.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>lettercard</ent><br/
<hw>lettercard</hw> <pos>n.</pos> <def>a postcard that folds so that the message is inside.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lettered</ent><br/
<hw>Let"tered</hw> <pr>(l<ecr/t"t<etil/rd)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Literate; educated; versed in literature.</def> <ldquo/ Are you not <xex>lettered</xex>?<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The unlettered barbarians willingly accepted the aid of the <qex>lettered</qex> clergy, still chiefly of Roman birth, to reduce to writing the institutes of their forefathers.</q> <rj><qau>Milman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to learning or literature; learned.</def> <ldquo/ A <xex>lettered</xex> education.<rdquo/ <rj><au>Collier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Inscribed or stamped with letters.</def> <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letterer</ent><br/
<hw>Let"ter*er</hw> <pr>(l<ecr/t"t<etil/r*<etil/r)</pr>, <pos>n.</pos> <def>One who makes, inscribes, or engraves, alphabetical letters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lettergram</ent><br/
<hw>Let"ter*gram</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Letter{8}</er>, above.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Lettering</ent><br/
<hw>Let"ter*ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act or business of making, or marking with, letters, as by cutting or painting.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The letters made; <as>as, the <ex>lettering</ex> of a sign</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letterless</ent><br/
<hw>Let"ter*less</hw> <pr>(l<ecr/t"t<etil/r*l<ecr/s)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Not having a letter.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Illiterate.</def> <mark>[Obs.]</mark> <rj><au>E. Waterhouse.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lettern</ent><br/
<hw>Let"tern</hw> <pr>(l<ecr/t"t<etil/rn)</pr>, <pos>n.</pos> <def>See <er>Lecturn</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>letter-perfect</ent><br/
<hw>letter-perfect</hw> <pos>adj.</pos> <def>correct to the last detail; especially being in or following the exact words; <as>as, a <ex>letter-perfect</ex> rendition of the soliloquy</as>.</def><br/
<syn><b>Syn. --</b> word-perfect.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Letterpress</ent><br/
<hw>Let"ter*press`</hw> <pr>(-t<etil/r*pr<ecr/s`)</pr>, <pos>n.</pos> <def>Print; letters and words impressed on paper or other material by types; -- often used of the reading matter in distinction from the illustrations.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Letterpress printing, printing directly from type, in distinction from printing from plates.</q><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letterure</ent><br/
<hw>Let"ter*ure</hw> <pr>(-<usl/r)</pr>, <pos>n.</pos> <def>Letters; literature.</def> <mark>[Obs.]</mark> <ldquo/To teach him <xex>letterure</xex> and courtesy.<rdquo/ <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letterwood</ent><br/
<hw>Let"ter*wood`</hw> <pr>(-w<oocr/d`)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The beautiful and highly elastic wood of a tree of the genus <gen>Brosimum</gen> (<spn>Brosimum Aubletii</spn>), found in Guiana; -- so called from black spots in it which bear some resemblance to hieroglyphics; also called <altname>snakewood</altname>, and <altname>leopardwood</altname>. It is much used for bows and for walking sticks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lettic</ent><br/
<hw>Let"tic</hw> <pr>(l<ecr/t"t<icr/k)</pr>, <pos>a.</pos> <sd>(a)</sd> <def>Of or pertaining to the Letts; Lettish.</def> <sd>(b)</sd> <def>Of or pertaining to a branch of the Slavic family, subdivided into Lettish, Lithuanian, and Old Prussian.</def> -- <def2><pos>n.</pos> <sd>(a)</sd> <def>The language of the Letts; Lettish.</def> <sd>(b)</sd> <def>The language of the Lettic race, including Lettish, Lithuanian, and Old Prussian.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lettish</ent><br/
<hw>Let"tish</hw> <pr>(l<ecr/t"t<icr/sh)</pr>, <pos>a.</pos> <def>Of or pertaining to the Letts.</def> -- <def2><pos>n.</pos> <def>The language spoken by the Letts. See <er>Lettic</er>.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lettrure</ent><br/
<hw>Let"trure</hw> <pr>(-tr<usdot/r)</pr>, <pos>n.</pos> <def>See <er>Letterure</er>.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letts</ent><br/
<hw>Letts</hw> <pr>(l<ecr/ts)</pr>, <pos>n. pl.</pos>; <sing>sing. <singw>Lett</singw> <pr>(l<ecr/t)</pr></sing>. <fld>(Ethnol.)</fld> <def>An Indo-European people, allied to the Lithuanians and Old Prussians, and inhabiting a part of the Baltic provinces of Russia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lettuce</ent><br/
<hw>Let"tuce</hw> <pr>(l<ecr/t"t<icr/s)</pr>, <pos>n.</pos> <ety>[OE. <ets>letuce</ets>, prob. through Old French from some Late Latin derivative of L. <ets>lactuca</ets> lettuce, which, according to Varro, is fr. <ets>lac</ets>, <ets>lactis</ets>, milk, on account of the milky white juice which flows from it when it is cut: cf. F. <ets>laitue</ets>. Cf. <er>Lacteal</er>, <er>Lactucic</er>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>A composite plant of the genus <gen>Lactuca</gen> (<spn>Lactuca sativa</spn>), the leaves of which are used as salad.  Plants of this genus yield a milky juice, from which lactucarium is obtained.  The commonest wild lettuce of the United States is <spn>Lactuca Canadensis</spn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>United States currency; dollar bills; greenbacks.</def> <mark>[slang]</mark><br/
[<source>PJC</source>]</p>

<p><cs><mcol><col><b>Hare's lettuce</b></col>, <col><b>Lamb's lettuce</b></col></mcol>. <cd>See under <er>Hare</er>, and <er>Lamb</er>.</cd> -- <col><b>Lettuce opium</b></col>. <cd>See <er>Lactucarium</er>.</cd> -- <col><b>Sea lettuce</b></col>, <cd>certain papery green seaweeds of the genus <gen>Ulva</gen>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Letuary</ent><br/
<hw>Let"u*a*ry</hw> <pr>(l<ecr/t"<usl/*<asl/*r<ycr/)</pr>, <pos>n.</pos> <def>Electuary.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Let-up</ent><br/
<hw>Let"-up`</hw> <pr>(l<ecr/t"<ucr/p`)</pr>, <pos>n.</pos> <ety>[See <er>Let</er> to forbear.]</ety> <def>Abatement; also, cessation; <as>as, it blew a gale for three days without any <ex>let-up</ex></as>.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leuc-</ent><br/
<hw>Leuc-</hw> <pr>(l<umac/k-)</pr> <pos>pref.</pos> <def>Same as <er>Leuco-</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucadendron</ent><br/
\'d8<hw>Leu`ca*den"dron</hw> <pr>(l<umac/`k<adot/*d<ecr/n"dr<ocr/n)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>leyko`s</grk> white + <grk>de`ndron</grk> tree.]</ety> <fld>(Bot.)</fld> <def>A genus of evergreen shrubs from the Cape of Good Hope, having handsome foliage. <spn>Leucadendron argenteum</spn> is the <stype>silverboom</stype> of the colonists.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucaniline</ent><br/
<hw>Leu*can"i*line</hw> <pr>(l<usl/*k<acr/n"<icr/*l<icr/n <or/ -l<emac/n)</pr>, <pos>n.</pos> <ety>[<ets>Leuc-</ets> + <ets>aniline</ets>.]</ety> <fld>(Chem.)</fld> <def>A colorless, crystalline, organic base, obtained from rosaniline by reduction, and also from other sources. It forms colorless salts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leuchaemia</ent><br/
\'d8<hw>Leu*ch<ae/"mi*a</hw> <pr>(l<usl/*k<emac/"m<icr/*<adot/)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>leyko`s</grk> white + <grk>a"i^ma</grk> blood.]</ety> <fld>(Med.)</fld> <def>See <er>Leukemia</er>.</def> <altsp>[Written also <asp>leukemia</asp>, <asp>leukaemia</asp>,a nd <asp>leucemia</asp>.]</altsp><br/
-- <wordforms><wf>Leu*ch<ae/m"ic</wf> <pr>(l<usl/*k<ecr/m"<icr/k)</pr>, <pos>a.</pos>  <altsp>[Written also <asp>leukemic</asp> and <asp>leukaemic</asp>.]</altsp></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucinic</ent><br/
<ent>Leucic</ent><br/
<mhw>{ <hw>Leu"cic</hw> <pr>(l<umac/"s<icr/k)</pr>, <hw>Leu*cin"ic</hw> <pr>(l<usl/*s<icr/n"<icr/k)</pr>, }</mhw> <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an acid obtained from leucin, and called also <altname>oxycaproic acid</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucin</ent><br/
<ent>Leucine</ent><br/
<mhw><hw>Leu"cine</hw> <pr>(l<oomac/"s<emac/n)</pr>, <hw>Leu"cin</hw></mhw> <pr>(l<umac/"s<icr/n)</pr>, <pos>n.</pos> <ety>[Gr. <grk>leyko`s</grk> white.]</ety> <fld>(Physiol. Chem.)</fld> <def>a naturally occurring alpha-amino acid (<chform>(CH3)2CH.CH2.CH(NH2)-COOH</chform>), one of the building units of almost all proteins of living organisms, both animal and vegetable.  It is one of the essential amino acids (not synthesized by the human body, a required component for proper nutrition), and is hydrophobic in character when bound in proteins. In isolated form it is a white, crystalline, zwitterionic substance formed, e. g. by the decomposition of proteins by pancreatic digestion, by the action of boiling dilute mineral acid, or by putrefaction. Chemically it is to be considered as amido-caproic acid.  It occurs as two optical isomers, the L- and D-forms.  The L-form, L-leucine, is the natural form, present in most proteins.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Leuciscus</ent><br/
<hw>Leuciscus</hw> <pos>prop. n.</pos> <def>A genus of freshwater fishes including the dace (<spn>Leuciscus leuciscus</spn>).</def><br/
<syn><b>Syn. --</b> genus <gen>Leuciscus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leucite</ent><br/
<hw>Leu"cite</hw> <pr>(l<umac/"s<imac/t)</pr>, <pos>n.</pos> <ety>[Gr. <grk>leyko`s</grk> white: cf. F. <ets>leucite</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Min.)</fld> <def>A mineral having a glassy fracture, occurring in translucent trapezohedral crystals. It is a silicate of alumina and potash <chform>KAlSi2O6</chform>.  It is found in the volcanic rocks of Italy, especially at Vesuvius.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>A leucoplast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucitic</ent><br/
<hw>Leu*cit"ic</hw> <pr>(l<usl/*s<icr/t"<icr/k)</pr>, <pos>a.</pos> <fld>(Min.)</fld> <def>Containing leucite; <as>as, <ex>leucitic</ex> rocks</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucitoid</ent><br/
<hw>Leu"ci*toid</hw> <pr>(l<umac/"s<icr/*toid)</pr>, <pos>n.</pos> <ety>[<ets>Leucite</ets> + <ets>-oid</ets>.]</ety> <fld>(Crystallog.)</fld> <def>The trapezohedron or tetragonal trisoctahedron; -- so called as being the form of the mineral leucite.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leuc-</ent><br/
<ent>Leuco-</ent><br/
<mhw>{ <hw>Leu"co-</hw> <pr>(l<umac/"k<osl/-)</pr>, <hw>Leuc-</hw> <pr>(l<umac/k-)</pr>. }</mhw> <pos>pref.</pos> <ety>[Gr. <grk>leyko`s</grk> white.]</ety> <def>A combining form signifying <xex>white</xex>, <xex>colorless</xex>; specif. <fld>(Chem.)</fld>, denoting an extensive series of <xex>colorless</xex> organic compounds, obtained by reduction from certain other <xex>colored</xex> compounds; <as>as, <ex>leuc</ex>aniline, <ex>leuc</ex>aurin, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucocyte</ent><br/
<hw>Leu"co*cyte</hw> <pr>(l<umac/"k<osl/*s<imac/t)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + Gr. <grk>ky`tos</grk> a hollow vessel.]</ety> <fld>(Physiol.)</fld> <def>A colorless corpuscle, as one of the white blood corpuscles, or those found in lymph, marrow of bone, connective tissue, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ They all consist of more or less spherical masses of protoplasm, without any surrounding membrane or wall, and are capable of motion.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucocythemia</ent><br/
<ent>Leucocythaemia</ent><br/
<mhw>{ \'d8<hw>Leu`co*cy*th<ae/"mi*a</hw> \'d8<hw>Leu`co*cy*the"mi*a</hw> } </mhw> <pr>(l<umac/`k<osl/*s<isl/*th<emac/"m<icr/*<adot/)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>leyko`s</grk> white + <grk>ky`tos</grk> a hollow vessel + <grk>a"i^ma</grk> blood.]</ety> <fld>(Med.)</fld> <def>Same as <er>leukemia</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucocytogenesis</ent><br/
<hw>Leu`co*cy`to*gen"e*sis</hw> <pr>(-s<imac/`t<osl/*j<ecr/n"<esl/*s<icr/s)</pr>, <pos>n.</pos> <ety>[<ets>Leucocyte</ets> + <ets>genesis</ets>.]</ety> <fld>(Physiol.)</fld> <def>The formation of leucocytes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoethiopic</ent><br/
<hw>Leu`co*e`thi*op"ic</hw> <pr>(-<emac/`th<icr/*<ocr/p"<icr/k)</pr>, <pos>a.</pos> <ety>[<ets>Leuco-</ets> + <ets>Ethiopic</ets>.]</ety> <def>White and black; -- said of a white animal of a black species, or the albino of the negro race.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoethiops</ent><br/
<hw>Leu`co*e"thi*ops</hw> <pr>(-<emac/"th<icr/*<ocr/ps)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + <ets>Aethiops</ets>.]</ety> <def>An albino.</def> <altsp>[Also written <asp>leuc<oe/thiops</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoline</ent><br/
<hw>Leu"co*line</hw> <pr>(l<umac/"k<osl/*l<icr/n <or/ -l<emac/n)</pr>, <pos>n.</pos> <ety>[<ets>Leuc-</ets> + L. <ets>ol</ets>eum oil.]</ety> <fld>(Chem.)</fld> <def>A nitrogenous organic base from coal tar, and identical with quinoline. Cf. <er>Quinoline</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoma</ent><br/
\'d8<hw>Leu*co"ma</hw> <pr>(l<usl/*k<omac/"m<adot/)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr. <grk>ley`kwma</grk>, fr. <grk>leyko`s</grk> white.]</ety> <fld>(Med.)</fld> <def>A white opacity in the cornea of the eye; -- called also <altname>albugo</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucomaine</ent><br/
<hw>Leu*co"ma*ine</hw> <pr>(l<usl/*k<omac/"m<adot/*<icr/n <or/ -<emac/n)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + <ets>-maine</ets>, as in <ets>ptomaine</ets>.]</ety> <fld>(Physiol. Chem.)</fld> <def>An animal base or alkaloid, appearing in the tissue during life; hence, a vital alkaloid, as distinguished from a <contr>ptomaine</contr> or cadaveric poison.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leuconic</ent><br/
<hw>Leu*con"ic</hw> <pr>(-k<ocr/n"<icr/k)</pr>, <pos>a.</pos> <ety>[<ets>Leuc-</ets> + croc<ets>onic</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, a complex organic acid, obtained as a yellowish white gum by the oxidation of croconic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucopathy</ent><br/
<hw>Leu*cop"a*thy</hw> <pr>(l<usl/*k<ocr/p"<adot/*th<ycr/)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + Gr. <grk>pa`schein</grk>, <grk>paqei^n</grk> to suffer.]</ety> <def>The state of an albino, or of a white child of black parents.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucophane</ent><br/
<hw>Leu"co*phane</hw> <pr>(l<umac/"k<osl/*f<amac/n)</pr>, <pos>n.</pos> <ety>[Gr. <grk>leykofanh`s</grk> appearing bright or white; <grk>leyko`s</grk> white + <grk>fai`nein</grk> to show: cf. G. <ets>leukophan</ets>.]</ety> <fld>(Min.)</fld> <def>A mineral of a greenish yellow color; it is a silicate of glucina, lime, and soda with fluorine. Called also <altname>leucophanite</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucophlegmacy</ent><br/
<hw>Leu`co*phleg"ma*cy</hw> <pr>(l<umac/`k<osl/*fl<ecr/g"m<adot/*s<ycr/)</pr>, <pos>n.</pos> <ety>[Gr. <grk>leykoflegmati`a</grk>; <grk>leyko`s</grk> white + <grk>fle`gma</grk> phlegm: cf. F. <ets>leucophlegmasie</ets>.]</ety> <fld>(Med.)</fld> <def>A dropsical habit of body, or the commencement of anasarca; paleness, with viscid juices and cold sweats.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucophlegmatic</ent><br/
<hw>Leu`co*phleg*mat"ic</hw> <pr>(-fl<ecr/g*m<acr/t"<icr/k)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>leucophlegmatique</ets>, Gr. <grk>leykofle`gmatos</grk>.]</ety> <def>Having a dropsical habit of body, with a white bloated skin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucophyll</ent><br/
<hw>Leu"co*phyll</hw> <pr>(l<umac/"k<osl/*f<icr/l)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + Gr. <grk>fy`llon</grk> a leaf.]</ety> <fld>(Chem.)</fld> <def>A colorless substance isomeric with chlorophyll, contained in parts of plants capable of becoming green.</def> <rj><au>Watts.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucophyllous</ent><br/
<hw>Leu*coph"yl*lous</hw> <pr>(l<usl/*k<ocr/f"<icr/l*l<ucr/s <or/ l<umac/`k<osl/*f<icr/l"l<ucr/s)</pr>, <pos>a.</pos> <ety>[Gr. <grk>leyko`fyllos</grk>; <grk>leyko`s</grk> white + <grk>fy`llon</grk> a leaf.]</ety> <fld>(Bot.)</fld> <def>Having white or silvery foliage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoplastid</ent><br/
<ent>Leucoplast</ent><br/
<mhw>{ <hw>Leu"co*plast</hw> <pr>(l<umac/"k<osl/*pl<acr/st)</pr>, <hw>Leu`co*plas"tid</hw> <pr>(-pl<acr/s"t<icr/d)</pr>, }</mhw> <pos>n.</pos> <ety>[<ets>Leuco-</ets> + Gr. <grk>pla`ssein</grk> to mold.]</ety> <fld>(Bot.)</fld> <def>One of certain very minute whitish or colorless granules occurring in the protoplasm of plants and supposed to be the nuclei around which starch granules will form.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucopyrite</ent><br/
<hw>Leu*cop"y*rite</hw> <pr>(l<usl/*k<ocr/p"<icr/*r<imac/t)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + <ets>pyrites</ets>.]</ety> <fld>(Min.)</fld> <def>A mineral of a color between white and steel-gray, with a metallic luster, and consisting chiefly of arsenic and iron.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucorrhoea</ent><br/
<hw>Leu`cor*rh<oe/"a</hw> <pr>(l<umac/`k<ocr/r*r<emac/"<adot/)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + Gr. <grk>"rei^n</grk> to flow.]</ety> <fld>(Med.)</fld> <def>A discharge of a white, yellowish, or greenish, viscid mucus, resulting from inflammation or irritation of the membrane lining the genital organs of the female; the whites.</def><-- leukorrhea, leukorrhagia --> <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoryx</ent><br/
\'d8<hw>Leu"co*ryx</hw> <pr>(l<umac/"k<osl/*r<icr/ks)</pr>, <pos>n.</pos> <ety>[NL., from Gr. <grk>leyko`s</grk> + <grk>'o`ryx</grk> a kind of gazelle.]</ety> <fld>(Zool.)</fld> <def>A large antelope of North Africa (<spn>Oryx leucoryx</spn>), allied to the gemsbok.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoscope</ent><br/
<hw>Leu"co*scope</hw> <pr>(l<umac/"k<osl/*sk<omac/p)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + <ets>-scope</ets>.]</ety> <fld>(Physics)</fld> <def>An instrument, devised by Professor Helmholtz, for testing the color perception of the eye, or for comparing different lights, as to their constituent colors or their relative whiteness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucosoid</ent><br/
<hw>Leu"co*soid</hw> <pr>(-soid)</pr>, <pos>a.</pos> <ety>[NL. <ets>Leucosia</ets>, the typical genus (fr. Gr. <grk>leyko`s</grk> white) + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Like or pertaining to the <fam>Leucosoidea</fam>, a tribe of marine crabs including the box crab or <gen>Calappa</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucosphere</ent><br/
<hw>Leu"co*sphere</hw> <pr>(-sf<emac/r)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + <ets>sphere</ets>.]</ety> <fld>(Astron.)</fld> <def>The inner corona.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoturic</ent><br/
<hw>Leu`co*tu"ric</hw> <pr>(l<umac/`k<osl/*t<umac/"r<icr/k)</pr>, <pos>a.</pos> <ety>[<ets>Leuco-</ets> + allan<ets>t</ets>oic + <ets>uric</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, a nitrogenous organic substance of the uric acid group, called <xex>leucoturic</xex> acid or <xex>oxalantin</xex>. See <er>Oxalantin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucous</ent><br/
<hw>Leu"cous</hw> <pr>(l<umac/"k<ucr/s)</pr>, <pos>a.</pos> <ety>[Gr. <grk>leyko`s</grk>.]</ety> <def>White; -- applied to albinos, from the whiteness of their skin and hair.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leucoxene</ent><br/
<hw>Leu*cox"ene</hw> <pr>(l<usl/*k<ocr/ks"<emac/n)</pr>, <pos>n.</pos> <ety>[<ets>Leuco-</ets> + Gr. <grk>xe`nos</grk> stranger.]</ety> <fld>(Min.)</fld> <def>A nearly opaque white mineral, in part identical with titanite, observed in some igneous rocks as the result of the alteration of titanic iron.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>leukaemia</ent><br/
<ent>leukemia</ent><br/
<hw>leu*k<ae/"mi*a</hw> <pr>(l<usl/*k<emac/"m<icr/*<adot/)</pr>, <pos>n.</pos> <def>A disease in which the white corpuscles of the blood are largely increased in number, and there is enlargement of the spleen, or the lymphatic glands; formerly called <altname>leucocythaemia</altname>.  It is due to a cancer of the bone marrow, and results in anemia and increased susceptibility to infectious disease.</def>  <altsp>[Also spelled <asp>leucemia</asp>  and <asp>leuchaemia</asp>.]</altsp><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Leukeness</ent><br/
<ent>Leuke</ent><br/
<mhw><hw>Leuke</hw> <pr>(l<umac/k)</pr>, <pos>a.</pos>, <hw>Leuke"ness</hw>, <pos>n.</pos></mhw> <def>See <er>Luke</er>, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leukoplast</ent><br/
<hw>Leu"ko*plast</hw> <pr>(l<umac/"k<osl/*pl<acr/st)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>See <er>Leucoplast</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levana</ent><br/
\'d8<hw>Le*va"na</hw> <pr>(l<esl/*v<amac/"n<adot/)</pr>, <pos>n.</pos> <ety>[L., fr. <ets>levare</ets> to raise.]</ety> <fld>(Rom. Myth.)</fld> <def>A goddess who protected newborn infants.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levant</ent><br/
<hw>Le"vant</hw> <pr>(l<emac/"v<ait/nt)</pr>, <pos>a.</pos> <ety>[F., p. pr. of <ets>lever</ets> to raise.]</ety> <fld>(Law)</fld> <def>Rising or having risen from rest; -- said of cattle. See <cref>Couchant and levant</cref>, under <er>Couchant</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levant</ent><br/
<hw>Le*vant"</hw> <pr>(l<esl/*v<acr/nt")</pr>, <pos>n.</pos> <ety>[It. <ets>levante</ets> the point where the sun rises, the east, the Levant, fr. <ets>levare</ets> to raise, <ets>levarsi</ets> to rise: cf. F. <ets>levant</ets>. See <er>Lever</er>.]</ety> <sn>1.</sn> <def>The countries washed by the eastern part of the Mediterranean and its contiguous waters.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A levanter (the wind so called).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levant</ent><br/
<hw>Le"vant</hw> <pr>(l<emac/"v<ait/nt; 277)</pr>, <pos>a.</pos> <def>Eastern.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Forth rush the <qex>levant</qex> and the ponent winds.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levant</ent><br/
<hw>Le*vant"</hw> <pr>(l<esl/*v<acr/nt")</pr>, <pos>v. i.</pos> <ety>[Cf. Sp. <ets>levantar</ets> to raise, go from one place to another.]</ety> <def>To run away from one's debts; to decamp.</def> <mark>[Colloq. Eng.]</mark> <rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 846 pr=VMG --></p>

<p><ent>Levanter</ent><br/
<hw>Le*vant"er</hw> <pr>(l<esl/*v<acr/nt"<etil/r)</pr>, <pos>n.</pos> <ety>[From <er>Levant</er>, <pos>v.</pos>]</ety> <def>One who levants, or decamps.</def> <mark>[Colloq. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levanter</ent><br/
<hw>Le*vant"er</hw>, <pos>n.</pos> <ety>[From <er>Levant</er>, <pos>n.</pos>]</ety> <def>A strong easterly wind peculiar to the Mediterranean.</def> <rj><au>W. H. Russell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levantine</ent><br/
<hw>Le*vant"ine</hw> <pr>(l<esl/*v<acr/nt"<icr/n <or/ l<ecr/v"<ait/nt*<imac/n; 277)</pr>, <pos>a.</pos> <ety>[F. <ets>levantin</ets>, or It. <ets>levantino</ets>. See <er>Levant</er>, <pos>n.</pos>]</ety> <def>Of or pertaining to the Levant.</def> <rj><au>J. Spencer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levantine</ent><br/
<hw>Le*vant"ine</hw>, <pos>n.</pos> <sn>1.</sn> <def>A native or inhabitant of the Levant.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[F. <ets>levantine</ets>, or It. <ets>levantina</ets>.]</ety> <def>A stout twilled silk fabric, formerly made in the Levant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levari facias</ent><br/
\'d8<hw>Le*va`ri fa"ci*as</hw> <pr>(l<esl/*v<amac/`r<isl/ f<amac/"sh<icr/*<acr/s)</pr> <pos>n.</pos> <ety>[Law L., cause to be levied.]</ety> <def>A writ of execution at common law.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levation</ent><br/
<hw>Le*va"tion</hw> <pr>(l<esl/*v<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>levatio</ets>.]</ety> <def>The act of raising; elevation; upward motion, as that produced by the action of a <xex>levator</xex> muscle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levator</ent><br/
<hw>Le*va"tor</hw> <pr>(l<esl/*v<amac/"t<ocr/r)</pr>, <pos>n.</pos> <ety>[NL., fr. L. <ets>levare</ets> to raise. See <er>Lever</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <fld>(Anat.)</fld> <def>A muscle that serves to raise some part, as the lip or the eyelid.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Surg.)</fld> <def>A surgical instrument used to raise a depressed part of the skull.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leve</ent><br/
<hw>Leve</hw> <pr>(l<emac/v)</pr>, <pos>a.</pos> <def>Dear. See <er>Lief</er>.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leve</ent><br/
<hw>Leve</hw>, <pos>n. & v.</pos> <def>Same as 3d & 4th <er>Leave</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leve</ent><br/
<hw>Leve</hw>, <pos>v. i.</pos> <def>To live.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leve</ent><br/
<hw>Leve</hw>, <pos>v. t.</pos> <ety>[OE., fr. AS. <ets>l<emac/fan</ets>, abbrev. fr. <ets>gel<emac/fan</ets>. See <er>Believe</er>.]</ety> <def>To believe.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leve</ent><br/
<hw>Leve</hw>, <pos>v. t.</pos> <ety>[OE. <ets>leven</ets>, AS. <ets>l<emac/fan</ets>, <ets>l<ymac/fan</ets>. See <er>Leave</er> permission.]</ety> <def>To grant; -- used esp. in exclamations or prayers followed by a dependent clause.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>God <qex>leve</qex> all be well.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leveche</ent><br/
\'d8<hw>Le*ve"che</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. Cf. <er>Lebeccio</er>.]</ety> <fld>(Meteor.)</fld> <def>A dry sirocco of Spain.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Levee</ent><br/
<hw>Lev"ee</hw> <pr>(l<ecr/v"<esl/; <it>often</it> l<ecr/v*<emac/" in U. S.)</pr>, <pos>n.</pos> <ety>[F. <ets>lever</ets>, fr. <ets>lever</ets> to raise, <ets>se lever</ets> to rise. See <er>Lever</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>The act of rising.</def> <ldquo/ The sun's <xex>levee</xex>.<rdquo/ <rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A morning assembly or reception of visitors, -- in distinction from a <contr>soir<eacute/e</contr>, or evening assembly; a <altname>matin<eacute/e</altname>; hence, also, any general or somewhat miscellaneous gathering of guests, whether in the daytime or evening; <as>as, the president's <ex>levee</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In England a ceremonious day reception, when attended by both ladies and gentlemen, is called a <stype>drawing-room</stype>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levee</ent><br/
<hw>Lev"ee</hw>, <pos>v. t.</pos> <def>To attend the levee or levees of.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>levees</qex> all the great.</q> <rj><qau>Young.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levee</ent><br/
<hw>Lev"ee</hw>, <pos>n.</pos> <ety>[F. <ets>lev<eacute/e</ets>, fr. <ets>lever</ets> to raise. See <er>Lever</er>, and cf. <er>Levy</er>.]</ety> <def>An embankment to prevent inundation; <as>as, the <ex>levees</ex> along the Mississippi</as>; sometimes, the steep bank of a river.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levee</ent><br/
<hw>Lev"ee</hw>, <pos>v. t.</pos> <def>To keep within a channel by means of levees; <as>as, to <ex>levee</ex> a river</as>.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levee en masse</ent><br/
\'d8<hw>Le*v<eacute/e" en` masse"</hw> <pr>(l<eit/*v<asl/" <aum/N` m<adot/s")</pr> <pos>n.</pos> <ety>[F.]</ety> <def>See <cref>Levy in mass</cref>, under <er>Levy</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leveful</ent><br/
<hw>Leve"ful</hw> <pr>(l<emac/v"f<usdot/l)</pr>, <pos>a.</pos> <ety>[<ets>Leve</ets>, <pos>n.</pos> + <ets>-ful</ets>.]</ety> <def>Allowable; permissible; lawful.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Level</ent><br/
<hw>Lev"el</hw> <pr>(l<ecr/v"<ecr/l)</pr>, <pos>n.</pos> <ety>[OE. <ets>level</ets>, <ets>livel</ets>, OF. <ets>livel</ets>, F. <ets>niveau</ets>, fr. L. <ets>libella</ets> level, water level, a plumb level, dim. of <ets>libra</ets> pound, measure for liquids, balance, water poise, level. Cf. <er>Librate</er>, <er>Libella</er>.]</ety> <sn>1.</sn> <def>A line or surface to which, at every point, a vertical or plumb line is perpendicular; a line or surface which is everywhere parallel to the surface of still water; -- this is the <xex>true level</xex>, and is a curve or surface in which all points are equally distant from the center of the earth, or rather would be so if the earth were an exact sphere.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A horizontal line or plane; that is, a straight line or a plane which is tangent to a true level at a given point and hence parallel to the horizon at that point; -- this is the <xex>apparent level</xex> at the given point.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An approximately horizontal line or surface at a certain degree of altitude, or distance from the center of the earth; <as>as, to climb from the <ex>level</ex> of the coast to the <ex>level</ex> of the plateau and then descend to the <ex>level</ex> of the valley or of the sea</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>After draining of the <qex>level</qex> in Northamptonshire.</q> <rj><qau>Sir M. Hale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Shot from the deadly <qex>level</qex> of a gun.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Hence, figuratively, a certain position, rank, standard, degree, quality, character, etc., conceived of as in one of several planes of different elevation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Providence, for the most part, sets us on a <qex>level</qex>.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Somebody there of his own <qex>level</qex>.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Be the fair <qex>level</qex> of thy actions laid<br/
As temperance wills and prudence may persuade.</q> <rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A uniform or average height; a normal plane or altitude; a condition conformable to natural law or which will secure a level surface; <as>as, moving fluids seek a <ex>level</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When merit shall find its <qex>level</qex>.</q> <rj><qau>F. W. Robertson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Mech. & Surv.)</fld> <sd>(a)</sd> <def>An instrument by which to find a horizontal line, or adjust something with reference to a horizontal line.</def> <sd>(b)</sd> <def>A measurement of the difference of altitude of two points, by means of a level; <as>as, to take a <ex>level</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A horizontal passage, drift, or adit, in a mine.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Air level</b></col>, <col><b>a spirit level</b></col></mcol>. <cd>See <cref>Spirit level</cref> (below).</cd> -- <col><b>Box level</b></col>, <cd>a spirit level in which a glass-covered box is used instead of a tube.</cd> -- <mcol><col><b>Carpenter's level</b></col>, <col><b>Mason's level</b></col></mcol>, <cd>either the <xex>plumb level</xex> or a straight bar of wood, in which is imbedded a small spirit level.</cd> -- <col><b>Level of the sea</b></col>, <cd>the imaginary level from which heights and depths are calculated, taken at a mean distance between high and low water.</cd> -- <col><b>Line of levels</b></col>, <cd>a connected series of measurements, by means of a level, along a given line, as of a railroad, to ascertain the profile of the ground.</cd> -- <col><b>Plumb level</b></col>, <cd>one in which a horizontal bar is placed in true position by means of a plumb line, to which it is at right angles.</cd> -- <col><b>Spirit level</b></col>, <cd>one in which the adjustment to the horizon is shown by the position of a bubble in alcohol or ether contained in a nearly horizontal glass tube, or a circular box with a glass cover.</cd> -- <col><b>Surveyor's level</b></col>, <cd>a telescope, with a spirit level attached, and with suitable screws, etc., for accurate adjustment, the whole mounted on a tripod, for use in leveling; -- called also <altname>leveling instrument</altname>.</cd> -- <col><b>Water level</b></col>, <cd>an instrument to show the level by means of the surface of water in a trough, or in upright tubes connected by a pipe.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Level</ent><br/
<hw>Lev"el</hw> <pr>(l<ecr/v"<ecr/l)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Even; flat; having no part higher than another; having, or conforming to, the curvature which belongs to the undisturbed liquid parts of the earth's surface; <as>as, a <ex>level</ex> field; <ex>level</ex> ground; the <ex>level</ex> surface of a pond or lake.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ample spaces o'er the smooth<br/
And <qex>level</qex> pavement.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Coinciding or parallel with the plane of the horizon; horizontal; <as>as, the telescope is now <ex>level</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Even with anything else; of the same height; on the same line or plane; on the same footing; of equal importance; -- followed by <xex>with</xex>, sometimes by <xex>to</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Young boys and girls<br/
Are <qex>level</qex> now with men; the odds is gone.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Everything lies <qex>level</qex> to our wish.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Straightforward; direct; clear; open.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A very plain and <qex>level</qex> account.</q> <rj><qau>M. Arnold.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Well balanced; even; just; steady; impartial; <as>as, a <ex>level</ex> head; a <ex>level</ex> understanding. <mark>[Colloq.]</mark> </as></def> <ldquo/ A <xex>level</xex> consideration.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Phonetics)</fld> <def>Of even tone; without rising or falling inflection.</def> <rj><au>H. Sweet.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Level line</b></col> <fld>(Shipbuilding)</fld>, <cd>the outline of a section which is horizontal crosswise, and parallel with the rabbet of the keel lengthwise.</cd> -- <col><b>Level surface</b></col> <fld>(Physics)</fld>, <cd>an equipotential surface at right angles at every point to the lines of force.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Level</ent><br/
<hw>Lev"el</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Leveled</conjf> <pr>(-<ecr/ld)</pr> or <conjf>Levelled</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Leveling</conjf> or <conjf>Levelling</conjf>.]</vmorph> <sn>1.</sn> <def>To make level; to make horizontal; to bring to the condition of a level line or surface; hence, to make flat or even; <as>as, to <ex>level</ex> a road, a walk, or a garden</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To bring to a lower level; to overthrow; to topple down; to reduce to a flat surface; to lower.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And their proud structures <qex>level</qex> with the ground.</q> <rj><qau>Sandys.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>levels</qex> mountains and he raises plains.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To bring to a horizontal position, as a gun; hence, to point in taking aim; to aim; to direct.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Bertram de Gordon, standing on the castle wall, <qex>leveled</qex> a quarrel out of a crossbow.</q> <rj><qau>Stow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Figuratively, to bring to a common level or plane, in respect of rank, condition, character, privilege, etc.; <as>as, to <ex>level</ex> all the ranks and conditions of men</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To adjust or adapt to a certain level; <as>as, to <ex>level</ex> remarks to the capacity of children</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For all his mind on honor fixed is,<br/
To which he <qex>levels</qex> all his purposes.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Level</ent><br/
<hw>Lev"el</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To be level; to be on a level with, or on an equality with, something; hence, to accord; to agree; to suit.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>With such accommodation and besort<br/
As <qex>levels</qex> with her breeding.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To aim a gun, spear, etc., horizontally; hence, to aim or point a weapon in direct line with the mark; fig., to direct the eye, mind, or effort, directly to an object; <as>as, he <ex>leveled</ex> a gun at the bandit and fired</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The foeman may with as great aim <qex>level</qex> at the edge of a penknife.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The glory of God and the good of his church . . . ought to be the mark whereat we also <qex>level</qex>.</q> <rj><qau>Hooker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She <qex>leveled</qex> at our purposes.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leveler</ent><br/
<hw>Lev"el*er</hw> <pr>(-<etil/r)</pr>, <pos>n.</pos> <ety>[Written also <ets>leveller</ets>.]</ety> <sn>1.</sn> <def>One who, or that which, levels.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who would remove social inequalities or distinctions; a socialist.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>levelheaded</ent><br/
<hw>lev"el*head"ed</hw> <pos>a.</pos>  <def>exercising or showing good judgment or common sense; sensible.</def><br/
<syn><b>Syn. --</b> healthy, intelligent, sound.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p>-- <wordforms><wf>lev"el*head"ed*ly</wf>, <pos>adv.</pos> -- <wf>lev"el*head"ed*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>PJC</source>]</p>

<p><ent>Leveling</ent><br/
<hw>Lev"el*ing</hw>, <pos>n.</pos> <ety>[Written also <ets>levelling</ets>.]</ety> <sn>1.</sn> <def>The act or operation of making level.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Surveying)</fld> <def>The art or operation of using a leveling instrument for finding a horizontal line, for ascertaining the differences of level between different points of the earth's surface included in a survey, for establishing grades, etc., as in finding the descent of a river, or locating a line of railroad.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leveling instrument</b></col>. <cd>See <cref>Surveyor's level</cref>, under <er>Level</er>, <pos>n.</pos></cd> -- <col><b>Leveling staff</b></col>, <cd>a graduated rod or staff used in connection with a leveling instrument for measuring differences of level between points.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levelism</ent><br/
<hw>Lev"el*ism</hw> <pr>(-<icr/z'm)</pr>, <pos>n.</pos> <def>The disposition or endeavor to level all distinctions of rank in society.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levelly</ent><br/
<hw>Lev"el*ly</hw>, <pos>adv.</pos> <def>In an even or level manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levelness</ent><br/
<hw>Lev"el*ness</hw>, <pos>n.</pos> <def>The state or quality of being level.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leven</ent><br/
<hw>Lev"en</hw> <pr>(l<ecr/v"<eit/n)</pr>, <pos>n.</pos> <ety>[See <er>Levin</er>.]</ety> <def>Lightning.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Wild thunder dint and fiery <qex>leven</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lever</ent><br/
<hw>Lev"er</hw> <pr>(l<emac/"v<etil/r)</pr>, <pos>a.</pos> <ety>[Old compar. of <ets>leve</ets> or <ets>lief</ets>.]</ety> <def>More agreeable; more pleasing.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To be lever than</b></col>. <cd>See <cref>Had as lief</cref>, under <er>Had</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lever</ent><br/
<hw>Lev"er</hw>, <pos>adv.</pos> <def>Rather.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>For <qex>lever</qex> had I die than see his deadly face.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lever</ent><br/
<hw>Le"ver</hw> <pr>(l<emac/"v<etil/r <or/ l<ecr/v"<etil/r; 277)</pr>, <pos>n.</pos> <ety>[OE. <ets>levour</ets>, OF. <ets>leveor</ets>, prop., a lifter, fr. F. <ets>lever</ets> to raise, L. <ets>levare</ets>; akin to <ets>levis</ets> light in weight, E. <ets>levity</ets>, and perh. to E. <ets>light</ets> not heavy: cf. F. <ets>levier</ets>. Cf. <er>Alleviate</er>, <er>Elevate</er>, <er>Leaven</er>, <er>Legerdemain</er>, <er>Levee</er>, <er>Levy</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <fld>(Mech.)</fld> <def>A rigid piece which is capable of turning about one point, or axis (the fulcrum), and in which are two or more other points where forces are applied; -- used for transmitting and modifying force and motion. Specif., a bar of metal, wood, or other rigid substance, used to exert a pressure, or sustain a weight, at one point of its length, by receiving a force or power at a second, and turning at a third on a fixed point called a <xex>fulcrum</xex>. It is usually named as the first of the six mechanical powers, and is of three kinds, according as either the <xex>fulcrum</xex> F, the <xex>weight</xex> W, or the <xex>power</xex> P, respectively, is situated between the other two, as in the figures.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mach.)</fld> <sd>(a)</sd> <def>A bar, as a capstan bar, applied to a rotatory piece to turn it.</def> <sd>(b)</sd> <def>An arm on a rock shaft, to give motion to the shaft or to obtain motion from it.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Compound lever</b></col>, <cd>a machine consisting of two or more levers acting upon each other.</cd> -- <col><b>Lever escapement</b></col>. <cd>See <er>Escapement</er>.</cd> -- <col><b>Lever jack</b></col>. <cd>See <er>Jack</er>, <pos>n.</pos>, 5.</cd> -- <col><b>Lever watch</b></col>, <cd>a watch having a vibrating lever to connect the action of the escape wheel with that of the balance.</cd> -- <col><b>Universal lever</b></col>, <cd>a machine formed by a combination of a lever with the wheel and axle, in such a manner as to convert the reciprocating motion of the lever into a continued rectilinear motion of some body to which the power is applied.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leverage</ent><br/
<hw>Lev"er*age</hw> <pr>(l<ecr/v"<etil/r*<asl/j <or/ l<emac/"v<etil/r*<asl/j)</pr>, <pos>n.</pos> <def>The action of a lever; mechanical advantage gained by the lever.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Leverage of a couple</b></col> <fld>(Mech.)</fld>, <cd>the perpendicular distance between the lines of action of two forces which act in parallel and opposite directions.</cd> -- <col><b>Leverage of a force</b></col>, <cd>the perpendicular distance from the line in which a force acts upon a body to a point about which the body may be supposed to turn.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leveret</ent><br/
<hw>Lev"er*et</hw> <pr>(l<ecr/v"<etil/r*<ecr/t)</pr>, <pos>n.</pos> <ety>[F. <ets>levraut</ets>, dim. of <ets>li<egrave/vre</ets> hare, L. <ets>lepus</ets>. Cf. <er>Leporine</er>.]</ety> <fld>(Zool.)</fld> <def>A hare in the first year of its age.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leverock</ent><br/
<hw>Lev"er*ock</hw> <pr>(-<ocr/k)</pr>, <pos>n.</pos> <ety>[See <er>Lark</er>.]</ety> <def>A lark.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leverwood</ent><br/
<hw>Lev"er*wood`</hw> <pr>(l<ecr/v"<etil/r*w<oocr/d`)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The American hop hornbeam (<spn>Ostrya Virginica</spn>), a small tree with very tough wood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levesel</ent><br/
<hw>Lev"e*sel</hw> <pr>(l<ecr/v"<esl/*s<ecr/l)</pr>, <pos>n.</pos> <ety>[AS. <ets>le<aacute/f</ets> a leaf + <ets>s<ae/l</ets>, <ets>sel</ets>, a room, a hall.]</ety> <def>A leafy shelter; a place covered with foliage.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Behind the mill, under a <qex>levesel</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levet</ent><br/
<hw>Lev"et</hw> <pr>(l<ecr/v"<ecr/t)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lever</ets> to raise.]</ety> <def>A trumpet call for rousing soldiers; a reveille.</def> <mark>[Obs.]</mark> <rj><au>Hudibras.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leviable</ent><br/
<hw>Lev"i*a*ble</hw> <pr>(l<ecr/v"<icr/*<adot/*b'l)</pr>, <pos>a.</pos> <ety>[From <er>Levy</er> to assess.]</ety> <def>Fit to be levied; capable of being assessed and collected; <as>as, sums <ex>leviable</ex> by course of law</as>.</def> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leviathan</ent><br/
<hw>Le*vi"a*than</hw> <pr>(l<esl/*v<imac/"<adot/*th<ait/n)</pr>, <pos>n.</pos> <ety>[Heb. <ets>livy<amac/th<amac/n</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>An aquatic animal, described in the book of Job, ch. xli., and mentioned in other passages of Scripture.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It is not certainly known what animal is intended, whether the crocodile, the whale, or some sort of serpent.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The whale, or a great whale.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levier</ent><br/
<hw>Lev"i*er</hw> <pr>(l<ecr/v"<icr/*<etil/r)</pr>, <pos>n.</pos> <def>One who levies.</def> <rj><au>Cartwright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levigable</ent><br/
<hw>Lev"i*ga*ble</hw> <pr>(l<ecr/v"<icr/*g<adot/*b'l)</pr>, <pos>a.</pos> <ety>[See <er>Levigate</er>, <pos>v. t.</pos>]</ety> <def>Capable of being levigated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levigate</ent><br/
<hw>Lev"i*gate</hw> <pr>(-g<asl/t)</pr>, <pos>a.</pos> <ety>[L. <ets>levigatus</ets>, p. p. of <ets>levigare</ets> to lighten, fr. <ets>l<ecr/vis</ets> light.]</ety> <def>Made less harsh or burdensome; alleviated.</def> <mark>[Obs.]</mark> <rj><au>Sir T. Elyot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levigate</ent><br/
<hw>Lev"i*gate</hw> <pr>(-g<amac/t)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Levigated</conjf> <pr>(-g<amac/`t<ecr/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Levigating</conjf>.]</vmorph> <ety>[L. <ets>levigatus</ets>, p. p. of <ets>levigare</ets> to make smooth, fr. <ets>l<emac/vis</ets> smooth; akin to Gr. <grk>lei^os</grk>.]</ety> <def>To make smooth in various senses</def>: <sd>(a)</sd> <def>To free from grit; to reduce to an impalpable powder or paste.</def> <sd>(b)</sd> <def>To mix thoroughly, as liquids or semiliquids.</def> <sd>(c)</sd> <def>To polish.</def> <sd>(d)</sd> <def>To make smooth in action.</def> <ldquo/ When use hath <xex>levigated</xex> the organs.<rdquo/ <au>Barrow.</au> <sd>(e)</sd> <def>Technically, to make smooth by rubbing in a moist condition between hard surfaces, as in grinding pigments.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levigate</ent><br/
<hw>Lev"i*gate</hw> <pr>(-g<asl/t)</pr>, <pos>a.</pos> <ety>[L. <ets>levigatus</ets>, <ets>p. p.</ets>]</ety> <def>Made smooth, as if polished.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levigation</ent><br/
<hw>Lev`i*ga"tion</hw> <pr>(l<ecr/v`<icr/*g<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>levigatio</ets> a smoothing: cf. F. <ets>l<eacute/vigation</ets>.]</ety> <def>The act or operation of levigating.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levin</ent><br/
<hw>Lev"in</hw> <pr>(l<ecr/v"<icr/n)</pr>, <pos>n.</pos> <ety>[Etymol. uncertain. Cf. <er>Leven</er>.]</ety> <def>Lightning.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Levin brand</b></col>, <cd>a thunderbolt.</cd> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leviner</ent><br/
<hw>Lev"in*er</hw> <pr>(-<etil/r)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A swift hound.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levir</ent><br/
<hw>Le"vir</hw> <pr>(l<emac/"v<etil/r)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>A husband's brother; -- used in reference to levirate marriages.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leviratical</ent><br/
<ent>Levirate</ent><br/
<mhw>{ <hw>Lev"i*rate</hw> <pr>(l<ecr/v"<icr/*r<asl/t)</pr>, <hw>Lev`i*rat"ic*al</hw> <pr>(-r<acr/t"<icr/*k<ait/l)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>levir</ets> a husband's brother, brother-in-law; akin to Gr. <grk>dah`r</grk>: cf. F. <ets>l<eacute/virat</ets> leviration.]</ety> <def>Of, pertaining to, or in accordance with, a law of the ancient Israelites and other tribes and races, according to which a woman, whose husband died without issue, was married to the husband's brother.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The firstborn son of a <qex>leviratical</qex> marriage was reckoned and registered as the son of the deceased brother.</q> <rj><qau>Alford.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leviration</ent><br/
<hw>Lev`i*ra"tion</hw> <pr>(l<ecr/v`<icr/*r<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <def>Levirate marriage or marriages.</def> <rj><au>Kitto.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levirostres</ent><br/
\'d8<hw>Lev`i*ros"tres</hw> <pr>(-r<ocr/s"tr<emac/z)</pr>, <pos>n. pl.</pos> <ety>[NL., fr. L. <ets>levis</ets> light + <ets>rostrum</ets> beak.]</ety> <fld>(Zool.)</fld> <def>A group of birds, including the hornbills, kingfishers, and related forms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levitate</ent><br/
<hw>Lev"i*tate</hw> <pr>(l<ecr/v"<icr/*t<amac/t)</pr>, <pos>v. i.</pos> <ety>[L. <ets>levitas</ets>, <ets>-atis</ets>, lightness. See <er>Levity</er>.]</ety> <def>To rise, or tend to rise, as if lighter than the surrounding medium; to become buoyant; -- opposed to <ant>gravitate</ant>.</def> <rj><au>Sir. J. Herschel.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levitate</ent><br/
<hw>Lev"i*tate</hw>, <pos>v. t.</pos> <fld>(Spiritualism)</fld> <def>To make buoyant; to cause to float in the air; <as>as, to <ex>levitate</ex> a table</as>.</def> <mark>[Cant]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levitation</ent><br/
<hw>Lev`i*ta"tion</hw> <pr>(-t<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>levis</ets> light in weight.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Lightness; buoyancy; act of making light.</def> <rj><au>Paley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act or process of making buoyant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levite</ent><br/
<hw>Le"vite</hw> <pr>(l<emac/"v<imac/t)</pr>, <pos>n.</pos> <ety>[L. <ets>Levites</ets>, Gr. <grk>Leyi:`ths</grk>, fr. Heb. <ets>Levi</ets>, one of the sons of Jacob.]</ety> <sn>1.</sn> <fld>(Bib. Hist.)</fld> <def>One of the tribe or family of Levi; a descendant of Levi; esp., one subordinate to the priests (who were of the same tribe) and employed in various duties connected with the tabernacle first, and afterward the temple, such as the care of the building, bringing of wood and other necessaries for the sacrifices, the music of the services, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A priest; -- so called in contempt or ridicule.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 847 pr=VMG --></p>

<p><ent>Levitical</ent><br/
<hw>Le*vit"ic*al</hw> <pr>(l<esl/*v<icr/t"<icr/*k<ait/l)</pr>, <pos>a.</pos> <ety>[L. <ets>Leviticus</ets>, Gr. <grk>Leyitiko`s</grk>.]</ety> <sn>1.</sn> <def>Of or pertaining to a Levite or the Levites.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Priestly.</def> <ldquo/ <xex>Levitical</xex> questions.<rdquo/  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Of or pertaining to, or designating, the law contained in the book of Leviticus.</def>  <rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Levitical degrees</b></col>, <cd>degrees of relationship named in Leviticus, within which marriage is forbidden.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levitically</ent><br/
<hw>Le*vit"ic*al*ly</hw>, <pos>adv.</pos> <def>After the manner of the Levites; in accordance with the levitical law.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leviticus</ent><br/
<hw>Le*vit"i*cus</hw> <pr>(-<icr/*k<ucr/s)</pr>, <pos>n.</pos> <ety>[See <er>Levitical</er>.]</ety> <def>The third canonical book of the Old Testament, containing the laws and regulations relating to the priests and Levites among the Hebrews, or the body of the ceremonial law.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levity</ent><br/
<hw>Lev"i*ty</hw> <pr>(l<ecr/v"<icr/*t<ycr/)</pr>, <pos>n.</pos> <ety>[L. <ets>levitas</ets>, fr. <ets>levis</ets> light in weight; akin to <ets>levare</ets> to raise. See <er>Lever</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>The quality of weighing less than something else of equal bulk; relative lightness, especially as shown by rising through, or floating upon, a contiguous substance; buoyancy; -- opposed to <ant>gravity</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He gave the form of <qex>levity</qex> to that which ascended; to that which descended, the form of gravity.</q> <rj><qau>Sir. W. Raleigh.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This bubble by reason of its comparative <qex>levity</qex> to the fluidity that incloses it, would ascend to the top.</q> <rj><qau>Bentley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lack of gravity and earnestness in deportment or character; trifling gayety; frivolity; sportiveness; vanity.</def> <ldquo/ A spirit of <xex>levity</xex> and libertinism.<rdquo/  <rj><au>Atterbury.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He never employed his omnipotence out of <qex>levity</qex>.</q> <rj><qau>Calamy.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Lack of steadiness or constancy; disposition to change; fickleness; volatility.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>levity</qex> that is fatigued and disgusted with everything of which it is in possession.</q> <rj><qau>Burke.</qau></rj></p>

<p><syn><b>Syn.</b> -- Inconstancy; thoughtlessness; unsteadiness; inconsideration; volatility; flightiness.</syn> <usage> -- <er>Levity</er>, <er>Volatility</er>, <er>Flightiness</er>. All these words relate to outward conduct. <xex>Levity</xex> springs from a lightness of mind which produces a disregard of the proprieties of time and place.<xex>Volatility</xex> is a degree of levity which causes the thoughts to fly from one object to another, without resting on any for a moment. <xex>Flightiness</xex> is volatility carried to an extreme which often betrays its subject into gross impropriety or weakness. <xex>Levity</xex> of deportment, of conduct, of remark; <xex>volatility</xex> of temper, of spirits; <xex>flightiness</xex> of mind or disposition.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levo-</ent><br/
<hw>Le"vo-</hw> <pr>(l<emac/"v<osl/-)</pr> <pos>pref.</pos> <def>A prefix from L. <ets>laevus</ets></def>, meaning: <sd>(a)</sd> <def><it>Pertaining to, or toward, the left</it>; <as>as, <ex>levo</ex>rotatory</as>.</def> <sd>(b)</sd> <fld>(Chem. & Opt.)</fld> <def><it>Turning the plane of polarized light to the left</it>; <as>as, <ex>levo</ex>tartaric acid; <ex>levo</ex>racemic acid; <ex>levo</ex>gyratory crystals, etc.</as></def> <altsp>[Written also <asp>l<ae/vo-</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>levodopa</ent><br/
<hw>le`vo*do"pa</hw> <pr>(l<emac/`v<osl/*d<omac/"p<adot/)</pr>, <pos>a.</pos> <ety>[<ets>Levo-</ets> + <ets>DOPA</ets>, <ets>d</ets>ihydr<ets>o</ets>xy<ets>p</ets>henyl<ets>a</ets>lanine.]</ety> <fld>(Chem. & Biochem.)</fld> <def>A substance used as a therapy for <er>Parkinson's Disease</er>; the L form of Dopa; L-dihydroxyphenylalanine; L-hydroxytyrosine (<chform>C9H11NO4</chform>); also called <altname>L-dopa</altname>.  In the body it is converted by the enzyme dopa-decarboxylase into <cnvto>dopamine</cnvto>, the form in which it is active in the brain, affecting neural impulse transmission.</def><br/
[<source>PJC</source>]</p>

<p><ent>Levogyrate</ent><br/
<hw>Le`vo*gy"rate</hw> <pr>(-j<imac/"r<asl/t)</pr>, <pos>a.</pos> <ety>[<ets>Levo-</ets> + <ets>gyrate</ets>.]</ety> <fld>(Chem., Physics, Biochem.)</fld> <def>Turning or twisting the plane of polarization of light towards the left, as levulose, levotartaric acid, etc.; levorotatory.</def> <altsp>[Written also <asp>l<ae/vogyrate</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>levorotary</ent><br/
<hw>le`vo*ro"ta*ry</hw> <pr>(-r<omac/"t<adot/*r<ycr/)</pr>, <pos>a.</pos> <ety>[<ets>Levo-</ets> + <ets>rotary</ets>.]</ety> <fld>(Chem. & Physics)</fld> <def>Same as <er>levorotatory</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Levorotation</ent><br/
<hw>Le`vo*ro*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <altsp>[Written also <asp>l<ae/vorotation</asp>.]</altsp> <ety>[<ets>Levo-</ets> + <ets>rotation</ets>.]</ety> <fld>(Physics & Chem.)</fld> <def>Rotation in the direction of an outgoing right-handed screw; counter-clockwise rotation; -- applied chiefly to the turning of the plane of polarization of light.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Levorotatory</ent><br/
<hw>Le`vo*ro"ta*to*ry</hw> <pr>(-r<omac/"t<adot/*t<osl/*r<ycr/)</pr>, <pos>a.</pos> <ety>[<ets>Levo-</ets> + <ets>rotatory</ets>.]</ety> <fld>(Chem. & Physics)</fld> <def>Turning or rotating the plane of polarization of light towards the left; -- applied to crystals and compounds exhibiting optical activity, such as levulose, left-handed quartz crystals, etc.  Opposite of <ant>dextrorotatory</ant>.</def> <altsp>[Written also <asp>l<ae/vorotatory</asp>.]</altsp><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Levulin</ent><br/
<hw>Lev"u*lin</hw> <pr>(l<ecr/v"<usl/*l<icr/n)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A substance resembling dextrin, obtained from the bulbs of the dahlia, the artichoke, and other sources, as a colorless, spongy, amorphous material. It is so called because by decomposition it yields <xex>levulose</xex>.</def> <altsp>[Written also <asp>l<ae/vulin</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levulinic</ent><br/
<hw>Lev`u*lin"ic</hw> <pr>(-l<icr/n"<icr/k)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or denoting, an acid (called also <altname>acetyl-propionic</altname> <xex>acid</xex>), <chform>C5H8O3</chform>, obtained by the action of dilute acids on various sugars (as levulose).</def> <altsp>[Written also <asp>laevulinic</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levulosan</ent><br/
<hw>Lev`u*lo"san</hw> <pr>(-l<omac/"s<ait/n)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>An unfermentable carbohydrate obtained by gently heating levulose.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levulose</ent><br/
<hw>Lev"u*lose`</hw> <pr>(l<ecr/v"<usl/*l<omac/s`)</pr>, <pos>n.</pos> <ety>[See <er>Levo-</er>.]</ety> <fld>(Chem.)</fld> <def>A sirupy variety of sugar, rarely obtained crystallized, occurring widely in honey, ripe fruits, etc., and hence called also <altname>fruit sugar</altname>; also called <altname>fructose</altname>.  Chemical formula: <chform>C6H12O6</chform>.  It is called <xex>levulose</xex>, because it rotates the plane of polarization of light to the left, in contrast to <contr>dextrose</contr>, the other product of the hydrolysis of sucrose.</def> <altsp>[Written also <asp>laevulose</asp>.]</altsp><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><note><hand/ It is obtained, together with an equal quantity of dextrose, by the inversion of ordinary cane or beet sugar, and hence, as being an ingredient of <xex>invert sugar</xex>, is often so called.  It is fermentable, nearly as sweet as cane sugar, and is metameric with dextrose.  Cf. <er>Dextrose</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levy</ent><br/
<hw>Lev"y</hw> <pr>(-<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Levies</plw> <pr>(-<icr/z)</pr>.</plu> <ety>[A contr. of <ets>elevenpence</ets> or <ets>elevenpenny bit</ets>.]</ety> <def>A name formerly given in Pennsylvania, Maryland, and Virginia to the Spanish real of one eighth of a dollar (or 12<frac12/ cents), valued at eleven pence when the dollar was rated at 7s. 6d.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levy</ent><br/
<hw>Lev"y</hw>, <pos>n.</pos> <ety>[F. <ets>lev<eacute/e</ets>, fr. <ets>lever</ets> to raise. See <er>Lever</er>, and cf. <er>Levee</er>.]</ety> <sn>1.</sn> <def>The act of levying or collecting by authority; <as>as, the <ex>levy</ex> of troops, taxes, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>levy</qex> of all the men left under sixty.</q> <rj><qau>Thirlwall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is levied, as an army, force, tribute, etc.</def> <ldquo/ The Irish <xex>levies</xex>.<rdquo/  <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>The taking or seizure of property on executions to satisfy judgments, or on warrants for the collection of taxes; a collecting by execution.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Levy in mass</b></col> <ety>[F. <ets>lev<eacute/e en masse</ets>]</ety>, <cd>a requisition of all able-bodied men for military service.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levy</ent><br/
<hw>Lev"y</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Levied</conjf> <pr>(l<ecr/v"<icr/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Levying</conjf>.]</vmorph> <sn>1.</sn> <def>To raise, as a siege.</def> <mark>[Obs.]</mark> <au>Holland.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To raise; to collect; said of troops, to form into an army by enrollment, conscription, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Augustine . . . inflamed Ethelbert, king of Kent, to <qex>levy</qex> his power, and to war against them.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To raise or collect by assessment; to exact by authority; <as>as, to <ex>levy</ex> taxes, toll, tribute, or contributions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If they do this . . . my ransom, then,<br/
Will soon be <qex>levied</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>To gather or exact; <as>as, to <ex>levy</ex> money</as>.</def> <sd>(b)</sd> <def>To erect, build, or set up; to make or construct; to raise or cast up; <as>as, to <ex>levy</ex> a mill, dike, ditch, a nuisance, etc.</as></def> <mark>[Obs.]</mark> <au>Cowell.</au> <au>Blackstone.</au> <sd>(c)</sd> <def>To take or seize on execution; to collect by execution.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To levy a fine</b></col>, <cd>to commence and carry on a suit for assuring the title to lands or tenements.</cd> <au>Blackstone.</au> -- <col><b>To levy war</b></col>, <cd>to make or begin war; to take arms for attack; to attack.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levy</ent><br/
<hw>Lev"y</hw>, <pos>v. i.</pos> <def>To seize property, real or personal, or subject it to the operation of an execution; to make a levy; <as>as, to <ex>levy</ex> on property; the usual mode of <ex>levying</ex>, in England, is by seizing the goods.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To levy on goods and chattels</b></col>, <cd>to take into custody or seize specific property in satisfaction of a writ.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Levynite</ent><br/
<ent>Levyne</ent><br/
<mhw>{ <hw>Lev"yne</hw> <pr>(l<ecr/v"<icr/n)</pr>, <hw>Lev"yn*ite</hw> <pr>(-<icr/n*<imac/t)</pr>, }</mhw> <pos>n.</pos> <ety>[From Mr. <ets>Levy</ets>, an English mineralogist.]</ety> <fld>(Min.)</fld> <def>A whitish, reddish, or yellowish, transparent or translucent mineral, allied to chabazite.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lew</ent><br/
<hw>Lew</hw> <pr>(l<umac/)</pr>, <pos>a.</pos> <ety>[Cf. <ets>lee</ets> a calm or sheltered place, <ets>luke</ets>warm.]</ety> <def>Lukewarm; tepid.</def> <mark>[Obs.]</mark>  <rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lewd</ent><br/
<hw>Lewd</hw> <pr>(l<umac/d)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Lewder</adjf> <pr>(-<etil/r)</pr>; <pos>superl.</pos> <adjf>Lewdest</adjf>.]</amorph> <ety>[<er>OE</er>. <ets>lewed</ets>, <ets>lewd</ets>, lay, ignorant, vile, AS. <ets>l<aemac/wed</ets> laical, belonging to the laity.]</ety> <sn>1.</sn> <def>Not clerical; laic; laical; hence, unlearned; simple.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>For if a priest be foul, on whom we trust,<br/
No wonder is a <qex>lewed</qex> man to rust.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>So these great clerks their little wisdom show<br/
To mock the <qex>lewd</qex>, as learn'd in this as they.</q> <rj><qau>Sir. J. Davies.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Belonging to the lower classes, or the rabble; idle and lawless; bad; vicious.</def> <mark>[Archaic]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>But the Jews, which believed not, . . . took unto them certain <qex>lewd</qex> fellows of the baser sort, . . . and assaulted the house of Jason.</q> <rj><qau>Acts xvii. 5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Too <qex>lewd</qex> to work, and ready for any kind of mischief.</q> <rj><qau>Southey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Given to the promiscuous indulgence of lust; dissolute; lustful; libidinous.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Suiting, or proceeding from, lustfulness; involving unlawful sexual desire; <as>as, <ex>lewd</ex> thoughts, conduct, or language</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Lustful; libidinous; licentious; profligate; dissolute; sensual; unchaste; impure; lascivious; lecherous; rakish; debauched.</syn></p>

<p>-- <wordforms><wf>Lewd"ly</wf>, <pos>adv.</pos> -- <wf>Lewd"ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lewdster</ent><br/
<hw>Lewd"ster</hw> <pr>(-st<etil/r)</pr>, <pos>n.</pos> <def>A lewd person.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lewisson</ent><br/
<ent>Lewis</ent><br/
<mhw>{ <hw>Lew"is</hw> <pr>(l<umac/"<icr/s)</pr>, <hw>Lew"is*son</hw> <pr>(-s<ucr/n)</pr>, }</mhw> <pos>n.</pos> <sn>1.</sn> <def>An iron dovetailed tenon, made in sections, which can be fitted into a dovetail mortise; -- used in hoisting large stones, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A kind of shears used in cropping woolen cloth.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lewis hole</b></col>, <cd>a hole wider at the bottom than at the mouth, into which a <xex>lewis</xex> is fitted.</cd>  <rj><au>De Foe.</au></rj></cs></p>

<p><-- Lewis acid (Chem) A compound without dissociable hydrogen which acts as an acid (bonding with Lewis bases) in chemical reaction. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lex</ent><br/
\'d8<hw>Lex</hw> <pr>(l<ecr/ks)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Leges</plw> <pr>(l<emac/"j<emac/z)</pr>.</plu> <ety>[L. See <er>Legal</er>.]</ety> <def>Law; <as>as, <ex>lex talionis</ex>, the law of retaliation; <ex>lex terr<ae/</ex>, the law of the land; <ex>lex fori</ex>, the law of the forum or court; <ex>lex loci</ex>, the law of the place; <ex>lex mercatoria</ex>, the law or custom of merchants.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>lexical</ent><br/
<hw>lex"ic*al</hw> <pr>(l<ecr/ks"<icr/*k<ait/l)</pr>, <pos>a.</pos> <def>Of or pertaining to a lexicon, to lexicography, or words; according or conforming to a lexicon.</def> -- <wordforms><wf>Lex"ic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>lexicalize</ent><br/
<hw>lex"i*cal*ize</hw> <pr>(l<ecr/ks"<icr/*k<ait/l*<imac/z)</pr>, <pos>v. t.</pos> <sn>1.</sn> <def>To make into a word, coin into a word; <as>as, The concept expressed by German "Gemuetlichkeit" is not <ex>lexicalized</ex> in English</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>To increase the importance of, or emphasis on, words as opposed to other parts of a theory or program; -- said of grammatical theories and computer programs, especially programs for understanding language; <as>as, <ex>lexicalized</ex> tree-adjoining grammar</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Lexicographer</ent><br/
<hw>Lex`i*cog"ra*pher</hw> <pr>(l<ecr/ks`<icr/*k<ocr/g"r<adot/*f<etil/r)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lexikogra`fos</grk>; <grk>lexiko`n</grk> dictionary + <grk>gra`fein</grk> to write: cf. F. <ets>lexicographe</ets>. See <er>Lexicon</er>.]</ety> <def>The author or compiler of a lexicon or dictionary.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Every other author may aspire to praise; the <qex>lexicographer</qex> can only hope to escape reproach; and even this negative recompense has been yet granted to very few.</q> <rj><qau>Johnson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexicographical</ent><br/
<ent>Lexicographic</ent><br/
<mhw>{ <hw>Lex`i*co*graph"ic</hw> <pr>(l<ecr/ks`<icr/*k<osl/*gr<acr/f"<icr/k)</pr>, <hw>Lex`i*co*graph"ic*al</hw> <pr>(l<ecr/ks`<icr/*k<osl/*gr<acr/f"<icr/*k<ait/l)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F. <ets>lexicographi</ets>que.]</ety> <def>Of or pertaining to, or according to, lexicography.</def> -- <wordforms><wf>Lex`i*co*graph"ic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexicographist</ent><br/
<hw>Lex`i*cog"ra*phist</hw> <pr>(l<ecr/ks`<icr/*k<ocr/g"r<adot/*f<icr/st)</pr>, <pos>n.</pos> <def>A lexicographer.</def> <mark>[R.]</mark>  <rj><au>Southey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexicography</ent><br/
<hw>Lex`i*cog"ra*phy</hw> <pr>(l<ecr/ks`<icr/*k<ocr/g"r<adot/*f<ycr/)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lexicographie</ets>.]</ety> <def>The art, process, or occupation of making a lexicon or dictionary; the principles which are applied in making dictionaries; <as>as, with so many words <ex>lexicography</ex> can be interesting in parts but at length is rather tedious labor</as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Lexicologist</ent><br/
<hw>Lex`i*col"o*gist</hw> <pr>(l<ecr/ks`<icr/*k<ocr/l"<osl/*j<icr/st)</pr>, <pos>n.</pos> <def>One versed in lexicology.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexicology</ent><br/
<hw>Lex`i*col"o*gy</hw> <pr>(l<ecr/ks`<icr/*k<ocr/l"<osl/*j<ycr/)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lexiko`n</grk> lexicon + <ets>-logy</ets>: cf. F. <ets>lexicologie</ets>.]</ety> <def>The science of the derivation and signification of words; that branch of learning which treats of the signification and application of words.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexicon</ent><br/
<hw>Lex"i*con</hw> <pr>(l<ecr/ks"<icr/*k<ocr/n)</pr>, <pos>n.</pos> <ety>[Gr. <grk>lexiko`n</grk> (sc. <grk>bibli`on</grk>), neut. of <grk>lexiko`s</grk> of or belonging to words, fr. <grk>le`xis</grk> a speaking, speech, a way of speaking, a single word or phrase, fr. <grk>le`gein</grk> to say, to speak. See <er>Legend</er>.]</ety> <def>A vocabulary, or book containing an alphabetical arrangement of the words in a language or of a considerable number of them, with the definition of each; a dictionary; especially, a dictionary of the Greek, Hebrew, or Latin language.</def>
<-- also, a dictionary for use in computational linguistics --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexiconist</ent><br/
<hw>Lex"i*con*ist</hw>, <pos>n.</pos> <def>A writer of a lexicon.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexigraphic</ent><br/
<hw>Lex`i*graph"ic</hw> <pr>(l<ecr/ks"<icr/*gr<acr/f"<icr/k)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>lexigraphique</ets>.]</ety> <def>Of or pertaining to lexigraphy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexigraphy</ent><br/
<hw>Lex*ig"ra*phy</hw> <pr>(l<ecr/ks*<icr/g"r<adot/*f<ycr/)</pr>, <pos>n.</pos> <ety>[Gr. <grk>le`xis</grk> word + <ets>-graphy</ets>: cf. F. <ets>lexigraphie</ets>.]</ety> <def>The art or practice of defining words; definition of words.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexiphanic</ent><br/
<hw>Lex`i*phan"ic</hw> <pr>(l<ecr/ks`<icr/*f<acr/n"<icr/k)</pr>, <pos>a.</pos> <ety>[Gr. <grk>lexifa`nis</grk> a phrase monger; <grk>le`xis</grk> speech + <grk>fai`nein</grk> to show.]</ety> <def>Using, or interlarded with, pretentious words; bombastic; <as>as, a <ex>lexiphanic</ex> writer or speaker; <ex>lexiphanic</ex> writing.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexiphanicism</ent><br/
<hw>Lex`i*phan"i*cism</hw> <pr>(l<ecr/ks`<icr/*f<acr/n"<icr/*s<icr/z'm)</pr>, <pos>n.</pos> <def>The use of pretentious words, language, or style.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lexipharmic</ent><br/
<hw>Lex`i*phar"mic</hw> <pr>(l<ecr/ks`<icr/*f<aum/r"m<icr/k)</pr>, <pos>a.</pos> <def>See <er>Alexipharmic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ley</ent><br/
<hw>Ley</hw> <pr>(l<amac/)</pr>, <pos>v. t. & i.</pos> <def>To lay; to wager.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ley</ent><br/
<hw>Ley</hw>, <pos>n.</pos> <ety>[OF.]</ety> <def>Law.</def>  <rj><au>Abbott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ley</ent><br/
<hw>Ley</hw> <pr>(l<imac/)</pr>, <pos>n.</pos> <mark>[Obs.]</mark> <def>See <er>Lye</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ley</ent><br/
<hw>Ley</hw> <pr>(l<emac/)</pr>, <pos>n.</pos> <def>Grass or meadow land; a lea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ley</ent><br/
<hw>Ley</hw>, <pos>a.</pos> <def>Fallow; unseeded.</def> <mark>[Obs.]</mark>  <rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leyden phial</ent><br/
<ent>Leyden jar</ent><br/
<mhw>{ <hw>Ley"den jar"</hw> <pr>(l<imac/"d'n j<aum/r"; 277)</pr> <hw>Ley"den phi"al</hw> <pr>(f<imac/"<ait/l)</pr>.}</mhw> <pos>n.</pos> <fld>(Elec.)</fld> <def>A glass jar or bottle used to accumulate electricity.  It is coated with tin foil, within and without, nearly to its top, and is surmounted by a brass knob which communicates with the inner coating, for the purpose of charging it with electricity. It is so named from having been invented in <etsep>Leyden</etsep>, Holland.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Leymus</ent><br/
<hw>Leymus</hw> <pos>prop. n.</pos> <def>A genus that in some classifications overlaps the genus <gen>Elymus</gen>.</def><br/
<syn><b>Syn. --</b> genus <gen>Leymus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leyte</ent><br/
<hw>Leyte</hw> <pos>prop. n.</pos> <def>The name of an island in the Pacific Ocean and of a battle in World War II, at which the American forces experienced the first use of Kamikaze aircraft by the Japanese.  The return of U. S. troops to the Philippines after their expulsion by the Japanese began with landings on Leyte Island in October 1944.</def><br/
<syn><b>Syn. --</b> Leyte Island, Leyte invasion, Battle of Leyte Gulf.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Leyser</ent><br/
<hw>Ley"ser</hw> <pr>(l<amac/"z<etil/r)</pr>, <pos>n.</pos> <def>Leisure.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lese majesty</ent><br/
<ent>Leze majesty</ent><br/
<mhw><hw>Lese` maj"es*ty</hw>, <hw>Leze` maj"es*ty</hw></mhw> <pr>(l<emac/z` m<acr/j"<ecr/s*t<ycr/)</pr> <pos>n.</pos> <ety>[F. <ets>lese-majest<eacute/</ets>, fr. L. <ets>laesus</ets>, fem. <ets>laesa</ets>, injured (see <er>Lesion</er>) + <ets>majestas</ets> majesty; that is, <ets>crimen laesae majestatis</ets>.]</ety> <altsp>[Written also <asp>l<egrave/se majesty</asp>.]</altsp> <sn>1.</sn> <fld>(Law)</fld> <def>Any crime committed against the sovereign power, or against a ruler.</def><br/
[<source>1913 Webster</source>]

<p><sn>2.</sn> <def>Any affront to the dignity of an eminent or respected person.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>An attack against an institution or custom revered by the majority in a society.</def><br/
[<source>PJC</source>]</p>

<p><ent>LF</ent><br/
<hw>LF</hw> <pos>n.</pos> <fld>(Electronics)</fld> <def>Low frequency, a term used to refer to radio waves of a frequency from 30 to 300 kilohertz.  Contrasted to <contr>HF</contr>, high frequency.</def> <mark>[Acronym]</mark><br/
<syn><b>Syn. --</b> low frequency.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>LH</ent><br/
<hw>LH</hw> <pos>n.</pos> <fld>(Biochem.)</fld>  <def>An abbreviation for <sig>luteinizing hormone</sig>, a gonadotropic hormone that is secreted by the pituitary and stimulates ovulation in female mammals, and stimulates androgen release in male mammals.</def> <mark>[Acronym]</mark> <br/
<syn><b>Syn. --</b> luteinizing hormone, interstitial cell-stimulating hormone.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lhasa</ent><br/
<hw>Lhasa</hw> <pos>n.</pos> <def>The capital city of Tibet; it is the sacred city of Lamaism.</def><br/
<syn><b>Syn. --</b> Lassa, Lasa, capital of Tibet.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A breed of terrier having a long heavy coat raised in Tibet as watchdogs; also called <altname>Lhasa apso</altname>.</def><br/
<syn><b>Syn. --</b> Lhasa apso.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Lherzolite</ent><br/
<hw>Lher"zo*lite</hw> <pr>(l<etil/r"z<osl/*l<imac/t)</pr>, <pos>n.</pos> <ety>[From <ets>Lherz</ets>, a place in the Pyrenees + <ets>-lite</ets>.]</ety> <fld>(Min.)</fld> <def>An igneous rock consisting largely of chrysolite, with pyroxene and picotite (a variety of spinel containing chromium).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Li</ent><br/
<hw>Li</hw> <pr>(l<emac/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A Chinese measure of distance, being a little more than one third of a mile.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A Chinese copper coin; a cash. See <er>Cash</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liability</ent><br/
<hw>Li`a*bil"i*ty</hw> <pr>(l<imac/`<adot/*b<icr/l"<icr/*t<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Liabilities</plw> <pr>(-t<icr/z)</pr>.</plu><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The state of being liable; <as>as, the <ex>liability</ex> of an insurer; <ex>liability</ex> to accidents; <ex>liability</ex> to the law.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which one is under obligation to pay, or for which one is liable.</def> Specifically, in the <pluf>pl.</pluf>, <def>the sum of one's pecuniary obligations; -- opposed to <contr>assets</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Limited liability</b></col>. <cd>See <cref>Limited company</cref>, under <er>Limited</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liable</ent><br/
<hw>Li"a*ble</hw> <pr>(l<imac/"<adot/*b'l)</pr>, <pos>a.</pos> <ety>[From F. <ets>lier</ets> to bind, L. <ets>ligare</ets>.  Cf. <er>Ally</er>, <pos>v. t.</pos>, <er>Ligature</er>.]</ety> <sn>1.</sn> <def>Bound or obliged in law or equity; responsible; answerable; <as>as, the surety is <ex>liable</ex> for the debt of his principal</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Exposed to a certain contingency or casualty, more or less probable; -- with <ptcl>to</ptcl> and an infinitive or noun; <as>as, <ex>liable</ex> to slip; <ex>liable</ex> to accident.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Accountable; responsible; answerable; bound; subject; obnoxious; exposed.</syn> <usage> -- <er>Liable</er>, <er>Subject</er>. <xex>Liable</xex> refers to a future possible or probable happening which may not actually occur; as, horses are <xex>liable</xex> to slip; even the sagacious are <xex>liable</xex> to make mistakes. <xex>Subject</xex> refers to any actual state or condition belonging to the nature or circumstances of the person or thing spoken of, or to that which often befalls one. One whose father was <xex>subject</xex> to attacks of the gout is himself <xex>liable</xex> to have that disease. Men are constantly <xex>subject</xex> to the law, but <xex>liable</xex> to suffer by its infraction.</usage><br/
[<source>1913 Webster</source>]</p>

<p><q>Proudly secure, yet <qex>liable</qex> to fall.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>All human things are <qex>subject</qex> to decay.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liableness</ent><br/
<hw>Li"a*ble*ness</hw>, <pos>n.</pos> <def>Quality of being liable; liability.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liage</ent><br/
<hw>Li"age</hw> <pr>(l<imac/"<asl/j)</pr>, <pos>n.</pos> <ety>[Cf. OF. <ets>liage</ets> a bond. See <er>Liable</er>.]</ety> <def>Union by league; alliance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>liaise</ent><br/
<hw>li*aise"</hw> <pr>(l<emac/*<amac/z")</pr>, <pos>v. i.</pos> <ety>[By back-formation from <er>liaison</er>.]</ety> <sn>1.</sn> <def>To form or maintain a liaison{3}.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To act as a liaison{4}.</def><br/
[<source>PJC</source>]</p>

<p><ent>liaison</ent><br/
<hw>li`ai`son"</hw> <pr>(l<esl/`<asl/`z<ocir/N")</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>ligatio</ets>, fr. <ets>ligare</ets> to bind. See <er>Ligature</er>, and cf. <er>Ligation</er>.]</ety> <sn>1.</sn> <def>A union, or bond of union; an intimacy; an interrelationship.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>Specifically,</specif> <def>An illicit sexual relation between a man and a woman; a sexual afffair.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <specif>Specifically</specif>: <def>A process of communication between parts of an organization or between two organizations acting together for a common purpose.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <specif>Hence:</specif> <def>A person whose function it is to maintain such communication.</def><br/
[<source>PJC</source>]</p>

<p><sn>5.</sn> <fld>(Phonetics)</fld> <def>A pronunciation of a consonant sound that would be otherwise silent, such as the final consonant of certain French words, when the following word begins with a vowel sound.</def><br/
[<source>PJC</source>]</p>

<p><ent>Liana</ent><br/
<ent>Liane</ent><br/
<mhw>{ <hw>Li*ane"</hw> <pr>(l<isl/*<amac/n")</pr>, <hw>Li*a"na</hw> <pr>(l<isl/*<amac/"n<adot/)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>liane</ets>; prob. akin to <ets>lien</ets> a band, fr. L. <ets>ligamen</ets>, fr. <ets>ligare</ets> to bind.  Cf. <er>Lien</er>, <pos>n.</pos> ]</ety> <fld>(Bot.)</fld> <def>A luxuriant woody plant, climbing high trees and having ropelike stems. The grapevine often has the habit of a liane. Lianes are abundant in the forests of the Amazon region.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liar</ent><br/
<hw>Li"ar</hw> <pr>(l<imac/"<etil/r)</pr>, <pos>n.</pos> <ety>[OE. <ets>liere</ets>. See <er>Lie</er> to falsify.]</ety> <def>A person who knowingly utters falsehood; one who lies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liard</ent><br/
<hw>Li"ard</hw> <pr>(l<imac/"<etil/rd)</pr>, <pos>a.</pos> <ety>[OF. <ets>liart</ets>, LL. <ets>liardus</ets> gray, dapple.]</ety> <def>Gray.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Used by Chaucer as an epithet of a gray or dapple gray horse. Also used as a name for such a horse.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liard</ent><br/
\'d8<hw>Liard</hw> <pr>(ly<aum/r)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A French copper coin of one fourth the value of a sou.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lias</ent><br/
<hw>Li"as</hw> <pr>(l<imac/"<ait/s)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lias</ets>, fr. <ets>liais</ets> sort of limestone, OF. also <ets>liois</ets>; perh. of Celtic origin, cf. Armor. <ets>liach</ets>, <ets>leach</ets>, a stone, Gael. <ets>leac</ets>, W. <ets>llech</ets>.  Cf. <er>Cromlech</er>.]</ety> <fld>(Geol.)</fld> <def>The lowest of the three divisions of the Jurassic period; a name given in England and Europe to a series of marine limestones underlying the O<oum/lite. See the Chart of <er>Geology</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liassic</ent><br/
<hw>Li*as"sic</hw> <pr>(l<isl/*<acr/s"s<icr/k)</pr>, <pos>a.</pos> <fld>(Geol.)</fld> <def>Of the age of the Lias; pertaining to the Lias formation.</def> -- <def2><pos>n.</pos> <def>Same as <er>Lias</er>.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Lib</ent><br/
<hw>Lib</hw> <pr>(l<icr/b)</pr>, <pos>v. t.</pos> <ety>[Cf. <er>Glib</er> to geld.]</ety> <def>To castrate.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libament</ent><br/
<hw>Lib"a*ment</hw> <pr>(l<icr/b"<adot/*m<eit/nt)</pr>, <pos>n.</pos> <ety>[L. <ets>libamentum</ets>.]</ety> <def>Libation.</def> <mark>[Obs.]</mark>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libant</ent><br/
<hw>Li"bant</hw> <pr>(l<imac/"b<ait/nt)</pr>, <pos>a.</pos> <ety>[L. <ets>libans</ets>, p. pr. of <ets>libare</ets> to taste, touch.]</ety> <def>Sipping; touching lightly.</def> <mark>[R.]</mark>  <rj><au>Landor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libation</ent><br/
<hw>Li*ba"tion</hw> <pr>(l<isl/*b<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>libatio</ets>, fr. <ets>libare</ets> to take a little from anything, to taste, to pour out as an offering: cf. F. <ets>libation</ets>.]</ety> <def>The act of pouring a liquid or liquor, usually wine, either on the ground or on a victim in sacrifice, in honor of some deity; also, the wine or liquid thus poured out.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A heathen sacrifice or <qex>libation</qex> to the earth.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libatory</ent><br/
<hw>Li"ba*to*ry</hw> <pr>(l<imac/"b<adot/*t<osl/*r<ycr/)</pr>, <pos>a.</pos> <def>Pertaining to libation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libbard</ent><br/
<hw>Lib"bard</hw> <pr>(l<icr/b"b<etil/rd)</pr>, <pos>n.</pos> <ety>[See <er>Leopard</er>.]</ety> <def>A leopard.</def> <mark>[Obs. or Poetic]</mark>  <rj><au>Spenser. Keats.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libbard's bane</ent><br/
<hw>Lib"bard's bane`</hw> <pr>(-b<etil/rdz b<amac/n`)</pr> <pos>n.</pos> <def>Leopard's bane.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libel</ent><br/
<hw>Li"bel</hw> <pr>(l<imac/"b<ecr/l)</pr>, <pos>n.</pos> <ety>[L. <ets>libellus</ets> a little book, pamphlet, libel, lampoon, dim. of <ets>liber</ets> the liber or inner bark of a tree; also (because the ancients wrote on this bark), paper, parchment, or a roll of any material used to write upon, and hence, a book or treatise: cf. F. <ets>libelle</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A brief writing of any kind, esp. a declaration, bill, certificate, request, supplication, etc.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>libel</qex> of forsaking [divorcement].</q> <rj><qau>Wyclif (Matt. v. 31).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any defamatory writing; a lampoon; a satire.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>A malicious publication expressed either in print or in writing, or by pictures, effigies, or other signs, tending to expose another to public hatred, contempt, or ridicule. Such publication is indictable at common law.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The term, in a more extended sense, includes the publication of such writings, pictures, and the like, as are of a blasphemous, treasonable, seditious, or obscene character. These also are indictable at common law.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Law)</fld> <def>The crime of issuing a malicious defamatory publication.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Civil Law & Courts of Admiralty)</fld> <def>A written declaration or statement by the plaintiff of his cause of action, and of the relief he seeks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libel</ent><br/
<hw>Li"bel</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Libeled</conjf> <pr>(-b<ecr/ld)</pr> or <conjf>Libelled</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Libeling</conjf> or <conjf>Libelling</conjf>.]</vmorph> <sn>1.</sn> <def>To defame, or expose to public hatred, contempt, or ridicule, by a writing, picture, sign, etc.; to lampoon.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some wicked wits have <qex>libeled</qex> all the fair.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>To proceed against by filing a libel, particularly against a ship or goods.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 848 pr=VMG --></p>

<p><ent>Libel</ent><br/
<hw>Li"bel</hw> <pr>(l<imac/"b<ecr/l)</pr>, <pos>v. i.</pos> <def>To spread defamation, written or printed; -- with <ptcl>against</ptcl>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>What's this but <qex>libeling</qex> against the senate?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>[He] <qex>libels</qex> now 'gainst each great man.</q> <rj><qau>Donne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libelant</ent><br/
<hw>Li"bel*ant</hw> <pr>(-<ait/nt)</pr>, <pos>n.</pos> <def>One who libels; one who institutes a suit in an ecclesiastical or admiralty court.</def> <altsp>[Written also <asp>libellant</asp>.]</altsp>  <rj><au>Cranch.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libeler</ent><br/
<hw>Li"bel*er</hw> <pr>(-<etil/r)</pr>, <pos>n.</pos> <def>One who libels.</def> <altsp>[Written also <asp>libeller</asp>.]</altsp> <ldquo/ <xex>Libelers</xex> of others.<rdquo/  <rj><au>Buckminster.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libelist</ent><br/
<hw>Li"bel*ist</hw> <pr>(-<icr/st)</pr>, <pos>n.</pos> <def>A libeler.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Li bella</ent><br/
\'d8<hw>Li *bel"la</hw> <pr>(l<isl/*b<ecr/l"l<adot/)</pr>, <pos>n.</pos> <ety>[L., dim. of <ets>libra</ets> balance. See <er>Level</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>A small balance.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A level, or leveling instrument.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libellee</ent><br/
<hw>Li`bel*lee"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Law)</fld> <sd>(a)</sd> <def>The party against whom a libel has been filed; -- corresponding to <altname>defendant</altname> in a common law action.</def> <sd>(b)</sd> <def>The defendant in an action of libel.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>libellulid</ent><br/
<hw>li*bel"lu*lid</hw> <pr>(l<isl/*b<ecr/l"l<usl/*l<icr/d)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A dragon fly; -- from <gen>Libellula</gen>, the name of the typical genus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>libelluloid</ent><br/
<hw>li*bel"lu*loid</hw> <pr>(l<isl/*b<ecr/l"l<usl/*loid)</pr>, <pos>a.</pos> <ety>[NL. <ets>Libellula</ets>, the name of the typical genus + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld> <def>Like or pertaining to the dragon flies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libelous</ent><br/
<hw>Li"bel*ous</hw> <pr>(l<imac/"b<ecr/l*<ucr/s)</pr>, <pos>a.</pos> <def>Containing or involving a libel; defamatory; containing that which exposes some person to public hatred, contempt, or ridicule; <as>as, a <ex>libelous</ex> pamphlet</as>.</def> <altsp>[Written also <asp>libellous</asp>.]</altsp> -- <wordforms><wf>Li"bel*ous*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liber</ent><br/
\'d8<hw>Li"ber</hw> <pr>(l<imac/"b<etil/r)</pr>, <pos>n.</pos> <ety>[L. See <er>Libel</er>.]</ety> <fld>(Bot.)</fld> <def>The inner bark of plants, lying next to the wood. It usually contains a large proportion of woody, fibrous cells, and is, therefore, the part from which the fiber of the plant is obtained, as that of hemp, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Liber cells</b></col>, <cd>elongated woody cells found in the liber.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberal</ent><br/
<hw>Lib"er*al</hw> <pr>(l<icr/b"<etil/r*<ait/l)</pr>, <pos>a.</pos> <ety>[F. <ets>lib<eacute/ral</ets>, L. <ets>liberalis</ets>, from <ets>liber</ets> free; perh. akin to <ets>libet</ets>, <ets>lubet</ets>, it pleases, E. <ets>lief</ets>.  Cf. <er>Deliver</er>.]</ety> <sn>1.</sn> <def>Free by birth; hence, befitting a freeman or gentleman; refined; noble; independent; free; not servile or mean; <as>as, a <ex>liberal</ex> ancestry; a <ex>liberal</ex> spirit; <ex>liberal</ex> arts or studies.</as></def> <ldquo/ <xex>Liberal</xex> education.<rdquo/ <au>Macaulay.</au> <ldquo/ A <xex>liberal</xex> tongue.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Bestowing in a large and noble way, as a freeman; generous; bounteous; open-handed; <as>as, a <ex>liberal</ex> giver</as>.</def> <ldquo/ <xex>Liberal</xex> of praise.<rdquo/  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Infinitely good, and of his good<br/
As <qex>liberal</qex> and free as infinite.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Bestowed in a large way; hence, more than sufficient; abundant; bountiful; ample; profuse; <as>as, a <ex>liberal</ex> gift; a <ex>liberal</ex> discharge of matter or of water.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>His wealth doth warrant a <qex>liberal</qex> dower.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Not strict or rigorous; not confined or restricted to the literal sense; free; <as>as, a <ex>liberal</ex> translation of a classic, or a <ex>liberal</ex> construction of law or of language</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Not narrow or contracted in mind; not selfish; enlarged in spirit; catholic.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Free to excess; regardless of law or moral restraint; licentious.</def> <ldquo/ Most like a <xex>liberal</xex> villain.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Not bound by orthodox tenets or established forms in political or religious philosophy; independent in opinion; not conservative; friendly to great freedom in the constitution or administration of government; having tendency toward democratic or republican, as distinguished from monarchical or aristocratic, forms; <as>as, <ex>liberal</ex> thinkers; <ex>liberal</ex> Christians; the <ex>Liberal</ex> party.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>I confess I see nothing <qex>liberal</qex> in this <ldquo/ order of thoughts,<rdquo/ as Hobbes elsewhere expresses it.</q> <rj><qau>Hazlitt.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Liberal</xex> has <xex>of</xex>, sometimes <xex>with</xex>, before the thing bestowed, <xex>in</xex> before a word signifying action, and <xex>to</xex> before a person or object on which anything is bestowed; as, to be <xex>liberal of</xex>  praise or censure; <xex>liberal with</xex> money; <xex>liberal in</xex> giving; <xex>liberal to</xex> the poor.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>The liberal arts</b></col>. <cd>See under <er>Art</er>.</cd> -- <col><b>Liberal education</b></col>, <cd>education that enlarges and disciplines the mind and makes it master of its own powers, irrespective of the particular business or profession one may follow.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Generous; bountiful; munificent; beneficent; ample; large; profuse; free.</syn> <usage> -- <er>Liberal</er>, <er>Generous</er>. <xex>Liberal</xex> is <xex>freeborn</xex>, and <xex>generous</xex> is <xex>highborn</xex>. The former is opposed to the ordinary feelings of a servile state, and implies largeness of spirit in giving, judging, acting, etc. The latter expresses that nobleness of soul which is peculiarly appropriate to those of high rank, -- a spirit that goes out of self, and finds its enjoyment in consulting the feelings and happiness of others. <xex>Generosity</xex> is measured by the extent of the sacrifices it makes; <xex>liberality</xex>, by the warmth of feeling which it manifests.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberal</ent><br/
<hw>Lib"er*al</hw>, <pos>n.</pos> <def>One who favors greater freedom in political or religious matters; an opponent of the established systems; a reformer; in English politics, a member of the Liberal party, so called.  Cf. <er>Whig</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>liberalisation</ent><br/
<hw>liberalisation</hw> <pos>n.</pos> <def>Same as liberalization.</def><br/
<syn><b>Syn. --</b> liberalization, relaxation.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Liberalism</ent><br/
<hw>Lib"er*al*ism</hw> <pr>(-<icr/z'm)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>lib<eacute/ralisme</ets>.]</ety> <def>Liberal principles; the principles and methods of the liberals in politics or religion; specifically, the principles of the Liberal party.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberalist</ent><br/
<hw>Lib"er*al*ist</hw>, <pos>n.</pos> <def>A liberal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberalistic</ent><br/
<hw>Lib`er*al*is"tic</hw> <pr>(-<icr/s"t<icr/k)</pr>, <pos>a.</pos> <def>Pertaining to, or characterized by, liberalism; <as>as, <ex>liberalistic</ex> opinions</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberality</ent><br/
<hw>Lib`er*al"i*ty</hw> <pr>(-<acr/l"<icr/*t<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Liberalities</plw> <pr>(-t<icr/z)</pr>.</plu> <ety>[L. <ets>liberalitas</ets>: cf. F. <ets>lib<eacute/ralit<eacute/</ets>.]</ety> <sn>1.</sn> <def>The quality or state of being liberal; liberal disposition or practice; freedom from narrowness or prejudice; generosity; candor; charity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That <qex>liberality</qex> is but cast away<br/
Which makes us borrow what we can not pay.</q> <rj><qau>Denham.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A gift; a gratuity; -- sometimes in the plural; <as>as, a prudent man is not impoverished by his <ex>liberalities</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberalization</ent><br/
<hw>Lib`er*al*i*za"tion</hw> <pr>(-<ait/l*<icr/*z<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <def>The act of liberalizing; the act of making less strict.</def><br/
<syn><b>Syn. --</b> liberalization, relaxation.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Liberalize</ent><br/
<hw>Lib"er*al*ize</hw> <pr>(l<icr/b"<etil/r*<ait/l*<imac/z)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Liberalized</conjf> <pr>(-<imac/zd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Liberalizing</conjf> <pr>(-<imac/`z<icr/ng)</pr>.]</vmorph> <ety>[Cf. F. <ets>lib<eacute/raliser</ets>.]</ety> <def>To make liberal; to free from narrow views or prejudices; to make less strict.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To open and to <qex>liberalize</qex> the mind.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberalizer</ent><br/
<hw>Lib"er*al*i`zer</hw> <pr>(-<imac/`z<etil/r)</pr>, <pos>n.</pos> <def>One who, or that which, liberalizes.</def>  <rj><au>Emerson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberally</ent><br/
<hw>Lib"er*al*ly</hw>, <pos>adv.</pos> <def>In a liberal manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberate</ent><br/
<hw>Lib"er*ate</hw> <pr>(-<amac/t)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Liberated</conjf> <pr>(-<amac/`t<ecr/d)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Liberating</conjf> <pr>(-<amac/`t<icr/ng)</pr>.]</vmorph> <ety>[L. <ets>liberatus</ets>, p. p. of <ets>liberare</ets> to free, fr. <ets>liber</ets> free. See <er>Liberal</er>, <pos>a.</pos>, and cf. <er>Deliver</er>.]</ety> <def>To release from restraint or bondage; to set at liberty; to free; to manumit; to disengage; <as>as, to <ex>liberate</ex> a slave or prisoner; to <ex>liberate</ex> the mind from prejudice; to <ex>liberate</ex> gases.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To deliver; free; release. See <er>Deliver</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>liberated</ent><br/
<hw>liberated</hw> <pos>adj.</pos> <fld>(Chem.)</fld> <sn>1.</sn> <def>released from chemical combination, or as a consequence of chemical reaction; -- of a gas.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn>  <def>freed from bondage; -- of people.</def><br/
<syn><b>Syn. --</b> emancipated, freed.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn>  <def>free from traditional social restraints; <as>as, a <ex>liberated</ex> lifestyle</as>.</def><br/
<syn><b>Syn. --</b> emancipated.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>4.</sn> <def>stolen.</def> <mark>[jocose]</mark><br/
[<source>PJC</source>]</p>

<p><ent>liberating</ent><br/
<hw>liberating</hw> <pos>adj.</pos>  <def>giving freedom from restriction or restraint.</def><br/
<syn><b>Syn. --</b> emancipating, emancipative, freeing.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Liberation</ent><br/
<hw>Lib`er*a"tion</hw> <pr>(l<icr/b`<etil/r*<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>liberatio</ets>: cf. F. <ets>lib<eacute/ration</ets>.  Cf. <er>Livraison</er>.]</ety> <def>The act of liberating or the state of being liberated.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This mode of analysis requires perfect <qex>liberation</qex> from all prejudged system.</q> <rj><qau>Pownall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberator</ent><br/
<hw>Lib"er*a`tor</hw> <pr>(l<icr/b"<etil/r*<amac/`t<etil/r)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>One who, or that which, liberates; a deliverer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberatory</ent><br/
<hw>Lib"er*a*to*ry</hw> <pr>(-<adot/*t<osl/*r<ycr/)</pr>, <pos>a.</pos> <def>Tending, or serving, to liberate.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberian</ent><br/
<hw>Liberian</hw> <pos>adj.</pos> <def>Of or pertaining to Liberia; <as>as, <ex>Liberian</ex> ship owners; a ship of <ex>Liberian</ex> registry</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>of or pertaining to the inhabitants of Liberia; <as>as, <ex>Liberian</ex> rebels</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Liberian</ent><br/
<hw>Liberian</hw> <pos>n.</pos> <def>A native or inhabitant of Liberia.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Libertarian</ent><br/
<hw>Lib`er*ta"ri*an</hw> <pr>(-t<amac/"r<icr/*<ait/n)</pr>, <pos>a.</pos> <ety>[See <er>Liberty</er>.]</ety> <def>Pertaining to liberty, or to the doctrine of free will, as opposed to the doctrine of necessity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libertarian</ent><br/
<hw>Lib`er*ta"ri*an</hw>, <pos>n.</pos> <def>One who holds to the doctrine of free will.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libertarianism</ent><br/
<hw>Lib`er*ta"ri*an*ism</hw> <pr>(-<icr/z'm)</pr>, <pos>n.</pos> <def>Libertarian principles or doctrines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberticide</ent><br/
<hw>Lib"er*ti*cide</hw> <pr>(l<icr/b"<etil/r*t<icr/*s<imac/d)</pr>, <pos>n.</pos> <ety>[L. <ets>libertas</ets> liberty + <ets>caedere</ets> to kill: cf. (for sense 2) F. <ets>liberticide</ets>.]</ety> <sn>1.</sn> <def>The destruction of civil liberty.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A destroyer of civil liberty.</def>  <rj><au>B. F. Wade.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libertinage</ent><br/
<hw>Lib"er*tin*age</hw> <pr>(-t<icr/n*<asl/j)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>libertinage</ets>. See <er>Libertine</er>.]</ety> <def>Libertinism; license.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libertine</ent><br/
<hw>Lib"er*tine</hw> <pr>(-t<icr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>libertinus</ets> freedman, from <ets>libertus</ets> one made free, fr. <ets>liber</ets> free: cf. F. <ets>libertin</ets>. See <er>Liberal</er>.]</ety> <sn>1.</sn> <fld>(Rom. Antiq.)</fld> <def>A manumitted slave; a freedman; also, the son of a freedman.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eccl. Hist.)</fld> <def>One of a sect of Anabaptists, in the fifteenth and early part of the sixteenth century, who rejected many of the customs and decencies of life, and advocated a community of goods and of women.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>One free from restraint; one who acts according to his impulses and desires; now, specifically, one who gives rein to lust; a rake; a debauchee.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like a puffed and reckless <qex>libertine</qex>,<br/
Himself the primrose path of dalliance treads.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A defamatory name for a freethinker.</def> <mark>[Obsolescent]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libertine</ent><br/
<hw>Lib"er*tine</hw>, <pos>a.</pos> <ety>[L. <ets>libertinus</ets> of a freedman: cf. F. <ets>libertin</ets>. See <er>Libertine</er>, <pos>n.</pos> ]</ety> <sn>1.</sn> <def>Free from restraint; uncontrolled.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>You are too much <qex>libertine</qex>.</q> <rj><qau>Beau. & Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Dissolute; licentious; profligate; loose in morals; <as>as, <ex>libertine</ex> principles or manners</as>.</def>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libertinism</ent><br/
<hw>Lib"er*tin*ism</hw> <pr>(-t<icr/n*<icr/z'm)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The state of a libertine or freedman.</def> <mark>[R.]</mark>  <rj><au>Hammond.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Licentious conduct; debauchery; lewdness.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Licentiousness of principle or opinion.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That spirit of religion and seriousness vanished all at once, and a spirit of liberty and <qex>libertinism</qex>, of infidelity and profaneness, started up in the room of it.</q> <rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Liberty</ent><br/
<hw>Lib"er*ty</hw> <pr>(l<icr/b"<etil/r*t<ycr/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Liberties</plw> <pr>(-t<icr/z)</pr>.</plu> <ety>[OE. <ets>liberte</ets>, F. <ets>libert<eacute/</ets>, fr. L. <ets>libertas</ets>, fr. <ets>liber</ets> free. See <er>Liberal</er>.]</ety> <sn>1.</sn> <def>The state of a free person; exemption from subjection to the will of another claiming ownership of the person or services; freedom; -- opposed to slavery, serfdom, bondage, or subjection.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But ye . . . caused every man his servant, and every man his handmaid whom he had set at <qex>liberty</qex> at their pleasure, to return, and brought them into subjection.</q> <rj><qau>Jer. xxxiv. 16.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Delivered fro the bondage of corruption into the glorious <qex>liberty</qex> of the sons of God.</q> <rj><qau>Bible, 1551. Rom. viii. 21.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Freedom from imprisonment, bonds, or other restraint upon locomotion.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Being pent from <qex>liberty</qex>, as I am now.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A privilege conferred by a superior power; permission granted; leave; <as>as, <ex>liberty</ex> given to a child to play, or to a witness to leave a court, and the like</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Privilege; exemption; franchise; immunity enjoyed by prescription or by grant; <as>as, the <ex>liberties</ex> of the commercial cities of Europe</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His majesty gave not an entire county to any; much less did he grant . . . any extraordinary <qex>liberties</qex>.</q> <rj><qau>Sir J. Davies.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The place within which certain immunities are enjoyed, or jurisdiction is exercised.</def> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Brought forth into some public or open place within the <qex>liberty</qex> of the city, and there . . . burned.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A certain amount of freedom; permission to go freely within certain limits; also, the place or limits within which such freedom is exercised; <as>as, the <ex>liberties</ex> of a prison</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A privilege or license in violation of the laws of etiquette or propriety; <as>as, to permit, or take, a <ex>liberty</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He was repeatedly provoked into striking those who had taken <qex>liberties</qex> with him.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>The power of choice; freedom from necessity; freedom from compulsion or constraint in willing.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The idea of <qex>liberty</qex> is the idea of a power in any agent to do or forbear any particular action, according to the determination or thought of the mind, whereby either of them is preferred to the other.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This <qex>liberty</qex> of judgment did not of necessity lead to lawlessness.</q> <rj><qau>J. A. Symonds.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Manege)</fld> <def>A curve or arch in a bit to afford room for the tongue of the horse.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Naut.)</fld> <def>Leave of absence; permission to go on shore.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>At liberty</b></col>. <sd>(a)</sd> <cd>Unconfined; free.</cd> <sd>(b)</sd> <cd>At leisure.</cd> -- <col><b>Civil liberty</b></col>, <cd>exemption from arbitrary interference with person, opinion, or property, on the part of the government under which one lives, and freedom to take part in modifying that government or its laws.</cd> -- <col><b>Liberty bell</b></col>. <cd>See under <er>Bell</er>.</cd> -- <col><b>Liberty cap</b></col>. <sd>(a)</sd> <cd>The Roman <xex>pileus</xex> which was given to a slave at his manumission.</cd> <sd>(b)</sd> <cd>A limp, close-fitting cap with which the head of representations of the goddess of liberty is often decked. It is sometimes represented on a spear or a liberty pole.</cd> -- <col><b>Liberty of the press</b></col>, <cd>freedom to print and publish without official supervision.</cd> <col><b>Liberty party</b></col>, <cd>the party, in the American Revolution, which favored independence of England; in more recent usage, a party which favored the emancipation of the slaves.</cd> -- <col><b>Liberty pole</b></col>, <cd>a tall flagstaff planted in the ground, often surmounted by a liberty cap.</cd> <mark>[U. S.]</mark> -- <col><b>Moral liberty</b></col>, <cd>that liberty of choice which is essential to moral responsibility.</cd> -- <col><b>Religious liberty</b></col>, <cd>freedom of religious opinion and worship.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Leave; permission; license.</syn> <usage> -- <er>Liberty</er>, <er>Freedom</er>. These words, though often interchanged, are distinct in some of  their applications. <xex>Liberty</xex> has reference to previous restraint; <xex>freedom</xex>, to the simple, unrepressed exercise of our powers. A slave is set at <xex>liberty</xex>; his master had always been in a state of <xex>freedom</xex>. A prisoner under trial may ask <xex>liberty</xex> (exemption from restraint) to speak his sentiments with <xex>freedom</xex> (the spontaneous and bold utterance of his feelings). The <xex>liberty</xex> of the press is our great security for <xex>freedom</xex> of thought.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libethenite</ent><br/
<hw>Li*beth"en*ite</hw> <pr>(l<icr/*b<ecr/th"<ecr/n*<imac/t)</pr>, <pos>n.</pos> <ety>[From <ets>Libethen</ets>, in Hungary, where it was first found.]</ety> <fld>(Min.)</fld> <def>A mineral of an olive-green color, commonly in orthorhombic crystals. It is a hydrous phosphate of copper.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>libidinal</ent><br/
<hw>libidinal</hw> <pos>adj.</pos> <def>Of or pertaining to the libido; caused by libido; <as>as, <ex>libidinal</ex> gratification; <ex>libidinal</ex> impulses</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Libidinist</ent><br/
<hw>Li*bid"i*nist</hw> <pr>(l<icr/*b<icr/d"<icr/*n<icr/st)</pr>, <pos>n.</pos> <ety>[See <er>Libidinous</er>.]</ety> <def>One given to lewdness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libidinosity</ent><br/
<hw>Li*bid`i*nos"i*ty</hw> <pr>(-n<ocr/s"<icr/*t<ycr/)</pr>, <pos>n.</pos> <def>The state or quality of being libidinous; libidinousness.</def>
 <rj><qau>Skelton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Libidinous</ent><br/
<hw>Li*bid"i*nous</hw> <pr>(-n<ucr/s)</pr>, <pos>a.</pos> <ety>[L. <ets>libidinosus</ets>, fr. <ets>libido</ets>, <ets>libidinis</ets>, pleasure, desire, lust, fr. <ets>libet</ets>, <ets>lubet</ets>, it pleases: cf. F. <ets>libidineux</ets>. See <er>Lief</er>.]</ety> <def>Having lustful desires; characterized by lewdness; sensual; lascivious.</def> -- <wordforms><wf>Li*bid"i*nous*ly</wf>, <pos>adv.</pos> -- <wf>Li*bid"i*nous*ness