/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.fetch.subphase.InnerHitsPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.tasks.TaskCancelledException;

public class FetchPhase
implements SearchPhase {
    private static final Logger LOGGER = LogManager.getLogger(FetchPhase.class);
    private final FetchSubPhase[] fetchSubPhases;

    public FetchPhase(List<FetchSubPhase> fetchSubPhases) {
        this.fetchSubPhases = fetchSubPhases.toArray(new FetchSubPhase[fetchSubPhases.size() + 1]);
        this.fetchSubPhases[fetchSubPhases.size()] = new InnerHitsPhase(this);
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        FieldsVisitor fieldsVisitor;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchPhase.SearchContextSourcePrinter(context));
        }
        HashMap<String, Set<String>> storedToRequestedFields = new HashMap<String, Set<String>>();
        StoredFieldsContext storedFieldsContext = context.storedFieldsContext();
        if (storedFieldsContext == null) {
            if (!context.hasScriptFields() && !context.hasFetchSourceContext()) {
                context.fetchSourceContext(new FetchSourceContext(true));
            }
            fieldsVisitor = new FieldsVisitor(context.sourceRequested());
        } else if (!storedFieldsContext.fetchFields()) {
            fieldsVisitor = null;
        } else {
            for (String fieldNameOrPattern : context.storedFieldsContext().fieldNames()) {
                if (fieldNameOrPattern.equals("_source")) {
                    FetchSourceContext fetchSourceContext = context.hasFetchSourceContext() ? context.fetchSourceContext() : FetchSourceContext.FETCH_SOURCE;
                    context.fetchSourceContext(new FetchSourceContext(true, fetchSourceContext.includes(), fetchSourceContext.excludes()));
                    continue;
                }
                Set<String> fieldNames = context.mapperService().simpleMatchToFullName(fieldNameOrPattern);
                for (String fieldName : fieldNames) {
                    MappedFieldType fieldType = context.smartNameFieldType(fieldName);
                    if (fieldType == null) {
                        if (context.getObjectMapper(fieldName) == null) continue;
                        throw new IllegalArgumentException("field [" + fieldName + "] isn't a leaf field");
                    }
                    String storedField = fieldType.name();
                    Set requestedFields = storedToRequestedFields.computeIfAbsent(storedField, key -> new HashSet());
                    requestedFields.add(fieldName);
                }
            }
            boolean loadSource = context.sourceRequested();
            fieldsVisitor = storedToRequestedFields.isEmpty() ? new FieldsVisitor(loadSource) : new CustomFieldsVisitor(storedToRequestedFields.keySet(), loadSource);
        }
        try {
            SearchHit[] hits = new SearchHit[context.docIdsToLoadSize()];
            FetchSubPhase.HitContext hitContext = new FetchSubPhase.HitContext();
            for (int index = 0; index < context.docIdsToLoadSize(); ++index) {
                int subDocId;
                if (context.isCancelled()) {
                    throw new TaskCancelledException("cancelled");
                }
                int docId = context.docIdsToLoad()[context.docIdsToLoadFrom() + index];
                int readerIndex = ReaderUtil.subIndex((int)docId, (List)context.searcher().getIndexReader().leaves());
                LeafReaderContext subReaderContext = (LeafReaderContext)context.searcher().getIndexReader().leaves().get(readerIndex);
                int rootDocId = this.findRootDocumentIfNested(context, subReaderContext, subDocId = docId - subReaderContext.docBase);
                SearchHit searchHit = rootDocId != -1 ? this.createNestedSearchHit(context, docId, subDocId, rootDocId, storedToRequestedFields, subReaderContext) : this.createSearchHit(context, fieldsVisitor, docId, subDocId, storedToRequestedFields, subReaderContext);
                hits[index] = searchHit;
                hitContext.reset(searchHit, subReaderContext, subDocId, context.searcher());
                for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
                    fetchSubPhase.hitExecute(context, hitContext);
                }
            }
            if (context.isCancelled()) {
                throw new TaskCancelledException("cancelled");
            }
            for (FetchSubPhase fetchSubPhase : this.fetchSubPhases) {
                fetchSubPhase.hitsExecute(context, hits);
                if (!context.isCancelled()) continue;
                throw new TaskCancelledException("cancelled");
            }
            TotalHits totalHits = context.queryResult().getTotalHits();
            context.fetchResult().hits(new SearchHits(hits, totalHits, context.queryResult().getMaxScore()));
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    private int findRootDocumentIfNested(SearchContext context, LeafReaderContext subReaderContext, int subDocId) throws IOException {
        BitSet bits;
        if (context.mapperService().hasNested() && !(bits = context.bitsetFilterCache().getBitSetProducer(Queries.newNonNestedFilter(context.indexShard().indexSettings().getIndexVersionCreated())).getBitSet(subReaderContext)).get(subDocId)) {
            return bits.nextSetBit(subDocId);
        }
        return -1;
    }

    private SearchHit createSearchHit(SearchContext context, FieldsVisitor fieldsVisitor, int docId, int subDocId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext) {
        DocumentMapper documentMapper = context.mapperService().documentMapper();
        Text typeText = documentMapper.typeText();
        if (fieldsVisitor == null) {
            return new SearchHit(docId, null, typeText, null);
        }
        Map<String, DocumentField> searchFields = this.getSearchFields(context, fieldsVisitor, subDocId, storedToRequestedFields, subReaderContext);
        SearchHit searchHit = new SearchHit(docId, fieldsVisitor.uid().id(), typeText, searchFields);
        SourceLookup sourceLookup = context.lookup().source();
        sourceLookup.setSegmentAndDocument(subReaderContext, subDocId);
        if (fieldsVisitor.source() != null) {
            sourceLookup.setSource(fieldsVisitor.source());
        }
        return searchHit;
    }

    private Map<String, DocumentField> getSearchFields(SearchContext context, FieldsVisitor fieldsVisitor, int subDocId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext) {
        this.loadStoredFields(context.shardTarget(), subReaderContext, fieldsVisitor, subDocId);
        fieldsVisitor.postProcess(context.mapperService());
        if (fieldsVisitor.fields().isEmpty()) {
            return null;
        }
        HashMap<String, DocumentField> searchFields = new HashMap<String, DocumentField>(fieldsVisitor.fields().size());
        for (Map.Entry<String, List<Object>> entry : fieldsVisitor.fields().entrySet()) {
            String storedField = entry.getKey();
            List<Object> storedValues = entry.getValue();
            if (storedToRequestedFields.containsKey(storedField)) {
                for (String requestedField : storedToRequestedFields.get(storedField)) {
                    searchFields.put(requestedField, new DocumentField(requestedField, storedValues));
                }
                continue;
            }
            searchFields.put(storedField, new DocumentField(storedField, storedValues));
        }
        return searchFields;
    }

    private SearchHit createNestedSearchHit(SearchContext context, int nestedTopDocId, int nestedSubDocId, int rootSubDocId, Map<String, Set<String>> storedToRequestedFields, LeafReaderContext subReaderContext) throws IOException {
        BytesReference source;
        Uid uid;
        boolean needSource;
        boolean bl = needSource = context.sourceRequested() || context.highlight() != null;
        if (needSource || !(context instanceof InnerHitsContext.InnerHitSubContext)) {
            FieldsVisitor rootFieldsVisitor = new FieldsVisitor(needSource);
            this.loadStoredFields(context.shardTarget(), subReaderContext, rootFieldsVisitor, rootSubDocId);
            rootFieldsVisitor.postProcess(context.mapperService());
            uid = rootFieldsVisitor.uid();
            source = rootFieldsVisitor.source();
        } else {
            uid = ((InnerHitsContext.InnerHitSubContext)context).getUid();
            source = null;
        }
        Map<String, DocumentField> searchFields = null;
        if (context.hasStoredFields() && !context.storedFieldsContext().fieldNames().isEmpty()) {
            CustomFieldsVisitor nestedFieldsVisitor = new CustomFieldsVisitor(storedToRequestedFields.keySet(), false);
            searchFields = this.getSearchFields(context, nestedFieldsVisitor, nestedSubDocId, storedToRequestedFields, subReaderContext);
        }
        DocumentMapper documentMapper = context.mapperService().documentMapper();
        SourceLookup sourceLookup = context.lookup().source();
        sourceLookup.setSegmentAndDocument(subReaderContext, nestedSubDocId);
        ObjectMapper nestedObjectMapper = documentMapper.findNestedObjectMapper(nestedSubDocId, context, subReaderContext);
        assert (nestedObjectMapper != null);
        SearchHit.NestedIdentity nestedIdentity = this.getInternalNestedIdentity(context, nestedSubDocId, subReaderContext, context.mapperService(), nestedObjectMapper);
        if (source != null) {
            HashMap<String, Object> nestedSourceAsMap;
            Tuple<XContentType, Map<String, Object>> tuple = XContentHelper.convertToMap(source, true);
            Map sourceAsMap = (Map)tuple.v2();
            HashMap<String, Object> current = nestedSourceAsMap = new HashMap<String, Object>();
            for (SearchHit.NestedIdentity nested = nestedIdentity; nested != null; nested = nested.getChild()) {
                List<Object> nestedParsedSource;
                String nestedPath = nested.getField().string();
                current.put(nestedPath, new HashMap());
                Object extractedValue = XContentMapValues.extractValue(nestedPath, sourceAsMap);
                if (extractedValue instanceof List) {
                    nestedParsedSource = (List<Object>)extractedValue;
                } else if (extractedValue instanceof Map) {
                    nestedParsedSource = Collections.singletonList(extractedValue);
                } else {
                    throw new IllegalStateException("extracted source isn't an object or an array");
                }
                if (!(nestedParsedSource.get(0) instanceof Map) && !nestedObjectMapper.parentObjectMapperAreNested(context.mapperService())) {
                    throw new IllegalArgumentException("Cannot execute inner hits. One or more parent object fields of nested field [" + nestedObjectMapper.name() + "] are not nested. All parent fields need to be nested fields too");
                }
                sourceAsMap = (Map)nestedParsedSource.get(nested.getOffset());
                if (nested.getChild() == null) {
                    current.put(nestedPath, sourceAsMap);
                    continue;
                }
                HashMap next = new HashMap();
                current.put(nestedPath, next);
                current = next;
            }
            context.lookup().source().setSource(nestedSourceAsMap);
            XContentType contentType = (XContentType)tuple.v1();
            context.lookup().source().setSourceContentType(contentType);
        }
        return new SearchHit(nestedTopDocId, uid.id(), documentMapper.typeText(), nestedIdentity, searchFields);
    }

    private SearchHit.NestedIdentity getInternalNestedIdentity(SearchContext context, int nestedSubDocId, LeafReaderContext subReaderContext, MapperService mapperService, ObjectMapper nestedObjectMapper) throws IOException {
        int currentParent = nestedSubDocId;
        ObjectMapper current = nestedObjectMapper;
        String originalName = nestedObjectMapper.name();
        SearchHit.NestedIdentity nestedIdentity = null;
        IndexSettings indexSettings = context.getQueryShardContext().getIndexSettings();
        do {
            int docId;
            Query parentFilter;
            ObjectMapper nestedParentObjectMapper;
            if ((nestedParentObjectMapper = current.getParentObjectMapper(mapperService)) != null) {
                if (!nestedParentObjectMapper.nested().isNested()) {
                    current = nestedParentObjectMapper;
                    continue;
                }
                parentFilter = nestedParentObjectMapper.nestedTypeFilter();
            } else {
                parentFilter = Queries.newNonNestedFilter(context.indexShard().indexSettings().getIndexVersionCreated());
            }
            Query childFilter = nestedObjectMapper.nestedTypeFilter();
            if (childFilter == null) {
                current = nestedParentObjectMapper;
                continue;
            }
            Weight childWeight = context.searcher().createWeight(context.searcher().rewrite(childFilter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer childScorer = childWeight.scorer(subReaderContext);
            if (childScorer == null) {
                current = nestedParentObjectMapper;
                continue;
            }
            DocIdSetIterator childIter = childScorer.iterator();
            BitSet parentBits = context.bitsetFilterCache().getBitSetProducer(parentFilter).getBitSet(subReaderContext);
            int offset = 0;
            if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_6_5_0)) {
                int previousParent = parentBits.prevSetBit(currentParent);
                docId = childIter.advance(previousParent + 1);
                while (docId < nestedSubDocId && docId != Integer.MAX_VALUE) {
                    ++offset;
                    docId = childIter.nextDoc();
                }
                currentParent = nestedSubDocId;
            } else {
                int nextParent = parentBits.nextSetBit(currentParent);
                docId = childIter.advance(currentParent + 1);
                while (docId < nextParent && docId != Integer.MAX_VALUE) {
                    ++offset;
                    docId = childIter.nextDoc();
                }
                currentParent = nextParent;
            }
            current = nestedObjectMapper = nestedParentObjectMapper;
            int currentPrefix = current == null ? 0 : current.name().length() + 1;
            nestedIdentity = new SearchHit.NestedIdentity(originalName.substring(currentPrefix), offset, nestedIdentity);
            if (current == null) continue;
            originalName = current.name();
        } while (current != null);
        return nestedIdentity;
    }

    private void loadStoredFields(SearchShardTarget shardTarget, LeafReaderContext readerContext, FieldsVisitor fieldVisitor, int docId) {
        fieldVisitor.reset();
        try {
            readerContext.reader().document(docId, (StoredFieldVisitor)fieldVisitor);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(shardTarget, "Failed to fetch doc id [" + docId + "]", e);
        }
    }
}

