/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.transport.Transport;

abstract class AbstractSearchAsyncAction<Result extends SearchPhaseResult>
extends SearchPhase
implements SearchPhaseContext {
    private static final float DEFAULT_INDEX_BOOST = 1.0f;
    private final Logger logger;
    private final SearchTransportService searchTransportService;
    private final Executor executor;
    private final ActionListener<SearchResponse> listener;
    private final SearchRequest request;
    private final BiFunction<String, String, Transport.Connection> nodeIdToConnection;
    private final SearchTask task;
    private final SearchPhaseResults<Result> results;
    private final long clusterStateVersion;
    private final Map<String, AliasFilter> aliasFilter;
    private final Map<String, Float> concreteIndexBoosts;
    private final Map<String, Set<String>> indexRoutings;
    private final SetOnce<AtomicArray<ShardSearchFailure>> shardFailures = new SetOnce();
    private final Object shardFailuresMutex = new Object();
    private final AtomicInteger successfulOps = new AtomicInteger();
    private final AtomicInteger skippedOps = new AtomicInteger();
    private final TransportSearchAction.SearchTimeProvider timeProvider;
    private final SearchResponse.Clusters clusters;
    private final GroupShardsIterator<SearchShardIterator> toSkipShardsIts;
    protected final GroupShardsIterator<SearchShardIterator> shardsIts;
    private final int expectedTotalOps;
    private final AtomicInteger totalOps = new AtomicInteger();
    private final int maxConcurrentRequestsPerNode;
    private final Map<String, PendingExecutions> pendingExecutionsPerNode = new ConcurrentHashMap<String, PendingExecutions>();
    private final boolean throttleConcurrentRequests;

    AbstractSearchAsyncAction(String name, Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, long clusterStateVersion, SearchTask task, SearchPhaseResults<Result> resultConsumer, int maxConcurrentRequestsPerNode, SearchResponse.Clusters clusters) {
        super(name);
        ArrayList<SearchShardIterator> toSkipIterators = new ArrayList<SearchShardIterator>();
        ArrayList<SearchShardIterator> iterators = new ArrayList<SearchShardIterator>();
        for (SearchShardIterator iterator : shardsIts) {
            if (iterator.skip()) {
                toSkipIterators.add(iterator);
                continue;
            }
            iterators.add(iterator);
        }
        this.toSkipShardsIts = new GroupShardsIterator(toSkipIterators, false);
        this.shardsIts = new GroupShardsIterator(iterators, false);
        this.expectedTotalOps = shardsIts.totalSizeWith1ForEmpty();
        this.maxConcurrentRequestsPerNode = maxConcurrentRequestsPerNode;
        this.throttleConcurrentRequests = maxConcurrentRequestsPerNode < shardsIts.size();
        this.timeProvider = timeProvider;
        this.logger = logger;
        this.searchTransportService = searchTransportService;
        this.executor = executor;
        this.request = request;
        this.task = task;
        this.listener = listener;
        this.nodeIdToConnection = nodeIdToConnection;
        this.clusterStateVersion = clusterStateVersion;
        this.concreteIndexBoosts = concreteIndexBoosts;
        this.aliasFilter = aliasFilter;
        this.indexRoutings = indexRoutings;
        this.results = resultConsumer;
        this.clusters = clusters;
    }

    long buildTookInMillis() {
        return this.timeProvider.buildTookInMillis();
    }

    public final void start() {
        if (this.getNumShards() == 0) {
            int trackTotalHitsUpTo = this.request.source() == null ? 10000 : (this.request.source().trackTotalHitsUpTo() == null ? 10000 : this.request.source().trackTotalHitsUpTo());
            boolean withTotalHits = trackTotalHitsUpTo != -1;
            this.listener.onResponse(new SearchResponse(InternalSearchResponse.empty(withTotalHits), null, 0, 0, 0, this.buildTookInMillis(), ShardSearchFailure.EMPTY_ARRAY, this.clusters));
            return;
        }
        this.executePhase(this);
    }

    public final void run() {
        for (SearchShardIterator iterator : this.toSkipShardsIts) {
            assert (iterator.skip());
            this.skipShard(iterator);
        }
        if (this.shardsIts.size() > 0) {
            assert (this.request.allowPartialSearchResults() != null) : "SearchRequest missing setting for allowPartialSearchResults";
            if (!this.request.allowPartialSearchResults().booleanValue()) {
                StringBuilder missingShards = new StringBuilder();
                for (int index = 0; index < this.shardsIts.size(); ++index) {
                    SearchShardIterator shardRoutings = this.shardsIts.get(index);
                    if (shardRoutings.size() != 0) continue;
                    if (missingShards.length() > 0) {
                        missingShards.append(", ");
                    }
                    missingShards.append(shardRoutings.shardId());
                }
                if (missingShards.length() > 0) {
                    String msg = "Search rejected due to missing shards [" + missingShards + "]. Consider using `allow_partial_search_results` setting to bypass this error.";
                    throw new SearchPhaseExecutionException(this.getName(), msg, null, ShardSearchFailure.EMPTY_ARRAY);
                }
            }
            for (int index = 0; index < this.shardsIts.size(); ++index) {
                SearchShardIterator shardRoutings = this.shardsIts.get(index);
                assert (!shardRoutings.skip());
                this.performPhaseOnShard(index, shardRoutings, shardRoutings.nextOrNull());
            }
        }
    }

    void skipShard(SearchShardIterator iterator) {
        this.successfulOps.incrementAndGet();
        this.skippedOps.incrementAndGet();
        assert (iterator.skip());
        this.successfulShardExecution(iterator);
    }

    private void performPhaseOnShard(final int shardIndex, final SearchShardIterator shardIt, final ShardRouting shard) {
        if (shard == null) {
            this.fork(() -> this.onShardFailure(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId())));
        } else {
            final PendingExecutions pendingExecutions = this.throttleConcurrentRequests ? this.pendingExecutionsPerNode.computeIfAbsent(shard.currentNodeId(), n -> new PendingExecutions(this.maxConcurrentRequestsPerNode)) : null;
            Runnable r = () -> {
                final Thread thread = Thread.currentThread();
                try {
                    this.executePhaseOnShard(shardIt, shard, new SearchActionListener<Result>(shardIt.newSearchShardTarget(shard.currentNodeId()), shardIndex){

                        @Override
                        public void innerOnResponse(Result result) {
                            try {
                                AbstractSearchAsyncAction.this.onShardResult(result, shardIt);
                            }
                            finally {
                                AbstractSearchAsyncAction.this.executeNext(pendingExecutions, thread);
                            }
                        }

                        @Override
                        public void onFailure(Exception t) {
                            try {
                                AbstractSearchAsyncAction.this.onShardFailure(shardIndex, shard, shard.currentNodeId(), shardIt, t);
                            }
                            finally {
                                AbstractSearchAsyncAction.this.executeNext(pendingExecutions, thread);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    try {
                        this.fork(() -> this.onShardFailure(shardIndex, shard, shard.currentNodeId(), shardIt, e));
                    }
                    finally {
                        this.executeNext(pendingExecutions, thread);
                    }
                }
            };
            if (this.throttleConcurrentRequests) {
                pendingExecutions.tryRun(r);
            } else {
                r.run();
            }
        }
    }

    protected abstract void executePhaseOnShard(SearchShardIterator var1, ShardRouting var2, SearchActionListener<Result> var3);

    private void fork(final Runnable runnable) {
        this.executor.execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
            }

            @Override
            protected void doRun() {
                runnable.run();
            }

            @Override
            public boolean isForceExecution() {
                return true;
            }
        });
    }

    @Override
    public final void executeNextPhase(SearchPhase currentPhase, SearchPhase nextPhase) {
        if (this.successfulOps.get() == 0) {
            ShardOperationFailedException[] shardSearchFailures = ExceptionsHelper.groupBy(this.buildShardFailures());
            ElasticsearchException cause = shardSearchFailures.length == 0 ? null : ElasticsearchException.guessRootCauses(shardSearchFailures[0].getCause())[0];
            this.logger.debug(() -> new ParameterizedMessage("All shards failed for phase: [{}]", (Object)this.getName()), (Throwable)cause);
            this.onPhaseFailure(currentPhase, "all shards failed", cause);
        } else {
            Boolean allowPartialResults = this.request.allowPartialSearchResults();
            assert (allowPartialResults != null) : "SearchRequest missing setting for allowPartialSearchResults";
            if (!allowPartialResults.booleanValue() && this.successfulOps.get() != this.getNumShards()) {
                ShardOperationFailedException[] shardSearchFailures = this.buildShardFailures();
                if (shardSearchFailures.length > 0) {
                    if (this.logger.isDebugEnabled()) {
                        int numShardFailures = shardSearchFailures.length;
                        shardSearchFailures = ExceptionsHelper.groupBy(shardSearchFailures);
                        ElasticsearchException cause = ElasticsearchException.guessRootCauses(shardSearchFailures[0].getCause())[0];
                        this.logger.debug(() -> new ParameterizedMessage("{} shards failed for phase: [{}]", (Object)numShardFailures, (Object)this.getName()), (Throwable)cause);
                    }
                    this.onPhaseFailure(currentPhase, "Partial shards failure", null);
                    return;
                }
                int discrepancy = this.getNumShards() - this.successfulOps.get();
                assert (discrepancy > 0) : "discrepancy: " + discrepancy;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Partial shards failure (unavailable: {}, successful: {}, skipped: {}, num-shards: {}, phase: {})", (Object)discrepancy, (Object)this.successfulOps.get(), (Object)this.skippedOps.get(), (Object)this.getNumShards(), (Object)currentPhase.getName());
                }
                this.onPhaseFailure(currentPhase, "Partial shards failure (" + discrepancy + " shards unavailable)", null);
                return;
            }
            if (this.logger.isTraceEnabled()) {
                String resultsFrom = this.results.getSuccessfulResults().map(r -> r.getSearchShardTarget().toString()).collect(Collectors.joining(","));
                this.logger.trace("[{}] Moving to next phase: [{}], based on results from: {} (cluster state version: {})", (Object)currentPhase.getName(), (Object)nextPhase.getName(), (Object)resultsFrom, (Object)this.clusterStateVersion);
            }
            this.executePhase(nextPhase);
        }
    }

    private void executePhase(SearchPhase phase) {
        try {
            phase.run();
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Message)new ParameterizedMessage("Failed to execute [{}] while moving to [{}] phase", (Object)this.request, (Object)phase.getName()), (Throwable)e);
            }
            this.onPhaseFailure(phase, "", e);
        }
    }

    ShardSearchFailure[] buildShardFailures() {
        AtomicArray shardFailures = (AtomicArray)this.shardFailures.get();
        if (shardFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        List entries = shardFailures.asList();
        ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
        for (int i = 0; i < failures.length; ++i) {
            failures[i] = (ShardSearchFailure)entries.get(i);
        }
        return failures;
    }

    private void onShardFailure(int shardIndex, @Nullable ShardRouting shard, @Nullable String nodeId, SearchShardIterator shardIt, Exception e) {
        SearchShardTarget shardTarget = shardIt.newSearchShardTarget(nodeId);
        this.onShardFailure(shardIndex, shardTarget, e);
        if (this.totalOps.incrementAndGet() == this.expectedTotalOps) {
            if (this.logger.isDebugEnabled()) {
                if (e != null && !TransportActions.isShardNotAvailableException(e)) {
                    this.logger.debug((Message)new ParameterizedMessage("{}: Failed to execute [{}]", shard != null ? shard.shortSummary() : shardIt.shardId(), (Object)this.request), (Throwable)e);
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Message)new ParameterizedMessage("{}: Failed to execute [{}]", (Object)shard, (Object)this.request), (Throwable)e);
                }
            }
            this.onShardGroupFailure(shardIndex, e);
            this.onPhaseDone();
        } else {
            ShardRouting nextShard = shardIt.nextOrNull();
            boolean lastShard = nextShard == null;
            this.logger.trace(() -> new ParameterizedMessage("{}: Failed to execute [{}] lastShard [{}]", new Object[]{shard != null ? shard.shortSummary() : shardIt.shardId(), this.request, lastShard}), (Throwable)e);
            if (!lastShard) {
                this.performPhaseOnShard(shardIndex, shardIt, nextShard);
            } else {
                if (this.logger.isDebugEnabled() && !this.logger.isTraceEnabled() && e != null && !TransportActions.isShardNotAvailableException(e)) {
                    this.logger.debug((Message)new ParameterizedMessage("{}: Failed to execute [{}] lastShard [{}]", new Object[]{shard != null ? shard.shortSummary() : shardIt.shardId(), this.request, lastShard}), (Throwable)e);
                }
                this.onShardGroupFailure(shardIndex, e);
            }
        }
    }

    protected void onShardGroupFailure(int shardIndex, Exception exc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onShardFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Exception e) {
        if (!TransportActions.isShardNotAvailableException(e)) {
            ShardSearchFailure failure;
            AtomicArray<ShardSearchFailure> shardFailures = (AtomicArray<ShardSearchFailure>)this.shardFailures.get();
            if (shardFailures == null) {
                Object object = this.shardFailuresMutex;
                synchronized (object) {
                    shardFailures = (AtomicArray)this.shardFailures.get();
                    if (shardFailures == null) {
                        shardFailures = new AtomicArray<ShardSearchFailure>(this.getNumShards());
                        this.shardFailures.set(shardFailures);
                    }
                }
            }
            if ((failure = (ShardSearchFailure)shardFailures.get(shardIndex)) == null) {
                shardFailures.set(shardIndex, new ShardSearchFailure(e, shardTarget));
            } else if (TransportActions.isReadOverrideException(e)) {
                shardFailures.set(shardIndex, new ShardSearchFailure(e, shardTarget));
            }
            if (this.results.hasResult(shardIndex)) {
                assert (failure == null) : "shard failed before but shouldn't: " + failure;
                this.successfulOps.decrementAndGet();
            }
        }
        this.results.consumeShardFailure(shardIndex);
    }

    private void onShardResult(Result result, SearchShardIterator shardIt) {
        AtomicArray shardFailures;
        assert (((SearchPhaseResult)result).getShardIndex() != -1) : "shard index is not set";
        assert (((SearchPhaseResult)result).getSearchShardTarget() != null) : "search shard target must not be null";
        this.successfulOps.incrementAndGet();
        this.results.consumeResult(result);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("got first-phase result from {}", (Object)(result != null ? ((SearchPhaseResult)result).getSearchShardTarget() : null));
        }
        if ((shardFailures = (AtomicArray)this.shardFailures.get()) != null) {
            shardFailures.set(((SearchPhaseResult)result).getShardIndex(), null);
        }
        this.successfulShardExecution(shardIt);
    }

    private void successfulShardExecution(SearchShardIterator shardsIt) {
        int remainingOpsOnIterator = shardsIt.skip() ? shardsIt.remaining() : shardsIt.remaining() + 1;
        int xTotalOps = this.totalOps.addAndGet(remainingOpsOnIterator);
        if (xTotalOps == this.expectedTotalOps) {
            this.onPhaseDone();
        } else if (xTotalOps > this.expectedTotalOps) {
            throw new AssertionError((Object)("unexpected higher total ops [" + xTotalOps + "] compared to expected [" + this.expectedTotalOps + "]"));
        }
    }

    @Override
    public final int getNumShards() {
        return this.results.getNumShards();
    }

    @Override
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    public final SearchTask getTask() {
        return this.task;
    }

    @Override
    public final SearchRequest getRequest() {
        return this.request;
    }

    protected final SearchResponse buildSearchResponse(InternalSearchResponse internalSearchResponse, String scrollId, ShardSearchFailure[] failures) {
        return new SearchResponse(internalSearchResponse, scrollId, this.getNumShards(), this.successfulOps.get(), this.skippedOps.get(), this.buildTookInMillis(), failures, this.clusters);
    }

    @Override
    public void sendSearchResponse(InternalSearchResponse internalSearchResponse, String scrollId) {
        ShardSearchFailure[] failures = this.buildShardFailures();
        Boolean allowPartialResults = this.request.allowPartialSearchResults();
        assert (allowPartialResults != null) : "SearchRequest missing setting for allowPartialSearchResults";
        if (!allowPartialResults.booleanValue() && failures.length > 0) {
            this.raisePhaseFailure(new SearchPhaseExecutionException("", "Shard failures", null, failures));
        } else {
            this.listener.onResponse(this.buildSearchResponse(internalSearchResponse, scrollId, failures));
        }
    }

    @Override
    public final void onPhaseFailure(SearchPhase phase, String msg, Throwable cause) {
        this.raisePhaseFailure(new SearchPhaseExecutionException(phase.getName(), msg, cause, this.buildShardFailures()));
    }

    private void raisePhaseFailure(SearchPhaseExecutionException exception) {
        this.results.getSuccessfulResults().forEach(entry -> {
            try {
                SearchShardTarget searchShardTarget = entry.getSearchShardTarget();
                Transport.Connection connection = this.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                this.sendReleaseSearchContext(entry.getRequestId(), connection, searchShardTarget.getOriginalIndices());
            }
            catch (Exception inner) {
                inner.addSuppressed(exception);
                this.logger.trace("failed to release context", (Throwable)inner);
            }
        });
        this.listener.onFailure(exception);
    }

    final void onPhaseDone() {
        this.executeNextPhase(this, this.getNextPhase(this.results, this));
    }

    @Override
    public final Transport.Connection getConnection(String clusterAlias, String nodeId) {
        return this.nodeIdToConnection.apply(clusterAlias, nodeId);
    }

    @Override
    public final SearchTransportService getSearchTransport() {
        return this.searchTransportService;
    }

    @Override
    public final void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    public final void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public final ShardSearchRequest buildShardSearchRequest(SearchShardIterator shardIt) {
        AliasFilter filter = this.aliasFilter.get(shardIt.shardId().getIndex().getUUID());
        assert (filter != null);
        float indexBoost = this.concreteIndexBoosts.getOrDefault(shardIt.shardId().getIndex().getUUID(), Float.valueOf(1.0f)).floatValue();
        String indexName = shardIt.shardId().getIndex().getName();
        String[] routings = this.indexRoutings.getOrDefault(indexName, Collections.emptySet()).toArray(new String[0]);
        return new ShardSearchRequest(shardIt.getOriginalIndices(), this.request, shardIt.shardId(), this.getNumShards(), filter, indexBoost, this.timeProvider.getAbsoluteStartMillis(), shardIt.getClusterAlias(), routings);
    }

    protected abstract SearchPhase getNextPhase(SearchPhaseResults<Result> var1, SearchPhaseContext var2);

    private void executeNext(PendingExecutions pendingExecutions, Thread originalThread) {
        this.executeNext(pendingExecutions == null ? null : pendingExecutions::finishAndRunNext, originalThread);
    }

    void executeNext(Runnable runnable, Thread originalThread) {
        if (this.throttleConcurrentRequests) {
            if (originalThread == Thread.currentThread()) {
                this.fork(runnable);
            } else {
                runnable.run();
            }
        } else assert (runnable == null);
    }

    private static final class PendingExecutions {
        private final int permits;
        private int permitsTaken = 0;
        private ArrayDeque<Runnable> queue = new ArrayDeque();

        PendingExecutions(int permits) {
            assert (permits > 0) : "not enough permits: " + permits;
            this.permits = permits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishAndRunNext() {
            PendingExecutions pendingExecutions = this;
            synchronized (pendingExecutions) {
                --this.permitsTaken;
                assert (this.permitsTaken >= 0) : "illegal taken permits: " + this.permitsTaken;
            }
            this.tryRun(null);
        }

        void tryRun(Runnable runnable) {
            Runnable r = this.tryQueue(runnable);
            if (r != null) {
                r.run();
            }
        }

        private synchronized Runnable tryQueue(Runnable runnable) {
            Runnable toExecute = null;
            if (this.permitsTaken < this.permits) {
                ++this.permitsTaken;
                toExecute = runnable;
                if (toExecute == null) {
                    toExecute = this.queue.poll();
                }
                if (toExecute == null) {
                    --this.permitsTaken;
                }
            } else if (runnable != null) {
                this.queue.add(runnable);
            }
            return toExecute;
        }
    }
}

