/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.PackedInteger;
import com.sleepycat.util.UtfOps;
import java.math.BigInteger;

public class TupleInput
extends FastInputStream {
    public TupleInput(byte[] byArray) {
        super(byArray);
    }

    public TupleInput(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    public TupleInput(TupleOutput tupleOutput) {
        super(tupleOutput.getBufferBytes(), tupleOutput.getBufferOffset(), tupleOutput.getBufferLength());
    }

    public final String readString() throws IndexOutOfBoundsException, IllegalArgumentException {
        byte[] byArray = this.buf;
        int n = this.off;
        if (this.available() >= 2 && byArray[n] == -1 && byArray[n + 1] == 0) {
            this.skip(2L);
            return null;
        }
        int n2 = UtfOps.getZeroTerminatedByteLength(byArray, n);
        this.skip(n2 + 1);
        return UtfOps.bytesToString(byArray, n, n2);
    }

    public final char readChar() throws IndexOutOfBoundsException {
        return (char)this.readUnsignedShort();
    }

    public final boolean readBoolean() throws IndexOutOfBoundsException {
        int n = this.readFast();
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        return n != 0;
    }

    public final byte readByte() throws IndexOutOfBoundsException {
        return (byte)(this.readUnsignedByte() ^ 0x80);
    }

    public final short readShort() throws IndexOutOfBoundsException {
        return (short)(this.readUnsignedShort() ^ 0x8000);
    }

    public final int readInt() throws IndexOutOfBoundsException {
        return (int)(this.readUnsignedInt() ^ Integer.MIN_VALUE);
    }

    public final long readLong() throws IndexOutOfBoundsException {
        return this.readUnsignedLong() ^ Long.MIN_VALUE;
    }

    public final float readFloat() throws IndexOutOfBoundsException {
        return Float.intBitsToFloat((int)this.readUnsignedInt());
    }

    public final double readDouble() throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.readUnsignedLong());
    }

    public final float readSortedFloat() throws IndexOutOfBoundsException {
        int n;
        return Float.intBitsToFloat(n ^= (n = (int)this.readUnsignedInt()) < 0 ? Integer.MIN_VALUE : -1);
    }

    public final double readSortedDouble() throws IndexOutOfBoundsException {
        long l;
        return Double.longBitsToDouble(l ^= (l = this.readUnsignedLong()) < 0L ? Long.MIN_VALUE : -1L);
    }

    public final int readUnsignedByte() throws IndexOutOfBoundsException {
        int n = this.readFast();
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        return n;
    }

    public final int readUnsignedShort() throws IndexOutOfBoundsException {
        int n;
        int n2 = this.readFast();
        if ((n2 | (n = this.readFast())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return n2 << 8 | n;
    }

    public final long readUnsignedInt() throws IndexOutOfBoundsException {
        long l;
        long l2;
        long l3;
        long l4 = this.readFast();
        if ((l4 | (l3 = (long)this.readFast()) | (l2 = (long)this.readFast()) | (l = (long)this.readFast())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    private final long readUnsignedLong() throws IndexOutOfBoundsException {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8 = this.readFast();
        if ((l8 | (l7 = (long)this.readFast()) | (l6 = (long)this.readFast()) | (l5 = (long)this.readFast()) | (l4 = (long)this.readFast()) | (l3 = (long)this.readFast()) | (l2 = (long)this.readFast()) | (l = (long)this.readFast())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    public final String readBytes(int n) throws IndexOutOfBoundsException {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.readFast();
            if (n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public final String readChars(int n) throws IndexOutOfBoundsException {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.readChar());
        }
        return stringBuffer.toString();
    }

    public final void readBytes(char[] cArray) throws IndexOutOfBoundsException {
        for (int i = 0; i < cArray.length; ++i) {
            int n = this.readFast();
            if (n < 0) {
                throw new IndexOutOfBoundsException();
            }
            cArray[i] = (char)n;
        }
    }

    public final void readChars(char[] cArray) throws IndexOutOfBoundsException {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.readChar();
        }
    }

    public final String readString(int n) throws IndexOutOfBoundsException, IllegalArgumentException {
        char[] cArray = new char[n];
        this.readString(cArray);
        return new String(cArray);
    }

    public final void readString(char[] cArray) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.off = UtfOps.bytesToChars(this.buf, this.off, cArray, 0, cArray.length, false);
    }

    public final int getStringByteLength() throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.available() >= 2 && this.buf[this.off] == -1 && this.buf[this.off + 1] == 0) {
            return 2;
        }
        return UtfOps.getZeroTerminatedByteLength(this.buf, this.off) + 1;
    }

    public final int readPackedInt() {
        int n = PackedInteger.getReadIntLength(this.buf, this.off);
        int n2 = PackedInteger.readInt(this.buf, this.off);
        this.off += n;
        return n2;
    }

    public final int getPackedIntByteLength() {
        return PackedInteger.getReadIntLength(this.buf, this.off);
    }

    public final long readPackedLong() {
        int n = PackedInteger.getReadLongLength(this.buf, this.off);
        long l = PackedInteger.readLong(this.buf, this.off);
        this.off += n;
        return l;
    }

    public final int getPackedLongByteLength() {
        return PackedInteger.getReadLongLength(this.buf, this.off);
    }

    public final BigInteger readBigInteger() {
        short s = this.readShort();
        if (s < 0) {
            s = -s;
        }
        byte[] byArray = new byte[s];
        byArray[0] = this.readByte();
        this.readFast(byArray, 1, byArray.length - 1);
        return new BigInteger(byArray);
    }

    public final int getBigIntegerByteLength() {
        int n = this.off;
        short s = this.readShort();
        this.off = n;
        if (s < 0) {
            s = -s;
        }
        return s + 2;
    }
}

