/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr353;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class JsonValueDeserializer
extends StdDeserializer<JsonValue> {
    private static final long serialVersionUID = 1L;
    protected final JsonBuilderFactory _builderFactory;

    public JsonValueDeserializer(JsonBuilderFactory bf) {
        super(JsonValue.class);
        this._builderFactory = bf;
    }

    public JsonValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (p.getCurrentToken()) {
            case START_OBJECT: {
                return this._deserializeObject(p, ctxt);
            }
            case START_ARRAY: {
                return this._deserializeArray(p, ctxt);
            }
        }
        return this._deserializeScalar(p, ctxt);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeser) throws IOException, JsonProcessingException {
        return typeDeser.deserializeTypedFromScalar(p, ctxt);
    }

    protected JsonValue _deserializeObject(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonObjectBuilder b = this._builderFactory.createObjectBuilder();
        block15: while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.getCurrentName();
            JsonToken t = p.nextToken();
            switch (t) {
                case START_ARRAY: {
                    b.add(name, this._deserializeArray(p, ctxt));
                    continue block15;
                }
                case START_OBJECT: {
                    b.add(name, this._deserializeObject(p, ctxt));
                    continue block15;
                }
                case VALUE_FALSE: {
                    b.add(name, false);
                    continue block15;
                }
                case VALUE_TRUE: {
                    b.add(name, true);
                    continue block15;
                }
                case VALUE_NULL: {
                    b.addNull(name);
                    continue block15;
                }
                case VALUE_NUMBER_FLOAT: {
                    if (p.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                        b.add(name, p.getDecimalValue());
                        continue block15;
                    }
                    b.add(name, p.getDoubleValue());
                    continue block15;
                }
                case VALUE_NUMBER_INT: {
                    switch (p.getNumberType()) {
                        case LONG: {
                            b.add(name, p.getLongValue());
                            continue block15;
                        }
                        case INT: {
                            b.add(name, p.getIntValue());
                            continue block15;
                        }
                    }
                    b.add(name, p.getBigIntegerValue());
                    continue block15;
                }
                case VALUE_STRING: {
                    b.add(name, p.getText());
                    continue block15;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object ob = p.getEmbeddedObject();
                    if (!(ob instanceof byte[])) break;
                    String b64 = ctxt.getBase64Variant().encode((byte[])ob, false);
                    b.add(name, b64);
                    continue block15;
                }
            }
            return (JsonValue)ctxt.handleUnexpectedToken(JsonValue.class, p);
        }
        return b.build();
    }

    protected JsonValue _deserializeArray(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t;
        JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
        block14: while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            switch (t) {
                case START_ARRAY: {
                    b.add(this._deserializeArray(p, ctxt));
                    continue block14;
                }
                case START_OBJECT: {
                    b.add(this._deserializeObject(p, ctxt));
                    continue block14;
                }
                case VALUE_FALSE: {
                    b.add(false);
                    continue block14;
                }
                case VALUE_TRUE: {
                    b.add(true);
                    continue block14;
                }
                case VALUE_NULL: {
                    b.addNull();
                    continue block14;
                }
                case VALUE_NUMBER_FLOAT: {
                    if (p.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                        b.add(p.getDecimalValue());
                        continue block14;
                    }
                    b.add(p.getDoubleValue());
                    continue block14;
                }
                case VALUE_NUMBER_INT: {
                    switch (p.getNumberType()) {
                        case LONG: {
                            b.add(p.getLongValue());
                            continue block14;
                        }
                        case INT: {
                            b.add(p.getIntValue());
                            continue block14;
                        }
                    }
                    b.add(p.getBigIntegerValue());
                    continue block14;
                }
                case VALUE_STRING: {
                    b.add(p.getText());
                    continue block14;
                }
            }
            return (JsonValue)ctxt.handleUnexpectedToken(JsonValue.class, p);
        }
        return b.build();
    }

    protected JsonValue _deserializeScalar(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (p.getCurrentToken()) {
            case VALUE_EMBEDDED_OBJECT: {
                return (JsonValue)ctxt.handleUnexpectedToken(JsonValue.class, p);
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_NUMBER_FLOAT: {
                JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
                if (p.getNumberType() == JsonParser.NumberType.BIG_DECIMAL) {
                    return (JsonValue)b.add(p.getDecimalValue()).build().get(0);
                }
                return (JsonValue)b.add(p.getDoubleValue()).build().get(0);
            }
            case VALUE_NUMBER_INT: {
                JsonArrayBuilder b = this._builderFactory.createArrayBuilder();
                switch (p.getNumberType()) {
                    case LONG: {
                        return (JsonValue)b.add(p.getLongValue()).build().get(0);
                    }
                    case INT: {
                        return (JsonValue)b.add(p.getIntValue()).build().get(0);
                    }
                }
                return (JsonValue)b.add(p.getBigIntegerValue()).build().get(0);
            }
            case VALUE_STRING: {
                return (JsonValue)this._builderFactory.createArrayBuilder().add(p.getText()).build().get(0);
            }
        }
        return (JsonValue)ctxt.handleUnexpectedToken(JsonValue.class, p);
    }
}

