/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class SolarPoweredProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_ACTIVE_REPORTING = 17;

    public SolarPoweredProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(0, 15);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        if (type == 17) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            block3: while (buf.readableBytes() > 2) {
                short tag = buf.readUnsignedByte();
                short length = buf.readUnsignedByte();
                switch (tag) {
                    case 129: {
                        short status = buf.readUnsignedByte();
                        DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                        position.setTime(dateBuilder.getDate());
                        position.setLatitude((double)buf.readUnsignedInt() * 1.0E-6);
                        if (BitUtil.check(status, 3)) {
                            position.setLatitude(-position.getLatitude());
                        }
                        position.setLongitude((double)buf.readUnsignedInt() * 1.0E-6);
                        if (BitUtil.check(status, 2)) {
                            position.setLongitude(-position.getLongitude());
                        }
                        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                        position.set("deviceTemp", Integer.valueOf(buf.readByte()));
                        position.set("battery", (double)buf.readUnsignedByte() * 0.02);
                        position.setCourse(buf.readUnsignedByte());
                        continue block3;
                    }
                }
                buf.skipBytes((int)length);
            }
            return position;
        }
        return null;
    }
}

