/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class PluginProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("[^0-9,]*,?").number("([^,]+),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+.?d*),").number("(d+),").number("(-?d+),").number("(-?d+),").number("d+,").number("(d+.?d*),").number("(d+),").number("(d+.?d*),").expression("[^,]*,").text("0").groupBegin().number(",(-?d+.?d*)").number(",(-?d+.?d*)").number(",d+").number(",(d+)").number(",(d+)").number(",d+").number(",d+").number(",d+").number(",d+").number(",(d+)").number(",(d+)").groupEnd("?").groupBegin().text(",+,").number("(d+),").groupEnd("?").any().compile();

    public PluginProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setLongitude(parser.nextDouble());
        position.setLatitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.set("sat", parser.nextInt());
        position.set("odometer", (long)(parser.nextDouble() * 1000.0));
        int status = parser.nextInt();
        position.setValid(BitUtil.check(status, 0));
        position.set("ignition", BitUtil.check(status, 1));
        for (int i = 0; i < 4; ++i) {
            position.set("in" + (i + 1), BitUtil.check(status, 20 + i));
        }
        position.set("status", status);
        position.set("fuel", parser.nextDouble());
        if (parser.hasNext(6)) {
            position.set("temp1", parser.nextDouble());
            position.set("temp2", parser.nextDouble());
            position.set("rpm", parser.nextInt());
            position.set("obdSpeed", parser.nextInt());
            position.set("throttle", (double)parser.nextInt().intValue() * 0.1);
            position.set("power", (double)parser.nextInt().intValue() * 0.1);
        }
        if (parser.hasNext()) {
            int event = parser.nextInt();
            switch (event) {
                case 11317: {
                    position.set("alarm", "hardAcceleration");
                    break;
                }
                case 11319: {
                    position.set("alarm", "hardBraking");
                    break;
                }
            }
            position.set("event", event);
        }
        return position;
    }
}

