/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoppableCommitThread
extends AbstractFullDistribZkTestBase.StoppableThread {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrClient cloudClient;
    private final long timeBetweenCommitsMs;
    private final boolean softCommits;
    private volatile boolean stop = false;
    private final AtomicInteger numCommits = new AtomicInteger(0);
    private final AtomicInteger numFails = new AtomicInteger(0);

    public StoppableCommitThread(SolrClient cloudClient, long timeBetweenCommitsMs, boolean softCommits) {
        super("StoppableCommitThread");
        this.cloudClient = cloudClient;
        this.timeBetweenCommitsMs = timeBetweenCommitsMs;
        this.softCommits = softCommits;
    }

    @Override
    public void run() {
        log.debug("StoppableCommitThread started");
        while (!this.stop) {
            try {
                this.cloudClient.commit(false, false, this.softCommits);
                this.numCommits.incrementAndGet();
            }
            catch (Exception e) {
                this.numFails.incrementAndGet();
            }
            try {
                Thread.sleep(this.timeBetweenCommitsMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        log.info("StoppableCommitThread finished. Committed {} times. Failed {} times.", (Object)this.numCommits.get(), (Object)this.numFails.get());
    }

    @Override
    public void safeStop() {
        this.stop = true;
    }
}

