/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class CLOBTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId typeId, boolean bl) {
        return typeId.isStringTypeId() || typeId.isBooleanTypeId();
    }

    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        return typeId.isStringTypeId() || typeId.isBooleanTypeId();
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "java.sql.Clob";
            }
        }
        return null;
    }

    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.getMaximumWidth();
    }

    String nullMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "getNullClob";
            }
        }
        return null;
    }

    String dataValueMethodName() {
        int n = this.getStoredFormatIdFromTypeId();
        switch (n) {
            case 444: {
                return "getClobDataValue";
            }
        }
        return null;
    }

    boolean pushCollationForDataValue(int n) {
        return n != 0;
    }
}

