/*!
 * Copyright (c) 2012 - 2019, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"]);
})(this, function(Bokeh) {
  var define;
  return (function(modules, entry, aliases, externals) {
    if (Bokeh != null) {
      return Bokeh.register_plugin(modules, entry, aliases, externals);
    } else {
      throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.");
    }
  })
({
514: function _(e,r,s){var a=e(515);s.Tables=a,e(108).register_models(a)},
515: function _(a,g,r){function e(a){for(var g in a)r.hasOwnProperty(g)||(r[g]=a[g])}e(a(516)),e(a(537));var o=a(517);r.DataTable=o.DataTable;var t=a(540);r.TableColumn=t.TableColumn;var n=a(533);r.TableWidget=n.TableWidget;var u=a(541);r.AvgAggregator=u.AvgAggregator,r.MinAggregator=u.MinAggregator,r.MaxAggregator=u.MaxAggregator,r.SumAggregator=u.SumAggregator;var A=a(542);r.GroupingInfo=A.GroupingInfo,r.DataCube=A.DataCube},
516: function _(t,e,i){var n=t(113),o=t(121),r=t(163),u=t(161),l=t(166),p=t(517),a=t(535),s=function(t){function e(e){var i=t.call(this,Object.assign({model:e.column.model},e))||this;return i.args=e,i.render(),i}return n.__extends(e,t),Object.defineProperty(e.prototype,"emptyValue",{get:function(){return null},enumerable:!0,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.inputEl=this._createInput(),this.defaultValue=null},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(a.bk_cell_editor)},e.prototype.render=function(){t.prototype.render.call(this),this.args.container.append(this.el),this.el.appendChild(this.inputEl),this.renderEditor(),this.disableNavigation()},e.prototype.renderEditor=function(){},e.prototype.disableNavigation=function(){this.inputEl.addEventListener("keydown",function(t){switch(t.keyCode){case r.Keys.Left:case r.Keys.Right:case r.Keys.Up:case r.Keys.Down:case r.Keys.PageUp:case r.Keys.PageDown:t.stopImmediatePropagation()}})},e.prototype.destroy=function(){this.remove()},e.prototype.focus=function(){this.inputEl.focus()},e.prototype.show=function(){},e.prototype.hide=function(){},e.prototype.position=function(){},e.prototype.getValue=function(){return this.inputEl.value},e.prototype.setValue=function(t){this.inputEl.value=t},e.prototype.serializeValue=function(){return this.getValue()},e.prototype.isValueChanged=function(){return!(""==this.getValue()&&null==this.defaultValue)&&this.getValue()!==this.defaultValue},e.prototype.applyValue=function(t,e){var i=this.args.grid.getData(),n=i.index.indexOf(t[p.DTINDEX_NAME]);i.setField(n,this.args.column.field,e)},e.prototype.loadValue=function(t){var e=t[this.args.column.field];this.defaultValue=null!=e?e:this.emptyValue,this.setValue(this.defaultValue)},e.prototype.validateValue=function(t){if(this.args.column.validator){var e=this.args.column.validator(t);if(!e.valid)return e}return{valid:!0,msg:null}},e.prototype.validate=function(){return this.validateValue(this.getValue())},e}(u.DOMView);i.CellEditorView=s,s.__name__="CellEditorView";var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e}(l.Model);i.CellEditor=c,c.__name__="CellEditor";var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),Object.defineProperty(e.prototype,"emptyValue",{get:function(){return""},enumerable:!0,configurable:!0}),e.prototype._createInput=function(){return r.input({type:"text"})},e.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},e.prototype.loadValue=function(e){t.prototype.loadValue.call(this,e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},e}(s);i.StringEditorView=d,d.__name__="StringEditorView";var _=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_StringEditor=function(){this.prototype.default_view=d,this.define({completions:[o.Array,[]]})},e}(c);i.StringEditor=_,_.__name__="StringEditor",_.init_StringEditor();var f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._createInput=function(){return r.textarea()},e}(s);i.TextEditorView=f,f.__name__="TextEditorView";var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_TextEditor=function(){this.prototype.default_view=f},e}(c);i.TextEditor=h,h.__name__="TextEditor",h.init_TextEditor();var y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._createInput=function(){return r.select()},e.prototype.renderEditor=function(){for(var t=0,e=this.model.options;t<e.length;t++){var i=e[t];this.inputEl.appendChild(r.option({value:i},i))}this.focus()},e}(s);i.SelectEditorView=y,y.__name__="SelectEditorView";var E=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_SelectEditor=function(){this.prototype.default_view=y,this.define({options:[o.Array,[]]})},e}(c);i.SelectEditor=E,E.__name__="SelectEditor",E.init_SelectEditor();var V=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._createInput=function(){return r.input({type:"text"})},e}(s);i.PercentEditorView=V,V.__name__="PercentEditorView";var m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_PercentEditor=function(){this.prototype.default_view=V},e}(c);i.PercentEditor=m,m.__name__="PercentEditor",m.init_PercentEditor();var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._createInput=function(){return r.input({type:"checkbox",value:"true"})},e.prototype.renderEditor=function(){this.focus()},e.prototype.loadValue=function(t){this.defaultValue=!!t[this.args.column.field],this.inputEl.checked=this.defaultValue},e.prototype.serializeValue=function(){return this.inputEl.checked},e}(s);i.CheckboxEditorView=v,v.__name__="CheckboxEditorView";var g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_CheckboxEditor=function(){this.prototype.default_view=v},e}(c);i.CheckboxEditor=g,g.__name__="CheckboxEditor",g.init_CheckboxEditor();var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._createInput=function(){return r.input({type:"text"})},e.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},e.prototype.remove=function(){t.prototype.remove.call(this)},e.prototype.serializeValue=function(){return parseInt(this.getValue(),10)||0},e.prototype.loadValue=function(e){t.prototype.loadValue.call(this,e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},e.prototype.validateValue=function(e){return isNaN(e)?{valid:!1,msg:"Please enter a valid integer"}:t.prototype.validateValue.call(this,e)},e}(s);i.IntEditorView=x,x.__name__="IntEditorView";var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_IntEditor=function(){this.prototype.default_view=x,this.define({step:[o.Number,1]})},e}(c);i.IntEditor=w,w.__name__="IntEditor",w.init_IntEditor();var b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._createInput=function(){return r.input({type:"text"})},e.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},e.prototype.remove=function(){t.prototype.remove.call(this)},e.prototype.serializeValue=function(){return parseFloat(this.getValue())||0},e.prototype.loadValue=function(e){t.prototype.loadValue.call(this,e),this.inputEl.defaultValue=this.defaultValue,this.inputEl.select()},e.prototype.validateValue=function(e){return isNaN(e)?{valid:!1,msg:"Please enter a valid number"}:t.prototype.validateValue.call(this,e)},e}(s);i.NumberEditorView=b,b.__name__="NumberEditorView";var I=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_NumberEditor=function(){this.prototype.default_view=b,this.define({step:[o.Number,.01]})},e}(c);i.NumberEditor=I,I.__name__="NumberEditor",I.init_NumberEditor();var N=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._createInput=function(){return r.input({type:"text"})},e}(s);i.TimeEditorView=N,N.__name__="TimeEditorView";var C=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_TimeEditor=function(){this.prototype.default_view=N},e}(c);i.TimeEditor=C,C.__name__="TimeEditor",C.init_TimeEditor();var P=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._createInput=function(){return r.input({type:"text"})},Object.defineProperty(e.prototype,"emptyValue",{get:function(){return new Date},enumerable:!0,configurable:!0}),e.prototype.renderEditor=function(){this.inputEl.focus(),this.inputEl.select()},e.prototype.destroy=function(){t.prototype.destroy.call(this)},e.prototype.show=function(){t.prototype.show.call(this)},e.prototype.hide=function(){t.prototype.hide.call(this)},e.prototype.position=function(){return t.prototype.position.call(this)},e.prototype.getValue=function(){},e.prototype.setValue=function(t){},e}(s);i.DateEditorView=P,P.__name__="DateEditorView";var D=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.init_DateEditor=function(){this.prototype.default_view=P},e}(c);i.DateEditor=D,D.__name__="DateEditor",D.init_DateEditor()},
517: function _(e,t,i){var n=e(113),o=e(518).RowSelectionModel,r=e(522).CheckboxSelectColumn,s=e(523).CellExternalCopyManager,l=e(524),a=e(121),d=e(127),c=e(109),u=e(110),h=e(125),_=e(167),p=e(282),m=e(533),f=e(534),g=e(535);i.DTINDEX_NAME="__bkdt_internal_index__";var b=function(){function e(e,t){if(this.source=e,this.view=t,i.DTINDEX_NAME in this.source.data)throw new Error("special name "+i.DTINDEX_NAME+" cannot be used as a data table column");this.index=this.view.indices}return e.prototype.getLength=function(){return this.index.length},e.prototype.getItem=function(e){for(var t={},n=0,o=h.keys(this.source.data);n<o.length;n++){var r=o[n];t[r]=this.source.data[r][this.index[e]]}return t[i.DTINDEX_NAME]=this.index[e],t},e.prototype.getField=function(e,t){return t==i.DTINDEX_NAME?this.index[e]:this.source.data[t][this.index[e]]},e.prototype.setField=function(e,t,i){var n,o=this.index[e];this.source.patch(((n={})[t]=[[o,i]],n))},e.prototype.getItemMetadata=function(e){return null},e.prototype.getRecords=function(){var e=this;return u.range(0,this.getLength()).map(function(t){return e.getItem(t)})},e.prototype.sort=function(e){var t=e.map(function(e){return[e.sortCol.field,e.sortAsc?1:-1]});0==t.length&&(t=[[i.DTINDEX_NAME,1]]);var n=this.getRecords(),o=this.index.slice();this.index.sort(function(e,i){for(var r=0,s=t;r<s.length;r++){var l=s[r],a=l[0],d=l[1],c=n[o.indexOf(e)][a],u=n[o.indexOf(i)][a],h=c==u?0:c>u?d:-d;if(0!=h)return h}return 0})},e}();i.TableDataProvider=b,b.__name__="TableDataProvider";var v=function(e){function t(){var t=e.apply(this,arguments)||this;return t._in_selection_update=!1,t._warned_not_reorderable=!1,t}return n.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,function(){return t.render()}),this.connect(this.model.source.streaming,function(){return t.updateGrid()}),this.connect(this.model.source.patching,function(){return t.updateGrid()}),this.connect(this.model.source.change,function(){return t.updateGrid()}),this.connect(this.model.source.properties.data.change,function(){return t.updateGrid()}),this.connect(this.model.source.selected.change,function(){return t.updateSelection()}),this.connect(this.model.source.selected.properties.indices.change,function(){return t.updateSelection()})},t.prototype._update_layout=function(){this.layout=new p.LayoutItem,this.layout.set_sizing(this.box_sizing())},t.prototype.update_position=function(){e.prototype.update_position.call(this),this.grid.resizeCanvas()},t.prototype.updateGrid=function(){var e=this;if(this.model.view.compute_indices(),this.data.constructor(this.model.source,this.model.view),this.model.sortable){var t=this.grid.getColumns(),i=this.grid.getSortColumns().map(function(i){return{sortCol:{field:t[e.grid.getColumnIndex(i.columnId)].field},sortAsc:i.sortAsc}});this.data.sort(i)}this.grid.invalidate(),this.grid.render()},t.prototype.updateSelection=function(){var e=this;if(!this._in_selection_update){var t=this.model.source.selected.indices.map(function(t){return e.data.index.indexOf(t)}).sort();this._in_selection_update=!0,this.grid.setSelectedRows(t),this._in_selection_update=!1;var i=this.grid.getViewport(),n=this.model.get_scroll_index(i,t);null!=n&&this.grid.scrollRowToTop(n)}},t.prototype.newIndexColumn=function(){return{id:d.uniqueId(),name:this.model.index_header,field:i.DTINDEX_NAME,width:this.model.index_width,behavior:"select",cannotTriggerInsert:!0,resizable:!1,selectable:!1,sortable:!0,cssClass:g.bk_cell_index,headerCssClass:g.bk_header_index}},t.prototype.css_classes=function(){return e.prototype.css_classes.call(this).concat(g.bk_data_table)},t.prototype.render=function(){var e,t=this,i=this.model.columns.map(function(e){return e.toColumn()});if("checkbox"==this.model.selectable&&(e=new r({cssClass:g.bk_cell_select}),i.unshift(e.getColumnDefinition())),null!=this.model.index_position){var n=this.model.index_position,a=this.newIndexColumn();-1==n?i.push(a):n<-1?i.splice(n+1,0,a):i.splice(n,0,a)}var d=this.model.reorderable;!d||"undefined"!=typeof $&&null!=$.fn&&null!=$.fn.sortable||(this._warned_not_reorderable||(_.logger.warn("jquery-ui is required to enable DataTable.reorderable"),this._warned_not_reorderable=!0),d=!1);var u={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:d,forceFitColumns:this.model.fit_columns,multiColumnSort:this.model.sortable,editable:this.model.editable,autoEdit:!1,rowHeight:this.model.row_height};if(this.data=new b(this.model.source,this.model.view),this.grid=new l.Grid(this.el,this.data,i,u),this.grid.onSort.subscribe(function(e,n){t.model.sortable&&(i=n.sortCols,t.data.sort(i),t.grid.invalidate(),t.updateSelection(),t.grid.render(),t.model.header_row||t._hide_header(),t.model.update_sort_columns(i))}),!1!==this.model.selectable){this.grid.setSelectionModel(new o({selectActiveRow:null==e})),null!=e&&this.grid.registerPlugin(e);var h={dataItemColumnValueExtractor:function(e,t){var i=e[t.field];return c.isString(i)&&(i=i.replace(/\n/g,"\\n")),i},includeHeaderWhenCopying:!1};this.grid.registerPlugin(new s(h)),this.grid.onSelectedRowsChanged.subscribe(function(e,i){t._in_selection_update||(t.model.source.selected.indices=i.rows.map(function(e){return t.data.index[e]}))}),this.updateSelection(),this.model.header_row||this._hide_header()}},t.prototype._hide_header=function(){for(var e=0,t=Array.from(this.el.querySelectorAll(".slick-header-columns"));e<t.length;e++){t[e].style.height="0px"}this.grid.resizeCanvas()},t}(f.WidgetView);i.DataTableView=v,v.__name__="DataTableView";var w=function(e){function t(t){var i=e.call(this,t)||this;return i._sort_columns=[],i}return n.__extends(t,e),Object.defineProperty(t.prototype,"sort_columns",{get:function(){return this._sort_columns},enumerable:!0,configurable:!0}),t.init_DataTable=function(){this.prototype.default_view=v,this.define({columns:[a.Array,[]],fit_columns:[a.Boolean,!0],sortable:[a.Boolean,!0],reorderable:[a.Boolean,!0],editable:[a.Boolean,!1],selectable:[a.Any,!0],index_position:[a.Int,0],index_header:[a.String,"#"],index_width:[a.Int,40],scroll_to_selection:[a.Boolean,!0],header_row:[a.Boolean,!0],row_height:[a.Int,25]}),this.override({width:600,height:400})},t.prototype.update_sort_columns=function(e){return this._sort_columns=e.map(function(e){return{field:e.sortCol.field,sortAsc:e.sortAsc}}),null},t.prototype.get_scroll_index=function(e,t){return this.scroll_to_selection&&0!=t.length?u.some(t,function(t){return e.top<=t&&t<=e.bottom})?null:Math.max(0,Math.min.apply(Math,t)-1):null},t}(m.TableWidget);i.DataTable=w,w.__name__="DataTable",w.init_DataTable()},
518: function _(e,t,n){var o=e(519),r=e(521);t.exports={RowSelectionModel:function(e){var t,n,l,i=[],c=this,u=new r.EventHandler,s={selectActiveRow:!0};function a(e){return function(){n||(n=!0,e.apply(this,arguments),n=!1)}}function f(e){for(var t=[],n=0;n<e.length;n++)for(var o=e[n].fromRow;o<=e[n].toRow;o++)t.push(o);return t}function h(e){for(var n=[],o=t.getColumns().length-1,l=0;l<e.length;l++)n.push(new r.Range(e[l],0,e[l],o));return n}function w(){return f(i)}function g(e){(i&&0!==i.length||e&&0!==e.length)&&(i=e,c.onSelectedRangesChanged.notify(i))}function v(e,n){l.selectActiveRow&&null!=n.row&&g([new r.Range(n.row,0,n.row,t.getColumns().length-1)])}function p(e){var n=t.getActiveCell();if(t.getOptions().multiSelect&&n&&e.shiftKey&&!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.which==r.keyCode.UP||e.which==r.keyCode.DOWN)){var o=w();o.sort(function(e,t){return e-t}),o.length||(o=[n.row]);var l,i=o[0],c=o[o.length-1];(l=e.which==r.keyCode.DOWN?n.row<c||i==c?++c:++i:n.row<c?--c:--i)>=0&&l<t.getDataLength()&&(t.scrollRowIntoView(l),g(h(function(e,t){var n,o=[];for(n=e;n<=t;n++)o.push(n);for(n=t;n<e;n++)o.push(n);return o}(i,c)))),e.preventDefault(),e.stopPropagation()}}function y(e){var n=t.getCellFromEvent(e);if(!n||!t.canCellBeActive(n.row,n.cell))return!1;if(!t.getOptions().multiSelect||!e.ctrlKey&&!e.shiftKey&&!e.metaKey)return!1;var r=f(i),l=o.inArray(n.row,r);if(-1===l&&(e.ctrlKey||e.metaKey))r.push(n.row),t.setActiveCell(n.row,n.cell);else if(-1!==l&&(e.ctrlKey||e.metaKey))r=o.grep(r,function(e,t){return e!==n.row}),t.setActiveCell(n.row,n.cell);else if(r.length&&e.shiftKey){var c=r.pop(),u=Math.min(n.row,c),s=Math.max(n.row,c);r=[];for(var a=u;a<=s;a++)a!==c&&r.push(a);r.push(c),t.setActiveCell(n.row,n.cell)}return g(h(r)),e.stopImmediatePropagation(),!0}o.extend(this,{getSelectedRows:w,setSelectedRows:function(e){g(h(e))},getSelectedRanges:function(){return i},setSelectedRanges:g,init:function(n){l=o.extend(!0,{},s,e),t=n,u.subscribe(t.onActiveCellChanged,a(v)),u.subscribe(t.onKeyDown,a(p)),u.subscribe(t.onClick,a(y))},destroy:function(){u.unsubscribeAll()},onSelectedRangesChanged:new r.Event})}}},
519: function _(e,n,f){n.exports="undefined"!=typeof $?$:e(520)},
520: function _(e,t,n){
/*!
     * jQuery JavaScript Library v3.4.1
     * https://jquery.com/
     *
     * Includes Sizzle.js
     * https://sizzlejs.com/
     *
     * Copyright JS Foundation and other contributors
     * Released under the MIT license
     * https://jquery.org/license
     *
     * Date: 2019-05-01T21:04Z
     */
!function(e,n){"use strict";"object"==typeof t&&"object"==typeof t.exports?t.exports=e.document?n(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return n(e)}:n(e)}("undefined"!=typeof window?window:this,function(e,t){"use strict";var n=[],r=e.document,i=Object.getPrototypeOf,o=n.slice,a=n.concat,s=n.push,u=n.indexOf,l={},c=l.toString,f=l.hasOwnProperty,p=f.toString,d=p.call(Object),h={},g=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},v=function(e){return null!=e&&e===e.window},y={type:!0,src:!0,nonce:!0,noModule:!0};function m(e,t,n){var i,o,a=(n=n||r).createElement("script");if(a.text=e,t)for(i in y)(o=t[i]||t.getAttribute&&t.getAttribute(i))&&a.setAttribute(i,o);n.head.appendChild(a).parentNode.removeChild(a)}function x(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?l[c.call(e)]||"object":typeof e}var b=function(e,t){return new b.fn.init(e,t)},w=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;function T(e){var t=!!e&&"length"in e&&e.length,n=x(e);return!g(e)&&!v(e)&&("array"===n||0===t||"number"==typeof t&&t>0&&t-1 in e)}b.fn=b.prototype={jquery:"3.4.1",constructor:b,length:0,toArray:function(){return o.call(this)},get:function(e){return null==e?o.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=b.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return b.each(this,e)},map:function(e){return this.pushStack(b.map(this,function(t,n){return e.call(t,n,t)}))},slice:function(){return this.pushStack(o.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(n>=0&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:s,sort:n.sort,splice:n.splice},b.extend=b.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,l=!1;for("boolean"==typeof a&&(l=a,a=arguments[s]||{},s++),"object"==typeof a||g(a)||(a={}),s===u&&(a=this,s--);s<u;s++)if(null!=(e=arguments[s]))for(t in e)r=e[t],"__proto__"!==t&&a!==r&&(l&&r&&(b.isPlainObject(r)||(i=Array.isArray(r)))?(n=a[t],o=i&&!Array.isArray(n)?[]:i||b.isPlainObject(n)?n:{},i=!1,a[t]=b.extend(l,o,r)):void 0!==r&&(a[t]=r));return a},b.extend({expando:"jQuery"+("3.4.1"+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==c.call(e))&&(!(t=i(e))||"function"==typeof(n=f.call(t,"constructor")&&t.constructor)&&p.call(n)===d)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t){m(e,{nonce:t&&t.nonce})},each:function(e,t){var n,r=0;if(T(e))for(n=e.length;r<n&&!1!==t.call(e[r],r,e[r]);r++);else for(r in e)if(!1===t.call(e[r],r,e[r]))break;return e},trim:function(e){return null==e?"":(e+"").replace(w,"")},makeArray:function(e,t){var n=t||[];return null!=e&&(T(Object(e))?b.merge(n,"string"==typeof e?[e]:e):s.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:u.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;r<n;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r=[],i=0,o=e.length,a=!n;i<o;i++)!t(e[i],i)!==a&&r.push(e[i]);return r},map:function(e,t,n){var r,i,o=0,s=[];if(T(e))for(r=e.length;o<r;o++)null!=(i=t(e[o],o,n))&&s.push(i);else for(o in e)null!=(i=t(e[o],o,n))&&s.push(i);return a.apply([],s)},guid:1,support:h}),"function"==typeof Symbol&&(b.fn[Symbol.iterator]=n[Symbol.iterator]),b.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){l["[object "+t+"]"]=t.toLowerCase()});var C=
/*!
         * Sizzle CSS Selector Engine v2.3.4
         * https://sizzlejs.com/
         *
         * Copyright JS Foundation and other contributors
         * Released under the MIT license
         * https://js.foundation/
         *
         * Date: 2019-04-08
         */
function(e){var t,n,r,i,o,a,s,u,l,c,f,p,d,h,g,v,y,m,x,b="sizzle"+1*new Date,w=e.document,T=0,C=0,E=ue(),k=ue(),S=ue(),N=ue(),A=function(e,t){return e===t&&(f=!0),0},D={}.hasOwnProperty,j=[],q=j.pop,L=j.push,H=j.push,O=j.slice,P=function(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\.|[\\w-]|[^\0-\\xa0])+",W="\\["+M+"*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",$=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|.*)\\)|)",F=new RegExp(M+"+","g"),B=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),_=new RegExp("^"+M+"*,"+M+"*"),z=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),U=new RegExp(M+"|>"),X=new RegExp($),V=new RegExp("^"+I+"$"),G={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+$),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},Y=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\([\\da-f]{1,6}"+M+"?|("+M+")|.)","ig"),ne=function(e,t,n){var r="0x"+t-65536;return r!=r||n?t:r<0?String.fromCharCode(r+65536):String.fromCharCode(r>>10|55296,1023&r|56320)},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){return t?"\0"===e?"�":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){p()},ae=be(function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()},{dir:"parentNode",next:"legend"});try{H.apply(j=O.call(w.childNodes),w.childNodes),j[w.childNodes.length].nodeType}catch(e){H={apply:j.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){for(var n=e.length,r=0;e[n++]=t[r++];);e.length=n-1}}}function se(e,t,r,i){var o,s,l,c,f,h,y,m=t&&t.ownerDocument,T=t?t.nodeType:9;if(r=r||[],"string"!=typeof e||!e||1!==T&&9!==T&&11!==T)return r;if(!i&&((t?t.ownerDocument||t:w)!==d&&p(t),t=t||d,g)){if(11!==T&&(f=Z.exec(e)))if(o=f[1]){if(9===T){if(!(l=t.getElementById(o)))return r;if(l.id===o)return r.push(l),r}else if(m&&(l=m.getElementById(o))&&x(t,l)&&l.id===o)return r.push(l),r}else{if(f[2])return H.apply(r,t.getElementsByTagName(e)),r;if((o=f[3])&&n.getElementsByClassName&&t.getElementsByClassName)return H.apply(r,t.getElementsByClassName(o)),r}if(n.qsa&&!N[e+" "]&&(!v||!v.test(e))&&(1!==T||"object"!==t.nodeName.toLowerCase())){if(y=e,m=t,1===T&&U.test(e)){for((c=t.getAttribute("id"))?c=c.replace(re,ie):t.setAttribute("id",c=b),s=(h=a(e)).length;s--;)h[s]="#"+c+" "+xe(h[s]);y=h.join(","),m=ee.test(e)&&ye(t.parentNode)||t}try{return H.apply(r,m.querySelectorAll(y)),r}catch(t){N(e,!0)}finally{c===b&&t.removeAttribute("id")}}}return u(e.replace(B,"$1"),t,r,i)}function ue(){var e=[];return function t(n,i){return e.push(n+" ")>r.cacheLength&&delete t[e.shift()],t[n+" "]=i}}function le(e){return e[b]=!0,e}function ce(e){var t=d.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function fe(e,t){for(var n=e.split("|"),i=n.length;i--;)r.attrHandle[n[i]]=t}function pe(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(r)return r;if(n)for(;n=n.nextSibling;)if(n===t)return-1;return e?1:-1}function de(e){return function(t){return"input"===t.nodeName.toLowerCase()&&t.type===e}}function he(e){return function(t){var n=t.nodeName.toLowerCase();return("input"===n||"button"===n)&&t.type===e}}function ge(e){return function(t){return"form"in t?t.parentNode&&!1===t.disabled?"label"in t?"label"in t.parentNode?t.parentNode.disabled===e:t.disabled===e:t.isDisabled===e||t.isDisabled!==!e&&ae(t)===e:t.disabled===e:"label"in t&&t.disabled===e}}function ve(e){return le(function(t){return t=+t,le(function(n,r){for(var i,o=e([],n.length,t),a=o.length;a--;)n[i=o[a]]&&(n[i]=!(r[i]=n[i]))})})}function ye(e){return e&&void 0!==e.getElementsByTagName&&e}for(t in n=se.support={},o=se.isXML=function(e){var t=e.namespaceURI,n=(e.ownerDocument||e).documentElement;return!Y.test(t||n&&n.nodeName||"HTML")},p=se.setDocument=function(e){var t,i,a=e?e.ownerDocument||e:w;return a!==d&&9===a.nodeType&&a.documentElement?(h=(d=a).documentElement,g=!o(d),w!==d&&(i=d.defaultView)&&i.top!==i&&(i.addEventListener?i.addEventListener("unload",oe,!1):i.attachEvent&&i.attachEvent("onunload",oe)),n.attributes=ce(function(e){return e.className="i",!e.getAttribute("className")}),n.getElementsByTagName=ce(function(e){return e.appendChild(d.createComment("")),!e.getElementsByTagName("*").length}),n.getElementsByClassName=K.test(d.getElementsByClassName),n.getById=ce(function(e){return h.appendChild(e).id=b,!d.getElementsByName||!d.getElementsByName(b).length}),n.getById?(r.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},r.find.ID=function(e,t){if(void 0!==t.getElementById&&g){var n=t.getElementById(e);return n?[n]:[]}}):(r.filter.ID=function(e){var t=e.replace(te,ne);return function(e){var n=void 0!==e.getAttributeNode&&e.getAttributeNode("id");return n&&n.value===t}},r.find.ID=function(e,t){if(void 0!==t.getElementById&&g){var n,r,i,o=t.getElementById(e);if(o){if((n=o.getAttributeNode("id"))&&n.value===e)return[o];for(i=t.getElementsByName(e),r=0;o=i[r++];)if((n=o.getAttributeNode("id"))&&n.value===e)return[o]}return[]}}),r.find.TAG=n.getElementsByTagName?function(e,t){return void 0!==t.getElementsByTagName?t.getElementsByTagName(e):n.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){for(;n=o[i++];)1===n.nodeType&&r.push(n);return r}return o},r.find.CLASS=n.getElementsByClassName&&function(e,t){if(void 0!==t.getElementsByClassName&&g)return t.getElementsByClassName(e)},y=[],v=[],(n.qsa=K.test(d.querySelectorAll))&&(ce(function(e){h.appendChild(e).innerHTML="<a id='"+b+"'></a><select id='"+b+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&v.push("[*^$]="+M+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||v.push("\\["+M+"*(?:value|"+R+")"),e.querySelectorAll("[id~="+b+"-]").length||v.push("~="),e.querySelectorAll(":checked").length||v.push(":checked"),e.querySelectorAll("a#"+b+"+*").length||v.push(".#.+[+~]")}),ce(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=d.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&v.push("name"+M+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&v.push(":enabled",":disabled"),h.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&v.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),v.push(",.*:")})),(n.matchesSelector=K.test(m=h.matches||h.webkitMatchesSelector||h.mozMatchesSelector||h.oMatchesSelector||h.msMatchesSelector))&&ce(function(e){n.disconnectedMatch=m.call(e,"*"),m.call(e,"[s!='']:x"),y.push("!=",$)}),v=v.length&&new RegExp(v.join("|")),y=y.length&&new RegExp(y.join("|")),t=K.test(h.compareDocumentPosition),x=t||K.test(h.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)for(;t=t.parentNode;)if(t===e)return!0;return!1},A=t?function(e,t){if(e===t)return f=!0,0;var r=!e.compareDocumentPosition-!t.compareDocumentPosition;return r||(1&(r=(e.ownerDocument||e)===(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!n.sortDetached&&t.compareDocumentPosition(e)===r?e===d||e.ownerDocument===w&&x(w,e)?-1:t===d||t.ownerDocument===w&&x(w,t)?1:c?P(c,e)-P(c,t):0:4&r?-1:1)}:function(e,t){if(e===t)return f=!0,0;var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o)return e===d?-1:t===d?1:i?-1:o?1:c?P(c,e)-P(c,t):0;if(i===o)return pe(e,t);for(n=e;n=n.parentNode;)a.unshift(n);for(n=t;n=n.parentNode;)s.unshift(n);for(;a[r]===s[r];)r++;return r?pe(a[r],s[r]):a[r]===w?-1:s[r]===w?1:0},d):d},se.matches=function(e,t){return se(e,null,null,t)},se.matchesSelector=function(e,t){if((e.ownerDocument||e)!==d&&p(e),n.matchesSelector&&g&&!N[t+" "]&&(!y||!y.test(t))&&(!v||!v.test(t)))try{var r=m.call(e,t);if(r||n.disconnectedMatch||e.document&&11!==e.document.nodeType)return r}catch(e){N(t,!0)}return se(t,d,null,[e]).length>0},se.contains=function(e,t){return(e.ownerDocument||e)!==d&&p(e),x(e,t)},se.attr=function(e,t){(e.ownerDocument||e)!==d&&p(e);var i=r.attrHandle[t.toLowerCase()],o=i&&D.call(r.attrHandle,t.toLowerCase())?i(e,t,!g):void 0;return void 0!==o?o:n.attributes||!g?e.getAttribute(t):(o=e.getAttributeNode(t))&&o.specified?o.value:null},se.escape=function(e){return(e+"").replace(re,ie)},se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},se.uniqueSort=function(e){var t,r=[],i=0,o=0;if(f=!n.detectDuplicates,c=!n.sortStable&&e.slice(0),e.sort(A),f){for(;t=e[o++];)t===e[o]&&(i=r.push(o));for(;i--;)e.splice(r[i],1)}return c=null,e},i=se.getText=function(e){var t,n="",r=0,o=e.nodeType;if(o){if(1===o||9===o||11===o){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=i(e)}else if(3===o||4===o)return e.nodeValue}else for(;t=e[r++];)n+=i(t);return n},(r=se.selectors={cacheLength:50,createPseudo:le,match:G,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||se.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&se.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return G.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&X.test(n)&&(t=a(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=E[e+" "];return t||(t=new RegExp("(^|"+M+")"+e+"("+M+"|$)"))&&E(e,function(e){return t.test("string"==typeof e.className&&e.className||void 0!==e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(e,t,n){return function(r){var i=se.attr(r,e);return null==i?"!="===t:!t||(i+="","="===t?i===n:"!="===t?i!==n:"^="===t?n&&0===i.indexOf(n):"*="===t?n&&i.indexOf(n)>-1:"$="===t?n&&i.slice(-n.length)===n:"~="===t?(" "+i.replace(F," ")+" ").indexOf(n)>-1:"|="===t&&(i===n||i.slice(0,n.length+1)===n+"-"))}},CHILD:function(e,t,n,r,i){var o="nth"!==e.slice(0,3),a="last"!==e.slice(-4),s="of-type"===t;return 1===r&&0===i?function(e){return!!e.parentNode}:function(t,n,u){var l,c,f,p,d,h,g=o!==a?"nextSibling":"previousSibling",v=t.parentNode,y=s&&t.nodeName.toLowerCase(),m=!u&&!s,x=!1;if(v){if(o){for(;g;){for(p=t;p=p[g];)if(s?p.nodeName.toLowerCase()===y:1===p.nodeType)return!1;h=g="only"===e&&!h&&"nextSibling"}return!0}if(h=[a?v.firstChild:v.lastChild],a&&m){for(x=(d=(l=(c=(f=(p=v)[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]||[])[0]===T&&l[1])&&l[2],p=d&&v.childNodes[d];p=++d&&p&&p[g]||(x=d=0)||h.pop();)if(1===p.nodeType&&++x&&p===t){c[e]=[T,d,x];break}}else if(m&&(x=d=(l=(c=(f=(p=t)[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]||[])[0]===T&&l[1]),!1===x)for(;(p=++d&&p&&p[g]||(x=d=0)||h.pop())&&((s?p.nodeName.toLowerCase()!==y:1!==p.nodeType)||!++x||(m&&((c=(f=p[b]||(p[b]={}))[p.uniqueID]||(f[p.uniqueID]={}))[e]=[T,x]),p!==t)););return(x-=i)===r||x%r==0&&x/r>=0}}},PSEUDO:function(e,t){var n,i=r.pseudos[e]||r.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);return i[b]?i(t):i.length>1?(n=[e,e,"",t],r.setFilters.hasOwnProperty(e.toLowerCase())?le(function(e,n){for(var r,o=i(e,t),a=o.length;a--;)e[r=P(e,o[a])]=!(n[r]=o[a])}):function(e){return i(e,0,n)}):i}},pseudos:{not:le(function(e){var t=[],n=[],r=s(e.replace(B,"$1"));return r[b]?le(function(e,t,n,i){for(var o,a=r(e,null,i,[]),s=e.length;s--;)(o=a[s])&&(e[s]=!(t[s]=o))}):function(e,i,o){return t[0]=e,r(t,null,o,n),t[0]=null,!n.pop()}}),has:le(function(e){return function(t){return se(e,t).length>0}}),contains:le(function(e){return e=e.replace(te,ne),function(t){return(t.textContent||i(t)).indexOf(e)>-1}}),lang:le(function(e){return V.test(e||"")||se.error("unsupported lang: "+e),e=e.replace(te,ne).toLowerCase(),function(t){var n;do{if(n=g?t.lang:t.getAttribute("xml:lang")||t.getAttribute("lang"))return(n=n.toLowerCase())===e||0===n.indexOf(e+"-")}while((t=t.parentNode)&&1===t.nodeType);return!1}}),target:function(t){var n=e.location&&e.location.hash;return n&&n.slice(1)===t.id},root:function(e){return e===h},focus:function(e){return e===d.activeElement&&(!d.hasFocus||d.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(!1),disabled:ge(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!r.pseudos.empty(e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ve(function(){return[0]}),last:ve(function(e,t){return[t-1]}),eq:ve(function(e,t,n){return[n<0?n+t:n]}),even:ve(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:ve(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:ve(function(e,t,n){for(var r=n<0?n+t:n>t?t:n;--r>=0;)e.push(r);return e}),gt:ve(function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e})}}).pseudos.nth=r.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})r.pseudos[t]=de(t);for(t in{submit:!0,reset:!0})r.pseudos[t]=he(t);function me(){}function xe(e){for(var t=0,n=e.length,r="";t<n;t++)r+=e[t].value;return r}function be(e,t,n){var r=t.dir,i=t.next,o=i||r,a=n&&"parentNode"===o,s=C++;return t.first?function(t,n,i){for(;t=t[r];)if(1===t.nodeType||a)return e(t,n,i);return!1}:function(t,n,u){var l,c,f,p=[T,s];if(u){for(;t=t[r];)if((1===t.nodeType||a)&&e(t,n,u))return!0}else for(;t=t[r];)if(1===t.nodeType||a)if(c=(f=t[b]||(t[b]={}))[t.uniqueID]||(f[t.uniqueID]={}),i&&i===t.nodeName.toLowerCase())t=t[r]||t;else{if((l=c[o])&&l[0]===T&&l[1]===s)return p[2]=l[2];if(c[o]=p,p[2]=e(t,n,u))return!0}return!1}}function we(e){return e.length>1?function(t,n,r){for(var i=e.length;i--;)if(!e[i](t,n,r))return!1;return!0}:e[0]}function Te(e,t,n,r,i){for(var o,a=[],s=0,u=e.length,l=null!=t;s<u;s++)(o=e[s])&&(n&&!n(o,r,i)||(a.push(o),l&&t.push(s)));return a}function Ce(e,t,n,r,i,o){return r&&!r[b]&&(r=Ce(r)),i&&!i[b]&&(i=Ce(i,o)),le(function(o,a,s,u){var l,c,f,p=[],d=[],h=a.length,g=o||function(e,t,n){for(var r=0,i=t.length;r<i;r++)se(e,t[r],n);return n}(t||"*",s.nodeType?[s]:s,[]),v=!e||!o&&t?g:Te(g,p,e,s,u),y=n?i||(o?e:h||r)?[]:a:v;if(n&&n(v,y,s,u),r)for(l=Te(y,d),r(l,[],s,u),c=l.length;c--;)(f=l[c])&&(y[d[c]]=!(v[d[c]]=f));if(o){if(i||e){if(i){for(l=[],c=y.length;c--;)(f=y[c])&&l.push(v[c]=f);i(null,y=[],l,u)}for(c=y.length;c--;)(f=y[c])&&(l=i?P(o,f):p[c])>-1&&(o[l]=!(a[l]=f))}}else y=Te(y===a?y.splice(h,y.length):y),i?i(null,a,y,u):H.apply(a,y)})}function Ee(e){for(var t,n,i,o=e.length,a=r.relative[e[0].type],s=a||r.relative[" "],u=a?1:0,c=be(function(e){return e===t},s,!0),f=be(function(e){return P(t,e)>-1},s,!0),p=[function(e,n,r){var i=!a&&(r||n!==l)||((t=n).nodeType?c(e,n,r):f(e,n,r));return t=null,i}];u<o;u++)if(n=r.relative[e[u].type])p=[be(we(p),n)];else{if((n=r.filter[e[u].type].apply(null,e[u].matches))[b]){for(i=++u;i<o&&!r.relative[e[i].type];i++);return Ce(u>1&&we(p),u>1&&xe(e.slice(0,u-1).concat({value:" "===e[u-2].type?"*":""})).replace(B,"$1"),n,u<i&&Ee(e.slice(u,i)),i<o&&Ee(e=e.slice(i)),i<o&&xe(e))}p.push(n)}return we(p)}return me.prototype=r.filters=r.pseudos,r.setFilters=new me,a=se.tokenize=function(e,t){var n,i,o,a,s,u,l,c=k[e+" "];if(c)return t?0:c.slice(0);for(s=e,u=[],l=r.preFilter;s;){for(a in n&&!(i=_.exec(s))||(i&&(s=s.slice(i[0].length)||s),u.push(o=[])),n=!1,(i=z.exec(s))&&(n=i.shift(),o.push({value:n,type:i[0].replace(B," ")}),s=s.slice(n.length)),r.filter)!(i=G[a].exec(s))||l[a]&&!(i=l[a](i))||(n=i.shift(),o.push({value:n,type:a,matches:i}),s=s.slice(n.length));if(!n)break}return t?s.length:s?se.error(e):k(e,u).slice(0)},s=se.compile=function(e,t){var n,i=[],o=[],s=S[e+" "];if(!s){for(t||(t=a(e)),n=t.length;n--;)(s=Ee(t[n]))[b]?i.push(s):o.push(s);(s=S(e,function(e,t){var n=t.length>0,i=e.length>0,o=function(o,a,s,u,c){var f,h,v,y=0,m="0",x=o&&[],b=[],w=l,C=o||i&&r.find.TAG("*",c),E=T+=null==w?1:Math.random()||.1,k=C.length;for(c&&(l=a===d||a||c);m!==k&&null!=(f=C[m]);m++){if(i&&f){for(h=0,a||f.ownerDocument===d||(p(f),s=!g);v=e[h++];)if(v(f,a||d,s)){u.push(f);break}c&&(T=E)}n&&((f=!v&&f)&&y--,o&&x.push(f))}if(y+=m,n&&m!==y){for(h=0;v=t[h++];)v(x,b,a,s);if(o){if(y>0)for(;m--;)x[m]||b[m]||(b[m]=q.call(u));b=Te(b)}H.apply(u,b),c&&!o&&b.length>0&&y+t.length>1&&se.uniqueSort(u)}return c&&(T=E,l=w),x};return n?le(o):o}(o,i))).selector=e}return s},u=se.select=function(e,t,n,i){var o,u,l,c,f,p="function"==typeof e&&e,d=!i&&a(e=p.selector||e);if(n=n||[],1===d.length){if((u=d[0]=d[0].slice(0)).length>2&&"ID"===(l=u[0]).type&&9===t.nodeType&&g&&r.relative[u[1].type]){if(!(t=(r.find.ID(l.matches[0].replace(te,ne),t)||[])[0]))return n;p&&(t=t.parentNode),e=e.slice(u.shift().value.length)}for(o=G.needsContext.test(e)?0:u.length;o--&&(l=u[o],!r.relative[c=l.type]);)if((f=r.find[c])&&(i=f(l.matches[0].replace(te,ne),ee.test(u[0].type)&&ye(t.parentNode)||t))){if(u.splice(o,1),!(e=i.length&&xe(u)))return H.apply(n,i),n;break}}return(p||s(e,d))(i,t,!g,n,!t||ee.test(e)&&ye(t.parentNode)||t),n},n.sortStable=b.split("").sort(A).join("")===b,n.detectDuplicates=!!f,p(),n.sortDetached=ce(function(e){return 1&e.compareDocumentPosition(d.createElement("fieldset"))}),ce(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||fe("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),n.attributes&&ce(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||fe("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),ce(function(e){return null==e.getAttribute("disabled")})||fe(R,function(e,t,n){var r;if(!n)return!0===e[t]?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null}),se}(e);b.find=C,b.expr=C.selectors,b.expr[":"]=b.expr.pseudos,b.uniqueSort=b.unique=C.uniqueSort,b.text=C.getText,b.isXMLDoc=C.isXML,b.contains=C.contains,b.escapeSelector=C.escape;var E=function(e,t,n){for(var r=[],i=void 0!==n;(e=e[t])&&9!==e.nodeType;)if(1===e.nodeType){if(i&&b(e).is(n))break;r.push(e)}return r},k=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},S=b.expr.match.needsContext;function N(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var A=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function D(e,t,n){return g(t)?b.grep(e,function(e,r){return!!t.call(e,r,e)!==n}):t.nodeType?b.grep(e,function(e){return e===t!==n}):"string"!=typeof t?b.grep(e,function(e){return u.call(t,e)>-1!==n}):b.filter(t,e,n)}b.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?b.find.matchesSelector(r,e)?[r]:[]:b.find.matches(e,b.grep(t,function(e){return 1===e.nodeType}))},b.fn.extend({find:function(e){var t,n,r=this.length,i=this;if("string"!=typeof e)return this.pushStack(b(e).filter(function(){for(t=0;t<r;t++)if(b.contains(i[t],this))return!0}));for(n=this.pushStack([]),t=0;t<r;t++)b.find(e,i[t],n);return r>1?b.uniqueSort(n):n},filter:function(e){return this.pushStack(D(this,e||[],!1))},not:function(e){return this.pushStack(D(this,e||[],!0))},is:function(e){return!!D(this,"string"==typeof e&&S.test(e)?b(e):e||[],!1).length}});var j,q=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(b.fn.init=function(e,t,n){var i,o;if(!e)return this;if(n=n||j,"string"==typeof e){if(!(i="<"===e[0]&&">"===e[e.length-1]&&e.length>=3?[null,e,null]:q.exec(e))||!i[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(i[1]){if(t=t instanceof b?t[0]:t,b.merge(this,b.parseHTML(i[1],t&&t.nodeType?t.ownerDocument||t:r,!0)),A.test(i[1])&&b.isPlainObject(t))for(i in t)g(this[i])?this[i](t[i]):this.attr(i,t[i]);return this}return(o=r.getElementById(i[2]))&&(this[0]=o,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):g(e)?void 0!==n.ready?n.ready(e):e(b):b.makeArray(e,this)}).prototype=b.fn,j=b(r);var L=/^(?:parents|prev(?:Until|All))/,H={children:!0,contents:!0,next:!0,prev:!0};function O(e,t){for(;(e=e[t])&&1!==e.nodeType;);return e}b.fn.extend({has:function(e){var t=b(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(b.contains(this,t[e]))return!0})},closest:function(e,t){var n,r=0,i=this.length,o=[],a="string"!=typeof e&&b(e);if(!S.test(e))for(;r<i;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(a?a.index(n)>-1:1===n.nodeType&&b.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(o.length>1?b.uniqueSort(o):o)},index:function(e){return e?"string"==typeof e?u.call(b(e),this[0]):u.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(b.uniqueSort(b.merge(this.get(),b(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),b.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return E(e,"parentNode")},parentsUntil:function(e,t,n){return E(e,"parentNode",n)},next:function(e){return O(e,"nextSibling")},prev:function(e){return O(e,"previousSibling")},nextAll:function(e){return E(e,"nextSibling")},prevAll:function(e){return E(e,"previousSibling")},nextUntil:function(e,t,n){return E(e,"nextSibling",n)},prevUntil:function(e,t,n){return E(e,"previousSibling",n)},siblings:function(e){return k((e.parentNode||{}).firstChild,e)},children:function(e){return k(e.firstChild)},contents:function(e){return void 0!==e.contentDocument?e.contentDocument:(N(e,"template")&&(e=e.content||e),b.merge([],e.childNodes))}},function(e,t){b.fn[e]=function(n,r){var i=b.map(this,t,n);return"Until"!==e.slice(-5)&&(r=n),r&&"string"==typeof r&&(i=b.filter(r,i)),this.length>1&&(H[e]||b.uniqueSort(i),L.test(e)&&i.reverse()),this.pushStack(i)}});var P=/[^\x20\t\r\n\f]+/g;function R(e){return e}function M(e){throw e}function I(e,t,n,r){var i;try{e&&g(i=e.promise)?i.call(e).done(t).fail(n):e&&g(i=e.then)?i.call(e,t,n):t.apply(void 0,[e].slice(r))}catch(e){n.apply(void 0,[e])}}b.Callbacks=function(e){e="string"==typeof e?function(e){var t={};return b.each(e.match(P)||[],function(e,n){t[n]=!0}),t}(e):b.extend({},e);var t,n,r,i,o=[],a=[],s=-1,u=function(){for(i=i||e.once,r=t=!0;a.length;s=-1)for(n=a.shift();++s<o.length;)!1===o[s].apply(n[0],n[1])&&e.stopOnFalse&&(s=o.length,n=!1);e.memory||(n=!1),t=!1,i&&(o=n?[]:"")},l={add:function(){return o&&(n&&!t&&(s=o.length-1,a.push(n)),function t(n){b.each(n,function(n,r){g(r)?e.unique&&l.has(r)||o.push(r):r&&r.length&&"string"!==x(r)&&t(r)})}(arguments),n&&!t&&u()),this},remove:function(){return b.each(arguments,function(e,t){for(var n;(n=b.inArray(t,o,n))>-1;)o.splice(n,1),n<=s&&s--}),this},has:function(e){return e?b.inArray(e,o)>-1:o.length>0},empty:function(){return o&&(o=[]),this},disable:function(){return i=a=[],o=n="",this},disabled:function(){return!o},lock:function(){return i=a=[],n||t||(o=n=""),this},locked:function(){return!!i},fireWith:function(e,n){return i||(n=[e,(n=n||[]).slice?n.slice():n],a.push(n),t||u()),this},fire:function(){return l.fireWith(this,arguments),this},fired:function(){return!!r}};return l},b.extend({Deferred:function(t){var n=[["notify","progress",b.Callbacks("memory"),b.Callbacks("memory"),2],["resolve","done",b.Callbacks("once memory"),b.Callbacks("once memory"),0,"resolved"],["reject","fail",b.Callbacks("once memory"),b.Callbacks("once memory"),1,"rejected"]],r="pending",i={state:function(){return r},always:function(){return o.done(arguments).fail(arguments),this},catch:function(e){return i.then(null,e)},pipe:function(){var e=arguments;return b.Deferred(function(t){b.each(n,function(n,r){var i=g(e[r[4]])&&e[r[4]];o[r[1]](function(){var e=i&&i.apply(this,arguments);e&&g(e.promise)?e.promise().progress(t.notify).done(t.resolve).fail(t.reject):t[r[0]+"With"](this,i?[e]:arguments)})}),e=null}).promise()},then:function(t,r,i){var o=0;function a(t,n,r,i){return function(){var s=this,u=arguments,l=function(){var e,l;if(!(t<o)){if((e=r.apply(s,u))===n.promise())throw new TypeError("Thenable self-resolution");l=e&&("object"==typeof e||"function"==typeof e)&&e.then,g(l)?i?l.call(e,a(o,n,R,i),a(o,n,M,i)):(o++,l.call(e,a(o,n,R,i),a(o,n,M,i),a(o,n,R,n.notifyWith))):(r!==R&&(s=void 0,u=[e]),(i||n.resolveWith)(s,u))}},c=i?l:function(){try{l()}catch(e){b.Deferred.exceptionHook&&b.Deferred.exceptionHook(e,c.stackTrace),t+1>=o&&(r!==M&&(s=void 0,u=[e]),n.rejectWith(s,u))}};t?c():(b.Deferred.getStackHook&&(c.stackTrace=b.Deferred.getStackHook()),e.setTimeout(c))}}return b.Deferred(function(e){n[0][3].add(a(0,e,g(i)?i:R,e.notifyWith)),n[1][3].add(a(0,e,g(t)?t:R)),n[2][3].add(a(0,e,g(r)?r:M))}).promise()},promise:function(e){return null!=e?b.extend(e,i):i}},o={};return b.each(n,function(e,t){var a=t[2],s=t[5];i[t[1]]=a.add,s&&a.add(function(){r=s},n[3-e][2].disable,n[3-e][3].disable,n[0][2].lock,n[0][3].lock),a.add(t[3].fire),o[t[0]]=function(){return o[t[0]+"With"](this===o?void 0:this,arguments),this},o[t[0]+"With"]=a.fireWith}),i.promise(o),t&&t.call(o,o),o},when:function(e){var t=arguments.length,n=t,r=Array(n),i=o.call(arguments),a=b.Deferred(),s=function(e){return function(n){r[e]=this,i[e]=arguments.length>1?o.call(arguments):n,--t||a.resolveWith(r,i)}};if(t<=1&&(I(e,a.done(s(n)).resolve,a.reject,!t),"pending"===a.state()||g(i[n]&&i[n].then)))return a.then();for(;n--;)I(i[n],s(n),a.reject);return a.promise()}});var W=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;b.Deferred.exceptionHook=function(t,n){e.console&&e.console.warn&&t&&W.test(t.name)&&e.console.warn("jQuery.Deferred exception: "+t.message,t.stack,n)},b.readyException=function(t){e.setTimeout(function(){throw t})};var $=b.Deferred();function F(){r.removeEventListener("DOMContentLoaded",F),e.removeEventListener("load",F),b.ready()}b.fn.ready=function(e){return $.then(e).catch(function(e){b.readyException(e)}),this},b.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--b.readyWait:b.isReady)||(b.isReady=!0,!0!==e&&--b.readyWait>0||$.resolveWith(r,[b]))}}),b.ready.then=$.then,"complete"===r.readyState||"loading"!==r.readyState&&!r.documentElement.doScroll?e.setTimeout(b.ready):(r.addEventListener("DOMContentLoaded",F),e.addEventListener("load",F));var B=function(e,t,n,r,i,o,a){var s=0,u=e.length,l=null==n;if("object"===x(n))for(s in i=!0,n)B(e,t,s,n[s],!0,o,a);else if(void 0!==r&&(i=!0,g(r)||(a=!0),l&&(a?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(b(e),n)})),t))for(;s<u;s++)t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)));return i?e:l?t.call(e):u?t(e[0],n):o},_=/^-ms-/,z=/-([a-z])/g;function U(e,t){return t.toUpperCase()}function X(e){return e.replace(_,"ms-").replace(z,U)}var V=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function G(){this.expando=b.expando+G.uid++}G.uid=1,G.prototype={cache:function(e){var t=e[this.expando];return t||(t={},V(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var r,i=this.cache(e);if("string"==typeof t)i[X(t)]=n;else for(r in t)i[X(r)]=t[r];return i},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][X(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r=e[this.expando];if(void 0!==r){if(void 0!==t){n=(t=Array.isArray(t)?t.map(X):(t=X(t))in r?[t]:t.match(P)||[]).length;for(;n--;)delete r[t[n]]}(void 0===t||b.isEmptyObject(r))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!b.isEmptyObject(t)}};var Y=new G,Q=new G,J=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,K=/[A-Z]/g;function Z(e,t,n){var r;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(K,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(r))){try{n=function(e){return"true"===e||"false"!==e&&("null"===e?null:e===+e+""?+e:J.test(e)?JSON.parse(e):e)}(n)}catch(e){}Q.set(e,t,n)}else n=void 0;return n}b.extend({hasData:function(e){return Q.hasData(e)||Y.hasData(e)},data:function(e,t,n){return Q.access(e,t,n)},removeData:function(e,t){Q.remove(e,t)},_data:function(e,t,n){return Y.access(e,t,n)},_removeData:function(e,t){Y.remove(e,t)}}),b.fn.extend({data:function(e,t){var n,r,i,o=this[0],a=o&&o.attributes;if(void 0===e){if(this.length&&(i=Q.get(o),1===o.nodeType&&!Y.get(o,"hasDataAttrs"))){for(n=a.length;n--;)a[n]&&0===(r=a[n].name).indexOf("data-")&&(r=X(r.slice(5)),Z(o,r,i[r]));Y.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof e?this.each(function(){Q.set(this,e)}):B(this,function(t){var n;if(o&&void 0===t)return void 0!==(n=Q.get(o,e))?n:void 0!==(n=Z(o,e))?n:void 0;this.each(function(){Q.set(this,e,t)})},null,t,arguments.length>1,null,!0)},removeData:function(e){return this.each(function(){Q.remove(this,e)})}}),b.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=Y.get(e,t),n&&(!r||Array.isArray(n)?r=Y.access(e,t,b.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=b.queue(e,t),r=n.length,i=n.shift(),o=b._queueHooks(e,t);"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,function(){b.dequeue(e,t)},o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return Y.get(e,n)||Y.access(e,n,{empty:b.Callbacks("once memory").add(function(){Y.remove(e,[t+"queue",n])})})}}),b.fn.extend({queue:function(e,t){var n=2;return"string"!=typeof e&&(t=e,e="fx",n--),arguments.length<n?b.queue(this[0],e):void 0===t?this:this.each(function(){var n=b.queue(this,e,t);b._queueHooks(this,e),"fx"===e&&"inprogress"!==n[0]&&b.dequeue(this,e)})},dequeue:function(e){return this.each(function(){b.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=b.Deferred(),o=this,a=this.length,s=function(){--r||i.resolveWith(o,[o])};for("string"!=typeof e&&(t=e,e=void 0),e=e||"fx";a--;)(n=Y.get(o[a],e+"queueHooks"))&&n.empty&&(r++,n.empty.add(s));return s(),i.promise(t)}});var ee=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,te=new RegExp("^(?:([+-])=|)("+ee+")([a-z%]*)$","i"),ne=["Top","Right","Bottom","Left"],re=r.documentElement,ie=function(e){return b.contains(e.ownerDocument,e)},oe={composed:!0};re.getRootNode&&(ie=function(e){return b.contains(e.ownerDocument,e)||e.getRootNode(oe)===e.ownerDocument});var ae=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&ie(e)&&"none"===b.css(e,"display")},se=function(e,t,n,r){var i,o,a={};for(o in t)a[o]=e.style[o],e.style[o]=t[o];for(o in i=n.apply(e,r||[]),t)e.style[o]=a[o];return i};function ue(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return b.css(e,t,"")},u=s(),l=n&&n[3]||(b.cssNumber[t]?"":"px"),c=e.nodeType&&(b.cssNumber[t]||"px"!==l&&+u)&&te.exec(b.css(e,t));if(c&&c[3]!==l){for(u/=2,l=l||c[3],c=+u||1;a--;)b.style(e,t,c+l),(1-o)*(1-(o=s()/u||.5))<=0&&(a=0),c/=o;c*=2,b.style(e,t,c+l),n=n||[]}return n&&(c=+c||+u||0,i=n[1]?c+(n[1]+1)*n[2]:+n[2],r&&(r.unit=l,r.start=c,r.end=i)),i}var le={};function ce(e){var t,n=e.ownerDocument,r=e.nodeName,i=le[r];return i||(t=n.body.appendChild(n.createElement(r)),i=b.css(t,"display"),t.parentNode.removeChild(t),"none"===i&&(i="block"),le[r]=i,i)}function fe(e,t){for(var n,r,i=[],o=0,a=e.length;o<a;o++)(r=e[o]).style&&(n=r.style.display,t?("none"===n&&(i[o]=Y.get(r,"display")||null,i[o]||(r.style.display="")),""===r.style.display&&ae(r)&&(i[o]=ce(r))):"none"!==n&&(i[o]="none",Y.set(r,"display",n)));for(o=0;o<a;o++)null!=i[o]&&(e[o].style.display=i[o]);return e}b.fn.extend({show:function(){return fe(this,!0)},hide:function(){return fe(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){ae(this)?b(this).show():b(this).hide()})}});var pe=/^(?:checkbox|radio)$/i,de=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,he=/^$|^module$|\/(?:java|ecma)script/i,ge={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ve(e,t){var n;return n=void 0!==e.getElementsByTagName?e.getElementsByTagName(t||"*"):void 0!==e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&N(e,t)?b.merge([e],n):n}function ye(e,t){for(var n=0,r=e.length;n<r;n++)Y.set(e[n],"globalEval",!t||Y.get(t[n],"globalEval"))}ge.optgroup=ge.option,ge.tbody=ge.tfoot=ge.colgroup=ge.caption=ge.thead,ge.th=ge.td;var me,xe,be=/<|&#?\w+;/;function we(e,t,n,r,i){for(var o,a,s,u,l,c,f=t.createDocumentFragment(),p=[],d=0,h=e.length;d<h;d++)if((o=e[d])||0===o)if("object"===x(o))b.merge(p,o.nodeType?[o]:o);else if(be.test(o)){for(a=a||f.appendChild(t.createElement("div")),s=(de.exec(o)||["",""])[1].toLowerCase(),u=ge[s]||ge._default,a.innerHTML=u[1]+b.htmlPrefilter(o)+u[2],c=u[0];c--;)a=a.lastChild;b.merge(p,a.childNodes),(a=f.firstChild).textContent=""}else p.push(t.createTextNode(o));for(f.textContent="",d=0;o=p[d++];)if(r&&b.inArray(o,r)>-1)i&&i.push(o);else if(l=ie(o),a=ve(f.appendChild(o),"script"),l&&ye(a),n)for(c=0;o=a[c++];)he.test(o.type||"")&&n.push(o);return f}me=r.createDocumentFragment().appendChild(r.createElement("div")),(xe=r.createElement("input")).setAttribute("type","radio"),xe.setAttribute("checked","checked"),xe.setAttribute("name","t"),me.appendChild(xe),h.checkClone=me.cloneNode(!0).cloneNode(!0).lastChild.checked,me.innerHTML="<textarea>x</textarea>",h.noCloneChecked=!!me.cloneNode(!0).lastChild.defaultValue;var Te=/^key/,Ce=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,Ee=/^([^.]*)(?:\.(.+)|)/;function ke(){return!0}function Se(){return!1}function Ne(e,t){return e===function(){try{return r.activeElement}catch(e){}}()==("focus"===t)}function Ae(e,t,n,r,i,o){var a,s;if("object"==typeof t){for(s in"string"!=typeof n&&(r=r||n,n=void 0),t)Ae(e,s,n,r,t[s],o);return e}if(null==r&&null==i?(i=n,r=n=void 0):null==i&&("string"==typeof n?(i=r,r=void 0):(i=r,r=n,n=void 0)),!1===i)i=Se;else if(!i)return e;return 1===o&&(a=i,(i=function(e){return b().off(e),a.apply(this,arguments)}).guid=a.guid||(a.guid=b.guid++)),e.each(function(){b.event.add(this,t,i,r,n)})}function De(e,t,n){n?(Y.set(e,t,!1),b.event.add(e,t,{namespace:!1,handler:function(e){var r,i,a=Y.get(this,t);if(1&e.isTrigger&&this[t]){if(a.length)(b.event.special[t]||{}).delegateType&&e.stopPropagation();else if(a=o.call(arguments),Y.set(this,t,a),r=n(this,t),this[t](),a!==(i=Y.get(this,t))||r?Y.set(this,t,!1):i={},a!==i)return e.stopImmediatePropagation(),e.preventDefault(),i.value}else a.length&&(Y.set(this,t,{value:b.event.trigger(b.extend(a[0],b.Event.prototype),a.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===Y.get(e,t)&&b.event.add(e,t,ke)}b.event={global:{},add:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.get(e);if(v)for(n.handler&&(n=(o=n).handler,i=o.selector),i&&b.find.matchesSelector(re,i),n.guid||(n.guid=b.guid++),(u=v.events)||(u=v.events={}),(a=v.handle)||(a=v.handle=function(t){return void 0!==b&&b.event.triggered!==t.type?b.event.dispatch.apply(e,arguments):void 0}),l=(t=(t||"").match(P)||[""]).length;l--;)d=g=(s=Ee.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d&&(f=b.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=b.event.special[d]||{},c=b.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&b.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||((p=u[d]=[]).delegateCount=0,f.setup&&!1!==f.setup.call(e,r,h,a)||e.addEventListener&&e.addEventListener(d,a)),f.add&&(f.add.call(e,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),b.event.global[d]=!0)},remove:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.hasData(e)&&Y.get(e);if(v&&(u=v.events)){for(l=(t=(t||"").match(P)||[""]).length;l--;)if(d=g=(s=Ee.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d){for(f=b.event.special[d]||{},p=u[d=(r?f.delegateType:f.bindType)||d]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),a=o=p.length;o--;)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||s&&!s.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));a&&!p.length&&(f.teardown&&!1!==f.teardown.call(e,h,v.handle)||b.removeEvent(e,d,v.handle),delete u[d])}else for(d in u)b.event.remove(e,d+t[l],n,r,!0);b.isEmptyObject(u)&&Y.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=b.event.fix(e),u=new Array(arguments.length),l=(Y.get(this,"events")||{})[s.type]||[],c=b.event.special[s.type]||{};for(u[0]=s,t=1;t<arguments.length;t++)u[t]=arguments[t];if(s.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,s)){for(a=b.event.handlers.call(this,s,l),t=0;(i=a[t++])&&!s.isPropagationStopped();)for(s.currentTarget=i.elem,n=0;(o=i.handlers[n++])&&!s.isImmediatePropagationStopped();)s.rnamespace&&!1!==o.namespace&&!s.rnamespace.test(o.namespace)||(s.handleObj=o,s.data=o.data,void 0!==(r=((b.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,u))&&!1===(s.result=r)&&(s.preventDefault(),s.stopPropagation()));return c.postDispatch&&c.postDispatch.call(this,s),s.result}},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,l=e.target;if(u&&l.nodeType&&!("click"===e.type&&e.button>=1))for(;l!==this;l=l.parentNode||this)if(1===l.nodeType&&("click"!==e.type||!0!==l.disabled)){for(o=[],a={},n=0;n<u;n++)void 0===a[i=(r=t[n]).selector+" "]&&(a[i]=r.needsContext?b(i,this).index(l)>-1:b.find(i,this,null,[l]).length),a[i]&&o.push(r);o.length&&s.push({elem:l,handlers:o})}return l=this,u<t.length&&s.push({elem:l,handlers:t.slice(u)}),s},addProp:function(e,t){Object.defineProperty(b.Event.prototype,e,{enumerable:!0,configurable:!0,get:g(t)?function(){if(this.originalEvent)return t(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[e]},set:function(t){Object.defineProperty(this,e,{enumerable:!0,configurable:!0,writable:!0,value:t})}})},fix:function(e){return e[b.expando]?e:new b.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return pe.test(t.type)&&t.click&&N(t,"input")&&De(t,"click",ke),!1},trigger:function(e){var t=this||e;return pe.test(t.type)&&t.click&&N(t,"input")&&De(t,"click"),!0},_default:function(e){var t=e.target;return pe.test(t.type)&&t.click&&N(t,"input")&&Y.get(t,"click")||N(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},b.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},b.Event=function(e,t){if(!(this instanceof b.Event))return new b.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?ke:Se,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&b.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[b.expando]=!0},b.Event.prototype={constructor:b.Event,isDefaultPrevented:Se,isPropagationStopped:Se,isImmediatePropagationStopped:Se,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=ke,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=ke,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=ke,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},b.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,char:!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&Te.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&Ce.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},b.event.addProp),b.each({focus:"focusin",blur:"focusout"},function(e,t){b.event.special[e]={setup:function(){return De(this,e,Ne),!1},trigger:function(){return De(this,e),!0},delegateType:t}}),b.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,t){b.event.special[e]={delegateType:t,bindType:t,handle:function(e){var n,r=e.relatedTarget,i=e.handleObj;return r&&(r===this||b.contains(this,r))||(e.type=i.origType,n=i.handler.apply(this,arguments),e.type=t),n}}}),b.fn.extend({on:function(e,t,n,r){return Ae(this,e,t,n,r)},one:function(e,t,n,r){return Ae(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,b(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Se),this.each(function(){b.event.remove(this,e,n,t)})}});var je=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,qe=/<script|<style|<link/i,Le=/checked\s*(?:[^=]|=\s*.checked.)/i,He=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function Oe(e,t){return N(e,"table")&&N(11!==t.nodeType?t:t.firstChild,"tr")&&b(e).children("tbody")[0]||e}function Pe(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function Re(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function Me(e,t){var n,r,i,o,a,s,u,l;if(1===t.nodeType){if(Y.hasData(e)&&(o=Y.access(e),a=Y.set(t,o),l=o.events))for(i in delete a.handle,a.events={},l)for(n=0,r=l[i].length;n<r;n++)b.event.add(t,i,l[i][n]);Q.hasData(e)&&(s=Q.access(e),u=b.extend({},s),Q.set(t,u))}}function Ie(e,t,n,r){t=a.apply([],t);var i,o,s,u,l,c,f=0,p=e.length,d=p-1,v=t[0],y=g(v);if(y||p>1&&"string"==typeof v&&!h.checkClone&&Le.test(v))return e.each(function(i){var o=e.eq(i);y&&(t[0]=v.call(this,i,o.html())),Ie(o,t,n,r)});if(p&&(o=(i=we(t,e[0].ownerDocument,!1,e,r)).firstChild,1===i.childNodes.length&&(i=o),o||r)){for(u=(s=b.map(ve(i,"script"),Pe)).length;f<p;f++)l=i,f!==d&&(l=b.clone(l,!0,!0),u&&b.merge(s,ve(l,"script"))),n.call(e[f],l,f);if(u)for(c=s[s.length-1].ownerDocument,b.map(s,Re),f=0;f<u;f++)l=s[f],he.test(l.type||"")&&!Y.access(l,"globalEval")&&b.contains(c,l)&&(l.src&&"module"!==(l.type||"").toLowerCase()?b._evalUrl&&!l.noModule&&b._evalUrl(l.src,{nonce:l.nonce||l.getAttribute("nonce")}):m(l.textContent.replace(He,""),l,c))}return e}function We(e,t,n){for(var r,i=t?b.filter(t,e):e,o=0;null!=(r=i[o]);o++)n||1!==r.nodeType||b.cleanData(ve(r)),r.parentNode&&(n&&ie(r)&&ye(ve(r,"script")),r.parentNode.removeChild(r));return e}b.extend({htmlPrefilter:function(e){return e.replace(je,"<$1></$2>")},clone:function(e,t,n){var r,i,o,a,s,u,l,c=e.cloneNode(!0),f=ie(e);if(!(h.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||b.isXMLDoc(e)))for(a=ve(c),r=0,i=(o=ve(e)).length;r<i;r++)s=o[r],u=a[r],l=void 0,"input"===(l=u.nodeName.toLowerCase())&&pe.test(s.type)?u.checked=s.checked:"input"!==l&&"textarea"!==l||(u.defaultValue=s.defaultValue);if(t)if(n)for(o=o||ve(e),a=a||ve(c),r=0,i=o.length;r<i;r++)Me(o[r],a[r]);else Me(e,c);return(a=ve(c,"script")).length>0&&ye(a,!f&&ve(e,"script")),c},cleanData:function(e){for(var t,n,r,i=b.event.special,o=0;void 0!==(n=e[o]);o++)if(V(n)){if(t=n[Y.expando]){if(t.events)for(r in t.events)i[r]?b.event.remove(n,r):b.removeEvent(n,r,t.handle);n[Y.expando]=void 0}n[Q.expando]&&(n[Q.expando]=void 0)}}}),b.fn.extend({detach:function(e){return We(this,e,!0)},remove:function(e){return We(this,e)},text:function(e){return B(this,function(e){return void 0===e?b.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return Ie(this,arguments,function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||Oe(this,e).appendChild(e)})},prepend:function(){return Ie(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=Oe(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return Ie(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return Ie(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(b.cleanData(ve(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return b.clone(this,e,t)})},html:function(e){return B(this,function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!qe.test(e)&&!ge[(de.exec(e)||["",""])[1].toLowerCase()]){e=b.htmlPrefilter(e);try{for(;n<r;n++)1===(t=this[n]||{}).nodeType&&(b.cleanData(ve(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var e=[];return Ie(this,arguments,function(t){var n=this.parentNode;b.inArray(this,e)<0&&(b.cleanData(ve(this)),n&&n.replaceChild(t,this))},e)}}),b.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,t){b.fn[e]=function(e){for(var n,r=[],i=b(e),o=i.length-1,a=0;a<=o;a++)n=a===o?this:this.clone(!0),b(i[a])[t](n),s.apply(r,n.get());return this.pushStack(r)}});var $e=new RegExp("^("+ee+")(?!px)[a-z%]+$","i"),Fe=function(t){var n=t.ownerDocument.defaultView;return n&&n.opener||(n=e),n.getComputedStyle(t)},Be=new RegExp(ne.join("|"),"i");function _e(e,t,n){var r,i,o,a,s=e.style;return(n=n||Fe(e))&&(""!==(a=n.getPropertyValue(t)||n[t])||ie(e)||(a=b.style(e,t)),!h.pixelBoxStyles()&&$e.test(a)&&Be.test(t)&&(r=s.width,i=s.minWidth,o=s.maxWidth,s.minWidth=s.maxWidth=s.width=a,a=n.width,s.width=r,s.minWidth=i,s.maxWidth=o)),void 0!==a?a+"":a}function ze(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function t(){if(c){l.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",c.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",re.appendChild(l).appendChild(c);var t=e.getComputedStyle(c);i="1%"!==t.top,u=12===n(t.marginLeft),c.style.right="60%",s=36===n(t.right),o=36===n(t.width),c.style.position="absolute",a=12===n(c.offsetWidth/3),re.removeChild(l),c=null}}function n(e){return Math.round(parseFloat(e))}var i,o,a,s,u,l=r.createElement("div"),c=r.createElement("div");c.style&&(c.style.backgroundClip="content-box",c.cloneNode(!0).style.backgroundClip="",h.clearCloneStyle="content-box"===c.style.backgroundClip,b.extend(h,{boxSizingReliable:function(){return t(),o},pixelBoxStyles:function(){return t(),s},pixelPosition:function(){return t(),i},reliableMarginLeft:function(){return t(),u},scrollboxSize:function(){return t(),a}}))}();var Ue=["Webkit","Moz","ms"],Xe=r.createElement("div").style,Ve={};function Ge(e){var t=b.cssProps[e]||Ve[e];return t||(e in Xe?e:Ve[e]=function(e){for(var t=e[0].toUpperCase()+e.slice(1),n=Ue.length;n--;)if((e=Ue[n]+t)in Xe)return e}(e)||e)}var Ye=/^(none|table(?!-c[ea]).+)/,Qe=/^--/,Je={position:"absolute",visibility:"hidden",display:"block"},Ke={letterSpacing:"0",fontWeight:"400"};function Ze(e,t,n){var r=te.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function et(e,t,n,r,i,o){var a="width"===t?1:0,s=0,u=0;if(n===(r?"border":"content"))return 0;for(;a<4;a+=2)"margin"===n&&(u+=b.css(e,n+ne[a],!0,i)),r?("content"===n&&(u-=b.css(e,"padding"+ne[a],!0,i)),"margin"!==n&&(u-=b.css(e,"border"+ne[a]+"Width",!0,i))):(u+=b.css(e,"padding"+ne[a],!0,i),"padding"!==n?u+=b.css(e,"border"+ne[a]+"Width",!0,i):s+=b.css(e,"border"+ne[a]+"Width",!0,i));return!r&&o>=0&&(u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0),u}function tt(e,t,n){var r=Fe(e),i=(!h.boxSizingReliable()||n)&&"border-box"===b.css(e,"boxSizing",!1,r),o=i,a=_e(e,t,r),s="offset"+t[0].toUpperCase()+t.slice(1);if($e.test(a)){if(!n)return a;a="auto"}return(!h.boxSizingReliable()&&i||"auto"===a||!parseFloat(a)&&"inline"===b.css(e,"display",!1,r))&&e.getClientRects().length&&(i="border-box"===b.css(e,"boxSizing",!1,r),(o=s in e)&&(a=e[s])),(a=parseFloat(a)||0)+et(e,t,n||(i?"border":"content"),o,r,a)+"px"}function nt(e,t,n,r,i){return new nt.prototype.init(e,t,n,r,i)}b.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=_e(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,a,s=X(t),u=Qe.test(t),l=e.style;if(u||(t=Ge(s)),a=b.cssHooks[t]||b.cssHooks[s],void 0===n)return a&&"get"in a&&void 0!==(i=a.get(e,!1,r))?i:l[t];"string"===(o=typeof n)&&(i=te.exec(n))&&i[1]&&(n=ue(e,t,i),o="number"),null!=n&&n==n&&("number"!==o||u||(n+=i&&i[3]||(b.cssNumber[s]?"":"px")),h.clearCloneStyle||""!==n||0!==t.indexOf("background")||(l[t]="inherit"),a&&"set"in a&&void 0===(n=a.set(e,n,r))||(u?l.setProperty(t,n):l[t]=n))}},css:function(e,t,n,r){var i,o,a,s=X(t);return Qe.test(t)||(t=Ge(s)),(a=b.cssHooks[t]||b.cssHooks[s])&&"get"in a&&(i=a.get(e,!0,n)),void 0===i&&(i=_e(e,t,r)),"normal"===i&&t in Ke&&(i=Ke[t]),""===n||n?(o=parseFloat(i),!0===n||isFinite(o)?o||0:i):i}}),b.each(["height","width"],function(e,t){b.cssHooks[t]={get:function(e,n,r){if(n)return!Ye.test(b.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?tt(e,t,r):se(e,Je,function(){return tt(e,t,r)})},set:function(e,n,r){var i,o=Fe(e),a=!h.scrollboxSize()&&"absolute"===o.position,s=(a||r)&&"border-box"===b.css(e,"boxSizing",!1,o),u=r?et(e,t,r,s,o):0;return s&&a&&(u-=Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-parseFloat(o[t])-et(e,t,"border",!1,o)-.5)),u&&(i=te.exec(n))&&"px"!==(i[3]||"px")&&(e.style[t]=n,n=b.css(e,t)),Ze(0,n,u)}}}),b.cssHooks.marginLeft=ze(h.reliableMarginLeft,function(e,t){if(t)return(parseFloat(_e(e,"marginLeft"))||e.getBoundingClientRect().left-se(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),b.each({margin:"",padding:"",border:"Width"},function(e,t){b.cssHooks[e+t]={expand:function(n){for(var r=0,i={},o="string"==typeof n?n.split(" "):[n];r<4;r++)i[e+ne[r]+t]=o[r]||o[r-2]||o[0];return i}},"margin"!==e&&(b.cssHooks[e+t].set=Ze)}),b.fn.extend({css:function(e,t){return B(this,function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){for(r=Fe(e),i=t.length;a<i;a++)o[t[a]]=b.css(e,t[a],!1,r);return o}return void 0!==n?b.style(e,t,n):b.css(e,t)},e,t,arguments.length>1)}}),b.Tween=nt,nt.prototype={constructor:nt,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||b.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(b.cssNumber[n]?"":"px")},cur:function(){var e=nt.propHooks[this.prop];return e&&e.get?e.get(this):nt.propHooks._default.get(this)},run:function(e){var t,n=nt.propHooks[this.prop];return this.options.duration?this.pos=t=b.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):nt.propHooks._default.set(this),this}},nt.prototype.init.prototype=nt.prototype,nt.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=b.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){b.fx.step[e.prop]?b.fx.step[e.prop](e):1!==e.elem.nodeType||!b.cssHooks[e.prop]&&null==e.elem.style[Ge(e.prop)]?e.elem[e.prop]=e.now:b.style(e.elem,e.prop,e.now+e.unit)}}},nt.propHooks.scrollTop=nt.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},b.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},b.fx=nt.prototype.init,b.fx.step={};var rt,it,ot=/^(?:toggle|show|hide)$/,at=/queueHooks$/;function st(){it&&(!1===r.hidden&&e.requestAnimationFrame?e.requestAnimationFrame(st):e.setTimeout(st,b.fx.interval),b.fx.tick())}function ut(){return e.setTimeout(function(){rt=void 0}),rt=Date.now()}function lt(e,t){var n,r=0,i={height:e};for(t=t?1:0;r<4;r+=2-t)i["margin"+(n=ne[r])]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function ct(e,t,n){for(var r,i=(ft.tweeners[t]||[]).concat(ft.tweeners["*"]),o=0,a=i.length;o<a;o++)if(r=i[o].call(n,t,e))return r}function ft(e,t,n){var r,i,o=0,a=ft.prefilters.length,s=b.Deferred().always(function(){delete u.elem}),u=function(){if(i)return!1;for(var t=rt||ut(),n=Math.max(0,l.startTime+l.duration-t),r=1-(n/l.duration||0),o=0,a=l.tweens.length;o<a;o++)l.tweens[o].run(r);return s.notifyWith(e,[l,r,n]),r<1&&a?n:(a||s.notifyWith(e,[l,1,0]),s.resolveWith(e,[l]),!1)},l=s.promise({elem:e,props:b.extend({},t),opts:b.extend(!0,{specialEasing:{},easing:b.easing._default},n),originalProperties:t,originalOptions:n,startTime:rt||ut(),duration:n.duration,tweens:[],createTween:function(t,n){var r=b.Tween(e,l.opts,t,n,l.opts.specialEasing[t]||l.opts.easing);return l.tweens.push(r),r},stop:function(t){var n=0,r=t?l.tweens.length:0;if(i)return this;for(i=!0;n<r;n++)l.tweens[n].run(1);return t?(s.notifyWith(e,[l,1,0]),s.resolveWith(e,[l,t])):s.rejectWith(e,[l,t]),this}}),c=l.props;for(!function(e,t){var n,r,i,o,a;for(n in e)if(i=t[r=X(n)],o=e[n],Array.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),(a=b.cssHooks[r])&&"expand"in a)for(n in o=a.expand(o),delete e[r],o)n in e||(e[n]=o[n],t[n]=i);else t[r]=i}(c,l.opts.specialEasing);o<a;o++)if(r=ft.prefilters[o].call(l,e,c,l.opts))return g(r.stop)&&(b._queueHooks(l.elem,l.opts.queue).stop=r.stop.bind(r)),r;return b.map(c,ct,l),g(l.opts.start)&&l.opts.start.call(e,l),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always),b.fx.timer(b.extend(u,{elem:e,anim:l,queue:l.opts.queue})),l}b.Animation=b.extend(ft,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return ue(n.elem,e,te.exec(t),n),n}]},tweener:function(e,t){g(e)?(t=e,e=["*"]):e=e.match(P);for(var n,r=0,i=e.length;r<i;r++)n=e[r],ft.tweeners[n]=ft.tweeners[n]||[],ft.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var r,i,o,a,s,u,l,c,f="width"in t||"height"in t,p=this,d={},h=e.style,g=e.nodeType&&ae(e),v=Y.get(e,"fxshow");for(r in n.queue||(null==(a=b._queueHooks(e,"fx")).unqueued&&(a.unqueued=0,s=a.empty.fire,a.empty.fire=function(){a.unqueued||s()}),a.unqueued++,p.always(function(){p.always(function(){a.unqueued--,b.queue(e,"fx").length||a.empty.fire()})})),t)if(i=t[r],ot.test(i)){if(delete t[r],o=o||"toggle"===i,i===(g?"hide":"show")){if("show"!==i||!v||void 0===v[r])continue;g=!0}d[r]=v&&v[r]||b.style(e,r)}if((u=!b.isEmptyObject(t))||!b.isEmptyObject(d))for(r in f&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(l=v&&v.display)&&(l=Y.get(e,"display")),"none"===(c=b.css(e,"display"))&&(l?c=l:(fe([e],!0),l=e.style.display||l,c=b.css(e,"display"),fe([e]))),("inline"===c||"inline-block"===c&&null!=l)&&"none"===b.css(e,"float")&&(u||(p.done(function(){h.display=l}),null==l&&(c=h.display,l="none"===c?"":c)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always(function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]})),u=!1,d)u||(v?"hidden"in v&&(g=v.hidden):v=Y.access(e,"fxshow",{display:l}),o&&(v.hidden=!g),g&&fe([e],!0),p.done(function(){for(r in g||fe([e]),Y.remove(e,"fxshow"),d)b.style(e,r,d[r])})),u=ct(g?v[r]:0,r,p),r in v||(v[r]=u.start,g&&(u.end=u.start,u.start=0))}],prefilter:function(e,t){t?ft.prefilters.unshift(e):ft.prefilters.push(e)}}),b.speed=function(e,t,n){var r=e&&"object"==typeof e?b.extend({},e):{complete:n||!n&&t||g(e)&&e,duration:e,easing:n&&t||t&&!g(t)&&t};return b.fx.off?r.duration=0:"number"!=typeof r.duration&&(r.duration in b.fx.speeds?r.duration=b.fx.speeds[r.duration]:r.duration=b.fx.speeds._default),null!=r.queue&&!0!==r.queue||(r.queue="fx"),r.old=r.complete,r.complete=function(){g(r.old)&&r.old.call(this),r.queue&&b.dequeue(this,r.queue)},r},b.fn.extend({fadeTo:function(e,t,n,r){return this.filter(ae).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(e,t,n,r){var i=b.isEmptyObject(e),o=b.speed(t,n,r),a=function(){var t=ft(this,b.extend({},e),o);(i||Y.get(this,"finish"))&&t.stop(!0)};return a.finish=a,i||!1===o.queue?this.each(a):this.queue(o.queue,a)},stop:function(e,t,n){var r=function(e){var t=e.stop;delete e.stop,t(n)};return"string"!=typeof e&&(n=t,t=e,e=void 0),t&&!1!==e&&this.queue(e||"fx",[]),this.each(function(){var t=!0,i=null!=e&&e+"queueHooks",o=b.timers,a=Y.get(this);if(i)a[i]&&a[i].stop&&r(a[i]);else for(i in a)a[i]&&a[i].stop&&at.test(i)&&r(a[i]);for(i=o.length;i--;)o[i].elem!==this||null!=e&&o[i].queue!==e||(o[i].anim.stop(n),t=!1,o.splice(i,1));!t&&n||b.dequeue(this,e)})},finish:function(e){return!1!==e&&(e=e||"fx"),this.each(function(){var t,n=Y.get(this),r=n[e+"queue"],i=n[e+"queueHooks"],o=b.timers,a=r?r.length:0;for(n.finish=!0,b.queue(this,e,[]),i&&i.stop&&i.stop.call(this,!0),t=o.length;t--;)o[t].elem===this&&o[t].queue===e&&(o[t].anim.stop(!0),o.splice(t,1));for(t=0;t<a;t++)r[t]&&r[t].finish&&r[t].finish.call(this);delete n.finish})}}),b.each(["toggle","show","hide"],function(e,t){var n=b.fn[t];b.fn[t]=function(e,r,i){return null==e||"boolean"==typeof e?n.apply(this,arguments):this.animate(lt(t,!0),e,r,i)}}),b.each({slideDown:lt("show"),slideUp:lt("hide"),slideToggle:lt("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,t){b.fn[e]=function(e,n,r){return this.animate(t,e,n,r)}}),b.timers=[],b.fx.tick=function(){var e,t=0,n=b.timers;for(rt=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||b.fx.stop(),rt=void 0},b.fx.timer=function(e){b.timers.push(e),b.fx.start()},b.fx.interval=13,b.fx.start=function(){it||(it=!0,st())},b.fx.stop=function(){it=null},b.fx.speeds={slow:600,fast:200,_default:400},b.fn.delay=function(t,n){return t=b.fx&&b.fx.speeds[t]||t,n=n||"fx",this.queue(n,function(n,r){var i=e.setTimeout(n,t);r.stop=function(){e.clearTimeout(i)}})},function(){var e=r.createElement("input"),t=r.createElement("select").appendChild(r.createElement("option"));e.type="checkbox",h.checkOn=""!==e.value,h.optSelected=t.selected,(e=r.createElement("input")).value="t",e.type="radio",h.radioValue="t"===e.value}();var pt,dt=b.expr.attrHandle;b.fn.extend({attr:function(e,t){return B(this,b.attr,e,t,arguments.length>1)},removeAttr:function(e){return this.each(function(){b.removeAttr(this,e)})}}),b.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return void 0===e.getAttribute?b.prop(e,t,n):(1===o&&b.isXMLDoc(e)||(i=b.attrHooks[t.toLowerCase()]||(b.expr.match.bool.test(t)?pt:void 0)),void 0!==n?null===n?void b.removeAttr(e,t):i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:(e.setAttribute(t,n+""),n):i&&"get"in i&&null!==(r=i.get(e,t))?r:null==(r=b.find.attr(e,t))?void 0:r)},attrHooks:{type:{set:function(e,t){if(!h.radioValue&&"radio"===t&&N(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(P);if(i&&1===e.nodeType)for(;n=i[r++];)e.removeAttribute(n)}}),pt={set:function(e,t,n){return!1===t?b.removeAttr(e,n):e.setAttribute(n,n),n}},b.each(b.expr.match.bool.source.match(/\w+/g),function(e,t){var n=dt[t]||b.find.attr;dt[t]=function(e,t,r){var i,o,a=t.toLowerCase();return r||(o=dt[a],dt[a]=i,i=null!=n(e,t,r)?a:null,dt[a]=o),i}});var ht=/^(?:input|select|textarea|button)$/i,gt=/^(?:a|area)$/i;function vt(e){return(e.match(P)||[]).join(" ")}function yt(e){return e.getAttribute&&e.getAttribute("class")||""}function mt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(P)||[]}b.fn.extend({prop:function(e,t){return B(this,b.prop,e,t,arguments.length>1)},removeProp:function(e){return this.each(function(){delete this[b.propFix[e]||e]})}}),b.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return 1===o&&b.isXMLDoc(e)||(t=b.propFix[t]||t,i=b.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]},propHooks:{tabIndex:{get:function(e){var t=b.find.attr(e,"tabindex");return t?parseInt(t,10):ht.test(e.nodeName)||gt.test(e.nodeName)&&e.href?0:-1}}},propFix:{for:"htmlFor",class:"className"}}),h.optSelected||(b.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),b.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){b.propFix[this.toLowerCase()]=this}),b.fn.extend({addClass:function(e){var t,n,r,i,o,a,s,u=0;if(g(e))return this.each(function(t){b(this).addClass(e.call(this,t,yt(this)))});if((t=mt(e)).length)for(;n=this[u++];)if(i=yt(n),r=1===n.nodeType&&" "+vt(i)+" "){for(a=0;o=t[a++];)r.indexOf(" "+o+" ")<0&&(r+=o+" ");i!==(s=vt(r))&&n.setAttribute("class",s)}return this},removeClass:function(e){var t,n,r,i,o,a,s,u=0;if(g(e))return this.each(function(t){b(this).removeClass(e.call(this,t,yt(this)))});if(!arguments.length)return this.attr("class","");if((t=mt(e)).length)for(;n=this[u++];)if(i=yt(n),r=1===n.nodeType&&" "+vt(i)+" "){for(a=0;o=t[a++];)for(;r.indexOf(" "+o+" ")>-1;)r=r.replace(" "+o+" "," ");i!==(s=vt(r))&&n.setAttribute("class",s)}return this},toggleClass:function(e,t){var n=typeof e,r="string"===n||Array.isArray(e);return"boolean"==typeof t&&r?t?this.addClass(e):this.removeClass(e):g(e)?this.each(function(n){b(this).toggleClass(e.call(this,n,yt(this),t),t)}):this.each(function(){var t,i,o,a;if(r)for(i=0,o=b(this),a=mt(e);t=a[i++];)o.hasClass(t)?o.removeClass(t):o.addClass(t);else void 0!==e&&"boolean"!==n||((t=yt(this))&&Y.set(this,"__className__",t),this.setAttribute&&this.setAttribute("class",t||!1===e?"":Y.get(this,"__className__")||""))})},hasClass:function(e){var t,n,r=0;for(t=" "+e+" ";n=this[r++];)if(1===n.nodeType&&(" "+vt(yt(n))+" ").indexOf(t)>-1)return!0;return!1}});var xt=/\r/g;b.fn.extend({val:function(e){var t,n,r,i=this[0];return arguments.length?(r=g(e),this.each(function(n){var i;1===this.nodeType&&(null==(i=r?e.call(this,n,b(this).val()):e)?i="":"number"==typeof i?i+="":Array.isArray(i)&&(i=b.map(i,function(e){return null==e?"":e+""})),(t=b.valHooks[this.type]||b.valHooks[this.nodeName.toLowerCase()])&&"set"in t&&void 0!==t.set(this,i,"value")||(this.value=i))})):i?(t=b.valHooks[i.type]||b.valHooks[i.nodeName.toLowerCase()])&&"get"in t&&void 0!==(n=t.get(i,"value"))?n:"string"==typeof(n=i.value)?n.replace(xt,""):null==n?"":n:void 0}}),b.extend({valHooks:{option:{get:function(e){var t=b.find.attr(e,"value");return null!=t?t:vt(b.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a="select-one"===e.type,s=a?null:[],u=a?o+1:i.length;for(r=o<0?u:a?o:0;r<u;r++)if(((n=i[r]).selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!N(n.parentNode,"optgroup"))){if(t=b(n).val(),a)return t;s.push(t)}return s},set:function(e,t){for(var n,r,i=e.options,o=b.makeArray(t),a=i.length;a--;)((r=i[a]).selected=b.inArray(b.valHooks.option.get(r),o)>-1)&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),b.each(["radio","checkbox"],function(){b.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=b.inArray(b(e).val(),t)>-1}},h.checkOn||(b.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})}),h.focusin="onfocusin"in e;var bt=/^(?:focusinfocus|focusoutblur)$/,wt=function(e){e.stopPropagation()};b.extend(b.event,{trigger:function(t,n,i,o){var a,s,u,l,c,p,d,h,y=[i||r],m=f.call(t,"type")?t.type:t,x=f.call(t,"namespace")?t.namespace.split("."):[];if(s=h=u=i=i||r,3!==i.nodeType&&8!==i.nodeType&&!bt.test(m+b.event.triggered)&&(m.indexOf(".")>-1&&(x=m.split("."),m=x.shift(),x.sort()),c=m.indexOf(":")<0&&"on"+m,(t=t[b.expando]?t:new b.Event(m,"object"==typeof t&&t)).isTrigger=o?2:3,t.namespace=x.join("."),t.rnamespace=t.namespace?new RegExp("(^|\\.)"+x.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,t.result=void 0,t.target||(t.target=i),n=null==n?[t]:b.makeArray(n,[t]),d=b.event.special[m]||{},o||!d.trigger||!1!==d.trigger.apply(i,n))){if(!o&&!d.noBubble&&!v(i)){for(l=d.delegateType||m,bt.test(l+m)||(s=s.parentNode);s;s=s.parentNode)y.push(s),u=s;u===(i.ownerDocument||r)&&y.push(u.defaultView||u.parentWindow||e)}for(a=0;(s=y[a++])&&!t.isPropagationStopped();)h=s,t.type=a>1?l:d.bindType||m,(p=(Y.get(s,"events")||{})[t.type]&&Y.get(s,"handle"))&&p.apply(s,n),(p=c&&s[c])&&p.apply&&V(s)&&(t.result=p.apply(s,n),!1===t.result&&t.preventDefault());return t.type=m,o||t.isDefaultPrevented()||d._default&&!1!==d._default.apply(y.pop(),n)||!V(i)||c&&g(i[m])&&!v(i)&&((u=i[c])&&(i[c]=null),b.event.triggered=m,t.isPropagationStopped()&&h.addEventListener(m,wt),i[m](),t.isPropagationStopped()&&h.removeEventListener(m,wt),b.event.triggered=void 0,u&&(i[c]=u)),t.result}},simulate:function(e,t,n){var r=b.extend(new b.Event,n,{type:e,isSimulated:!0});b.event.trigger(r,null,t)}}),b.fn.extend({trigger:function(e,t){return this.each(function(){b.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return b.event.trigger(e,t,n,!0)}}),h.focusin||b.each({focus:"focusin",blur:"focusout"},function(e,t){var n=function(e){b.event.simulate(t,e.target,b.event.fix(e))};b.event.special[t]={setup:function(){var r=this.ownerDocument||this,i=Y.access(r,t);i||r.addEventListener(e,n,!0),Y.access(r,t,(i||0)+1)},teardown:function(){var r=this.ownerDocument||this,i=Y.access(r,t)-1;i?Y.access(r,t,i):(r.removeEventListener(e,n,!0),Y.remove(r,t))}}});var Tt=e.location,Ct=Date.now(),Et=/\?/;b.parseXML=function(t){var n;if(!t||"string"!=typeof t)return null;try{n=(new e.DOMParser).parseFromString(t,"text/xml")}catch(e){n=void 0}return n&&!n.getElementsByTagName("parsererror").length||b.error("Invalid XML: "+t),n};var kt=/\[\]$/,St=/\r?\n/g,Nt=/^(?:submit|button|image|reset|file)$/i,At=/^(?:input|select|textarea|keygen)/i;function Dt(e,t,n,r){var i;if(Array.isArray(t))b.each(t,function(t,i){n||kt.test(e)?r(e,i):Dt(e+"["+("object"==typeof i&&null!=i?t:"")+"]",i,n,r)});else if(n||"object"!==x(t))r(e,t);else for(i in t)Dt(e+"["+i+"]",t[i],n,r)}b.param=function(e,t){var n,r=[],i=function(e,t){var n=g(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!b.isPlainObject(e))b.each(e,function(){i(this.name,this.value)});else for(n in e)Dt(n,e[n],t,i);return r.join("&")},b.fn.extend({serialize:function(){return b.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=b.prop(this,"elements");return e?b.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!b(this).is(":disabled")&&At.test(this.nodeName)&&!Nt.test(e)&&(this.checked||!pe.test(e))}).map(function(e,t){var n=b(this).val();return null==n?null:Array.isArray(n)?b.map(n,function(e){return{name:t.name,value:e.replace(St,"\r\n")}}):{name:t.name,value:n.replace(St,"\r\n")}}).get()}});var jt=/%20/g,qt=/#.*$/,Lt=/([?&])_=[^&]*/,Ht=/^(.*?):[ \t]*([^\r\n]*)$/gm,Ot=/^(?:GET|HEAD)$/,Pt=/^\/\//,Rt={},Mt={},It="*/".concat("*"),Wt=r.createElement("a");function $t(e){return function(t,n){"string"!=typeof t&&(n=t,t="*");var r,i=0,o=t.toLowerCase().match(P)||[];if(g(n))for(;r=o[i++];)"+"===r[0]?(r=r.slice(1)||"*",(e[r]=e[r]||[]).unshift(n)):(e[r]=e[r]||[]).push(n)}}function Ft(e,t,n,r){var i={},o=e===Mt;function a(s){var u;return i[s]=!0,b.each(e[s]||[],function(e,s){var l=s(t,n,r);return"string"!=typeof l||o||i[l]?o?!(u=l):void 0:(t.dataTypes.unshift(l),a(l),!1)}),u}return a(t.dataTypes[0])||!i["*"]&&a("*")}function Bt(e,t){var n,r,i=b.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&b.extend(!0,e,r),e}Wt.href=Tt.href,b.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:Tt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(Tt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":It,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":b.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?Bt(Bt(e,b.ajaxSettings),t):Bt(b.ajaxSettings,e)},ajaxPrefilter:$t(Rt),ajaxTransport:$t(Mt),ajax:function(t,n){"object"==typeof t&&(n=t,t=void 0),n=n||{};var i,o,a,s,u,l,c,f,p,d,h=b.ajaxSetup({},n),g=h.context||h,v=h.context&&(g.nodeType||g.jquery)?b(g):b.event,y=b.Deferred(),m=b.Callbacks("once memory"),x=h.statusCode||{},w={},T={},C="canceled",E={readyState:0,getResponseHeader:function(e){var t;if(c){if(!s)for(s={};t=Ht.exec(a);)s[t[1].toLowerCase()+" "]=(s[t[1].toLowerCase()+" "]||[]).concat(t[2]);t=s[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return c?a:null},setRequestHeader:function(e,t){return null==c&&(e=T[e.toLowerCase()]=T[e.toLowerCase()]||e,w[e]=t),this},overrideMimeType:function(e){return null==c&&(h.mimeType=e),this},statusCode:function(e){var t;if(e)if(c)E.always(e[E.status]);else for(t in e)x[t]=[x[t],e[t]];return this},abort:function(e){var t=e||C;return i&&i.abort(t),k(0,t),this}};if(y.promise(E),h.url=((t||h.url||Tt.href)+"").replace(Pt,Tt.protocol+"//"),h.type=n.method||n.type||h.method||h.type,h.dataTypes=(h.dataType||"*").toLowerCase().match(P)||[""],null==h.crossDomain){l=r.createElement("a");try{l.href=h.url,l.href=l.href,h.crossDomain=Wt.protocol+"//"+Wt.host!=l.protocol+"//"+l.host}catch(e){h.crossDomain=!0}}if(h.data&&h.processData&&"string"!=typeof h.data&&(h.data=b.param(h.data,h.traditional)),Ft(Rt,h,n,E),c)return E;for(p in(f=b.event&&h.global)&&0==b.active++&&b.event.trigger("ajaxStart"),h.type=h.type.toUpperCase(),h.hasContent=!Ot.test(h.type),o=h.url.replace(qt,""),h.hasContent?h.data&&h.processData&&0===(h.contentType||"").indexOf("application/x-www-form-urlencoded")&&(h.data=h.data.replace(jt,"+")):(d=h.url.slice(o.length),h.data&&(h.processData||"string"==typeof h.data)&&(o+=(Et.test(o)?"&":"?")+h.data,delete h.data),!1===h.cache&&(o=o.replace(Lt,"$1"),d=(Et.test(o)?"&":"?")+"_="+Ct+++d),h.url=o+d),h.ifModified&&(b.lastModified[o]&&E.setRequestHeader("If-Modified-Since",b.lastModified[o]),b.etag[o]&&E.setRequestHeader("If-None-Match",b.etag[o])),(h.data&&h.hasContent&&!1!==h.contentType||n.contentType)&&E.setRequestHeader("Content-Type",h.contentType),E.setRequestHeader("Accept",h.dataTypes[0]&&h.accepts[h.dataTypes[0]]?h.accepts[h.dataTypes[0]]+("*"!==h.dataTypes[0]?", "+It+"; q=0.01":""):h.accepts["*"]),h.headers)E.setRequestHeader(p,h.headers[p]);if(h.beforeSend&&(!1===h.beforeSend.call(g,E,h)||c))return E.abort();if(C="abort",m.add(h.complete),E.done(h.success),E.fail(h.error),i=Ft(Mt,h,n,E)){if(E.readyState=1,f&&v.trigger("ajaxSend",[E,h]),c)return E;h.async&&h.timeout>0&&(u=e.setTimeout(function(){E.abort("timeout")},h.timeout));try{c=!1,i.send(w,k)}catch(e){if(c)throw e;k(-1,e)}}else k(-1,"No Transport");function k(t,n,r,s){var l,p,d,w,T,C=n;c||(c=!0,u&&e.clearTimeout(u),i=void 0,a=s||"",E.readyState=t>0?4:0,l=t>=200&&t<300||304===t,r&&(w=function(e,t,n){for(var r,i,o,a,s=e.contents,u=e.dataTypes;"*"===u[0];)u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in s)if(s[i]&&s[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}a||(a=i)}o=o||a}if(o)return o!==u[0]&&u.unshift(o),n[o]}(h,E,r)),w=function(e,t,n,r){var i,o,a,s,u,l={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)l[a.toLowerCase()]=e.converters[a];for(o=c.shift();o;)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(!(a=l[u+" "+o]||l["* "+o]))for(i in l)if((s=i.split(" "))[1]===o&&(a=l[u+" "+s[0]]||l["* "+s[0]])){!0===a?a=l[i]:!0!==l[i]&&(o=s[0],c.unshift(s[1]));break}if(!0!==a)if(a&&e.throws)t=a(t);else try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}(h,w,E,l),l?(h.ifModified&&((T=E.getResponseHeader("Last-Modified"))&&(b.lastModified[o]=T),(T=E.getResponseHeader("etag"))&&(b.etag[o]=T)),204===t||"HEAD"===h.type?C="nocontent":304===t?C="notmodified":(C=w.state,p=w.data,l=!(d=w.error))):(d=C,!t&&C||(C="error",t<0&&(t=0))),E.status=t,E.statusText=(n||C)+"",l?y.resolveWith(g,[p,C,E]):y.rejectWith(g,[E,C,d]),E.statusCode(x),x=void 0,f&&v.trigger(l?"ajaxSuccess":"ajaxError",[E,h,l?p:d]),m.fireWith(g,[E,C]),f&&(v.trigger("ajaxComplete",[E,h]),--b.active||b.event.trigger("ajaxStop")))}return E},getJSON:function(e,t,n){return b.get(e,t,n,"json")},getScript:function(e,t){return b.get(e,void 0,t,"script")}}),b.each(["get","post"],function(e,t){b[t]=function(e,n,r,i){return g(n)&&(i=i||r,r=n,n=void 0),b.ajax(b.extend({url:e,type:t,dataType:i,data:n,success:r},b.isPlainObject(e)&&e))}}),b._evalUrl=function(e,t){return b.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){b.globalEval(e,t)}})},b.fn.extend({wrapAll:function(e){var t;return this[0]&&(g(e)&&(e=e.call(this[0])),t=b(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){for(var e=this;e.firstElementChild;)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(e){return g(e)?this.each(function(t){b(this).wrapInner(e.call(this,t))}):this.each(function(){var t=b(this),n=t.contents();n.length?n.wrapAll(e):t.append(e)})},wrap:function(e){var t=g(e);return this.each(function(n){b(this).wrapAll(t?e.call(this,n):e)})},unwrap:function(e){return this.parent(e).not("body").each(function(){b(this).replaceWith(this.childNodes)}),this}}),b.expr.pseudos.hidden=function(e){return!b.expr.pseudos.visible(e)},b.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},b.ajaxSettings.xhr=function(){try{return new e.XMLHttpRequest}catch(e){}};var _t={0:200,1223:204},zt=b.ajaxSettings.xhr();h.cors=!!zt&&"withCredentials"in zt,h.ajax=zt=!!zt,b.ajaxTransport(function(t){var n,r;if(h.cors||zt&&!t.crossDomain)return{send:function(i,o){var a,s=t.xhr();if(s.open(t.type,t.url,t.async,t.username,t.password),t.xhrFields)for(a in t.xhrFields)s[a]=t.xhrFields[a];for(a in t.mimeType&&s.overrideMimeType&&s.overrideMimeType(t.mimeType),t.crossDomain||i["X-Requested-With"]||(i["X-Requested-With"]="XMLHttpRequest"),i)s.setRequestHeader(a,i[a]);n=function(e){return function(){n&&(n=r=s.onload=s.onerror=s.onabort=s.ontimeout=s.onreadystatechange=null,"abort"===e?s.abort():"error"===e?"number"!=typeof s.status?o(0,"error"):o(s.status,s.statusText):o(_t[s.status]||s.status,s.statusText,"text"!==(s.responseType||"text")||"string"!=typeof s.responseText?{binary:s.response}:{text:s.responseText},s.getAllResponseHeaders()))}},s.onload=n(),r=s.onerror=s.ontimeout=n("error"),void 0!==s.onabort?s.onabort=r:s.onreadystatechange=function(){4===s.readyState&&e.setTimeout(function(){n&&r()})},n=n("abort");try{s.send(t.hasContent&&t.data||null)}catch(e){if(n)throw e}},abort:function(){n&&n()}}}),b.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),b.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return b.globalEval(e),e}}}),b.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),b.ajaxTransport("script",function(e){var t,n;if(e.crossDomain||e.scriptAttrs)return{send:function(i,o){t=b("<script>").attr(e.scriptAttrs||{}).prop({charset:e.scriptCharset,src:e.url}).on("load error",n=function(e){t.remove(),n=null,e&&o("error"===e.type?404:200,e.type)}),r.head.appendChild(t[0])},abort:function(){n&&n()}}});var Ut,Xt=[],Vt=/(=)\?(?=&|$)|\?\?/;b.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Xt.pop()||b.expando+"_"+Ct++;return this[e]=!0,e}}),b.ajaxPrefilter("json jsonp",function(t,n,r){var i,o,a,s=!1!==t.jsonp&&(Vt.test(t.url)?"url":"string"==typeof t.data&&0===(t.contentType||"").indexOf("application/x-www-form-urlencoded")&&Vt.test(t.data)&&"data");if(s||"jsonp"===t.dataTypes[0])return i=t.jsonpCallback=g(t.jsonpCallback)?t.jsonpCallback():t.jsonpCallback,s?t[s]=t[s].replace(Vt,"$1"+i):!1!==t.jsonp&&(t.url+=(Et.test(t.url)?"&":"?")+t.jsonp+"="+i),t.converters["script json"]=function(){return a||b.error(i+" was not called"),a[0]},t.dataTypes[0]="json",o=e[i],e[i]=function(){a=arguments},r.always(function(){void 0===o?b(e).removeProp(i):e[i]=o,t[i]&&(t.jsonpCallback=n.jsonpCallback,Xt.push(i)),a&&g(o)&&o(a[0]),a=o=void 0}),"script"}),h.createHTMLDocument=((Ut=r.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===Ut.childNodes.length),b.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(h.createHTMLDocument?((i=(t=r.implementation.createHTMLDocument("")).createElement("base")).href=r.location.href,t.head.appendChild(i)):t=r),a=!n&&[],(o=A.exec(e))?[t.createElement(o[1])]:(o=we([e],t,a),a&&a.length&&b(a).remove(),b.merge([],o.childNodes)));var i,o,a},b.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");return s>-1&&(r=vt(e.slice(s)),e=e.slice(0,s)),g(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),a.length>0&&b.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done(function(e){o=arguments,a.html(r?b("<div>").append(b.parseHTML(e)).find(r):e)}).always(n&&function(e,t){a.each(function(){n.apply(this,o||[e.responseText,t,e])})}),this},b.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){b.fn[t]=function(e){return this.on(t,e)}}),b.expr.pseudos.animated=function(e){return b.grep(b.timers,function(t){return e===t.elem}).length},b.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,l=b.css(e,"position"),c=b(e),f={};"static"===l&&(e.style.position="relative"),s=c.offset(),o=b.css(e,"top"),u=b.css(e,"left"),("absolute"===l||"fixed"===l)&&(o+u).indexOf("auto")>-1?(a=(r=c.position()).top,i=r.left):(a=parseFloat(o)||0,i=parseFloat(u)||0),g(t)&&(t=t.call(e,n,b.extend({},s))),null!=t.top&&(f.top=t.top-s.top+a),null!=t.left&&(f.left=t.left-s.left+i),"using"in t?t.using.call(e,f):c.css(f)}},b.fn.extend({offset:function(e){if(arguments.length)return void 0===e?this:this.each(function(t){b.offset.setOffset(this,e,t)});var t,n,r=this[0];return r?r.getClientRects().length?(t=r.getBoundingClientRect(),n=r.ownerDocument.defaultView,{top:t.top+n.pageYOffset,left:t.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,r=this[0],i={top:0,left:0};if("fixed"===b.css(r,"position"))t=r.getBoundingClientRect();else{for(t=this.offset(),n=r.ownerDocument,e=r.offsetParent||n.documentElement;e&&(e===n.body||e===n.documentElement)&&"static"===b.css(e,"position");)e=e.parentNode;e&&e!==r&&1===e.nodeType&&((i=b(e).offset()).top+=b.css(e,"borderTopWidth",!0),i.left+=b.css(e,"borderLeftWidth",!0))}return{top:t.top-i.top-b.css(r,"marginTop",!0),left:t.left-i.left-b.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){for(var e=this.offsetParent;e&&"static"===b.css(e,"position");)e=e.offsetParent;return e||re})}}),b.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(e,t){var n="pageYOffset"===t;b.fn[e]=function(r){return B(this,function(e,r,i){var o;if(v(e)?o=e:9===e.nodeType&&(o=e.defaultView),void 0===i)return o?o[t]:e[r];o?o.scrollTo(n?o.pageXOffset:i,n?i:o.pageYOffset):e[r]=i},e,r,arguments.length)}}),b.each(["top","left"],function(e,t){b.cssHooks[t]=ze(h.pixelPosition,function(e,n){if(n)return n=_e(e,t),$e.test(n)?b(e).position()[t]+"px":n})}),b.each({Height:"height",Width:"width"},function(e,t){b.each({padding:"inner"+e,content:t,"":"outer"+e},function(n,r){b.fn[r]=function(i,o){var a=arguments.length&&(n||"boolean"!=typeof i),s=n||(!0===i||!0===o?"margin":"border");return B(this,function(t,n,i){var o;return v(t)?0===r.indexOf("outer")?t["inner"+e]:t.document.documentElement["client"+e]:9===t.nodeType?(o=t.documentElement,Math.max(t.body["scroll"+e],o["scroll"+e],t.body["offset"+e],o["offset"+e],o["client"+e])):void 0===i?b.css(t,n,s):b.style(t,n,i,s)},t,a?i:void 0,a)}})}),b.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,t){b.fn[t]=function(e,n){return arguments.length>0?this.on(t,null,e,n):this.trigger(t)}}),b.fn.extend({hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),b.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)}}),b.proxy=function(e,t){var n,r,i;if("string"==typeof t&&(n=e[t],t=e,e=n),g(e))return r=o.call(arguments,2),(i=function(){return e.apply(t||this,r.concat(o.call(arguments)))}).guid=e.guid=e.guid||b.guid++,i},b.holdReady=function(e){e?b.readyWait++:b.ready(!0)},b.isArray=Array.isArray,b.parseJSON=JSON.parse,b.nodeName=N,b.isFunction=g,b.isWindow=v,b.camelCase=X,b.type=x,b.now=Date.now,b.isNumeric=function(e){var t=b.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},"function"==typeof define&&define.amd&&define("jquery",[],function(){return b});var Gt=e.jQuery,Yt=e.$;return b.noConflict=function(t){return e.$===b&&(e.$=Yt),t&&e.jQuery===b&&(e.jQuery=Gt),b},t||(e.jQuery=e.$=b),b})},
521: function _(t,i,n){function o(){var t=!1,i=!1;this.stopPropagation=function(){t=!0},this.isPropagationStopped=function(){return t},this.stopImmediatePropagation=function(){i=!0},this.isImmediatePropagationStopped=function(){return i}}function e(){this.__nonDataRow=!0}function r(){this.__group=!0,this.level=0,this.count=0,this.value=null,this.title=null,this.collapsed=!1,this.selectChecked=!1,this.totals=null,this.rows=[],this.groups=null,this.groupingKey=null}function s(){this.__groupTotals=!0,this.group=null,this.initialized=!1}function l(){var t=null;this.isActive=function(i){return i?t===i:null!==t},this.activate=function(i){if(i!==t){if(null!==t)throw new Error("SlickGrid.EditorLock.activate: an editController is still active, can't activate another editController");if(!i.commitCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .commitCurrentEdit()");if(!i.cancelCurrentEdit)throw new Error("SlickGrid.EditorLock.activate: editController must implement .cancelCurrentEdit()");t=i}},this.deactivate=function(i){if(t!==i)throw new Error("SlickGrid.EditorLock.deactivate: specified editController is not the currently active one");t=null},this.commitCurrentEdit=function(){return!t||t.commitCurrentEdit()},this.cancelCurrentEdit=function(){return!t||t.cancelCurrentEdit()}}r.prototype=new e,r.prototype.equals=function(t){return this.value===t.value&&this.count===t.count&&this.collapsed===t.collapsed&&this.title===t.title},s.prototype=new e,i.exports={Event:function(){var t=[];this.subscribe=function(i){t.push(i)},this.unsubscribe=function(i){for(var n=t.length-1;n>=0;n--)t[n]===i&&t.splice(n,1)},this.notify=function(i,n,e){var r;n=n||new o,e=e||this;for(var s=0;s<t.length&&!n.isPropagationStopped()&&!n.isImmediatePropagationStopped();s++)r=t[s].call(e,n,i);return r}},EventData:o,EventHandler:function(){var t=[];this.subscribe=function(i,n){return t.push({event:i,handler:n}),i.subscribe(n),this},this.unsubscribe=function(i,n){for(var o=t.length;o--;)if(t[o].event===i&&t[o].handler===n)return t.splice(o,1),void i.unsubscribe(n);return this},this.unsubscribeAll=function(){for(var i=t.length;i--;)t[i].event.unsubscribe(t[i].handler);return t=[],this}},Range:function(t,i,n,o){void 0===n&&void 0===o&&(n=t,o=i),this.fromRow=Math.min(t,n),this.fromCell=Math.min(i,o),this.toRow=Math.max(t,n),this.toCell=Math.max(i,o),this.isSingleRow=function(){return this.fromRow==this.toRow},this.isSingleCell=function(){return this.fromRow==this.toRow&&this.fromCell==this.toCell},this.contains=function(t,i){return t>=this.fromRow&&t<=this.toRow&&i>=this.fromCell&&i<=this.toCell},this.toString=function(){return this.isSingleCell()?"("+this.fromRow+":"+this.fromCell+")":"("+this.fromRow+":"+this.fromCell+" - "+this.toRow+":"+this.toCell+")"}},NonDataRow:e,Group:r,GroupTotals:s,EditorLock:l,GlobalEditorLock:new l,keyCode:{BACKSPACE:8,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,ESC:27,HOME:36,INSERT:45,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,RIGHT:39,TAB:9,UP:38,C:67,V:86},preClickClassName:"slick-edit-preclick"}},
522: function _(e,t,o){var l=e(519),c=e(521);t.exports={CheckboxSelectColumn:function(e){var t,o=g(),n=new c.EventHandler,i={},r=!1,d=l.extend(!0,{},{columnId:"_checkbox_selector",cssClass:null,hideSelectAllCheckbox:!1,toolTip:"Select/Deselect All",width:30,hideInColumnTitleRow:!1,hideInFilterHeaderRow:!0},e);function a(){t.updateColumnHeader(d.columnId,"","")}function s(){l("#filter-checkbox-selectall-container").hide()}function u(e,c){var n,a,s=t.getSelectedRows(),u={};for(a=0;a<s.length;a++)u[n=s[a]]=!0,u[n]!==i[n]&&(t.invalidateRow(n),delete i[n]);for(a in i)t.invalidateRow(a);i=u,t.render(),r=s.length&&s.length==t.getDataLength(),d.hideInColumnTitleRow||d.hideSelectAllCheckbox||(r?t.updateColumnHeader(d.columnId,"<input id='header-selector"+o+"' type='checkbox' checked='checked'><label for='header-selector"+o+"'></label>",d.toolTip):t.updateColumnHeader(d.columnId,"<input id='header-selector"+o+"' type='checkbox'><label for='header-selector"+o+"'></label>",d.toolTip)),d.hideInFilterHeaderRow||l("#header-filter-selector"+o).prop("checked",r)}function h(e,o){32==e.which&&t.getColumns()[o.cell].id===d.columnId&&(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit()||p(o.row),e.preventDefault(),e.stopImmediatePropagation())}function f(e,o){if(t.getColumns()[o.cell].id===d.columnId&&l(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();p(o.row),e.stopPropagation(),e.stopImmediatePropagation()}}function p(e){i[e]?t.setSelectedRows(l.grep(t.getSelectedRows(),function(t){return t!=e})):t.setSelectedRows(t.getSelectedRows().concat(e)),t.setActiveCell(e,function(){if(null===m){m=0;for(var e=t.getColumns(),o=0;o<e.length;o++)e[o].id==d.columnId&&(m=o)}return m}()),t.focus()}function b(e,o){if(o.column.id==d.columnId&&l(e.target).is(":checkbox")){if(t.getEditorLock().isActive()&&!t.getEditorLock().commitCurrentEdit())return e.preventDefault(),void e.stopImmediatePropagation();if(l(e.target).is(":checked")){for(var c=[],n=0;n<t.getDataLength();n++)c.push(n);t.setSelectedRows(c)}else t.setSelectedRows([]);e.stopPropagation(),e.stopImmediatePropagation()}}var m=null;function g(){return Math.round(1e7*Math.random())}function k(e,t,o,l,c){var n=g()+e;return c?i[e]?"<input id='selector"+n+"' type='checkbox' checked='checked'><label for='selector"+n+"'></label>":"<input id='selector"+n+"' type='checkbox'><label for='selector"+n+"'></label>":null}l.extend(this,{init:function(e){t=e,n.subscribe(t.onSelectedRowsChanged,u).subscribe(t.onClick,f).subscribe(t.onKeyDown,h),d.hideInFilterHeaderRow||function(e){e.onHeaderRowCellRendered.subscribe(function(e,t){"sel"===t.column.field&&(l(t.node).empty(),l("<span id='filter-checkbox-selectall-container'><input id='header-filter-selector"+o+"' type='checkbox'><label for='header-filter-selector"+o+"'></label></span>").appendTo(t.node).on("click",function(e){b(e,t)}))})}(e),d.hideInColumnTitleRow||n.subscribe(t.onHeaderClick,b)},destroy:function(){n.unsubscribeAll()},deSelectRows:function(e){var o,c=e.length,n=[];for(o=0;o<c;o++)i[e[o]]&&(n[n.length]=e[o]);t.setSelectedRows(l.grep(t.getSelectedRows(),function(e){return n.indexOf(e)<0}))},selectRows:function(e){var o,l=e.length,c=[];for(o=0;o<l;o++)i[e[o]]||(c[c.length]=e[o]);t.setSelectedRows(t.getSelectedRows().concat(c))},getColumnDefinition:function(){return{id:d.columnId,name:d.hideSelectAllCheckbox||d.hideInColumnTitleRow?"":"<input id='header-selector"+o+"' type='checkbox'><label for='header-selector"+o+"'></label>",toolTip:d.toolTip,field:"sel",width:d.width,resizable:!1,sortable:!1,cssClass:d.cssClass,hideSelectAllCheckbox:d.hideSelectAllCheckbox,formatter:k}},getOptions:function(){return d},setOptions:function(e){if((d=l.extend(!0,{},d,e)).hideSelectAllCheckbox)a(),s();else if(d.hideInColumnTitleRow?a():(r?t.updateColumnHeader(d.columnId,"<input id='header-selector"+o+"' type='checkbox' checked='checked'><label for='header-selector"+o+"'></label>",d.toolTip):t.updateColumnHeader(d.columnId,"<input id='header-selector"+o+"' type='checkbox'><label for='header-selector"+o+"'></label>",d.toolTip),n.subscribe(t.onHeaderClick,b)),d.hideInFilterHeaderRow)s();else{var c=l("#filter-checkbox-selectall-container");c.show(),c.find('input[type="checkbox"]').prop("checked",r)}}})}}},
523: function _(e,t,o){var l=e(519),n=e(521),a=n.keyCode;t.exports={CellExternalCopyManager:function(e){var t,o,r=this,i=e||{},s=i.copiedCellStyleLayerKey||"copy-manager",u=i.copiedCellStyle||"copied",c=0,d=i.bodyElement||document.body,f=i.onCopyInit||null,h=i.onCopySuccess||null;function C(e){if(i.headerColumnValueExtractor){var t=i.headerColumnValueExtractor(e);if(t)return t}return e.name}function m(e,o,n){if(i.dataItemColumnValueExtractor){var a=i.dataItemColumnValueExtractor(e,o);if(a)return a}var r="";if(o.editor){var s={container:l("<p>"),column:o,position:{top:0,left:0},grid:t,event:n},u=new o.editor(s);u.loadValue(e),r=u.serializeValue(),u.destroy()}else r=e[o.field];return r}function g(e,o,n){if(i.dataItemColumnValueSetter)return i.dataItemColumnValueSetter(e,o,n);if(o.editor){var a={container:l("body"),column:o,position:{top:0,left:0},grid:t},r=new o.editor(a);r.loadValue(e),r.applyValue(e,n),r.destroy()}else e[o.field]=n}function p(e){var t=document.createElement("textarea");return t.style.position="absolute",t.style.left="-1000px",t.style.top=document.body.scrollTop+"px",t.value=e,d.appendChild(t),t.select(),t}function y(e,l){var n;if(!t.getEditorLock().isActive()||t.getOptions().autoEdit){if(e.which==a.ESC&&o&&(e.preventDefault(),w(),r.onCopyCancelled.notify({ranges:o}),o=null),(e.which===a.C||e.which===a.INSERT)&&(e.ctrlKey||e.metaKey)&&!e.shiftKey&&(f&&f.call(),0!=(n=t.getSelectionModel().getSelectedRanges()).length)){o=n,v(n),r.onCopyCells.notify({ranges:n});for(var s=t.getColumns(),u="",c=0;c<n.length;c++){for(var y=n[c],D=[],S=y.fromRow;S<y.toRow+1;S++){var R=[],x=t.getDataItem(S);if(""==D&&i.includeHeaderWhenCopying){for(var V=[],E=y.fromCell;E<y.toCell+1;E++)s[E].name.length>0&&V.push(C(s[E]));D.push(V.join("\t"))}for(E=y.fromCell;E<y.toCell+1;E++)R.push(m(x,s[E],e));D.push(R.join("\t"))}u+=D.join("\r\n")+"\r\n"}if(window.clipboardData)return window.clipboardData.setData("Text",u),!0;var b=document.activeElement;if((M=p(u)).focus(),setTimeout(function(){d.removeChild(M),b?b.focus():console.log("Not element to restore focus to after copy?")},100),h){var I=0;I=1===n.length?n[0].toRow+1-n[0].fromRow:n.length,h.call(this,I)}return!1}if(!i.readOnlyMode&&(e.which===a.V&&(e.ctrlKey||e.metaKey)&&!e.shiftKey||e.which===a.INSERT&&e.shiftKey&&!e.ctrlKey)){var M=p("");return setTimeout(function(){!function(e,t){var o=e.getColumns(),l=t.value.split(/[\n\f\r]/);""==l[l.length-1]&&l.pop();var n=[],a=0;d.removeChild(t);for(var s=0;s<l.length;s++)""!=l[s]?n[a++]=l[s].split("\t"):n[s]=[""];var u=e.getActiveCell(),c=e.getSelectionModel().getSelectedRanges(),f=c&&c.length?c[0]:null,h=null,C=null;if(f)h=f.fromRow,C=f.fromCell;else{if(!u)return;h=u.row,C=u.cell}var m=!1,p=n.length,y=n.length?n[0].length:0;1==n.length&&1==n[0].length&&f&&(m=!0,p=f.toRow-f.fromRow+1,y=f.toCell-f.fromCell+1);var w=e.getData().length-h,D=0;if(w<p&&i.newRowCreator){var S=e.getData();for(D=1;D<=p-w;D++)S.push({});e.setData(S),e.render()}var R=h+p>e.getDataLength();if(i.newRowCreator&&R){var x=h+p-e.getDataLength();i.newRowCreator(x)}var V={isClipboardCommand:!0,clippedRange:n,oldValues:[],cellExternalCopyManager:r,_options:i,setDataItemValueForColumn:g,markCopySelection:v,oneCellToMultiple:m,activeRow:h,activeCell:C,destH:p,destW:y,maxDestY:e.getDataLength(),maxDestX:e.getColumns().length,h:0,w:0,execute:function(){this.h=0;for(var t=0;t<this.destH;t++){this.oldValues[t]=[],this.w=0,this.h++;for(var l=0;l<this.destW;l++){this.w++;var a=h+t,r=C+l;if(a<this.maxDestY&&r<this.maxDestX){e.getCellNode(a,r);var i=e.getDataItem(a);this.oldValues[t][l]=i[o[r].field],m?this.setDataItemValueForColumn(i,o[r],n[0][0]):this.setDataItemValueForColumn(i,o[r],n[t]?n[t][l]:""),e.updateCell(a,r),e.onCellChange.notify({row:a,cell:r,item:i,grid:e})}}}var s={fromCell:C,fromRow:h,toCell:C+this.w-1,toRow:h+this.h-1};this.markCopySelection([s]),e.getSelectionModel().setSelectedRanges([s]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[s]})},undo:function(){for(var t=0;t<this.destH;t++)for(var l=0;l<this.destW;l++){var n=h+t,a=C+l;if(n<this.maxDestY&&a<this.maxDestX){e.getCellNode(n,a);var r=e.getDataItem(n);m?this.setDataItemValueForColumn(r,o[a],this.oldValues[0][0]):this.setDataItemValueForColumn(r,o[a],this.oldValues[t][l]),e.updateCell(n,a),e.onCellChange.notify({row:n,cell:a,item:r,grid:e})}}var i={fromCell:C,fromRow:h,toCell:C+this.w-1,toRow:h+this.h-1};if(this.markCopySelection([i]),e.getSelectionModel().setSelectedRanges([i]),this.cellExternalCopyManager.onPasteCells.notify({ranges:[i]}),D>1){for(var s=e.getData();D>1;D--)s.splice(s.length-1,1);e.setData(s),e.render()}}};i.clipboardCommandHandler?i.clipboardCommandHandler(V):V.execute()}(t,M)},100),!1}}}function v(e){w();for(var o=t.getColumns(),l={},n=0;n<e.length;n++)for(var a=e[n].fromRow;a<=e[n].toRow;a++){l[a]={};for(var i=e[n].fromCell;i<=e[n].toCell&&i<o.length;i++)l[a][o[i].id]=u}t.setCellCssStyles(s,l),clearTimeout(c),c=setTimeout(function(){r.clearCopySelection()},2e3)}function w(){t.removeCellCssStyles(s)}l.extend(this,{init:function(e){(t=e).onKeyDown.subscribe(y);var o=e.getSelectionModel();if(!o)throw new Error("Selection model is mandatory for this plugin. Please set a selection model on the grid before adding this plugin: grid.setSelectionModel(new Slick.CellSelectionModel())");o.onSelectedRangesChanged.subscribe(function(e,o){t.focus()})},destroy:function(){t.onKeyDown.unsubscribe(y)},clearCopySelection:w,handleKeyDown:y,onCopyCells:new n.Event,onCopyCancelled:new n.Event,onPasteCells:new n.Event,setIncludeHeaderWhenCopying:function(e){i.includeHeaderWhenCopying=e}})}}},
524: function _(r,t,o){var _=r(113);_.__exportStar(r(521),t.exports),_.__exportStar(r(525),t.exports),_.__exportStar(r(528),t.exports),_.__exportStar(r(529),t.exports),_.__exportStar(r(530),t.exports),_.__exportStar(r(531),t.exports),_.__exportStar(r(532),t.exports)},
525: function _(require,module,exports){
/**
     * @license
     * (c) 2009-2016 Michael Leibman
     * michael{dot}leibman{at}gmail{dot}com
     * http://github.com/mleibman/slickgrid
     *
     * Distributed under MIT license.
     * All rights reserved.
     *
     * SlickGrid v2.3
     *
     * NOTES:
     *     Cell/row DOM manipulations are done directly bypassing jQuery's DOM manipulation methods.
     *     This increases the speed dramatically, but can only be done safely because there are no event handlers
     *     or data associated with any cell/row DOM nodes.  Cell editors must make sure they implement .destroy()
     *     and do proper cleanup.
     */
var $=require(519),Slick=require(521),scrollbarDimensions,maxSupportedCssHeight;function SlickGrid(container,data,columns,options){$.fn.drag||require(526),$.fn.drop||require(527);var defaults={alwaysShowVerticalScroll:!1,explicitInitialization:!1,rowHeight:25,defaultColumnWidth:80,enableAddRow:!1,leaveSpaceForNewRows:!1,editable:!1,autoEdit:!0,suppressActiveCellChangeOnEdit:!1,enableCellNavigation:!0,enableColumnReorder:!0,asyncEditorLoading:!1,asyncEditorLoadDelay:100,forceFitColumns:!1,enableAsyncPostRender:!1,asyncPostRenderDelay:50,enableAsyncPostRenderCleanup:!1,asyncPostRenderCleanupDelay:40,autoHeight:!1,editorLock:Slick.GlobalEditorLock,showHeaderRow:!1,headerRowHeight:25,createFooterRow:!1,showFooterRow:!1,footerRowHeight:25,createPreHeaderPanel:!1,showPreHeaderPanel:!1,preHeaderPanelHeight:25,showTopPanel:!1,topPanelHeight:25,formatterFactory:null,editorFactory:null,cellFlashingCssClass:"flashing",selectedCellCssClass:"selected",multiSelect:!0,enableTextSelectionOnCells:!1,dataItemColumnValueExtractor:null,fullWidthRows:!1,multiColumnSort:!1,numberedMultiColumnSort:!1,tristateMultiColumnSort:!1,sortColNumberInSeparateSpan:!1,defaultFormatter:defaultFormatter,forceSyncScrolling:!1,addNewRowCssClass:"new-row",preserveCopiedSelectionOnPaste:!1,showCellSelection:!0,viewportClass:null,minRowBuffer:3,emulatePagingWhenScrolling:!0,editorCellNavOnLRKeys:!1},columnDefaults={name:"",resizable:!0,sortable:!1,minWidth:30,rerenderOnResize:!1,headerCssClass:null,defaultSortAsc:!0,focusable:!0,selectable:!0},th,h,ph,n,cj,page=0,offset=0,vScrollDir=1,initialized=!1,$container,uid="slickgrid_"+Math.round(1e6*Math.random()),self=this,$focusSink,$focusSink2,$headerScroller,$headers,$headerRow,$headerRowScroller,$headerRowSpacer,$footerRow,$footerRowScroller,$footerRowSpacer,$preHeaderPanel,$preHeaderPanelScroller,$preHeaderPanelSpacer,$topPanelScroller,$topPanel,$viewport,$canvas,$style,$boundAncestors,stylesheet,columnCssRulesL,columnCssRulesR,viewportH,viewportW,canvasWidth,viewportHasHScroll,viewportHasVScroll,headerColumnWidthDiff=0,headerColumnHeightDiff=0,cellWidthDiff=0,cellHeightDiff=0,jQueryNewWidthBehaviour=!1,absoluteColumnMinWidth,tabbingDirection=1,activePosX,activeRow,activeCell,activeCellNode=null,currentEditor=null,serializedEditorValue,editController,rowsCache={},renderedRows=0,numVisibleRows,prevScrollTop=0,scrollTop=0,lastRenderedScrollTop=0,lastRenderedScrollLeft=0,prevScrollLeft=0,scrollLeft=0,selectionModel,selectedRows=[],plugins=[],cellCssClasses={},columnsById={},sortColumns=[],columnPosLeft=[],columnPosRight=[],pagingActive=!1,pagingIsLastPage=!1,scrollThrottle=ActionThrottle(render,50),h_editorLoader=null,h_render=null,h_postrender=null,h_postrenderCleanup=null,postProcessedRows={},postProcessToRow=null,postProcessFromRow=null,postProcessedCleanupQueue=[],postProcessgroupId=0,counter_rows_rendered=0,counter_rows_removed=0,rowNodeFromLastMouseWheelEvent,zombieRowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent,cssShow={position:"absolute",visibility:"hidden",display:"block"},$hiddenParents,oldProps=[],columnResizeDragging=!1;function init(){if(($container=container instanceof $?container:$(container)).length<1)throw new Error("SlickGrid requires a valid container, "+container+" does not exist in the DOM.");cacheCssForHiddenInit(),maxSupportedCssHeight=maxSupportedCssHeight||getMaxSupportedCssHeight(),options=$.extend({},defaults,options),validateAndEnforceOptions(),columnDefaults.width=options.defaultColumnWidth,columnsById={};for(var e=0;e<columns.length;e++){var o=columns[e]=$.extend({},columnDefaults,columns[e]);columnsById[o.id]=e,o.minWidth&&o.width<o.minWidth&&(o.width=o.minWidth),o.maxWidth&&o.width>o.maxWidth&&(o.width=o.maxWidth)}if(options.enableColumnReorder&&!$.fn.sortable)throw new Error("SlickGrid's 'enableColumnReorder = true' option requires jquery-ui.sortable module to be loaded");editController={commitCurrentEdit:commitCurrentEdit,cancelCurrentEdit:cancelCurrentEdit},$container.empty().css("overflow","hidden").css("outline",0).addClass(uid).addClass("ui-widget"),/relative|absolute|fixed/.test($container.css("position"))||$container.css("position","relative"),$focusSink=$("<div tabIndex='0' hideFocus style='position:fixed;width:0;height:0;top:0;left:0;outline:0;'></div>").appendTo($container),options.createPreHeaderPanel&&($preHeaderPanelScroller=$("<div class='slick-preheader-panel ui-state-default' style='overflow:hidden;position:relative;' />").appendTo($container),$preHeaderPanel=$("<div />").appendTo($preHeaderPanelScroller),$preHeaderPanelSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($preHeaderPanelScroller),options.showPreHeaderPanel||$preHeaderPanelScroller.hide()),$headerScroller=$("<div class='slick-header ui-state-default' />").appendTo($container),$headers=$("<div class='slick-header-columns' style='left:-1000px' />").appendTo($headerScroller),$headerRowScroller=$("<div class='slick-headerrow ui-state-default' />").appendTo($container),$headerRow=$("<div class='slick-headerrow-columns' />").appendTo($headerRowScroller),$headerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").appendTo($headerRowScroller),$topPanelScroller=$("<div class='slick-top-panel-scroller ui-state-default' />").appendTo($container),$topPanel=$("<div class='slick-top-panel' style='width:10000px' />").appendTo($topPanelScroller),options.showTopPanel||$topPanelScroller.hide(),options.showHeaderRow||$headerRowScroller.hide(),($viewport=$("<div class='slick-viewport' style='width:100%;overflow:auto;outline:0;position:relative;;'>").appendTo($container)).css("overflow-y",options.alwaysShowVerticalScroll?"scroll":options.autoHeight?"hidden":"auto"),$viewport.css("overflow-x",options.forceFitColumns?"hidden":"auto"),options.viewportClass&&$viewport.toggleClass(options.viewportClass,!0),$canvas=$("<div class='grid-canvas' />").appendTo($viewport),scrollbarDimensions=scrollbarDimensions||measureScrollbar(),$preHeaderPanelSpacer&&$preHeaderPanelSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),$headers.width(getHeadersWidth()),$headerRowSpacer.css("width",getCanvasWidth()+scrollbarDimensions.width+"px"),options.createFooterRow&&($footerRowScroller=$("<div class='slick-footerrow ui-state-default' />").appendTo($container),$footerRow=$("<div class='slick-footerrow-columns' />").appendTo($footerRowScroller),$footerRowSpacer=$("<div style='display:block;height:1px;position:absolute;top:0;left:0;'></div>").css("width",getCanvasWidth()+scrollbarDimensions.width+"px").appendTo($footerRowScroller),options.showFooterRow||$footerRowScroller.hide()),$focusSink2=$focusSink.clone().appendTo($container),options.explicitInitialization||finishInitialization()}function finishInitialization(){initialized||(initialized=!0,viewportW=parseFloat($.css($container[0],"width",!0)),measureCellPaddingAndBorder(),disableSelection($headers),options.enableTextSelectionOnCells||$viewport.on("selectstart.ui",function(e){return $(e.target).is("input,textarea")}),updateColumnCaches(),createColumnHeaders(),setupColumnSort(),createCssRules(),resizeCanvas(),bindAncestorScrollEvents(),$container.on("resize.slickgrid",resizeCanvas),$viewport.on("scroll",handleScroll),$headerScroller.on("contextmenu",handleHeaderContextMenu).on("click",handleHeaderClick).on("mouseenter",".slick-header-column",handleHeaderMouseEnter).on("mouseleave",".slick-header-column",handleHeaderMouseLeave),$headerRowScroller.on("scroll",handleHeaderRowScroll),options.createFooterRow&&$footerRowScroller.on("scroll",handleFooterRowScroll),options.createPreHeaderPanel&&$preHeaderPanelScroller.on("scroll",handlePreHeaderPanelScroll),$focusSink.add($focusSink2).on("keydown",handleKeyDown),$canvas.on("keydown",handleKeyDown).on("click",handleClick).on("dblclick",handleDblClick).on("contextmenu",handleContextMenu).on("draginit",handleDragInit).on("dragstart",{distance:3},handleDragStart).on("drag",handleDrag).on("dragend",handleDragEnd).on("mouseenter",".slick-cell",handleMouseEnter).on("mouseleave",".slick-cell",handleMouseLeave),navigator.userAgent.toLowerCase().match(/webkit/)&&navigator.userAgent.toLowerCase().match(/macintosh/)&&$canvas.on("mousewheel",handleMouseWheel),restoreCssFromHiddenInit())}function cacheCssForHiddenInit(){($hiddenParents=$container.parents().addBack().not(":visible")).each(function(){var e={};for(var o in cssShow)e[o]=this.style[o],this.style[o]=cssShow[o];oldProps.push(e)})}function restoreCssFromHiddenInit(){$hiddenParents.each(function(e){var o=oldProps[e];for(var t in cssShow)this.style[t]=o[t]})}function registerPlugin(e){plugins.unshift(e),e.init(self)}function unregisterPlugin(e){for(var o=plugins.length;o>=0;o--)if(plugins[o]===e){plugins[o].destroy&&plugins[o].destroy(),plugins.splice(o,1);break}}function setSelectionModel(e){selectionModel&&(selectionModel.onSelectedRangesChanged.unsubscribe(handleSelectedRangesChanged),selectionModel.destroy&&selectionModel.destroy()),(selectionModel=e)&&(selectionModel.init(self),selectionModel.onSelectedRangesChanged.subscribe(handleSelectedRangesChanged))}function getSelectionModel(){return selectionModel}function getCanvasNode(){return $canvas[0]}function measureScrollbar(){var e=$('<div class="'+$viewport.className+'" style="position:absolute; top:-10000px; left:-10000px; overflow:auto; width:100px; height:100px;"></div>').appendTo($viewport),o=$('<div style="width:200px; height:200px; overflow:auto;"></div>').appendTo(e),t={width:e[0].offsetWidth-e[0].clientWidth,height:e[0].offsetHeight-e[0].clientHeight};return o.remove(),e.remove(),t}function getColumnTotalWidth(e){for(var o=0,t=0,l=columns.length;t<l;t++){o+=columns[t].width}return e&&(o+=scrollbarDimensions.width),o}function getHeadersWidth(){var e=getColumnTotalWidth(!options.autoHeight);return Math.max(e,viewportW)+1e3}function getCanvasWidth(){for(var e=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW,o=0,t=columns.length;t--;)o+=columns[t].width;return options.fullWidthRows?Math.max(o,e):o}function updateCanvasWidth(e){var o=canvasWidth;(canvasWidth=getCanvasWidth())!=o&&($canvas.width(canvasWidth),$headerRow.width(canvasWidth),options.createFooterRow&&$footerRow.width(canvasWidth),options.createPreHeaderPanel&&$preHeaderPanel.width(canvasWidth),$headers.width(getHeadersWidth()),viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width);var t=canvasWidth+(viewportHasVScroll?scrollbarDimensions.width:0);$headerRowSpacer.width(t),options.createFooterRow&&$footerRowSpacer.width(t),options.createPreHeaderPanel&&$preHeaderPanelSpacer.width(t),(canvasWidth!=o||e)&&applyColumnWidths()}function disableSelection(e){e&&e.jquery&&e.attr("unselectable","on").css("MozUserSelect","none").on("selectstart.ui",function(){return!1})}function getMaxSupportedCssHeight(){for(var e=1e6,o=navigator.userAgent.toLowerCase().match(/firefox/)?6e6:1e9,t=$("<div style='display:none' />").appendTo(document.body);;){var l=2*e;if(t.css("height",l),l>o||t.height()!==l)break;e=l}return t.remove(),e}function getUID(){return uid}function getHeaderColumnWidthDiff(){return headerColumnWidthDiff}function getScrollbarDimensions(){return scrollbarDimensions}function bindAncestorScrollEvents(){for(var e=$canvas[0];(e=e.parentNode)!=document.body&&null!=e;)if(e==$viewport[0]||e.scrollWidth!=e.clientWidth||e.scrollHeight!=e.clientHeight){var o=$(e);$boundAncestors=$boundAncestors?$boundAncestors.add(o):o,o.on("scroll."+uid,handleActiveCellPositionChange)}}function unbindAncestorScrollEvents(){$boundAncestors&&($boundAncestors.off("scroll."+uid),$boundAncestors=null)}function updateColumnHeader(e,o,t){if(initialized){var l=getColumnIndex(e);if(null!=l){var n=columns[l],r=$headers.children().eq(l);r&&(void 0!==o&&(columns[l].name=o),void 0!==t&&(columns[l].toolTip=t),trigger(self.onBeforeHeaderCellDestroy,{node:r[0],column:n,grid:self}),r.attr("title",t||"").children().eq(0).html(o),trigger(self.onHeaderCellRendered,{node:r[0],column:n,grid:self}))}}}function getHeader(){return $headers[0]}function getHeaderColumn(e){var o="number"==typeof e?e:getColumnIndex(e),t=$headers.children().eq(o);return t&&t[0]}function getHeaderRow(){return $headerRow[0]}function getFooterRow(){return $footerRow[0]}function getPreHeaderPanel(){return $preHeaderPanel[0]}function getHeaderRowColumn(e){var o="number"==typeof e?e:getColumnIndex(e),t=$headerRow.children().eq(o);return t&&t[0]}function getFooterRowColumn(e){var o="number"==typeof e?e:getColumnIndex(e),t=$footerRow.children().eq(o);return t&&t[0]}function createColumnHeaders(){function e(){$(this).addClass("ui-state-hover")}function o(){$(this).removeClass("ui-state-hover")}$headers.find(".slick-header-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderCellDestroy,{node:this,column:e,grid:self})}),$headers.empty(),$headers.width(getHeadersWidth()),$headerRow.find(".slick-headerrow-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeHeaderRowCellDestroy,{node:this,column:e,grid:self})}),$headerRow.empty(),options.createFooterRow&&($footerRow.find(".slick-footerrow-column").each(function(){var e=$(this).data("column");e&&trigger(self.onBeforeFooterRowCellDestroy,{node:this,column:e})}),$footerRow.empty());for(var t=0;t<columns.length;t++){var l=columns[t],n=$("<div class='ui-state-default slick-header-column' />").html("<span class='slick-column-name'>"+l.name+"</span>").width(l.width-headerColumnWidthDiff).attr("id",""+uid+l.id).attr("title",l.toolTip||"").data("column",l).addClass(l.headerCssClass||"").appendTo($headers);if((options.enableColumnReorder||l.sortable)&&n.on("mouseenter",e).on("mouseleave",o),l.sortable&&(n.addClass("slick-header-sortable"),n.append("<span class='slick-sort-indicator"+(options.numberedMultiColumnSort&&!options.sortColNumberInSeparateSpan?" slick-sort-indicator-numbered":"")+"' />"),options.numberedMultiColumnSort&&options.sortColNumberInSeparateSpan&&n.append("<span class='slick-sort-indicator-numbered' />")),trigger(self.onHeaderCellRendered,{node:n[0],column:l,grid:self}),options.showHeaderRow){var r=$("<div class='ui-state-default slick-headerrow-column l"+t+" r"+t+"'></div>").data("column",l).appendTo($headerRow);trigger(self.onHeaderRowCellRendered,{node:r[0],column:l,grid:self})}if(options.createFooterRow&&options.showFooterRow){var i=$("<div class='ui-state-default slick-footerrow-column l"+t+" r"+t+"'></div>").data("column",l).appendTo($footerRow);trigger(self.onFooterRowCellRendered,{node:i[0],column:l})}}setSortColumns(sortColumns),setupColumnResize(),options.enableColumnReorder&&("function"==typeof options.enableColumnReorder?options.enableColumnReorder(self,$headers,headerColumnWidthDiff,setColumns,setupColumnResize,columns,getColumnIndex,uid,trigger):setupColumnReorder())}function setupColumnSort(){$headers.click(function(e){if(!columnResizeDragging&&(e.metaKey=e.metaKey||e.ctrlKey,!$(e.target).hasClass("slick-resizable-handle"))){var o=$(e.target).closest(".slick-header-column");if(o.length){var t=o.data("column");if(t.sortable){if(!getEditorLock().commitCurrentEdit())return;for(var l=null,n=0;n<sortColumns.length;n++)if(sortColumns[n].columnId==t.id){(l=sortColumns[n]).sortAsc=!l.sortAsc;break}var r=!!l;options.tristateMultiColumnSort?(l||(l={columnId:t.id,sortAsc:t.defaultSortAsc}),r&&l.sortAsc&&(sortColumns.splice(n,1),l=null),options.multiColumnSort||(sortColumns=[]),!l||r&&options.multiColumnSort||sortColumns.push(l)):e.metaKey&&options.multiColumnSort?l&&sortColumns.splice(n,1):((e.shiftKey||e.metaKey)&&options.multiColumnSort||(sortColumns=[]),l?0==sortColumns.length&&sortColumns.push(l):(l={columnId:t.id,sortAsc:t.defaultSortAsc},sortColumns.push(l))),setSortColumns(sortColumns),options.multiColumnSort?trigger(self.onSort,{multiColumnSort:!0,sortCols:$.map(sortColumns,function(e){return{sortCol:columns[getColumnIndex(e.columnId)],sortAsc:e.sortAsc}})},e):trigger(self.onSort,{multiColumnSort:!1,sortCol:sortColumns.length>0?t:null,sortAsc:!(sortColumns.length>0)||sortColumns[0].sortAsc},e)}}}})}function setupColumnReorder(){$headers.filter(":ui-sortable").sortable("destroy"),$headers.sortable({containment:"parent",distance:3,axis:"x",cursor:"default",tolerance:"intersection",helper:"clone",placeholder:"slick-sortable-placeholder ui-state-default slick-header-column",start:function(e,o){o.placeholder.width(o.helper.outerWidth()-headerColumnWidthDiff),$(o.helper).addClass("slick-header-column-active")},beforeStop:function(e,o){$(o.helper).removeClass("slick-header-column-active")},stop:function(e){if(getEditorLock().commitCurrentEdit()){for(var o=$headers.sortable("toArray"),t=[],l=0;l<o.length;l++)t.push(columns[getColumnIndex(o[l].replace(uid,""))]);setColumns(t),trigger(self.onColumnsReordered,{}),e.stopPropagation(),setupColumnResize()}else $(this).sortable("cancel")}})}function setupColumnResize(){var e,o,t,l,n,r,i,s;(l=$headers.children()).find(".slick-resizable-handle").remove(),l.each(function(e,o){e>=columns.length||columns[e].resizable&&(void 0===i&&(i=e),s=e)}),void 0!==i&&l.each(function(a,c){a>=columns.length||a<i||options.forceFitColumns&&a>=s||($(c),$("<div class='slick-resizable-handle' />").appendTo(c).on("dragstart",function(i,s){if(!getEditorLock().commitCurrentEdit())return!1;t=i.pageX,$(this).parent().addClass("slick-header-column-active");var c=null,d=null;if(l.each(function(e,o){e>=columns.length||(columns[e].previousWidth=$(o).outerWidth())}),options.forceFitColumns)for(c=0,d=0,e=a+1;e<columns.length;e++)(o=columns[e]).resizable&&(null!==d&&(o.maxWidth?d+=o.maxWidth-o.previousWidth:d=null),c+=o.previousWidth-Math.max(o.minWidth||0,absoluteColumnMinWidth));var u=0,h=0;for(e=0;e<=a;e++)(o=columns[e]).resizable&&(null!==h&&(o.maxWidth?h+=o.maxWidth-o.previousWidth:h=null),u+=o.previousWidth-Math.max(o.minWidth||0,absoluteColumnMinWidth));null===c&&(c=1e5),null===u&&(u=1e5),null===d&&(d=1e5),null===h&&(h=1e5),r=t+Math.min(c,h),n=t-Math.min(u,d)}).on("drag",function(l,i){columnResizeDragging=!0;var s,c,d=Math.min(r,Math.max(n,l.pageX))-t;if(d<0){for(c=d,e=a;e>=0;e--)(o=columns[e]).resizable&&(s=Math.max(o.minWidth||0,absoluteColumnMinWidth),c&&o.previousWidth+c<s?(c+=o.previousWidth-s,o.width=s):(o.width=o.previousWidth+c,c=0));if(options.forceFitColumns)for(c=-d,e=a+1;e<columns.length;e++)(o=columns[e]).resizable&&(c&&o.maxWidth&&o.maxWidth-o.previousWidth<c?(c-=o.maxWidth-o.previousWidth,o.width=o.maxWidth):(o.width=o.previousWidth+c,c=0))}else{for(c=d,e=a;e>=0;e--)(o=columns[e]).resizable&&(c&&o.maxWidth&&o.maxWidth-o.previousWidth<c?(c-=o.maxWidth-o.previousWidth,o.width=o.maxWidth):(o.width=o.previousWidth+c,c=0));if(options.forceFitColumns)for(c=-d,e=a+1;e<columns.length;e++)(o=columns[e]).resizable&&(s=Math.max(o.minWidth||0,absoluteColumnMinWidth),c&&o.previousWidth+c<s?(c+=o.previousWidth-s,o.width=s):(o.width=o.previousWidth+c,c=0))}applyColumnHeaderWidths(),options.syncColumnCellResize&&applyColumnWidths()}).on("dragend",function(t,n){var r;for($(this).parent().removeClass("slick-header-column-active"),e=0;e<columns.length;e++)o=columns[e],r=$(l[e]).outerWidth(),o.previousWidth!==r&&o.rerenderOnResize&&invalidateAllRows();updateCanvasWidth(!0),render(),trigger(self.onColumnsResized,{}),setTimeout(function(){columnResizeDragging=!1},300)}))})}function getVBoxDelta(e){var o=0;return $.each(["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],function(t,l){o+=parseFloat(e.css(l))||0}),o}function measureCellPaddingAndBorder(){var e,o=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],t=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],l=$.fn.jquery.split(".");jQueryNewWidthBehaviour=1==l[0]&&l[1]>=8||l[0]>=2,e=$("<div class='ui-state-default slick-header-column' style='visibility:hidden'>-</div>").appendTo($headers),headerColumnWidthDiff=headerColumnHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(o,function(o,t){headerColumnWidthDiff+=parseFloat(e.css(t))||0}),$.each(t,function(o,t){headerColumnHeightDiff+=parseFloat(e.css(t))||0})),e.remove();var n=$("<div class='slick-row' />").appendTo($canvas);e=$("<div class='slick-cell' id='' style='visibility:hidden'>-</div>").appendTo(n),cellWidthDiff=cellHeightDiff=0,"border-box"!=e.css("box-sizing")&&"border-box"!=e.css("-moz-box-sizing")&&"border-box"!=e.css("-webkit-box-sizing")&&($.each(o,function(o,t){cellWidthDiff+=parseFloat(e.css(t))||0}),$.each(t,function(o,t){cellHeightDiff+=parseFloat(e.css(t))||0})),n.remove(),absoluteColumnMinWidth=Math.max(headerColumnWidthDiff,cellWidthDiff)}function createCssRules(){$style=$("<style type='text/css' rel='stylesheet' />").appendTo($("head"));for(var e=options.rowHeight-cellHeightDiff,o=["."+uid+" .slick-header-column { left: 1000px; }","."+uid+" .slick-top-panel { height:"+options.topPanelHeight+"px; }","."+uid+" .slick-preheader-panel { height:"+options.preHeaderPanelHeight+"px; }","."+uid+" .slick-headerrow-columns { height:"+options.headerRowHeight+"px; }","."+uid+" .slick-footerrow-columns { height:"+options.footerRowHeight+"px; }","."+uid+" .slick-cell { height:"+e+"px; }","."+uid+" .slick-row { height:"+options.rowHeight+"px; }"],t=0;t<columns.length;t++)o.push("."+uid+" .l"+t+" { }"),o.push("."+uid+" .r"+t+" { }");$style[0].styleSheet?$style[0].styleSheet.cssText=o.join(" "):$style[0].appendChild(document.createTextNode(o.join(" ")))}function getColumnCssRules(e){var o;if(!stylesheet){var t=document.styleSheets;for(o=0;o<t.length;o++)if((t[o].ownerNode||t[o].owningElement)==$style[0]){stylesheet=t[o];break}if(!stylesheet)throw new Error("Cannot find stylesheet.");columnCssRulesL=[],columnCssRulesR=[];var l,n,r=stylesheet.cssRules||stylesheet.rules;for(o=0;o<r.length;o++){var i=r[o].selectorText;(l=/\.l\d+/.exec(i))?(n=parseInt(l[0].substr(2,l[0].length-2),10),columnCssRulesL[n]=r[o]):(l=/\.r\d+/.exec(i))&&(n=parseInt(l[0].substr(2,l[0].length-2),10),columnCssRulesR[n]=r[o])}}return{left:columnCssRulesL[e],right:columnCssRulesR[e]}}function removeCssRules(){$style.remove(),stylesheet=null}function destroy(){getEditorLock().cancelCurrentEdit(),trigger(self.onBeforeDestroy,{});for(var e=plugins.length;e--;)unregisterPlugin(plugins[e]);options.enableColumnReorder&&$headers.filter(":ui-sortable").sortable("destroy"),unbindAncestorScrollEvents(),$container.off(".slickgrid"),removeCssRules(),$canvas.off("draginit dragstart dragend drag"),$container.empty().removeClass(uid)}function trigger(e,o,t){return t=t||new Slick.EventData,(o=o||{}).grid=self,e.notify(o,t,self)}function getEditorLock(){return options.editorLock}function getEditController(){return editController}function getColumnIndex(e){return columnsById[e]}function autosizeColumns(){var e,o,t,l=[],n=0,r=0,i=viewportHasVScroll?viewportW-scrollbarDimensions.width:viewportW;for(e=0;e<columns.length;e++)o=columns[e],l.push(o.width),r+=o.width,o.resizable&&(n+=o.width-Math.max(o.minWidth,absoluteColumnMinWidth));for(t=r;r>i&&n;){var s=(r-i)/n;for(e=0;e<columns.length&&r>i;e++){o=columns[e];var a=l[e];if(!(!o.resizable||a<=o.minWidth||a<=absoluteColumnMinWidth)){var c=Math.max(o.minWidth,absoluteColumnMinWidth),d=Math.floor(s*(a-c))||1;r-=d=Math.min(d,a-c),n-=d,l[e]-=d}}if(t<=r)break;t=r}for(t=r;r<i;){var u=i/r;for(e=0;e<columns.length&&r<i;e++){o=columns[e];var h,p=l[e];r+=h=!o.resizable||o.maxWidth<=p?0:Math.min(Math.floor(u*p)-p,o.maxWidth-p||1e6)||1,l[e]+=r<=i?h:0}if(t>=r)break;t=r}var g=!1;for(e=0;e<columns.length;e++)columns[e].rerenderOnResize&&columns[e].width!=l[e]&&(g=!0),columns[e].width=l[e];applyColumnHeaderWidths(),updateCanvasWidth(!0),trigger(self.onAutosizeColumns,{columns:columns}),g&&(invalidateAllRows(),render())}function applyColumnHeaderWidths(){if(initialized){for(var e,o=0,t=$headers.children(),l=columns.length;o<l;o++)e=$(t[o]),jQueryNewWidthBehaviour?e.outerWidth()!==columns[o].width&&e.outerWidth(columns[o].width):e.width()!==columns[o].width-headerColumnWidthDiff&&e.width(columns[o].width-headerColumnWidthDiff);updateColumnCaches()}}function applyColumnWidths(){for(var e,o,t=0,l=0;l<columns.length;l++)e=columns[l].width,(o=getColumnCssRules(l)).left.style.left=t+"px",o.right.style.right=canvasWidth-t-e+"px",t+=columns[l].width}function setSortColumn(e,o){setSortColumns([{columnId:e,sortAsc:o}])}function setSortColumns(e){sortColumns=e;var o=options.numberedMultiColumnSort&&sortColumns.length>1,t=$headers.children();t.removeClass("slick-header-column-sorted").find(".slick-sort-indicator").removeClass("slick-sort-indicator-asc slick-sort-indicator-desc"),t.find(".slick-sort-indicator-numbered").text(""),$.each(sortColumns,function(e,l){null==l.sortAsc&&(l.sortAsc=!0);var n=getColumnIndex(l.columnId);null!=n&&(t.eq(n).addClass("slick-header-column-sorted").find(".slick-sort-indicator").addClass(l.sortAsc?"slick-sort-indicator-asc":"slick-sort-indicator-desc"),o&&t.eq(n).find(".slick-sort-indicator-numbered").text(e+1))})}function getSortColumns(){return sortColumns}function handleSelectedRangesChanged(e,o){selectedRows=[];for(var t={},l=0;l<o.length;l++)for(var n=o[l].fromRow;n<=o[l].toRow;n++){t[n]||(selectedRows.push(n),t[n]={});for(var r=o[l].fromCell;r<=o[l].toCell;r++)canCellBeSelected(n,r)&&(t[n][columns[r].id]=options.selectedCellCssClass)}setCellCssStyles(options.selectedCellCssClass,t),trigger(self.onSelectedRowsChanged,{rows:getSelectedRows()},e)}function getColumns(){return columns}function updateColumnCaches(){columnPosLeft=[],columnPosRight=[];for(var e=0,o=0,t=columns.length;o<t;o++)columnPosLeft[o]=e,columnPosRight[o]=e+columns[o].width,e+=columns[o].width}function setColumns(e){columns=e,columnsById={};for(var o=0;o<columns.length;o++){var t=columns[o]=$.extend({},columnDefaults,columns[o]);columnsById[t.id]=o,t.minWidth&&t.width<t.minWidth&&(t.width=t.minWidth),t.maxWidth&&t.width>t.maxWidth&&(t.width=t.maxWidth)}updateColumnCaches(),initialized&&(invalidateAllRows(),createColumnHeaders(),removeCssRules(),createCssRules(),resizeCanvas(),applyColumnWidths(),handleScroll())}function getOptions(){return options}function setOptions(e,o){getEditorLock().commitCurrentEdit()&&(makeActiveCellNormal(),options.enableAddRow!==e.enableAddRow&&invalidateRow(getDataLength()),options=$.extend(options,e),validateAndEnforceOptions(),$viewport.css("overflow-y",options.autoHeight?"hidden":"auto"),o||render())}function validateAndEnforceOptions(){options.autoHeight&&(options.leaveSpaceForNewRows=!1)}function setData(e,o){data=e,invalidateAllRows(),updateRowCount(),o&&scrollTo(0)}function getData(){return data}function getDataLength(){return data.getLength?data.getLength():data.length}function getDataLengthIncludingAddNew(){return getDataLength()+(options.enableAddRow&&(!pagingActive||pagingIsLastPage)?1:0)}function getDataItem(e){return data.getItem?data.getItem(e):data[e]}function getTopPanel(){return $topPanel[0]}function setTopPanelVisibility(e){options.showTopPanel!=e&&(options.showTopPanel=e,e?$topPanelScroller.slideDown("fast",resizeCanvas):$topPanelScroller.slideUp("fast",resizeCanvas))}function setHeaderRowVisibility(e){options.showHeaderRow!=e&&(options.showHeaderRow=e,e?$headerRowScroller.slideDown("fast",resizeCanvas):$headerRowScroller.slideUp("fast",resizeCanvas))}function setFooterRowVisibility(e){options.showFooterRow!=e&&(options.showFooterRow=e,e?$footerRowScroller.slideDown("fast",resizeCanvas):$footerRowScroller.slideUp("fast",resizeCanvas))}function setPreHeaderPanelVisibility(e){options.showPreHeaderPanel!=e&&(options.showPreHeaderPanel=e,e?$preHeaderPanelScroller.slideDown("fast",resizeCanvas):$preHeaderPanelScroller.slideUp("fast",resizeCanvas))}function getContainerNode(){return $container.get(0)}function getRowTop(e){return options.rowHeight*e-offset}function getRowFromPosition(e){return Math.floor((e+offset)/options.rowHeight)}function scrollTo(e){e=Math.max(e,0),e=Math.min(e,th-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0));var o=offset;page=Math.min(n-1,Math.floor(e/ph));var t=e-(offset=Math.round(page*cj));offset!=o&&(cleanupRows(getVisibleRange(t)),updateRowPositions());prevScrollTop!=t&&(vScrollDir=prevScrollTop+o<t+offset?1:-1,$viewport[0].scrollTop=lastRenderedScrollTop=scrollTop=prevScrollTop=t,trigger(self.onViewportChanged,{}))}function defaultFormatter(e,o,t,l,n,r){return null==t?"":(t+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}function getFormatter(e,o){var t=data.getItemMetadata&&data.getItemMetadata(e),l=t&&t.columns&&(t.columns[o.id]||t.columns[getColumnIndex(o.id)]);return l&&l.formatter||t&&t.formatter||o.formatter||options.formatterFactory&&options.formatterFactory.getFormatter(o)||options.defaultFormatter}function getEditor(e,o){var t=columns[o],l=data.getItemMetadata&&data.getItemMetadata(e),n=l&&l.columns;return n&&n[t.id]&&void 0!==n[t.id].editor?n[t.id].editor:n&&n[o]&&void 0!==n[o].editor?n[o].editor:t.editor||options.editorFactory&&options.editorFactory.getEditor(t)}function getDataItemValueForColumn(e,o){return options.dataItemColumnValueExtractor?options.dataItemColumnValueExtractor(e,o):e[o.field]}function appendRowHtml(e,o,t,l){var n=getDataItem(o),r="slick-row"+(o<l&&!n?" loading":"")+(o===activeRow&&options.showCellSelection?" active":"")+(o%2==1?" odd":" even");n||(r+=" "+options.addNewRowCssClass);var i,s,a=data.getItemMetadata&&data.getItemMetadata(o);a&&a.cssClasses&&(r+=" "+a.cssClasses),e.push("<div class='ui-widget-content "+r+"' style='top:"+getRowTop(o)+"px'>");for(var c=0,d=columns.length;c<d;c++){if(s=columns[c],i=1,a&&a.columns){var u=a.columns[s.id]||a.columns[c];"*"===(i=u&&u.colspan||1)&&(i=d-c)}if(columnPosRight[Math.min(d-1,c+i-1)]>t.leftPx){if(columnPosLeft[c]>t.rightPx)break;appendCellHtml(e,o,c,i,n)}i>1&&(c+=i-1)}e.push("</div>")}function appendCellHtml(e,o,t,l,n){var r=columns[t],i="slick-cell l"+t+" r"+Math.min(columns.length-1,t+l-1)+(r.cssClass?" "+r.cssClass:"");for(var s in o===activeRow&&t===activeCell&&options.showCellSelection&&(i+=" active"),cellCssClasses)cellCssClasses[s][o]&&cellCssClasses[s][o][r.id]&&(i+=" "+cellCssClasses[s][o][r.id]);var a=null,c="";n&&(a=getDataItemValueForColumn(n,r),null==(c=getFormatter(o,r)(o,t,a,r,n,self))&&(c=""));var d=trigger(self.onBeforeAppendCell,{row:o,cell:t,value:a,dataContext:n})||"";d+=c&&c.addClasses?(d?" ":"")+c.addClasses:"",e.push("<div class='"+i+(d?" "+d:"")+"'>"),n&&e.push("[object Object]"!==Object.prototype.toString.call(c)?c:c.text),e.push("</div>"),rowsCache[o].cellRenderQueue.push(t),rowsCache[o].cellColSpans[t]=l}function cleanupRows(e){for(var o in rowsCache)(o=parseInt(o,10))!==activeRow&&(o<e.top||o>e.bottom)&&removeRowFromCache(o);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function invalidate(){updateRowCount(),invalidateAllRows(),render()}function invalidateAllRows(){for(var e in currentEditor&&makeActiveCellNormal(),rowsCache)removeRowFromCache(e);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}function queuePostProcessedRowForCleanup(e,o,t){for(var l in postProcessgroupId++,o)o.hasOwnProperty(l)&&postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e.cellNodesByColumnIdx[0|l],columnIdx:0|l,rowIdx:t});postProcessedCleanupQueue.push({actionType:"R",groupId:postProcessgroupId,node:e.rowNode}),$(e.rowNode).detach()}function queuePostProcessedCellForCleanup(e,o,t){postProcessedCleanupQueue.push({actionType:"C",groupId:postProcessgroupId,node:e,columnIdx:o,rowIdx:t}),$(e).detach()}function removeRowFromCache(e){var o=rowsCache[e];o&&(o.rowNode&&(rowNodeFromLastMouseWheelEvent===o.rowNode?(o.rowNode.style.display="none",zombieRowNodeFromLastMouseWheelEvent=rowNodeFromLastMouseWheelEvent,zombieRowCacheFromLastMouseWheelEvent=o,zombieRowPostProcessedFromLastMouseWheelEvent=postProcessedRows[e]):options.enableAsyncPostRenderCleanup&&postProcessedRows[e]?queuePostProcessedRowForCleanup(o,postProcessedRows[e],e):$canvas[0].removeChild(o.rowNode)),delete rowsCache[e],delete postProcessedRows[e],renderedRows--,counter_rows_removed++)}function invalidateRows(e){var o,t;if(e&&e.length){for(vScrollDir=0,t=e.length,o=0;o<t;o++)currentEditor&&activeRow===e[o]&&makeActiveCellNormal(),rowsCache[e[o]]&&removeRowFromCache(e[o]);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()}}function invalidateRow(e){(e||0===e)&&invalidateRows([e])}function applyFormatResultToCellNode(e,o,t){null==e&&(e=""),"[object Object]"===Object.prototype.toString.call(e)?(o.innerHTML=e.text,e.removeClasses&&!t&&$(o).removeClass(e.removeClasses),e.addClasses&&$(o).addClass(e.addClasses)):o.innerHTML=e}function updateCell(e,o){var t=getCellNode(e,o);if(t){var l=columns[o],n=getDataItem(e);if(currentEditor&&activeRow===e&&activeCell===o)currentEditor.loadValue(n);else applyFormatResultToCellNode(n?getFormatter(e,l)(e,o,getDataItemValueForColumn(n,l),l,n,self):"",t),invalidatePostProcessingResults(e)}}function updateRow(e){var o=rowsCache[e];if(o){ensureCellNodesInRowsCache(e);var t=getDataItem(e);for(var l in o.cellNodesByColumnIdx)if(o.cellNodesByColumnIdx.hasOwnProperty(l)){var n=columns[l|=0],r=o.cellNodesByColumnIdx[l];e===activeRow&&l===activeCell&&currentEditor?currentEditor.loadValue(t):t?applyFormatResultToCellNode(getFormatter(e,n)(e,l,getDataItemValueForColumn(t,n),n,t,self),r):r.innerHTML=""}invalidatePostProcessingResults(e)}}function getViewportHeight(){return parseFloat($.css($container[0],"height",!0))-parseFloat($.css($container[0],"paddingTop",!0))-parseFloat($.css($container[0],"paddingBottom",!0))-parseFloat($.css($headerScroller[0],"height"))-getVBoxDelta($headerScroller)-(options.showTopPanel?options.topPanelHeight+getVBoxDelta($topPanelScroller):0)-(options.showHeaderRow?options.headerRowHeight+getVBoxDelta($headerRowScroller):0)-(options.createFooterRow&&options.showFooterRow?options.footerRowHeight+getVBoxDelta($footerRowScroller):0)-(options.createPreHeaderPanel&&options.showPreHeaderPanel?options.preHeaderPanelHeight+getVBoxDelta($preHeaderPanelScroller):0)}function resizeCanvas(){initialized&&(viewportH=options.autoHeight?options.rowHeight*getDataLengthIncludingAddNew():getViewportHeight(),numVisibleRows=Math.ceil(viewportH/options.rowHeight),viewportW=parseFloat($.css($container[0],"width",!0)),options.autoHeight||$viewport.height(viewportH),scrollbarDimensions&&scrollbarDimensions.width||(scrollbarDimensions=measureScrollbar()),options.forceFitColumns&&autosizeColumns(),updateRowCount(),handleScroll(),lastRenderedScrollLeft=-1,render())}function updatePagingStatusFromView(e){pagingActive=0!==e.pageSize,pagingIsLastPage=e.pageNum==e.totalPages-1}function updateRowCount(){if(initialized){var e=getDataLength(),o=getDataLengthIncludingAddNew()+(options.leaveSpaceForNewRows?numVisibleRows-1:0),t=viewportHasVScroll;viewportHasVScroll=options.alwaysShowVerticalScroll||!options.autoHeight&&o*options.rowHeight>viewportH,viewportHasHScroll=canvasWidth>viewportW-scrollbarDimensions.width,makeActiveCellNormal();var l=e-1;for(var r in rowsCache)r>l&&removeRowFromCache(r);options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup(),activeCellNode&&activeRow>l&&resetActiveCell();var i=h;(th=Math.max(options.rowHeight*o,viewportH-scrollbarDimensions.height))<maxSupportedCssHeight?(h=ph=th,n=1,cj=0):(ph=(h=maxSupportedCssHeight)/100,n=Math.floor(th/ph),cj=(th-h)/(n-1)),h!==i&&($canvas.css("height",h),scrollTop=$viewport[0].scrollTop);var s=scrollTop+offset<=th-viewportH;0==th||0==scrollTop?page=offset=0:scrollTo(s?scrollTop+offset:th-viewportH),h!=i&&options.autoHeight&&resizeCanvas(),options.forceFitColumns&&t!=viewportHasVScroll&&autosizeColumns(),updateCanvasWidth(!1)}}function getVisibleRange(e,o){return null==e&&(e=scrollTop),null==o&&(o=scrollLeft),{top:getRowFromPosition(e),bottom:getRowFromPosition(e+viewportH)+1,leftPx:o,rightPx:o+viewportW}}function getRenderedRange(e,o){var t=getVisibleRange(e,o),l=Math.round(viewportH/options.rowHeight),n=options.minRowBuffer;return-1==vScrollDir?(t.top-=l,t.bottom+=n):1==vScrollDir?(t.top-=n,t.bottom+=l):(t.top-=n,t.bottom+=n),t.top=Math.max(0,t.top),t.bottom=Math.min(getDataLengthIncludingAddNew()-1,t.bottom),t.leftPx-=viewportW,t.rightPx+=viewportW,t.leftPx=Math.max(0,t.leftPx),t.rightPx=Math.min(canvasWidth,t.rightPx),t}function ensureCellNodesInRowsCache(e){var o=rowsCache[e];if(o&&o.cellRenderQueue.length)for(var t=o.rowNode.lastChild;o.cellRenderQueue.length;){var l=o.cellRenderQueue.pop();o.cellNodesByColumnIdx[l]=t,t=t.previousSibling}}function cleanUpCells(e,o){var t,l,n=rowsCache[o],r=[];for(var i in n.cellNodesByColumnIdx)if(n.cellNodesByColumnIdx.hasOwnProperty(i)){i|=0;var s=n.cellColSpans[i];(columnPosLeft[i]>e.rightPx||columnPosRight[Math.min(columns.length-1,i+s-1)]<e.leftPx)&&(o==activeRow&&i==activeCell||r.push(i))}for(postProcessgroupId++;null!=(t=r.pop());)l=n.cellNodesByColumnIdx[t],options.enableAsyncPostRenderCleanup&&postProcessedRows[o]&&postProcessedRows[o][t]?queuePostProcessedCellForCleanup(l,t,o):n.rowNode.removeChild(l),delete n.cellColSpans[t],delete n.cellNodesByColumnIdx[t],postProcessedRows[o]&&delete postProcessedRows[o][t],0}function cleanUpAndRenderCells(e){for(var o,t,l,n=[],r=[],i=e.top,s=e.bottom;i<=s;i++)if(o=rowsCache[i]){ensureCellNodesInRowsCache(i),cleanUpCells(e,i),t=0;var a=data.getItemMetadata&&data.getItemMetadata(i);a=a&&a.columns;for(var c=getDataItem(i),d=0,u=columns.length;d<u&&!(columnPosLeft[d]>e.rightPx);d++)if(null==(l=o.cellColSpans[d])){if(l=1,a){var h=a[columns[d].id]||a[d];"*"===(l=h&&h.colspan||1)&&(l=u-d)}columnPosRight[Math.min(u-1,d+l-1)]>e.leftPx&&(appendCellHtml(n,i,d,l,c),t++),d+=l>1?l-1:0}else d+=l>1?l-1:0;t&&(t,r.push(i))}if(n.length){var p,g,m=document.createElement("div");for(m.innerHTML=n.join("");null!=(p=r.pop());){var v;for(o=rowsCache[p];null!=(v=o.cellRenderQueue.pop());)g=m.lastChild,o.rowNode.appendChild(g),o.cellNodesByColumnIdx[v]=g}}}function renderRows(e){for(var o=$canvas[0],t=[],l=[],n=!1,r=getDataLength(),i=e.top,s=e.bottom;i<=s;i++)rowsCache[i]||(renderedRows++,l.push(i),rowsCache[i]={rowNode:null,cellColSpans:[],cellNodesByColumnIdx:[],cellRenderQueue:[]},appendRowHtml(t,i,e,r),activeCellNode&&activeRow===i&&(n=!0),counter_rows_rendered++);if(l.length){var a=document.createElement("div");a.innerHTML=t.join("");for(i=0,s=l.length;i<s;i++)rowsCache[l[i]].rowNode=o.appendChild(a.firstChild);n&&(activeCellNode=getCellNode(activeRow,activeCell))}}function startPostProcessing(){options.enableAsyncPostRender&&(clearTimeout(h_postrender),h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}function startPostProcessingCleanup(){options.enableAsyncPostRenderCleanup&&(clearTimeout(h_postrenderCleanup),h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay))}function invalidatePostProcessingResults(e){for(var o in postProcessedRows[e])postProcessedRows[e].hasOwnProperty(o)&&(postProcessedRows[e][o]="C");postProcessFromRow=Math.min(postProcessFromRow,e),postProcessToRow=Math.max(postProcessToRow,e),startPostProcessing()}function updateRowPositions(){for(var e in rowsCache)rowsCache[e].rowNode.style.top=getRowTop(e)+"px"}function render(){if(initialized){scrollThrottle.dequeue();var e=getVisibleRange(),o=getRenderedRange();cleanupRows(o),lastRenderedScrollLeft!=scrollLeft&&cleanUpAndRenderCells(o),renderRows(o),postProcessFromRow=e.top,postProcessToRow=Math.min(getDataLengthIncludingAddNew()-1,e.bottom),startPostProcessing(),lastRenderedScrollTop=scrollTop,lastRenderedScrollLeft=scrollLeft,h_render=null,trigger(self.onRendered,{startRow:e.top,endRow:e.bottom,grid:self})}}function handleHeaderScroll(){handleElementScroll($headerScroller[0])}function handleHeaderRowScroll(){handleElementScroll($headerRowScroller[0])}function handleFooterRowScroll(){handleElementScroll($footerRowScroller[0])}function handlePreHeaderPanelScroll(){handleElementScroll($preHeaderPanelScroller[0])}function handleElementScroll(e){var o=e.scrollLeft;o!=$viewport[0].scrollLeft&&($viewport[0].scrollLeft=o)}function handleScroll(){scrollTop=$viewport[0].scrollTop,scrollLeft=$viewport[0].scrollLeft;var e=Math.abs(scrollTop-prevScrollTop),o=Math.abs(scrollLeft-prevScrollLeft);if(o&&(prevScrollLeft=scrollLeft,$headerScroller[0].scrollLeft=scrollLeft,$topPanelScroller[0].scrollLeft=scrollLeft,$headerRowScroller[0].scrollLeft=scrollLeft,options.createFooterRow&&($footerRowScroller[0].scrollLeft=scrollLeft),options.createPreHeaderPanel&&($preHeaderPanelScroller[0].scrollLeft=scrollLeft)),e)if(vScrollDir=prevScrollTop<scrollTop?1:-1,prevScrollTop=scrollTop,e<viewportH)scrollTo(scrollTop+offset);else{var t=offset;page=h==viewportH?0:Math.min(n-1,Math.floor(scrollTop*((th-viewportH)/(h-viewportH))*(1/ph))),t!=(offset=Math.round(page*cj))&&invalidateAllRows()}if(o||e){var l=Math.abs(lastRenderedScrollLeft-scrollLeft),r=Math.abs(lastRenderedScrollTop-scrollTop);(l>20||r>20)&&(options.forceSyncScrolling||r<viewportH&&l<viewportW?render():scrollThrottle.enqueue(),trigger(self.onViewportChanged,{}))}trigger(self.onScroll,{scrollLeft:scrollLeft,scrollTop:scrollTop})}function ActionThrottle(e,o){var t=!1,l=!1;function n(){l=!1}function r(){t=!0,setTimeout(i,o),e()}function i(){l?(n(),r()):t=!1}return{enqueue:function(){t?l=!0:r()},dequeue:n}}function asyncPostProcessRows(){for(var e=getDataLength();postProcessFromRow<=postProcessToRow;){var o=vScrollDir>=0?postProcessFromRow++:postProcessToRow--,t=rowsCache[o];if(t&&!(o>=e)){for(var l in postProcessedRows[o]||(postProcessedRows[o]={}),ensureCellNodesInRowsCache(o),t.cellNodesByColumnIdx)if(t.cellNodesByColumnIdx.hasOwnProperty(l)){var n=columns[l|=0],r=postProcessedRows[o][l];if(n.asyncPostRender&&"R"!==r){var i=t.cellNodesByColumnIdx[l];i&&n.asyncPostRender(i,o,getDataItem(o),n,"C"===r),postProcessedRows[o][l]="R"}}return void(h_postrender=setTimeout(asyncPostProcessRows,options.asyncPostRenderDelay))}}}function asyncPostProcessCleanupRows(){if(postProcessedCleanupQueue.length>0){for(var e=postProcessedCleanupQueue[0].groupId;postProcessedCleanupQueue.length>0&&postProcessedCleanupQueue[0].groupId==e;){var o=postProcessedCleanupQueue.shift();if("R"==o.actionType&&$(o.node).remove(),"C"==o.actionType){var t=columns[o.columnIdx];t.asyncPostRenderCleanup&&o.node&&t.asyncPostRenderCleanup(o.node,o.rowIdx,t)}}h_postrenderCleanup=setTimeout(asyncPostProcessCleanupRows,options.asyncPostRenderCleanupDelay)}}function updateCellCssStylesOnRenderedRows(e,o){var t,l,n,r;for(var i in rowsCache){if(r=o&&o[i],n=e&&e[i],r)for(l in r)n&&r[l]==n[l]||(t=getCellNode(i,getColumnIndex(l)))&&$(t).removeClass(r[l]);if(n)for(l in n)r&&r[l]==n[l]||(t=getCellNode(i,getColumnIndex(l)))&&$(t).addClass(n[l])}}function addCellCssStyles(e,o){if(cellCssClasses[e])throw new Error("addCellCssStyles: cell CSS hash with key '"+e+"' already exists.");cellCssClasses[e]=o,updateCellCssStylesOnRenderedRows(o,null),trigger(self.onCellCssStylesChanged,{key:e,hash:o,grid:self})}function removeCellCssStyles(e){cellCssClasses[e]&&(updateCellCssStylesOnRenderedRows(null,cellCssClasses[e]),delete cellCssClasses[e],trigger(self.onCellCssStylesChanged,{key:e,hash:null,grid:self}))}function setCellCssStyles(e,o){var t=cellCssClasses[e];cellCssClasses[e]=o,updateCellCssStylesOnRenderedRows(o,t),trigger(self.onCellCssStylesChanged,{key:e,hash:o,grid:self})}function getCellCssStyles(e){return cellCssClasses[e]}function flashCell(e,o,t){if(t=t||100,rowsCache[e]){var l=$(getCellNode(e,o)),n=function(e){e&&setTimeout(function(){l.queue(function(){l.toggleClass(options.cellFlashingCssClass).dequeue(),n(e-1)})},t)};n(4)}}function handleMouseWheel(e){var o=$(e.target).closest(".slick-row")[0];o!=rowNodeFromLastMouseWheelEvent&&(zombieRowNodeFromLastMouseWheelEvent&&zombieRowNodeFromLastMouseWheelEvent!=o&&(options.enableAsyncPostRenderCleanup&&zombieRowPostProcessedFromLastMouseWheelEvent?queuePostProcessedRowForCleanup(zombieRowCacheFromLastMouseWheelEvent,zombieRowPostProcessedFromLastMouseWheelEvent):$canvas[0].removeChild(zombieRowNodeFromLastMouseWheelEvent),zombieRowNodeFromLastMouseWheelEvent=null,zombieRowCacheFromLastMouseWheelEvent=null,zombieRowPostProcessedFromLastMouseWheelEvent=null,options.enableAsyncPostRenderCleanup&&startPostProcessingCleanup()),rowNodeFromLastMouseWheelEvent=o)}function handleDragInit(e,o){var t=getCellFromEvent(e);if(!t||!cellExists(t.row,t.cell))return!1;var l=trigger(self.onDragInit,o,e);return!!e.isImmediatePropagationStopped()&&l}function handleDragStart(e,o){var t=getCellFromEvent(e);if(!t||!cellExists(t.row,t.cell))return!1;var l=trigger(self.onDragStart,o,e);return!!e.isImmediatePropagationStopped()&&l}function handleDrag(e,o){return trigger(self.onDrag,o,e)}function handleDragEnd(e,o){trigger(self.onDragEnd,o,e)}function handleKeyDown(e){trigger(self.onKeyDown,{row:activeRow,cell:activeCell},e);var o=e.isImmediatePropagationStopped(),t=Slick.keyCode;if(!o&&!e.shiftKey&&!e.altKey){if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;e.which==t.HOME?o=e.ctrlKey?navigateTop():navigateRowStart():e.which==t.END&&(o=e.ctrlKey?navigateBottom():navigateRowEnd())}if(!o)if(e.shiftKey||e.altKey||e.ctrlKey)e.which!=t.TAB||!e.shiftKey||e.ctrlKey||e.altKey||(o=navigatePrev());else{if(options.editable&&currentEditor&&currentEditor.keyCaptureList&&currentEditor.keyCaptureList.indexOf(e.which)>-1)return;if(e.which==t.ESCAPE){if(!getEditorLock().isActive())return;cancelEditAndSetFocus()}else e.which==t.PAGE_DOWN?(navigatePageDown(),o=!0):e.which==t.PAGE_UP?(navigatePageUp(),o=!0):e.which==t.LEFT?o=navigateLeft():e.which==t.RIGHT?o=navigateRight():e.which==t.UP?o=navigateUp():e.which==t.DOWN?o=navigateDown():e.which==t.TAB?o=navigateNext():e.which==t.ENTER&&(options.editable&&(currentEditor?activeRow===getDataLength()?navigateDown():commitEditAndSetFocus():getEditorLock().commitCurrentEdit()&&makeActiveCellEditable(void 0,void 0,e)),o=!0)}if(o){e.stopPropagation(),e.preventDefault();try{e.originalEvent.keyCode=0}catch(e){}}}function handleClick(e){currentEditor||(e.target!=document.activeElement||$(e.target).hasClass("slick-cell"))&&setFocus();var o=getCellFromEvent(e);if(o&&(null===currentEditor||activeRow!=o.row||activeCell!=o.cell)&&(trigger(self.onClick,{row:o.row,cell:o.cell},e),!e.isImmediatePropagationStopped()&&canCellBeActive(o.row,o.cell)&&(!getEditorLock().isActive()||getEditorLock().commitCurrentEdit()))){scrollRowIntoView(o.row,!1);var t=e.target&&e.target.className===Slick.preClickClassName,l=columns[o.cell],n=!!(options.editable&&l&&l.editor&&options.suppressActiveCellChangeOnEdit);setActiveCellInternal(getCellNode(o.row,o.cell),null,t,n,e)}}function handleContextMenu(e){var o=$(e.target).closest(".slick-cell",$canvas);0!==o.length&&(activeCellNode===o[0]&&null!==currentEditor||trigger(self.onContextMenu,{},e))}function handleDblClick(e){var o=getCellFromEvent(e);!o||null!==currentEditor&&activeRow==o.row&&activeCell==o.cell||(trigger(self.onDblClick,{row:o.row,cell:o.cell},e),e.isImmediatePropagationStopped()||options.editable&&gotoCell(o.row,o.cell,!0,e))}function handleHeaderMouseEnter(e){trigger(self.onHeaderMouseEnter,{column:$(this).data("column"),grid:self},e)}function handleHeaderMouseLeave(e){trigger(self.onHeaderMouseLeave,{column:$(this).data("column"),grid:self},e)}function handleHeaderContextMenu(e){var o=$(e.target).closest(".slick-header-column",".slick-header-columns"),t=o&&o.data("column");trigger(self.onHeaderContextMenu,{column:t},e)}function handleHeaderClick(e){if(!columnResizeDragging){var o=$(e.target).closest(".slick-header-column",".slick-header-columns"),t=o&&o.data("column");t&&trigger(self.onHeaderClick,{column:t},e)}}function handleMouseEnter(e){trigger(self.onMouseEnter,{},e)}function handleMouseLeave(e){trigger(self.onMouseLeave,{},e)}function cellExists(e,o){return!(e<0||e>=getDataLength()||o<0||o>=columns.length)}function getCellFromPoint(e,o){for(var t=getRowFromPosition(o),l=0,n=0,r=0;r<columns.length&&n<e;r++)n+=columns[r].width,l++;return l<0&&(l=0),{row:t,cell:l-1}}function getCellFromNode(e){var o=/l\d+/.exec(e.className);if(!o)throw new Error("getCellFromNode: cannot get cell - "+e.className);return parseInt(o[0].substr(1,o[0].length-1),10)}function getRowFromNode(e){for(var o in rowsCache)if(rowsCache[o].rowNode===e)return 0|o;return null}function getCellFromEvent(e){var o=$(e.target).closest(".slick-cell",$canvas);if(!o.length)return null;var t=getRowFromNode(o[0].parentNode),l=getCellFromNode(o[0]);return null==t||null==l?null:{row:t,cell:l}}function getCellNodeBox(e,o){if(!cellExists(e,o))return null;for(var t=getRowTop(e),l=t+options.rowHeight-1,n=0,r=0;r<o;r++)n+=columns[r].width;return{top:t,left:n,bottom:l,right:n+columns[o].width}}function resetActiveCell(){setActiveCellInternal(null,!1)}function setFocus(){-1==tabbingDirection?$focusSink[0].focus():$focusSink2[0].focus()}function scrollCellIntoView(e,o,t){scrollRowIntoView(e,t);var l=getColspan(e,o);internalScrollColumnIntoView(columnPosLeft[o],columnPosRight[o+(l>1?l-1:0)])}function internalScrollColumnIntoView(e,o){var t=scrollLeft+viewportW;e<scrollLeft?($viewport.scrollLeft(e),handleScroll(),render()):o>t&&($viewport.scrollLeft(Math.min(e,o-$viewport[0].clientWidth)),handleScroll(),render())}function scrollColumnIntoView(e){internalScrollColumnIntoView(columnPosLeft[e],columnPosRight[e])}function setActiveCellInternal(e,o,t,l,n){null!==activeCellNode&&(makeActiveCellNormal(),$(activeCellNode).removeClass("active"),rowsCache[activeRow]&&$(rowsCache[activeRow].rowNode).removeClass("active"));null!=(activeCellNode=e)?(activeRow=getRowFromNode(activeCellNode.parentNode),activeCell=activePosX=getCellFromNode(activeCellNode),null==o&&(o=activeRow==getDataLength()||options.autoEdit),options.showCellSelection&&($(activeCellNode).addClass("active"),$(rowsCache[activeRow].rowNode).addClass("active")),options.editable&&o&&isCellPotentiallyEditable(activeRow,activeCell)&&(clearTimeout(h_editorLoader),options.asyncEditorLoading?h_editorLoader=setTimeout(function(){makeActiveCellEditable(void 0,t,n)},options.asyncEditorLoadDelay):makeActiveCellEditable(void 0,t,n))):activeRow=activeCell=null,l||trigger(self.onActiveCellChanged,getActiveCell())}function clearTextSelection(){if(document.selection&&document.selection.empty)try{document.selection.empty()}catch(e){}else if(window.getSelection){var e=window.getSelection();e&&e.removeAllRanges&&e.removeAllRanges()}}function isCellPotentiallyEditable(e,o){var t=getDataLength();return!(e<t&&!getDataItem(e))&&(!(columns[o].cannotTriggerInsert&&e>=t)&&!!getEditor(e,o))}function makeActiveCellNormal(){if(currentEditor){if(trigger(self.onBeforeCellEditorDestroy,{editor:currentEditor}),currentEditor.destroy(),currentEditor=null,activeCellNode){var e=getDataItem(activeRow);if($(activeCellNode).removeClass("editable invalid"),e){var o=columns[activeCell];applyFormatResultToCellNode(getFormatter(activeRow,o)(activeRow,activeCell,getDataItemValueForColumn(e,o),o,e,self),activeCellNode),invalidatePostProcessingResults(activeRow)}}navigator.userAgent.toLowerCase().match(/msie/)&&clearTextSelection(),getEditorLock().deactivate(editController)}}function makeActiveCellEditable(e,o,t){if(activeCellNode){if(!options.editable)throw new Error("Grid : makeActiveCellEditable : should never get called when options.editable is false");if(clearTimeout(h_editorLoader),isCellPotentiallyEditable(activeRow,activeCell)){var l=columns[activeCell],n=getDataItem(activeRow);if(!1!==trigger(self.onBeforeEditCell,{row:activeRow,cell:activeCell,item:n,column:l})){getEditorLock().activate(editController),$(activeCellNode).addClass("editable");var r=e||getEditor(activeRow,activeCell);e||r.suppressClearOnEdit||(activeCellNode.innerHTML=""),currentEditor=new r({grid:self,gridPosition:absBox($container[0]),position:absBox(activeCellNode),container:activeCellNode,column:l,item:n||{},event:t,commitChanges:commitEditAndSetFocus,cancelChanges:cancelEditAndSetFocus}),n&&(currentEditor.loadValue(n),o&&currentEditor.preClick&&currentEditor.preClick()),serializedEditorValue=currentEditor.serializeValue(),currentEditor.position&&handleActiveCellPositionChange()}else setFocus()}}}function commitEditAndSetFocus(){getEditorLock().commitCurrentEdit()&&(setFocus(),options.autoEdit&&navigateDown())}function cancelEditAndSetFocus(){getEditorLock().cancelCurrentEdit()&&setFocus()}function absBox(e){var o={top:e.offsetTop,left:e.offsetLeft,bottom:0,right:0,width:$(e).outerWidth(),height:$(e).outerHeight(),visible:!0};o.bottom=o.top+o.height,o.right=o.left+o.width;for(var t=e.offsetParent;(e=e.parentNode)!=document.body&&null!=e;)o.visible&&e.scrollHeight!=e.offsetHeight&&"visible"!=$(e).css("overflowY")&&(o.visible=o.bottom>e.scrollTop&&o.top<e.scrollTop+e.clientHeight),o.visible&&e.scrollWidth!=e.offsetWidth&&"visible"!=$(e).css("overflowX")&&(o.visible=o.right>e.scrollLeft&&o.left<e.scrollLeft+e.clientWidth),o.left-=e.scrollLeft,o.top-=e.scrollTop,e===t&&(o.left+=e.offsetLeft,o.top+=e.offsetTop,t=e.offsetParent),o.bottom=o.top+o.height,o.right=o.left+o.width;return o}function getActiveCellPosition(){return absBox(activeCellNode)}function getGridPosition(){return absBox($container[0])}function handleActiveCellPositionChange(){if(activeCellNode&&(trigger(self.onActiveCellPositionChanged,{}),currentEditor)){var e=getActiveCellPosition();currentEditor.show&&currentEditor.hide&&(e.visible?currentEditor.show():currentEditor.hide()),currentEditor.position&&currentEditor.position(e)}}function getCellEditor(){return currentEditor}function getActiveCell(){return activeCellNode?{row:activeRow,cell:activeCell}:null}function getActiveCellNode(){return activeCellNode}function scrollRowIntoView(e,o){var t=e*options.rowHeight,l=(e+1)*options.rowHeight-viewportH+(viewportHasHScroll?scrollbarDimensions.height:0);(e+1)*options.rowHeight>scrollTop+viewportH+offset?(scrollTo(o?t:l),render()):e*options.rowHeight<scrollTop+offset&&(scrollTo(o?l:t),render())}function scrollRowToTop(e){scrollTo(e*options.rowHeight),render()}function scrollPage(e){var o=e*numVisibleRows;if(scrollTo((getRowFromPosition(scrollTop)+o)*options.rowHeight),render(),options.enableCellNavigation&&null!=activeRow){var t=activeRow+o,l=getDataLengthIncludingAddNew();t>=l&&(t=l-1),t<0&&(t=0);for(var n=0,r=null,i=activePosX;n<=activePosX;)canCellBeActive(t,n)&&(r=n),n+=getColspan(t,n);null!==r?(setActiveCellInternal(getCellNode(t,r)),activePosX=i):resetActiveCell()}}function navigatePageDown(){scrollPage(1)}function navigatePageUp(){scrollPage(-1)}function navigateTop(){navigateToRow(0)}function navigateBottom(){navigateToRow(getDataLength()-1)}function navigateToRow(e){var o=getDataLength();if(!o)return!0;if(e<0?e=0:e>=o&&(e=o-1),scrollCellIntoView(e,0,!0),options.enableCellNavigation&&null!=activeRow){for(var t=0,l=null,n=activePosX;t<=activePosX;)canCellBeActive(e,t)&&(l=t),t+=getColspan(e,t);null!==l?(setActiveCellInternal(getCellNode(e,l)),activePosX=n):resetActiveCell()}return!0}function getColspan(e,o){var t=data.getItemMetadata&&data.getItemMetadata(e);if(!t||!t.columns)return 1;var l=t.columns[columns[o].id]||t.columns[o],n=l&&l.colspan;return n="*"===n?columns.length-o:n||1}function findFirstFocusableCell(e){for(var o=0;o<columns.length;){if(canCellBeActive(e,o))return o;o+=getColspan(e,o)}return null}function findLastFocusableCell(e){for(var o=0,t=null;o<columns.length;)canCellBeActive(e,o)&&(t=o),o+=getColspan(e,o);return t}function gotoRight(e,o,t){if(o>=columns.length)return null;do{o+=getColspan(e,o)}while(o<columns.length&&!canCellBeActive(e,o));return o<columns.length?{row:e,cell:o,posX:o}:null}function gotoLeft(e,o,t){if(o<=0)return null;var l=findFirstFocusableCell(e);if(null===l||l>=o)return null;for(var n,r={row:e,cell:l,posX:l};;){if(!(n=gotoRight(r.row,r.cell,r.posX)))return null;if(n.cell>=o)return r;r=n}}function gotoDown(e,o,t){for(var l,n=getDataLengthIncludingAddNew();;){if(++e>=n)return null;for(l=o=0;o<=t;)l=o,o+=getColspan(e,o);if(canCellBeActive(e,l))return{row:e,cell:l,posX:t}}}function gotoUp(e,o,t){for(var l;;){if(--e<0)return null;for(l=o=0;o<=t;)l=o,o+=getColspan(e,o);if(canCellBeActive(e,l))return{row:e,cell:l,posX:t}}}function gotoNext(e,o,t){if(null==e&&null==o&&canCellBeActive(e=o=t=0,o))return{row:e,cell:o,posX:o};var l=gotoRight(e,o,t);if(l)return l;var n=null,r=getDataLengthIncludingAddNew();for(e===r-1&&e--;++e<r;)if(null!==(n=findFirstFocusableCell(e)))return{row:e,cell:n,posX:n};return null}function gotoPrev(e,o,t){if(null==e&&null==o&&canCellBeActive(e=getDataLengthIncludingAddNew()-1,o=t=columns.length-1))return{row:e,cell:o,posX:o};for(var l,n;!l&&!(l=gotoLeft(e,o,t));){if(--e<0)return null;o=0,null!==(n=findLastFocusableCell(e))&&(l={row:e,cell:n,posX:n})}return l}function gotoRowStart(e,o,t){var l=findFirstFocusableCell(e);return null===l?null:{row:e,cell:l,posX:l}}function gotoRowEnd(e,o,t){var l=findLastFocusableCell(e);return null===l?null:{row:e,cell:l,posX:l}}function navigateRight(){return navigate("right")}function navigateLeft(){return navigate("left")}function navigateDown(){return navigate("down")}function navigateUp(){return navigate("up")}function navigateNext(){return navigate("next")}function navigatePrev(){return navigate("prev")}function navigateRowStart(){return navigate("home")}function navigateRowEnd(){return navigate("end")}function navigate(e){if(!options.enableCellNavigation)return!1;if(!activeCellNode&&"prev"!=e&&"next"!=e)return!1;if(!getEditorLock().commitCurrentEdit())return!0;setFocus();tabbingDirection={up:-1,down:1,left:-1,right:1,prev:-1,next:1,home:-1,end:1}[e];var o=(0,{up:gotoUp,down:gotoDown,left:gotoLeft,right:gotoRight,prev:gotoPrev,next:gotoNext,home:gotoRowStart,end:gotoRowEnd}[e])(activeRow,activeCell,activePosX);if(o){var t=o.row==getDataLength();return scrollCellIntoView(o.row,o.cell,!t&&options.emulatePagingWhenScrolling),setActiveCellInternal(getCellNode(o.row,o.cell)),activePosX=o.posX,!0}return setActiveCellInternal(getCellNode(activeRow,activeCell)),!1}function getCellNode(e,o){return rowsCache[e]?(ensureCellNodesInRowsCache(e),rowsCache[e].cellNodesByColumnIdx[o]):null}function setActiveCell(e,o,t,l,n){initialized&&(e>getDataLength()||e<0||o>=columns.length||o<0||options.enableCellNavigation&&(scrollCellIntoView(e,o,!1),setActiveCellInternal(getCellNode(e,o),t,l,n)))}function canCellBeActive(e,o){if(!options.enableCellNavigation||e>=getDataLengthIncludingAddNew()||e<0||o>=columns.length||o<0)return!1;var t=data.getItemMetadata&&data.getItemMetadata(e);if(t&&void 0!==t.focusable)return!!t.focusable;var l=t&&t.columns;return l&&l[columns[o].id]&&void 0!==l[columns[o].id].focusable?!!l[columns[o].id].focusable:l&&l[o]&&void 0!==l[o].focusable?!!l[o].focusable:!!columns[o].focusable}function canCellBeSelected(e,o){if(e>=getDataLength()||e<0||o>=columns.length||o<0)return!1;var t=data.getItemMetadata&&data.getItemMetadata(e);if(t&&void 0!==t.selectable)return!!t.selectable;var l=t&&t.columns&&(t.columns[columns[o].id]||t.columns[o]);return l&&void 0!==l.selectable?!!l.selectable:!!columns[o].selectable}function gotoCell(e,o,t,l){initialized&&(canCellBeActive(e,o)&&getEditorLock().commitCurrentEdit()&&(scrollCellIntoView(e,o,!1),setActiveCellInternal(getCellNode(e,o),t||e===getDataLength()||options.autoEdit,null,options.editable,l),currentEditor||setFocus()))}function commitCurrentEdit(){var e=getDataItem(activeRow),o=columns[activeCell];if(currentEditor){if(currentEditor.isValueChanged()){var t=currentEditor.validate();if(t.valid){if(activeRow<getDataLength()){var l={row:activeRow,cell:activeCell,editor:currentEditor,serializedValue:currentEditor.serializeValue(),prevSerializedValue:serializedEditorValue,execute:function(){this.editor.applyValue(e,this.serializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})},undo:function(){this.editor.applyValue(e,this.prevSerializedValue),updateRow(this.row),trigger(self.onCellChange,{row:this.row,cell:this.cell,item:e})}};options.editCommandHandler?(makeActiveCellNormal(),options.editCommandHandler(e,o,l)):(l.execute(),makeActiveCellNormal())}else{var n={};currentEditor.applyValue(n,currentEditor.serializeValue()),makeActiveCellNormal(),trigger(self.onAddNewRow,{item:n,column:o})}return!getEditorLock().isActive()}return $(activeCellNode).removeClass("invalid"),$(activeCellNode).width(),$(activeCellNode).addClass("invalid"),trigger(self.onValidationError,{editor:currentEditor,cellNode:activeCellNode,validationResults:t,row:activeRow,cell:activeCell,column:o}),currentEditor.focus(),!1}makeActiveCellNormal()}return!0}function cancelCurrentEdit(){return makeActiveCellNormal(),!0}function rowsToRanges(e){for(var o=[],t=columns.length-1,l=0;l<e.length;l++)o.push(new Slick.Range(e[l],0,e[l],t));return o}function getSelectedRows(){if(!selectionModel)throw new Error("Selection model is not set");return selectedRows}function setSelectedRows(e){if(!selectionModel)throw new Error("Selection model is not set");self&&self.getEditorLock&&!self.getEditorLock().isActive()&&selectionModel.setSelectedRanges(rowsToRanges(e))}this.debug=function(){var e="";e+="\ncounter_rows_rendered:  "+counter_rows_rendered,e+="\ncounter_rows_removed:  "+counter_rows_removed,e+="\nrenderedRows:  "+renderedRows,e+="\nnumVisibleRows:  "+numVisibleRows,e+="\nmaxSupportedCssHeight:  "+maxSupportedCssHeight,e+="\nn(umber of pages):  "+n,e+="\n(current) page:  "+page,e+="\npage height (ph):  "+ph,e+="\nvScrollDir:  "+vScrollDir,alert(e)},this.eval=function(expr){return eval(expr)},$.extend(this,{slickGridVersion:"2.3.23",onScroll:new Slick.Event,onSort:new Slick.Event,onHeaderMouseEnter:new Slick.Event,onHeaderMouseLeave:new Slick.Event,onHeaderContextMenu:new Slick.Event,onHeaderClick:new Slick.Event,onHeaderCellRendered:new Slick.Event,onBeforeHeaderCellDestroy:new Slick.Event,onHeaderRowCellRendered:new Slick.Event,onFooterRowCellRendered:new Slick.Event,onBeforeHeaderRowCellDestroy:new Slick.Event,onBeforeFooterRowCellDestroy:new Slick.Event,onMouseEnter:new Slick.Event,onMouseLeave:new Slick.Event,onClick:new Slick.Event,onDblClick:new Slick.Event,onContextMenu:new Slick.Event,onKeyDown:new Slick.Event,onAddNewRow:new Slick.Event,onBeforeAppendCell:new Slick.Event,onValidationError:new Slick.Event,onViewportChanged:new Slick.Event,onColumnsReordered:new Slick.Event,onColumnsResized:new Slick.Event,onCellChange:new Slick.Event,onBeforeEditCell:new Slick.Event,onBeforeCellEditorDestroy:new Slick.Event,onBeforeDestroy:new Slick.Event,onActiveCellChanged:new Slick.Event,onActiveCellPositionChanged:new Slick.Event,onDragInit:new Slick.Event,onDragStart:new Slick.Event,onDrag:new Slick.Event,onDragEnd:new Slick.Event,onSelectedRowsChanged:new Slick.Event,onCellCssStylesChanged:new Slick.Event,onAutosizeColumns:new Slick.Event,onRendered:new Slick.Event,registerPlugin:registerPlugin,unregisterPlugin:unregisterPlugin,getColumns:getColumns,setColumns:setColumns,getColumnIndex:getColumnIndex,updateColumnHeader:updateColumnHeader,setSortColumn:setSortColumn,setSortColumns:setSortColumns,getSortColumns:getSortColumns,autosizeColumns:autosizeColumns,getOptions:getOptions,setOptions:setOptions,getData:getData,getDataLength:getDataLength,getDataItem:getDataItem,setData:setData,getSelectionModel:getSelectionModel,setSelectionModel:setSelectionModel,getSelectedRows:getSelectedRows,setSelectedRows:setSelectedRows,getContainerNode:getContainerNode,updatePagingStatusFromView:updatePagingStatusFromView,render:render,invalidate:invalidate,invalidateRow:invalidateRow,invalidateRows:invalidateRows,invalidateAllRows:invalidateAllRows,updateCell:updateCell,updateRow:updateRow,getViewport:getVisibleRange,getRenderedRange:getRenderedRange,resizeCanvas:resizeCanvas,updateRowCount:updateRowCount,scrollRowIntoView:scrollRowIntoView,scrollRowToTop:scrollRowToTop,scrollCellIntoView:scrollCellIntoView,scrollColumnIntoView:scrollColumnIntoView,getCanvasNode:getCanvasNode,getUID:getUID,getHeaderColumnWidthDiff:getHeaderColumnWidthDiff,getScrollbarDimensions:getScrollbarDimensions,getHeadersWidth:getHeadersWidth,getCanvasWidth:getCanvasWidth,focus:setFocus,scrollTo:scrollTo,getCellFromPoint:getCellFromPoint,getCellFromEvent:getCellFromEvent,getActiveCell:getActiveCell,setActiveCell:setActiveCell,getActiveCellNode:getActiveCellNode,getActiveCellPosition:getActiveCellPosition,resetActiveCell:resetActiveCell,editActiveCell:makeActiveCellEditable,getCellEditor:getCellEditor,getCellNode:getCellNode,getCellNodeBox:getCellNodeBox,canCellBeSelected:canCellBeSelected,canCellBeActive:canCellBeActive,navigatePrev:navigatePrev,navigateNext:navigateNext,navigateUp:navigateUp,navigateDown:navigateDown,navigateLeft:navigateLeft,navigateRight:navigateRight,navigatePageUp:navigatePageUp,navigatePageDown:navigatePageDown,navigateTop:navigateTop,navigateBottom:navigateBottom,navigateRowStart:navigateRowStart,navigateRowEnd:navigateRowEnd,gotoCell:gotoCell,getTopPanel:getTopPanel,setTopPanelVisibility:setTopPanelVisibility,getPreHeaderPanel:getPreHeaderPanel,setPreHeaderPanelVisibility:setPreHeaderPanelVisibility,getHeader:getHeader,getHeaderColumn:getHeaderColumn,setHeaderRowVisibility:setHeaderRowVisibility,getHeaderRow:getHeaderRow,getHeaderRowColumn:getHeaderRowColumn,setFooterRowVisibility:setFooterRowVisibility,getFooterRow:getFooterRow,getFooterRowColumn:getFooterRowColumn,getGridPosition:getGridPosition,flashCell:flashCell,addCellCssStyles:addCellCssStyles,setCellCssStyles:setCellCssStyles,removeCellCssStyles:removeCellCssStyles,getCellCssStyles:getCellCssStyles,init:finishInitialization,destroy:destroy,getEditorLock:getEditorLock,getEditController:getEditController}),init()}module.exports={Grid:SlickGrid}},
526: function _(t,e,a){
/*!
     * jquery.event.drag - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var n=t(519);n.fn.drag=function(t,e,a){var r="string"==typeof t?t:"",o=n.isFunction(t)?t:n.isFunction(e)?e:null;return 0!==r.indexOf("drag")&&(r="drag"+r),a=(t==o?e:a)||{},o?this.on(r,a,o):this.trigger(r)};var r=n.event,o=r.special,i=o.drag={defaults:{which:1,distance:0,not:":input",handle:null,relative:!1,drop:!0,click:!1},datakey:"dragdata",noBubble:!0,add:function(t){var e=n.data(this,i.datakey),a=t.data||{};e.related+=1,n.each(i.defaults,function(t,n){void 0!==a[t]&&(e[t]=a[t])})},remove:function(){n.data(this,i.datakey).related-=1},setup:function(){if(!n.data(this,i.datakey)){var t=n.extend({related:0},i.defaults);n.data(this,i.datakey,t),r.add(this,"touchstart mousedown",i.init,t),this.attachEvent&&this.attachEvent("ondragstart",i.dontstart)}},teardown:function(){(n.data(this,i.datakey)||{}).related||(n.removeData(this,i.datakey),r.remove(this,"touchstart mousedown",i.init),i.textselect(!0),this.detachEvent&&this.detachEvent("ondragstart",i.dontstart))},init:function(t){if(!i.touched){var e,a=t.data;if(!(0!=t.which&&a.which>0&&t.which!=a.which)&&!n(t.target).is(a.not)&&(!a.handle||n(t.target).closest(a.handle,t.currentTarget).length)&&(i.touched="touchstart"==t.type?this:null,a.propagates=1,a.mousedown=this,a.interactions=[i.interaction(this,a)],a.target=t.target,a.pageX=t.pageX,a.pageY=t.pageY,a.dragging=null,e=i.hijack(t,"draginit",a),a.propagates))return(e=i.flatten(e))&&e.length&&(a.interactions=[],n.each(e,function(){a.interactions.push(i.interaction(this,a))})),a.propagates=a.interactions.length,!1!==a.drop&&o.drop&&o.drop.handler(t,a),i.textselect(!1),i.touched?r.add(i.touched,"touchmove touchend",i.handler,a):r.add(document,"mousemove mouseup",i.handler,a),!(!i.touched||a.live)&&void 0}},interaction:function(t,e){var a=t&&t.ownerDocument&&n(t)[e.relative?"position":"offset"]()||{top:0,left:0};return{drag:t,callback:new i.callback,droppable:[],offset:a}},handler:function(t){var e=t.data;switch(t.type){case!e.dragging&&"touchmove":t.preventDefault();case!e.dragging&&"mousemove":if(Math.pow(t.pageX-e.pageX,2)+Math.pow(t.pageY-e.pageY,2)<Math.pow(e.distance,2))break;t.target=e.target,i.hijack(t,"dragstart",e),e.propagates&&(e.dragging=!0);case"touchmove":t.preventDefault();case"mousemove":if(e.dragging){if(i.hijack(t,"drag",e),e.propagates){!1!==e.drop&&o.drop&&o.drop.handler(t,e);break}t.type="mouseup"}case"touchend":case"mouseup":default:i.touched?r.remove(i.touched,"touchmove touchend",i.handler):r.remove(document,"mousemove mouseup",i.handler),e.dragging&&(!1!==e.drop&&o.drop&&o.drop.handler(t,e),i.hijack(t,"dragend",e)),i.textselect(!0),!1===e.click&&e.dragging&&n.data(e.mousedown,"suppress.click",(new Date).getTime()+5),e.dragging=i.touched=!1}},hijack:function(t,e,a,o,d){if(a){var s,c,l,p={event:t.originalEvent,type:t.type},u=e.indexOf("drop")?"drag":"drop",g=o||0,h=isNaN(o)?a.interactions.length:o;t.type=e;var f=function(){};t.originalEvent=new n.Event(p.event,{preventDefault:f,stopPropagation:f,stopImmediatePropagation:f}),a.results=[];do{if(c=a.interactions[g]){if("dragend"!==e&&c.cancelled)continue;l=i.properties(t,a,c),c.results=[],n(d||c[u]||a.droppable).each(function(o,d){if(l.target=d,t.isPropagationStopped=function(){return!1},!1===(s=d?r.dispatch.call(d,t,l):null)?("drag"==u&&(c.cancelled=!0,a.propagates-=1),"drop"==e&&(c[u][o]=null)):"dropinit"==e&&c.droppable.push(i.element(s)||d),"dragstart"==e&&(c.proxy=n(i.element(s)||c.drag)[0]),c.results.push(s),delete t.result,"dropinit"!==e)return s}),a.results[g]=i.flatten(c.results),"dropinit"==e&&(c.droppable=i.flatten(c.droppable)),"dragstart"!=e||c.cancelled||l.update()}}while(++g<h);return t.type=p.type,t.originalEvent=p.event,i.flatten(a.results)}},properties:function(t,e,a){var n=a.callback;return n.drag=a.drag,n.proxy=a.proxy||a.drag,n.startX=e.pageX,n.startY=e.pageY,n.deltaX=t.pageX-e.pageX,n.deltaY=t.pageY-e.pageY,n.originalX=a.offset.left,n.originalY=a.offset.top,n.offsetX=n.originalX+n.deltaX,n.offsetY=n.originalY+n.deltaY,n.drop=i.flatten((a.drop||[]).slice()),n.available=i.flatten((a.droppable||[]).slice()),n},element:function(t){if(t&&(t.jquery||1==t.nodeType))return t},flatten:function(t){return n.map(t,function(t){return t&&t.jquery?n.makeArray(t):t&&t.length?i.flatten(t):t})},textselect:function(t){n(document)[t?"off":"on"]("selectstart",i.dontstart).css("MozUserSelect",t?"":"none"),document.unselectable=t?"off":"on"},dontstart:function(){return!1},callback:function(){}};i.callback.prototype={update:function(){o.drop&&this.available.length&&n.each(this.available,function(t){o.drop.locate(this,t)})}};var d=r.dispatch;r.dispatch=function(t){if(!(n.data(this,"suppress."+t.type)-(new Date).getTime()>0))return d.apply(this,arguments);n.removeData(this,"suppress."+t.type)},o.draginit=o.dragstart=o.dragend=i},
527: function _(t,e,a){
/*!
     * jquery.event.drop - v 2.3.0
     * Copyright (c) 2010 Three Dub Media - http://threedubmedia.com
     * Open Source MIT License - http://threedubmedia.com/code/license
     */
var n=t(519);n.fn.drop=function(t,e,a){var i="string"==typeof t?t:"",o=n.isFunction(t)?t:n.isFunction(e)?e:null;return 0!==i.indexOf("drop")&&(i="drop"+i),a=(t==o?e:a)||{},o?this.on(i,a,o):this.trigger(i)},n.drop=function(t){t=t||{},o.multi=!0===t.multi?1/0:!1===t.multi?1:isNaN(t.multi)?o.multi:t.multi,o.delay=t.delay||o.delay,o.tolerance=n.isFunction(t.tolerance)?t.tolerance:null===t.tolerance?null:o.tolerance,o.mode=t.mode||o.mode||"intersect"};var i=n.event.special,o=n.event.special.drop={multi:1,delay:20,mode:"overlap",targets:[],datakey:"dropdata",noBubble:!0,add:function(t){n.data(this,o.datakey).related+=1},remove:function(){n.data(this,o.datakey).related-=1},setup:function(){if(!n.data(this,o.datakey)){n.data(this,o.datakey,{related:0,active:[],anyactive:0,winner:0,location:{}}),o.targets.push(this)}},teardown:function(){if(!(n.data(this,o.datakey)||{}).related){n.removeData(this,o.datakey);var t=this;o.targets=n.grep(o.targets,function(e){return e!==t})}},handler:function(t,e){var a;if(e)switch(t.type){case"mousedown":case"touchstart":a=n(o.targets),"string"==typeof e.drop&&(a=a.filter(e.drop)),a.each(function(){var t=n.data(this,o.datakey);t.active=[],t.anyactive=0,t.winner=0}),e.droppable=a,i.drag.hijack(t,"dropinit",e);break;case"mousemove":case"touchmove":o.event=t,o.timer||o.tolerate(e);break;case"mouseup":case"touchend":o.timer=clearTimeout(o.timer),e.propagates&&(i.drag.hijack(t,"drop",e),i.drag.hijack(t,"dropend",e))}},locate:function(t,e){var a=n.data(t,o.datakey),i=n(t),r=i.offset()||{},d=i.outerHeight(),l=i.outerWidth(),c={elem:t,width:l,height:d,top:r.top,left:r.left,right:r.left+l,bottom:r.top+d};return a&&(a.location=c,a.index=e,a.elem=t),c},contains:function(t,e){return(e[0]||e.left)>=t.left&&(e[0]||e.right)<=t.right&&(e[1]||e.top)>=t.top&&(e[1]||e.bottom)<=t.bottom},modes:{intersect:function(t,e,a){return this.contains(a,[t.pageX,t.pageY])?1e9:this.modes.overlap.apply(this,arguments)},overlap:function(t,e,a){return Math.max(0,Math.min(a.bottom,e.bottom)-Math.max(a.top,e.top))*Math.max(0,Math.min(a.right,e.right)-Math.max(a.left,e.left))},fit:function(t,e,a){return this.contains(a,e)?1:0},middle:function(t,e,a){return this.contains(a,[e.left+.5*e.width,e.top+.5*e.height])?1:0}},sort:function(t,e){return e.winner-t.winner||t.index-e.index},tolerate:function(t){var e,a,r,d,l,c,s,u,p=0,h=t.interactions.length,m=[o.event.pageX,o.event.pageY],f=o.tolerance||o.modes[o.mode];do{if(u=t.interactions[p]){if(!u)return;u.drop=[],l=[],c=u.droppable.length,f&&(r=o.locate(u.proxy)),e=0;do{if(s=u.droppable[e]){if(!(a=(d=n.data(s,o.datakey)).location))continue;d.winner=f?f.call(o,o.event,r,a):o.contains(a,m)?1:0,l.push(d)}}while(++e<c);l.sort(o.sort),e=0;do{(d=l[e])&&(d.winner&&u.drop.length<o.multi?(d.active[p]||d.anyactive||(!1!==i.drag.hijack(o.event,"dropstart",t,p,d.elem)[0]?(d.active[p]=1,d.anyactive+=1):d.winner=0),d.winner&&u.drop.push(d.elem)):d.active[p]&&1==d.anyactive&&(i.drag.hijack(o.event,"dropend",t,p,d.elem),d.active[p]=0,d.anyactive-=1))}while(++e<c)}}while(++p<h);o.last&&m[0]==o.last.pageX&&m[1]==o.last.pageY?delete o.timer:o.timer=setTimeout(function(){o.tolerate(t)},o.delay),o.last=o.event}};i.dropinit=i.dropstart=i.dropend=o},
528: function _(t,e,n){var r=t(519),i=t(521);var o={Avg:function(t){this.field_=t,this.init=function(){this.count_=0,this.nonNullCount_=0,this.sum_=0},this.accumulate=function(t){var e=t[this.field_];this.count_++,null==e||""===e||isNaN(e)||(this.nonNullCount_++,this.sum_+=parseFloat(e))},this.storeResult=function(t){t.avg||(t.avg={}),0!=this.nonNullCount_&&(t.avg[this.field_]=this.sum_/this.nonNullCount_)}},Min:function(t){this.field_=t,this.init=function(){this.min_=null},this.accumulate=function(t){var e=t[this.field_];null==e||""===e||isNaN(e)||(null==this.min_||e<this.min_)&&(this.min_=e)},this.storeResult=function(t){t.min||(t.min={}),t.min[this.field_]=this.min_}},Max:function(t){this.field_=t,this.init=function(){this.max_=null},this.accumulate=function(t){var e=t[this.field_];null==e||""===e||isNaN(e)||(null==this.max_||e>this.max_)&&(this.max_=e)},this.storeResult=function(t){t.max||(t.max={}),t.max[this.field_]=this.max_}},Sum:function(t){this.field_=t,this.init=function(){this.sum_=null},this.accumulate=function(t){var e=t[this.field_];null==e||""===e||isNaN(e)||(this.sum_+=parseFloat(e))},this.storeResult=function(t){t.sum||(t.sum={}),t.sum[this.field_]=this.sum_}}};e.exports={DataView:function(t){var e,n,o,a,l,s=this,u="id",g=[],c=[],f={},p=null,h=null,d=null,m=!1,v=!0,_={},w={},$=[],y=[],I={getter:null,formatter:null,comparer:function(t,e){return t.value===e.value?0:t.value>e.value?1:-1},predefinedValues:[],aggregators:[],aggregateEmpty:!1,aggregateCollapsed:!1,aggregateChildGroups:!1,collapsed:!1,displayTotalsRow:!0,lazyTotalsCalculation:!1},C=[],R=[],x=[],b=":|:",M=0,F=0,A=0,S=new i.Event,N=new i.Event,E=new i.Event;function T(t){for(var e,n=t=t||0,r=g.length;n<r;n++){if(void 0===(e=g[n][u]))throw new Error("Each data element must implement a unique 'id' property");f[e]=n}}function G(){var t=M?Math.max(1,Math.ceil(A/M)):1;return{pageSize:M,pageNum:F,totalRows:A,totalPages:t,dataView:s}}function D(t,r){v=r,n=t,e=null,!1===r&&g.reverse(),g.sort(t),!1===r&&g.reverse(),f={},T(),Z()}function P(t,r){v=r,e=t,n=null;var i=Object.prototype.toString;Object.prototype.toString="function"==typeof t?t:function(){return this[t]},!1===r&&g.reverse(),g.sort(),Object.prototype.toString=i,!1===r&&g.reverse(),f={},T(),Z()}function j(e){t.groupItemMetadataProvider||(t.groupItemMetadataProvider=new i.Data.GroupItemMetadataProvider),R=[],x=[],C=(e=e||[])instanceof Array?e:[e];for(var n=0;n<C.length;n++){var o=C[n]=r.extend(!0,{},I,C[n]);o.getterIsAFn="function"==typeof o.getter,o.compiledAccumulators=[];for(var a=o.aggregators.length;a--;)o.compiledAccumulators[a]=(l=o.aggregators[a],s=void 0,u=void 0,s=W(l.accumulate),(u=new Function("_items","for (var "+s.params[0]+", _i=0, _il=_items.length; _i<_il; _i++) {"+s.params[0]+" = _items[_i]; "+s.body+"}")).displayName=u.name="compiledAccumulatorLoop",u);x[n]={}}var l,s,u;Z()}function z(){if(!p){p={};for(var t=0,e=c.length;t<e;t++)p[c[t][u]]=t}}function B(t){return g[f[t]]}function V(t,e){if(void 0===f[t]||t!==e[u])throw new Error("Invalid or non-matching id");g[f[t]]=e,d||(d={}),d[t]=!0,Z()}function O(t,e){g.splice(t,0,e),T(t),Z()}function q(t){var e=f[t];if(void 0===e)throw new Error("Invalid id");delete f[t],g.splice(e,1),T(e),Z()}function K(t){if(!n)throw new Error("sortedAddItem() requires a sort comparer, use sort()");O(function(t){for(var e=0,r=g.length;e<r;){var i=e+r>>>1;-1===n(g[i],t)?e=i+1:r=i}return e}(t),t)}function U(t,e){if(null==t)for(var n=0;n<C.length;n++)x[n]={},C[n].collapsed=e;else x[t]={},C[t].collapsed=e;Z()}function L(t,e,n){x[t][e]=C[t].collapsed^n,Z()}function k(t){var e,n=t.group,r=C[n.level],i=n.level==C.length,o=r.aggregators.length;if(!i&&r.aggregateChildGroups)for(var a=n.groups.length;a--;)n.groups[a].totals.initialized||k(n.groups[a].totals);for(;o--;)(e=r.aggregators[o]).init(),!i&&r.aggregateChildGroups?r.compiledAccumulators[o].call(e,n.groups):r.compiledAccumulators[o].call(e,n.rows),e.storeResult(t);t.initialized=!0}function H(t){var e=C[t.level],n=new i.GroupTotals;n.group=t,t.totals=n,e.lazyTotalsCalculation||k(n)}function W(t){var e=t.toString().match(/^function[^(]*\(([^)]*)\)\s*{([\s\S]*)}$/);return{params:e[1].split(","),body:e[2]}}function J(t,e){for(var n=[],r=0,i=0,o=t.length;i<o;i++)h(t[i],e)&&(n[r++]=t[i]);return n}function Q(t,e,n){for(var r,i=[],o=0,a=0,l=t.length;a<l;a++)r=t[a],n[a]?i[o++]=r:h(r,e)&&(i[o++]=r,n[a]=!0);return i}function X(e){if(h){var n=t.inlineFilters?a:J,r=t.inlineFilters?l:Q;_.isFilterNarrowing?$=n($,o):_.isFilterExpanding?$=r(e,o,y):_.isFilterUnchanged||($=n(e,o))}else $=M?e:e.concat();var i;return M?($.length<=F*M&&(F=0===$.length?0:Math.floor(($.length-1)/M)),i=$.slice(M*F,M*F+M)):i=$,{totalRows:$.length,rows:i}}function Y(t){p=null,_.isFilterNarrowing==w.isFilterNarrowing&&_.isFilterExpanding==w.isFilterExpanding||(y=[]);var e=X(t);A=e.totalRows;var n=e.rows;R=[],C.length&&(R=function t(e,n){for(var r,o,a,l=[],s={},u=n?n.level+1:0,g=C[u],c=0,f=g.predefinedValues.length;c<f;c++)(r=s[o=g.predefinedValues[c]])||((r=new i.Group).value=o,r.level=u,r.groupingKey=(n?n.groupingKey+b:"")+o,l[l.length]=r,s[o]=r);for(c=0,f=e.length;c<f;c++)a=e[c],(r=s[o=g.getterIsAFn?g.getter(a):a[g.getter]])||((r=new i.Group).value=o,r.level=u,r.groupingKey=(n?n.groupingKey+b:"")+o,l[l.length]=r,s[o]=r),r.rows[r.count++]=a;if(u<C.length-1)for(c=0;c<l.length;c++)(r=l[c]).groups=t(r.rows,r);return l.sort(C[u].comparer),l}(n)).length&&(function t(e,n){for(var r,i=C[n=n||0],o=i.collapsed,a=x[n],l=e.length;l--;)(r=e[l]).collapsed&&!i.aggregateCollapsed||(r.groups&&t(r.groups,n+1),i.aggregators.length&&(i.aggregateEmpty||r.rows.length||r.groups&&r.groups.length)&&H(r),r.collapsed=o^a[r.groupingKey],r.title=i.formatter?i.formatter(r):r.value)}(R),n=function t(e,n){for(var r,i,o=C[n=n||0],a=[],l=0,s=0,u=e.length;s<u;s++){if(i=e[s],a[l++]=i,!i.collapsed)for(var g=0,c=(r=i.groups?t(i.groups,n+1):i.rows).length;g<c;g++)a[l++]=r[g];i.totals&&o.displayTotalsRow&&(!i.collapsed||o.aggregateCollapsed)&&(a[l++]=i.totals)}return a}(R));var r=function(t,e){var n,r,i,o=[],a=0,l=e.length;_&&_.ignoreDiffsBefore&&(a=Math.max(0,Math.min(e.length,_.ignoreDiffsBefore))),_&&_.ignoreDiffsAfter&&(l=Math.min(e.length,Math.max(0,_.ignoreDiffsAfter)));for(var s=a,g=t.length;s<l;s++)s>=g?o[o.length]=s:(n=e[s],r=t[s],(C.length&&(i=n.__nonDataRow||r.__nonDataRow)&&n.__group!==r.__group||n.__group&&!n.equals(r)||i&&(n.__groupTotals||r.__groupTotals)||n[u]!=r[u]||d&&d[n[u]])&&(o[o.length]=s));return o}(c,n);return c=n,r}function Z(){if(!m){var t=c.length,e=A,n=Y(g);M&&A<F*M&&(F=Math.max(0,Math.ceil(A/M)-1),n=Y(g)),d=null,w=_,_={},e!==A&&E.notify(G(),null,s),t!==c.length&&S.notify({previous:t,current:c.length,dataView:s},null,s),n.length>0&&N.notify({rows:n,dataView:s},null,s)}}t=r.extend(!0,{},{groupItemMetadataProvider:null,inlineFilters:!1},t),r.extend(this,{beginUpdate:function(){m=!0},endUpdate:function(){m=!1,Z()},setPagingOptions:function(t){null!=t.pageSize&&(M=t.pageSize,F=M?Math.min(F,Math.max(0,Math.ceil(A/M)-1)):0),null!=t.pageNum&&(F=Math.min(t.pageNum,Math.max(0,Math.ceil(A/M)-1))),E.notify(G(),null,s),Z()},getPagingInfo:G,getItems:function(){return g},setItems:function(t,e){void 0!==e&&(u=e),g=$=t,f={},T(),function(){for(var t,e=0,n=g.length;e<n;e++)if(void 0===(t=g[e][u])||f[t]!==e)throw new Error("Each data element must implement a unique 'id' property")}(),Z()},setFilter:function(e){h=e,t.inlineFilters&&(a=function(){var t=W(h),e="{ _retval[_idx++] = $item$; continue _coreloop; }$1",n=t.body.replace(/return false\s*([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return!1([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return true\s*([;}]|\}|$)/gi,e).replace(/return!0([;}]|\}|$)/gi,e).replace(/return ([^;}]+?)\s*([;}]|$)/gi,"{ if ($1) { _retval[_idx++] = $item$; }; continue _coreloop; }$2"),r=["var _retval = [], _idx = 0; ","var $item$, $args$ = _args; ","_coreloop: ","for (var _i = 0, _il = _items.length; _i < _il; _i++) { ","$item$ = _items[_i]; ","$filter$; ","} ","return _retval; "].join("");r=(r=(r=r.replace(/\$filter\$/gi,n)).replace(/\$item\$/gi,t.params[0])).replace(/\$args\$/gi,t.params[1]);var i=new Function("_items,_args",r);return i.displayName=i.name="compiledFilter",i}(),l=function(){var t=W(h),e="{ _cache[_i] = true;_retval[_idx++] = $item$; continue _coreloop; }$1",n=t.body.replace(/return false\s*([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return!1([;}]|\}|$)/gi,"{ continue _coreloop; }$1").replace(/return true\s*([;}]|\}|$)/gi,e).replace(/return!0([;}]|\}|$)/gi,e).replace(/return ([^;}]+?)\s*([;}]|$)/gi,"{ if ((_cache[_i] = $1)) { _retval[_idx++] = $item$; }; continue _coreloop; }$2"),r=["var _retval = [], _idx = 0; ","var $item$, $args$ = _args; ","_coreloop: ","for (var _i = 0, _il = _items.length; _i < _il; _i++) { ","$item$ = _items[_i]; ","if (_cache[_i]) { ","_retval[_idx++] = $item$; ","continue _coreloop; ","} ","$filter$; ","} ","return _retval; "].join("");r=(r=(r=r.replace(/\$filter\$/gi,n)).replace(/\$item\$/gi,t.params[0])).replace(/\$args\$/gi,t.params[1]);var i=new Function("_items,_args,_cache",r);return i.displayName=i.name="compiledFilterWithCaching",i}()),Z()},getFilter:function(){return h},getFilteredItems:function(){return $},sort:D,fastSort:P,reSort:function(){n?D(n,v):e&&P(e,v)},setGrouping:j,getGrouping:function(){return C},groupBy:function(t,e,n){j(null!=t?{getter:t,formatter:e,comparer:n}:[])},setAggregators:function(t,e){if(!C.length)throw new Error("At least one grouping must be specified before calling setAggregators().");C[0].aggregators=t,C[0].aggregateCollapsed=e,j(C)},collapseAllGroups:function(t){U(t,!0)},expandAllGroups:function(t){U(t,!1)},collapseGroup:function(t){var e=Array.prototype.slice.call(arguments),n=e[0];1==e.length&&-1!=n.indexOf(b)?L(n.split(b).length-1,n,!0):L(e.length-1,e.join(b),!0)},expandGroup:function(t){var e=Array.prototype.slice.call(arguments),n=e[0];1==e.length&&-1!=n.indexOf(b)?L(n.split(b).length-1,n,!1):L(e.length-1,e.join(b),!1)},getGroups:function(){return R},getIdxById:function(t){return f[t]},getRowByItem:function(t){return z(),p[t[u]]},getRowById:function(t){return z(),p[t]},getItemById:B,getItemByIdx:function(t){return g[t]},mapItemsToRows:function(t){var e=[];z();for(var n=0,r=t.length;n<r;n++){var i=p[t[n][u]];null!=i&&(e[e.length]=i)}return e},mapRowsToIds:function(t){for(var e=[],n=0,r=t.length;n<r;n++)t[n]<c.length&&(e[e.length]=c[t[n]][u]);return e},mapIdsToRows:function(t){var e=[];z();for(var n=0,r=t.length;n<r;n++){var i=p[t[n]];null!=i&&(e[e.length]=i)}return e},setRefreshHints:function(t){_=t},setFilterArgs:function(t){o=t},refresh:Z,updateItem:V,insertItem:O,addItem:function(t){g.push(t),T(g.length-1),Z()},deleteItem:q,sortedAddItem:K,sortedUpdateItem:function(t,e){if(void 0===f[t]||t!==e[u])throw new Error("Invalid or non-matching id "+f[t]);if(!n)throw new Error("sortedUpdateItem() requires a sort comparer, use sort()");var r=B(t);0!==n(r,e)?(q(t),K(e)):V(t,e)},syncGridSelection:function(t,e,n){var o,a=this,l=a.mapRowsToIds(t.getSelectedRows()),s=new i.Event;function u(e){l.join(",")!=e.join(",")&&(l=e,s.notify({grid:t,ids:l,dataView:a},new i.EventData,a))}function g(){if(l.length>0){o=!0;var n=a.mapIdsToRows(l);e||u(a.mapRowsToIds(n)),t.setSelectedRows(n),o=!1}}return t.onSelectedRowsChanged.subscribe(function(e,i){if(!o){var s=a.mapRowsToIds(t.getSelectedRows());n&&t.getOptions().multiSelect?u(r.grep(l,function(t){return void 0===a.getRowById(t)}).concat(s)):u(s)}}),this.onRowsChanged.subscribe(g),this.onRowCountChanged.subscribe(g),s},syncGridCellCssStyles:function(t,e){var n,r;function i(t){for(var e in n={},t){var r=c[e][u];n[r]=t[e]}}function o(){if(n){r=!0,z();var i={};for(var o in n){var a=p[o];null!=a&&(i[a]=n[o])}t.setCellCssStyles(e,i),r=!1}}i(t.getCellCssStyles(e)),t.onCellCssStylesChanged.subscribe(function(n,a){r||e==a.key&&(a.hash?i(a.hash):(t.onCellCssStylesChanged.unsubscribe(styleChanged),s.onRowsChanged.unsubscribe(o),s.onRowCountChanged.unsubscribe(o)))}),this.onRowsChanged.subscribe(o),this.onRowCountChanged.subscribe(o)},getLength:function(){return c.length},getItem:function(t){var e=c[t];if(e&&e.__group&&e.totals&&!e.totals.initialized){var n=C[e.level];n.displayTotalsRow||(k(e.totals),e.title=n.formatter?n.formatter(e):e.value)}else e&&e.__groupTotals&&!e.initialized&&k(e);return e},getItemMetadata:function(e){var n=c[e];return void 0===n?null:n.__group?t.groupItemMetadataProvider.getGroupRowMetadata(n):n.__groupTotals?t.groupItemMetadataProvider.getTotalsRowMetadata(n):null},onRowCountChanged:S,onRowsChanged:N,onPagingInfoChanged:E})},Aggregators:o,Data:{Aggregators:o}}},
529: function _(e,t,i){var n=e(519),o=e(521);function l(e){var t,i;function o(){var t=e.column.editorFixedDecimalPlaces;return void 0===t&&(t=l.DefaultDecimalPlaces),t||0===t?t:null}this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=n("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?a:s).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){i=n[e.column.field];var l=o();null!==l&&(i||0===i)&&i.toFixed&&(i=i.toFixed(l)),t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){var e=parseFloat(t.val());l.AllowEmptyValue?e||0===e||(e=""):e=e||0;var i=o();return null!==i&&(e||0===e)&&e.toFixed&&(e=parseFloat(e.toFixed(i))),e},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(isNaN(t.val()))return{valid:!1,msg:"Please enter a valid number"};if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()}function a(e){var t=this.selectionStart,i=this.value.length;(e.keyCode===n.ui.keyCode.LEFT&&t>0||e.keyCode===n.ui.keyCode.RIGHT&&t<i-1)&&e.stopImmediatePropagation()}function s(e){e.keyCode!==n.ui.keyCode.LEFT&&e.keyCode!==n.ui.keyCode.RIGHT||e.stopImmediatePropagation()}l.DefaultDecimalPlaces=null,l.AllowEmptyValue=!1,t.exports={Editors:{Text:function(e){var t,i;this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=n("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?a:s).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.getValue=function(){return t.val()},this.setValue=function(e){t.val(e)},this.loadValue=function(n){i=n[e.column.field]||"",t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},Integer:function(e){var t,i;this.init=function(){var i=e.grid.getOptions().editorCellNavOnLRKeys;t=n("<INPUT type=text class='editor-text' />").appendTo(e.container).on("keydown.nav",i?a:s).focus().select()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){i=n[e.column.field],t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return parseInt(t.val(),10)||0},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(isNaN(t.val()))return{valid:!1,msg:"Please enter a valid integer"};if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},Float:l,Date:function(e){var t,i,o=!1;this.init=function(){(t=n("<INPUT type=text class='editor-text' />")).appendTo(e.container),t.focus().select(),t.datepicker({showOn:"button",buttonImageOnly:!0,beforeShow:function(){o=!0},onClose:function(){o=!1}}),t.width(t.width()-18)},this.destroy=function(){n.datepicker.dpDiv.stop(!0,!0),t.datepicker("hide"),t.datepicker("destroy"),t.remove()},this.show=function(){o&&n.datepicker.dpDiv.stop(!0,!0).show()},this.hide=function(){o&&n.datepicker.dpDiv.stop(!0,!0).hide()},this.position=function(e){o&&n.datepicker.dpDiv.css("top",e.top+30).css("left",e.left)},this.focus=function(){t.focus()},this.loadValue=function(n){i=n[e.column.field],t.val(i),t[0].defaultValue=i,t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==i)&&t.val()!=i},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()},YesNoSelect:function(e){var t,i;this.init=function(){(t=n("<SELECT tabIndex='0' class='editor-yesno'><OPTION value='yes'>Yes</OPTION><OPTION value='no'>No</OPTION></SELECT>")).appendTo(e.container),t.focus()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){t.val((i=n[e.column.field])?"yes":"no"),t.select()},this.serializeValue=function(){return"yes"==t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return t.val()!=i},this.validate=function(){return{valid:!0,msg:null}},this.init()},Checkbox:function(e){var t,i;this.init=function(){(t=n("<INPUT type=checkbox value='true' class='editor-checkbox' hideFocus>")).appendTo(e.container),t.focus()},this.destroy=function(){t.remove()},this.focus=function(){t.focus()},this.loadValue=function(n){(i=!!n[e.column.field])?t.prop("checked",!0):t.prop("checked",!1)},this.preClick=function(){t.prop("checked",!t.prop("checked"))},this.serializeValue=function(){return t.prop("checked")},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return this.serializeValue()!==i},this.validate=function(){return{valid:!0,msg:null}},this.init()},PercentComplete:function(e){var t,i,o;this.init=function(){(t=n("<INPUT type=text class='editor-percentcomplete' />")).width(n(e.container).innerWidth()-25),t.appendTo(e.container),(i=n("<div class='editor-percentcomplete-picker' />").appendTo(e.container)).append("<div class='editor-percentcomplete-helper'><div class='editor-percentcomplete-wrapper'><div class='editor-percentcomplete-slider' /><div class='editor-percentcomplete-buttons' /></div></div>"),i.find(".editor-percentcomplete-buttons").append("<button val=0>Not started</button><br/><button val=50>In Progress</button><br/><button val=100>Complete</button>"),t.focus().select(),i.find(".editor-percentcomplete-slider").slider({orientation:"vertical",range:"min",value:o,slide:function(e,i){t.val(i.value)}}),i.find(".editor-percentcomplete-buttons button").on("click",function(e){t.val(n(this).attr("val")),i.find(".editor-percentcomplete-slider").slider("value",n(this).attr("val"))})},this.destroy=function(){t.remove(),i.remove()},this.focus=function(){t.focus()},this.loadValue=function(i){t.val(o=i[e.column.field]),t.select()},this.serializeValue=function(){return parseInt(t.val(),10)||0},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==o)&&(parseInt(t.val(),10)||0)!=o},this.validate=function(){return isNaN(parseInt(t.val(),10))?{valid:!1,msg:"Please enter a valid positive number"}:{valid:!0,msg:null}},this.init()},LongText:function(e){var t,i,l,a=this;this.init=function(){var o=n("body");e.grid.getOptions().editorCellNavOnLRKeys,i=n("<DIV style='z-index:10000;position:absolute;background:white;padding:5px;border:3px solid gray; -moz-border-radius:10px; border-radius:10px;'/>").appendTo(o),t=n("<TEXTAREA hidefocus rows=5 style='background:white;width:250px;height:80px;border:0;outline:0'>").appendTo(i),n("<DIV style='text-align:right'><BUTTON>Save</BUTTON><BUTTON>Cancel</BUTTON></DIV>").appendTo(i),i.find("button:first").on("click",this.save),i.find("button:last").on("click",this.cancel),t.on("keydown",this.handleKeyDown),a.position(e.position),t.focus().select()},this.handleKeyDown=function(t){if(t.which==o.keyCode.ENTER&&t.ctrlKey)a.save();else if(t.which==o.keyCode.ESCAPE)t.preventDefault(),a.cancel();else if(t.which==o.keyCode.TAB&&t.shiftKey)t.preventDefault(),e.grid.navigatePrev();else if(t.which==o.keyCode.TAB)t.preventDefault(),e.grid.navigateNext();else if((t.which==n.ui.keyCode.LEFT||t.which==n.ui.keyCode.RIGHT)&&e.grid.getOptions().editorCellNavOnLRKeys){var i=this.selectionStart,l=this.value.length;t.keyCode===n.ui.keyCode.LEFT&&0===i&&e.grid.navigatePrev(),t.keyCode===n.ui.keyCode.RIGHT&&i>=l-1&&e.grid.navigateNext()}},this.save=function(){e.commitChanges()},this.cancel=function(){t.val(l),e.cancelChanges()},this.hide=function(){i.hide()},this.show=function(){i.show()},this.position=function(e){i.css("top",e.top-5).css("left",e.left-5)},this.destroy=function(){i.remove()},this.focus=function(){t.focus()},this.loadValue=function(i){t.val(l=i[e.column.field]),t.select()},this.serializeValue=function(){return t.val()},this.applyValue=function(t,i){t[e.column.field]=i},this.isValueChanged=function(){return!(""==t.val()&&null==l)&&t.val()!=l},this.validate=function(){if(e.column.validator){var i=e.column.validator(t.val());if(!i.valid)return i}return{valid:!0,msg:null}},this.init()}}}},
530: function _(e,n,r){e(521);n.exports={Formatters:{PercentComplete:function(e,n,r,t,c){return null==r||""===r?"-":r<50?"<span style='color:red;font-weight:bold;'>"+r+"%</span>":"<span style='color:green'>"+r+"%</span>"},PercentCompleteBar:function(e,n,r,t,c){return null==r||""===r?"":"<span class='percent-complete-bar' style='background:"+(r<30?"red":r<70?"silver":"green")+";width:"+r+"%'></span>"},YesNo:function(e,n,r,t,c){return r?"Yes":"No"},Checkmark:function(e,n,r,t,c){return r?"<img src='../images/tick.png'>":""},Checkbox:function(e,n,r,t,c){return'<img class="slick-edit-preclick" src="../images/'+(r?"CheckboxY":"CheckboxN")+'.png">'}}}},
531: function _(t,o,r){var e=t(519),n=t(521);o.exports={RemoteModel:function(){var t=50,o={length:0},r="",a=null,l=1,i=null,s=null,u=new n.Event,f=new n.Event;function c(){for(var t in o)delete o[t];o.length=0}function h(n,c){if(s){s.abort();for(var h=s.fromPage;h<=s.toPage;h++)o[h*t]=void 0}n<0&&(n=0),o.length>0&&(c=Math.min(c,o.length-1));for(var v=Math.floor(n/t),m=Math.floor(c/t);void 0!==o[v*t]&&v<m;)v++;for(;void 0!==o[m*t]&&v<m;)m--;if(v>m||v==m&&void 0!==o[v*t])f.notify({from:n,to:c});else{var g="http://octopart.com/api/v3/parts/search?apikey=68b25f31&include[]=short_description&show[]=uid&show[]=manufacturer&show[]=mpn&show[]=brand&show[]=octopart_url&show[]=short_description&q="+r+"&start="+v*t+"&limit="+((m-v)*t+t);null!=a&&(g+="&sortby="+a+(l>0?"+asc":"+desc")),null!=i&&clearTimeout(i),i=setTimeout(function(){for(var r=v;r<=m;r++)o[r*t]=null;u.notify({from:n,to:c}),(s=e.jsonp({url:g,callbackParameter:"callback",cache:!0,success:d,error:function(){!function(t,o){alert("error loading pages "+t+" to "+o)}(v,m)}})).fromPage=v,s.toPage=m},50)}}function d(t){var r=t.request.start,e=r+t.results.length;o.length=Math.min(parseInt(t.hits),1e3);for(var n=0;n<t.results.length;n++){var a=t.results[n].item;o[r+n]=a,o[r+n].index=r+n}s=null,f.notify({from:r,to:e})}return{data:o,clear:c,isDataLoaded:function(t,r){for(var e=t;e<=r;e++)if(null==o[e]||null==o[e])return!1;return!0},ensureData:h,reloadData:function(t,r){for(var e=t;e<=r;e++)delete o[e];h(t,r)},setSort:function(t,o){a=t,l=o,c()},setSearch:function(t){r=t,c()},onDataLoading:u,onDataLoaded:f}}}},
532: function _(e,s,t){var a=e(519),o=e(521);s.exports={GroupItemMetadataProvider:function(e){var s,t={checkboxSelect:!1,checkboxSelectCssClass:"slick-group-select-checkbox",checkboxSelectPlugin:null,groupCssClass:"slick-group",groupTitleCssClass:"slick-group-title",totalsCssClass:"slick-group-totals",groupFocusable:!0,totalsFocusable:!1,toggleCssClass:"slick-group-toggle",toggleExpandedCssClass:"expanded",toggleCollapsedCssClass:"collapsed",enableExpandCollapse:!0,groupFormatter:function(s,t,a,o,l,c){if(!e.enableExpandCollapse)return l.title;var r=15*l.level+"px";return(e.checkboxSelect?'<span class="'+e.checkboxSelectCssClass+" "+(l.selectChecked?"checked":"unchecked")+'"></span>':"")+"<span class='"+e.toggleCssClass+" "+(l.collapsed?e.toggleCollapsedCssClass:e.toggleExpandedCssClass)+"' style='margin-left:"+r+"'></span><span class='"+e.groupTitleCssClass+"' level='"+l.level+"'>"+l.title+"</span>"},totalsFormatter:function(e,s,t,a,o,l){return a.groupTotalsFormatter&&a.groupTotalsFormatter(o,a,l)||""}};function l(t,l){var c=a(t.target),r=this.getDataItem(l.row);if(r&&r instanceof o.Group&&c.hasClass(e.toggleCssClass)){var n=s.getRenderedRange();this.getData().setRefreshHints({ignoreDiffsBefore:n.top,ignoreDiffsAfter:n.bottom+1}),r.collapsed?this.getData().expandGroup(r.groupingKey):this.getData().collapseGroup(r.groupingKey),t.stopImmediatePropagation(),t.preventDefault()}if(r&&r instanceof o.Group&&c.hasClass(e.checkboxSelectCssClass)){r.selectChecked=!r.selectChecked,c.removeClass(r.selectChecked?"unchecked":"checked"),c.addClass(r.selectChecked?"checked":"unchecked");var i=s.getData().mapItemsToRows(r.rows);(r.selectChecked?e.checkboxSelectPlugin.selectRows:e.checkboxSelectPlugin.deSelectRows)(i)}}function c(t,a){if(e.enableExpandCollapse&&t.which==o.keyCode.SPACE){var l=this.getActiveCell();if(l){var c=this.getDataItem(l.row);if(c&&c instanceof o.Group){var r=s.getRenderedRange();this.getData().setRefreshHints({ignoreDiffsBefore:r.top,ignoreDiffsAfter:r.bottom+1}),c.collapsed?this.getData().expandGroup(c.groupingKey):this.getData().collapseGroup(c.groupingKey),t.stopImmediatePropagation(),t.preventDefault()}}}}return e=a.extend(!0,{},t,e),{init:function(e){(s=e).onClick.subscribe(l),s.onKeyDown.subscribe(c)},destroy:function(){s&&(s.onClick.unsubscribe(l),s.onKeyDown.unsubscribe(c))},getGroupRowMetadata:function(s){return{selectable:!1,focusable:e.groupFocusable,cssClasses:e.groupCssClass,columns:{0:{colspan:"*",formatter:e.groupFormatter,editor:null}}}},getTotalsRowMetadata:function(s){return{selectable:!1,focusable:e.totalsFocusable,cssClasses:e.totalsCssClass,formatter:e.totalsFormatter,editor:null}}}}}},
533: function _(i,e,t){var n=i(113),c=i(534),s=i(191),o=i(121),u=function(i){function e(e){return i.call(this,e)||this}return n.__extends(e,i),e.init_TableWidget=function(){this.define({source:[o.Instance],view:[o.Instance,function(){return new s.CDSView}]})},e.prototype.initialize=function(){i.prototype.initialize.call(this),null==this.view.source&&(this.view.source=this.source,this.view.compute_indices())},e}(c.Widget);t.TableWidget=u,u.__name__="TableWidget",u.init_TableWidget()},
534: function _(t,i,e){var n=t(113),o=t(342),r=t(121),l=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(i,t),i.prototype._width_policy=function(){return"horizontal"==this.model.orientation?t.prototype._width_policy.call(this):"fixed"},i.prototype._height_policy=function(){return"horizontal"==this.model.orientation?"fixed":t.prototype._height_policy.call(this)},i.prototype.box_sizing=function(){var i=t.prototype.box_sizing.call(this);return"horizontal"==this.model.orientation?null==i.width&&(i.width=this.model.default_size):null==i.height&&(i.height=this.model.default_size),i},i}(o.HTMLBoxView);e.WidgetView=l,l.__name__="WidgetView";var h=function(t){function i(i){return t.call(this,i)||this}return n.__extends(i,t),i.init_Widget=function(){this.define({orientation:[r.Orientation,"horizontal"],default_size:[r.Number,300]}),this.override({margin:[5,5,5,5]})},i}(o.HTMLBox);e.Widget=h,h.__name__="Widget",h.init_Widget()},
535: function _(n,e,l){n(164),n(536),n(163).styles.append('.bk-root .bk-data-table {\n  box-sizing: content-box;\n  font-size: 11px;\n}\n.bk-root .bk-data-table input[type="checkbox"] {\n  margin-left: 4px;\n  margin-right: 4px;\n}\n.bk-root .bk-cell-special-defaults {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n}\n.bk-root .bk-cell-select {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n}\n.bk-root .bk-cell-index {\n  border-right-color: silver;\n  border-right-style: solid;\n  background: #f5f5f5;\n  text-align: right;\n  color: gray;\n}\n.bk-root .bk-header-index .slick-column-name {\n  float: right;\n}\n.bk-root .slick-row.selected .bk-cell-index {\n  background-color: transparent;\n}\n.bk-root .slick-cell {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .slick-cell.active {\n  border-style: dashed;\n}\n.bk-root .slick-cell.editable {\n  padding-left: 0;\n  padding-right: 0;\n}\n.bk-root .bk-cell-editor input,\n.bk-root .bk-cell-editor select {\n  width: 100%;\n  height: 100%;\n  border: 0;\n  margin: 0;\n  padding: 0;\n  outline: 0;\n  background: transparent;\n  vertical-align: baseline;\n}\n.bk-root .bk-cell-editor input {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .bk-cell-editor-completion {\n  font-size: 11px;\n}\n'),l.bk_data_table="bk-data-table",l.bk_cell_index="bk-cell-index",l.bk_header_index="bk-header-index",l.bk_cell_editor="bk-cell-editor",l.bk_cell_select="bk-cell-select"},
536: function _(A,n,o){A(164),A(163).styles.append('.bk-root {\n  /*\nIMPORTANT:\nIn order to preserve the uniform grid appearance, all cell styles need to have padding, margin and border sizes.\nNo built-in (selected, editable, highlight, flashing, invalid, loading, :focus) or user-specified CSS\nclasses should alter those!\n*/\n  /*\nIMPORTANT:\nIn order to preserve the uniform grid appearance, all cell styles need to have padding, margin and border sizes.\nNo built-in (selected, editable, highlight, flashing, invalid, loading, :focus) or user-specified CSS\nclasses should alter those!\n*/\n  /* Menu button */\n  /* Menu */\n  /* Menu items */\n  /* Disabled */\n}\n.bk-root .slick-header.ui-state-default,\n.bk-root .slick-headerrow.ui-state-default,\n.bk-root .slick-footerrow.ui-state-default,\n.bk-root .slick-top-panel-scroller.ui-state-default {\n  width: 100%;\n  overflow: auto;\n  position: relative;\n  border-left: 0px !important;\n}\n.bk-root .slick-header.ui-state-default {\n  overflow: inherit;\n}\n.bk-root .slick-header::-webkit-scrollbar,\n.bk-root .slick-headerrow::-webkit-scrollbar,\n.bk-root .slick-footerrow::-webkit-scrollbar {\n  display: none;\n}\n.bk-root .slick-header-columns,\n.bk-root .slick-headerrow-columns,\n.bk-root .slick-footerrow-columns {\n  position: relative;\n  white-space: nowrap;\n  cursor: default;\n  overflow: hidden;\n}\n.bk-root .slick-header-column.ui-state-default {\n  position: relative;\n  display: inline-block;\n  box-sizing: content-box !important;\n  /* this here only for Firefox! */\n  overflow: hidden;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  height: 16px;\n  line-height: 16px;\n  margin: 0;\n  padding: 4px;\n  border-right: 1px solid silver;\n  border-left: 0px !important;\n  border-top: 0px !important;\n  border-bottom: 0px !important;\n  float: left;\n}\n.bk-root .slick-headerrow-column.ui-state-default,\n.bk-root .slick-footerrow-column.ui-state-default {\n  padding: 4px;\n}\n.bk-root .slick-header-column-sorted {\n  font-style: italic;\n}\n.bk-root .slick-sort-indicator {\n  display: inline-block;\n  width: 8px;\n  height: 5px;\n  margin-left: 4px;\n  margin-top: 6px;\n  float: left;\n}\n.bk-root .slick-sort-indicator-numbered {\n  display: inline-block;\n  width: 8px;\n  height: 5px;\n  margin-left: 4px;\n  margin-top: 0;\n  line-height: 20px;\n  float: left;\n  font-family: Arial;\n  font-style: normal;\n  font-weight: bold;\n  color: #6190CD;\n}\n.bk-root .slick-sort-indicator-desc {\n  background: url(images/sort-desc.gif);\n}\n.bk-root .slick-sort-indicator-asc {\n  background: url(images/sort-asc.gif);\n}\n.bk-root .slick-resizable-handle {\n  position: absolute;\n  font-size: 0.1px;\n  display: block;\n  cursor: col-resize;\n  width: 9px;\n  right: -5px;\n  top: 0;\n  height: 100%;\n  z-index: 1;\n}\n.bk-root .slick-sortable-placeholder {\n  background: silver;\n}\n.bk-root .grid-canvas {\n  position: relative;\n  outline: 0;\n}\n.bk-root .slick-row.ui-widget-content,\n.bk-root .slick-row.ui-state-active {\n  position: absolute;\n  border: 0px;\n  width: 100%;\n}\n.bk-root .slick-cell,\n.bk-root .slick-headerrow-column,\n.bk-root .slick-footerrow-column {\n  position: absolute;\n  border: 1px solid transparent;\n  border-right: 1px dotted silver;\n  border-bottom-color: silver;\n  overflow: hidden;\n  -o-text-overflow: ellipsis;\n  text-overflow: ellipsis;\n  vertical-align: middle;\n  z-index: 1;\n  padding: 1px 2px 2px 1px;\n  margin: 0;\n  white-space: nowrap;\n  cursor: default;\n}\n.bk-root .slick-cell,\n.bk-root .slick-headerrow-column {\n  border-bottom-color: silver;\n}\n.bk-root .slick-footerrow-column {\n  border-top-color: silver;\n}\n.bk-root .slick-group-toggle {\n  display: inline-block;\n}\n.bk-root .slick-cell.highlighted {\n  background: lightskyblue;\n  background: rgba(0, 0, 255, 0.2);\n  -webkit-transition: all 0.5s;\n  -moz-transition: all 0.5s;\n  -o-transition: all 0.5s;\n  transition: all 0.5s;\n}\n.bk-root .slick-cell.flashing {\n  border: 1px solid red !important;\n}\n.bk-root .slick-cell.editable {\n  z-index: 11;\n  overflow: visible;\n  background: white;\n  border-color: black;\n  border-style: solid;\n}\n.bk-root .slick-cell:focus {\n  outline: none;\n}\n.bk-root .slick-reorder-proxy {\n  display: inline-block;\n  background: blue;\n  opacity: 0.15;\n  cursor: move;\n}\n.bk-root .slick-reorder-guide {\n  display: inline-block;\n  height: 2px;\n  background: blue;\n  opacity: 0.7;\n}\n.bk-root .slick-selection {\n  z-index: 10;\n  position: absolute;\n  border: 2px dashed black;\n}\n.bk-root .slick-header-columns {\n  background: url(\'images/header-columns-bg.gif\') repeat-x center bottom;\n  border-bottom: 1px solid silver;\n}\n.bk-root .slick-header-column {\n  background: url(\'images/header-columns-bg.gif\') repeat-x center bottom;\n  border-right: 1px solid silver;\n}\n.bk-root .slick-header-column:hover,\n.bk-root .slick-header-column-active {\n  background: white url(\'images/header-columns-over-bg.gif\') repeat-x center bottom;\n}\n.bk-root .slick-headerrow {\n  background: #fafafa;\n}\n.bk-root .slick-headerrow-column {\n  background: #fafafa;\n  border-bottom: 0;\n  height: 100%;\n}\n.bk-root .slick-row.ui-state-active {\n  background: #F5F7D7;\n}\n.bk-root .slick-row {\n  position: absolute;\n  background: white;\n  border: 0px;\n  line-height: 20px;\n}\n.bk-root .slick-row.selected {\n  z-index: 10;\n  background: #DFE8F6;\n}\n.bk-root .slick-cell {\n  padding-left: 4px;\n  padding-right: 4px;\n}\n.bk-root .slick-group {\n  border-bottom: 2px solid silver;\n}\n.bk-root .slick-group-toggle {\n  width: 9px;\n  height: 9px;\n  margin-right: 5px;\n}\n.bk-root .slick-group-toggle.expanded {\n  background: url(images/collapse.gif) no-repeat center center;\n}\n.bk-root .slick-group-toggle.collapsed {\n  background: url(images/expand.gif) no-repeat center center;\n}\n.bk-root .slick-group-totals {\n  color: gray;\n  background: white;\n}\n.bk-root .slick-group-select-checkbox {\n  width: 13px;\n  height: 13px;\n  margin: 3px 10px 0 0;\n  display: inline-block;\n}\n.bk-root .slick-group-select-checkbox.checked {\n  background: url(images/GrpCheckboxY.png) no-repeat center center;\n}\n.bk-root .slick-group-select-checkbox.unchecked {\n  background: url(images/GrpCheckboxN.png) no-repeat center center;\n}\n.bk-root .slick-cell.selected {\n  background-color: beige;\n}\n.bk-root .slick-cell.active {\n  border-color: gray;\n  border-style: solid;\n}\n.bk-root .slick-sortable-placeholder {\n  background: silver !important;\n}\n.bk-root .slick-row.odd {\n  background: #fafafa;\n}\n.bk-root .slick-row.ui-state-active {\n  background: #F5F7D7;\n}\n.bk-root .slick-row.loading {\n  opacity: 0.5;\n}\n.bk-root .slick-cell.invalid {\n  border-color: red;\n  -moz-animation-duration: 0.2s;\n  -webkit-animation-duration: 0.2s;\n  -moz-animation-name: slickgrid-invalid-hilite;\n  -webkit-animation-name: slickgrid-invalid-hilite;\n}\n@-moz-keyframes slickgrid-invalid-hilite {\n  from {\n    box-shadow: 0 0 6px red;\n  }\n  to {\n    box-shadow: none;\n  }\n}\n@-webkit-keyframes slickgrid-invalid-hilite {\n  from {\n    box-shadow: 0 0 6px red;\n  }\n  to {\n    box-shadow: none;\n  }\n}\n.bk-root .slick-column-name,\n.bk-root .slick-sort-indicator {\n  /**\n   * This makes all "float:right" elements after it that spill over to the next line\n   * display way below the lower boundary of the column thus hiding them.\n   */\n  display: inline-block;\n  float: left;\n  margin-bottom: 100px;\n}\n.bk-root .slick-header-button {\n  display: inline-block;\n  float: right;\n  vertical-align: top;\n  margin: 1px;\n  /**\n  * This makes all "float:right" elements after it that spill over to the next line\n  * display way below the lower boundary of the column thus hiding them.\n  */\n  margin-bottom: 100px;\n  height: 15px;\n  width: 15px;\n  background-repeat: no-repeat;\n  background-position: center center;\n  cursor: pointer;\n}\n.bk-root .slick-header-button-hidden {\n  width: 0;\n  -webkit-transition: 0.2s width;\n  -ms-transition: 0.2s width;\n  transition: 0.2s width;\n}\n.bk-root .slick-header-column:hover > .slick-header-button {\n  width: 15px;\n}\n.bk-root .slick-header-menubutton {\n  position: absolute;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  width: 14px;\n  background-repeat: no-repeat;\n  background-position: left center;\n  background-image: url(../images/down.gif);\n  cursor: pointer;\n  display: none;\n  border-left: thin ridge silver;\n}\n.bk-root .slick-header-column:hover > .slick-header-menubutton,\n.bk-root .slick-header-column-active .slick-header-menubutton {\n  display: inline-block;\n}\n.bk-root .slick-header-menu {\n  position: absolute;\n  display: inline-block;\n  margin: 0;\n  padding: 2px;\n  cursor: default;\n}\n.bk-root .slick-header-menuitem {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n  cursor: pointer;\n}\n.bk-root .slick-header-menuicon {\n  display: inline-block;\n  width: 16px;\n  height: 16px;\n  vertical-align: middle;\n  margin-right: 4px;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .slick-header-menucontent {\n  display: inline-block;\n  vertical-align: middle;\n}\n.bk-root .slick-header-menuitem-disabled {\n  color: silver;\n}\n.bk-root .slick-columnpicker {\n  border: 1px solid #718BB7;\n  background: #f0f0f0;\n  padding: 6px;\n  -moz-box-shadow: 2px 2px 2px silver;\n  -webkit-box-shadow: 2px 2px 2px silver;\n  box-shadow: 2px 2px 2px silver;\n  min-width: 150px;\n  cursor: default;\n  position: absolute;\n  z-index: 20;\n  overflow: auto;\n  resize: both;\n}\n.bk-root .slick-columnpicker > .close {\n  float: right;\n}\n.bk-root .slick-columnpicker .title {\n  font-size: 16px;\n  width: 60%;\n  border-bottom: solid 1px #d6d6d6;\n  margin-bottom: 10px;\n}\n.bk-root .slick-columnpicker li {\n  list-style: none;\n  margin: 0;\n  padding: 0;\n  background: none;\n}\n.bk-root .slick-columnpicker input {\n  margin: 4px;\n}\n.bk-root .slick-columnpicker li a {\n  display: block;\n  padding: 4px;\n  font-weight: bold;\n}\n.bk-root .slick-columnpicker li a:hover {\n  background: white;\n}\n.bk-root .slick-pager {\n  width: 100%;\n  height: 26px;\n  border: 1px solid gray;\n  border-top: 0;\n  background: url(\'../images/header-columns-bg.gif\') repeat-x center bottom;\n  vertical-align: middle;\n}\n.bk-root .slick-pager .slick-pager-status {\n  display: inline-block;\n  padding: 6px;\n}\n.bk-root .slick-pager .ui-icon-container {\n  display: inline-block;\n  margin: 2px;\n  border-color: gray;\n}\n.bk-root .slick-pager .slick-pager-nav {\n  display: inline-block;\n  float: left;\n  padding: 2px;\n}\n.bk-root .slick-pager .slick-pager-settings {\n  display: block;\n  float: right;\n  padding: 2px;\n}\n.bk-root .slick-pager .slick-pager-settings * {\n  vertical-align: middle;\n}\n.bk-root .slick-pager .slick-pager-settings a {\n  padding: 2px;\n  text-decoration: underline;\n  cursor: pointer;\n}\n.bk-root .slick-header-columns {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n.bk-root .slick-header-column {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n.bk-root .slick-header-column:hover,\n.bk-root .slick-header-column-active {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAWAIcAAKrM9tno++vz/QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABYAAAgUAAUIHEiwoIAACBMqXMhwIQAAAQEAOw==");\n}\n.bk-root .slick-group-toggle.expanded {\n  background-image: url("data:image/gif;base64,R0lGODlhCQAJAPcAAAFGeoCAgNXz/+v5/+v6/+z5/+36//L7//X8//j9/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAACQAJAAAIMwADCBxIUIDBgwIEChgwwECBAgQUFjBAkaJCABgxGlB4AGHCAAIQiBypEEECkScJqgwQEAA7");\n}\n.bk-root .slick-group-toggle.collapsed {\n  background-image: url("data:image/gif;base64,R0lGODlhCQAJAPcAAAFGeoCAgNXz/+v5/+v6/+z5/+36//L7//X8//j9/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACwAAAAACQAJAAAIOAADCBxIUIDBgwIEChgwAECBAgQUFjAAQIABAwoBaNSIMYCAAwIqGlSIAEHFkiQTIBCgkqDLAAEBADs=");\n}\n.bk-root .slick-group-select-checkbox.checked {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAIAAACQKrqGAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABl0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMC4xNkRpr/UAAAEcSURBVChTjdI9S8NQFAbg/raQXVwCRRFE7GK7OXTwD+ikk066VF3a0ja0hQTyQdJrwNq0zrYSQRLEXMSWSlCIb8glqRcFD+9yz3nugXwU4n9XQqMoGjj36uBJsTwuaNo3EwBG4Yy7pe7Gv8YcvhJCGFVsjxsjxujj6OTSGlHv+U2WZUZbPWKOv1ZjT5a7pbIoiptbO5b73mwrjHa1B27l8VlTEIS1damlTnEE+EEN9/P8WrfH81qdAIGeXvTTmzltdCy46sEhxpKUINReZR9NnqZbr9puugxV3NjWh/k74WmmEdWhmUNy2jNmWRc6fZTVADCqao52u+DGWTACYNT3fRxwtatPufTNR4yCIGAUn5hS+vJHhWGY/ANx/A3tvdv+1tZmuwAAAABJRU5ErkJggg==");\n}\n.bk-root .slick-group-select-checkbox.unchecked {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAIAAACQKrqGAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwQAADsEBuJFr7QAAABl0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMC4xNkRpr/UAAACXSURBVChT1dIxC4MwEAXg/v8/VOhQVDBNakV0KA6pxS4JhWRSIYPEJxwdDi1de7wleR+3JIf486w0hKCKRpSvvOhZcCmvNQBRuKqdah03U7UjNNH81rOaBYDo8SQaPX8JANFEaLaGBeAPaaY61rGksiN6TmR5H1j9CSoAosYYHLA7vTxYMvVEZa0liif23r93xjm3/oEYF8PiDn/I2FHCAAAAAElFTkSuQmCC");\n}\n.bk-root .slick-sort-indicator-desc {\n  background-image: url("data:image/gif;base64,R0lGODlhDQAFAIcAAGGQzUD/QOPu+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAEALAAAAAANAAUAAAgeAAUAGEgQgIAACBEKLHgwYcKFBh1KFNhQosOKEgMCADs=");\n}\n.bk-root .slick-sort-indicator-asc {\n  background-image: url("data:image/gif;base64,R0lGODlhDQAFAIcAAGGQzUD/QOPu+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAEALAAAAAANAAUAAAgbAAMIDABgoEGDABIeRJhQ4cKGEA8KmEiRosGAADs=");\n}\n.bk-root .slick-header-menubutton {\n  background-image: url("data:image/gif;base64,R0lGODlhDgAOAIABADtKYwAAACH5BAEAAAEALAAAAAAOAA4AAAISjI+py+0PHZgUsGobhTn6DxoFADs=");\n}\n.bk-root .slick-pager {\n  background-image: url("data:image/gif;base64,R0lGODlhAgAYAIcAANDQ0Ovs7uzt7+3u8O7v8e/w8vDx8/Hy9Pn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAP8ALAAAAAACABgAAAghABEIHEiwYMEDCA8YWMiwgMMCBAgMmDhAgIAAGAMAABAQADs=");\n}\n')},
537: function _(t,e,r){var n=t(113),o=t(255),a=t(538),i=t(252),u=t(121),l=t(163),c=t(109),s=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.prototype.doFormat=function(t,e,r,n,o){return null==r?"":(r+"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},e}(t(166).Model);r.CellFormatter=s,s.__name__="CellFormatter";var m=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_StringFormatter=function(){this.define({font_style:[u.FontStyle,"normal"],text_align:[u.TextAlign,"left"],text_color:[u.Color]})},e.prototype.doFormat=function(t,e,r,n,o){var a=this.font_style,i=this.text_align,u=this.text_color,c=l.div({},null==r?"":""+r);switch(a){case"bold":c.style.fontWeight="bold";break;case"italic":c.style.fontStyle="italic"}return null!=i&&(c.style.textAlign=i),null!=u&&(c.style.color=u),c.outerHTML},e}(s);r.StringFormatter=m,m.__name__="StringFormatter",m.init_StringFormatter();var _=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_NumberFormatter=function(){this.define({format:[u.String,"0,0"],language:[u.String,"en"],rounding:[u.RoundingFunction,"round"]})},e.prototype.doFormat=function(e,r,n,a,i){var u=this,l=this.format,c=this.language,s=function(){switch(u.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}();return n=o.format(n,l,c,s),t.prototype.doFormat.call(this,e,r,n,a,i)},e}(m);r.NumberFormatter=_,_.__name__="NumberFormatter",_.init_NumberFormatter();var f=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_BooleanFormatter=function(){this.define({icon:[u.String,"check"]})},e.prototype.doFormat=function(t,e,r,n,o){return r?l.i({class:this.icon}).outerHTML:""},e}(s);r.BooleanFormatter=f,f.__name__="BooleanFormatter",f.init_BooleanFormatter();var F=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_DateFormatter=function(){this.define({format:[u.String,"ISO-8601"]})},e.prototype.getFormat=function(){switch(this.format){case"ATOM":case"W3C":case"RFC-3339":case"ISO-8601":return"%Y-%m-%d";case"COOKIE":return"%a, %d %b %Y";case"RFC-850":return"%A, %d-%b-%y";case"RFC-1123":case"RFC-2822":return"%a, %e %b %Y";case"RSS":case"RFC-822":case"RFC-1036":return"%a, %e %b %y";case"TIMESTAMP":return;default:return this.format}},e.prototype.doFormat=function(e,r,n,o,a){n=c.isString(n)?parseInt(n,10):n;var u=i(n,this.getFormat());return t.prototype.doFormat.call(this,e,r,u,o,a)},e}(s);r.DateFormatter=F,F.__name__="DateFormatter",F.init_DateFormatter();var h=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_HTMLTemplateFormatter=function(){this.define({template:[u.String,"<%= value %>"]})},e.prototype.doFormat=function(t,e,r,n,o){var i=this.template;return null==r?"":a(i)(Object.assign(Object.assign({},o),{value:r}))},e}(s);r.HTMLTemplateFormatter=h,h.__name__="HTMLTemplateFormatter",h.init_HTMLTemplateFormatter()},
538: function _(e,n,t){var f=e(539),i=f.template;function o(e,n,t){return i(e,n,t)}o._=f,n.exports=o,"function"==typeof define&&define.amd?define(function(){return o}):"undefined"==typeof window&&"undefined"==typeof navigator||(window.UnderscoreTemplate=o)},
539: function _(r,e,n){
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var t={},a=Array.prototype,u=Object.prototype,c=a.slice,o=u.toString,l=u.hasOwnProperty,i=a.forEach,f=Object.keys,s=Array.isArray,p=function(){},_=p.each=p.forEach=function(r,e,n){if(null!=r)if(i&&r.forEach===i)r.forEach(e,n);else if(r.length===+r.length){for(var a=0,u=r.length;a<u;a++)if(e.call(n,r[a],a,r)===t)return}else{var c=p.keys(r);for(a=0,u=c.length;a<u;a++)if(e.call(n,r[c[a]],c[a],r)===t)return}};p.keys=f||function(r){if(r!==Object(r))throw new TypeError("Invalid object");var e=[];for(var n in r)p.has(r,n)&&e.push(n);return e},p.defaults=function(r){return _(c.call(arguments,1),function(e){if(e)for(var n in e)void 0===r[n]&&(r[n]=e[n])}),r},p.isArray=s||function(r){return"[object Array]"===o.call(r)},p.has=function(r,e){if(!p.isArray(e))return null!=r&&l.call(r,e);for(var n=e.length,t=0;t<n;t++){var a=e[t];if(null==r||!l.call(r,a))return!1;r=r[a]}return!!n};var h={escape:{"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;"}},v={escape:new RegExp("["+p.keys(h.escape).join("")+"]","g")};p.each(["escape"],function(r){p[r]=function(e){return null==e?"":(""+e).replace(v[r],function(e){return h[r][e]})}}),p.templateSettings={evaluate:/<%([\s\S]+?)%>/g,interpolate:/<%=([\s\S]+?)%>/g,escape:/<%-([\s\S]+?)%>/g};var g=/(.)^/,y={"'":"'","\\":"\\","\r":"r","\n":"n","\t":"t","\u2028":"u2028","\u2029":"u2029"},j=/\\|'|\r|\n|\t|\u2028|\u2029/g;p.template=function(r,e,n){var t;n=p.defaults({},n,p.templateSettings);var a=new RegExp([(n.escape||g).source,(n.interpolate||g).source,(n.evaluate||g).source].join("|")+"|$","g"),u=0,c="__p+='";r.replace(a,function(e,n,t,a,o){return c+=r.slice(u,o).replace(j,function(r){return"\\"+y[r]}),n&&(c+="'+\n((__t=("+n+"))==null?'':_.escape(__t))+\n'"),t&&(c+="'+\n((__t=("+t+"))==null?'':__t)+\n'"),a&&(c+="';\n"+a+"\n__p+='"),u=o+e.length,e}),c+="';\n",n.variable||(c="with(obj||{}){\n"+c+"}\n"),c="var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n"+c+"return __p;\n";try{t=new Function(n.variable||"obj","_",c)}catch(r){throw r.source=c,r}if(e)return t(e,p);var o=function(r){return t.call(this,r,p)};return o.source="function("+(n.variable||"obj")+"){\n"+c+"}",o},e.exports=p},
540: function _(t,e,i){var n=t(113),r=t(537),o=t(516),l=t(121),a=t(127),d=function(t){function e(e){return t.call(this,e)||this}return n.__extends(e,t),e.init_TableColumn=function(){this.define({field:[l.String],title:[l.String],width:[l.Number,300],formatter:[l.Instance,function(){return new r.StringFormatter}],editor:[l.Instance,function(){return new o.StringEditor}],sortable:[l.Boolean,!0],default_sort:[l.Sort,"ascending"]})},e.prototype.toColumn=function(){return{id:a.uniqueId(),field:this.field,name:this.title,width:this.width,formatter:null!=this.formatter?this.formatter.doFormat.bind(this.formatter):void 0,model:this.editor,editor:this.editor.default_view,sortable:this.sortable,defaultSortAsc:"ascending"==this.default_sort}},e}(t(166).Model);i.TableColumn=d,d.__name__="TableColumn",d.init_TableColumn()},
541: function _(t,e,n){var r=t(113),a=t(524).Data.Aggregators,i=a.Avg,u=a.Min,g=a.Max,o=a.Sum,s=t(121),_=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_RowAggregator=function(){this.define({field_:[s.String,""]})},e}(t(166).Model);n.RowAggregator=_,_.__name__="RowAggregator",_.init_RowAggregator();var c=new i,l=function(t){function e(){var e=t.apply(this,arguments)||this;return e.key="avg",e.init=c.init,e.accumulate=c.accumulate,e.storeResult=c.storeResult,e}return r.__extends(e,t),e}(_);n.AvgAggregator=l,l.__name__="AvgAggregator";var m=new u,A=function(t){function e(){var e=t.apply(this,arguments)||this;return e.key="min",e.init=m.init,e.accumulate=m.accumulate,e.storeResult=m.storeResult,e}return r.__extends(e,t),e}(_);n.MinAggregator=A,A.__name__="MinAggregator";var f=new g,v=function(t){function e(){var e=t.apply(this,arguments)||this;return e.key="max",e.init=f.init,e.accumulate=f.accumulate,e.storeResult=f.storeResult,e}return r.__extends(e,t),e}(_);n.MaxAggregator=v,v.__name__="MaxAggregator";var R=new o,h=function(t){function e(){var e=t.apply(this,arguments)||this;return e.key="sum",e.init=R.init,e.accumulate=R.accumulate,e.storeResult=R.storeResult,e}return r.__extends(e,t),e}(_);n.SumAggregator=h,h.__name__="SumAggregator"},
542: function _(t,e,r){var o=t(113),n=t(121),i=t(163),s=t(524),a=t(517);function u(t,e,r,o,n){var s=n.collapsed,a=n.level,u=n.title,l=i.span({class:"slick-group-toggle "+(s?"collapsed":"expanded"),style:{"margin-left":15*a+"px"}}),p=i.span({class:"slick-group-title",level:a},u);return""+l.outerHTML+p.outerHTML}function l(t,e){var r=this.getDataItem(e.row);r instanceof s.Group&&t.target.classList.contains("slick-group-toggle")&&(r.collapsed?this.getData().expandGroup(r.groupingKey):this.getData().collapseGroup(r.groupingKey),t.stopImmediatePropagation(),t.preventDefault(),this.invalidate(),this.render())}var p=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_GroupingInfo=function(){this.define({getter:[n.String,""],aggregators:[n.Array,[]],collapsed:[n.Boolean,!1]})},Object.defineProperty(e.prototype,"comparer",{get:function(){return function(t,e){return t.value===e.value?0:t.value>e.value?1:-1}},enumerable:!0,configurable:!0}),e}(t(166).Model);r.GroupingInfo=p,p.__name__="GroupingInfo",p.init_GroupingInfo();var c=function(t){function e(e,r,o,n){var i=t.call(this,e,r)||this;return i.columns=o,i.groupingInfos=[],i.groupingDelimiter=":|:",i.target=n,i}return o.__extends(e,t),e.prototype.setGrouping=function(t){this.groupingInfos=t,this.toggledGroupsByLevel=t.map(function(){return{}}),this.refresh()},e.prototype.extractGroups=function(t,e){var r=this,o=[],n=new Map,i=e?e.level+1:0,a=this.groupingInfos[i],u=a.comparer,l=a.getter;return t.forEach(function(t){var a=r.source.data[l][t],u=n.get(a);if(!u){var p=e?""+e.groupingKey+r.groupingDelimiter+a:""+a;u=Object.assign(new s.Group,{value:a,level:i,groupingKey:p}),o.push(u),n.set(a,u)}u.rows.push(t)}),i<this.groupingInfos.length-1&&o.forEach(function(t){t.groups=r.extractGroups(t.rows,t)}),o.sort(u),o},e.prototype.calculateTotals=function(t,e){var r={avg:{},max:{},min:{},sum:{}},o=this.source.data,n=Object.keys(o),i=t.rows.map(function(t){return n.reduce(function(e,r){var n;return Object.assign(Object.assign({},e),((n={})[r]=o[r][t],n))},{})});return e.forEach(function(t){t.init(),i.forEach(function(e){return t.accumulate(e)}),t.storeResult(r)}),r},e.prototype.addTotals=function(t,e){var r=this;void 0===e&&(e=0);var o=this.groupingInfos[e],n=o.aggregators,i=o.collapsed,s=this.toggledGroupsByLevel[e];t.forEach(function(t){t.groups&&r.addTotals(t.groups,e+1),n.length&&t.rows.length&&(t.totals=r.calculateTotals(t,n)),t.collapsed=i!==s[t.groupingKey],t.title=t.value?""+t.value:""})},e.prototype.flattenedGroupedRows=function(t,e){var r=this;void 0===e&&(e=0);var o=[];return t.forEach(function(t){if(o.push(t),!t.collapsed){var n=t.groups?r.flattenedGroupedRows(t.groups,e+1):t.rows;o.push.apply(o,n)}}),o},e.prototype.refresh=function(){var t=this.extractGroups(this.view.indices),e=this.source.data[this.columns[0].field];t.length&&(this.addTotals(t),this.rows=this.flattenedGroupedRows(t),this.target.data={row_indices:this.rows.map(function(t){return t instanceof s.Group?t.rows:t}),labels:this.rows.map(function(t){return t instanceof s.Group?t.title:e[t]})})},e.prototype.getLength=function(){return this.rows.length},e.prototype.getItem=function(t){var e,r=this.rows[t],o=this.source.data;return r instanceof s.Group?r:Object.keys(o).reduce(function(t,e){var n;return Object.assign(Object.assign({},t),((n={})[e]=o[e][r],n))},((e={})[a.DTINDEX_NAME]=r,e))},e.prototype.getItemMetadata=function(t){var e=this.rows[t],r=this.columns.slice(1),n=e instanceof s.Group?this.groupingInfos[e.level].aggregators:[];return e instanceof s.Group?{selectable:!1,focusable:!1,cssClasses:"slick-group",columns:o.__spreadArrays([{formatter:u}],r.map(function(t){var e=t.field,r=t.formatter,o=n.find(function(t){return t.field_===e});if(o){var i=o.key;return{formatter:function(t,o,n,s,a){return r?r(t,o,a.totals[i][e],s,a):""}}}return{}}))}:{}},e.prototype.collapseGroup=function(t){var e=t.split(this.groupingDelimiter).length-1;this.toggledGroupsByLevel[e][t]=!this.groupingInfos[e].collapsed,this.refresh()},e.prototype.expandGroup=function(t){var e=t.split(this.groupingDelimiter).length-1;this.toggledGroupsByLevel[e][t]=this.groupingInfos[e].collapsed,this.refresh()},e}(a.TableDataProvider);r.DataCubeProvider=c,c.__name__="DataCubeProvider";var g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(e,t),e.prototype.render=function(){var t,e,r={enableCellNavigation:!1!==this.model.selectable,enableColumnReorder:!1,forceFitColumns:this.model.fit_columns,multiColumnSort:!1,editable:this.model.editable,autoEdit:!1,rowHeight:this.model.row_height},o=this.model.columns.map(function(t){return t.toColumn()});o[0].formatter=(t=o[0].formatter,e=this.model.grouping.length,function(r,o,n,s,a){var u=i.span({class:"slick-group-toggle",style:{"margin-left":15*(e||0)+"px"}}),l=t?t(r,o,n,s,a):""+n;return""+u.outerHTML+(l&&l.replace(/^<div/,"<span").replace(/div>$/,"span>"))}),delete o[0].editor,this.data=new c(this.model.source,this.model.view,o,this.model.target),this.data.setGrouping(this.model.grouping),this.el.style.width=this.model.width+"px",this.grid=new s.Grid(this.el,this.data,o,r),this.grid.onClick.subscribe(l)},e}(a.DataTableView);r.DataCubeView=g,g.__name__="DataCubeView";var f=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_DataCube=function(){this.prototype.default_view=g,this.define({grouping:[n.Array,[]],target:[n.Instance]})},e}(a.DataTable);r.DataCube=f,f.__name__="DataCube",f.init_DataCube()},
}, 514, {"models/widgets/tables/main":514,"models/widgets/tables/index":515,"models/widgets/tables/cell_editors":516,"models/widgets/tables/data_table":517,"models/widgets/tables/table_widget":533,"models/widgets/widget":534,"styles/widgets/tables":535,"styles/widgets/slickgrid":536,"models/widgets/tables/cell_formatters":537,"models/widgets/tables/table_column":540,"models/widgets/tables/row_aggregators":541,"models/widgets/tables/data_cube":542}, {});
})

//# sourceMappingURL=bokeh-tables.min.js.map
