/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(22u, 23u, 4u) >> 0u) => uvec3(22u, 23u, 4u)
 * (uvec3(22u, 23u, 4u) >> 1u) => uvec3(11u, 11u, 2u)
 * (uvec3(22u, 23u, 4u) >> 2u) => uvec3(5u, 5u, 1u)
 * (uvec3(22u, 23u, 4u) >> 5u) => uvec3(0u, 0u, 0u)
 * (uvec3(22u, 23u, 4u) >> 25u) => uvec3(0u, 0u, 0u)
 * (uvec3(22u, 23u, 4u) >> 31u) => uvec3(0u, 0u, 0u)
 * (uvec3(19u, 1u, 13u) >> 0u) => uvec3(19u, 1u, 13u)
 * (uvec3(19u, 1u, 13u) >> 1u) => uvec3(9u, 0u, 6u)
 * (uvec3(19u, 1u, 13u) >> 2u) => uvec3(4u, 0u, 3u)
 * (uvec3(19u, 1u, 13u) >> 5u) => uvec3(0u, 0u, 0u)
 * (uvec3(19u, 1u, 13u) >> 25u) => uvec3(0u, 0u, 0u)
 * (uvec3(19u, 1u, 13u) >> 31u) => uvec3(0u, 0u, 0u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(22u, 23u, 4u) >> 0u), uvec3(22u, 23u, 4u))) ? 1 : -1] array0;
  float[all(equal((uvec3(22u, 23u, 4u) >> 1u), uvec3(11u, 11u, 2u))) ? 1 : -1] array1;
  float[all(equal((uvec3(22u, 23u, 4u) >> 2u), uvec3(5u, 5u, 1u))) ? 1 : -1] array2;
  float[all(equal((uvec3(22u, 23u, 4u) >> 5u), uvec3(0u, 0u, 0u))) ? 1 : -1] array3;
  float[all(equal((uvec3(22u, 23u, 4u) >> 25u), uvec3(0u, 0u, 0u))) ? 1 : -1] array4;
  float[all(equal((uvec3(22u, 23u, 4u) >> 31u), uvec3(0u, 0u, 0u))) ? 1 : -1] array5;
  float[all(equal((uvec3(19u, 1u, 13u) >> 0u), uvec3(19u, 1u, 13u))) ? 1 : -1] array6;
  float[all(equal((uvec3(19u, 1u, 13u) >> 1u), uvec3(9u, 0u, 6u))) ? 1 : -1] array7;
  float[all(equal((uvec3(19u, 1u, 13u) >> 2u), uvec3(4u, 0u, 3u))) ? 1 : -1] array8;
  float[all(equal((uvec3(19u, 1u, 13u) >> 5u), uvec3(0u, 0u, 0u))) ? 1 : -1] array9;
  float[all(equal((uvec3(19u, 1u, 13u) >> 25u), uvec3(0u, 0u, 0u))) ? 1 : -1] array10;
  float[all(equal((uvec3(19u, 1u, 13u) >> 31u), uvec3(0u, 0u, 0u))) ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
