/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(13u, 26u) << ivec2(13, 26)) => uvec2(106496u, 1744830464u)
 * (uvec2(13u, 26u) << ivec2(2, 26)) => uvec2(52u, 1744830464u)
 * (uvec2(2u, 26u) << ivec2(13, 26)) => uvec2(16384u, 1744830464u)
 * (uvec2(2u, 26u) << ivec2(2, 26)) => uvec2(8u, 1744830464u)
 */
#version 130

void main()
{
  float[all(equal((uvec2(13u, 26u) << ivec2(13, 26)), uvec2(106496u, 1744830464u))) ? 1 : -1] array0;
  float[all(equal((uvec2(13u, 26u) << ivec2(2, 26)), uvec2(52u, 1744830464u))) ? 1 : -1] array1;
  float[all(equal((uvec2(2u, 26u) << ivec2(13, 26)), uvec2(16384u, 1744830464u))) ? 1 : -1] array2;
  float[all(equal((uvec2(2u, 26u) << ivec2(2, 26)), uvec2(8u, 1744830464u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
