/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server.config;

import java.util.LinkedList;
import java.util.List;
import net.jradius.handler.EventHandler;
import net.jradius.handler.EventHandlerChain;
import net.jradius.handler.PacketHandlerChain;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.server.config.Configuration;
import net.jradius.server.config.ConfigurationItem;
import net.jradius.server.config.HandlerConfigurationItem;
import net.jradius.server.config.PacketHandlerConfigurationItem;
import net.jradius.server.config.XMLConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerConfigurationItem
extends ConfigurationItem {
    public static String XML_LIST_KEY = "listeners";
    public static String XML_KEY = "listener";
    private List<JRCommand> requestHandlers;
    private List<JRCommand> eventHandlers;
    private String processorClassName;
    private int numberOfThreads;
    private static final String PROC_CLASS_KEY = "processor-class";
    private static final String PROC_THREADS_KEY = "processor-threads";

    public ListenerConfigurationItem(HierarchicalConfiguration.Node node2, XMLConfiguration config) {
        super(node2, config);
        JRCommand command;
        HandlerConfigurationItem preCfg;
        HandlerConfigurationItem cfg;
        this.processorClassName = config.getConfigString(PROC_CLASS_KEY);
        this.numberOfThreads = config.getConfigInt(PROC_THREADS_KEY, 1);
        HierarchicalConfiguration.Node lnode = node2;
        HierarchicalConfiguration.Node lroot = config.getRoot();
        List children = lnode.getChildren("packet-handler");
        for (HierarchicalConfiguration.Node node2 : children) {
            config.setRoot(node2);
            cfg = new PacketHandlerConfigurationItem(node2, config);
            preCfg = null;
            command = Configuration.packetHandlerForName(cfg.getHandlerName());
            if (command == null) {
                if (cfg.getCatalogName() != null) {
                    cfg.setName(cfg.getCatalogName());
                    cfg.setClassName(PacketHandlerChain.class.getName());
                } else {
                    preCfg = Configuration.packetHandlerConfigurationForName(cfg.getHandlerName());
                    if (preCfg != null) {
                        cfg.setName(preCfg.getName());
                        cfg.setHandlerName(preCfg.getHandlerName());
                        cfg.setClassName(preCfg.getClassName());
                        cfg.getSenders().addAll(preCfg.getSenders());
                        cfg.getHandleTypes().addAll(preCfg.getHandleTypes());
                        cfg.getProperties().putAll(preCfg.getProperties());
                    }
                }
                String cfgClassName = cfg.getClassName();
                try {
                    command = (EventHandler)Configuration.getBean(cfgClassName);
                }
                catch (Exception e) {
                    String message = cfgClassName == null ? "Class/bean name not defined." : "Class/bean '" + cfgClassName + "' not found.";
                    RadiusLog.error(message, e);
                    continue;
                }
            }
            if (command == null) {
                RadiusLog.error("No command found for " + cfg.getHandlerName() + " " + cfg.getClassName());
                continue;
            }
            if (preCfg != null) {
                command.setConfig(preCfg);
            }
            command.setConfig(cfg);
            if (this.requestHandlers == null) {
                this.requestHandlers = new LinkedList<JRCommand>();
            }
            this.requestHandlers.add(command);
        }
        if (this.requestHandlers == null) {
            config.setRoot(lroot);
            children = lnode.getChildren("request-handler");
            for (HierarchicalConfiguration.Node node2 : children) {
                config.setRoot(node2);
                cfg = new HandlerConfigurationItem(node2, config);
                preCfg = null;
                command = Configuration.eventHandlerForName(cfg.getHandlerName());
                if (command == null) {
                    if (cfg.getCatalogName() != null) {
                        cfg.setName(cfg.getCatalogName());
                        cfg.setClassName(EventHandlerChain.class.getName());
                    } else {
                        preCfg = Configuration.eventHandlerConfigurationForName(cfg.getHandlerName());
                        if (preCfg != null) {
                            cfg.setName(preCfg.getName());
                            cfg.setHandlerName(preCfg.getHandlerName());
                            cfg.setClassName(preCfg.getClassName());
                            cfg.getSenders().addAll(preCfg.getSenders());
                            cfg.getHandleTypes().addAll(preCfg.getHandleTypes());
                            cfg.getProperties().putAll(preCfg.getProperties());
                        }
                    }
                    try {
                        command = (EventHandler)Configuration.getBean(cfg.getClassName());
                    }
                    catch (Exception e) {
                        RadiusLog.error(e.getMessage(), e);
                        continue;
                    }
                }
                if (preCfg != null) {
                    command.setConfig(preCfg);
                }
                command.setConfig(cfg);
                if (this.requestHandlers == null) {
                    this.requestHandlers = new LinkedList<JRCommand>();
                }
                this.requestHandlers.add(command);
            }
        }
        config.setRoot(lroot);
        children = lnode.getChildren("event-handler");
        for (HierarchicalConfiguration.Node node2 : children) {
            config.setRoot(node2);
            cfg = new HandlerConfigurationItem(node2, config);
            preCfg = null;
            command = Configuration.eventHandlerForName(cfg.getHandlerName());
            if (command == null) {
                if (cfg.getCatalogName() != null) {
                    cfg.setName(cfg.getCatalogName());
                    cfg.setClassName(EventHandlerChain.class.getName());
                } else {
                    preCfg = Configuration.eventHandlerConfigurationForName(cfg.getHandlerName());
                    if (preCfg != null) {
                        cfg.setName(preCfg.getName());
                        cfg.setHandlerName(preCfg.getHandlerName());
                        cfg.setClassName(preCfg.getClassName());
                        cfg.getSenders().addAll(preCfg.getSenders());
                        cfg.getHandleTypes().addAll(preCfg.getHandleTypes());
                        cfg.getProperties().putAll(preCfg.getProperties());
                    }
                }
                try {
                    command = (EventHandler)Configuration.getBean(cfg.getClassName());
                }
                catch (Exception e) {
                    RadiusLog.error(e.getMessage(), e);
                    continue;
                }
            }
            if (command == null) {
                RadiusLog.error("No command found for " + cfg.getClassName());
                continue;
            }
            if (preCfg != null) {
                command.setConfig(preCfg);
            }
            command.setConfig(cfg);
            if (this.eventHandlers == null) {
                this.eventHandlers = new LinkedList<JRCommand>();
            }
            this.eventHandlers.add(command);
        }
    }

    public List<JRCommand> getRequestHandlers() {
        return this.requestHandlers;
    }

    public List<JRCommand> getEventHandlers() {
        return this.eventHandlers;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public String getProcessorClassName() {
        return this.processorClassName;
    }

    @Override
    public String xmlKey() {
        return XML_KEY;
    }
}

