/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals.c14n;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public final class UtfHelpper {
    private UtfHelpper() {
    }

    public static void writeByte(String string, OutputStream outputStream, Map<String, byte[]> map) throws IOException {
        byte[] byArray = map.get(string);
        if (byArray == null) {
            byArray = UtfHelpper.getStringInUtf8(string);
            map.put(string, byArray);
        }
        outputStream.write(byArray);
    }

    public static void writeCharToUtf8(char c, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        char c2;
        if (c < '\u0080') {
            outputStream.write(c);
            return;
        }
        if (c >= '\ud800' && c <= '\udbff' || c >= '\udc00' && c <= '\udfff') {
            outputStream.write(63);
            return;
        }
        if (c > '\u07ff') {
            c2 = (char)(c >>> 12);
            n2 = 224;
            if (c2 > '\u0000') {
                n2 |= c2 & 0xF;
            }
            outputStream.write(n2);
            n2 = 128;
            n = 63;
        } else {
            n2 = 192;
            n = 31;
        }
        c2 = (char)(c >>> 6);
        if (c2 > '\u0000') {
            n2 |= c2 & n;
        }
        outputStream.write(n2);
        outputStream.write(0x80 | c & 0x3F);
    }

    public static void writeStringToUtf8(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            char c;
            char c2;
            if ((c2 = string.charAt(n2++)) < '\u0080') {
                outputStream.write(c2);
                continue;
            }
            if (c2 >= '\ud800' && c2 <= '\udbff' || c2 >= '\udc00' && c2 <= '\udfff') {
                outputStream.write(63);
                continue;
            }
            if (c2 > '\u07ff') {
                c = (char)(c2 >>> 12);
                n4 = 224;
                if (c > '\u0000') {
                    n4 |= c & 0xF;
                }
                outputStream.write(n4);
                n4 = 128;
                n3 = 63;
            } else {
                n4 = 192;
                n3 = 31;
            }
            c = (char)(c2 >>> 6);
            if (c > '\u0000') {
                n4 |= c & n3;
            }
            outputStream.write(n4);
            outputStream.write(0x80 | c2 & 0x3F);
        }
    }

    public static byte[] getStringInUtf8(String string) {
        int n = string.length();
        boolean bl = false;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4;
            int n5;
            char c;
            if ((c = string.charAt(n2++)) < '\u0080') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff' || c >= '\udc00' && c <= '\udfff') {
                byArray[n3++] = 63;
                continue;
            }
            if (!bl) {
                byte[] byArray2 = new byte[3 * n];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                byArray = byArray2;
                bl = true;
            }
            if (c > '\u07ff') {
                char c2 = (char)(c >>> 12);
                n5 = -32;
                if (c2 > '\u0000') {
                    n5 = (byte)(n5 | c2 & 0xF);
                }
                byArray[n3++] = n5;
                n5 = -128;
                n4 = 63;
            } else {
                n5 = -64;
                n4 = 31;
            }
            char c3 = (char)(c >>> 6);
            if (c3 > '\u0000') {
                n5 = (byte)(n5 | c3 & n4);
            }
            byArray[n3++] = n5;
            byArray[n3++] = (byte)(0x80 | c & 0x3F);
        }
        if (bl) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, 0, byArray3, 0, n3);
            byArray = byArray3;
        }
        return byArray;
    }
}

