/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import java.util.LinkedHashSet;
import org.jruby.RubyArray;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.execution.QueueBatch;
import org.logstash.ext.JrubyEventExtLibrary;

public final class MemoryReadBatch
implements QueueBatch {
    private final LinkedHashSet<IRubyObject> events;

    public MemoryReadBatch(LinkedHashSet<IRubyObject> events) {
        this.events = events;
    }

    public static boolean isCancelled(IRubyObject event) {
        return ((JrubyEventExtLibrary.RubyEvent)event).getEvent().isCancelled();
    }

    public static MemoryReadBatch create(LinkedHashSet<IRubyObject> events) {
        return new MemoryReadBatch(events);
    }

    public static MemoryReadBatch create() {
        return MemoryReadBatch.create(new LinkedHashSet<IRubyObject>());
    }

    @Override
    public RubyArray to_a() {
        RubyArray result = RubyUtil.RUBY.newArray(this.events.size());
        for (IRubyObject event : this.events) {
            if (MemoryReadBatch.isCancelled(event)) continue;
            result.append(event);
        }
        return result;
    }

    @Override
    public void merge(IRubyObject event) {
        this.events.add(event);
    }

    @Override
    public int filteredSize() {
        return this.events.size();
    }

    @Override
    public void close() {
    }
}

